#!/bin/bash
export MIOPEN_DEBUG_DISABLE_FIND_DB=1
export NCCL_SOCKET_IFNAME=eno1
export HSA_USERPTR_FOR_PAGED_MEM=0
export HIP_LAUNCH_BLOCKING=1
lrank=$OMPI_COMM_WORLD_LOCAL_RANK
comm_rank=$OMPI_COMM_WORLD_RANK
comm_size=$OMPI_COMM_WORLD_SIZE
export PATH_PHRASE2=/public/DL_DATA/wikicorpus_en/lower_case_1_seq_len_512_max_pred_80_masked_lm_prob_0.15_random_seed_12345_dupe_factor_5_shard_1472_test_split_10/wikicorpus_en/training
APP="python3 ${HOME}/torch/bert-pretrain/run_pretraining_v4.py  \
    --input_dir=${PATH_PHRASE2}    \
    --output_dir=${HOME}/outdir/torch/pre_wiki/phrase2 \
    --config_file=${HOME}/model/uncased_L-24_H-1024_A-16/bert_config.json \
    --bert_model=bert-large-uncased \
    --train_batch_size=2 \
    --max_seq_length=512 \
    --max_predictions_per_seq=80 \
    --max_steps=400000 \
    --warmup_proportion=0.128 \
    --num_steps_per_checkpoint=20000 \
    --learning_rate=4.0e-3 \
    --seed=12439 \
    --gradient_accumulation_steps=1 \
    --allreduce_post_accumulation \
    --gpus_per_node ${2} \
    --do_train \
    --phase2 \
    --phase1_end_step=0 \
    --local_rank ${comm_rank} \
    --world_size ${comm_size} \
    --dist_url tcp://${1}:34567 \
    --json-summary ${HOME}/outdir/torch/pre_wiki4/phrase2/dllogger.json
 "

case ${lrank} in
[0])
  export HIP_VISIBLE_DEVICES=0
  echo numactl --cpunodebind=0 --membind=0 ${APP}
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[1])
  export HIP_VISIBLE_DEVICES=1
  echo numactl --cpunodebind=0 --membind=0 ${APP}
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[2])
  export HIP_VISIBLE_DEVICES=2
  echo numactl --cpunodebind=0 --membind=0 ${APP}  
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[3])
  export HIP_VISIBLE_DEVICES=3
  echo numactl --cpunodebind=0 --membind=0 ${APP}  
  numactl --cpunodebind=0 --membind=0 ${APP}
  ;;
[4])
  export HIP_VISIBLE_DEVICES=4
  echo numactl --cpunodebind=3 --membind=3 ${APP}
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[5])
  export HIP_VISIBLE_DEVICES=5
  echo numactl --cpunodebind=3 --membind=3 ${APP}
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[6])
  export HIP_VISIBLE_DEVICES=6
  echo numactl --cpunodebind=3 --membind=3 ${APP}  
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
[7])
  export HIP_VISIBLE_DEVICES=7
  echo numactl --cpunodebind=3 --membind=3 ${APP}  
  numactl --cpunodebind=3 --membind=3 ${APP}
  ;;
esac
