// !!! This is a file automatically generated by hipify!!!
// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0

// DeepSpeed Team

#ifndef __TIMER_H__
#define __TIMER_H__

#include <hip/hip_runtime.h>
#include <chrono>
#include "hip/hip_runtime.h"

class GPUTimer {
    hipEvent_t start, stop;

public:
    GPUTimer()
    {
        hipEventCreate(&start);
        hipEventCreate(&stop);
    }
    ~GPUTimer()
    {
        hipEventDestroy(start);
        hipEventDestroy(stop);
    }
    inline void Record() { hipEventRecord(start); }
    inline void Elapsed(float& time_elapsed)
    {
        hipEventRecord(stop);
        hipEventSynchronize(stop);
        hipEventElapsedTime(&time_elapsed, start, stop);
    }
};

class CPUTimer {
    std::chrono::high_resolution_clock::time_point start;

public:
    CPUTimer() : start(std::chrono::high_resolution_clock::now()) {}
    inline void Reset() { start = std::chrono::high_resolution_clock::now(); }
    inline float Elapsed()
    {
        auto temp = start;
        start = std::chrono::high_resolution_clock::now();
        return (float)(std::chrono::duration_cast<std::chrono::microseconds>(start - temp).count() /
                       1e3);
    }
};

#endif
