// !!! This is a file automatically generated by hipify!!!
// Copyright (c) Microsoft Corporation.
// SPDX-License-Identifier: Apache-2.0

// DeepSpeed Team

#pragma once

#include <assert.h>
#include <hipblas/hipblas.h>
#include <hip/hip_runtime.h>
#include <hip/hip_fp16.h>
#include <hip/hip_runtime.h>
#ifndef __HIP_PLATFORM_AMD__
//#include <mma.h>
#endif
#ifdef __HIP_PLATFORM_AMD__
#include <rocblas/rocblas.h>
#endif
#include <stdio.h>

int cublas_gemm_ex(hipblasHandle_t handle,
                   hipblasOperation_t transa,
                   hipblasOperation_t transb,
                   int m,
                   int n,
                   int k,
                   const float* alpha,
                   const float* beta,
                   const float* A,
                   const float* B,
                   float* C,
#ifdef __HIP_PLATFORM_AMD__
                   rocblas_gemm_algo algo = rocblas_gemm_algo_standard);
#else
                   hipblasGemmAlgo_t algo = HIPBLAS_GEMM_DEFAULT);
#endif

int cublas_gemm_ex(hipblasHandle_t handle,
                   hipblasOperation_t transa,
                   hipblasOperation_t transb,
                   int m,
                   int n,
                   int k,
                   const float* alpha,
                   const float* beta,
                   const __half* A,
                   const __half* B,
                   __half* C,
#ifdef __HIP_PLATFORM_AMD__
                   rocblas_gemm_algo algo = rocblas_gemm_algo_standard);
#else
                   hipblasGemmAlgo_t algo = HIPBLAS_GEMM_DEFAULT);
#endif

int cublas_strided_batched_gemm(hipblasHandle_t handle,
                                int m,
                                int n,
                                int k,
                                const float* alpha,
                                const float* beta,
                                const float* A,
                                const float* B,
                                float* C,
                                hipblasOperation_t op_A,
                                hipblasOperation_t op_B,
                                int stride_A,
                                int stride_B,
                                int stride_C,
                                int batch,
#ifdef __HIP_PLATFORM_AMD__
                                rocblas_gemm_algo algo = rocblas_gemm_algo_standard);
#else
                                hipblasGemmAlgo_t algo = HIPBLAS_GEMM_DEFAULT);
#endif

int cublas_strided_batched_gemm(hipblasHandle_t handle,
                                int m,
                                int n,
                                int k,
                                const float* alpha,
                                const float* beta,
                                const __half* A,
                                const __half* B,
                                __half* C,
                                hipblasOperation_t op_A,
                                hipblasOperation_t op_B,
                                int stride_A,
                                int stride_B,
                                int stride_C,
                                int batch,
#ifdef __HIP_PLATFORM_AMD__
                                rocblas_gemm_algo algo = rocblas_gemm_algo_standard);
#else
                                hipblasGemmAlgo_t algo = HIPBLAS_GEMM_DEFAULT);
#endif
