


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ==============================================================================
! hipfort: FORTRAN Interfaces for GPU kernels
! ==============================================================================
! Copyright (c) 2020-2022 Advanced Micro Devices, Inc. All rights reserved.
! [MITx11 License]
! 
! Permission is hereby granted, free of charge, to any person obtaining a copy
! of this software and associated documentation files (the "Software"), to deal
! in the Software without restriction, including without limitation the rights
! to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
! copies of the Software, and to permit persons to whom the Software is
! furnished to do so, subject to the following conditions:
! 
! The above copyright notice and this permission notice shall be included in
! all copies or substantial portions of the Software.
! 
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
! IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
! FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
! AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
! LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
! OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
! THE SOFTWARE.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          
module cudafor_cusolver
  use cudafor_cusolver_enums
  implicit none

 
  
  interface cusolverCreate
    function cusolverCreate_(handle) bind(c, name="cusolverCreate")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCreate_
      type(c_ptr) :: handle
    end function

  end interface
  
  interface cusolverDestroy
    function cusolverDestroy_(handle) bind(c, name="cusolverDestroy")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDestroy_
      type(c_ptr),value :: handle
    end function

  end interface
  
  interface cusolverSetStream
    function cusolverSetStream_(handle,streamId) bind(c, &
&name="cusolverSetStream")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSetStream_
      type(c_ptr),value :: handle
      type(c_ptr),value :: streamId
    end function

  end interface
  
  interface cusolverGetStream
    function cusolverGetStream_(handle,streamId) bind(c, &
&name="cusolverGetStream")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverGetStream_
      type(c_ptr),value :: handle
      type(c_ptr) :: streamId
    end function

  end interface
  
  interface cusolverSorgbr_bufferSize
    function cusolverSorgbr_bufferSize_(handle,side,m,n,k,A,lda,tau,&
&lwork) bind(c, name="cusolverSorgbr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgbr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSorgbr_bufferSize_full_rank,&
      cusolverSorgbr_bufferSize_rank_0,&
      cusolverSorgbr_bufferSize_rank_1
  end interface
  
  interface cusolverDorgbr_bufferSize
    function cusolverDorgbr_bufferSize_(handle,side,m,n,k,A,lda,tau,&
&lwork) bind(c, name="cusolverDorgbr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgbr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDorgbr_bufferSize_full_rank,&
      cusolverDorgbr_bufferSize_rank_0,&
      cusolverDorgbr_bufferSize_rank_1
  end interface
  
  interface cusolverCungbr_bufferSize
    function cusolverCungbr_bufferSize_(handle,side,m,n,k,A,lda,tau,&
&lwork) bind(c, name="cusolverCungbr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungbr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCungbr_bufferSize_full_rank,&
      cusolverCungbr_bufferSize_rank_0,&
      cusolverCungbr_bufferSize_rank_1
  end interface
  
  interface cusolverZungbr_bufferSize
    function cusolverZungbr_bufferSize_(handle,side,m,n,k,A,lda,tau,&
&lwork) bind(c, name="cusolverZungbr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungbr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZungbr_bufferSize_full_rank,&
      cusolverZungbr_bufferSize_rank_0,&
      cusolverZungbr_bufferSize_rank_1
  end interface
  
  interface cusolverSorgbr
    function cusolverSorgbr_(handle,side,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverSorgbr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgbr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSorgbr_full_rank,&
      cusolverSorgbr_rank_0,&
      cusolverSorgbr_rank_1
  end interface
  
  interface cusolverDorgbr
    function cusolverDorgbr_(handle,side,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverDorgbr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgbr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDorgbr_full_rank,&
      cusolverDorgbr_rank_0,&
      cusolverDorgbr_rank_1
  end interface
  
  interface cusolverCungbr
    function cusolverCungbr_(handle,side,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverCungbr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungbr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCungbr_full_rank,&
      cusolverCungbr_rank_0,&
      cusolverCungbr_rank_1
  end interface
  
  interface cusolverZungbr
    function cusolverZungbr_(handle,side,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverZungbr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungbr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZungbr_full_rank,&
      cusolverZungbr_rank_0,&
      cusolverZungbr_rank_1
  end interface
  
  interface cusolverSorgqr_bufferSize
    function cusolverSorgqr_bufferSize_(handle,m,n,k,A,lda,tau,lwork) &
&bind(c, name="cusolverSorgqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgqr_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSorgqr_bufferSize_full_rank,&
      cusolverSorgqr_bufferSize_rank_0,&
      cusolverSorgqr_bufferSize_rank_1
  end interface
  
  interface cusolverDorgqr_bufferSize
    function cusolverDorgqr_bufferSize_(handle,m,n,k,A,lda,tau,lwork) &
&bind(c, name="cusolverDorgqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgqr_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDorgqr_bufferSize_full_rank,&
      cusolverDorgqr_bufferSize_rank_0,&
      cusolverDorgqr_bufferSize_rank_1
  end interface
  
  interface cusolverCungqr_bufferSize
    function cusolverCungqr_bufferSize_(handle,m,n,k,A,lda,tau,lwork) &
&bind(c, name="cusolverCungqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungqr_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCungqr_bufferSize_full_rank,&
      cusolverCungqr_bufferSize_rank_0,&
      cusolverCungqr_bufferSize_rank_1
  end interface
  
  interface cusolverZungqr_bufferSize
    function cusolverZungqr_bufferSize_(handle,m,n,k,A,lda,tau,lwork) &
&bind(c, name="cusolverZungqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungqr_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZungqr_bufferSize_full_rank,&
      cusolverZungqr_bufferSize_rank_0,&
      cusolverZungqr_bufferSize_rank_1
  end interface
  
  interface cusolverSorgqr
    function cusolverSorgqr_(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverSorgqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgqr_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSorgqr_full_rank,&
      cusolverSorgqr_rank_0,&
      cusolverSorgqr_rank_1
  end interface
  
  interface cusolverDorgqr
    function cusolverDorgqr_(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverDorgqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgqr_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDorgqr_full_rank,&
      cusolverDorgqr_rank_0,&
      cusolverDorgqr_rank_1
  end interface
  
  interface cusolverCungqr
    function cusolverCungqr_(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverCungqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungqr_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCungqr_full_rank,&
      cusolverCungqr_rank_0,&
      cusolverCungqr_rank_1
  end interface
  
  interface cusolverZungqr
    function cusolverZungqr_(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverZungqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungqr_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZungqr_full_rank,&
      cusolverZungqr_rank_0,&
      cusolverZungqr_rank_1
  end interface
  
  interface cusolverSorgtr_bufferSize
    function cusolverSorgtr_bufferSize_(handle,uplo,n,A,lda,tau,lwork) &
&bind(c, name="cusolverSorgtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSorgtr_bufferSize_full_rank,&
      cusolverSorgtr_bufferSize_rank_0,&
      cusolverSorgtr_bufferSize_rank_1
  end interface
  
  interface cusolverDorgtr_bufferSize
    function cusolverDorgtr_bufferSize_(handle,uplo,n,A,lda,tau,lwork) &
&bind(c, name="cusolverDorgtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDorgtr_bufferSize_full_rank,&
      cusolverDorgtr_bufferSize_rank_0,&
      cusolverDorgtr_bufferSize_rank_1
  end interface
  
  interface cusolverCungtr_bufferSize
    function cusolverCungtr_bufferSize_(handle,uplo,n,A,lda,tau,lwork) &
&bind(c, name="cusolverCungtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCungtr_bufferSize_full_rank,&
      cusolverCungtr_bufferSize_rank_0,&
      cusolverCungtr_bufferSize_rank_1
  end interface
  
  interface cusolverZungtr_bufferSize
    function cusolverZungtr_bufferSize_(handle,uplo,n,A,lda,tau,lwork) &
&bind(c, name="cusolverZungtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZungtr_bufferSize_full_rank,&
      cusolverZungtr_bufferSize_rank_0,&
      cusolverZungtr_bufferSize_rank_1
  end interface
  
  interface cusolverSorgtr
    function cusolverSorgtr_(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverSorgtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSorgtr_full_rank,&
      cusolverSorgtr_rank_0,&
      cusolverSorgtr_rank_1
  end interface
  
  interface cusolverDorgtr
    function cusolverDorgtr_(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverDorgtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDorgtr_full_rank,&
      cusolverDorgtr_rank_0,&
      cusolverDorgtr_rank_1
  end interface
  
  interface cusolverCungtr
    function cusolverCungtr_(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverCungtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCungtr_full_rank,&
      cusolverCungtr_rank_0,&
      cusolverCungtr_rank_1
  end interface
  
  interface cusolverZungtr
    function cusolverZungtr_(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo) bind(c, name="cusolverZungtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZungtr_full_rank,&
      cusolverZungtr_rank_0,&
      cusolverZungtr_rank_1
  end interface
  
  interface cusolverSormqr_bufferSize
    function cusolverSormqr_bufferSize_(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,lwork) bind(c, name="cusolverSormqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormqr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSormqr_bufferSize_full_rank,&
      cusolverSormqr_bufferSize_rank_0,&
      cusolverSormqr_bufferSize_rank_1
  end interface
  
  interface cusolverDormqr_bufferSize
    function cusolverDormqr_bufferSize_(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,lwork) bind(c, name="cusolverDormqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormqr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDormqr_bufferSize_full_rank,&
      cusolverDormqr_bufferSize_rank_0,&
      cusolverDormqr_bufferSize_rank_1
  end interface
  
  interface cusolverCunmqr_bufferSize
    function cusolverCunmqr_bufferSize_(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,lwork) bind(c, name="cusolverCunmqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmqr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCunmqr_bufferSize_full_rank,&
      cusolverCunmqr_bufferSize_rank_0,&
      cusolverCunmqr_bufferSize_rank_1
  end interface
  
  interface cusolverZunmqr_bufferSize
    function cusolverZunmqr_bufferSize_(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,lwork) bind(c, name="cusolverZunmqr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmqr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZunmqr_bufferSize_full_rank,&
      cusolverZunmqr_bufferSize_rank_0,&
      cusolverZunmqr_bufferSize_rank_1
  end interface
  
  interface cusolverSormqr
    function cusolverSormqr_(handle,side,trans,m,n,k,A,lda,tau,C,ldc,&
&work,lwork,devInfo) bind(c, name="cusolverSormqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormqr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSormqr_full_rank,&
      cusolverSormqr_rank_0,&
      cusolverSormqr_rank_1
  end interface
  
  interface cusolverDormqr
    function cusolverDormqr_(handle,side,trans,m,n,k,A,lda,tau,C,ldc,&
&work,lwork,devInfo) bind(c, name="cusolverDormqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormqr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDormqr_full_rank,&
      cusolverDormqr_rank_0,&
      cusolverDormqr_rank_1
  end interface
  
  interface cusolverCunmqr
    function cusolverCunmqr_(handle,side,trans,m,n,k,A,lda,tau,C,ldc,&
&work,lwork,devInfo) bind(c, name="cusolverCunmqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmqr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCunmqr_full_rank,&
      cusolverCunmqr_rank_0,&
      cusolverCunmqr_rank_1
  end interface
  
  interface cusolverZunmqr
    function cusolverZunmqr_(handle,side,trans,m,n,k,A,lda,tau,C,ldc,&
&work,lwork,devInfo) bind(c, name="cusolverZunmqr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmqr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int),value :: k
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZunmqr_full_rank,&
      cusolverZunmqr_rank_0,&
      cusolverZunmqr_rank_1
  end interface
  
  interface cusolverSormtr_bufferSize
    function cusolverSormtr_bufferSize_(handle,side,uplo,trans,m,n,A,&
&lda,tau,C,ldc,lwork) bind(c, name="cusolverSormtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSormtr_bufferSize_full_rank,&
      cusolverSormtr_bufferSize_rank_0,&
      cusolverSormtr_bufferSize_rank_1
  end interface
  
  interface cusolverDormtr_bufferSize
    function cusolverDormtr_bufferSize_(handle,side,uplo,trans,m,n,A,&
&lda,tau,C,ldc,lwork) bind(c, name="cusolverDormtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDormtr_bufferSize_full_rank,&
      cusolverDormtr_bufferSize_rank_0,&
      cusolverDormtr_bufferSize_rank_1
  end interface
  
  interface cusolverCunmtr_bufferSize
    function cusolverCunmtr_bufferSize_(handle,side,uplo,trans,m,n,A,&
&lda,tau,C,ldc,lwork) bind(c, name="cusolverCunmtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCunmtr_bufferSize_full_rank,&
      cusolverCunmtr_bufferSize_rank_0,&
      cusolverCunmtr_bufferSize_rank_1
  end interface
  
  interface cusolverZunmtr_bufferSize
    function cusolverZunmtr_bufferSize_(handle,side,uplo,trans,m,n,A,&
&lda,tau,C,ldc,lwork) bind(c, name="cusolverZunmtr_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmtr_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZunmtr_bufferSize_full_rank,&
      cusolverZunmtr_bufferSize_rank_0,&
      cusolverZunmtr_bufferSize_rank_1
  end interface
  
  interface cusolverSormtr
    function cusolverSormtr_(handle,side,uplo,trans,m,n,A,lda,tau,C,&
&ldc,work,lwork,devInfo) bind(c, name="cusolverSormtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSormtr_full_rank,&
      cusolverSormtr_rank_0,&
      cusolverSormtr_rank_1
  end interface
  
  interface cusolverDormtr
    function cusolverDormtr_(handle,side,uplo,trans,m,n,A,lda,tau,C,&
&ldc,work,lwork,devInfo) bind(c, name="cusolverDormtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDormtr_full_rank,&
      cusolverDormtr_rank_0,&
      cusolverDormtr_rank_1
  end interface
  
  interface cusolverCunmtr
    function cusolverCunmtr_(handle,side,uplo,trans,m,n,A,lda,tau,C,&
&ldc,work,lwork,devInfo) bind(c, name="cusolverCunmtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCunmtr_full_rank,&
      cusolverCunmtr_rank_0,&
      cusolverCunmtr_rank_1
  end interface
  
  interface cusolverZunmtr
    function cusolverZunmtr_(handle,side,uplo,trans,m,n,A,lda,tau,C,&
&ldc,work,lwork,devInfo) bind(c, name="cusolverZunmtr")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmtr_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)),value :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: C
      integer(c_int),value :: ldc
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZunmtr_full_rank,&
      cusolverZunmtr_rank_0,&
      cusolverZunmtr_rank_1
  end interface
  
  interface cusolverSgebrd_bufferSize
    function cusolverSgebrd_bufferSize_(handle,m,n,lwork) bind(c, &
&name="cusolverSgebrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgebrd_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int) :: lwork
    end function

  end interface
  
  interface cusolverDgebrd_bufferSize
    function cusolverDgebrd_bufferSize_(handle,m,n,lwork) bind(c, &
&name="cusolverDgebrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgebrd_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int) :: lwork
    end function

  end interface
  
  interface cusolverCgebrd_bufferSize
    function cusolverCgebrd_bufferSize_(handle,m,n,lwork) bind(c, &
&name="cusolverCgebrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgebrd_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int) :: lwork
    end function

  end interface
  
  interface cusolverZgebrd_bufferSize
    function cusolverZgebrd_bufferSize_(handle,m,n,lwork) bind(c, &
&name="cusolverZgebrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgebrd_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      integer(c_int) :: lwork
    end function

  end interface
  
  interface cusolverSgebrd
    function cusolverSgebrd_(handle,m,n,A,lda,D,E,tauq,taup,work,lwork,&
&devInfo) bind(c, name="cusolverSgebrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgebrd_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      type(c_ptr),value :: tauq
      type(c_ptr),value :: taup
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSgebrd_full_rank,&
      cusolverSgebrd_rank_0,&
      cusolverSgebrd_rank_1
  end interface
  
  interface cusolverDgebrd
    function cusolverDgebrd_(handle,m,n,A,lda,D,E,tauq,taup,work,lwork,&
&devInfo) bind(c, name="cusolverDgebrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgebrd_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      type(c_ptr),value :: tauq
      type(c_ptr),value :: taup
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDgebrd_full_rank,&
      cusolverDgebrd_rank_0,&
      cusolverDgebrd_rank_1
  end interface
  
  interface cusolverCgebrd
    function cusolverCgebrd_(handle,m,n,A,lda,D,E,tauq,taup,work,lwork,&
&devInfo) bind(c, name="cusolverCgebrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgebrd_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      type(c_ptr),value :: tauq
      type(c_ptr),value :: taup
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCgebrd_full_rank,&
      cusolverCgebrd_rank_0,&
      cusolverCgebrd_rank_1
  end interface
  
  interface cusolverZgebrd
    function cusolverZgebrd_(handle,m,n,A,lda,D,E,tauq,taup,work,lwork,&
&devInfo) bind(c, name="cusolverZgebrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgebrd_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      type(c_ptr),value :: tauq
      type(c_ptr),value :: taup
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZgebrd_full_rank,&
      cusolverZgebrd_rank_0,&
      cusolverZgebrd_rank_1
  end interface
  
  interface cusolverSgeqrf_bufferSize
    function cusolverSgeqrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverSgeqrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgeqrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSgeqrf_bufferSize_full_rank,&
      cusolverSgeqrf_bufferSize_rank_0,&
      cusolverSgeqrf_bufferSize_rank_1
  end interface
  
  interface cusolverDgeqrf_bufferSize
    function cusolverDgeqrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverDgeqrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgeqrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDgeqrf_bufferSize_full_rank,&
      cusolverDgeqrf_bufferSize_rank_0,&
      cusolverDgeqrf_bufferSize_rank_1
  end interface
  
  interface cusolverCgeqrf_bufferSize
    function cusolverCgeqrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverCgeqrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgeqrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCgeqrf_bufferSize_full_rank,&
      cusolverCgeqrf_bufferSize_rank_0,&
      cusolverCgeqrf_bufferSize_rank_1
  end interface
  
  interface cusolverZgeqrf_bufferSize
    function cusolverZgeqrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverZgeqrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgeqrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZgeqrf_bufferSize_full_rank,&
      cusolverZgeqrf_bufferSize_rank_0,&
      cusolverZgeqrf_bufferSize_rank_1
  end interface
  
  interface cusolverSgeqrf
    function cusolverSgeqrf_(handle,m,n,A,lda,tau,work,lwork,devInfo) &
&bind(c, name="cusolverSgeqrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgeqrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_float) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSgeqrf_full_rank,&
      cusolverSgeqrf_rank_0,&
      cusolverSgeqrf_rank_1
  end interface
  
  interface cusolverDgeqrf
    function cusolverDgeqrf_(handle,m,n,A,lda,tau,work,lwork,devInfo) &
&bind(c, name="cusolverDgeqrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgeqrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      real(c_double) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDgeqrf_full_rank,&
      cusolverDgeqrf_rank_0,&
      cusolverDgeqrf_rank_1
  end interface
  
  interface cusolverCgeqrf
    function cusolverCgeqrf_(handle,m,n,A,lda,tau,work,lwork,devInfo) &
&bind(c, name="cusolverCgeqrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgeqrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_float_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCgeqrf_full_rank,&
      cusolverCgeqrf_rank_0,&
      cusolverCgeqrf_rank_1
  end interface
  
  interface cusolverZgeqrf
    function cusolverZgeqrf_(handle,m,n,A,lda,tau,work,lwork,devInfo) &
&bind(c, name="cusolverZgeqrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgeqrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      complex(c_double_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZgeqrf_full_rank,&
      cusolverZgeqrf_rank_0,&
      cusolverZgeqrf_rank_1
  end interface
  
  interface cusolverSSgesv_bufferSize
    function cusolverSSgesv_bufferSize_(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,lwork) bind(c, name="cusolverSSgesv_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSSgesv_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      integer(c_size_t) :: lwork
    end function

    module procedure &
      cusolverSSgesv_bufferSize_full_rank,&
      cusolverSSgesv_bufferSize_rank_0,&
      cusolverSSgesv_bufferSize_rank_1
  end interface
  
  interface cusolverDDgesv_bufferSize
    function cusolverDDgesv_bufferSize_(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,lwork) bind(c, name="cusolverDDgesv_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDDgesv_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      integer(c_size_t) :: lwork
    end function

    module procedure &
      cusolverDDgesv_bufferSize_full_rank,&
      cusolverDDgesv_bufferSize_rank_0,&
      cusolverDDgesv_bufferSize_rank_1
  end interface
  
  interface cusolverCCgesv_bufferSize
    function cusolverCCgesv_bufferSize_(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,lwork) bind(c, name="cusolverCCgesv_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCCgesv_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      integer(c_size_t) :: lwork
    end function

    module procedure &
      cusolverCCgesv_bufferSize_full_rank,&
      cusolverCCgesv_bufferSize_rank_0,&
      cusolverCCgesv_bufferSize_rank_1
  end interface
  
  interface cusolverZZgesv_bufferSize
    function cusolverZZgesv_bufferSize_(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,lwork) bind(c, name="cusolverZZgesv_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZZgesv_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      integer(c_size_t) :: lwork
    end function

    module procedure &
      cusolverZZgesv_bufferSize_full_rank,&
      cusolverZZgesv_bufferSize_rank_0,&
      cusolverZZgesv_bufferSize_rank_1
  end interface
  
  interface cusolverSSgesv
    function cusolverSSgesv_(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,ldx,&
&work,lwork,niters,devInfo) bind(c, name="cusolverSSgesv")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSSgesv_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      type(c_ptr),value :: work
      integer(c_size_t),value :: lwork
      type(c_ptr),value :: niters
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSSgesv_full_rank,&
      cusolverSSgesv_rank_0,&
      cusolverSSgesv_rank_1
  end interface
  
  interface cusolverDDgesv
    function cusolverDDgesv_(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,ldx,&
&work,lwork,niters,devInfo) bind(c, name="cusolverDDgesv")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDDgesv_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      type(c_ptr),value :: work
      integer(c_size_t),value :: lwork
      type(c_ptr),value :: niters
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDDgesv_full_rank,&
      cusolverDDgesv_rank_0,&
      cusolverDDgesv_rank_1
  end interface
  
  interface cusolverCCgesv
    function cusolverCCgesv_(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,ldx,&
&work,lwork,niters,devInfo) bind(c, name="cusolverCCgesv")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCCgesv_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      type(c_ptr),value :: work
      integer(c_size_t),value :: lwork
      type(c_ptr),value :: niters
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCCgesv_full_rank,&
      cusolverCCgesv_rank_0,&
      cusolverCCgesv_rank_1
  end interface
  
  interface cusolverZZgesv
    function cusolverZZgesv_(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,ldx,&
&work,lwork,niters,devInfo) bind(c, name="cusolverZZgesv")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZZgesv_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: X
      integer(c_int),value :: ldx
      type(c_ptr),value :: work
      integer(c_size_t),value :: lwork
      type(c_ptr),value :: niters
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZZgesv_full_rank,&
      cusolverZZgesv_rank_0,&
      cusolverZZgesv_rank_1
  end interface
  
  interface cusolverSgetrf_bufferSize
    function cusolverSgetrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverSgetrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSgetrf_bufferSize_full_rank,&
      cusolverSgetrf_bufferSize_rank_0,&
      cusolverSgetrf_bufferSize_rank_1
  end interface
  
  interface cusolverDgetrf_bufferSize
    function cusolverDgetrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverDgetrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDgetrf_bufferSize_full_rank,&
      cusolverDgetrf_bufferSize_rank_0,&
      cusolverDgetrf_bufferSize_rank_1
  end interface
  
  interface cusolverCgetrf_bufferSize
    function cusolverCgetrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverCgetrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCgetrf_bufferSize_full_rank,&
      cusolverCgetrf_bufferSize_rank_0,&
      cusolverCgetrf_bufferSize_rank_1
  end interface
  
  interface cusolverZgetrf_bufferSize
    function cusolverZgetrf_bufferSize_(handle,m,n,A,lda,lwork) bind(c,&
& name="cusolverZgetrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZgetrf_bufferSize_full_rank,&
      cusolverZgetrf_bufferSize_rank_0,&
      cusolverZgetrf_bufferSize_rank_1
  end interface
  
  interface cusolverSgetrf
    function cusolverSgetrf_(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo) bind(c, name="cusolverSgetrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      type(c_ptr),value :: devIpiv
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSgetrf_full_rank,&
      cusolverSgetrf_rank_0,&
      cusolverSgetrf_rank_1
  end interface
  
  interface cusolverDgetrf
    function cusolverDgetrf_(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo) bind(c, name="cusolverDgetrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      type(c_ptr),value :: devIpiv
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDgetrf_full_rank,&
      cusolverDgetrf_rank_0,&
      cusolverDgetrf_rank_1
  end interface
  
  interface cusolverCgetrf
    function cusolverCgetrf_(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo) bind(c, name="cusolverCgetrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      type(c_ptr),value :: devIpiv
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCgetrf_full_rank,&
      cusolverCgetrf_rank_0,&
      cusolverCgetrf_rank_1
  end interface
  
  interface cusolverZgetrf
    function cusolverZgetrf_(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo) bind(c, name="cusolverZgetrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrf_
      type(c_ptr),value :: handle
      integer(c_int),value :: m
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      type(c_ptr),value :: devIpiv
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZgetrf_full_rank,&
      cusolverZgetrf_rank_0,&
      cusolverZgetrf_rank_1
  end interface
  
  interface cusolverSgetrs_bufferSize
    function cusolverSgetrs_bufferSize_(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,lwork) bind(c, name="cusolverSgetrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSgetrs_bufferSize_full_rank,&
      cusolverSgetrs_bufferSize_rank_0,&
      cusolverSgetrs_bufferSize_rank_1
  end interface
  
  interface cusolverDgetrs_bufferSize
    function cusolverDgetrs_bufferSize_(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,lwork) bind(c, name="cusolverDgetrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDgetrs_bufferSize_full_rank,&
      cusolverDgetrs_bufferSize_rank_0,&
      cusolverDgetrs_bufferSize_rank_1
  end interface
  
  interface cusolverCgetrs_bufferSize
    function cusolverCgetrs_bufferSize_(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,lwork) bind(c, name="cusolverCgetrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCgetrs_bufferSize_full_rank,&
      cusolverCgetrs_bufferSize_rank_0,&
      cusolverCgetrs_bufferSize_rank_1
  end interface
  
  interface cusolverZgetrs_bufferSize
    function cusolverZgetrs_bufferSize_(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,lwork) bind(c, name="cusolverZgetrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZgetrs_bufferSize_full_rank,&
      cusolverZgetrs_bufferSize_rank_0,&
      cusolverZgetrs_bufferSize_rank_1
  end interface
  
  interface cusolverSgetrs
    function cusolverSgetrs_(handle,trans,n,nrhs,A,lda,devIpiv,B,ldb,&
&work,lwork,devInfo) bind(c, name="cusolverSgetrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSgetrs_full_rank,&
      cusolverSgetrs_rank_0,&
      cusolverSgetrs_rank_1
  end interface
  
  interface cusolverDgetrs
    function cusolverDgetrs_(handle,trans,n,nrhs,A,lda,devIpiv,B,ldb,&
&work,lwork,devInfo) bind(c, name="cusolverDgetrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDgetrs_full_rank,&
      cusolverDgetrs_rank_0,&
      cusolverDgetrs_rank_1
  end interface
  
  interface cusolverCgetrs
    function cusolverCgetrs_(handle,trans,n,nrhs,A,lda,devIpiv,B,ldb,&
&work,lwork,devInfo) bind(c, name="cusolverCgetrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCgetrs_full_rank,&
      cusolverCgetrs_rank_0,&
      cusolverCgetrs_rank_1
  end interface
  
  interface cusolverZgetrs
    function cusolverZgetrs_(handle,trans,n,nrhs,A,lda,devIpiv,B,ldb,&
&work,lwork,devInfo) bind(c, name="cusolverZgetrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_OP_N)),value :: trans
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: devIpiv
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZgetrs_full_rank,&
      cusolverZgetrs_rank_0,&
      cusolverZgetrs_rank_1
  end interface
  
  interface cusolverSpotrf_bufferSize
    function cusolverSpotrf_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverSpotrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrf_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSpotrf_bufferSize_full_rank,&
      cusolverSpotrf_bufferSize_rank_0,&
      cusolverSpotrf_bufferSize_rank_1
  end interface
  
  interface cusolverDpotrf_bufferSize
    function cusolverDpotrf_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverDpotrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrf_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDpotrf_bufferSize_full_rank,&
      cusolverDpotrf_bufferSize_rank_0,&
      cusolverDpotrf_bufferSize_rank_1
  end interface
  
  interface cusolverCpotrf_bufferSize
    function cusolverCpotrf_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverCpotrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrf_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCpotrf_bufferSize_full_rank,&
      cusolverCpotrf_bufferSize_rank_0,&
      cusolverCpotrf_bufferSize_rank_1
  end interface
  
  interface cusolverZpotrf_bufferSize
    function cusolverZpotrf_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverZpotrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrf_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZpotrf_bufferSize_full_rank,&
      cusolverZpotrf_bufferSize_rank_0,&
      cusolverZpotrf_bufferSize_rank_1
  end interface
  
  interface cusolverSpotrf
    function cusolverSpotrf_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverSpotrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSpotrf_full_rank,&
      cusolverSpotrf_rank_0,&
      cusolverSpotrf_rank_1
  end interface
  
  interface cusolverDpotrf
    function cusolverDpotrf_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverDpotrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDpotrf_full_rank,&
      cusolverDpotrf_rank_0,&
      cusolverDpotrf_rank_1
  end interface
  
  interface cusolverCpotrf
    function cusolverCpotrf_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverCpotrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCpotrf_full_rank,&
      cusolverCpotrf_rank_0,&
      cusolverCpotrf_rank_1
  end interface
  
  interface cusolverZpotrf
    function cusolverZpotrf_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverZpotrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZpotrf_full_rank,&
      cusolverZpotrf_rank_0,&
      cusolverZpotrf_rank_1
  end interface
  
  interface cusolverSpotrfBatched_bufferSize
    function cusolverSpotrfBatched_bufferSize_(handle,uplo,n,A,lda,&
&lwork,batch_count) bind(c, name="cusolverSpotrfBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverSpotrfBatched_bufferSize_full_rank,&
      cusolverSpotrfBatched_bufferSize_rank_0,&
      cusolverSpotrfBatched_bufferSize_rank_1
  end interface
  
  interface cusolverDpotrfBatched_bufferSize
    function cusolverDpotrfBatched_bufferSize_(handle,uplo,n,A,lda,&
&lwork,batch_count) bind(c, name="cusolverDpotrfBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverDpotrfBatched_bufferSize_full_rank,&
      cusolverDpotrfBatched_bufferSize_rank_0,&
      cusolverDpotrfBatched_bufferSize_rank_1
  end interface
  
  interface cusolverCpotrfBatched_bufferSize
    function cusolverCpotrfBatched_bufferSize_(handle,uplo,n,A,lda,&
&lwork,batch_count) bind(c, name="cusolverCpotrfBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverCpotrfBatched_bufferSize_full_rank,&
      cusolverCpotrfBatched_bufferSize_rank_0,&
      cusolverCpotrfBatched_bufferSize_rank_1
  end interface
  
  interface cusolverZpotrfBatched_bufferSize
    function cusolverZpotrfBatched_bufferSize_(handle,uplo,n,A,lda,&
&lwork,batch_count) bind(c, name="cusolverZpotrfBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverZpotrfBatched_bufferSize_full_rank,&
      cusolverZpotrfBatched_bufferSize_rank_0,&
      cusolverZpotrfBatched_bufferSize_rank_1
  end interface
  
  interface cusolverSpotrfBatched
    function cusolverSpotrfBatched_(handle,uplo,n,A,lda,work,lwork,&
&devInfo,batch_count) bind(c, name="cusolverSpotrfBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrfBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverSpotrfBatched_full_rank,&
      cusolverSpotrfBatched_rank_0,&
      cusolverSpotrfBatched_rank_1
  end interface
  
  interface cusolverDpotrfBatched
    function cusolverDpotrfBatched_(handle,uplo,n,A,lda,work,lwork,&
&devInfo,batch_count) bind(c, name="cusolverDpotrfBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrfBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverDpotrfBatched_full_rank,&
      cusolverDpotrfBatched_rank_0,&
      cusolverDpotrfBatched_rank_1
  end interface
  
  interface cusolverCpotrfBatched
    function cusolverCpotrfBatched_(handle,uplo,n,A,lda,work,lwork,&
&devInfo,batch_count) bind(c, name="cusolverCpotrfBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrfBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverCpotrfBatched_full_rank,&
      cusolverCpotrfBatched_rank_0,&
      cusolverCpotrfBatched_rank_1
  end interface
  
  interface cusolverZpotrfBatched
    function cusolverZpotrfBatched_(handle,uplo,n,A,lda,work,lwork,&
&devInfo,batch_count) bind(c, name="cusolverZpotrfBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrfBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverZpotrfBatched_full_rank,&
      cusolverZpotrfBatched_rank_0,&
      cusolverZpotrfBatched_rank_1
  end interface
  
  interface cusolverSpotri_bufferSize
    function cusolverSpotri_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverSpotri_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotri_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSpotri_bufferSize_full_rank,&
      cusolverSpotri_bufferSize_rank_0,&
      cusolverSpotri_bufferSize_rank_1
  end interface
  
  interface cusolverDpotri_bufferSize
    function cusolverDpotri_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverDpotri_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotri_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDpotri_bufferSize_full_rank,&
      cusolverDpotri_bufferSize_rank_0,&
      cusolverDpotri_bufferSize_rank_1
  end interface
  
  interface cusolverCpotri_bufferSize
    function cusolverCpotri_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverCpotri_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotri_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCpotri_bufferSize_full_rank,&
      cusolverCpotri_bufferSize_rank_0,&
      cusolverCpotri_bufferSize_rank_1
  end interface
  
  interface cusolverZpotri_bufferSize
    function cusolverZpotri_bufferSize_(handle,uplo,n,A,lda,lwork) &
&bind(c, name="cusolverZpotri_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotri_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZpotri_bufferSize_full_rank,&
      cusolverZpotri_bufferSize_rank_0,&
      cusolverZpotri_bufferSize_rank_1
  end interface
  
  interface cusolverSpotri
    function cusolverSpotri_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverSpotri")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotri_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSpotri_full_rank,&
      cusolverSpotri_rank_0,&
      cusolverSpotri_rank_1
  end interface
  
  interface cusolverDpotri
    function cusolverDpotri_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverDpotri")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotri_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDpotri_full_rank,&
      cusolverDpotri_rank_0,&
      cusolverDpotri_rank_1
  end interface
  
  interface cusolverCpotri
    function cusolverCpotri_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverCpotri")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotri_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCpotri_full_rank,&
      cusolverCpotri_rank_0,&
      cusolverCpotri_rank_1
  end interface
  
  interface cusolverZpotri
    function cusolverZpotri_(handle,uplo,n,A,lda,work,lwork,devInfo) &
&bind(c, name="cusolverZpotri")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotri_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZpotri_full_rank,&
      cusolverZpotri_rank_0,&
      cusolverZpotri_rank_1
  end interface
  
  interface cusolverSpotrs_bufferSize
    function cusolverSpotrs_bufferSize_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&lwork) bind(c, name="cusolverSpotrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSpotrs_bufferSize_full_rank,&
      cusolverSpotrs_bufferSize_rank_0,&
      cusolverSpotrs_bufferSize_rank_1
  end interface
  
  interface cusolverDpotrs_bufferSize
    function cusolverDpotrs_bufferSize_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&lwork) bind(c, name="cusolverDpotrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDpotrs_bufferSize_full_rank,&
      cusolverDpotrs_bufferSize_rank_0,&
      cusolverDpotrs_bufferSize_rank_1
  end interface
  
  interface cusolverCpotrs_bufferSize
    function cusolverCpotrs_bufferSize_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&lwork) bind(c, name="cusolverCpotrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCpotrs_bufferSize_full_rank,&
      cusolverCpotrs_bufferSize_rank_0,&
      cusolverCpotrs_bufferSize_rank_1
  end interface
  
  interface cusolverZpotrs_bufferSize
    function cusolverZpotrs_bufferSize_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&lwork) bind(c, name="cusolverZpotrs_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrs_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZpotrs_bufferSize_full_rank,&
      cusolverZpotrs_bufferSize_rank_0,&
      cusolverZpotrs_bufferSize_rank_1
  end interface
  
  interface cusolverSpotrs
    function cusolverSpotrs_(handle,uplo,n,nrhs,A,lda,B,ldb,work,lwork,&
&devInfo) bind(c, name="cusolverSpotrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSpotrs_full_rank,&
      cusolverSpotrs_rank_0,&
      cusolverSpotrs_rank_1
  end interface
  
  interface cusolverDpotrs
    function cusolverDpotrs_(handle,uplo,n,nrhs,A,lda,B,ldb,work,lwork,&
&devInfo) bind(c, name="cusolverDpotrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDpotrs_full_rank,&
      cusolverDpotrs_rank_0,&
      cusolverDpotrs_rank_1
  end interface
  
  interface cusolverCpotrs
    function cusolverCpotrs_(handle,uplo,n,nrhs,A,lda,B,ldb,work,lwork,&
&devInfo) bind(c, name="cusolverCpotrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCpotrs_full_rank,&
      cusolverCpotrs_rank_0,&
      cusolverCpotrs_rank_1
  end interface
  
  interface cusolverZpotrs
    function cusolverZpotrs_(handle,uplo,n,nrhs,A,lda,B,ldb,work,lwork,&
&devInfo) bind(c, name="cusolverZpotrs")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrs_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZpotrs_full_rank,&
      cusolverZpotrs_rank_0,&
      cusolverZpotrs_rank_1
  end interface
  
  interface cusolverSpotrsBatched_bufferSize
    function cusolverSpotrsBatched_bufferSize_(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork,batch_count) bind(c, &
&name="cusolverSpotrsBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverSpotrsBatched_bufferSize_full_rank,&
      cusolverSpotrsBatched_bufferSize_rank_0,&
      cusolverSpotrsBatched_bufferSize_rank_1
  end interface
  
  interface cusolverDpotrsBatched_bufferSize
    function cusolverDpotrsBatched_bufferSize_(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork,batch_count) bind(c, &
&name="cusolverDpotrsBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverDpotrsBatched_bufferSize_full_rank,&
      cusolverDpotrsBatched_bufferSize_rank_0,&
      cusolverDpotrsBatched_bufferSize_rank_1
  end interface
  
  interface cusolverCpotrsBatched_bufferSize
    function cusolverCpotrsBatched_bufferSize_(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork,batch_count) bind(c, &
&name="cusolverCpotrsBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverCpotrsBatched_bufferSize_full_rank,&
      cusolverCpotrsBatched_bufferSize_rank_0,&
      cusolverCpotrsBatched_bufferSize_rank_1
  end interface
  
  interface cusolverZpotrsBatched_bufferSize
    function cusolverZpotrsBatched_bufferSize_(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork,batch_count) bind(c, &
&name="cusolverZpotrsBatched_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      integer(c_int) :: lwork
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverZpotrsBatched_bufferSize_full_rank,&
      cusolverZpotrsBatched_bufferSize_rank_0,&
      cusolverZpotrsBatched_bufferSize_rank_1
  end interface
  
  interface cusolverSpotrsBatched
    function cusolverSpotrsBatched_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo,batch_count) bind(c, name="cusolverSpotrsBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrsBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverSpotrsBatched_full_rank,&
      cusolverSpotrsBatched_rank_0,&
      cusolverSpotrsBatched_rank_1
  end interface
  
  interface cusolverDpotrsBatched
    function cusolverDpotrsBatched_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo,batch_count) bind(c, name="cusolverDpotrsBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrsBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverDpotrsBatched_full_rank,&
      cusolverDpotrsBatched_rank_0,&
      cusolverDpotrsBatched_rank_1
  end interface
  
  interface cusolverCpotrsBatched
    function cusolverCpotrsBatched_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo,batch_count) bind(c, name="cusolverCpotrsBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrsBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverCpotrsBatched_full_rank,&
      cusolverCpotrsBatched_rank_0,&
      cusolverCpotrsBatched_rank_1
  end interface
  
  interface cusolverZpotrsBatched
    function cusolverZpotrsBatched_(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo,batch_count) bind(c, name="cusolverZpotrsBatched")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrsBatched_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      integer(c_int),value :: nrhs
      type(c_ptr) :: A
      integer(c_int),value :: lda
      type(c_ptr) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
      integer(c_int),value :: batch_count
    end function

    module procedure &
      cusolverZpotrsBatched_full_rank,&
      cusolverZpotrsBatched_rank_0,&
      cusolverZpotrsBatched_rank_1
  end interface
  
  interface cusolverSsyevd_bufferSize
    function cusolverSsyevd_bufferSize_(handle,jobz,uplo,n,A,lda,D,&
&lwork) bind(c, name="cusolverSsyevd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsyevd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSsyevd_bufferSize_full_rank,&
      cusolverSsyevd_bufferSize_rank_0,&
      cusolverSsyevd_bufferSize_rank_1
  end interface
  
  interface cusolverDsyevd_bufferSize
    function cusolverDsyevd_bufferSize_(handle,jobz,uplo,n,A,lda,D,&
&lwork) bind(c, name="cusolverDsyevd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsyevd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDsyevd_bufferSize_full_rank,&
      cusolverDsyevd_bufferSize_rank_0,&
      cusolverDsyevd_bufferSize_rank_1
  end interface
  
  interface cusolverCheevd_bufferSize
    function cusolverCheevd_bufferSize_(handle,jobz,uplo,n,A,lda,D,&
&lwork) bind(c, name="cusolverCheevd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCheevd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCheevd_bufferSize_full_rank,&
      cusolverCheevd_bufferSize_rank_0,&
      cusolverCheevd_bufferSize_rank_1
  end interface
  
  interface cusolverZheevd_bufferSize
    function cusolverZheevd_bufferSize_(handle,jobz,uplo,n,A,lda,D,&
&lwork) bind(c, name="cusolverZheevd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZheevd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZheevd_bufferSize_full_rank,&
      cusolverZheevd_bufferSize_rank_0,&
      cusolverZheevd_bufferSize_rank_1
  end interface
  
  interface cusolverSsyevd
    function cusolverSsyevd_(handle,jobz,uplo,n,A,lda,D,work,lwork,&
&devInfo) bind(c, name="cusolverSsyevd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsyevd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSsyevd_full_rank,&
      cusolverSsyevd_rank_0,&
      cusolverSsyevd_rank_1
  end interface
  
  interface cusolverDsyevd
    function cusolverDsyevd_(handle,jobz,uplo,n,A,lda,D,work,lwork,&
&devInfo) bind(c, name="cusolverDsyevd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsyevd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDsyevd_full_rank,&
      cusolverDsyevd_rank_0,&
      cusolverDsyevd_rank_1
  end interface
  
  interface cusolverCheevd
    function cusolverCheevd_(handle,jobz,uplo,n,A,lda,D,work,lwork,&
&devInfo) bind(c, name="cusolverCheevd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCheevd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCheevd_full_rank,&
      cusolverCheevd_rank_0,&
      cusolverCheevd_rank_1
  end interface
  
  interface cusolverZheevd
    function cusolverZheevd_(handle,jobz,uplo,n,A,lda,D,work,lwork,&
&devInfo) bind(c, name="cusolverZheevd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZheevd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZheevd_full_rank,&
      cusolverZheevd_rank_0,&
      cusolverZheevd_rank_1
  end interface
  
  interface cusolverSsygvd_bufferSize
    function cusolverSsygvd_bufferSize_(handle,itype,jobz,uplo,n,A,lda,&
&B,ldb,D,lwork) bind(c, name="cusolverSsygvd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsygvd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSsygvd_bufferSize_full_rank,&
      cusolverSsygvd_bufferSize_rank_0,&
      cusolverSsygvd_bufferSize_rank_1
  end interface
  
  interface cusolverDsygvd_bufferSize
    function cusolverDsygvd_bufferSize_(handle,itype,jobz,uplo,n,A,lda,&
&B,ldb,D,lwork) bind(c, name="cusolverDsygvd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsygvd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDsygvd_bufferSize_full_rank,&
      cusolverDsygvd_bufferSize_rank_0,&
      cusolverDsygvd_bufferSize_rank_1
  end interface
  
  interface cusolverChegvd_bufferSize
    function cusolverChegvd_bufferSize_(handle,itype,jobz,uplo,n,A,lda,&
&B,ldb,D,lwork) bind(c, name="cusolverChegvd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChegvd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverChegvd_bufferSize_full_rank,&
      cusolverChegvd_bufferSize_rank_0,&
      cusolverChegvd_bufferSize_rank_1
  end interface
  
  interface cusolverZhegvd_bufferSize
    function cusolverZhegvd_bufferSize_(handle,itype,jobz,uplo,n,A,lda,&
&B,ldb,D,lwork) bind(c, name="cusolverZhegvd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhegvd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZhegvd_bufferSize_full_rank,&
      cusolverZhegvd_bufferSize_rank_0,&
      cusolverZhegvd_bufferSize_rank_1
  end interface
  
  interface cusolverSsygvd
    function cusolverSsygvd_(handle,itype,jobz,uplo,n,A,lda,B,ldb,D,&
&work,lwork,devInfo) bind(c, name="cusolverSsygvd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsygvd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSsygvd_full_rank,&
      cusolverSsygvd_rank_0,&
      cusolverSsygvd_rank_1
  end interface
  
  interface cusolverDsygvd
    function cusolverDsygvd_(handle,itype,jobz,uplo,n,A,lda,B,ldb,D,&
&work,lwork,devInfo) bind(c, name="cusolverDsygvd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsygvd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDsygvd_full_rank,&
      cusolverDsygvd_rank_0,&
      cusolverDsygvd_rank_1
  end interface
  
  interface cusolverChegvd
    function cusolverChegvd_(handle,itype,jobz,uplo,n,A,lda,B,ldb,D,&
&work,lwork,devInfo) bind(c, name="cusolverChegvd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChegvd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverChegvd_full_rank,&
      cusolverChegvd_rank_0,&
      cusolverChegvd_rank_1
  end interface
  
  interface cusolverZhegvd
    function cusolverZhegvd_(handle,itype,jobz,uplo,n,A,lda,B,ldb,D,&
&work,lwork,devInfo) bind(c, name="cusolverZhegvd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhegvd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)),value :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)),value :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: D
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZhegvd_full_rank,&
      cusolverZhegvd_rank_0,&
      cusolverZhegvd_rank_1
  end interface
  
  interface cusolverSsytrd_bufferSize
    function cusolverSsytrd_bufferSize_(handle,uplo,n,A,lda,D,E,tau,&
&lwork) bind(c, name="cusolverSsytrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      real(c_float) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSsytrd_bufferSize_full_rank,&
      cusolverSsytrd_bufferSize_rank_0,&
      cusolverSsytrd_bufferSize_rank_1
  end interface
  
  interface cusolverDsytrd_bufferSize
    function cusolverDsytrd_bufferSize_(handle,uplo,n,A,lda,D,E,tau,&
&lwork) bind(c, name="cusolverDsytrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      real(c_double) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDsytrd_bufferSize_full_rank,&
      cusolverDsytrd_bufferSize_rank_0,&
      cusolverDsytrd_bufferSize_rank_1
  end interface
  
  interface cusolverChetrd_bufferSize
    function cusolverChetrd_bufferSize_(handle,uplo,n,A,lda,D,E,tau,&
&lwork) bind(c, name="cusolverChetrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChetrd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverChetrd_bufferSize_full_rank,&
      cusolverChetrd_bufferSize_rank_0,&
      cusolverChetrd_bufferSize_rank_1
  end interface
  
  interface cusolverZhetrd_bufferSize
    function cusolverZhetrd_bufferSize_(handle,uplo,n,A,lda,D,E,tau,&
&lwork) bind(c, name="cusolverZhetrd_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhetrd_bufferSize_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZhetrd_bufferSize_full_rank,&
      cusolverZhetrd_bufferSize_rank_0,&
      cusolverZhetrd_bufferSize_rank_1
  end interface
  
  interface cusolverSsytrd
    function cusolverSsytrd_(handle,uplo,n,A,lda,D,E,tau,work,lwork,&
&devInfo) bind(c, name="cusolverSsytrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      real(c_float) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSsytrd_full_rank,&
      cusolverSsytrd_rank_0,&
      cusolverSsytrd_rank_1
  end interface
  
  interface cusolverDsytrd
    function cusolverDsytrd_(handle,uplo,n,A,lda,D,E,tau,work,lwork,&
&devInfo) bind(c, name="cusolverDsytrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      real(c_double) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDsytrd_full_rank,&
      cusolverDsytrd_rank_0,&
      cusolverDsytrd_rank_1
  end interface
  
  interface cusolverChetrd
    function cusolverChetrd_(handle,uplo,n,A,lda,D,E,tau,work,lwork,&
&devInfo) bind(c, name="cusolverChetrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChetrd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      complex(c_float_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverChetrd_full_rank,&
      cusolverChetrd_rank_0,&
      cusolverChetrd_rank_1
  end interface
  
  interface cusolverZhetrd
    function cusolverZhetrd_(handle,uplo,n,A,lda,D,E,tau,work,lwork,&
&devInfo) bind(c, name="cusolverZhetrd")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhetrd_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: D
      type(c_ptr),value :: E
      complex(c_double_complex) :: tau
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZhetrd_full_rank,&
      cusolverZhetrd_rank_0,&
      cusolverZhetrd_rank_1
  end interface
  
  interface cusolverSsytrf_bufferSize
    function cusolverSsytrf_bufferSize_(handle,n,A,lda,lwork) bind(c, &
&name="cusolverSsytrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverSsytrf_bufferSize_full_rank,&
      cusolverSsytrf_bufferSize_rank_0,&
      cusolverSsytrf_bufferSize_rank_1
  end interface
  
  interface cusolverDsytrf_bufferSize
    function cusolverDsytrf_bufferSize_(handle,n,A,lda,lwork) bind(c, &
&name="cusolverDsytrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverDsytrf_bufferSize_full_rank,&
      cusolverDsytrf_bufferSize_rank_0,&
      cusolverDsytrf_bufferSize_rank_1
  end interface
  
  interface cusolverCsytrf_bufferSize
    function cusolverCsytrf_bufferSize_(handle,n,A,lda,lwork) bind(c, &
&name="cusolverCsytrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCsytrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverCsytrf_bufferSize_full_rank,&
      cusolverCsytrf_bufferSize_rank_0,&
      cusolverCsytrf_bufferSize_rank_1
  end interface
  
  interface cusolverZsytrf_bufferSize
    function cusolverZsytrf_bufferSize_(handle,n,A,lda,lwork) bind(c, &
&name="cusolverZsytrf_bufferSize")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZsytrf_bufferSize_
      type(c_ptr),value :: handle
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      integer(c_int) :: lwork
    end function

    module procedure &
      cusolverZsytrf_bufferSize_full_rank,&
      cusolverZsytrf_bufferSize_rank_0,&
      cusolverZsytrf_bufferSize_rank_1
  end interface
  
  interface cusolverSsytrf
    function cusolverSsytrf_(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo) bind(c, name="cusolverSsytrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: ipiv
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverSsytrf_full_rank,&
      cusolverSsytrf_rank_0,&
      cusolverSsytrf_rank_1
  end interface
  
  interface cusolverDsytrf
    function cusolverDsytrf_(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo) bind(c, name="cusolverDsytrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: ipiv
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverDsytrf_full_rank,&
      cusolverDsytrf_rank_0,&
      cusolverDsytrf_rank_1
  end interface
  
  interface cusolverCsytrf
    function cusolverCsytrf_(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo) bind(c, name="cusolverCsytrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCsytrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: ipiv
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverCsytrf_full_rank,&
      cusolverCsytrf_rank_0,&
      cusolverCsytrf_rank_1
  end interface
  
  interface cusolverZsytrf
    function cusolverZsytrf_(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo) bind(c, name="cusolverZsytrf")
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZsytrf_
      type(c_ptr),value :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)),value :: uplo
      integer(c_int),value :: n
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: ipiv
      type(c_ptr),value :: work
      integer(c_int),value :: lwork
      integer(c_int) :: devInfo
    end function

    module procedure &
      cusolverZsytrf_full_rank,&
      cusolverZsytrf_rank_0,&
      cusolverZsytrf_rank_1
  end interface

  contains
    function cusolverSorgbr_bufferSize_full_rank(handle,side,m,n,k,A,&
&lda,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgbr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgbr_bufferSize_full_rank = &
&cusolverSorgbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgbr_bufferSize_rank_0(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgbr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgbr_bufferSize_rank_0 = &
&cusolverSorgbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgbr_bufferSize_rank_1(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgbr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgbr_bufferSize_rank_1 = &
&cusolverSorgbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgbr_bufferSize_full_rank(handle,side,m,n,k,A,&
&lda,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgbr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgbr_bufferSize_full_rank = &
&cusolverDorgbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgbr_bufferSize_rank_0(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgbr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgbr_bufferSize_rank_0 = &
&cusolverDorgbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgbr_bufferSize_rank_1(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgbr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgbr_bufferSize_rank_1 = &
&cusolverDorgbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungbr_bufferSize_full_rank(handle,side,m,n,k,A,&
&lda,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungbr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungbr_bufferSize_full_rank = &
&cusolverCungbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungbr_bufferSize_rank_0(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungbr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungbr_bufferSize_rank_0 = &
&cusolverCungbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungbr_bufferSize_rank_1(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungbr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungbr_bufferSize_rank_1 = &
&cusolverCungbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungbr_bufferSize_full_rank(handle,side,m,n,k,A,&
&lda,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungbr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungbr_bufferSize_full_rank = &
&cusolverZungbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungbr_bufferSize_rank_0(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungbr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungbr_bufferSize_rank_0 = &
&cusolverZungbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungbr_bufferSize_rank_1(handle,side,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungbr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungbr_bufferSize_rank_1 = &
&cusolverZungbr_bufferSize_(handle,side,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgbr_full_rank(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgbr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgbr_full_rank = cusolverSorgbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgbr_rank_0(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgbr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgbr_rank_0 = cusolverSorgbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgbr_rank_1(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgbr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgbr_rank_1 = cusolverSorgbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgbr_full_rank(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgbr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgbr_full_rank = cusolverDorgbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgbr_rank_0(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgbr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgbr_rank_0 = cusolverDorgbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgbr_rank_1(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgbr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgbr_rank_1 = cusolverDorgbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungbr_full_rank(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungbr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungbr_full_rank = cusolverCungbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungbr_rank_0(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungbr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungbr_rank_0 = cusolverCungbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungbr_rank_1(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungbr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungbr_rank_1 = cusolverCungbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungbr_full_rank(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungbr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungbr_full_rank = cusolverZungbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungbr_rank_0(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungbr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungbr_rank_0 = cusolverZungbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungbr_rank_1(handle,side,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungbr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungbr_rank_1 = cusolverZungbr_(handle,side,m,n,k,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgqr_bufferSize_full_rank(handle,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgqr_bufferSize_full_rank = &
&cusolverSorgqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgqr_bufferSize_rank_0(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgqr_bufferSize_rank_0 = &
&cusolverSorgqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgqr_bufferSize_rank_1(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgqr_bufferSize_rank_1 = &
&cusolverSorgqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgqr_bufferSize_full_rank(handle,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgqr_bufferSize_full_rank = &
&cusolverDorgqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgqr_bufferSize_rank_0(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgqr_bufferSize_rank_0 = &
&cusolverDorgqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgqr_bufferSize_rank_1(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgqr_bufferSize_rank_1 = &
&cusolverDorgqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungqr_bufferSize_full_rank(handle,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungqr_bufferSize_full_rank = &
&cusolverCungqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungqr_bufferSize_rank_0(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungqr_bufferSize_rank_0 = &
&cusolverCungqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungqr_bufferSize_rank_1(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungqr_bufferSize_rank_1 = &
&cusolverCungqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungqr_bufferSize_full_rank(handle,m,n,k,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungqr_bufferSize_full_rank = &
&cusolverZungqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungqr_bufferSize_rank_0(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungqr_bufferSize_rank_0 = &
&cusolverZungqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungqr_bufferSize_rank_1(handle,m,n,k,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungqr_bufferSize_rank_1 = &
&cusolverZungqr_bufferSize_(handle,m,n,k,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgqr_full_rank(handle,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgqr_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgqr_full_rank = cusolverSorgqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgqr_rank_0(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgqr_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgqr_rank_0 = cusolverSorgqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgqr_rank_1(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgqr_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgqr_rank_1 = cusolverSorgqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgqr_full_rank(handle,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgqr_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgqr_full_rank = cusolverDorgqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgqr_rank_0(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgqr_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgqr_rank_0 = cusolverDorgqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgqr_rank_1(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgqr_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgqr_rank_1 = cusolverDorgqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungqr_full_rank(handle,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungqr_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungqr_full_rank = cusolverCungqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungqr_rank_0(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungqr_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungqr_rank_0 = cusolverCungqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungqr_rank_1(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungqr_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungqr_rank_1 = cusolverCungqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungqr_full_rank(handle,m,n,k,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungqr_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungqr_full_rank = cusolverZungqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungqr_rank_0(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungqr_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungqr_rank_0 = cusolverZungqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungqr_rank_1(handle,m,n,k,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungqr_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungqr_rank_1 = cusolverZungqr_(handle,m,n,k,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgtr_bufferSize_full_rank(handle,uplo,n,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgtr_bufferSize_full_rank = &
&cusolverSorgtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgtr_bufferSize_rank_0(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgtr_bufferSize_rank_0 = &
&cusolverSorgtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgtr_bufferSize_rank_1(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSorgtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSorgtr_bufferSize_rank_1 = &
&cusolverSorgtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgtr_bufferSize_full_rank(handle,uplo,n,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgtr_bufferSize_full_rank = &
&cusolverDorgtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgtr_bufferSize_rank_0(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgtr_bufferSize_rank_0 = &
&cusolverDorgtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverDorgtr_bufferSize_rank_1(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDorgtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDorgtr_bufferSize_rank_1 = &
&cusolverDorgtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungtr_bufferSize_full_rank(handle,uplo,n,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungtr_bufferSize_full_rank = &
&cusolverCungtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungtr_bufferSize_rank_0(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungtr_bufferSize_rank_0 = &
&cusolverCungtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverCungtr_bufferSize_rank_1(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCungtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverCungtr_bufferSize_rank_1 = &
&cusolverCungtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungtr_bufferSize_full_rank(handle,uplo,n,A,lda,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungtr_bufferSize_full_rank = &
&cusolverZungtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungtr_bufferSize_rank_0(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungtr_bufferSize_rank_0 = &
&cusolverZungtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverZungtr_bufferSize_rank_1(handle,uplo,n,A,lda,tau,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZungtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZungtr_bufferSize_rank_1 = &
&cusolverZungtr_bufferSize_(handle,uplo,n,c_loc(A),lda,tau,lwork)
    end function

    function cusolverSorgtr_full_rank(handle,uplo,n,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgtr_full_rank = cusolverSorgtr_(handle,uplo,n,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgtr_rank_0(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgtr_rank_0 = cusolverSorgtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverSorgtr_rank_1(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSorgtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSorgtr_rank_1 = cusolverSorgtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgtr_full_rank(handle,uplo,n,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgtr_full_rank = cusolverDorgtr_(handle,uplo,n,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgtr_rank_0(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgtr_rank_0 = cusolverDorgtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverDorgtr_rank_1(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDorgtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDorgtr_rank_1 = cusolverDorgtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungtr_full_rank(handle,uplo,n,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungtr_full_rank = cusolverCungtr_(handle,uplo,n,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungtr_rank_0(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungtr_rank_0 = cusolverCungtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverCungtr_rank_1(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCungtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCungtr_rank_1 = cusolverCungtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungtr_full_rank(handle,uplo,n,A,lda,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungtr_full_rank = cusolverZungtr_(handle,uplo,n,&
&c_loc(A),lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungtr_rank_0(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungtr_rank_0 = cusolverZungtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverZungtr_rank_1(handle,uplo,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZungtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZungtr_rank_1 = cusolverZungtr_(handle,uplo,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverSormqr_bufferSize_full_rank(handle,side,trans,m,n,&
&k,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverSormqr_bufferSize_full_rank = &
&cusolverSormqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverSormqr_bufferSize_rank_0(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverSormqr_bufferSize_rank_0 = &
&cusolverSormqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverSormqr_bufferSize_rank_1(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverSormqr_bufferSize_rank_1 = &
&cusolverSormqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverDormqr_bufferSize_full_rank(handle,side,trans,m,n,&
&k,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverDormqr_bufferSize_full_rank = &
&cusolverDormqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverDormqr_bufferSize_rank_0(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverDormqr_bufferSize_rank_0 = &
&cusolverDormqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverDormqr_bufferSize_rank_1(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverDormqr_bufferSize_rank_1 = &
&cusolverDormqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverCunmqr_bufferSize_full_rank(handle,side,trans,m,n,&
&k,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverCunmqr_bufferSize_full_rank = &
&cusolverCunmqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverCunmqr_bufferSize_rank_0(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverCunmqr_bufferSize_rank_0 = &
&cusolverCunmqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverCunmqr_bufferSize_rank_1(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverCunmqr_bufferSize_rank_1 = &
&cusolverCunmqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverZunmqr_bufferSize_full_rank(handle,side,trans,m,n,&
&k,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmqr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverZunmqr_bufferSize_full_rank = &
&cusolverZunmqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverZunmqr_bufferSize_rank_0(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmqr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverZunmqr_bufferSize_rank_0 = &
&cusolverZunmqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverZunmqr_bufferSize_rank_1(handle,side,trans,m,n,k,&
&A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmqr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverZunmqr_bufferSize_rank_1 = &
&cusolverZunmqr_bufferSize_(handle,side,trans,m,n,k,c_loc(A),lda,tau,&
&c_loc(C),ldc,lwork)
    end function

    function cusolverSormqr_full_rank(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormqr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSormqr_full_rank = cusolverSormqr_(handle,side,trans,m,n,&
&k,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverSormqr_rank_0(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormqr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSormqr_rank_0 = cusolverSormqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverSormqr_rank_1(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormqr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSormqr_rank_1 = cusolverSormqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverDormqr_full_rank(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormqr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDormqr_full_rank = cusolverDormqr_(handle,side,trans,m,n,&
&k,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverDormqr_rank_0(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormqr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDormqr_rank_0 = cusolverDormqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverDormqr_rank_1(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormqr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDormqr_rank_1 = cusolverDormqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverCunmqr_full_rank(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmqr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCunmqr_full_rank = cusolverCunmqr_(handle,side,trans,m,n,&
&k,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverCunmqr_rank_0(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmqr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCunmqr_rank_0 = cusolverCunmqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverCunmqr_rank_1(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmqr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCunmqr_rank_1 = cusolverCunmqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverZunmqr_full_rank(handle,side,trans,m,n,k,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmqr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZunmqr_full_rank = cusolverZunmqr_(handle,side,trans,m,n,&
&k,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverZunmqr_rank_0(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmqr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZunmqr_rank_0 = cusolverZunmqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverZunmqr_rank_1(handle,side,trans,m,n,k,A,lda,tau,C,&
&ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmqr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      integer(c_int) :: k
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZunmqr_rank_1 = cusolverZunmqr_(handle,side,trans,m,n,k,&
&c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverSormtr_bufferSize_full_rank(handle,side,uplo,&
&trans,m,n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverSormtr_bufferSize_full_rank = &
&cusolverSormtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverSormtr_bufferSize_rank_0(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverSormtr_bufferSize_rank_0 = &
&cusolverSormtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverSormtr_bufferSize_rank_1(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSormtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverSormtr_bufferSize_rank_1 = &
&cusolverSormtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverDormtr_bufferSize_full_rank(handle,side,uplo,&
&trans,m,n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverDormtr_bufferSize_full_rank = &
&cusolverDormtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverDormtr_bufferSize_rank_0(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverDormtr_bufferSize_rank_0 = &
&cusolverDormtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverDormtr_bufferSize_rank_1(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDormtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverDormtr_bufferSize_rank_1 = &
&cusolverDormtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverCunmtr_bufferSize_full_rank(handle,side,uplo,&
&trans,m,n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverCunmtr_bufferSize_full_rank = &
&cusolverCunmtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverCunmtr_bufferSize_rank_0(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverCunmtr_bufferSize_rank_0 = &
&cusolverCunmtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverCunmtr_bufferSize_rank_1(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCunmtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverCunmtr_bufferSize_rank_1 = &
&cusolverCunmtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverZunmtr_bufferSize_full_rank(handle,side,uplo,&
&trans,m,n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmtr_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverZunmtr_bufferSize_full_rank = &
&cusolverZunmtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverZunmtr_bufferSize_rank_0(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmtr_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverZunmtr_bufferSize_rank_0 = &
&cusolverZunmtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverZunmtr_bufferSize_rank_1(handle,side,uplo,trans,m,&
&n,A,lda,tau,C,ldc,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZunmtr_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      integer(c_int) :: lwork
      !
      cusolverZunmtr_bufferSize_rank_1 = &
&cusolverZunmtr_bufferSize_(handle,side,uplo,trans,m,n,c_loc(A),lda,&
&tau,c_loc(C),ldc,lwork)
    end function

    function cusolverSormtr_full_rank(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSormtr_full_rank = cusolverSormtr_(handle,side,uplo,&
&trans,m,n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverSormtr_rank_0(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSormtr_rank_0 = cusolverSormtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverSormtr_rank_1(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSormtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      real(c_float),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSormtr_rank_1 = cusolverSormtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverDormtr_full_rank(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDormtr_full_rank = cusolverDormtr_(handle,side,uplo,&
&trans,m,n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverDormtr_rank_0(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDormtr_rank_0 = cusolverDormtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverDormtr_rank_1(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDormtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      real(c_double),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDormtr_rank_1 = cusolverDormtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverCunmtr_full_rank(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCunmtr_full_rank = cusolverCunmtr_(handle,side,uplo,&
&trans,m,n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverCunmtr_rank_0(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCunmtr_rank_0 = cusolverCunmtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverCunmtr_rank_1(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCunmtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      complex(c_float_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCunmtr_rank_1 = cusolverCunmtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverZunmtr_full_rank(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmtr_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:,:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZunmtr_full_rank = cusolverZunmtr_(handle,side,uplo,&
&trans,m,n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverZunmtr_rank_0(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmtr_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZunmtr_rank_0 = cusolverZunmtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverZunmtr_rank_1(handle,side,uplo,trans,m,n,A,lda,&
&tau,C,ldc,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZunmtr_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_SIDE_LEFT)) :: side
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      complex(c_double_complex),target,dimension(:) :: C
      integer(c_int) :: ldc
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZunmtr_rank_1 = cusolverZunmtr_(handle,side,uplo,trans,m,&
&n,c_loc(A),lda,tau,c_loc(C),ldc,work,lwork,devInfo)
    end function

    function cusolverSgebrd_full_rank(handle,m,n,A,lda,D,E,tauq,taup,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgebrd_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      real(c_float),target,dimension(:) :: tauq
      real(c_float),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgebrd_full_rank = cusolverSgebrd_(handle,m,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverSgebrd_rank_0(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgebrd_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      real(c_float),target :: E
      real(c_float),target :: tauq
      real(c_float),target :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgebrd_rank_0 = cusolverSgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverSgebrd_rank_1(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgebrd_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      real(c_float),target,dimension(:) :: tauq
      real(c_float),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgebrd_rank_1 = cusolverSgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverDgebrd_full_rank(handle,m,n,A,lda,D,E,tauq,taup,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgebrd_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      real(c_double),target,dimension(:) :: tauq
      real(c_double),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgebrd_full_rank = cusolverDgebrd_(handle,m,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverDgebrd_rank_0(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgebrd_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      real(c_double),target :: E
      real(c_double),target :: tauq
      real(c_double),target :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgebrd_rank_0 = cusolverDgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverDgebrd_rank_1(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgebrd_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      real(c_double),target,dimension(:) :: tauq
      real(c_double),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgebrd_rank_1 = cusolverDgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverCgebrd_full_rank(handle,m,n,A,lda,D,E,tauq,taup,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgebrd_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      complex(c_float_complex),target,dimension(:) :: tauq
      complex(c_float_complex),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgebrd_full_rank = cusolverCgebrd_(handle,m,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverCgebrd_rank_0(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgebrd_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      real(c_float),target :: E
      complex(c_float_complex),target :: tauq
      complex(c_float_complex),target :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgebrd_rank_0 = cusolverCgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverCgebrd_rank_1(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgebrd_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      complex(c_float_complex),target,dimension(:) :: tauq
      complex(c_float_complex),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgebrd_rank_1 = cusolverCgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverZgebrd_full_rank(handle,m,n,A,lda,D,E,tauq,taup,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgebrd_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      complex(c_double_complex),target,dimension(:) :: tauq
      complex(c_double_complex),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgebrd_full_rank = cusolverZgebrd_(handle,m,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverZgebrd_rank_0(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgebrd_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      real(c_double),target :: E
      complex(c_double_complex),target :: tauq
      complex(c_double_complex),target :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgebrd_rank_0 = cusolverZgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverZgebrd_rank_1(handle,m,n,A,lda,D,E,tauq,taup,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgebrd_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      complex(c_double_complex),target,dimension(:) :: tauq
      complex(c_double_complex),target,dimension(:) :: taup
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgebrd_rank_1 = cusolverZgebrd_(handle,m,n,c_loc(A),lda,&
&c_loc(D),c_loc(E),c_loc(tauq),c_loc(taup),work,lwork,devInfo)
    end function

    function cusolverSgeqrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgeqrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSgeqrf_bufferSize_full_rank = &
&cusolverSgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverSgeqrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgeqrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSgeqrf_bufferSize_rank_0 = &
&cusolverSgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverSgeqrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgeqrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSgeqrf_bufferSize_rank_1 = &
&cusolverSgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverDgeqrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgeqrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDgeqrf_bufferSize_full_rank = &
&cusolverDgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverDgeqrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgeqrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDgeqrf_bufferSize_rank_0 = &
&cusolverDgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverDgeqrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgeqrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDgeqrf_bufferSize_rank_1 = &
&cusolverDgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverCgeqrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgeqrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCgeqrf_bufferSize_full_rank = &
&cusolverCgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverCgeqrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgeqrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCgeqrf_bufferSize_rank_0 = &
&cusolverCgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverCgeqrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgeqrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCgeqrf_bufferSize_rank_1 = &
&cusolverCgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverZgeqrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgeqrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZgeqrf_bufferSize_full_rank = &
&cusolverZgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverZgeqrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgeqrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZgeqrf_bufferSize_rank_0 = &
&cusolverZgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverZgeqrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgeqrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZgeqrf_bufferSize_rank_1 = &
&cusolverZgeqrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverSgeqrf_full_rank(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgeqrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgeqrf_full_rank = cusolverSgeqrf_(handle,m,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverSgeqrf_rank_0(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgeqrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgeqrf_rank_0 = cusolverSgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverSgeqrf_rank_1(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgeqrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgeqrf_rank_1 = cusolverSgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverDgeqrf_full_rank(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgeqrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgeqrf_full_rank = cusolverDgeqrf_(handle,m,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverDgeqrf_rank_0(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgeqrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgeqrf_rank_0 = cusolverDgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverDgeqrf_rank_1(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgeqrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgeqrf_rank_1 = cusolverDgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverCgeqrf_full_rank(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgeqrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgeqrf_full_rank = cusolverCgeqrf_(handle,m,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverCgeqrf_rank_0(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgeqrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgeqrf_rank_0 = cusolverCgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverCgeqrf_rank_1(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgeqrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgeqrf_rank_1 = cusolverCgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverZgeqrf_full_rank(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgeqrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgeqrf_full_rank = cusolverZgeqrf_(handle,m,n,c_loc(A),&
&lda,tau,work,lwork,devInfo)
    end function

    function cusolverZgeqrf_rank_0(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgeqrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgeqrf_rank_0 = cusolverZgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverZgeqrf_rank_1(handle,m,n,A,lda,tau,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgeqrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgeqrf_rank_1 = cusolverZgeqrf_(handle,m,n,c_loc(A),lda,&
&tau,work,lwork,devInfo)
    end function

    function cusolverSSgesv_bufferSize_full_rank(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSSgesv_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverSSgesv_bufferSize_full_rank = &
&cusolverSSgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverSSgesv_bufferSize_rank_0(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSSgesv_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_float),target :: B
      integer(c_int) :: ldb
      real(c_float),target :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverSSgesv_bufferSize_rank_0 = &
&cusolverSSgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverSSgesv_bufferSize_rank_1(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSSgesv_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverSSgesv_bufferSize_rank_1 = &
&cusolverSSgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverDDgesv_bufferSize_full_rank(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDDgesv_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverDDgesv_bufferSize_full_rank = &
&cusolverDDgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverDDgesv_bufferSize_rank_0(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDDgesv_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_double),target :: B
      integer(c_int) :: ldb
      real(c_double),target :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverDDgesv_bufferSize_rank_0 = &
&cusolverDDgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverDDgesv_bufferSize_rank_1(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDDgesv_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverDDgesv_bufferSize_rank_1 = &
&cusolverDDgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverCCgesv_bufferSize_full_rank(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCCgesv_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      complex(c_float_complex),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverCCgesv_bufferSize_full_rank = &
&cusolverCCgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverCCgesv_bufferSize_rank_0(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCCgesv_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      complex(c_float_complex),target :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverCCgesv_bufferSize_rank_0 = &
&cusolverCCgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverCCgesv_bufferSize_rank_1(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCCgesv_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      complex(c_float_complex),target,dimension(:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverCCgesv_bufferSize_rank_1 = &
&cusolverCCgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverZZgesv_bufferSize_full_rank(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZZgesv_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      complex(c_double_complex),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverZZgesv_bufferSize_full_rank = &
&cusolverZZgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverZZgesv_bufferSize_rank_0(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZZgesv_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      complex(c_double_complex),target :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverZZgesv_bufferSize_rank_0 = &
&cusolverZZgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverZZgesv_bufferSize_rank_1(handle,n,nrhs,A,lda,&
&devIpiv,B,ldb,X,ldx,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZZgesv_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      complex(c_double_complex),target,dimension(:) :: X
      integer(c_int) :: ldx
      integer(c_size_t) :: lwork
      !
      cusolverZZgesv_bufferSize_rank_1 = &
&cusolverZZgesv_bufferSize_(handle,n,nrhs,c_loc(A),lda,c_loc(devIpiv),&
&c_loc(B),ldb,c_loc(X),ldx,lwork)
    end function

    function cusolverSSgesv_full_rank(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSSgesv_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverSSgesv_full_rank = cusolverSSgesv_(handle,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,&
&niters,devInfo)
    end function

    function cusolverSSgesv_rank_0(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSSgesv_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_float),target :: B
      integer(c_int) :: ldb
      real(c_float),target :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverSSgesv_rank_0 = cusolverSSgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverSSgesv_rank_1(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSSgesv_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverSSgesv_rank_1 = cusolverSSgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverDDgesv_full_rank(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDDgesv_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverDDgesv_full_rank = cusolverDDgesv_(handle,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,&
&niters,devInfo)
    end function

    function cusolverDDgesv_rank_0(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDDgesv_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_double),target :: B
      integer(c_int) :: ldb
      real(c_double),target :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverDDgesv_rank_0 = cusolverDDgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverDDgesv_rank_1(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDDgesv_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverDDgesv_rank_1 = cusolverDDgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverCCgesv_full_rank(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCCgesv_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      complex(c_float_complex),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverCCgesv_full_rank = cusolverCCgesv_(handle,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,&
&niters,devInfo)
    end function

    function cusolverCCgesv_rank_0(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCCgesv_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      complex(c_float_complex),target :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverCCgesv_rank_0 = cusolverCCgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverCCgesv_rank_1(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCCgesv_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      complex(c_float_complex),target,dimension(:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverCCgesv_rank_1 = cusolverCCgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverZZgesv_full_rank(handle,n,nrhs,A,lda,devIpiv,B,&
&ldb,X,ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZZgesv_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      complex(c_double_complex),target,dimension(:,:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverZZgesv_full_rank = cusolverZZgesv_(handle,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,&
&niters,devInfo)
    end function

    function cusolverZZgesv_rank_0(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZZgesv_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      complex(c_double_complex),target :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverZZgesv_rank_0 = cusolverZZgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverZZgesv_rank_1(handle,n,nrhs,A,lda,devIpiv,B,ldb,X,&
&ldx,work,lwork,niters,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZZgesv_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      complex(c_double_complex),target,dimension(:) :: X
      integer(c_int) :: ldx
      type(c_ptr) :: work
      integer(c_size_t) :: lwork
      type(c_ptr) :: niters
      integer(c_int) :: devInfo
      !
      cusolverZZgesv_rank_1 = cusolverZZgesv_(handle,n,nrhs,c_loc(A),&
&lda,c_loc(devIpiv),c_loc(B),ldb,c_loc(X),ldx,work,lwork,niters,&
&devInfo)
    end function

    function cusolverSgetrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSgetrf_bufferSize_full_rank = &
&cusolverSgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverSgetrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSgetrf_bufferSize_rank_0 = &
&cusolverSgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverSgetrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSgetrf_bufferSize_rank_1 = &
&cusolverSgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverDgetrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDgetrf_bufferSize_full_rank = &
&cusolverDgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverDgetrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDgetrf_bufferSize_rank_0 = &
&cusolverDgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverDgetrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDgetrf_bufferSize_rank_1 = &
&cusolverDgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverCgetrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCgetrf_bufferSize_full_rank = &
&cusolverCgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverCgetrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCgetrf_bufferSize_rank_0 = &
&cusolverCgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverCgetrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCgetrf_bufferSize_rank_1 = &
&cusolverCgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverZgetrf_bufferSize_full_rank(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZgetrf_bufferSize_full_rank = &
&cusolverZgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverZgetrf_bufferSize_rank_0(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZgetrf_bufferSize_rank_0 = &
&cusolverZgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverZgetrf_bufferSize_rank_1(handle,m,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZgetrf_bufferSize_rank_1 = &
&cusolverZgetrf_bufferSize_(handle,m,n,c_loc(A),lda,lwork)
    end function

    function cusolverSgetrf_full_rank(handle,m,n,A,lda,work,lwork,&
&devIpiv,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverSgetrf_full_rank = cusolverSgetrf_(handle,m,n,c_loc(A),&
&lda,work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverSgetrf_rank_0(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverSgetrf_rank_0 = cusolverSgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverSgetrf_rank_1(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverSgetrf_rank_1 = cusolverSgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverDgetrf_full_rank(handle,m,n,A,lda,work,lwork,&
&devIpiv,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverDgetrf_full_rank = cusolverDgetrf_(handle,m,n,c_loc(A),&
&lda,work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverDgetrf_rank_0(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverDgetrf_rank_0 = cusolverDgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverDgetrf_rank_1(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverDgetrf_rank_1 = cusolverDgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverCgetrf_full_rank(handle,m,n,A,lda,work,lwork,&
&devIpiv,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverCgetrf_full_rank = cusolverCgetrf_(handle,m,n,c_loc(A),&
&lda,work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverCgetrf_rank_0(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverCgetrf_rank_0 = cusolverCgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverCgetrf_rank_1(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverCgetrf_rank_1 = cusolverCgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverZgetrf_full_rank(handle,m,n,A,lda,work,lwork,&
&devIpiv,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrf_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverZgetrf_full_rank = cusolverZgetrf_(handle,m,n,c_loc(A),&
&lda,work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverZgetrf_rank_0(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrf_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverZgetrf_rank_0 = cusolverZgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverZgetrf_rank_1(handle,m,n,A,lda,work,lwork,devIpiv,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrf_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: m
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int),target,dimension(:) :: devIpiv
      integer(c_int) :: devInfo
      !
      cusolverZgetrf_rank_1 = cusolverZgetrf_(handle,m,n,c_loc(A),lda,&
&work,lwork,c_loc(devIpiv),devInfo)
    end function

    function cusolverSgetrs_bufferSize_full_rank(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverSgetrs_bufferSize_full_rank = &
&cusolverSgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverSgetrs_bufferSize_rank_0(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_float),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverSgetrs_bufferSize_rank_0 = &
&cusolverSgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverSgetrs_bufferSize_rank_1(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSgetrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverSgetrs_bufferSize_rank_1 = &
&cusolverSgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverDgetrs_bufferSize_full_rank(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverDgetrs_bufferSize_full_rank = &
&cusolverDgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverDgetrs_bufferSize_rank_0(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_double),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverDgetrs_bufferSize_rank_0 = &
&cusolverDgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverDgetrs_bufferSize_rank_1(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDgetrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverDgetrs_bufferSize_rank_1 = &
&cusolverDgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverCgetrs_bufferSize_full_rank(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverCgetrs_bufferSize_full_rank = &
&cusolverCgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverCgetrs_bufferSize_rank_0(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverCgetrs_bufferSize_rank_0 = &
&cusolverCgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverCgetrs_bufferSize_rank_1(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCgetrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverCgetrs_bufferSize_rank_1 = &
&cusolverCgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverZgetrs_bufferSize_full_rank(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverZgetrs_bufferSize_full_rank = &
&cusolverZgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverZgetrs_bufferSize_rank_0(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverZgetrs_bufferSize_rank_0 = &
&cusolverZgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverZgetrs_bufferSize_rank_1(handle,trans,n,nrhs,A,&
&lda,devIpiv,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZgetrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverZgetrs_bufferSize_rank_1 = &
&cusolverZgetrs_bufferSize_(handle,trans,n,nrhs,c_loc(A),lda,&
&c_loc(devIpiv),c_loc(B),ldb,lwork)
    end function

    function cusolverSgetrs_full_rank(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgetrs_full_rank = cusolverSgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverSgetrs_rank_0(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_float),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgetrs_rank_0 = cusolverSgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverSgetrs_rank_1(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSgetrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSgetrs_rank_1 = cusolverSgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverDgetrs_full_rank(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgetrs_full_rank = cusolverDgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverDgetrs_rank_0(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      real(c_double),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgetrs_rank_0 = cusolverDgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverDgetrs_rank_1(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDgetrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDgetrs_rank_1 = cusolverDgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverCgetrs_full_rank(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgetrs_full_rank = cusolverCgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverCgetrs_rank_0(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgetrs_rank_0 = cusolverCgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverCgetrs_rank_1(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCgetrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCgetrs_rank_1 = cusolverCgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverZgetrs_full_rank(handle,trans,n,nrhs,A,lda,&
&devIpiv,B,ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgetrs_full_rank = cusolverZgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverZgetrs_rank_0(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int),target :: devIpiv
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgetrs_rank_0 = cusolverZgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverZgetrs_rank_1(handle,trans,n,nrhs,A,lda,devIpiv,B,&
&ldb,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZgetrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_OP_N)) :: trans
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int),target,dimension(:) :: devIpiv
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZgetrs_rank_1 = cusolverZgetrs_(handle,trans,n,nrhs,&
&c_loc(A),lda,c_loc(devIpiv),c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverSpotrf_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSpotrf_bufferSize_full_rank = &
&cusolverSpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverSpotrf_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSpotrf_bufferSize_rank_0 = &
&cusolverSpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverSpotrf_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSpotrf_bufferSize_rank_1 = &
&cusolverSpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverDpotrf_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDpotrf_bufferSize_full_rank = &
&cusolverDpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverDpotrf_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDpotrf_bufferSize_rank_0 = &
&cusolverDpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverDpotrf_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDpotrf_bufferSize_rank_1 = &
&cusolverDpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverCpotrf_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCpotrf_bufferSize_full_rank = &
&cusolverCpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverCpotrf_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCpotrf_bufferSize_rank_0 = &
&cusolverCpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverCpotrf_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCpotrf_bufferSize_rank_1 = &
&cusolverCpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverZpotrf_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZpotrf_bufferSize_full_rank = &
&cusolverZpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverZpotrf_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZpotrf_bufferSize_rank_0 = &
&cusolverZpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverZpotrf_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZpotrf_bufferSize_rank_1 = &
&cusolverZpotrf_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverSpotrf_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotrf_full_rank = cusolverSpotrf_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverSpotrf_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotrf_rank_0 = cusolverSpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverSpotrf_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotrf_rank_1 = cusolverSpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverDpotrf_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotrf_full_rank = cusolverDpotrf_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverDpotrf_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotrf_rank_0 = cusolverDpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverDpotrf_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotrf_rank_1 = cusolverDpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverCpotrf_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotrf_full_rank = cusolverCpotrf_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverCpotrf_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotrf_rank_0 = cusolverCpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverCpotrf_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotrf_rank_1 = cusolverCpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverZpotrf_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotrf_full_rank = cusolverZpotrf_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverZpotrf_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotrf_rank_0 = cusolverZpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverZpotrf_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotrf_rank_1 = cusolverZpotrf_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverSpotrfBatched_bufferSize_full_rank(handle,uplo,n,&
&A,lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverSpotrfBatched_bufferSize_full_rank = &
&cusolverSpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverSpotrfBatched_bufferSize_rank_0(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverSpotrfBatched_bufferSize_rank_0 = &
&cusolverSpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverSpotrfBatched_bufferSize_rank_1(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverSpotrfBatched_bufferSize_rank_1 = &
&cusolverSpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverDpotrfBatched_bufferSize_full_rank(handle,uplo,n,&
&A,lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverDpotrfBatched_bufferSize_full_rank = &
&cusolverDpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverDpotrfBatched_bufferSize_rank_0(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverDpotrfBatched_bufferSize_rank_0 = &
&cusolverDpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverDpotrfBatched_bufferSize_rank_1(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverDpotrfBatched_bufferSize_rank_1 = &
&cusolverDpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverCpotrfBatched_bufferSize_full_rank(handle,uplo,n,&
&A,lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverCpotrfBatched_bufferSize_full_rank = &
&cusolverCpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverCpotrfBatched_bufferSize_rank_0(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverCpotrfBatched_bufferSize_rank_0 = &
&cusolverCpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverCpotrfBatched_bufferSize_rank_1(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverCpotrfBatched_bufferSize_rank_1 = &
&cusolverCpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverZpotrfBatched_bufferSize_full_rank(handle,uplo,n,&
&A,lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverZpotrfBatched_bufferSize_full_rank = &
&cusolverZpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverZpotrfBatched_bufferSize_rank_0(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverZpotrfBatched_bufferSize_rank_0 = &
&cusolverZpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverZpotrfBatched_bufferSize_rank_1(handle,uplo,n,A,&
&lda,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverZpotrfBatched_bufferSize_rank_1 = &
&cusolverZpotrfBatched_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork,&
&batch_count)
    end function

    function cusolverSpotrfBatched_full_rank(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverSpotrfBatched_full_rank = cusolverSpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverSpotrfBatched_rank_0(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverSpotrfBatched_rank_0 = cusolverSpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverSpotrfBatched_rank_1(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrfBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverSpotrfBatched_rank_1 = cusolverSpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverDpotrfBatched_full_rank(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverDpotrfBatched_full_rank = cusolverDpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverDpotrfBatched_rank_0(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverDpotrfBatched_rank_0 = cusolverDpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverDpotrfBatched_rank_1(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrfBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverDpotrfBatched_rank_1 = cusolverDpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverCpotrfBatched_full_rank(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverCpotrfBatched_full_rank = cusolverCpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverCpotrfBatched_rank_0(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverCpotrfBatched_rank_0 = cusolverCpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverCpotrfBatched_rank_1(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrfBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverCpotrfBatched_rank_1 = cusolverCpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverZpotrfBatched_full_rank(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverZpotrfBatched_full_rank = cusolverZpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverZpotrfBatched_rank_0(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverZpotrfBatched_rank_0 = cusolverZpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverZpotrfBatched_rank_1(handle,uplo,n,A,lda,work,&
&lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrfBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverZpotrfBatched_rank_1 = cusolverZpotrfBatched_(handle,&
&uplo,n,c_loc(A),lda,work,lwork,devInfo,batch_count)
    end function

    function cusolverSpotri_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotri_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSpotri_bufferSize_full_rank = &
&cusolverSpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverSpotri_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotri_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSpotri_bufferSize_rank_0 = &
&cusolverSpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverSpotri_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotri_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSpotri_bufferSize_rank_1 = &
&cusolverSpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverDpotri_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotri_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDpotri_bufferSize_full_rank = &
&cusolverDpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverDpotri_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotri_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDpotri_bufferSize_rank_0 = &
&cusolverDpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverDpotri_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotri_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDpotri_bufferSize_rank_1 = &
&cusolverDpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverCpotri_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotri_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCpotri_bufferSize_full_rank = &
&cusolverCpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverCpotri_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotri_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCpotri_bufferSize_rank_0 = &
&cusolverCpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverCpotri_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotri_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCpotri_bufferSize_rank_1 = &
&cusolverCpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverZpotri_bufferSize_full_rank(handle,uplo,n,A,lda,&
&lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotri_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZpotri_bufferSize_full_rank = &
&cusolverZpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverZpotri_bufferSize_rank_0(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotri_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZpotri_bufferSize_rank_0 = &
&cusolverZpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverZpotri_bufferSize_rank_1(handle,uplo,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotri_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZpotri_bufferSize_rank_1 = &
&cusolverZpotri_bufferSize_(handle,uplo,n,c_loc(A),lda,lwork)
    end function

    function cusolverSpotri_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotri_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotri_full_rank = cusolverSpotri_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverSpotri_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotri_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotri_rank_0 = cusolverSpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverSpotri_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotri_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotri_rank_1 = cusolverSpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverDpotri_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotri_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotri_full_rank = cusolverDpotri_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverDpotri_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotri_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotri_rank_0 = cusolverDpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverDpotri_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotri_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotri_rank_1 = cusolverDpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverCpotri_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotri_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotri_full_rank = cusolverCpotri_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverCpotri_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotri_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotri_rank_0 = cusolverCpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverCpotri_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotri_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotri_rank_1 = cusolverCpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverZpotri_full_rank(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotri_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotri_full_rank = cusolverZpotri_(handle,uplo,n,&
&c_loc(A),lda,work,lwork,devInfo)
    end function

    function cusolverZpotri_rank_0(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotri_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotri_rank_0 = cusolverZpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverZpotri_rank_1(handle,uplo,n,A,lda,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotri_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotri_rank_1 = cusolverZpotri_(handle,uplo,n,c_loc(A),&
&lda,work,lwork,devInfo)
    end function

    function cusolverSpotrs_bufferSize_full_rank(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverSpotrs_bufferSize_full_rank = &
&cusolverSpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverSpotrs_bufferSize_rank_0(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverSpotrs_bufferSize_rank_0 = &
&cusolverSpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverSpotrs_bufferSize_rank_1(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverSpotrs_bufferSize_rank_1 = &
&cusolverSpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverDpotrs_bufferSize_full_rank(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverDpotrs_bufferSize_full_rank = &
&cusolverDpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverDpotrs_bufferSize_rank_0(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverDpotrs_bufferSize_rank_0 = &
&cusolverDpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverDpotrs_bufferSize_rank_1(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverDpotrs_bufferSize_rank_1 = &
&cusolverDpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverCpotrs_bufferSize_full_rank(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverCpotrs_bufferSize_full_rank = &
&cusolverCpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverCpotrs_bufferSize_rank_0(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverCpotrs_bufferSize_rank_0 = &
&cusolverCpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverCpotrs_bufferSize_rank_1(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverCpotrs_bufferSize_rank_1 = &
&cusolverCpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverZpotrs_bufferSize_full_rank(handle,uplo,n,nrhs,A,&
&lda,B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrs_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverZpotrs_bufferSize_full_rank = &
&cusolverZpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverZpotrs_bufferSize_rank_0(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrs_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverZpotrs_bufferSize_rank_0 = &
&cusolverZpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverZpotrs_bufferSize_rank_1(handle,uplo,n,nrhs,A,lda,&
&B,ldb,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrs_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      !
      cusolverZpotrs_bufferSize_rank_1 = &
&cusolverZpotrs_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,c_loc(B),&
&ldb,lwork)
    end function

    function cusolverSpotrs_full_rank(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotrs_full_rank = cusolverSpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverSpotrs_rank_0(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotrs_rank_0 = cusolverSpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverSpotrs_rank_1(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSpotrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSpotrs_rank_1 = cusolverSpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverDpotrs_full_rank(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotrs_full_rank = cusolverDpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverDpotrs_rank_0(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotrs_rank_0 = cusolverDpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverDpotrs_rank_1(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDpotrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDpotrs_rank_1 = cusolverDpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverCpotrs_full_rank(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotrs_full_rank = cusolverCpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverCpotrs_rank_0(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotrs_rank_0 = cusolverCpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverCpotrs_rank_1(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCpotrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCpotrs_rank_1 = cusolverCpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverZpotrs_full_rank(handle,uplo,n,nrhs,A,lda,B,ldb,&
&work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrs_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotrs_full_rank = cusolverZpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverZpotrs_rank_0(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrs_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotrs_rank_0 = cusolverZpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverZpotrs_rank_1(handle,uplo,n,nrhs,A,lda,B,ldb,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZpotrs_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZpotrs_rank_1 = cusolverZpotrs_(handle,uplo,n,nrhs,&
&c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo)
    end function

    function cusolverSpotrsBatched_bufferSize_full_rank(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverSpotrsBatched_bufferSize_full_rank = &
&cusolverSpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverSpotrsBatched_bufferSize_rank_0(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverSpotrsBatched_bufferSize_rank_0 = &
&cusolverSpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverSpotrsBatched_bufferSize_rank_1(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverSpotrsBatched_bufferSize_rank_1 = &
&cusolverSpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverDpotrsBatched_bufferSize_full_rank(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverDpotrsBatched_bufferSize_full_rank = &
&cusolverDpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverDpotrsBatched_bufferSize_rank_0(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverDpotrsBatched_bufferSize_rank_0 = &
&cusolverDpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverDpotrsBatched_bufferSize_rank_1(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverDpotrsBatched_bufferSize_rank_1 = &
&cusolverDpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverCpotrsBatched_bufferSize_full_rank(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverCpotrsBatched_bufferSize_full_rank = &
&cusolverCpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverCpotrsBatched_bufferSize_rank_0(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverCpotrsBatched_bufferSize_rank_0 = &
&cusolverCpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverCpotrsBatched_bufferSize_rank_1(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverCpotrsBatched_bufferSize_rank_1 = &
&cusolverCpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverZpotrsBatched_bufferSize_full_rank(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverZpotrsBatched_bufferSize_full_rank = &
&cusolverZpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverZpotrsBatched_bufferSize_rank_0(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverZpotrsBatched_bufferSize_rank_0 = &
&cusolverZpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverZpotrsBatched_bufferSize_rank_1(handle,uplo,n,&
&nrhs,A,lda,B,ldb,lwork,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      integer(c_int) :: lwork
      integer(c_int) :: batch_count
      !
      cusolverZpotrsBatched_bufferSize_rank_1 = &
&cusolverZpotrsBatched_bufferSize_(handle,uplo,n,nrhs,c_loc(A),lda,&
&c_loc(B),ldb,lwork,batch_count)
    end function

    function cusolverSpotrsBatched_full_rank(handle,uplo,n,nrhs,A,lda,&
&B,ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverSpotrsBatched_full_rank = cusolverSpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverSpotrsBatched_rank_0(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverSpotrsBatched_rank_0 = cusolverSpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverSpotrsBatched_rank_1(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSpotrsBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverSpotrsBatched_rank_1 = cusolverSpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverDpotrsBatched_full_rank(handle,uplo,n,nrhs,A,lda,&
&B,ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverDpotrsBatched_full_rank = cusolverDpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverDpotrsBatched_rank_0(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverDpotrsBatched_rank_0 = cusolverDpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverDpotrsBatched_rank_1(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDpotrsBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverDpotrsBatched_rank_1 = cusolverDpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverCpotrsBatched_full_rank(handle,uplo,n,nrhs,A,lda,&
&B,ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverCpotrsBatched_full_rank = cusolverCpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverCpotrsBatched_rank_0(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverCpotrsBatched_rank_0 = cusolverCpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverCpotrsBatched_rank_1(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCpotrsBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverCpotrsBatched_rank_1 = cusolverCpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverZpotrsBatched_full_rank(handle,uplo,n,nrhs,A,lda,&
&B,ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:,:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:,:,:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverZpotrsBatched_full_rank = cusolverZpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverZpotrsBatched_rank_0(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverZpotrsBatched_rank_0 = cusolverZpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverZpotrsBatched_rank_1(handle,uplo,n,nrhs,A,lda,B,&
&ldb,work,lwork,devInfo,batch_count)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZpotrsBatched_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      integer(c_int) :: nrhs
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      integer(c_int) :: batch_count
      !
      cusolverZpotrsBatched_rank_1 = cusolverZpotrsBatched_(handle,&
&uplo,n,nrhs,c_loc(A),lda,c_loc(B),ldb,work,lwork,devInfo,batch_count)
    end function

    function cusolverSsyevd_bufferSize_full_rank(handle,jobz,uplo,n,A,&
&lda,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsyevd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverSsyevd_bufferSize_full_rank = &
&cusolverSsyevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverSsyevd_bufferSize_rank_0(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsyevd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      integer(c_int) :: lwork
      !
      cusolverSsyevd_bufferSize_rank_0 = &
&cusolverSsyevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverSsyevd_bufferSize_rank_1(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsyevd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverSsyevd_bufferSize_rank_1 = &
&cusolverSsyevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverDsyevd_bufferSize_full_rank(handle,jobz,uplo,n,A,&
&lda,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsyevd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverDsyevd_bufferSize_full_rank = &
&cusolverDsyevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverDsyevd_bufferSize_rank_0(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsyevd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      integer(c_int) :: lwork
      !
      cusolverDsyevd_bufferSize_rank_0 = &
&cusolverDsyevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverDsyevd_bufferSize_rank_1(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsyevd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverDsyevd_bufferSize_rank_1 = &
&cusolverDsyevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverCheevd_bufferSize_full_rank(handle,jobz,uplo,n,A,&
&lda,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCheevd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverCheevd_bufferSize_full_rank = &
&cusolverCheevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverCheevd_bufferSize_rank_0(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCheevd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      integer(c_int) :: lwork
      !
      cusolverCheevd_bufferSize_rank_0 = &
&cusolverCheevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverCheevd_bufferSize_rank_1(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCheevd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverCheevd_bufferSize_rank_1 = &
&cusolverCheevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverZheevd_bufferSize_full_rank(handle,jobz,uplo,n,A,&
&lda,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZheevd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverZheevd_bufferSize_full_rank = &
&cusolverZheevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverZheevd_bufferSize_rank_0(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZheevd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      integer(c_int) :: lwork
      !
      cusolverZheevd_bufferSize_rank_0 = &
&cusolverZheevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverZheevd_bufferSize_rank_1(handle,jobz,uplo,n,A,lda,&
&D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZheevd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverZheevd_bufferSize_rank_1 = &
&cusolverZheevd_bufferSize_(handle,jobz,uplo,n,c_loc(A),lda,c_loc(D),&
&lwork)
    end function

    function cusolverSsyevd_full_rank(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsyevd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsyevd_full_rank = cusolverSsyevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverSsyevd_rank_0(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsyevd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsyevd_rank_0 = cusolverSsyevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverSsyevd_rank_1(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsyevd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsyevd_rank_1 = cusolverSsyevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverDsyevd_full_rank(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsyevd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsyevd_full_rank = cusolverDsyevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverDsyevd_rank_0(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsyevd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsyevd_rank_0 = cusolverDsyevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverDsyevd_rank_1(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsyevd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsyevd_rank_1 = cusolverDsyevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverCheevd_full_rank(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCheevd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCheevd_full_rank = cusolverCheevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverCheevd_rank_0(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCheevd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCheevd_rank_0 = cusolverCheevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverCheevd_rank_1(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCheevd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCheevd_rank_1 = cusolverCheevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverZheevd_full_rank(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZheevd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZheevd_full_rank = cusolverZheevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverZheevd_rank_0(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZheevd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZheevd_rank_0 = cusolverZheevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverZheevd_rank_1(handle,jobz,uplo,n,A,lda,D,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZheevd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZheevd_rank_1 = cusolverZheevd_(handle,jobz,uplo,n,&
&c_loc(A),lda,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverSsygvd_bufferSize_full_rank(handle,itype,jobz,&
&uplo,n,A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsygvd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverSsygvd_bufferSize_full_rank = &
&cusolverSsygvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverSsygvd_bufferSize_rank_0(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsygvd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: B
      integer(c_int) :: ldb
      real(c_float),target :: D
      integer(c_int) :: lwork
      !
      cusolverSsygvd_bufferSize_rank_0 = &
&cusolverSsygvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverSsygvd_bufferSize_rank_1(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsygvd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverSsygvd_bufferSize_rank_1 = &
&cusolverSsygvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverDsygvd_bufferSize_full_rank(handle,itype,jobz,&
&uplo,n,A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsygvd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverDsygvd_bufferSize_full_rank = &
&cusolverDsygvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverDsygvd_bufferSize_rank_0(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsygvd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: B
      integer(c_int) :: ldb
      real(c_double),target :: D
      integer(c_int) :: lwork
      !
      cusolverDsygvd_bufferSize_rank_0 = &
&cusolverDsygvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverDsygvd_bufferSize_rank_1(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsygvd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverDsygvd_bufferSize_rank_1 = &
&cusolverDsygvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverChegvd_bufferSize_full_rank(handle,itype,jobz,&
&uplo,n,A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChegvd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverChegvd_bufferSize_full_rank = &
&cusolverChegvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverChegvd_bufferSize_rank_0(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChegvd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      real(c_float),target :: D
      integer(c_int) :: lwork
      !
      cusolverChegvd_bufferSize_rank_0 = &
&cusolverChegvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverChegvd_bufferSize_rank_1(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChegvd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverChegvd_bufferSize_rank_1 = &
&cusolverChegvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverZhegvd_bufferSize_full_rank(handle,itype,jobz,&
&uplo,n,A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhegvd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverZhegvd_bufferSize_full_rank = &
&cusolverZhegvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverZhegvd_bufferSize_rank_0(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhegvd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      real(c_double),target :: D
      integer(c_int) :: lwork
      !
      cusolverZhegvd_bufferSize_rank_0 = &
&cusolverZhegvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverZhegvd_bufferSize_rank_1(handle,itype,jobz,uplo,n,&
&A,lda,B,ldb,D,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhegvd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      integer(c_int) :: lwork
      !
      cusolverZhegvd_bufferSize_rank_1 = &
&cusolverZhegvd_bufferSize_(handle,itype,jobz,uplo,n,c_loc(A),lda,&
&c_loc(B),ldb,c_loc(D),lwork)
    end function

    function cusolverSsygvd_full_rank(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsygvd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsygvd_full_rank = cusolverSsygvd_(handle,itype,jobz,&
&uplo,n,c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverSsygvd_rank_0(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsygvd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: B
      integer(c_int) :: ldb
      real(c_float),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsygvd_rank_0 = cusolverSsygvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverSsygvd_rank_1(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsygvd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsygvd_rank_1 = cusolverSsygvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverDsygvd_full_rank(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsygvd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsygvd_full_rank = cusolverDsygvd_(handle,itype,jobz,&
&uplo,n,c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverDsygvd_rank_0(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsygvd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: B
      integer(c_int) :: ldb
      real(c_double),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsygvd_rank_0 = cusolverDsygvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverDsygvd_rank_1(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsygvd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsygvd_rank_1 = cusolverDsygvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverChegvd_full_rank(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChegvd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverChegvd_full_rank = cusolverChegvd_(handle,itype,jobz,&
&uplo,n,c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverChegvd_rank_0(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChegvd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      complex(c_float_complex),target :: B
      integer(c_int) :: ldb
      real(c_float),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverChegvd_rank_0 = cusolverChegvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverChegvd_rank_1(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChegvd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_float),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverChegvd_rank_1 = cusolverChegvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverZhegvd_full_rank(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhegvd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:,:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZhegvd_full_rank = cusolverZhegvd_(handle,itype,jobz,&
&uplo,n,c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverZhegvd_rank_0(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhegvd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      complex(c_double_complex),target :: B
      integer(c_int) :: ldb
      real(c_double),target :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZhegvd_rank_0 = cusolverZhegvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverZhegvd_rank_1(handle,itype,jobz,uplo,n,A,lda,B,&
&ldb,D,work,lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhegvd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_EIG_TYPE_1)) :: itype
      integer(kind(CUSOLVER_EIG_MODE_NOVECTOR)) :: jobz
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int) :: ldb
      real(c_double),target,dimension(:) :: D
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZhegvd_rank_1 = cusolverZhegvd_(handle,itype,jobz,uplo,n,&
&c_loc(A),lda,c_loc(B),ldb,c_loc(D),work,lwork,devInfo)
    end function

    function cusolverSsytrd_bufferSize_full_rank(handle,uplo,n,A,lda,D,&
&E,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSsytrd_bufferSize_full_rank = &
&cusolverSsytrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverSsytrd_bufferSize_rank_0(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      real(c_float),target :: E
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSsytrd_bufferSize_rank_0 = &
&cusolverSsytrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverSsytrd_bufferSize_rank_1(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      real(c_float) :: tau
      integer(c_int) :: lwork
      !
      cusolverSsytrd_bufferSize_rank_1 = &
&cusolverSsytrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverDsytrd_bufferSize_full_rank(handle,uplo,n,A,lda,D,&
&E,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDsytrd_bufferSize_full_rank = &
&cusolverDsytrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverDsytrd_bufferSize_rank_0(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      real(c_double),target :: E
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDsytrd_bufferSize_rank_0 = &
&cusolverDsytrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverDsytrd_bufferSize_rank_1(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      real(c_double) :: tau
      integer(c_int) :: lwork
      !
      cusolverDsytrd_bufferSize_rank_1 = &
&cusolverDsytrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverChetrd_bufferSize_full_rank(handle,uplo,n,A,lda,D,&
&E,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChetrd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverChetrd_bufferSize_full_rank = &
&cusolverChetrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverChetrd_bufferSize_rank_0(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChetrd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      real(c_float),target :: E
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverChetrd_bufferSize_rank_0 = &
&cusolverChetrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverChetrd_bufferSize_rank_1(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverChetrd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      complex(c_float_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverChetrd_bufferSize_rank_1 = &
&cusolverChetrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverZhetrd_bufferSize_full_rank(handle,uplo,n,A,lda,D,&
&E,tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhetrd_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZhetrd_bufferSize_full_rank = &
&cusolverZhetrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverZhetrd_bufferSize_rank_0(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhetrd_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      real(c_double),target :: E
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZhetrd_bufferSize_rank_0 = &
&cusolverZhetrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverZhetrd_bufferSize_rank_1(handle,uplo,n,A,lda,D,E,&
&tau,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZhetrd_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      complex(c_double_complex) :: tau
      integer(c_int) :: lwork
      !
      cusolverZhetrd_bufferSize_rank_1 = &
&cusolverZhetrd_bufferSize_(handle,uplo,n,c_loc(A),lda,c_loc(D),&
&c_loc(E),tau,lwork)
    end function

    function cusolverSsytrd_full_rank(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsytrd_full_rank = cusolverSsytrd_(handle,uplo,n,&
&c_loc(A),lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverSsytrd_rank_0(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      real(c_float),target :: E
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsytrd_rank_0 = cusolverSsytrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverSsytrd_rank_1(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      real(c_float) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsytrd_rank_1 = cusolverSsytrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverDsytrd_full_rank(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsytrd_full_rank = cusolverDsytrd_(handle,uplo,n,&
&c_loc(A),lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverDsytrd_rank_0(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      real(c_double),target :: E
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsytrd_rank_0 = cusolverDsytrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverDsytrd_rank_1(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      real(c_double) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsytrd_rank_1 = cusolverDsytrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverChetrd_full_rank(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChetrd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverChetrd_full_rank = cusolverChetrd_(handle,uplo,n,&
&c_loc(A),lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverChetrd_rank_0(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChetrd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      real(c_float),target :: D
      real(c_float),target :: E
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverChetrd_rank_0 = cusolverChetrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverChetrd_rank_1(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverChetrd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_float),target,dimension(:) :: D
      real(c_float),target,dimension(:) :: E
      complex(c_float_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverChetrd_rank_1 = cusolverChetrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverZhetrd_full_rank(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhetrd_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZhetrd_full_rank = cusolverZhetrd_(handle,uplo,n,&
&c_loc(A),lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverZhetrd_rank_0(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhetrd_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      real(c_double),target :: D
      real(c_double),target :: E
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZhetrd_rank_0 = cusolverZhetrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverZhetrd_rank_1(handle,uplo,n,A,lda,D,E,tau,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZhetrd_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      real(c_double),target,dimension(:) :: D
      real(c_double),target,dimension(:) :: E
      complex(c_double_complex) :: tau
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZhetrd_rank_1 = cusolverZhetrd_(handle,uplo,n,c_loc(A),&
&lda,c_loc(D),c_loc(E),tau,work,lwork,devInfo)
    end function

    function cusolverSsytrf_bufferSize_full_rank(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSsytrf_bufferSize_full_rank = &
&cusolverSsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverSsytrf_bufferSize_rank_0(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSsytrf_bufferSize_rank_0 = &
&cusolverSsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverSsytrf_bufferSize_rank_1(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverSsytrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverSsytrf_bufferSize_rank_1 = &
&cusolverSsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverDsytrf_bufferSize_full_rank(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDsytrf_bufferSize_full_rank = &
&cusolverDsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverDsytrf_bufferSize_rank_0(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDsytrf_bufferSize_rank_0 = &
&cusolverDsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverDsytrf_bufferSize_rank_1(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverDsytrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverDsytrf_bufferSize_rank_1 = &
&cusolverDsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverCsytrf_bufferSize_full_rank(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCsytrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCsytrf_bufferSize_full_rank = &
&cusolverCsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverCsytrf_bufferSize_rank_0(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCsytrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCsytrf_bufferSize_rank_0 = &
&cusolverCsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverCsytrf_bufferSize_rank_1(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverCsytrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverCsytrf_bufferSize_rank_1 = &
&cusolverCsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverZsytrf_bufferSize_full_rank(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZsytrf_bufferSize_full_rank
      type(c_ptr) :: handle
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZsytrf_bufferSize_full_rank = &
&cusolverZsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverZsytrf_bufferSize_rank_0(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZsytrf_bufferSize_rank_0
      type(c_ptr) :: handle
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZsytrf_bufferSize_rank_0 = &
&cusolverZsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverZsytrf_bufferSize_rank_1(handle,n,A,lda,lwork)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: &
&cusolverZsytrf_bufferSize_rank_1
      type(c_ptr) :: handle
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      integer(c_int) :: lwork
      !
      cusolverZsytrf_bufferSize_rank_1 = &
&cusolverZsytrf_bufferSize_(handle,n,c_loc(A),lda,lwork)
    end function

    function cusolverSsytrf_full_rank(handle,uplo,n,A,lda,ipiv,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsytrf_full_rank = cusolverSsytrf_(handle,uplo,n,&
&c_loc(A),lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverSsytrf_rank_0(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsytrf_rank_0 = cusolverSsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverSsytrf_rank_1(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverSsytrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_float),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverSsytrf_rank_1 = cusolverSsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverDsytrf_full_rank(handle,uplo,n,A,lda,ipiv,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsytrf_full_rank = cusolverDsytrf_(handle,uplo,n,&
&c_loc(A),lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverDsytrf_rank_0(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsytrf_rank_0 = cusolverDsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverDsytrf_rank_1(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverDsytrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      real(c_double),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverDsytrf_rank_1 = cusolverDsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverCsytrf_full_rank(handle,uplo,n,A,lda,ipiv,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCsytrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCsytrf_full_rank = cusolverCsytrf_(handle,uplo,n,&
&c_loc(A),lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverCsytrf_rank_0(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCsytrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCsytrf_rank_0 = cusolverCsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverCsytrf_rank_1(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverCsytrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverCsytrf_rank_1 = cusolverCsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverZsytrf_full_rank(handle,uplo,n,A,lda,ipiv,work,&
&lwork,devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZsytrf_full_rank
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:,:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZsytrf_full_rank = cusolverZsytrf_(handle,uplo,n,&
&c_loc(A),lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverZsytrf_rank_0(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZsytrf_rank_0
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZsytrf_rank_0 = cusolverZsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

    function cusolverZsytrf_rank_1(handle,uplo,n,A,lda,ipiv,work,lwork,&
&devInfo)
      use iso_c_binding
      use cudafor_cusolver_enums
      implicit none
      integer(kind(CUSOLVER_STATUS_SUCCESS)) :: cusolverZsytrf_rank_1
      type(c_ptr) :: handle
      integer(kind(CUSOLVER_FILL_MODE_UPPER)) :: uplo
      integer(c_int) :: n
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int) :: lda
      type(c_ptr) :: ipiv
      type(c_ptr) :: work
      integer(c_int) :: lwork
      integer(c_int) :: devInfo
      !
      cusolverZsytrf_rank_1 = cusolverZsytrf_(handle,uplo,n,c_loc(A),&
&lda,ipiv,work,lwork,devInfo)
    end function

  
end module cudafor_cusolver