


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ==============================================================================
! hipfort: FORTRAN Interfaces for GPU kernels
! ==============================================================================
! Copyright (c) 2020-2022 Advanced Micro Devices, Inc. All rights reserved.
! [MITx11 License]
! 
! Permission is hereby granted, free of charge, to any person obtaining a copy
! of this software and associated documentation files (the "Software"), to deal
! in the Software without restriction, including without limitation the rights
! to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
! copies of the Software, and to permit persons to whom the Software is
! furnished to do so, subject to the following conditions:
! 
! The above copyright notice and this permission notice shall be included in
! all copies or substantial portions of the Software.
! 
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
! IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
! FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
! AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
! LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
! OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
! THE SOFTWARE.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!

module cudafor_cublas_auxiliary

  interface cublasSetVector
    function cublasSetVector_(n,elem_size,x,incx,y,incy) bind(c, &
&name="cublasSetVector") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),value :: elem_size
      type(c_ptr),value :: x
      integer(c_int),value :: incx
      type(c_ptr),value :: y
      integer(c_int),value :: incy
    end function

    module procedure cublasSetVector_l_rank_0,&
&cublasSetVector_l_full_rank,&
      cublasSetVector_i4_rank_0,cublasSetVector_i4_full_rank,&
      cublasSetVector_i8_rank_0,cublasSetVector_i8_full_rank,&
      cublasSetVector_r4_rank_0,cublasSetVector_r4_full_rank,&
      cublasSetVector_r8_rank_0,cublasSetVector_r8_full_rank,&
      cublasSetVector_c4_rank_0,cublasSetVector_c4_full_rank,&
      cublasSetVector_c8_rank_0,cublasSetVector_c8_full_rank 
  end interface

  interface cublasGetVector
    function cublasGetVector_(n,elem_size,x,incx,y,incy) bind(c, &
&name="cublasGetVector") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),value :: elem_size
      type(c_ptr),value :: x
      integer(c_int),value :: incx
      type(c_ptr),value :: y
      integer(c_int),value :: incy
    end function

    module procedure cublasGetVector_l_rank_0,&
&cublasGetVector_l_full_rank,&
      cublasGetVector_i4_rank_0,cublasGetVector_i4_full_rank,&
      cublasGetVector_i8_rank_0,cublasGetVector_i8_full_rank,&
      cublasGetVector_r4_rank_0,cublasGetVector_r4_full_rank,&
      cublasGetVector_r8_rank_0,cublasGetVector_r8_full_rank,&
      cublasGetVector_c4_rank_0,cublasGetVector_c4_full_rank,&
      cublasGetVector_c8_rank_0,cublasGetVector_c8_full_rank 
  end interface

  interface cublasSetMatrix
    function cublasSetMatrix_(rows,cols,elem_size,A,lda,B,ldb) bind(c, &
&name="cublasSetMatrix") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),value :: elem_size
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
    end function

    module procedure cublasSetMatrix_l_full_rank,&
&cublasSetMatrix_l_rank_0,cublasSetMatrix_l_rank_1,&
      cublasSetMatrix_i4_full_rank,cublasSetMatrix_i4_rank_0,&
&cublasSetMatrix_i4_rank_1,&
      cublasSetMatrix_i8_full_rank,cublasSetMatrix_i8_rank_0,&
&cublasSetMatrix_i8_rank_1,&
      cublasSetMatrix_r4_full_rank,cublasSetMatrix_r4_rank_0,&
&cublasSetMatrix_r4_rank_1,&
      cublasSetMatrix_r8_full_rank,cublasSetMatrix_r8_rank_0,&
&cublasSetMatrix_r8_rank_1,&
      cublasSetMatrix_c4_full_rank,cublasSetMatrix_c4_rank_0,&
&cublasSetMatrix_c4_rank_1,&
      cublasSetMatrix_c8_full_rank,cublasSetMatrix_c8_rank_0,&
&cublasSetMatrix_c8_rank_1 
  end interface

  interface cublasGetMatrix
    function cublasGetMatrix_(rows,cols,elem_size,A,lda,B,ldb) bind(c, &
&name="cublasGetMatrix") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),value :: elem_size
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
    end function

    module procedure cublasGetMatrix_l_full_rank,&
&cublasGetMatrix_l_rank_0,cublasGetMatrix_l_rank_1,&
      cublasGetMatrix_i4_full_rank,cublasGetMatrix_i4_rank_0,&
&cublasGetMatrix_i4_rank_1,&
      cublasGetMatrix_i8_full_rank,cublasGetMatrix_i8_rank_0,&
&cublasGetMatrix_i8_rank_1,&
      cublasGetMatrix_r4_full_rank,cublasGetMatrix_r4_rank_0,&
&cublasGetMatrix_r4_rank_1,&
      cublasGetMatrix_r8_full_rank,cublasGetMatrix_r8_rank_0,&
&cublasGetMatrix_r8_rank_1,&
      cublasGetMatrix_c4_full_rank,cublasGetMatrix_c4_rank_0,&
&cublasGetMatrix_c4_rank_1,&
      cublasGetMatrix_c8_full_rank,cublasGetMatrix_c8_rank_0,&
&cublasGetMatrix_c8_rank_1 
  end interface

  interface cublasSetVectorAsync
    function cublasSetVectorAsync_(n,elem_size,x,incx,y,incy,stream) &
&bind(c, name="cublasSetVectorAsync") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),value :: elem_size
      type(c_ptr),value :: x
      integer(c_int),value :: incx
      type(c_ptr),value :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
    end function

    module procedure cublasSetVectorAsync_l_rank_0,&
&cublasSetVectorAsync_l_full_rank,&
      cublasSetVectorAsync_i4_rank_0,cublasSetVectorAsync_i4_full_rank,&
      cublasSetVectorAsync_i8_rank_0,cublasSetVectorAsync_i8_full_rank,&
      cublasSetVectorAsync_r4_rank_0,cublasSetVectorAsync_r4_full_rank,&
      cublasSetVectorAsync_r8_rank_0,cublasSetVectorAsync_r8_full_rank,&
      cublasSetVectorAsync_c4_rank_0,cublasSetVectorAsync_c4_full_rank,&
      cublasSetVectorAsync_c8_rank_0,cublasSetVectorAsync_c8_full_rank 
  end interface

  interface cublasGetVectorAsync
    function cublasGetVectorAsync_(n,elem_size,x,incx,y,incy,stream) &
&bind(c, name="cublasGetVectorAsync") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),value :: elem_size
      type(c_ptr),value :: x
      integer(c_int),value :: incx
      type(c_ptr),value :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
    end function

    module procedure cublasGetVectorAsync_l_rank_0,&
&cublasGetVectorAsync_l_full_rank,&
      cublasGetVectorAsync_i4_rank_0,cublasGetVectorAsync_i4_full_rank,&
      cublasGetVectorAsync_i8_rank_0,cublasGetVectorAsync_i8_full_rank,&
      cublasGetVectorAsync_r4_rank_0,cublasGetVectorAsync_r4_full_rank,&
      cublasGetVectorAsync_r8_rank_0,cublasGetVectorAsync_r8_full_rank,&
      cublasGetVectorAsync_c4_rank_0,cublasGetVectorAsync_c4_full_rank,&
      cublasGetVectorAsync_c8_rank_0,cublasGetVectorAsync_c8_full_rank 
  end interface

  interface cublasSetMatrixAsync
    function cublasSetMatrixAsync_(rows,cols,elem_size,A,lda,B,ldb,&
&stream) bind(c, name="cublasSetMatrixAsync") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),value :: elem_size
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
    end function

    module procedure cublasSetMatrixAsync_l_full_rank,&
&cublasSetMatrixAsync_l_rank_0,cublasSetMatrixAsync_l_rank_1,&
      cublasSetMatrixAsync_i4_full_rank,cublasSetMatrixAsync_i4_rank_0,&
&cublasSetMatrixAsync_i4_rank_1,&
      cublasSetMatrixAsync_i8_full_rank,cublasSetMatrixAsync_i8_rank_0,&
&cublasSetMatrixAsync_i8_rank_1,&
      cublasSetMatrixAsync_r4_full_rank,cublasSetMatrixAsync_r4_rank_0,&
&cublasSetMatrixAsync_r4_rank_1,&
      cublasSetMatrixAsync_r8_full_rank,cublasSetMatrixAsync_r8_rank_0,&
&cublasSetMatrixAsync_r8_rank_1,&
      cublasSetMatrixAsync_c4_full_rank,cublasSetMatrixAsync_c4_rank_0,&
&cublasSetMatrixAsync_c4_rank_1,&
      cublasSetMatrixAsync_c8_full_rank,cublasSetMatrixAsync_c8_rank_0,&
&cublasSetMatrixAsync_c8_rank_1 
  end interface

  interface cublasGetMatrixAsync
    function cublasGetMatrixAsync_(rows,cols,elem_size,A,lda,B,ldb,&
&stream) bind(c, name="cublasGetMatrixAsync") result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),value :: elem_size
      type(c_ptr),value :: A
      integer(c_int),value :: lda
      type(c_ptr),value :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
    end function

    module procedure cublasGetMatrixAsync_l_full_rank,&
&cublasGetMatrixAsync_l_rank_0,cublasGetMatrixAsync_l_rank_1,&
      cublasGetMatrixAsync_i4_full_rank,cublasGetMatrixAsync_i4_rank_0,&
&cublasGetMatrixAsync_i4_rank_1,&
      cublasGetMatrixAsync_i8_full_rank,cublasGetMatrixAsync_i8_rank_0,&
&cublasGetMatrixAsync_i8_rank_1,&
      cublasGetMatrixAsync_r4_full_rank,cublasGetMatrixAsync_r4_rank_0,&
&cublasGetMatrixAsync_r4_rank_1,&
      cublasGetMatrixAsync_r8_full_rank,cublasGetMatrixAsync_r8_rank_0,&
&cublasGetMatrixAsync_r8_rank_1,&
      cublasGetMatrixAsync_c4_full_rank,cublasGetMatrixAsync_c4_rank_0,&
&cublasGetMatrixAsync_c4_rank_1,&
      cublasGetMatrixAsync_c8_full_rank,cublasGetMatrixAsync_c8_rank_0,&
&cublasGetMatrixAsync_c8_rank_1 
  end interface

contains

    function cublasSetVector_l_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target :: x
      integer(c_int),value :: incx
      logical(c_bool),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,1,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_l_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target,dimension(:) :: x
      integer(c_int),value :: incx
      logical(c_bool),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,1,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_l_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target :: x
      integer(c_int),value :: incx
      logical(c_bool),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,1,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_l_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target,dimension(:) :: x
      integer(c_int),value :: incx
      logical(c_bool),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,1,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_l_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:,:) :: A
      logical(c_bool),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,1,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_l_rank_0(rows,cols,A,lda,B,ldb) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target :: A
      integer(c_int),value :: lda
      logical(c_bool),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,1,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_l_rank_1(rows,cols,A,lda,B,ldb) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:) :: A
      integer(c_int),value :: lda
      logical(c_bool),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,1,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_l_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:,:) :: A
      logical(c_bool),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,1,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_l_rank_0(rows,cols,A,lda,B,ldb) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target :: A
      integer(c_int),value :: lda
      logical(c_bool),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,1,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_l_rank_1(rows,cols,A,lda,B,ldb) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:) :: A
      integer(c_int),value :: lda
      logical(c_bool),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,1,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_l_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target :: x
      integer(c_int),value :: incx
      logical(c_bool),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,1,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_l_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target,dimension(:) :: x
      integer(c_int),value :: incx
      logical(c_bool),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,1,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_l_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target :: x
      integer(c_int),value :: incx
      logical(c_bool),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,1,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_l_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      logical(c_bool),target,dimension(:) :: x
      integer(c_int),value :: incx
      logical(c_bool),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,1,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_l_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:,:) :: A
      logical(c_bool),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,1,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_l_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target :: A
      integer(c_int),value :: lda
      logical(c_bool),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,1,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_l_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:) :: A
      integer(c_int),value :: lda
      logical(c_bool),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,1,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_l_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:,:) :: A
      logical(c_bool),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,1,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_l_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target :: A
      integer(c_int),value :: lda
      logical(c_bool),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,1,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_l_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      logical(c_bool),target,dimension(:) :: A
      integer(c_int),value :: lda
      logical(c_bool),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,1,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
    function cublasSetVector_i4_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target :: x
      integer(c_int),value :: incx
      integer(c_int),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_i4_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_int),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_i4_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target :: x
      integer(c_int),value :: incx
      integer(c_int),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_i4_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_int),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_i4_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:,:) :: A
      integer(c_int),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,4,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_i4_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target :: A
      integer(c_int),value :: lda
      integer(c_int),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_i4_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_int),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_i4_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:,:) :: A
      integer(c_int),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,4,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_i4_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target :: A
      integer(c_int),value :: lda
      integer(c_int),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_i4_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_int),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_i4_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target :: x
      integer(c_int),value :: incx
      integer(c_int),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_i4_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_int),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_i4_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target :: x
      integer(c_int),value :: incx
      integer(c_int),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_i4_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_int),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_int),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_i4_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:,:) :: A
      integer(c_int),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,4,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_i4_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target :: A
      integer(c_int),value :: lda
      integer(c_int),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_i4_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_int),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_i4_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:,:) :: A
      integer(c_int),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,4,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_i4_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target :: A
      integer(c_int),value :: lda
      integer(c_int),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_i4_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_int),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_int),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
    function cublasSetVector_i8_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target :: x
      integer(c_int),value :: incx
      integer(c_long),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_i8_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_long),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_i8_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target :: x
      integer(c_int),value :: incx
      integer(c_long),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_i8_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_long),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_i8_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:,:) :: A
      integer(c_long),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,8,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_i8_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target :: A
      integer(c_int),value :: lda
      integer(c_long),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_i8_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_long),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_i8_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:,:) :: A
      integer(c_long),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,8,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_i8_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target :: A
      integer(c_int),value :: lda
      integer(c_long),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_i8_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_long),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_i8_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target :: x
      integer(c_int),value :: incx
      integer(c_long),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_i8_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_long),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_i8_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target :: x
      integer(c_int),value :: incx
      integer(c_long),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_i8_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      integer(c_long),target,dimension(:) :: x
      integer(c_int),value :: incx
      integer(c_long),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_i8_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:,:) :: A
      integer(c_long),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,8,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_i8_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target :: A
      integer(c_int),value :: lda
      integer(c_long),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_i8_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_long),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_i8_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:,:) :: A
      integer(c_long),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,8,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_i8_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target :: A
      integer(c_int),value :: lda
      integer(c_long),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_i8_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      integer(c_long),target,dimension(:) :: A
      integer(c_int),value :: lda
      integer(c_long),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
    function cublasSetVector_r4_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target :: x
      integer(c_int),value :: incx
      real(c_float),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_r4_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_float),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_r4_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target :: x
      integer(c_int),value :: incx
      real(c_float),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_r4_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_float),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_r4_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:,:) :: A
      real(c_float),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,4,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_r4_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target :: A
      integer(c_int),value :: lda
      real(c_float),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_r4_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_r4_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:,:) :: A
      real(c_float),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,4,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_r4_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target :: A
      integer(c_int),value :: lda
      real(c_float),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_r4_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_r4_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target :: x
      integer(c_int),value :: incx
      real(c_float),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_r4_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_float),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_r4_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target :: x
      integer(c_int),value :: incx
      real(c_float),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_r4_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_float),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_float),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_r4_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:,:) :: A
      real(c_float),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,4,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_r4_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target :: A
      integer(c_int),value :: lda
      real(c_float),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_r4_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_r4_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:,:) :: A
      real(c_float),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,4,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_r4_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target :: A
      integer(c_int),value :: lda
      real(c_float),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_r4_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_float),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_float),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
    function cublasSetVector_r8_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target :: x
      integer(c_int),value :: incx
      real(c_double),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_r8_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_double),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_r8_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target :: x
      integer(c_int),value :: incx
      real(c_double),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_r8_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_double),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_r8_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:,:) :: A
      real(c_double),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,8,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_r8_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target :: A
      integer(c_int),value :: lda
      real(c_double),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_r8_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_r8_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:,:) :: A
      real(c_double),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,8,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_r8_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target :: A
      integer(c_int),value :: lda
      real(c_double),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_r8_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_r8_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target :: x
      integer(c_int),value :: incx
      real(c_double),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_r8_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_double),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_r8_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target :: x
      integer(c_int),value :: incx
      real(c_double),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_r8_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      real(c_double),target,dimension(:) :: x
      integer(c_int),value :: incx
      real(c_double),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_r8_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:,:) :: A
      real(c_double),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,8,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_r8_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target :: A
      integer(c_int),value :: lda
      real(c_double),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_r8_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_r8_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:,:) :: A
      real(c_double),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,8,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_r8_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target :: A
      integer(c_int),value :: lda
      real(c_double),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_r8_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      real(c_double),target,dimension(:) :: A
      integer(c_int),value :: lda
      real(c_double),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
    function cublasSetVector_c4_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,2*4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_c4_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,2*4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_c4_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,2*4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_c4_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,2*4,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_c4_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:,:) :: A
      complex(c_float_complex),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,2*4,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_c4_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,2*4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_c4_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,2*4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_c4_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:,:) :: A
      complex(c_float_complex),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,2*4,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_c4_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,2*4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_c4_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,2*4,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_c4_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,2*4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_c4_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,2*4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_c4_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,2*4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_c4_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_float_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_float_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,2*4,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_c4_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:,:) :: A
      complex(c_float_complex),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,2*4,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_c4_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,2*4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_c4_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,2*4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_c4_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:,:) :: A
      complex(c_float_complex),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,2*4,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_c4_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,2*4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_c4_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_float_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_float_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,2*4,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
    function cublasSetVector_c8_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,2*8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetVector_c8_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasSetVector_(n,2*8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_c8_rank_0(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,2*8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasGetVector_c8_full_rank(n,x,incx,y,incy) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      !
      ret = cublasGetVector_(n,2*8,c_loc(x),incx,c_loc(y),incy)
    end function

    function cublasSetMatrix_c8_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:,:) :: A
      complex(c_double_complex),target,dimension(:,:) :: B
      !
      ret = cublasSetMatrix_(rows,cols,2*8,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasSetMatrix_c8_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,2*8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetMatrix_c8_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasSetMatrix_(rows,cols,2*8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_c8_full_rank(rows,cols,A,B) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:,:) :: A
      complex(c_double_complex),target,dimension(:,:) :: B
      !
      ret = cublasGetMatrix_(rows,cols,2*8,c_loc(A),size(A,1),c_loc(B),&
&size(B,1))
    end function

    function cublasGetMatrix_c8_rank_0(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,2*8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasGetMatrix_c8_rank_1(rows,cols,A,lda,B,ldb) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      !
      ret = cublasGetMatrix_(rows,cols,2*8,c_loc(A),lda,c_loc(B),ldb)
    end function

    function cublasSetVectorAsync_c8_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,2*8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetVectorAsync_c8_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasSetVectorAsync_(n,2*8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_c8_rank_0(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,2*8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasGetVectorAsync_c8_full_rank(n,x,incx,y,incy,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: n
      complex(c_double_complex),target,dimension(:) :: x
      integer(c_int),value :: incx
      complex(c_double_complex),target,dimension(:) :: y
      integer(c_int),value :: incy
      type(c_ptr),value :: stream
      !
      ret = cublasGetVectorAsync_(n,2*8,c_loc(x),incx,c_loc(y),incy,&
&stream)
    end function

    function cublasSetMatrixAsync_c8_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:,:) :: A
      complex(c_double_complex),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,2*8,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasSetMatrixAsync_c8_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,2*8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasSetMatrixAsync_c8_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasSetMatrixAsync_(rows,cols,2*8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_c8_full_rank(rows,cols,A,B,stream) &
&result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:,:) :: A
      complex(c_double_complex),target,dimension(:,:) :: B
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,2*8,c_loc(A),size(A,1),&
&c_loc(B),size(B,1),stream)
    end function

    function cublasGetMatrixAsync_c8_rank_0(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,2*8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function

    function cublasGetMatrixAsync_c8_rank_1(rows,cols,A,lda,B,ldb,&
&stream) result(ret)
      use iso_c_binding
      use cudafor_cublas_enums
      implicit none
      integer(kind(CUBLAS_STATUS_SUCCESS)) :: ret
      integer(c_int),value :: rows
      integer(c_int),value :: cols
      complex(c_double_complex),target,dimension(:) :: A
      integer(c_int),value :: lda
      complex(c_double_complex),target,dimension(:) :: B
      integer(c_int),value :: ldb
      type(c_ptr),value :: stream
      !
      ret = cublasGetMatrixAsync_(rows,cols,2*8,c_loc(A),lda,c_loc(B),&
&ldb,stream)
    end function
 

end module