/*
 * Copyright 1993-2017 NVIDIA Corporation.  All rights reserved.
 *
 * NOTICE TO LICENSEE:
 *
 * This source code and/or documentation ("Licensed Deliverables") are
 * subject to NVIDIA intellectual property rights under U.S. and
 * international Copyright laws.
 *
 * These Licensed Deliverables contained herein is PROPRIETARY and
 * CONFIDENTIAL to NVIDIA and is being provided under the terms and
 * conditions of a form of NVIDIA software license agreement by and
 * between NVIDIA and Licensee ("License Agreement") or electronically
 * accepted by Licensee.  Notwithstanding any terms or conditions to
 * the contrary in the License Agreement, reproduction or disclosure
 * of the Licensed Deliverables to any third party without the express
 * written consent of NVIDIA is prohibited.
 *
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, NVIDIA MAKES NO REPRESENTATION ABOUT THE
 * SUITABILITY OF THESE LICENSED DELIVERABLES FOR ANY PURPOSE.  IT IS
 * PROVIDED "AS IS" WITHOUT EXPRESS OR IMPLIED WARRANTY OF ANY KIND.
 * NVIDIA DISCLAIMS ALL WARRANTIES WITH REGARD TO THESE LICENSED
 * DELIVERABLES, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY,
 * NONINFRINGEMENT, AND FITNESS FOR A PARTICULAR PURPOSE.
 * NOTWITHSTANDING ANY TERMS OR CONDITIONS TO THE CONTRARY IN THE
 * LICENSE AGREEMENT, IN NO EVENT SHALL NVIDIA BE LIABLE FOR ANY
 * SPECIAL, INDIRECT, INCIDENTAL, OR CONSEQUENTIAL DAMAGES, OR ANY
 * DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
 * ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE
 * OF THESE LICENSED DELIVERABLES.
 *
 * U.S. Government End Users.  These Licensed Deliverables are a
 * "commercial item" as that term is defined at 48 C.F.R. 2.101 (OCT
 * 1995), consisting of "commercial computer software" and "commercial
 * computer software documentation" as such terms are used in 48
 * C.F.R. 12.212 (SEPT 1995) and is provided to the U.S. Government
 * only as a commercial end item.  Consistent with 48 C.F.R.12.212 and
 * 48 C.F.R. 227.7202-1 through 227.7202-4 (JUNE 1995), all
 * U.S. Government End Users acquire the Licensed Deliverables with
 * only those rights set forth herein.
 *
 * Any use of the Licensed Deliverables in individual and commercial
 * software must include, in the user documentation and internal
 * comments to the code, the above Disclaimer and U.S. Government End
 * Users Notice.
 */


#ifndef __TEXTURE_INDIRECT_FUNCTIONS_H__
#define __TEXTURE_INDIRECT_FUNCTIONS_H__


#if defined(__cplusplus) && defined(__CUDACC__)

#include "cuda_runtime_api.h"
#include "ockl_image_internal.h"

#if !defined(__CUDA_ARCH__) || (__CUDA_ARCH__ >= 600)
#define __NV_TEX_SPARSE 1
#endif  /* endif */

#ifndef __CUDA_HIP_PLATFORM_AMD__
template <typename T> struct __nv_itex_trait {   };
template<> struct __nv_itex_trait<char> { typedef void type; };
template<> struct __nv_itex_trait<signed char> { typedef void type; };
template<> struct __nv_itex_trait<char1> { typedef void type; };
template<> struct __nv_itex_trait<char2> { typedef void type; };
template<> struct __nv_itex_trait<char4> { typedef void type; };
template<> struct __nv_itex_trait<unsigned char> { typedef void type; };
template<> struct __nv_itex_trait<uchar1> { typedef void type; };
template<> struct __nv_itex_trait<uchar2> { typedef void type; };
template<> struct __nv_itex_trait<uchar4> { typedef void type; };
template<> struct __nv_itex_trait<short> { typedef void type; };
template<> struct __nv_itex_trait<short1> { typedef void type; };
template<> struct __nv_itex_trait<short2> { typedef void type; };
template<> struct __nv_itex_trait<short4> { typedef void type; };
template<> struct __nv_itex_trait<unsigned short> { typedef void type; };
template<> struct __nv_itex_trait<ushort1> { typedef void type; };
template<> struct __nv_itex_trait<ushort2> { typedef void type; };
template<> struct __nv_itex_trait<ushort4> { typedef void type; };
template<> struct __nv_itex_trait<int> { typedef void type; };
template<> struct __nv_itex_trait<int1> { typedef void type; };
template<> struct __nv_itex_trait<int2> { typedef void type; };
template<> struct __nv_itex_trait<int4> { typedef void type; };
template<> struct __nv_itex_trait<unsigned int> { typedef void type; };
template<> struct __nv_itex_trait<uint1> { typedef void type; };
template<> struct __nv_itex_trait<uint2> { typedef void type; };
template<> struct __nv_itex_trait<uint4> { typedef void type; };
#if !defined(__LP64__)
template<> struct __nv_itex_trait<long> { typedef void type; };
template<> struct __nv_itex_trait<long1> { typedef void type; };
template<> struct __nv_itex_trait<long2> { typedef void type; };
template<> struct __nv_itex_trait<long4> { typedef void type; };
template<> struct __nv_itex_trait<unsigned long> { typedef void type; };
template<> struct __nv_itex_trait<ulong1> { typedef void type; };
template<> struct __nv_itex_trait<ulong2> { typedef void type; };
template<> struct __nv_itex_trait<ulong4> { typedef void type; };
#endif /* !__LP64__ */
template<> struct __nv_itex_trait<float> { typedef void type; };
template<> struct __nv_itex_trait<float1> { typedef void type; };
template<> struct __nv_itex_trait<float2> { typedef void type; };
template<> struct __nv_itex_trait<float4> { typedef void type; };

#define TEXTURE_OBJECT_PARAMETERS_INIT                                                            \
    unsigned int ADDRESS_SPACE_CONSTANT* i = (unsigned int ADDRESS_SPACE_CONSTANT*)textureObject; \
    unsigned int ADDRESS_SPACE_CONSTANT* s = i + HIP_SAMPLER_OBJECT_OFFSET_DWORD;

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1Dfetch(T *ptr, cudaTextureObject_t textureObject, int x)
{
#ifdef __CUDA_ARCH__
    *ptr = tex1Dfetch<T>(textureObject, x);
#endif   
}

template <class T>
static __device__ T tex1Dfetch(cudaTextureObject_t textureObject, int x)
{
#ifdef __CUDA_ARCH__

    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_load_1Db(i, x);
    return mapFrom<T>(tmp);
#endif  
}

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1D(T *ptr, cudaTextureObject_t textureObject, float x)
{
#ifdef __CUDA_ARCH__
    *ptr = tex1D<T>(textureObject, x);
#endif
}


template <class T>
static __device__  T tex1D(cudaTextureObject_t textureObject, float x)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_1D(i, s, x);
    return mapFrom<T>(tmp);
#endif
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2D(T *ptr, cudaTextureObject_t textureObject, float x, float y)
{
#ifdef __CUDA_ARCH__
    *ptr = tex2D<T>(textureObject, x, y);
#endif
}

template <class T>
static __device__  T tex2D(cudaTextureObject_t textureObject, float x, float y)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_2D(i, s, make_float2(x, y));
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2D(T *ptr, cudaTextureObject_t obj, float x, float y, 
                                                          bool* isResident)
{
#ifdef __CUDA_ARCH__
  *ptr = tex2D<T>(obj, x, y);
   *isResident = 0;
#endif
}

template <class T>
static __device__  T tex2D(cudaTextureObject_t texObject, float x, float y, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2D(&ret, texObject, x, y, isResident);
  return ret;
#endif  
}

#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex3D(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z)
{
#ifdef __CUDA_ARCH__
    *ptr = tex3D<T>(textureObject, x, y, z);
#endif
}

template <class T>
static __device__  T tex3D(cudaTextureObject_t textureObject, float x, float y, float z)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_3D(i, s, make_float4(x, y, z, 0.0f));
    return mapFrom<T>(tmp);
#endif
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex3D(T *ptr, cudaTextureObject_t obj, float x, float y, float z, 
                                                          bool* isResident)
{
#ifdef __CUDA_ARCH__
  *ptr = tex3D<T>(obj, x, y, z);
   *isResident = 0;
#endif
}

template <class T>
static __device__  T tex3D(cudaTextureObject_t texObject, float x, float y, float z, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex3D(&ret, texObject, x, y, z, isResident);
  return ret;
#endif
}
#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1DLayered(T *ptr, cudaTextureObject_t textureObject, float x, int layer)
{
#ifdef __CUDA_ARCH__
    *ptr = tex1DLayered<T>(textureObject, x, layer);
#endif
}

template <class T>
static __device__  T tex1DLayered(cudaTextureObject_t textureObject, float x, int layer)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_1Da(i, s, make_float2(x, layer));
    return mapFrom<T>(tmp);
#endif
}

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLayered(T *ptr, cudaTextureObject_t textureObject, float x, float y, int layer)
{
#ifdef __CUDA_ARCH__
    *ptr = tex1DLayered<T>(textureObject, x, y, layer);
#endif
}

template <class T>
static __device__  T tex2DLayered(cudaTextureObject_t textureObject, float x, float y, int layer)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_2Da(i, s, make_float4(x, y, layer, 0.0f));
    return mapFrom<T>(tmp);
#endif
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLayered(T *ptr, cudaTextureObject_t obj, float x, float y, int layer, bool* isResident)
{
#ifdef __CUDA_ARCH__
  *ptr = tex1DLayered<T>(obj, x, y, layer);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex2DLayered(cudaTextureObject_t texObject, float x, float y, int layer, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2DLayered(&ret, texObject, x, y, layer, isResident);
  return ret;
#endif
}
#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type texCubemap(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z)
{
#ifdef __CUDA_ARCH__
    *ptr = texCubemap<T>(textureObject, x, y, z);
#endif
}


template <class T>
static __device__  T texCubemap(cudaTextureObject_t textureObject, float x, float y, float z)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_CM(i, s, make_float4(x, y, z, 0.0f));
    return mapFrom<T>(tmp);
#endif
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type texCubemapLayered(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, int layer)
{ 
#ifdef __CUDA_ARCH__
    *ptr = texCubemapLayered<T>(textureObject, x, y, z, layer);
#endif
}

template <class T>
static __device__  T texCubemapLayered(cudaTextureObject_t textureObject, float x, float y, float z, int layer)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_CMa(i, s, make_float4(x, y, z, layer));
    return mapFrom<T>(tmp);
#endif  
}

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2Dgather(T *ptr, cudaTextureObject_t textureObject, float x, float y, int comp = 0)
{
#ifdef __CUDA_ARCH__
    //CHECK ME
    *ptr = tex2Dgather<T>(textureObject, x, y, comp);
#endif
}

template <class T>
static __device__  T tex2Dgather(cudaTextureObject_t textureObject, float x, float y, int comp = 0)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    switch (comp) {
    case 1: {
        auto tmp = __ockl_image_gather4r_2D(i, s, make_float2(x, y));
        return mapFrom<T>(tmp);
        break;
    }
    case 2: {
        auto tmp = __ockl_image_gather4g_2D(i, s, make_float2(x, y));
        return mapFrom<T>(tmp);
        break;
    }
    case 3: {
        auto tmp = __ockl_image_gather4b_2D(i, s, make_float2(x, y));
        return mapFrom<T>(tmp);
        break;
    }
    default: {
        auto tmp = __ockl_image_gather4a_2D(i, s, make_float2(x, y));
        return mapFrom<T>(tmp);
        break;
    }
    };
    return {};
#endif
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2Dgather(T *ptr, cudaTextureObject_t textureObject, float x, float y, bool* isResident, int comp = 0)
{
#ifdef __CUDA_ARCH__
  //CHECK ME
  *ptr = tex2Dgather<T>(textureObject, x, y, comp);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex2Dgather(cudaTextureObject_t to, float x, float y, bool* isResident, int comp = 0)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2Dgather(&ret, to, x, y,  isResident, comp);
  return ret;
#endif
}

#endif  /* __NV_TEX_SPARSE */

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1DLod(T *ptr, cudaTextureObject_t textureObject, float x, float level)
{
#ifdef __CUDA_ARCH__
    *ptr = tex1DLod<T>(textureObject, x, level);
#endif
}

template <class T>
static __device__  T tex1DLod(cudaTextureObject_t textureObject, float x, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_lod_1D(i, s, x, level);
    return mapFrom<T>(tmp);
#endif  
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLod(T *ptr, cudaTextureObject_t textureObject, float x, float y, float level)
{
#ifdef __CUDA_ARCH__
    *ptr = tex2DLod<T>(textureObject, x, y, level);
#endif
}

template <class T>
static __device__  T tex2DLod(cudaTextureObject_t textureObject, float x, float y, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_lod_2D(i, s, make_float2(x, y), level);
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLod(T *ptr, cudaTextureObject_t obj, float x, float y, float level, bool* isResident)
{
#ifdef __CUDA_ARCH__
  unsigned char res;
  *ptr = tex2DLod<T>(obj, x, y, level);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex2DLod(cudaTextureObject_t texObject, float x, float y, float level, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2DLod(&ret, texObject, x, y, level, isResident);
  return ret;
#endif  
}

#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex3DLod(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, float level)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex3DLod<T>(textureObject, x, y, z, level);
#endif
}

template <class T>
static __device__  T tex3DLod(cudaTextureObject_t textureObject, float x, float y, float z, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_lod_3D(i, s, make_float4(x, y, z, 0.0f), level);
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex3DLod(T *ptr, cudaTextureObject_t obj, float x, float y, float z, float level, bool* isResident)
{ 
#ifdef __CUDA_ARCH__
  *ptr = tex3DLod<T>(obj, x, y, z, level);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex3DLod(cudaTextureObject_t texObject, float x, float y, float z, float level, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex3DLod(&ret, texObject, x, y, z, level, isResident);
  return ret;
#endif  
}

#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1DLayeredLod(T *ptr, cudaTextureObject_t textureObject, float x, int layer, float level)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex1DLayeredLod<T>(textureObject, x, layer, level);
#endif
}

template <class T>
static __device__  T tex1DLayeredLod(cudaTextureObject_t textureObject, float x, int layer, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_1Da(i, s, make_float2(x, layer));
    return mapFrom<T>(tmp);
#endif  
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLayeredLod(T *ptr, cudaTextureObject_t textureObject, float x, float y, int layer, float level)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex2DLayeredLod<T>(textureObject, x, y, layer, level);
#endif
}

template <class T>
static __device__  T tex2DLayeredLod(cudaTextureObject_t textureObject, float x, float y, int layer, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_2Da(i, s, make_float4(x, y, layer, 0.0f));
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLayeredLod(T *ptr, cudaTextureObject_t obj, float x, float y, int layer, float level, bool* isResident)
{ 
#ifdef __CUDA_ARCH__
  *ptr = tex2DLayeredLod<T>(obj, x, y, layer, level);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex2DLayeredLod(cudaTextureObject_t texObject, float x, float y, int layer, float level, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2DLayeredLod(&ret, texObject, x, y, layer, level, isResident);
  return ret;
#endif  
}
#endif  /* __NV_TEX_SPARSE */

template <typename T>
static __device__ typename __nv_itex_trait<T>::type texCubemapLod(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, float level)
{ 
#ifdef __CUDA_ARCH__
    *ptr = texCubemapLod<T>(textureObject, x, y, z, level);
#endif
}

template <class T>
static __device__  T texCubemapLod(cudaTextureObject_t textureObject, float x, float y, float z, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_lod_CM(i, s, make_float4(x, y, z, 0.0f), level);
    return mapFrom<T>(tmp);
#endif  
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type texCubemapGrad(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, float4 dPdx, float4 dPdy)
{ 
#ifdef __CUDA_ARCH__
    *ptr = texCubemapGrad<T>(textureObject, x, y, z, dPdx, dPdy);
#endif
}

template <class T>
static __device__  T texCubemapGrad(cudaTextureObject_t textureObject, float x, float y, float z, float4 dPdx, float4 dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    // TODO missing in device libs.
    // auto tmp = __ockl_image_sample_grad_CM(i, s, float4(x, y, z, 0.0f).data, float4(dPdx.x, dPdx.y, dPdx.z, 0.0f).data, float4(dPdy.x, dPdy.y, dPdy.z, 0.0f).data);
    // return mapFrom<T>(tmp);
    return {};
#endif  
}

template <typename T>
static __device__ typename __nv_itex_trait<T>::type texCubemapLayeredLod(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, int layer, float level)
{ 
#ifdef __CUDA_ARCH__
    *ptr = texCubemapLayeredLod<T>(textureObject, x, y, z, layer, level);
#endif
}

template <class T>
static __device__  T texCubemapLayeredLod(cudaTextureObject_t textureObject, float x, float y, float z, int layer, float level)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_lod_CMa(i, s, make_float4(x, y, z, layer), level);
    return mapFrom<T>(tmp);
#endif  
}

template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1DGrad(T *ptr, cudaTextureObject_t textureObject, float x, float dPdx, float dPdy)
{
#ifdef __CUDA_ARCH__
    *ptr = tex1DGrad<T>(textureObject, x, dPdx, dPdy);
#endif
}

template <class T>
static __device__  T tex1DGrad(cudaTextureObject_t textureObject, float x, float dPdx, float dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_grad_1D(i, s, x, dPdx, dPdy);
    return mapFrom<T>(tmp);
#endif  
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DGrad(T *ptr, cudaTextureObject_t textureObject, float x, float y, float2 dPdx, float2 dPdy)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex2DGrad<T>(textureObject, x, y, dPdx, dPdy);
#endif

}

template <class T>
static __device__  T tex2DGrad(cudaTextureObject_t textureObject, float x, float y, float2 dPdx, float2 dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_grad_2D(i, s, make_float2(x, y), make_float2(dPdx.x, dPdx.y),  make_float2(dPdy.x, dPdy.y));
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DGrad(T *ptr, cudaTextureObject_t obj, float x, float y, float2 dPdx, float2 dPdy, bool* isResident)
{ 
#ifdef __CUDA_ARCH__
  *ptr = tex2DGrad<T>(obj, x, y, dPdx, dPdy);
  *isResident = 0;
#endif

}

template <class T>
static __device__  T tex2DGrad(cudaTextureObject_t texObject, float x, float y, float2 dPdx, float2 dPdy, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2DGrad(&ret, texObject, x, y, dPdx, dPdy, isResident);
  return ret;
#endif  
}
#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex3DGrad(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, float4 dPdx, float4 dPdy)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex3DGrad<T>(textureObject, x, y, z, dPdx, dPdy);
#endif
}

template <class T>
static __device__  T tex3DGrad(cudaTextureObject_t textureObject, float x, float y, float z, float4 dPdx, float4 dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_grad_3D(i, s, make_float4(x, y, z, 0.0f), make_float4(dPdx.x, dPdx.y, dPdx.z, 0.0f), make_float4(dPdy.x, dPdy.y, dPdy.z, 0.0f));
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex3DGrad(T *ptr, cudaTextureObject_t obj, float x, float y, float z, float4 dPdx, float4 dPdy, bool* isResident)
{ 
#ifdef __CUDA_ARCH__
  unsigned char res;
  *ptr = tex3DGrad<T>(obj, x, y, z, dPdx, dPdy);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex3DGrad(cudaTextureObject_t texObject, float x, float y, float z, float4 dPdx, float4 dPdy, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex3DGrad(&ret, texObject, x, y, z, dPdx, dPdy, isResident);
  return ret;
#endif  
}

#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex1DLayeredGrad(T *ptr, cudaTextureObject_t textureObject, float x, int layer, float dPdx, float dPdy)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex1DLayeredGrad<T>(textureObject, x, layer, dPdx, dPdy);
#endif
}

template <class T>
static __device__  T tex1DLayeredGrad(cudaTextureObject_t textureObject, float x, int layer, float dPdx, float dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_grad_1Da(i, s, make_float2(x, layer), dPdx, dPdy);
    return mapFrom<T>(tmp);
#endif  
}


template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLayeredGrad(T * ptr, cudaTextureObject_t textureObject, float x, float y, int layer, float2 dPdx, float2 dPdy)
{ 
#ifdef __CUDA_ARCH__
    *ptr = tex2DLayeredGrad<T>(textureObject, x, y, layer, dPdx, dPdy);
#endif
}

template <class T>
static __device__  T tex2DLayeredGrad(cudaTextureObject_t textureObject, float x, float y, int layer, float2 dPdx, float2 dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    auto tmp = __ockl_image_sample_grad_2Da(i, s, make_float4(x, y, layer, 0.0f), make_float2(dPdx.x, dPdx.y), make_float2(dPdy.x, dPdy.y));
    return mapFrom<T>(tmp);
#endif  
}

#if __NV_TEX_SPARSE
template <typename T>
static __device__ typename __nv_itex_trait<T>::type tex2DLayeredGrad(T * ptr, cudaTextureObject_t obj, float x, float y, int layer, float2 dPdx, float2 dPdy, bool* isResident)
{ 
#ifdef __CUDA_ARCH__
  *ptr = tex2DLayeredGrad<T>(obj, x, y, layer, dPdx, dPdy);
  *isResident = 0;
#endif
}

template <class T>
static __device__  T tex2DLayeredGrad(cudaTextureObject_t texObject, float x, float y, int layer, float2 dPdx, float2 dPdy, bool* isResident)
{
#ifdef __CUDA_ARCH__
  T ret;
  tex2DLayeredGrad(&ret, texObject, x, y, layer, dPdx, dPdy, isResident);
  return ret;
#endif  
}
#endif  /* __NV_TEX_SPARSE */


template <typename T>
static __device__ typename __nv_itex_trait<T>::type texCubemapLayeredGrad(T *ptr, cudaTextureObject_t textureObject, float x, float y, float z, int layer, float4 dPdx, float4 dPdy)
{
#ifdef __CUDA_ARCH__
    *ptr = texCubemapLayeredGrad<T>(textureObject, x, y, z, layer, dPdx, dPdy);
#endif
}

template <class T>
static __device__  T texCubemapLayeredGrad(cudaTextureObject_t textureObject, float x, float y, float z, int layer, float4 dPdx, float4 dPdy)
{
#ifdef __CUDA_ARCH__
    TEXTURE_OBJECT_PARAMETERS_INIT
    // TODO missing in device libs.
    // auto tmp = __ockl_image_sample_grad_CMa(i, s, float4(x, y, z, layer).data, float4(dPdx.x, dPdx.y, dPdx.z, 0.0f).data, float4(dPdy.x, dPdy.y, dPdy.z, 0.0f).data);
    // return mapFrom<T>(tmp);
    return {};
#endif  
}
#endif // __CUDA_HIP_PLATFORM_AMD__

#undef __NV_TEX_SPARSE

#endif // __cplusplus && __CUDACC__
#endif // __TEXTURE_INDIRECT_FUNCTIONS_H__
