import json
import requests
from loguru import logger
import argparse

def start(query):
    url = 'http://127.0.0.1:8888/work'
    try:
        header = {'Content-Type': 'application/json'}
        # Add history to data
        data = {
            'query': query
        }
        resp = requests.post(url,
                             headers=header,
                             data=json.dumps(data),
                             timeout=300)
        if resp.status_code != 200:
            raise Exception(str((resp.status_code, resp.reason)))
        return resp.json()['reply'], resp.json()['references']
    except Exception as e:
        logger.error(str(e))
        return ''


def parse_args():
    parser = argparse.ArgumentParser(description='.')
    parser.add_argument('--query',
                        default='输入用户问题',
                        help='')
    return parser.parse_args()


if __name__ == '__main__':
    args = parse_args()
    reply, ref = start(args.query)
    logger.debug('reply: {} \nref: {} '.format(reply, ref))
