


module cudafor_auxiliary
  !>
  !>   @brief Returns device properties.
  !>
  !>   @param [out] prop written with device properties
  !>   @param [in]  deviceId which device to query for information
  !>
  !>   @return #hipSuccess, #hipErrorInvalidDevice
  !>   @bug HCC always returns 0 for maxThreadsPerMultiProcessor
  !>   @bug HCC always returns 0 for regsPerBlock
  !>   @bug HCC always returns 0 for l2CacheSize
  !>
  !>   Populates hipGetDeviceProperties with information for the specified device.
  !>
  interface cudaGetDeviceProperties
    function cudaGetDeviceProperties_(prop,deviceId) bind(c, &
&name="cudaGetDeviceProperties")
      use iso_c_binding
      use cudafor_enums
      use cudafor_types
      implicit none
      integer(kind(cudaSuccess)) :: cudaGetDeviceProperties_
      type(cudaDeviceProp_t),intent(out) :: prop
      integer(c_int),value :: deviceId
    end function
  end interface

end module cudafor_auxiliary