


!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
! ==============================================================================
! hipfort: FORTRAN Interfaces for GPU kernels
! ==============================================================================
! Copyright (c) 2020-2022 Advanced Micro Devices, Inc. All rights reserved.
! [MITx11 License]
! 
! Permission is hereby granted, free of charge, to any person obtaining a copy
! of this software and associated documentation files (the "Software"), to deal
! in the Software without restriction, including without limitation the rights
! to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
! copies of the Software, and to permit persons to whom the Software is
! furnished to do so, subject to the following conditions:
! 
! The above copyright notice and this permission notice shall be included in
! all copies or substantial portions of the Software.
! 
! THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
! IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
! FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
! AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
! LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
! OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
! THE SOFTWARE.
!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!
          
           
module cudafor_enums
  implicit none

  enum, bind(c)
    enumerator :: CU_SUCCESS = 0
    enumerator :: CU_ERROR_INVALID_VALUE
    enumerator :: CU_ERROR_NOT_INITIALIZED
    enumerator :: CU_ERROR_LAUNCH_OUT_OF_RESOURCES
  end enum

  enum, bind(c)
    enumerator :: cudaMemoryTypeHost
    enumerator :: cudaMemoryTypeDevice
    enumerator :: cudaMemoryTypeArray
    enumerator :: cudaMemoryTypeUnified
  end enum

  enum, bind(c)
    enumerator :: cudaSuccess = 0
    enumerator :: cudaErrorInvalidValue = 1
    enumerator :: cudaErrorMemoryAllocation = 2
    !enumerator :: cudaErrorMemoryAllocation = 2
    enumerator :: cudaErrorInitializationError = 3
    !enumerator :: cudaErrorInitializationError = 3
    enumerator :: cudaErrorCudartUnloading = 4
    enumerator :: cudaErrorProfilerDisabled = 5
    enumerator :: cudaErrorProfilerNotInitialized = 6
    enumerator :: cudaErrorProfilerAlreadyStarted = 7
    enumerator :: cudaErrorProfilerAlreadyStopped = 8
    enumerator :: cudaErrorInvalidConfiguration = 9
    enumerator :: cudaErrorInvalidPitchValue = 12
    enumerator :: cudaErrorInvalidSymbol = 13
    enumerator :: cudaErrorInvalidDevicePointer = 17
    enumerator :: cudaErrorInvalidMemcpyDirection = 21
    enumerator :: cudaErrorInsufficientDriver = 35
    enumerator :: cudaErrorMissingConfiguration = 52
    enumerator :: cudaErrorPriorLaunchFailure = 53
    enumerator :: cudaErrorInvalidDeviceFunction = 98
    enumerator :: cudaErrorNoDevice = 100
    enumerator :: cudaErrorInvalidDevice = 101
    enumerator :: cudaErrorInvalidKernelImage = 200
    enumerator :: cudaErrorDeviceUninitialized = 201
    enumerator :: cudaErrorContextAlreadyCurrent = 202
    enumerator :: cudaErrorMapBufferObjectFailed = 205
    !enumerator :: cudaErrorMapBufferObjectFailed = 205
    enumerator :: cudaErrorUnmapBufferObjectFailed = 206
    enumerator :: cudaErrorArrayIsMapped = 207
    enumerator :: cudaErrorAlreadyMapped = 208
    enumerator :: cudaErrorNoKernelImageForDevice = 209
    enumerator :: cudaErrorAlreadyAcquired = 210
    enumerator :: cudaErrorNotMapped = 211
    enumerator :: cudaErrorNotMappedAsArray = 212
    enumerator :: cudaErrorNotMappedAsPointer = 213
    enumerator :: cudaErrorECCUncorrectable = 214
    enumerator :: cudaErrorUnsupportedLimit = 215
    enumerator :: cudaErrorDeviceAlreadyInUse = 216
    enumerator :: cudaErrorPeerAccessUnsupported = 217
    enumerator :: cudaErrorInvalidPtx = 218
    enumerator :: cudaErrorInvalidGraphicsContext = 219
    enumerator :: cudaErrorInvalidSource = 300
    enumerator :: cudaErrorFileNotFound = 301
    enumerator :: cudaErrorSharedObjectSymbolNotFound = 302
    enumerator :: cudaErrorSharedObjectInitFailed = 303
    enumerator :: cudaErrorOperatingSystem = 304
    enumerator :: cudaErrorInvalidResourceHandle = 400
    !enumerator :: cudaErrorInvalidResourceHandle = 400
    enumerator :: cudaErrorIllegalState = 401
    enumerator :: cudaErrorSymbolNotFound = 500
    enumerator :: cudaErrorNotReady = 600
    enumerator :: cudaErrorIllegalAddress = 700
    enumerator :: cudaErrorLaunchOutOfResources = 701
    enumerator :: cudaErrorLaunchTimeout = 702
    enumerator :: cudaErrorPeerAccessAlreadyEnabled = 704
    enumerator :: cudaErrorPeerAccessNotEnabled = 705
    enumerator :: cudaErrorSetOnActiveProcess = 708
    enumerator :: cudaErrorContextIsDestroyed = 709
    enumerator :: cudaErrorAssert = 710
    enumerator :: cudaErrorHostMemoryAlreadyRegistered = 712
    enumerator :: cudaErrorHostMemoryNotRegistered = 713
    enumerator :: cudaErrorLaunchFailure = 719
    enumerator :: cudaErrorCooperativeLaunchTooLarge = 720
    enumerator :: cudaErrorNotSupported = 801
    enumerator :: cudaErrorStreamCaptureUnsupported = 900
    enumerator :: cudaErrorStreamCaptureInvalidated = 901
    enumerator :: cudaErrorStreamCaptureMerge = 902
    enumerator :: cudaErrorStreamCaptureUnmatched = 903
    enumerator :: cudaErrorStreamCaptureUnjoined = 904
    enumerator :: cudaErrorStreamCaptureIsolation = 905
    enumerator :: cudaErrorStreamCaptureImplicit = 906
    enumerator :: cudaErrorCapturedEvent = 907
    enumerator :: cudaErrorStreamCaptureWrongThread = 908
    enumerator :: cudaErrorGraphExecUpdateFailure = 910
    enumerator :: cudaErrorUnknown = 999
    enumerator :: cudaErrorRuntimeMemory = 1052
    enumerator :: cudaErrorRuntimeOther = 1053
    enumerator :: cudaErrorTbd
  end enum

  enum, bind(c)
    enumerator :: cudaDevAttrCudaCompatibleBegin = 0
    enumerator :: cudaDevAttrEccEnabled = cudaDevAttrCudaCompatibleBegin
    enumerator :: cudaDevAttrAccessPolicyMaxWindowSize
    enumerator :: cudaDevAttrAsyncEngineCount
    enumerator :: cudaDevAttrCanMapHostMemory
    enumerator :: cudaDevAttrCanUseHostPointerForRegisteredMem
    enumerator :: cudaDevAttrClockRate
    enumerator :: cudaDevAttrComputeMode
    enumerator :: cudaDevAttrComputePreemptionSupported
    enumerator :: cudaDevAttrConcurrentKernels
    enumerator :: cudaDevAttrConcurrentManagedAccess
    enumerator :: cudaDevAttrCooperativeLaunch
    enumerator :: cudaDevAttrCooperativeMultiDeviceLaunch
    enumerator :: cudaDevAttrDeviceOverlap
    enumerator :: cudaDevAttrDirectManagedMemAccessFromHost
    enumerator :: cudaDevAttrGlobalL1CacheSupported
    enumerator :: cudaDevAttrHostNativeAtomicSupported
    enumerator :: cudaDevAttrIntegrated
    enumerator :: cudaDevAttrIsMultiGpuBoard
    enumerator :: cudaDevAttrKernelExecTimeout
    enumerator :: cudaDevAttrL2CacheSize
    enumerator :: cudaDevAttrLocalL1CacheSupported
    enumerator :: cudaDevAttrLuid
    enumerator :: cudaDevAttrLuidDeviceNodeMask
    enumerator :: cudaDevAttrComputeCapabilityMajor
    enumerator :: cudaDevAttrManagedMemory
    enumerator :: cudaDevAttrMaxBlocksPerMultiProcessor
    enumerator :: cudaDevAttrMaxBlockDimX
    enumerator :: cudaDevAttrMaxBlockDimY
    enumerator :: cudaDevAttrMaxBlockDimZ
    enumerator :: cudaDevAttrMaxGridDimX
    enumerator :: cudaDevAttrMaxGridDimY
    enumerator :: cudaDevAttrMaxGridDimZ
    enumerator :: cudaDevAttrMaxSurface1D
    enumerator :: cudaDevAttrMaxSurface1DLayered
    enumerator :: cudaDevAttrMaxSurface2D
    enumerator :: cudaDevAttrMaxSurface2DLayered
    enumerator :: cudaDevAttrMaxSurface3D
    enumerator :: cudaDevAttrMaxSurfaceCubemap
    enumerator :: cudaDevAttrMaxSurfaceCubemapLayered
    enumerator :: cudaDevAttrMaxTexture1DWidth
    enumerator :: cudaDevAttrMaxTexture1DLayered
    enumerator :: cudaDevAttrMaxTexture1DLinear
    enumerator :: cudaDevAttrMaxTexture1DMipmap
    enumerator :: cudaDevAttrMaxTexture2DWidth
    enumerator :: cudaDevAttrMaxTexture2DHeight
    enumerator :: cudaDevAttrMaxTexture2DGather
    enumerator :: cudaDevAttrMaxTexture2DLayered
    enumerator :: cudaDevAttrMaxTexture2DLinear
    enumerator :: cudaDevAttrMaxTexture2DMipmap
    enumerator :: cudaDevAttrMaxTexture3DWidth
    enumerator :: cudaDevAttrMaxTexture3DHeight
    enumerator :: cudaDevAttrMaxTexture3DDepth
    enumerator :: cudaDevAttrMaxTexture3DAlt
    enumerator :: cudaDevAttrMaxTextureCubemap
    enumerator :: cudaDevAttrMaxTextureCubemapLayered
    enumerator :: cudaDevAttrMaxThreadsDim
    enumerator :: cudaDevAttrMaxThreadsPerBlock
    enumerator :: cudaDevAttrMaxThreadsPerMultiProcessor
    enumerator :: cudaDevAttrMaxPitch
    enumerator :: cudaDevAttrMemoryBusWidth
    enumerator :: cudaDevAttrMemoryClockRate
    enumerator :: cudaDevAttrComputeCapabilityMinor
    enumerator :: cudaDevAttrMultiGpuBoardGroupID
    enumerator :: cudaDevAttrMultiprocessorCount
    enumerator :: cudaDevAttrName
    enumerator :: cudaDevAttrPageableMemoryAccess
    enumerator :: cudaDevAttrPageableMemoryAccessUsesHostPageTables
    enumerator :: cudaDevAttrPciBusId
    enumerator :: cudaDevAttrPciDeviceId
    enumerator :: cudaDevAttrPciDomainID
    enumerator :: cudaDevAttrPersistingL2CacheMaxSize
    enumerator :: cudaDevAttrMaxRegistersPerBlock
    enumerator :: cudaDevAttrMaxRegistersPerMultiprocessor
    enumerator :: cudaDevAttrReservedSharedMemPerBlock
    enumerator :: cudaDevAttrMaxSharedMemoryPerBlock
    enumerator :: cudaDevAttrSharedMemPerBlockOptin
    enumerator :: cudaDevAttrSharedMemPerMultiprocessor
    enumerator :: cudaDevAttrSingleToDoublePrecisionPerfRatio
    enumerator :: cudaDevAttrStreamPrioritiesSupported
    enumerator :: cudaDevAttrSurfaceAlignment
    enumerator :: cudaDevAttrTccDriver
    enumerator :: cudaDevAttrTextureAlignment
    enumerator :: cudaDevAttrTexturePitchAlignment
    enumerator :: cudaDevAttrTotalConstantMemory
    enumerator :: cudaDevAttrTotalGlobalMem
    enumerator :: cudaDevAttrUnifiedAddressing
    enumerator :: cudaDevAttrUuid
    enumerator :: cudaDevAttrWarpSize
    enumerator :: cudaDevAttrCudaCompatibleEnd = 9999
    enumerator :: cudaDevAttrAmdSpecificBegin = 10000
    enumerator :: cudaDevAttrClockInstructionRate = &
&cudaDevAttrAmdSpecificBegin
    enumerator :: cudaDevAttrArch
    enumerator :: cudaDevAttrMaxSharedMemoryPerMultiprocessor
    enumerator :: cudaDevAttrGcnArch
    enumerator :: cudaDevAttrGcnArchName
    enumerator :: cudaDevAttrHdpMemFlushCntl
    enumerator :: cudaDevAttrHdpRegFlushCntl
    enumerator :: cudaDevAttrCooperativeMultiDeviceUnmatchedFunc
    enumerator :: cudaDevAttrCooperativeMultiDeviceUnmatchedGridDim
    enumerator :: cudaDevAttrCooperativeMultiDeviceUnmatchedBlockDim
    enumerator :: cudaDevAttrCooperativeMultiDeviceUnmatchedSharedMem
    enumerator :: cudaDevAttrIsLargeBar
    enumerator :: cudaDevAttrAsicRevision
    enumerator :: cudaDevAttrCanUseStreamWaitValue
    enumerator :: cudaDevAttrImageSupport
    enumerator :: cudaDevAttrAmdSpecificEnd = 19999
    enumerator :: cudaDevAttrVendorSpecificBegin = 20000
  end enum

  enum, bind(c)
    enumerator :: cudaComputeModeDefault = 0
    enumerator :: cudaComputeModeExclusive = 1
    enumerator :: cudaComputeModeProhibited = 2
    enumerator :: cudaComputeModeExclusiveProcess = 3
  end enum

  enum, bind(c)
    enumerator :: cudaDevP2PAttrPerformanceRank = 0
    enumerator :: cudaDevP2PAttrAccessSupported
    enumerator :: cudaDevP2PAttrNativeAtomicSupported
    enumerator :: cudaDevP2PAttrCudaArrayAccessSupported
  end enum

  enum, bind(c)
    enumerator :: cudaLimitPrintfFifoSize = 1
    enumerator :: cudaLimitMallocHeapSize = 2
  end enum

  enum, bind(c)
    enumerator :: cudaMemAdviseSetReadMostly = 1
    enumerator :: cudaMemAdviseUnsetReadMostly = 2
    enumerator :: cudaMemAdviseSetPreferredLocation = 3
    enumerator :: cudaMemAdviseUnsetPreferredLocation = 4
    enumerator :: cudaMemAdviseSetAccessedBy = 5
    enumerator :: cudaMemAdviseUnsetAccessedBy = 6
    enumerator :: cudaMemAdviseSetCoarseGrain = 100
    enumerator :: cudaMemAdviseUnsetCoarseGrain = 101
  end enum

  enum, bind(c)
    enumerator :: cudaMemRangeCoherencyModeFineGrain = 0
    enumerator :: cudaMemRangeCoherencyModeCoarseGrain = 1
    enumerator :: cudaMemRangeCoherencyModeIndeterminate = 2
  end enum

  enum, bind(c)
    enumerator :: cudaMemRangeAttributeReadMostly = 1
    enumerator :: cudaMemRangeAttributePreferredLocation = 2
    enumerator :: cudaMemRangeAttributeAccessedBy = 3
    enumerator :: cudaMemRangeAttributeLastPrefetchLocation = 4
    enumerator :: cudaMemRangeAttributeCoherencyMode = 100
  end enum

  enum, bind(c)
    enumerator :: CU_JIT_MAX_REGISTERS = 0
    enumerator :: CU_JIT_THREADS_PER_BLOCK
    enumerator :: CU_JIT_WALL_TIME
    enumerator :: CU_JIT_INFO_LOG_BUFFER
    enumerator :: CU_JIT_INFO_LOG_BUFFER_SIZE_BYTES
    enumerator :: CU_JIT_ERROR_LOG_BUFFER
    enumerator :: CU_JIT_ERROR_LOG_BUFFER_SIZE_BYTES
    enumerator :: CU_JIT_OPTIMIZATION_LEVEL
    enumerator :: CU_JIT_TARGET_FROM_CONTEXT
    enumerator :: CU_JIT_TARGET
    enumerator :: CU_JIT_FALLBACK_STRATEGY
    enumerator :: CU_JIT_GENERATE_DEBUG_INFO
    enumerator :: CU_JIT_LOG_VERBOSE
    enumerator :: CU_JIT_GENERATE_LINE_INFO
    enumerator :: CU_JIT_CACHE_MODE
    enumerator :: CU_JIT_SM3X_OPT
    enumerator :: CU_JIT_FAST_COMPILE
    enumerator :: CU_JIT_NUM_OPTIONS
  end enum

  enum, bind(c)
    enumerator :: cudaFuncAttributeMaxDynamicSharedMemorySize = 8
    enumerator :: cudaFuncAttributePreferredSharedMemoryCarveout = 9
    enumerator :: cudaFuncAttributeMax
  end enum

  enum, bind(c)
    enumerator :: cudaFuncCachePreferNone
    enumerator :: cudaFuncCachePreferShared
    enumerator :: cudaFuncCachePreferL1
    enumerator :: cudaFuncCachePreferEqual
  end enum

  enum, bind(c)
    enumerator :: cudaSharedMemBankSizeDefault
    enumerator :: cudaSharedMemBankSizeFourByte
    enumerator :: cudaSharedMemBankSizeEightByte
  end enum

  enum, bind(c)
    enumerator :: cudaExternalMemoryHandleTypeOpaqueFd = 1
    enumerator :: cudaExternalMemoryHandleTypeOpaqueWin32 = 2
    enumerator :: cudaExternalMemoryHandleTypeOpaqueWin32Kmt = 3
    enumerator :: cudaExternalMemoryHandleTypeD3D12Heap = 4
    enumerator :: cudaExternalMemoryHandleTypeD3D12Resource = 5
    enumerator :: cudaExternalMemoryHandleTypeD3D11Resource = 6
    enumerator :: cudaExternalMemoryHandleTypeD3D11ResourceKmt = 7
  end enum

  enum, bind(c)
    enumerator :: cudaExternalSemaphoreHandleTypeOpaqueFd = 1
    enumerator :: cudaExternalSemaphoreHandleTypeOpaqueWin32 = 2
    enumerator :: cudaExternalSemaphoreHandleTypeOpaqueWin32Kmt = 3
    enumerator :: cudaExternalSemaphoreHandleTypeD3D12Fence = 4
  end enum

  enum, bind(c)
    enumerator :: cudaGLDeviceListAll = 1
    enumerator :: cudaGLDeviceListCurrentFrame = 2
    enumerator :: cudaGLDeviceListNextFrame = 3
  end enum

  enum, bind(c)
    enumerator :: cudaGraphicsRegisterFlagsNone = 0
    enumerator :: cudaGraphicsRegisterFlagsReadOnly = 1
    enumerator :: cudaGraphicsRegisterFlagsWriteDiscard = 2
    enumerator :: cudaGraphicsRegisterFlagsSurfaceLoadStore = 4
    enumerator :: cudaGraphicsRegisterFlagsTextureGather = 8
  end enum

  enum, bind(c)
    enumerator :: cudaGraphNodeTypeKernel = 1
    enumerator :: cudaGraphNodeTypeMemcpy = 2
    enumerator :: cudaGraphNodeTypeMemset = 3
    enumerator :: cudaGraphNodeTypeHost = 4
    enumerator :: cudaGraphNodeTypeGraph = 5
    enumerator :: cudaGraphNodeTypeEmpty = 6
    enumerator :: cudaGraphNodeTypeWaitEvent = 7
    enumerator :: cudaGraphNodeTypeEventRecord = 8
    enumerator :: cudaGraphNodeTypeMemcpy1D = 9
    enumerator :: cudaGraphNodeTypeMemcpyFromSymbol = 10
    enumerator :: cudaGraphNodeTypeMemcpyToSymbol = 11
    enumerator :: cudaGraphNodeTypeCount
  end enum

  enum, bind(c)
    enumerator :: cudaGraphExecUpdateSuccess = 0
    enumerator :: cudaGraphExecUpdateError = 1
    enumerator :: cudaGraphExecUpdateErrorTopologyChanged = 2
    enumerator :: cudaGraphExecUpdateErrorNodeTypeChanged = 3
    enumerator :: cudaGraphExecUpdateErrorFunctionChanged = 4
    enumerator :: cudaGraphExecUpdateErrorParametersChanged = 5
    enumerator :: cudaGraphExecUpdateErrorNotSupported = 6
    enumerator :: cudaGraphExecUpdateErrorUnsupportedFunctionChange = 7
  end enum

  enum, bind(c)
    enumerator :: cudaStreamCaptureModeGlobal = 0
    enumerator :: cudaStreamCaptureModeThreadLocal
    enumerator :: cudaStreamCaptureModeRelaxed
  end enum

  enum, bind(c)
    enumerator :: cudaStreamCaptureStatusNone = 0
    enumerator :: cudaStreamCaptureStatusActive
    enumerator :: cudaStreamCaptureStatusInvalidated
  end enum

  enum, bind(c)
    enumerator :: cudaStreamAddCaptureDependencies = 0
    enumerator :: cudaStreamSetCaptureDependencies
  end enum

  enum, bind(c)
    enumerator :: cudaChannelFormatKindSigned = 0
    enumerator :: cudaChannelFormatKindUnsigned = 1
    enumerator :: cudaChannelFormatKindFloat = 2
    enumerator :: cudaChannelFormatKindNone = 3
  end enum

  enum, bind(c)
    enumerator :: CU_AD_FORMAT_UNSIGNED_INT8 = 1
    enumerator :: CU_AD_FORMAT_UNSIGNED_INT16 = 2
    enumerator :: CU_AD_FORMAT_UNSIGNED_INT32 = 3
    enumerator :: CU_AD_FORMAT_SIGNED_INT8 = 8
    enumerator :: CU_AD_FORMAT_SIGNED_INT16 = 9
    enumerator :: CU_AD_FORMAT_SIGNED_INT32 = 10
    enumerator :: CU_AD_FORMAT_HALF = 16
    enumerator :: CU_AD_FORMAT_FLOAT = 32
  end enum

  enum, bind(c)
    enumerator :: cudaResourceTypeArray = 0
    enumerator :: cudaResourceTypeMipmappedArray = 1
    enumerator :: cudaResourceTypeLinear = 2
    enumerator :: cudaResourceTypePitch2D = 3
  end enum

  enum, bind(c)
    enumerator :: CU_RESOURCE_TYPE_ARRAY = 0
    enumerator :: CU_RESOURCE_TYPE_MIPMAPPED_ARRAY = 1
    enumerator :: CU_RESOURCE_TYPE_LINEAR = 2
    enumerator :: CU_RESOURCE_TYPE_PITCH2D = 3
  end enum

  enum, bind(c)
    enumerator :: CU_TR_ADDRESS_MODE_WRAP = 0
    enumerator :: CU_TR_ADDRESS_MODE_CLAMP = 1
    enumerator :: CU_TR_ADDRESS_MODE_MIRROR = 2
    enumerator :: CU_TR_ADDRESS_MODE_BORDER = 3
  end enum

  enum, bind(c)
    enumerator :: CU_TR_FILTER_MODE_POINT = 0
    enumerator :: CU_TR_FILTER_MODE_LINEAR = 1
  end enum

  enum, bind(c)
    enumerator :: cudaResViewFormatNone = 0
    enumerator :: cudaResViewFormatUnsignedChar1 = 1
    enumerator :: cudaResViewFormatUnsignedChar2 = 2
    enumerator :: cudaResViewFormatUnsignedChar4 = 3
    enumerator :: cudaResViewFormatSignedChar1 = 4
    enumerator :: cudaResViewFormatSignedChar2 = 5
    enumerator :: cudaResViewFormatSignedChar4 = 6
    enumerator :: cudaResViewFormatUnsignedShort1 = 7
    enumerator :: cudaResViewFormatUnsignedShort2 = 8
    enumerator :: cudaResViewFormatUnsignedShort4 = 9
    enumerator :: cudaResViewFormatSignedShort1 = 10
    enumerator :: cudaResViewFormatSignedShort2 = 11
    enumerator :: cudaResViewFormatSignedShort4 = 12
    enumerator :: cudaResViewFormatUnsignedInt1 = 13
    enumerator :: cudaResViewFormatUnsignedInt2 = 14
    enumerator :: cudaResViewFormatUnsignedInt4 = 15
    enumerator :: cudaResViewFormatSignedInt1 = 16
    enumerator :: cudaResViewFormatSignedInt2 = 17
    enumerator :: cudaResViewFormatSignedInt4 = 18
    enumerator :: cudaResViewFormatHalf1 = 19
    enumerator :: cudaResViewFormatHalf2 = 20
    enumerator :: cudaResViewFormatHalf4 = 21
    enumerator :: cudaResViewFormatFloat1 = 22
    enumerator :: cudaResViewFormatFloat2 = 23
    enumerator :: cudaResViewFormatFloat4 = 24
    enumerator :: cudaResViewFormatUnsignedBlockCompressed1 = 25
    enumerator :: cudaResViewFormatUnsignedBlockCompressed2 = 26
    enumerator :: cudaResViewFormatUnsignedBlockCompressed3 = 27
    enumerator :: cudaResViewFormatUnsignedBlockCompressed4 = 28
    enumerator :: cudaResViewFormatSignedBlockCompressed4 = 29
    enumerator :: cudaResViewFormatUnsignedBlockCompressed5 = 30
    enumerator :: cudaResViewFormatSignedBlockCompressed5 = 31
    enumerator :: cudaResViewFormatUnsignedBlockCompressed6H = 32
    enumerator :: cudaResViewFormatSignedBlockCompressed6H = 33
    enumerator :: cudaResViewFormatUnsignedBlockCompressed7 = 34
  end enum

  enum, bind(c)
    enumerator :: CU_RES_VIEW_FORMAT_NONE = 0
    enumerator :: CU_RES_VIEW_FORMAT_UINT_1X8 = 1
    enumerator :: CU_RES_VIEW_FORMAT_UINT_2X8 = 2
    enumerator :: CU_RES_VIEW_FORMAT_UINT_4X8 = 3
    enumerator :: CU_RES_VIEW_FORMAT_SINT_1X8 = 4
    enumerator :: CU_RES_VIEW_FORMAT_SINT_2X8 = 5
    enumerator :: CU_RES_VIEW_FORMAT_SINT_4X8 = 6
    enumerator :: CU_RES_VIEW_FORMAT_UINT_1X16 = 7
    enumerator :: CU_RES_VIEW_FORMAT_UINT_2X16 = 8
    enumerator :: CU_RES_VIEW_FORMAT_UINT_4X16 = 9
    enumerator :: CU_RES_VIEW_FORMAT_SINT_1X16 = 10
    enumerator :: CU_RES_VIEW_FORMAT_SINT_2X16 = 11
    enumerator :: CU_RES_VIEW_FORMAT_SINT_4X16 = 12
    enumerator :: CU_RES_VIEW_FORMAT_UINT_1X32 = 13
    enumerator :: CU_RES_VIEW_FORMAT_UINT_2X32 = 14
    enumerator :: CU_RES_VIEW_FORMAT_UINT_4X32 = 15
    enumerator :: CU_RES_VIEW_FORMAT_SINT_1X32 = 16
    enumerator :: CU_RES_VIEW_FORMAT_SINT_2X32 = 17
    enumerator :: CU_RES_VIEW_FORMAT_SINT_4X32 = 18
    enumerator :: CU_RES_VIEW_FORMAT_FLOAT_1X16 = 19
    enumerator :: CU_RES_VIEW_FORMAT_FLOAT_2X16 = 20
    enumerator :: CU_RES_VIEW_FORMAT_FLOAT_4X16 = 21
    enumerator :: CU_RES_VIEW_FORMAT_FLOAT_1X32 = 22
    enumerator :: CU_RES_VIEW_FORMAT_FLOAT_2X32 = 23
    enumerator :: CU_RES_VIEW_FORMAT_FLOAT_4X32 = 24
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC1 = 25
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC2 = 26
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC3 = 27
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC4 = 28
    enumerator :: CU_RES_VIEW_FORMAT_SIGNED_BC4 = 29
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC5 = 30
    enumerator :: CU_RES_VIEW_FORMAT_SIGNED_BC5 = 31
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC6H = 32
    enumerator :: CU_RES_VIEW_FORMAT_SIGNED_BC6H = 33
    enumerator :: CU_RES_VIEW_FORMAT_UNSIGNED_BC7 = 34
  end enum

  enum, bind(c)
    enumerator :: cudaMemcpyHostToHost = 0
    enumerator :: cudaMemcpyHostToDevice = 1
    enumerator :: cudaMemcpyDeviceToHost = 2
    enumerator :: cudaMemcpyDeviceToDevice = 3
    enumerator :: cudaMemcpyDefault = 4
  end enum

  enum, bind(c)
    enumerator :: CU_FUNC_ATTRIBUTE_MAX_THREADS_PER_BLOCK
    enumerator :: CU_FUNC_ATTRIBUTE_SHARED_SIZE_BYTES
    enumerator :: CU_FUNC_ATTRIBUTE_CONST_SIZE_BYTES
    enumerator :: CU_FUNC_ATTRIBUTE_LOCAL_SIZE_BYTES
    enumerator :: CU_FUNC_ATTRIBUTE_NUM_REGS
    enumerator :: CU_FUNC_ATTRIBUTE_PTX_VERSION
    enumerator :: CU_FUNC_ATTRIBUTE_BINARY_VERSION
    enumerator :: CU_FUNC_ATTRIBUTE_CACHE_MODE_CA
    enumerator :: CU_FUNC_ATTRIBUTE_MAX_DYNAMIC_SHARED_SIZE_BYTES
    enumerator :: CU_FUNC_ATTRIBUTE_PREFERRED_SHARED_MEMORY_CARVEOUT
    enumerator :: CU_FUNC_ATTRIBUTE_MAX
  end enum

  enum, bind(c)
    enumerator :: CU_POINTER_ATTRIBUTE_CONTEXT = 1
    enumerator :: CU_POINTER_ATTRIBUTE_MEMORY_TYPE
    enumerator :: CU_POINTER_ATTRIBUTE_DEVICE_POINTER
    enumerator :: CU_POINTER_ATTRIBUTE_HOST_POINTER
    enumerator :: CU_POINTER_ATTRIBUTE_P2P_TOKENS
    enumerator :: CU_POINTER_ATTRIBUTE_SYNC_MEMOPS
    enumerator :: CU_POINTER_ATTRIBUTE_BUFFER_ID
    enumerator :: CU_POINTER_ATTRIBUTE_IS_MANAGED
    enumerator :: CU_POINTER_ATTRIBUTE_DEVICE_ORDINAL
    enumerator :: CU_POINTER_ATTRIBUTE_IS_LEGACY_CU_IPC_CAPABLE
    enumerator :: CU_POINTER_ATTRIBUTE_RANGE_START_ADDR
    enumerator :: CU_POINTER_ATTRIBUTE_RANGE_SIZE
    enumerator :: CU_POINTER_ATTRIBUTE_MAPPED
    enumerator :: CU_POINTER_ATTRIBUTE_ALLOWED_HANDLE_TYPES
    enumerator :: CU_POINTER_ATTRIBUTE_IS_GPU_DIRECT_RDMA_CAPABLE
    enumerator :: CU_POINTER_ATTRIBUTE_ACCESS_FLAGS
    enumerator :: CU_POINTER_ATTRIBUTE_MEMPOOL_HANDLE
  end enum

  enum, bind(c)
    enumerator :: cudaAddressModeWrap = 0
    enumerator :: cudaAddressModeClamp = 1
    enumerator :: cudaAddressModeMirror = 2
    enumerator :: cudaAddressModeBorder = 3
  end enum

  enum, bind(c)
    enumerator :: cudaFilterModePoint = 0
    enumerator :: cudaFilterModeLinear = 1
  end enum

  enum, bind(c)
    enumerator :: cudaReadModeElementType = 0
    enumerator :: cudaReadModeNormalizedFloat = 1
  end enum

  enum, bind(c)
    enumerator :: CU_R_16F = 2
    enumerator :: CU_R_32F = 0
    enumerator :: CU_R_64F = 1
    enumerator :: CU_C_16F = 6
    enumerator :: CU_C_32F = 4
    enumerator :: CU_C_64F = 5
  end enum

  enum, bind(c)
    enumerator :: CU_LIBRARY_MAJOR_VERSION
    enumerator :: CU_LIBRARY_MINOR_VERSION
    enumerator :: CU_LIBRARY_PATCH_LEVEL
  end enum

 


  
end module cudafor_enums