/*
* cudamocker's RTC is currently consistent with hiprtc, some C++ feature required by cudamocker-RTC
*/


#ifndef __CLANG_CUDAMOCKER_RTC_H__
#define __CLANG_CUDAMOCKER_RTC_H__

#if !defined(__CUDACC_RTC__)
#warning "__CUDACC_RTC__ needs to be defined before include __clang_cudamocker_rtc.h. Please define __CUDACC_RTC__ first."
#endif

/***************************************
*   code from amd_hip_vector_types.h   *
***************************************/
namespace std {
    template <class _Tp, _Tp __v> struct integral_constant {
    static constexpr const _Tp value = __v;
    typedef _Tp value_type;
    typedef integral_constant type;
    constexpr operator value_type() const { return value; }
    constexpr value_type operator()() const { return value; }
    };
    template <class _Tp, _Tp __v> constexpr const _Tp integral_constant<_Tp, __v>::value;

    typedef integral_constant<bool, true> true_type;
    typedef integral_constant<bool, false> false_type;

    template <bool B> using bool_constant = integral_constant<bool, B>;
    typedef bool_constant<true> true_type;
    typedef bool_constant<false> false_type;

    template <bool __B, class __T = void> struct enable_if {};
    template <class __T> struct enable_if<true, __T> { typedef __T type; };

    template<bool _B> struct true_or_false_type : public false_type {};
    template<> struct true_or_false_type<true> : public true_type {};

    template <class _Tp> struct is_integral : public false_type {};
    template <> struct is_integral<bool> : public true_type {};
    template <> struct is_integral<char> : public true_type {};
    template <> struct is_integral<signed char> : public true_type {};
    template <> struct is_integral<unsigned char> : public true_type {};
    template <> struct is_integral<wchar_t> : public true_type {};
    template <> struct is_integral<short> : public true_type {};
    template <> struct is_integral<unsigned short> : public true_type {};
    template <> struct is_integral<int> : public true_type {};
    template <> struct is_integral<unsigned int> : public true_type {};
    template <> struct is_integral<long> : public true_type {};
    template <> struct is_integral<unsigned long> : public true_type {};
    template <> struct is_integral<long long> : public true_type {};
    template <> struct is_integral<unsigned long long> : public true_type {};

    template <class _Tp> struct is_arithmetic : public false_type {};
    template <> struct is_arithmetic<bool> : public true_type {};
    template <> struct is_arithmetic<char> : public true_type {};
    template <> struct is_arithmetic<signed char> : public true_type {};
    template <> struct is_arithmetic<unsigned char> : public true_type {};
    template <> struct is_arithmetic<wchar_t> : public true_type {};
    template <> struct is_arithmetic<short> : public true_type {};
    template <> struct is_arithmetic<unsigned short> : public true_type {};
    template <> struct is_arithmetic<int> : public true_type {};
    template <> struct is_arithmetic<unsigned int> : public true_type {};
    template <> struct is_arithmetic<long> : public true_type {};
    template <> struct is_arithmetic<unsigned long> : public true_type {};
    template <> struct is_arithmetic<long long> : public true_type {};
    template <> struct is_arithmetic<unsigned long long> : public true_type {};
    template <> struct is_arithmetic<float> : public true_type {};
    template <> struct is_arithmetic<double> : public true_type {};

    template<typename _Tp> struct is_floating_point : public false_type {};
    template<> struct is_floating_point<float> : public true_type {};
    template<> struct is_floating_point<double> : public true_type {};
    template<> struct is_floating_point<long double> : public true_type {};

    template <typename __T, typename __U> struct is_same : public false_type {};
    template <typename __T> struct is_same<__T, __T> : public true_type {};

    template<typename _Tp, bool = is_arithmetic<_Tp>::value>
    struct is_signed : public false_type {};
    template<typename _Tp>
    struct is_signed<_Tp, true> : public true_or_false_type<_Tp(-1) < _Tp(0)> {};

    template <class _T1, class _T2> struct is_convertible
    : public true_or_false_type<__is_convertible_to(_T1, _T2)> {};

    template<typename _CharT> struct char_traits;
    template<typename _CharT, typename _Traits = char_traits<_CharT>> class basic_istream;
    template<typename _CharT, typename _Traits = char_traits<_CharT>> class basic_ostream;
    typedef basic_istream<char> istream;
    typedef basic_ostream<char> ostream;

    template <typename __T> struct is_scalar : public integral_constant<bool, __is_scalar(__T)> {};
} // Namespace std.

/***************************************
*     code from amd_hip_runtime.h      *
***************************************/
typedef unsigned int uint32_t;
typedef unsigned long long uint64_t;
typedef signed int int32_t;
typedef signed long long int64_t;

namespace std {
    using ::uint32_t;
    using ::uint64_t;
    using ::int32_t;
    using ::int64_t;
}

typedef unsigned int uint;
typedef long long int clock_t;


#endif  // __CLANG_CUDAMOCKER_RTC_H__
