from typing import Tuple

__release__ = '0.0.1'
short_release = __release__


def extract_release_info(release_str: str) -> Tuple:
    release_info = []
    for part in release_str.split('.'):
        if part.isdigit():
            release_info.append(int(part))
        elif 'rc' in part:
            patch_info = part.split('rc')
            release_info.append(int(patch_info[0]))
            release_info.append(f'rc{patch_info[1]}')
    return tuple(release_info)


release_info = extract_release_info(__release__)
