import matplotlib.pyplot as plt
import numpy as np

# 数据
groups = ['原始查询', '0.5倍污染', '1倍污染', '1.5倍污染', '2倍污染']
times_before = [3716.4464, 7040.2188, 4724.0401, 7127.4622, 5103.7318]  # 拆解前的时间
times_after = [1981.7389, 2085.3399, 2116.5892, 2205.7316, 3006.2746]    # 拆解后的时间

# 设置中文字体，请确保你的系统中安装了这个字体
plt.rcParams['font.sans-serif'] = ['SimHei']
plt.rcParams['axes.unicode_minus'] = False

# 创建图表
fig, ax = plt.subplots(figsize=(10, 6))

# 设置柱的宽度
width = 0.35

# 创建柱状图
x = np.arange(len(groups))
rects1 = ax.bar(x - width/2, times_before, width, label='拆解前', color='white', edgecolor='black')
rects2 = ax.bar(x + width/2, times_after, width, label='拆解后', hatch='//', color='white', edgecolor='black')

# 设置y轴标签
ax.set_ylabel('时间')

# 设置x轴刻度和标签
ax.set_xticks(x)
ax.set_xticklabels(groups)

# 添加图例
ax.legend()

# 设置标题
ax.set_title('拆解前后时间对比')

# 在右上角添加图例说明
# ax.text(0.95, 0.95, '质量\n修改', transform=ax.transAxes, fontsize=9,
#         verticalalignment='top', horizontalalignment='right',
#         bbox=dict(boxstyle='round', facecolor='white', edgecolor='black'))

# 调整布局
plt.tight_layout()

# 保存图表到文件
plt.savefig('time_comparison_chart.png', dpi=300, bbox_inches='tight')

# 关闭图表（释放内存）
plt.close(fig)