## 树博士:一种基于检索增强生成模型的大型智能客服机器人系统

“树博士”是一个基于 RAG结合LLM 的领域知识助手。特点：

1. 应对垂直领域复杂应用场景，解答用户问题的同时，不会产生“幻觉”
2. 提出一套解答技术问题的算法 pipeline
3. 模块化组合部署成本低，安全可靠鲁棒性强


## 步骤1. 环境配置
- 拉取镜像并创建容器：[光源镜像下载地址](https://sourcefind.cn/#/image/dcu/pytorch?activeName=overview)
  docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-ubuntu20.04-dtk24.04.1-py3.10
- 运行容器：
  docker run -dit --name assitant --privileged --device=/dev/kfd --device=/dev/dri/ --cap-add=SYS_PTRACE --security-opt seccomp=unconfined --ulimit memlock=-1:-1 --ipc=host --network host --group-add video -v /opt/hyhal:/opt/hyhal -v /path/to/model:/opt/model:ro image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.1.0-centos7.6-dtk24.04-py310
  注意替换-v参数，即宿主机模型存放位置
- 安装
    ```shell
    git clone http://10.6.10.68/aps/ai.git
    cd ai
  
    # 如果是centos就用yum
    apt update
    apt install python-dev libxml2-dev libxslt1-dev antiword unrtf poppler-utils pstotext tesseract-ocr flac ffmpeg lame libmad0 libsox-fmt-mp3 sox libjpeg-dev swig libpulse-dev
    
    下载并安装dtk所需其他包：[faiss](http://10.6.10.68:8000/release/faiss/dtk24.04/faiss-1.7.2_dtk24.04_gitb7348e7df780-py3-none-any.whl)
    wget http://10.6.10.68:8000/release/faiss/dtk24.04/faiss-1.7.2_dtk24.04_gitb7348e7df780-py3-none-any.whl
    pip install faiss-1.7.2_dtk22.10_gitb7348e7df780-py3-none-any.whl

    安装火狐浏览器和驱动并配置环境变量
    sudo apt-get update
    sudo apt-get install firefox   # 安装 Firefox 浏览器

    wget https://github.com/mozilla/geckodriver/releases/latest/download/geckodriver-v0.34.0-linux64.tar.gz    # 下载 geckodriver
    tar -xvzf geckodriver-v0.34.0-linux64.tar.gz       # 解压 geckodriver
    sudo mv geckodriver /usr/local/bin/      # 将 geckodriver 移动到 /usr/local/bin 目录下

    nano ~/.bashrc   #配置环境变量,编辑 ~/.bashrc 文件
    export PATH=$PATH:/usr/local/bin
    export GECKODRIVER=/usr/local/bin/geckodriver # 添加以上两行内容
    source ~/.bashrc  # 保存并退出编辑器，然后让更改立即生效：
    echo $GECKODRIVER # 验证环境变量

    chmod +x /usr/local/bin/geckodriver  #常见问题排查 权限问题：确保 geckodriver 有执行权限。如果没有，使用 chmod +x /usr/local/bin/geckodriver 赋予执行权限。

    安装程序依赖
    pip install -r requirements.txt -i https://pypi.tuna.tsinghua.edu.cn/simple
    ```

## 步骤2. 准备模型

首次运行树博士需手动下载相关模型到本地，下载地址：

[BCERerank下载地址](https://modelscope.cn/models/maidalun/bce-reranker-base_v1/files)

[Text2vec-large-chinese下载地址](https://modelscope.cn/models/Jerry0/text2vec-large-chinese/files)

[Llama3-8B-Chinese-Chat下载地址](https://hf-mirror.com/shenzhi-wang/Llama3-8B-Chinese-Chat)

bert-finetune-dcu模型为微调模型，可以联系开发获取

注意下载位置要与步骤一中的-v参数一致

## 步骤3. 修改配置文件：
ai/config.ini
```shell
[default]
work_dir = /path/to/your/ai/work_dir  #填写ai/work_dir的绝对路径
bind_port = 8000                      #填写服务对外暴露的他很害怕端口
summarize_query = False               #查询前是否使用对问题进行总结
use_rag = True                        #是否使用RAG查询
use_template = False                  #是否使用模板输出RAG结果
output_format = True                  #是否使用Markdown格式化输出结果
filter_illegal = True                 #是否检查敏感问题

[feature_database]
file_processor = 10                                     #文件解析线程数

[llm]
llm_service_address = http://127.0.0.1:8001             #通用模型访问地址
llm_model = /path/to/your/Llama3-8B-Chinese-Chat/       #通用模型名称
cls_service_address = http://127.0.0.1:8002             #分类模型访问地址
rag_service_address = http://127.0.0.1:8003             #RAG服务访问地址
max_input_length = 1400                                 #输入长度限制
```

ai/rag/config.ini
```shell
[default]
work_dir = /path/to/your/ai/work_dir  #填写ai/work_dir的绝对路径
bind_port = 8003                      #填写服务对外暴露的他很害怕端口

[rag]
embedding_model_path = /path/to/your/text2vec-large-chinese   #填写text2vec-large-chinese模型的目录所在绝对路径
reranker_model_path = /path/to/your/bce-reranker-base_v1      #填写bce-reranker-base_v1模型的目录所在绝对路径
vector_top_k = 5                                              #向量库查询数量
es_top_k = 5                                                  #es查询数量
es_url = http://10.2.106.50:31920                             #es访问地址
index_name = dcu_knowledge_base                               #es索引名称
```

向量库需联系开发人员获取，放置到work_dir下

```shell
ll ai/work_dir/db_response/
total 173696
-rw-r--r-- 1 root root 154079277 Aug 22 10:04 index.faiss
-rw-r--r-- 1 root root  23767932 Aug 22 10:04 index.pkl
```


## 步骤4. 运行

- 运行llm服务
  指定服务运行的dcu卡编号，尽量找空闲卡
  
  export CUDA_VISIBLE_DEVICES='1'
  
  使用vllm运行标准openai接口服务

  python -m vllm.entrypoints.openai.api_server --model /opt/model/Llama3-8B-Chinese-Chat/ --enforce-eager --dtype float16 --trust-remote-code --port 8001 > llm.log 2>&1 &

- 运行分类模型

  python ai/classify/classify.py --model_path /opt/model/bert-finetune-dcu/ --port 8002 --dcu_id 2 > classify.log 2>&1 &
  
  参数说明：
  
  --model_path 分类模型路径
  
  --port 分类服务端口

  --dcu_id 运行dcu卡编号

- 运行RAG服务
  
  python ai/rag/retriever.py --config_path /root/ai/rag/config.ini --dcu_id 3 > rag.log 2>&1 &

提示：前三个服务都需要dcu设备，因此可以后台运行在一个容器中

- 运行助手服务

  python ai/server_start.py --config_path /root/ai/config.ini --log_path /var/log/assistant.log
  
提示：此服务不依赖dcu设备，可以运行在k8s中

  
- 客户端调用示例：
  ```shell
  python client.py --action query --query "你好, 我们公司想要购买几台测试机, 请问需要联系贵公司哪位?"
  ..
  20xx-xx-xx hh:mm:ss.sss | DEBUG    | __main__:<module>:30 - 
  reply: 您好，您需要联系中科曙光售前咨询平台，您可以通过访问官网，根据您所在地地址联系平台人员，
         或者点击人工客服进行咨询，或者拨打中科曙光服务热线400-810-0466联系人工进行咨询。
         如果您需要购买机架式服务器，I620--G30，请与平台人员联系。, 
  ref: ['train.json', 'FAQ_clean.xls', 'train.json'
  ```
  
# 🛠️ 未来计划

1. 支持网络检索融合进工作流

2. 更先进的llm微调与支持（llama3）

3. vllm加速

4. 支持多个本地llm及远程llm调用

5. 支持多模态图文问答

# 🛠️ 相关问题

```Could not load library with AVX2 support due to:ModuleNotFoundError("No module named 'faiss.swigfaiss_avx2'") ```问题修复:

找到安装faiss位置
  ```
  import faiss
  print(faiss.__file__)
  # /.../python3.10/site-packages/faiss/__init__.py
  ```

添加软链接
```
  # cd your_python_path/site-packages/faiss
  cd /.../python3.10/site-packages/faiss/
  ln -s swigfaiss.py swigfaiss_avx2.py
  ```
