#!/bin/bash

if [ -z "${ROCM_PATH}" ]; then
    echo "Error: The ROCM_PATH environment variable does not exist. Not able to initialize DTK CUDA path."
    echo "Please initialize DTK environment first!"
    return
fi

echo "Loading CUDA environment variables successfully, only support dtk-24.04."

CUDAROOT="$(cd "$(dirname "${BASH_SOURCE[0]}")" && pwd)/$(basename "${BASH_SOURCE[0]}")"
CUDAROOT=$(dirname $CUDAROOT)

export CUDA_PATH=$CUDAROOT
export CUDA_HOME=$CUDAROOT
export CUDA_BIN_PATH=$CUDA_PATH/bin
export PATH=$CUDA_BIN_PATH:$PATH
export LD_LIBRARY_PATH=$LD_LIBRARY_PATH:$CUDA_PATH/lib64
export C_INCLUDE_PATH=$CUDA_PATH/include${C_INCLUDE_PATH:+:${C_INCLUDE_PATH}}
export CPLUS_INCLUDE_PATH=$CUDA_PATH/include${CPLUS_INCLUDE_PATH:+:${CPLUS_INCLUDE_PATH}}
export CUDAARCHS=52