import gradio as gr
import torch
from TTS.api import TTS
import os

os.environ["COQUI_TOS_AGREED"] = "1"

device = "cuda"

tts = TTS("tts_models/multilingual/multi-dataset/xtts_v2").to(device)


def clone(text, audio, language):
    tts.tts_to_file(text=text, speaker_wav=audio, language=language, file_path="./output.wav")
    return "./output.wav"


iface = gr.Interface(fn=clone,
                     inputs=[gr.Textbox(label='文字'),
                             gr.Audio(type='filepath', label='参考语音'),
                             gr.Dropdown(label='语言',
                                         choices=['en', 'es', 'fr', 'de', 'it', 'pt', 'pl', 'tr', 'ru', 'nl', 'cs',
                                                  'ar', 'zh-cn', 'hu', 'ko', 'ja', 'hi'],
                                         value='zh-cn')],
                     outputs=gr.Audio(type='filepath', label='生成语音'),
                     title='Voice Clone：语音克隆工具',
                     allow_flagging="never",
                     theme=gr.themes.Base(primary_hue="teal", secondary_hue="teal", neutral_hue="slate"),
                     examples=[["前行必有曙光。",
                                "./audio/xiaozhan.wav", "zh-cn"],
                               ["Hey! It's me Dorthy, from the Wizard of Oz. Type in whatever you'd like me to say.",
                                "./audio/Wizard-of-Oz-Dorthy.wav", "en"],
                               ["It's me Vito Corleone, from the Godfather. Type in whatever you'd like me to say.",
                                "./audio/Godfather.wav", "en"],
                               ["Hey, it's me Paris Hilton. Type in whatever you'd like me to say.",
                                "./audio/Paris-Hilton.mp3", "en"],
                               ["Hey, it's me Megan Fox from Transformers. Type in whatever you'd like me to say.",
                                "./audio/Megan-Fox.mp3", "en"],
                               ["Hey there, it's me Jeff Goldblum. Type in whatever you'd like me to say.",
                                "./audio/Jeff-Goldblum.mp3", "en"],
                               ["It's me Vito Corleone, from the Godfather. Type in whatever you'd like me to say.",
                                "./audio/Godfather.wav", "en"]
                               ])
iface.launch(server_name='0.0.0.0', share=True)
