# How to contribute to transformers?

Everyone is welcome to contribute, and we value everybody's contribution. Code
is thus not the only way to contribute. Answering questions, helping others,
reaching out and improving the documentations are immensely valuable to the
community.

It also helps us if you spread the word: reference the library from blog posts
on the awesome projects it made possible, shout out on twitter every time it has
helped you, or simply star the repo to say "thank you".

## You can contribute in so many ways!

There are 4 ways you can contribute to transformers:
* Fixing outstanding issues with the existing code;
* Implementing new models;
* Contributing to the examples, or to the documentation;
* Submitting issues related to bugs or desired new features.

*All are equally valuable to the community.*

## Submitting a new issue or feature request

Do your best to follow these guidelines when submitting an issue or a feature
request. It will make it easier for us to come back to you quickly and with good
feedback.

### Did you find a bug?

The transformers are robust and reliable thanks to the users who notify us of
the problems they encounter.

So thank you for reporting an issue. First, we would really appreciate it if you
could **make sure the bug was not already reported** (use the search bar on
Github under Issues).

Did not find it? :( So we can act quickly on it, please follow these steps:

* Include your **OS type and version**, the versions of **Python**, **PyTorch** and
  **Tensorflow** when applicable;
* A short, self-contained, code snippet that allows us to reproduce the bug in
  less than 30s.
* Provide the *full* traceback if an exception is raised.

To get the OS and software versions, execute the following code and copy-paste
the output:

```
import platform; print("Platform", platform.platform())
import sys; print("Python", sys.version)
import torch; print("PyTorch", torch.__version__)
import tensorflow; print("Tensorflow", tensorflow.__version__)
```

### Do you want to implement a new model?

Please provide the following:

* Short description of the model and link to the paper
* Link to the implementation if open-source
* Link to the model weights if they are available

Let us know if you are willing to contribute so we can best guide you. 

### Do you want a new feature (that is not a model)?

A world-class feature request addresses the following points:

1. Motivation first:
  * Is it related to a problem/frustration with the library? If so, please explain
    why. Providing a code snippet that demonstrates the problem is best.
  * Is it related to something you would need for a project? We'd love to hear
    about it!
  * Is it something you worked on and think could benefit the community?
    Awesome! Tell us what problem it solved for you.
2. Write a *full paragraph* describing the feature.  
3. Provide a **code snippet** that demonstrates its future use.
4. In case this is related to a paper, please provide a link
5. Attach any additional information (drawings, screenshots, etc.) you think may help.

If your issue is well-written we're already 80% of the way there by the time you
post it.

## Contributing code

## Contributing examples
