#!/usr/bin/env bash

CUDA_VISIBLE_DEVICES=2 python run_audio_classification_one_layer.py \
    --model_name_or_path "facebook/mms-lid-4017" \
    --train_dataset_name "stable-speech/concatenated-normalized-accent-dataset" \
    --train_dataset_config_name "default" \
    --train_split_name "train" \
    --train_label_column_name "labels" \
    --eval_dataset_name "stable-speech/concatenated-normalized-accent-dataset" \
    --eval_dataset_config_name "default" \
    --eval_split_name "test" \
    --eval_label_column_name "labels" \
    --output_dir "./tmp/" \
    --do_train \
    --do_eval \
    --overwrite_output_dir \
    --remove_unused_columns false \
    --fp16 \
    --fp16_full_eval \
    --learning_rate 1e-4 \
    --max_length_seconds 20 \
    --min_length_seconds 5 \
    --attention_mask \
    --warmup_steps 100 \
    --max_steps 2000 \
    --per_device_train_batch_size 32 \
    --per_device_eval_batch_size 32 \
    --preprocessing_num_workers 4 \
    --dataloader_num_workers 4 \
    --logging_strategy "steps" \
    --logging_steps 10 \
    --evaluation_strategy "steps" \
    --eval_steps 300 \
    --save_strategy "no" \
    --save_steps 2000 \
    --freeze_base_model true \
    --freeze_feature_encoder true \
    --push_to_hub false \
    --trust_remote_code \
    --use_weighted_layer_sum true \
