## Pull Request Checklist

- [ ] **Description:** Briefly describe the changes in this pull request.
- [ ] **Changelog:** Ensure a changelog entry following the format of [Keep a Changelog](https://keepachangelog.com/) is added at the bottom of the PR description.
- [ ] **Documentation:** Have you updated relevant documentation, including [README](https://github.com/open-webui/open-webui/blob/main/README.md), [Open WebUI Docs](https://docs.openwebui.com/), or other documentation sources?
- [ ] **Dependencies:** Are there any new dependencies? Have you updated the dependency versions in the documentation?
- [ ] **Testing:** Have you written and run sufficient tests for the changes?
- [ ] **Code Review:** Have you self-reviewed your code and addressed any coding standard issues?

---

## Description

[Insert a brief description of the changes made in this pull request, including any relevant background or motivation. Consider including answers to the following questions:
* What problem does this PR solve?
* How does it improve the project or fix an issue?
* What changes were made to achieve this outcome?]

---

### Changelog Entry

### Added

- [List any new features, functionalities, or additions]

### Fixed

- [List any fixes or corrections, including bug fixes, typo fixes, or other corrections]

### Changed

- [List any changes or updates, including refactorings, optimizations, or other modifications]

### Removed

- [List any removed features, files, or deprecated functionalities and APIs]

### Security

- [List any security-related changes, including vulnerability fixes or security enhancements]

### Breaking Changes

- [List any breaking changes, including changes that may affect existing functionality or compatibility]

---

### Additional Information

* [Insert any additional context, notes, or explanations for the changes]

* [Mention any related issues, commits, or other references]
