import { WEBUI_API_BASE_URL } from '$lib/constants';

export const setDefaultModels = async (token: string, models: string) => {
	let error = null;

	const res = await fetch(`${WEBUI_API_BASE_URL}/configs/default/models`, {
		method: 'POST',
		headers: {
			'Content-Type': 'application/json',
			Authorization: `Bearer ${token}`
		},
		body: JSON.stringify({
			models: models
		})
	})
		.then(async (res) => {
			if (!res.ok) throw await res.json();
			return res.json();
		})
		.catch((err) => {
			console.log(err);
			error = err.detail;
			return null;
		});

	if (error) {
		throw error;
	}

	return res;
};
