import os
import sys
import paddle
import subprocess
import re

os.system('cat /etc/issue')
print('Python version:', sys.version)
print('PaddlePaddle version:', paddle.__version__)

version = paddle.__version__
version_pattern = r"(\d+)\.(\d+)\.(\d+)"
match = re.match(version_pattern, version)
major_version, minor_version, patch_version = map(int, match.groups())

if major_version >= 3 or (major_version >= 2 and minor_version >= 4):
    gpu_available = paddle.device.is_compiled_with_cuda()
    print('PaddlePaddle GPU available:', gpu_available)
    cuda_version = paddle.version.cuda() if gpu_available else 'No CUDA available'
    cudnn_version = paddle.version.cudnn() if gpu_available else 'No cuDNN available'
    print('PaddlePaddle CUDA version:', cuda_version)
    print('PaddlePaddle cuDNN version:', cudnn_version)

elif major_version >= 2 and minor_version < 4:
    gpu_available = paddle.device.is_compiled_with_cuda()
    print('PaddlePaddle GPU available:', gpu_available)
    cuda_version = subprocess.getoutput('nvcc --version')
    print('CUDA Version:')
    print(cuda_version)
    cudnn_version = subprocess.getoutput('dpkg -l | grep cudnn')
    print('\ncuDNN Version:')
    print(cudnn_version)

else:
    gpu_available = paddle.fluid.core.is_compiled_with_cuda()
    print('PaddlePaddle cuda available:', gpu_available)
    cuda_version = subprocess.getoutput('nvcc --version')
    print('CUDA Version:')
    print(cuda_version)
    cudnn_version = subprocess.getoutput('dpkg -l | grep cudnn')
    print('\ncuDNN Version:')
    print(cudnn_version)
