/// <reference types="node" />
import * as http from 'http';
import type * as https from 'https';
import * as tls from 'tls';
import * as nodeurl from 'url';
export declare enum LogLevel {
    Trace = 0,
    Debug = 1,
    Info = 2,
    Warning = 3,
    Error = 4,
    Critical = 5,
    Off = 6
}
export declare type ProxyResolveEvent = {
    count: number;
    duration: number;
    errorCount: number;
    cacheCount: number;
    cacheSize: number;
    cacheRolls: number;
    envCount: number;
    settingsCount: number;
    localhostCount: number;
    envNoProxyCount: number;
    results: ConnectionResult[];
};
interface ConnectionResult {
    proxy: string;
    connection: string;
    code: string;
    count: number;
}
export interface ProxyAgentParams {
    resolveProxy(url: string): Promise<string | undefined>;
    getHttpProxySetting(): string | undefined;
    log(level: LogLevel, message: string, ...args: any[]): void;
    getLogLevel(): LogLevel;
    proxyResolveTelemetry(event: ProxyResolveEvent): void;
    useHostProxy: boolean;
    env: NodeJS.ProcessEnv;
}
export declare function createProxyResolver(params: ProxyAgentParams): (flags: {
    useProxySettings: boolean;
    useSystemCertificates: boolean;
}, req: http.ClientRequest, opts: http.RequestOptions, url: string, callback: (proxy?: string | undefined) => void) => void;
export declare type ProxySupportSetting = 'override' | 'fallback' | 'on' | 'off';
export declare function createHttpPatch(originals: typeof http | typeof https, resolveProxy: ReturnType<typeof createProxyResolver>, proxySetting: {
    config: ProxySupportSetting;
}, certSetting: {
    config: boolean;
}, onRequest: boolean): {
    get: (url?: string | nodeurl.URL | null | undefined, options?: http.RequestOptions | null | undefined, callback?: ((res: http.IncomingMessage) => void) | undefined) => http.ClientRequest;
    request: (url?: string | nodeurl.URL | null | undefined, options?: http.RequestOptions | null | undefined, callback?: ((res: http.IncomingMessage) => void) | undefined) => http.ClientRequest;
};
export interface SecureContextOptionsPatch {
    _vscodeAdditionalCaCerts?: string[];
}
export declare function createTlsPatch(originals: typeof tls): {
    createSecureContext: typeof tls.createSecureContext;
};
declare function useSystemCertificates(params: ProxyAgentParams, useSystemCertificates: boolean, opts: http.RequestOptions, callback: () => void): void;
export {};
