#!/bin/bash

# 检查是否提供了输入字符串
if [ "$#" -ne 1 ]; then
    echo "Error: No image name provided."
    exit 1
fi
# 读取输入字符串
image_name=$1

# 使用tr命令将:替换为-
filename=$(echo "$image_name".tar | tr ':' '-')
docker save -o $filename $image_name
echo "The image has been saved as $filename"