/**
 * AppInsightsCore.ts
 * @author Abhilash Panwar (abpanwar) Hector Hernandez (hectorh)
 * @copyright Microsoft 2018
 */
import { AppInsightsCore as InternalCore, IPlugin, ITelemetryItem, IDiagnosticLogger, INotificationManager } from "@microsoft/applicationinsights-core-js";
import { IExtendedConfiguration, IExtendedTelemetryItem, IExtendedAppInsightsCore } from "./DataModels";
export default class AppInsightsCore extends InternalCore implements IExtendedAppInsightsCore {
    getWParam: () => number;
    pluginVersionStringArr: string[];
    pluginVersionString: string;
    constructor();
    /**
     * Initialize the sdk.
     * @param config - The configuration to initialize the SDK.
     * @param extensions - An array of extensions that are to be used by the core.
     */
    initialize(config: IExtendedConfiguration, extensions: IPlugin[], logger?: IDiagnosticLogger, notificationManager?: INotificationManager): void;
    track(item: IExtendedTelemetryItem | ITelemetryItem): void;
}
