// Copyright 2021 Google LLC.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
/*eslint-disable block-scoped-var, id-length, no-control-regex, no-magic-numbers, no-prototype-builtins, no-redeclare, no-shadow, no-var, sort-vars*/
(function(global, factory) { /* global define, require, module */

    /* AMD */ if (typeof define === 'function' && define.amd)
        define(["protobufjs/minimal"], factory);

    /* CommonJS */ else if (typeof require === 'function' && typeof module === 'object' && module && module.exports)
        module.exports = factory(require("protobufjs/minimal"));

})(this, function($protobuf) {
    "use strict";

    // Common aliases
    var $Reader = $protobuf.Reader, $Writer = $protobuf.Writer, $util = $protobuf.util;

    // Exported root namespace
    var $root = $protobuf.roots.compute_operations_protos || ($protobuf.roots.compute_operations_protos = {});

    $root.google = (function() {

        /**
         * Namespace google.
         * @exports google
         * @namespace
         */
        var google = {};

        google.cloud = (function() {

            /**
             * Namespace cloud.
             * @memberof google
             * @namespace
             */
            var cloud = {};

            cloud.compute = (function() {

                /**
                 * Namespace compute.
                 * @memberof google.cloud
                 * @namespace
                 */
                var compute = {};

                compute.v1 = (function() {

                    /**
                     * Namespace v1.
                     * @memberof google.cloud.compute
                     * @namespace
                     */
                    var v1 = {};

                    v1.Operation = (function() {

                        /**
                         * Properties of an Operation.
                         * @memberof google.cloud.compute.v1
                         * @interface IOperation
                         * @property {string|null} [clientOperationId] Operation clientOperationId
                         * @property {string|null} [creationTimestamp] Operation creationTimestamp
                         * @property {string|null} [description] Operation description
                         * @property {string|null} [endTime] Operation endTime
                         * @property {google.cloud.compute.v1.IError|null} [error] Operation error
                         * @property {string|null} [httpErrorMessage] Operation httpErrorMessage
                         * @property {number|null} [httpErrorStatusCode] Operation httpErrorStatusCode
                         * @property {string|null} [id] Operation id
                         * @property {string|null} [insertTime] Operation insertTime
                         * @property {string|null} [kind] Operation kind
                         * @property {string|null} [name] Operation name
                         * @property {string|null} [operationType] Operation operationType
                         * @property {number|null} [progress] Operation progress
                         * @property {string|null} [region] Operation region
                         * @property {string|null} [selfLink] Operation selfLink
                         * @property {string|null} [startTime] Operation startTime
                         * @property {google.cloud.compute.v1.Operation.Status|null} [status] Operation status
                         * @property {string|null} [statusMessage] Operation statusMessage
                         * @property {string|null} [targetId] Operation targetId
                         * @property {string|null} [targetLink] Operation targetLink
                         * @property {string|null} [user] Operation user
                         * @property {Array.<google.cloud.compute.v1.IWarnings>|null} [warnings] Operation warnings
                         * @property {string|null} [zone] Operation zone
                         */

                        /**
                         * Constructs a new Operation.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an Operation.
                         * @implements IOperation
                         * @constructor
                         * @param {google.cloud.compute.v1.IOperation=} [properties] Properties to set
                         */
                        function Operation(properties) {
                            this.warnings = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Operation clientOperationId.
                         * @member {string|null|undefined} clientOperationId
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.clientOperationId = null;

                        /**
                         * Operation creationTimestamp.
                         * @member {string|null|undefined} creationTimestamp
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.creationTimestamp = null;

                        /**
                         * Operation description.
                         * @member {string|null|undefined} description
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.description = null;

                        /**
                         * Operation endTime.
                         * @member {string|null|undefined} endTime
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.endTime = null;

                        /**
                         * Operation error.
                         * @member {google.cloud.compute.v1.IError|null|undefined} error
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.error = null;

                        /**
                         * Operation httpErrorMessage.
                         * @member {string|null|undefined} httpErrorMessage
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.httpErrorMessage = null;

                        /**
                         * Operation httpErrorStatusCode.
                         * @member {number|null|undefined} httpErrorStatusCode
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.httpErrorStatusCode = null;

                        /**
                         * Operation id.
                         * @member {string|null|undefined} id
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.id = null;

                        /**
                         * Operation insertTime.
                         * @member {string|null|undefined} insertTime
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.insertTime = null;

                        /**
                         * Operation kind.
                         * @member {string|null|undefined} kind
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.kind = null;

                        /**
                         * Operation name.
                         * @member {string|null|undefined} name
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.name = null;

                        /**
                         * Operation operationType.
                         * @member {string|null|undefined} operationType
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.operationType = null;

                        /**
                         * Operation progress.
                         * @member {number|null|undefined} progress
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.progress = null;

                        /**
                         * Operation region.
                         * @member {string|null|undefined} region
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.region = null;

                        /**
                         * Operation selfLink.
                         * @member {string|null|undefined} selfLink
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.selfLink = null;

                        /**
                         * Operation startTime.
                         * @member {string|null|undefined} startTime
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.startTime = null;

                        /**
                         * Operation status.
                         * @member {google.cloud.compute.v1.Operation.Status|null|undefined} status
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.status = null;

                        /**
                         * Operation statusMessage.
                         * @member {string|null|undefined} statusMessage
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.statusMessage = null;

                        /**
                         * Operation targetId.
                         * @member {string|null|undefined} targetId
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.targetId = null;

                        /**
                         * Operation targetLink.
                         * @member {string|null|undefined} targetLink
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.targetLink = null;

                        /**
                         * Operation user.
                         * @member {string|null|undefined} user
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.user = null;

                        /**
                         * Operation warnings.
                         * @member {Array.<google.cloud.compute.v1.IWarnings>} warnings
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.warnings = $util.emptyArray;

                        /**
                         * Operation zone.
                         * @member {string|null|undefined} zone
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Operation.prototype.zone = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * Operation _clientOperationId.
                         * @member {"clientOperationId"|undefined} _clientOperationId
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_clientOperationId", {
                            get: $util.oneOfGetter($oneOfFields = ["clientOperationId"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _creationTimestamp.
                         * @member {"creationTimestamp"|undefined} _creationTimestamp
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_creationTimestamp", {
                            get: $util.oneOfGetter($oneOfFields = ["creationTimestamp"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _description.
                         * @member {"description"|undefined} _description
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_description", {
                            get: $util.oneOfGetter($oneOfFields = ["description"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _endTime.
                         * @member {"endTime"|undefined} _endTime
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_endTime", {
                            get: $util.oneOfGetter($oneOfFields = ["endTime"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _error.
                         * @member {"error"|undefined} _error
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_error", {
                            get: $util.oneOfGetter($oneOfFields = ["error"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _httpErrorMessage.
                         * @member {"httpErrorMessage"|undefined} _httpErrorMessage
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_httpErrorMessage", {
                            get: $util.oneOfGetter($oneOfFields = ["httpErrorMessage"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _httpErrorStatusCode.
                         * @member {"httpErrorStatusCode"|undefined} _httpErrorStatusCode
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_httpErrorStatusCode", {
                            get: $util.oneOfGetter($oneOfFields = ["httpErrorStatusCode"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _id.
                         * @member {"id"|undefined} _id
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_id", {
                            get: $util.oneOfGetter($oneOfFields = ["id"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _insertTime.
                         * @member {"insertTime"|undefined} _insertTime
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_insertTime", {
                            get: $util.oneOfGetter($oneOfFields = ["insertTime"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _kind.
                         * @member {"kind"|undefined} _kind
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_kind", {
                            get: $util.oneOfGetter($oneOfFields = ["kind"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _name.
                         * @member {"name"|undefined} _name
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_name", {
                            get: $util.oneOfGetter($oneOfFields = ["name"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _operationType.
                         * @member {"operationType"|undefined} _operationType
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_operationType", {
                            get: $util.oneOfGetter($oneOfFields = ["operationType"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _progress.
                         * @member {"progress"|undefined} _progress
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_progress", {
                            get: $util.oneOfGetter($oneOfFields = ["progress"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _region.
                         * @member {"region"|undefined} _region
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_region", {
                            get: $util.oneOfGetter($oneOfFields = ["region"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _selfLink.
                         * @member {"selfLink"|undefined} _selfLink
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_selfLink", {
                            get: $util.oneOfGetter($oneOfFields = ["selfLink"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _startTime.
                         * @member {"startTime"|undefined} _startTime
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_startTime", {
                            get: $util.oneOfGetter($oneOfFields = ["startTime"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _status.
                         * @member {"status"|undefined} _status
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_status", {
                            get: $util.oneOfGetter($oneOfFields = ["status"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _statusMessage.
                         * @member {"statusMessage"|undefined} _statusMessage
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_statusMessage", {
                            get: $util.oneOfGetter($oneOfFields = ["statusMessage"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _targetId.
                         * @member {"targetId"|undefined} _targetId
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_targetId", {
                            get: $util.oneOfGetter($oneOfFields = ["targetId"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _targetLink.
                         * @member {"targetLink"|undefined} _targetLink
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_targetLink", {
                            get: $util.oneOfGetter($oneOfFields = ["targetLink"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _user.
                         * @member {"user"|undefined} _user
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_user", {
                            get: $util.oneOfGetter($oneOfFields = ["user"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Operation _zone.
                         * @member {"zone"|undefined} _zone
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         */
                        Object.defineProperty(Operation.prototype, "_zone", {
                            get: $util.oneOfGetter($oneOfFields = ["zone"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new Operation instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {google.cloud.compute.v1.IOperation=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.Operation} Operation instance
                         */
                        Operation.create = function create(properties) {
                            return new Operation(properties);
                        };

                        /**
                         * Encodes the specified Operation message. Does not implicitly {@link google.cloud.compute.v1.Operation.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {google.cloud.compute.v1.IOperation} message Operation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Operation.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 3355, wireType 2 =*/26842).string(message.id);
                            if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                                writer.uint32(/* id 3292052, wireType 2 =*/26336418).string(message.kind);
                            if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                                writer.uint32(/* id 3373707, wireType 2 =*/26989658).string(message.name);
                            if (message.user != null && Object.hasOwnProperty.call(message, "user"))
                                writer.uint32(/* id 3599307, wireType 2 =*/28794458).string(message.user);
                            if (message.zone != null && Object.hasOwnProperty.call(message, "zone"))
                                writer.uint32(/* id 3744684, wireType 2 =*/29957474).string(message.zone);
                            if (message.creationTimestamp != null && Object.hasOwnProperty.call(message, "creationTimestamp"))
                                writer.uint32(/* id 30525366, wireType 2 =*/244202930).string(message.creationTimestamp);
                            if (message.startTime != null && Object.hasOwnProperty.call(message, "startTime"))
                                writer.uint32(/* id 37467274, wireType 2 =*/299738194).string(message.startTime);
                            if (message.targetLink != null && Object.hasOwnProperty.call(message, "targetLink"))
                                writer.uint32(/* id 62671336, wireType 2 =*/501370690).string(message.targetLink);
                            if (message.progress != null && Object.hasOwnProperty.call(message, "progress"))
                                writer.uint32(/* id 72663597, wireType 0 =*/581308776).int32(message.progress);
                            if (message.error != null && Object.hasOwnProperty.call(message, "error"))
                                $root.google.cloud.compute.v1.Error.encode(message.error, writer.uint32(/* id 96784904, wireType 2 =*/774279234).fork()).ldelim();
                            if (message.endTime != null && Object.hasOwnProperty.call(message, "endTime"))
                                writer.uint32(/* id 114938801, wireType 2 =*/919510410).string(message.endTime);
                            if (message.region != null && Object.hasOwnProperty.call(message, "region"))
                                writer.uint32(/* id 138946292, wireType 2 =*/1111570338).string(message.region);
                            if (message.operationType != null && Object.hasOwnProperty.call(message, "operationType"))
                                writer.uint32(/* id 177650450, wireType 2 =*/1421203602).string(message.operationType);
                            if (message.status != null && Object.hasOwnProperty.call(message, "status"))
                                writer.uint32(/* id 181260274, wireType 0 =*/1450082192).int32(message.status);
                            if (message.httpErrorMessage != null && Object.hasOwnProperty.call(message, "httpErrorMessage"))
                                writer.uint32(/* id 202521945, wireType 2 =*/1620175562).string(message.httpErrorMessage);
                            if (message.targetId != null && Object.hasOwnProperty.call(message, "targetId"))
                                writer.uint32(/* id 258165385, wireType 2 =*/2065323082).string(message.targetId);
                            if (message.clientOperationId != null && Object.hasOwnProperty.call(message, "clientOperationId"))
                                writer.uint32(/* id 297240295, wireType 2 =*/2377922362).string(message.clientOperationId);
                            if (message.statusMessage != null && Object.hasOwnProperty.call(message, "statusMessage"))
                                writer.uint32(/* id 297428154, wireType 2 =*/2379425234).string(message.statusMessage);
                            if (message.httpErrorStatusCode != null && Object.hasOwnProperty.call(message, "httpErrorStatusCode"))
                                writer.uint32(/* id 312345196, wireType 0 =*/2498761568).int32(message.httpErrorStatusCode);
                            if (message.description != null && Object.hasOwnProperty.call(message, "description"))
                                writer.uint32(/* id 422937596, wireType 2 =*/3383500770).string(message.description);
                            if (message.insertTime != null && Object.hasOwnProperty.call(message, "insertTime"))
                                writer.uint32(/* id 433722515, wireType 2 =*/3469780122).string(message.insertTime);
                            if (message.selfLink != null && Object.hasOwnProperty.call(message, "selfLink"))
                                writer.uint32(/* id 456214797, wireType 2 =*/3649718378).string(message.selfLink);
                            if (message.warnings != null && message.warnings.length)
                                for (var i = 0; i < message.warnings.length; ++i)
                                    $root.google.cloud.compute.v1.Warnings.encode(message.warnings[i], writer.uint32(/* id 498091095, wireType 2 =*/3984728762).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified Operation message, length delimited. Does not implicitly {@link google.cloud.compute.v1.Operation.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {google.cloud.compute.v1.IOperation} message Operation message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Operation.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an Operation message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.Operation} Operation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Operation.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.Operation();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 297240295:
                                    message.clientOperationId = reader.string();
                                    break;
                                case 30525366:
                                    message.creationTimestamp = reader.string();
                                    break;
                                case 422937596:
                                    message.description = reader.string();
                                    break;
                                case 114938801:
                                    message.endTime = reader.string();
                                    break;
                                case 96784904:
                                    message.error = $root.google.cloud.compute.v1.Error.decode(reader, reader.uint32());
                                    break;
                                case 202521945:
                                    message.httpErrorMessage = reader.string();
                                    break;
                                case 312345196:
                                    message.httpErrorStatusCode = reader.int32();
                                    break;
                                case 3355:
                                    message.id = reader.string();
                                    break;
                                case 433722515:
                                    message.insertTime = reader.string();
                                    break;
                                case 3292052:
                                    message.kind = reader.string();
                                    break;
                                case 3373707:
                                    message.name = reader.string();
                                    break;
                                case 177650450:
                                    message.operationType = reader.string();
                                    break;
                                case 72663597:
                                    message.progress = reader.int32();
                                    break;
                                case 138946292:
                                    message.region = reader.string();
                                    break;
                                case 456214797:
                                    message.selfLink = reader.string();
                                    break;
                                case 37467274:
                                    message.startTime = reader.string();
                                    break;
                                case 181260274:
                                    message.status = reader.int32();
                                    break;
                                case 297428154:
                                    message.statusMessage = reader.string();
                                    break;
                                case 258165385:
                                    message.targetId = reader.string();
                                    break;
                                case 62671336:
                                    message.targetLink = reader.string();
                                    break;
                                case 3599307:
                                    message.user = reader.string();
                                    break;
                                case 498091095:
                                    if (!(message.warnings && message.warnings.length))
                                        message.warnings = [];
                                    message.warnings.push($root.google.cloud.compute.v1.Warnings.decode(reader, reader.uint32()));
                                    break;
                                case 3744684:
                                    message.zone = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an Operation message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.Operation} Operation
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Operation.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an Operation message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Operation.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.clientOperationId != null && message.hasOwnProperty("clientOperationId")) {
                                properties._clientOperationId = 1;
                                if (!$util.isString(message.clientOperationId))
                                    return "clientOperationId: string expected";
                            }
                            if (message.creationTimestamp != null && message.hasOwnProperty("creationTimestamp")) {
                                properties._creationTimestamp = 1;
                                if (!$util.isString(message.creationTimestamp))
                                    return "creationTimestamp: string expected";
                            }
                            if (message.description != null && message.hasOwnProperty("description")) {
                                properties._description = 1;
                                if (!$util.isString(message.description))
                                    return "description: string expected";
                            }
                            if (message.endTime != null && message.hasOwnProperty("endTime")) {
                                properties._endTime = 1;
                                if (!$util.isString(message.endTime))
                                    return "endTime: string expected";
                            }
                            if (message.error != null && message.hasOwnProperty("error")) {
                                properties._error = 1;
                                {
                                    var error = $root.google.cloud.compute.v1.Error.verify(message.error);
                                    if (error)
                                        return "error." + error;
                                }
                            }
                            if (message.httpErrorMessage != null && message.hasOwnProperty("httpErrorMessage")) {
                                properties._httpErrorMessage = 1;
                                if (!$util.isString(message.httpErrorMessage))
                                    return "httpErrorMessage: string expected";
                            }
                            if (message.httpErrorStatusCode != null && message.hasOwnProperty("httpErrorStatusCode")) {
                                properties._httpErrorStatusCode = 1;
                                if (!$util.isInteger(message.httpErrorStatusCode))
                                    return "httpErrorStatusCode: integer expected";
                            }
                            if (message.id != null && message.hasOwnProperty("id")) {
                                properties._id = 1;
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            }
                            if (message.insertTime != null && message.hasOwnProperty("insertTime")) {
                                properties._insertTime = 1;
                                if (!$util.isString(message.insertTime))
                                    return "insertTime: string expected";
                            }
                            if (message.kind != null && message.hasOwnProperty("kind")) {
                                properties._kind = 1;
                                if (!$util.isString(message.kind))
                                    return "kind: string expected";
                            }
                            if (message.name != null && message.hasOwnProperty("name")) {
                                properties._name = 1;
                                if (!$util.isString(message.name))
                                    return "name: string expected";
                            }
                            if (message.operationType != null && message.hasOwnProperty("operationType")) {
                                properties._operationType = 1;
                                if (!$util.isString(message.operationType))
                                    return "operationType: string expected";
                            }
                            if (message.progress != null && message.hasOwnProperty("progress")) {
                                properties._progress = 1;
                                if (!$util.isInteger(message.progress))
                                    return "progress: integer expected";
                            }
                            if (message.region != null && message.hasOwnProperty("region")) {
                                properties._region = 1;
                                if (!$util.isString(message.region))
                                    return "region: string expected";
                            }
                            if (message.selfLink != null && message.hasOwnProperty("selfLink")) {
                                properties._selfLink = 1;
                                if (!$util.isString(message.selfLink))
                                    return "selfLink: string expected";
                            }
                            if (message.startTime != null && message.hasOwnProperty("startTime")) {
                                properties._startTime = 1;
                                if (!$util.isString(message.startTime))
                                    return "startTime: string expected";
                            }
                            if (message.status != null && message.hasOwnProperty("status")) {
                                properties._status = 1;
                                switch (message.status) {
                                default:
                                    return "status: enum value expected";
                                case 0:
                                case 2104194:
                                case 35394935:
                                case 121282975:
                                    break;
                                }
                            }
                            if (message.statusMessage != null && message.hasOwnProperty("statusMessage")) {
                                properties._statusMessage = 1;
                                if (!$util.isString(message.statusMessage))
                                    return "statusMessage: string expected";
                            }
                            if (message.targetId != null && message.hasOwnProperty("targetId")) {
                                properties._targetId = 1;
                                if (!$util.isString(message.targetId))
                                    return "targetId: string expected";
                            }
                            if (message.targetLink != null && message.hasOwnProperty("targetLink")) {
                                properties._targetLink = 1;
                                if (!$util.isString(message.targetLink))
                                    return "targetLink: string expected";
                            }
                            if (message.user != null && message.hasOwnProperty("user")) {
                                properties._user = 1;
                                if (!$util.isString(message.user))
                                    return "user: string expected";
                            }
                            if (message.warnings != null && message.hasOwnProperty("warnings")) {
                                if (!Array.isArray(message.warnings))
                                    return "warnings: array expected";
                                for (var i = 0; i < message.warnings.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.Warnings.verify(message.warnings[i]);
                                    if (error)
                                        return "warnings." + error;
                                }
                            }
                            if (message.zone != null && message.hasOwnProperty("zone")) {
                                properties._zone = 1;
                                if (!$util.isString(message.zone))
                                    return "zone: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates an Operation message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.Operation} Operation
                         */
                        Operation.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.Operation)
                                return object;
                            var message = new $root.google.cloud.compute.v1.Operation();
                            if (object.clientOperationId != null)
                                message.clientOperationId = String(object.clientOperationId);
                            if (object.creationTimestamp != null)
                                message.creationTimestamp = String(object.creationTimestamp);
                            if (object.description != null)
                                message.description = String(object.description);
                            if (object.endTime != null)
                                message.endTime = String(object.endTime);
                            if (object.error != null) {
                                if (typeof object.error !== "object")
                                    throw TypeError(".google.cloud.compute.v1.Operation.error: object expected");
                                message.error = $root.google.cloud.compute.v1.Error.fromObject(object.error);
                            }
                            if (object.httpErrorMessage != null)
                                message.httpErrorMessage = String(object.httpErrorMessage);
                            if (object.httpErrorStatusCode != null)
                                message.httpErrorStatusCode = object.httpErrorStatusCode | 0;
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.insertTime != null)
                                message.insertTime = String(object.insertTime);
                            if (object.kind != null)
                                message.kind = String(object.kind);
                            if (object.name != null)
                                message.name = String(object.name);
                            if (object.operationType != null)
                                message.operationType = String(object.operationType);
                            if (object.progress != null)
                                message.progress = object.progress | 0;
                            if (object.region != null)
                                message.region = String(object.region);
                            if (object.selfLink != null)
                                message.selfLink = String(object.selfLink);
                            if (object.startTime != null)
                                message.startTime = String(object.startTime);
                            switch (object.status) {
                            case "UNDEFINED_STATUS":
                            case 0:
                                message.status = 0;
                                break;
                            case "DONE":
                            case 2104194:
                                message.status = 2104194;
                                break;
                            case "PENDING":
                            case 35394935:
                                message.status = 35394935;
                                break;
                            case "RUNNING":
                            case 121282975:
                                message.status = 121282975;
                                break;
                            }
                            if (object.statusMessage != null)
                                message.statusMessage = String(object.statusMessage);
                            if (object.targetId != null)
                                message.targetId = String(object.targetId);
                            if (object.targetLink != null)
                                message.targetLink = String(object.targetLink);
                            if (object.user != null)
                                message.user = String(object.user);
                            if (object.warnings) {
                                if (!Array.isArray(object.warnings))
                                    throw TypeError(".google.cloud.compute.v1.Operation.warnings: array expected");
                                message.warnings = [];
                                for (var i = 0; i < object.warnings.length; ++i) {
                                    if (typeof object.warnings[i] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.Operation.warnings: object expected");
                                    message.warnings[i] = $root.google.cloud.compute.v1.Warnings.fromObject(object.warnings[i]);
                                }
                            }
                            if (object.zone != null)
                                message.zone = String(object.zone);
                            return message;
                        };

                        /**
                         * Creates a plain object from an Operation message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.Operation
                         * @static
                         * @param {google.cloud.compute.v1.Operation} message Operation
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Operation.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.warnings = [];
                            if (message.id != null && message.hasOwnProperty("id")) {
                                object.id = message.id;
                                if (options.oneofs)
                                    object._id = "id";
                            }
                            if (message.kind != null && message.hasOwnProperty("kind")) {
                                object.kind = message.kind;
                                if (options.oneofs)
                                    object._kind = "kind";
                            }
                            if (message.name != null && message.hasOwnProperty("name")) {
                                object.name = message.name;
                                if (options.oneofs)
                                    object._name = "name";
                            }
                            if (message.user != null && message.hasOwnProperty("user")) {
                                object.user = message.user;
                                if (options.oneofs)
                                    object._user = "user";
                            }
                            if (message.zone != null && message.hasOwnProperty("zone")) {
                                object.zone = message.zone;
                                if (options.oneofs)
                                    object._zone = "zone";
                            }
                            if (message.creationTimestamp != null && message.hasOwnProperty("creationTimestamp")) {
                                object.creationTimestamp = message.creationTimestamp;
                                if (options.oneofs)
                                    object._creationTimestamp = "creationTimestamp";
                            }
                            if (message.startTime != null && message.hasOwnProperty("startTime")) {
                                object.startTime = message.startTime;
                                if (options.oneofs)
                                    object._startTime = "startTime";
                            }
                            if (message.targetLink != null && message.hasOwnProperty("targetLink")) {
                                object.targetLink = message.targetLink;
                                if (options.oneofs)
                                    object._targetLink = "targetLink";
                            }
                            if (message.progress != null && message.hasOwnProperty("progress")) {
                                object.progress = message.progress;
                                if (options.oneofs)
                                    object._progress = "progress";
                            }
                            if (message.error != null && message.hasOwnProperty("error")) {
                                object.error = $root.google.cloud.compute.v1.Error.toObject(message.error, options);
                                if (options.oneofs)
                                    object._error = "error";
                            }
                            if (message.endTime != null && message.hasOwnProperty("endTime")) {
                                object.endTime = message.endTime;
                                if (options.oneofs)
                                    object._endTime = "endTime";
                            }
                            if (message.region != null && message.hasOwnProperty("region")) {
                                object.region = message.region;
                                if (options.oneofs)
                                    object._region = "region";
                            }
                            if (message.operationType != null && message.hasOwnProperty("operationType")) {
                                object.operationType = message.operationType;
                                if (options.oneofs)
                                    object._operationType = "operationType";
                            }
                            if (message.status != null && message.hasOwnProperty("status")) {
                                object.status = options.enums === String ? $root.google.cloud.compute.v1.Operation.Status[message.status] : message.status;
                                if (options.oneofs)
                                    object._status = "status";
                            }
                            if (message.httpErrorMessage != null && message.hasOwnProperty("httpErrorMessage")) {
                                object.httpErrorMessage = message.httpErrorMessage;
                                if (options.oneofs)
                                    object._httpErrorMessage = "httpErrorMessage";
                            }
                            if (message.targetId != null && message.hasOwnProperty("targetId")) {
                                object.targetId = message.targetId;
                                if (options.oneofs)
                                    object._targetId = "targetId";
                            }
                            if (message.clientOperationId != null && message.hasOwnProperty("clientOperationId")) {
                                object.clientOperationId = message.clientOperationId;
                                if (options.oneofs)
                                    object._clientOperationId = "clientOperationId";
                            }
                            if (message.statusMessage != null && message.hasOwnProperty("statusMessage")) {
                                object.statusMessage = message.statusMessage;
                                if (options.oneofs)
                                    object._statusMessage = "statusMessage";
                            }
                            if (message.httpErrorStatusCode != null && message.hasOwnProperty("httpErrorStatusCode")) {
                                object.httpErrorStatusCode = message.httpErrorStatusCode;
                                if (options.oneofs)
                                    object._httpErrorStatusCode = "httpErrorStatusCode";
                            }
                            if (message.description != null && message.hasOwnProperty("description")) {
                                object.description = message.description;
                                if (options.oneofs)
                                    object._description = "description";
                            }
                            if (message.insertTime != null && message.hasOwnProperty("insertTime")) {
                                object.insertTime = message.insertTime;
                                if (options.oneofs)
                                    object._insertTime = "insertTime";
                            }
                            if (message.selfLink != null && message.hasOwnProperty("selfLink")) {
                                object.selfLink = message.selfLink;
                                if (options.oneofs)
                                    object._selfLink = "selfLink";
                            }
                            if (message.warnings && message.warnings.length) {
                                object.warnings = [];
                                for (var j = 0; j < message.warnings.length; ++j)
                                    object.warnings[j] = $root.google.cloud.compute.v1.Warnings.toObject(message.warnings[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this Operation to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.Operation
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Operation.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        /**
                         * Status enum.
                         * @name google.cloud.compute.v1.Operation.Status
                         * @enum {number}
                         * @property {number} UNDEFINED_STATUS=0 UNDEFINED_STATUS value
                         * @property {number} DONE=2104194 DONE value
                         * @property {number} PENDING=35394935 PENDING value
                         * @property {number} RUNNING=121282975 RUNNING value
                         */
                        Operation.Status = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "UNDEFINED_STATUS"] = 0;
                            values[valuesById[2104194] = "DONE"] = 2104194;
                            values[valuesById[35394935] = "PENDING"] = 35394935;
                            values[valuesById[121282975] = "RUNNING"] = 121282975;
                            return values;
                        })();

                        return Operation;
                    })();

                    v1.Errors = (function() {

                        /**
                         * Properties of an Errors.
                         * @memberof google.cloud.compute.v1
                         * @interface IErrors
                         * @property {string|null} [code] Errors code
                         * @property {string|null} [location] Errors location
                         * @property {string|null} [message] Errors message
                         */

                        /**
                         * Constructs a new Errors.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an Errors.
                         * @implements IErrors
                         * @constructor
                         * @param {google.cloud.compute.v1.IErrors=} [properties] Properties to set
                         */
                        function Errors(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Errors code.
                         * @member {string|null|undefined} code
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         */
                        Errors.prototype.code = null;

                        /**
                         * Errors location.
                         * @member {string|null|undefined} location
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         */
                        Errors.prototype.location = null;

                        /**
                         * Errors message.
                         * @member {string|null|undefined} message
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         */
                        Errors.prototype.message = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * Errors _code.
                         * @member {"code"|undefined} _code
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         */
                        Object.defineProperty(Errors.prototype, "_code", {
                            get: $util.oneOfGetter($oneOfFields = ["code"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Errors _location.
                         * @member {"location"|undefined} _location
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         */
                        Object.defineProperty(Errors.prototype, "_location", {
                            get: $util.oneOfGetter($oneOfFields = ["location"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Errors _message.
                         * @member {"message"|undefined} _message
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         */
                        Object.defineProperty(Errors.prototype, "_message", {
                            get: $util.oneOfGetter($oneOfFields = ["message"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new Errors instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {google.cloud.compute.v1.IErrors=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.Errors} Errors instance
                         */
                        Errors.create = function create(properties) {
                            return new Errors(properties);
                        };

                        /**
                         * Encodes the specified Errors message. Does not implicitly {@link google.cloud.compute.v1.Errors.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {google.cloud.compute.v1.IErrors} message Errors message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Errors.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                                writer.uint32(/* id 3059181, wireType 2 =*/24473450).string(message.code);
                            if (message.location != null && Object.hasOwnProperty.call(message, "location"))
                                writer.uint32(/* id 290430901, wireType 2 =*/2323447210).string(message.location);
                            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                                writer.uint32(/* id 418054151, wireType 2 =*/3344433210).string(message.message);
                            return writer;
                        };

                        /**
                         * Encodes the specified Errors message, length delimited. Does not implicitly {@link google.cloud.compute.v1.Errors.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {google.cloud.compute.v1.IErrors} message Errors message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Errors.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an Errors message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.Errors} Errors
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Errors.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.Errors();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3059181:
                                    message.code = reader.string();
                                    break;
                                case 290430901:
                                    message.location = reader.string();
                                    break;
                                case 418054151:
                                    message.message = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an Errors message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.Errors} Errors
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Errors.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an Errors message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Errors.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.code != null && message.hasOwnProperty("code")) {
                                properties._code = 1;
                                if (!$util.isString(message.code))
                                    return "code: string expected";
                            }
                            if (message.location != null && message.hasOwnProperty("location")) {
                                properties._location = 1;
                                if (!$util.isString(message.location))
                                    return "location: string expected";
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                properties._message = 1;
                                if (!$util.isString(message.message))
                                    return "message: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates an Errors message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.Errors} Errors
                         */
                        Errors.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.Errors)
                                return object;
                            var message = new $root.google.cloud.compute.v1.Errors();
                            if (object.code != null)
                                message.code = String(object.code);
                            if (object.location != null)
                                message.location = String(object.location);
                            if (object.message != null)
                                message.message = String(object.message);
                            return message;
                        };

                        /**
                         * Creates a plain object from an Errors message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.Errors
                         * @static
                         * @param {google.cloud.compute.v1.Errors} message Errors
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Errors.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.code != null && message.hasOwnProperty("code")) {
                                object.code = message.code;
                                if (options.oneofs)
                                    object._code = "code";
                            }
                            if (message.location != null && message.hasOwnProperty("location")) {
                                object.location = message.location;
                                if (options.oneofs)
                                    object._location = "location";
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                object.message = message.message;
                                if (options.oneofs)
                                    object._message = "message";
                            }
                            return object;
                        };

                        /**
                         * Converts this Errors to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.Errors
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Errors.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Errors;
                    })();

                    v1.Error = (function() {

                        /**
                         * Properties of an Error.
                         * @memberof google.cloud.compute.v1
                         * @interface IError
                         * @property {Array.<google.cloud.compute.v1.IErrors>|null} [errors] Error errors
                         */

                        /**
                         * Constructs a new Error.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an Error.
                         * @implements IError
                         * @constructor
                         * @param {google.cloud.compute.v1.IError=} [properties] Properties to set
                         */
                        function Error(properties) {
                            this.errors = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Error errors.
                         * @member {Array.<google.cloud.compute.v1.IErrors>} errors
                         * @memberof google.cloud.compute.v1.Error
                         * @instance
                         */
                        Error.prototype.errors = $util.emptyArray;

                        /**
                         * Creates a new Error instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {google.cloud.compute.v1.IError=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.Error} Error instance
                         */
                        Error.create = function create(properties) {
                            return new Error(properties);
                        };

                        /**
                         * Encodes the specified Error message. Does not implicitly {@link google.cloud.compute.v1.Error.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {google.cloud.compute.v1.IError} message Error message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Error.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.errors != null && message.errors.length)
                                for (var i = 0; i < message.errors.length; ++i)
                                    $root.google.cloud.compute.v1.Errors.encode(message.errors[i], writer.uint32(/* id 315977579, wireType 2 =*/2527820634).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified Error message, length delimited. Does not implicitly {@link google.cloud.compute.v1.Error.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {google.cloud.compute.v1.IError} message Error message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Error.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an Error message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.Error} Error
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Error.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.Error();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 315977579:
                                    if (!(message.errors && message.errors.length))
                                        message.errors = [];
                                    message.errors.push($root.google.cloud.compute.v1.Errors.decode(reader, reader.uint32()));
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an Error message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.Error} Error
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Error.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an Error message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Error.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.errors != null && message.hasOwnProperty("errors")) {
                                if (!Array.isArray(message.errors))
                                    return "errors: array expected";
                                for (var i = 0; i < message.errors.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.Errors.verify(message.errors[i]);
                                    if (error)
                                        return "errors." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates an Error message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.Error} Error
                         */
                        Error.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.Error)
                                return object;
                            var message = new $root.google.cloud.compute.v1.Error();
                            if (object.errors) {
                                if (!Array.isArray(object.errors))
                                    throw TypeError(".google.cloud.compute.v1.Error.errors: array expected");
                                message.errors = [];
                                for (var i = 0; i < object.errors.length; ++i) {
                                    if (typeof object.errors[i] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.Error.errors: object expected");
                                    message.errors[i] = $root.google.cloud.compute.v1.Errors.fromObject(object.errors[i]);
                                }
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an Error message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.Error
                         * @static
                         * @param {google.cloud.compute.v1.Error} message Error
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Error.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.errors = [];
                            if (message.errors && message.errors.length) {
                                object.errors = [];
                                for (var j = 0; j < message.errors.length; ++j)
                                    object.errors[j] = $root.google.cloud.compute.v1.Errors.toObject(message.errors[j], options);
                            }
                            return object;
                        };

                        /**
                         * Converts this Error to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.Error
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Error.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Error;
                    })();

                    v1.Warnings = (function() {

                        /**
                         * Properties of a Warnings.
                         * @memberof google.cloud.compute.v1
                         * @interface IWarnings
                         * @property {google.cloud.compute.v1.Warnings.Code|null} [code] Warnings code
                         * @property {Array.<google.cloud.compute.v1.IData>|null} [data] Warnings data
                         * @property {string|null} [message] Warnings message
                         */

                        /**
                         * Constructs a new Warnings.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a Warnings.
                         * @implements IWarnings
                         * @constructor
                         * @param {google.cloud.compute.v1.IWarnings=} [properties] Properties to set
                         */
                        function Warnings(properties) {
                            this.data = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Warnings code.
                         * @member {google.cloud.compute.v1.Warnings.Code|null|undefined} code
                         * @memberof google.cloud.compute.v1.Warnings
                         * @instance
                         */
                        Warnings.prototype.code = null;

                        /**
                         * Warnings data.
                         * @member {Array.<google.cloud.compute.v1.IData>} data
                         * @memberof google.cloud.compute.v1.Warnings
                         * @instance
                         */
                        Warnings.prototype.data = $util.emptyArray;

                        /**
                         * Warnings message.
                         * @member {string|null|undefined} message
                         * @memberof google.cloud.compute.v1.Warnings
                         * @instance
                         */
                        Warnings.prototype.message = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * Warnings _code.
                         * @member {"code"|undefined} _code
                         * @memberof google.cloud.compute.v1.Warnings
                         * @instance
                         */
                        Object.defineProperty(Warnings.prototype, "_code", {
                            get: $util.oneOfGetter($oneOfFields = ["code"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Warnings _message.
                         * @member {"message"|undefined} _message
                         * @memberof google.cloud.compute.v1.Warnings
                         * @instance
                         */
                        Object.defineProperty(Warnings.prototype, "_message", {
                            get: $util.oneOfGetter($oneOfFields = ["message"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new Warnings instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {google.cloud.compute.v1.IWarnings=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.Warnings} Warnings instance
                         */
                        Warnings.create = function create(properties) {
                            return new Warnings(properties);
                        };

                        /**
                         * Encodes the specified Warnings message. Does not implicitly {@link google.cloud.compute.v1.Warnings.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {google.cloud.compute.v1.IWarnings} message Warnings message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Warnings.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                                writer.uint32(/* id 3059181, wireType 0 =*/24473448).int32(message.code);
                            if (message.data != null && message.data.length)
                                for (var i = 0; i < message.data.length; ++i)
                                    $root.google.cloud.compute.v1.Data.encode(message.data[i], writer.uint32(/* id 3076010, wireType 2 =*/24608082).fork()).ldelim();
                            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                                writer.uint32(/* id 418054151, wireType 2 =*/3344433210).string(message.message);
                            return writer;
                        };

                        /**
                         * Encodes the specified Warnings message, length delimited. Does not implicitly {@link google.cloud.compute.v1.Warnings.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {google.cloud.compute.v1.IWarnings} message Warnings message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Warnings.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a Warnings message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.Warnings} Warnings
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Warnings.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.Warnings();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3059181:
                                    message.code = reader.int32();
                                    break;
                                case 3076010:
                                    if (!(message.data && message.data.length))
                                        message.data = [];
                                    message.data.push($root.google.cloud.compute.v1.Data.decode(reader, reader.uint32()));
                                    break;
                                case 418054151:
                                    message.message = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a Warnings message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.Warnings} Warnings
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Warnings.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a Warnings message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Warnings.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.code != null && message.hasOwnProperty("code")) {
                                properties._code = 1;
                                switch (message.code) {
                                default:
                                    return "code: enum value expected";
                                case 0:
                                case 150308440:
                                case 391835586:
                                case 346526230:
                                case 369442967:
                                case 451954443:
                                case 175546307:
                                case 329669423:
                                case 417377419:
                                case 344505463:
                                case 324964999:
                                case 383382887:
                                case 464250446:
                                case 243758146:
                                case 417081265:
                                case 105763924:
                                case 30036744:
                                case 3745539:
                                case 496728641:
                                case 168598460:
                                case 275245642:
                                case 268305617:
                                case 390513439:
                                case 13328052:
                                    break;
                                }
                            }
                            if (message.data != null && message.hasOwnProperty("data")) {
                                if (!Array.isArray(message.data))
                                    return "data: array expected";
                                for (var i = 0; i < message.data.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.Data.verify(message.data[i]);
                                    if (error)
                                        return "data." + error;
                                }
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                properties._message = 1;
                                if (!$util.isString(message.message))
                                    return "message: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a Warnings message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.Warnings} Warnings
                         */
                        Warnings.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.Warnings)
                                return object;
                            var message = new $root.google.cloud.compute.v1.Warnings();
                            switch (object.code) {
                            case "UNDEFINED_CODE":
                            case 0:
                                message.code = 0;
                                break;
                            case "CLEANUP_FAILED":
                            case 150308440:
                                message.code = 150308440;
                                break;
                            case "DEPRECATED_RESOURCE_USED":
                            case 391835586:
                                message.code = 391835586;
                                break;
                            case "DEPRECATED_TYPE_USED":
                            case 346526230:
                                message.code = 346526230;
                                break;
                            case "DISK_SIZE_LARGER_THAN_IMAGE_SIZE":
                            case 369442967:
                                message.code = 369442967;
                                break;
                            case "EXPERIMENTAL_TYPE_USED":
                            case 451954443:
                                message.code = 451954443;
                                break;
                            case "EXTERNAL_API_WARNING":
                            case 175546307:
                                message.code = 175546307;
                                break;
                            case "FIELD_VALUE_OVERRIDEN":
                            case 329669423:
                                message.code = 329669423;
                                break;
                            case "INJECTED_KERNELS_DEPRECATED":
                            case 417377419:
                                message.code = 417377419;
                                break;
                            case "MISSING_TYPE_DEPENDENCY":
                            case 344505463:
                                message.code = 344505463;
                                break;
                            case "NEXT_HOP_ADDRESS_NOT_ASSIGNED":
                            case 324964999:
                                message.code = 324964999;
                                break;
                            case "NEXT_HOP_CANNOT_IP_FORWARD":
                            case 383382887:
                                message.code = 383382887;
                                break;
                            case "NEXT_HOP_INSTANCE_NOT_FOUND":
                            case 464250446:
                                message.code = 464250446;
                                break;
                            case "NEXT_HOP_INSTANCE_NOT_ON_NETWORK":
                            case 243758146:
                                message.code = 243758146;
                                break;
                            case "NEXT_HOP_NOT_RUNNING":
                            case 417081265:
                                message.code = 417081265;
                                break;
                            case "NOT_CRITICAL_ERROR":
                            case 105763924:
                                message.code = 105763924;
                                break;
                            case "NO_RESULTS_ON_PAGE":
                            case 30036744:
                                message.code = 30036744;
                                break;
                            case "REQUIRED_TOS_AGREEMENT":
                            case 3745539:
                                message.code = 3745539;
                                break;
                            case "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING":
                            case 496728641:
                                message.code = 496728641;
                                break;
                            case "RESOURCE_NOT_DELETED":
                            case 168598460:
                                message.code = 168598460;
                                break;
                            case "SCHEMA_VALIDATION_IGNORED":
                            case 275245642:
                                message.code = 275245642;
                                break;
                            case "SINGLE_INSTANCE_PROPERTY_TEMPLATE":
                            case 268305617:
                                message.code = 268305617;
                                break;
                            case "UNDECLARED_PROPERTIES":
                            case 390513439:
                                message.code = 390513439;
                                break;
                            case "UNREACHABLE":
                            case 13328052:
                                message.code = 13328052;
                                break;
                            }
                            if (object.data) {
                                if (!Array.isArray(object.data))
                                    throw TypeError(".google.cloud.compute.v1.Warnings.data: array expected");
                                message.data = [];
                                for (var i = 0; i < object.data.length; ++i) {
                                    if (typeof object.data[i] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.Warnings.data: object expected");
                                    message.data[i] = $root.google.cloud.compute.v1.Data.fromObject(object.data[i]);
                                }
                            }
                            if (object.message != null)
                                message.message = String(object.message);
                            return message;
                        };

                        /**
                         * Creates a plain object from a Warnings message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.Warnings
                         * @static
                         * @param {google.cloud.compute.v1.Warnings} message Warnings
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Warnings.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.data = [];
                            if (message.code != null && message.hasOwnProperty("code")) {
                                object.code = options.enums === String ? $root.google.cloud.compute.v1.Warnings.Code[message.code] : message.code;
                                if (options.oneofs)
                                    object._code = "code";
                            }
                            if (message.data && message.data.length) {
                                object.data = [];
                                for (var j = 0; j < message.data.length; ++j)
                                    object.data[j] = $root.google.cloud.compute.v1.Data.toObject(message.data[j], options);
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                object.message = message.message;
                                if (options.oneofs)
                                    object._message = "message";
                            }
                            return object;
                        };

                        /**
                         * Converts this Warnings to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.Warnings
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Warnings.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        /**
                         * Code enum.
                         * @name google.cloud.compute.v1.Warnings.Code
                         * @enum {number}
                         * @property {number} UNDEFINED_CODE=0 UNDEFINED_CODE value
                         * @property {number} CLEANUP_FAILED=150308440 CLEANUP_FAILED value
                         * @property {number} DEPRECATED_RESOURCE_USED=391835586 DEPRECATED_RESOURCE_USED value
                         * @property {number} DEPRECATED_TYPE_USED=346526230 DEPRECATED_TYPE_USED value
                         * @property {number} DISK_SIZE_LARGER_THAN_IMAGE_SIZE=369442967 DISK_SIZE_LARGER_THAN_IMAGE_SIZE value
                         * @property {number} EXPERIMENTAL_TYPE_USED=451954443 EXPERIMENTAL_TYPE_USED value
                         * @property {number} EXTERNAL_API_WARNING=175546307 EXTERNAL_API_WARNING value
                         * @property {number} FIELD_VALUE_OVERRIDEN=329669423 FIELD_VALUE_OVERRIDEN value
                         * @property {number} INJECTED_KERNELS_DEPRECATED=417377419 INJECTED_KERNELS_DEPRECATED value
                         * @property {number} MISSING_TYPE_DEPENDENCY=344505463 MISSING_TYPE_DEPENDENCY value
                         * @property {number} NEXT_HOP_ADDRESS_NOT_ASSIGNED=324964999 NEXT_HOP_ADDRESS_NOT_ASSIGNED value
                         * @property {number} NEXT_HOP_CANNOT_IP_FORWARD=383382887 NEXT_HOP_CANNOT_IP_FORWARD value
                         * @property {number} NEXT_HOP_INSTANCE_NOT_FOUND=464250446 NEXT_HOP_INSTANCE_NOT_FOUND value
                         * @property {number} NEXT_HOP_INSTANCE_NOT_ON_NETWORK=243758146 NEXT_HOP_INSTANCE_NOT_ON_NETWORK value
                         * @property {number} NEXT_HOP_NOT_RUNNING=417081265 NEXT_HOP_NOT_RUNNING value
                         * @property {number} NOT_CRITICAL_ERROR=105763924 NOT_CRITICAL_ERROR value
                         * @property {number} NO_RESULTS_ON_PAGE=30036744 NO_RESULTS_ON_PAGE value
                         * @property {number} REQUIRED_TOS_AGREEMENT=3745539 REQUIRED_TOS_AGREEMENT value
                         * @property {number} RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING=496728641 RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING value
                         * @property {number} RESOURCE_NOT_DELETED=168598460 RESOURCE_NOT_DELETED value
                         * @property {number} SCHEMA_VALIDATION_IGNORED=275245642 SCHEMA_VALIDATION_IGNORED value
                         * @property {number} SINGLE_INSTANCE_PROPERTY_TEMPLATE=268305617 SINGLE_INSTANCE_PROPERTY_TEMPLATE value
                         * @property {number} UNDECLARED_PROPERTIES=390513439 UNDECLARED_PROPERTIES value
                         * @property {number} UNREACHABLE=13328052 UNREACHABLE value
                         */
                        Warnings.Code = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "UNDEFINED_CODE"] = 0;
                            values[valuesById[150308440] = "CLEANUP_FAILED"] = 150308440;
                            values[valuesById[391835586] = "DEPRECATED_RESOURCE_USED"] = 391835586;
                            values[valuesById[346526230] = "DEPRECATED_TYPE_USED"] = 346526230;
                            values[valuesById[369442967] = "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"] = 369442967;
                            values[valuesById[451954443] = "EXPERIMENTAL_TYPE_USED"] = 451954443;
                            values[valuesById[175546307] = "EXTERNAL_API_WARNING"] = 175546307;
                            values[valuesById[329669423] = "FIELD_VALUE_OVERRIDEN"] = 329669423;
                            values[valuesById[417377419] = "INJECTED_KERNELS_DEPRECATED"] = 417377419;
                            values[valuesById[344505463] = "MISSING_TYPE_DEPENDENCY"] = 344505463;
                            values[valuesById[324964999] = "NEXT_HOP_ADDRESS_NOT_ASSIGNED"] = 324964999;
                            values[valuesById[383382887] = "NEXT_HOP_CANNOT_IP_FORWARD"] = 383382887;
                            values[valuesById[464250446] = "NEXT_HOP_INSTANCE_NOT_FOUND"] = 464250446;
                            values[valuesById[243758146] = "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"] = 243758146;
                            values[valuesById[417081265] = "NEXT_HOP_NOT_RUNNING"] = 417081265;
                            values[valuesById[105763924] = "NOT_CRITICAL_ERROR"] = 105763924;
                            values[valuesById[30036744] = "NO_RESULTS_ON_PAGE"] = 30036744;
                            values[valuesById[3745539] = "REQUIRED_TOS_AGREEMENT"] = 3745539;
                            values[valuesById[496728641] = "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"] = 496728641;
                            values[valuesById[168598460] = "RESOURCE_NOT_DELETED"] = 168598460;
                            values[valuesById[275245642] = "SCHEMA_VALIDATION_IGNORED"] = 275245642;
                            values[valuesById[268305617] = "SINGLE_INSTANCE_PROPERTY_TEMPLATE"] = 268305617;
                            values[valuesById[390513439] = "UNDECLARED_PROPERTIES"] = 390513439;
                            values[valuesById[13328052] = "UNREACHABLE"] = 13328052;
                            return values;
                        })();

                        return Warnings;
                    })();

                    v1.Warning = (function() {

                        /**
                         * Properties of a Warning.
                         * @memberof google.cloud.compute.v1
                         * @interface IWarning
                         * @property {google.cloud.compute.v1.Warning.Code|null} [code] Warning code
                         * @property {Array.<google.cloud.compute.v1.IData>|null} [data] Warning data
                         * @property {string|null} [message] Warning message
                         */

                        /**
                         * Constructs a new Warning.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a Warning.
                         * @implements IWarning
                         * @constructor
                         * @param {google.cloud.compute.v1.IWarning=} [properties] Properties to set
                         */
                        function Warning(properties) {
                            this.data = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Warning code.
                         * @member {google.cloud.compute.v1.Warning.Code|null|undefined} code
                         * @memberof google.cloud.compute.v1.Warning
                         * @instance
                         */
                        Warning.prototype.code = null;

                        /**
                         * Warning data.
                         * @member {Array.<google.cloud.compute.v1.IData>} data
                         * @memberof google.cloud.compute.v1.Warning
                         * @instance
                         */
                        Warning.prototype.data = $util.emptyArray;

                        /**
                         * Warning message.
                         * @member {string|null|undefined} message
                         * @memberof google.cloud.compute.v1.Warning
                         * @instance
                         */
                        Warning.prototype.message = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * Warning _code.
                         * @member {"code"|undefined} _code
                         * @memberof google.cloud.compute.v1.Warning
                         * @instance
                         */
                        Object.defineProperty(Warning.prototype, "_code", {
                            get: $util.oneOfGetter($oneOfFields = ["code"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Warning _message.
                         * @member {"message"|undefined} _message
                         * @memberof google.cloud.compute.v1.Warning
                         * @instance
                         */
                        Object.defineProperty(Warning.prototype, "_message", {
                            get: $util.oneOfGetter($oneOfFields = ["message"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new Warning instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {google.cloud.compute.v1.IWarning=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.Warning} Warning instance
                         */
                        Warning.create = function create(properties) {
                            return new Warning(properties);
                        };

                        /**
                         * Encodes the specified Warning message. Does not implicitly {@link google.cloud.compute.v1.Warning.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {google.cloud.compute.v1.IWarning} message Warning message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Warning.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.code != null && Object.hasOwnProperty.call(message, "code"))
                                writer.uint32(/* id 3059181, wireType 0 =*/24473448).int32(message.code);
                            if (message.data != null && message.data.length)
                                for (var i = 0; i < message.data.length; ++i)
                                    $root.google.cloud.compute.v1.Data.encode(message.data[i], writer.uint32(/* id 3076010, wireType 2 =*/24608082).fork()).ldelim();
                            if (message.message != null && Object.hasOwnProperty.call(message, "message"))
                                writer.uint32(/* id 418054151, wireType 2 =*/3344433210).string(message.message);
                            return writer;
                        };

                        /**
                         * Encodes the specified Warning message, length delimited. Does not implicitly {@link google.cloud.compute.v1.Warning.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {google.cloud.compute.v1.IWarning} message Warning message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Warning.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a Warning message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.Warning} Warning
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Warning.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.Warning();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3059181:
                                    message.code = reader.int32();
                                    break;
                                case 3076010:
                                    if (!(message.data && message.data.length))
                                        message.data = [];
                                    message.data.push($root.google.cloud.compute.v1.Data.decode(reader, reader.uint32()));
                                    break;
                                case 418054151:
                                    message.message = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a Warning message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.Warning} Warning
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Warning.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a Warning message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Warning.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.code != null && message.hasOwnProperty("code")) {
                                properties._code = 1;
                                switch (message.code) {
                                default:
                                    return "code: enum value expected";
                                case 0:
                                case 150308440:
                                case 391835586:
                                case 346526230:
                                case 369442967:
                                case 451954443:
                                case 175546307:
                                case 329669423:
                                case 417377419:
                                case 481440678:
                                case 344505463:
                                case 324964999:
                                case 383382887:
                                case 464250446:
                                case 243758146:
                                case 417081265:
                                case 105763924:
                                case 30036744:
                                case 39966469:
                                case 3745539:
                                case 496728641:
                                case 168598460:
                                case 275245642:
                                case 268305617:
                                case 390513439:
                                case 13328052:
                                    break;
                                }
                            }
                            if (message.data != null && message.hasOwnProperty("data")) {
                                if (!Array.isArray(message.data))
                                    return "data: array expected";
                                for (var i = 0; i < message.data.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.Data.verify(message.data[i]);
                                    if (error)
                                        return "data." + error;
                                }
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                properties._message = 1;
                                if (!$util.isString(message.message))
                                    return "message: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a Warning message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.Warning} Warning
                         */
                        Warning.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.Warning)
                                return object;
                            var message = new $root.google.cloud.compute.v1.Warning();
                            switch (object.code) {
                            case "UNDEFINED_CODE":
                            case 0:
                                message.code = 0;
                                break;
                            case "CLEANUP_FAILED":
                            case 150308440:
                                message.code = 150308440;
                                break;
                            case "DEPRECATED_RESOURCE_USED":
                            case 391835586:
                                message.code = 391835586;
                                break;
                            case "DEPRECATED_TYPE_USED":
                            case 346526230:
                                message.code = 346526230;
                                break;
                            case "DISK_SIZE_LARGER_THAN_IMAGE_SIZE":
                            case 369442967:
                                message.code = 369442967;
                                break;
                            case "EXPERIMENTAL_TYPE_USED":
                            case 451954443:
                                message.code = 451954443;
                                break;
                            case "EXTERNAL_API_WARNING":
                            case 175546307:
                                message.code = 175546307;
                                break;
                            case "FIELD_VALUE_OVERRIDEN":
                            case 329669423:
                                message.code = 329669423;
                                break;
                            case "INJECTED_KERNELS_DEPRECATED":
                            case 417377419:
                                message.code = 417377419;
                                break;
                            case "LARGE_DEPLOYMENT_WARNING":
                            case 481440678:
                                message.code = 481440678;
                                break;
                            case "MISSING_TYPE_DEPENDENCY":
                            case 344505463:
                                message.code = 344505463;
                                break;
                            case "NEXT_HOP_ADDRESS_NOT_ASSIGNED":
                            case 324964999:
                                message.code = 324964999;
                                break;
                            case "NEXT_HOP_CANNOT_IP_FORWARD":
                            case 383382887:
                                message.code = 383382887;
                                break;
                            case "NEXT_HOP_INSTANCE_NOT_FOUND":
                            case 464250446:
                                message.code = 464250446;
                                break;
                            case "NEXT_HOP_INSTANCE_NOT_ON_NETWORK":
                            case 243758146:
                                message.code = 243758146;
                                break;
                            case "NEXT_HOP_NOT_RUNNING":
                            case 417081265:
                                message.code = 417081265;
                                break;
                            case "NOT_CRITICAL_ERROR":
                            case 105763924:
                                message.code = 105763924;
                                break;
                            case "NO_RESULTS_ON_PAGE":
                            case 30036744:
                                message.code = 30036744;
                                break;
                            case "PARTIAL_SUCCESS":
                            case 39966469:
                                message.code = 39966469;
                                break;
                            case "REQUIRED_TOS_AGREEMENT":
                            case 3745539:
                                message.code = 3745539;
                                break;
                            case "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING":
                            case 496728641:
                                message.code = 496728641;
                                break;
                            case "RESOURCE_NOT_DELETED":
                            case 168598460:
                                message.code = 168598460;
                                break;
                            case "SCHEMA_VALIDATION_IGNORED":
                            case 275245642:
                                message.code = 275245642;
                                break;
                            case "SINGLE_INSTANCE_PROPERTY_TEMPLATE":
                            case 268305617:
                                message.code = 268305617;
                                break;
                            case "UNDECLARED_PROPERTIES":
                            case 390513439:
                                message.code = 390513439;
                                break;
                            case "UNREACHABLE":
                            case 13328052:
                                message.code = 13328052;
                                break;
                            }
                            if (object.data) {
                                if (!Array.isArray(object.data))
                                    throw TypeError(".google.cloud.compute.v1.Warning.data: array expected");
                                message.data = [];
                                for (var i = 0; i < object.data.length; ++i) {
                                    if (typeof object.data[i] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.Warning.data: object expected");
                                    message.data[i] = $root.google.cloud.compute.v1.Data.fromObject(object.data[i]);
                                }
                            }
                            if (object.message != null)
                                message.message = String(object.message);
                            return message;
                        };

                        /**
                         * Creates a plain object from a Warning message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.Warning
                         * @static
                         * @param {google.cloud.compute.v1.Warning} message Warning
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Warning.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.data = [];
                            if (message.code != null && message.hasOwnProperty("code")) {
                                object.code = options.enums === String ? $root.google.cloud.compute.v1.Warning.Code[message.code] : message.code;
                                if (options.oneofs)
                                    object._code = "code";
                            }
                            if (message.data && message.data.length) {
                                object.data = [];
                                for (var j = 0; j < message.data.length; ++j)
                                    object.data[j] = $root.google.cloud.compute.v1.Data.toObject(message.data[j], options);
                            }
                            if (message.message != null && message.hasOwnProperty("message")) {
                                object.message = message.message;
                                if (options.oneofs)
                                    object._message = "message";
                            }
                            return object;
                        };

                        /**
                         * Converts this Warning to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.Warning
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Warning.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        /**
                         * Code enum.
                         * @name google.cloud.compute.v1.Warning.Code
                         * @enum {number}
                         * @property {number} UNDEFINED_CODE=0 UNDEFINED_CODE value
                         * @property {number} CLEANUP_FAILED=150308440 CLEANUP_FAILED value
                         * @property {number} DEPRECATED_RESOURCE_USED=391835586 DEPRECATED_RESOURCE_USED value
                         * @property {number} DEPRECATED_TYPE_USED=346526230 DEPRECATED_TYPE_USED value
                         * @property {number} DISK_SIZE_LARGER_THAN_IMAGE_SIZE=369442967 DISK_SIZE_LARGER_THAN_IMAGE_SIZE value
                         * @property {number} EXPERIMENTAL_TYPE_USED=451954443 EXPERIMENTAL_TYPE_USED value
                         * @property {number} EXTERNAL_API_WARNING=175546307 EXTERNAL_API_WARNING value
                         * @property {number} FIELD_VALUE_OVERRIDEN=329669423 FIELD_VALUE_OVERRIDEN value
                         * @property {number} INJECTED_KERNELS_DEPRECATED=417377419 INJECTED_KERNELS_DEPRECATED value
                         * @property {number} LARGE_DEPLOYMENT_WARNING=481440678 LARGE_DEPLOYMENT_WARNING value
                         * @property {number} MISSING_TYPE_DEPENDENCY=344505463 MISSING_TYPE_DEPENDENCY value
                         * @property {number} NEXT_HOP_ADDRESS_NOT_ASSIGNED=324964999 NEXT_HOP_ADDRESS_NOT_ASSIGNED value
                         * @property {number} NEXT_HOP_CANNOT_IP_FORWARD=383382887 NEXT_HOP_CANNOT_IP_FORWARD value
                         * @property {number} NEXT_HOP_INSTANCE_NOT_FOUND=464250446 NEXT_HOP_INSTANCE_NOT_FOUND value
                         * @property {number} NEXT_HOP_INSTANCE_NOT_ON_NETWORK=243758146 NEXT_HOP_INSTANCE_NOT_ON_NETWORK value
                         * @property {number} NEXT_HOP_NOT_RUNNING=417081265 NEXT_HOP_NOT_RUNNING value
                         * @property {number} NOT_CRITICAL_ERROR=105763924 NOT_CRITICAL_ERROR value
                         * @property {number} NO_RESULTS_ON_PAGE=30036744 NO_RESULTS_ON_PAGE value
                         * @property {number} PARTIAL_SUCCESS=39966469 PARTIAL_SUCCESS value
                         * @property {number} REQUIRED_TOS_AGREEMENT=3745539 REQUIRED_TOS_AGREEMENT value
                         * @property {number} RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING=496728641 RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING value
                         * @property {number} RESOURCE_NOT_DELETED=168598460 RESOURCE_NOT_DELETED value
                         * @property {number} SCHEMA_VALIDATION_IGNORED=275245642 SCHEMA_VALIDATION_IGNORED value
                         * @property {number} SINGLE_INSTANCE_PROPERTY_TEMPLATE=268305617 SINGLE_INSTANCE_PROPERTY_TEMPLATE value
                         * @property {number} UNDECLARED_PROPERTIES=390513439 UNDECLARED_PROPERTIES value
                         * @property {number} UNREACHABLE=13328052 UNREACHABLE value
                         */
                        Warning.Code = (function() {
                            var valuesById = {}, values = Object.create(valuesById);
                            values[valuesById[0] = "UNDEFINED_CODE"] = 0;
                            values[valuesById[150308440] = "CLEANUP_FAILED"] = 150308440;
                            values[valuesById[391835586] = "DEPRECATED_RESOURCE_USED"] = 391835586;
                            values[valuesById[346526230] = "DEPRECATED_TYPE_USED"] = 346526230;
                            values[valuesById[369442967] = "DISK_SIZE_LARGER_THAN_IMAGE_SIZE"] = 369442967;
                            values[valuesById[451954443] = "EXPERIMENTAL_TYPE_USED"] = 451954443;
                            values[valuesById[175546307] = "EXTERNAL_API_WARNING"] = 175546307;
                            values[valuesById[329669423] = "FIELD_VALUE_OVERRIDEN"] = 329669423;
                            values[valuesById[417377419] = "INJECTED_KERNELS_DEPRECATED"] = 417377419;
                            values[valuesById[481440678] = "LARGE_DEPLOYMENT_WARNING"] = 481440678;
                            values[valuesById[344505463] = "MISSING_TYPE_DEPENDENCY"] = 344505463;
                            values[valuesById[324964999] = "NEXT_HOP_ADDRESS_NOT_ASSIGNED"] = 324964999;
                            values[valuesById[383382887] = "NEXT_HOP_CANNOT_IP_FORWARD"] = 383382887;
                            values[valuesById[464250446] = "NEXT_HOP_INSTANCE_NOT_FOUND"] = 464250446;
                            values[valuesById[243758146] = "NEXT_HOP_INSTANCE_NOT_ON_NETWORK"] = 243758146;
                            values[valuesById[417081265] = "NEXT_HOP_NOT_RUNNING"] = 417081265;
                            values[valuesById[105763924] = "NOT_CRITICAL_ERROR"] = 105763924;
                            values[valuesById[30036744] = "NO_RESULTS_ON_PAGE"] = 30036744;
                            values[valuesById[39966469] = "PARTIAL_SUCCESS"] = 39966469;
                            values[valuesById[3745539] = "REQUIRED_TOS_AGREEMENT"] = 3745539;
                            values[valuesById[496728641] = "RESOURCE_IN_USE_BY_OTHER_RESOURCE_WARNING"] = 496728641;
                            values[valuesById[168598460] = "RESOURCE_NOT_DELETED"] = 168598460;
                            values[valuesById[275245642] = "SCHEMA_VALIDATION_IGNORED"] = 275245642;
                            values[valuesById[268305617] = "SINGLE_INSTANCE_PROPERTY_TEMPLATE"] = 268305617;
                            values[valuesById[390513439] = "UNDECLARED_PROPERTIES"] = 390513439;
                            values[valuesById[13328052] = "UNREACHABLE"] = 13328052;
                            return values;
                        })();

                        return Warning;
                    })();

                    v1.Data = (function() {

                        /**
                         * Properties of a Data.
                         * @memberof google.cloud.compute.v1
                         * @interface IData
                         * @property {string|null} [key] Data key
                         * @property {string|null} [value] Data value
                         */

                        /**
                         * Constructs a new Data.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a Data.
                         * @implements IData
                         * @constructor
                         * @param {google.cloud.compute.v1.IData=} [properties] Properties to set
                         */
                        function Data(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Data key.
                         * @member {string|null|undefined} key
                         * @memberof google.cloud.compute.v1.Data
                         * @instance
                         */
                        Data.prototype.key = null;

                        /**
                         * Data value.
                         * @member {string|null|undefined} value
                         * @memberof google.cloud.compute.v1.Data
                         * @instance
                         */
                        Data.prototype.value = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * Data _key.
                         * @member {"key"|undefined} _key
                         * @memberof google.cloud.compute.v1.Data
                         * @instance
                         */
                        Object.defineProperty(Data.prototype, "_key", {
                            get: $util.oneOfGetter($oneOfFields = ["key"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Data _value.
                         * @member {"value"|undefined} _value
                         * @memberof google.cloud.compute.v1.Data
                         * @instance
                         */
                        Object.defineProperty(Data.prototype, "_value", {
                            get: $util.oneOfGetter($oneOfFields = ["value"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new Data instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {google.cloud.compute.v1.IData=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.Data} Data instance
                         */
                        Data.create = function create(properties) {
                            return new Data(properties);
                        };

                        /**
                         * Encodes the specified Data message. Does not implicitly {@link google.cloud.compute.v1.Data.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {google.cloud.compute.v1.IData} message Data message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Data.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.key != null && Object.hasOwnProperty.call(message, "key"))
                                writer.uint32(/* id 106079, wireType 2 =*/848634).string(message.key);
                            if (message.value != null && Object.hasOwnProperty.call(message, "value"))
                                writer.uint32(/* id 111972721, wireType 2 =*/895781770).string(message.value);
                            return writer;
                        };

                        /**
                         * Encodes the specified Data message, length delimited. Does not implicitly {@link google.cloud.compute.v1.Data.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {google.cloud.compute.v1.IData} message Data message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        Data.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a Data message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.Data} Data
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Data.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.Data();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 106079:
                                    message.key = reader.string();
                                    break;
                                case 111972721:
                                    message.value = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a Data message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.Data} Data
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        Data.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a Data message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        Data.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.key != null && message.hasOwnProperty("key")) {
                                properties._key = 1;
                                if (!$util.isString(message.key))
                                    return "key: string expected";
                            }
                            if (message.value != null && message.hasOwnProperty("value")) {
                                properties._value = 1;
                                if (!$util.isString(message.value))
                                    return "value: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a Data message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.Data} Data
                         */
                        Data.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.Data)
                                return object;
                            var message = new $root.google.cloud.compute.v1.Data();
                            if (object.key != null)
                                message.key = String(object.key);
                            if (object.value != null)
                                message.value = String(object.value);
                            return message;
                        };

                        /**
                         * Creates a plain object from a Data message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.Data
                         * @static
                         * @param {google.cloud.compute.v1.Data} message Data
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        Data.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.key != null && message.hasOwnProperty("key")) {
                                object.key = message.key;
                                if (options.oneofs)
                                    object._key = "key";
                            }
                            if (message.value != null && message.hasOwnProperty("value")) {
                                object.value = message.value;
                                if (options.oneofs)
                                    object._value = "value";
                            }
                            return object;
                        };

                        /**
                         * Converts this Data to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.Data
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        Data.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return Data;
                    })();

                    v1.OperationsScopedList = (function() {

                        /**
                         * Properties of an OperationsScopedList.
                         * @memberof google.cloud.compute.v1
                         * @interface IOperationsScopedList
                         * @property {Array.<google.cloud.compute.v1.IOperation>|null} [operations] OperationsScopedList operations
                         * @property {google.cloud.compute.v1.IWarning|null} [warning] OperationsScopedList warning
                         */

                        /**
                         * Constructs a new OperationsScopedList.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an OperationsScopedList.
                         * @implements IOperationsScopedList
                         * @constructor
                         * @param {google.cloud.compute.v1.IOperationsScopedList=} [properties] Properties to set
                         */
                        function OperationsScopedList(properties) {
                            this.operations = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * OperationsScopedList operations.
                         * @member {Array.<google.cloud.compute.v1.IOperation>} operations
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @instance
                         */
                        OperationsScopedList.prototype.operations = $util.emptyArray;

                        /**
                         * OperationsScopedList warning.
                         * @member {google.cloud.compute.v1.IWarning|null|undefined} warning
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @instance
                         */
                        OperationsScopedList.prototype.warning = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * OperationsScopedList _warning.
                         * @member {"warning"|undefined} _warning
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @instance
                         */
                        Object.defineProperty(OperationsScopedList.prototype, "_warning", {
                            get: $util.oneOfGetter($oneOfFields = ["warning"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new OperationsScopedList instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationsScopedList=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.OperationsScopedList} OperationsScopedList instance
                         */
                        OperationsScopedList.create = function create(properties) {
                            return new OperationsScopedList(properties);
                        };

                        /**
                         * Encodes the specified OperationsScopedList message. Does not implicitly {@link google.cloud.compute.v1.OperationsScopedList.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationsScopedList} message OperationsScopedList message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationsScopedList.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operations != null && message.operations.length)
                                for (var i = 0; i < message.operations.length; ++i)
                                    $root.google.cloud.compute.v1.Operation.encode(message.operations[i], writer.uint32(/* id 4184044, wireType 2 =*/33472354).fork()).ldelim();
                            if (message.warning != null && Object.hasOwnProperty.call(message, "warning"))
                                $root.google.cloud.compute.v1.Warning.encode(message.warning, writer.uint32(/* id 50704284, wireType 2 =*/405634274).fork()).ldelim();
                            return writer;
                        };

                        /**
                         * Encodes the specified OperationsScopedList message, length delimited. Does not implicitly {@link google.cloud.compute.v1.OperationsScopedList.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationsScopedList} message OperationsScopedList message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationsScopedList.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an OperationsScopedList message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.OperationsScopedList} OperationsScopedList
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationsScopedList.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.OperationsScopedList();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 4184044:
                                    if (!(message.operations && message.operations.length))
                                        message.operations = [];
                                    message.operations.push($root.google.cloud.compute.v1.Operation.decode(reader, reader.uint32()));
                                    break;
                                case 50704284:
                                    message.warning = $root.google.cloud.compute.v1.Warning.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an OperationsScopedList message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.OperationsScopedList} OperationsScopedList
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationsScopedList.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an OperationsScopedList message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OperationsScopedList.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.operations != null && message.hasOwnProperty("operations")) {
                                if (!Array.isArray(message.operations))
                                    return "operations: array expected";
                                for (var i = 0; i < message.operations.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.Operation.verify(message.operations[i]);
                                    if (error)
                                        return "operations." + error;
                                }
                            }
                            if (message.warning != null && message.hasOwnProperty("warning")) {
                                properties._warning = 1;
                                {
                                    var error = $root.google.cloud.compute.v1.Warning.verify(message.warning);
                                    if (error)
                                        return "warning." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates an OperationsScopedList message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.OperationsScopedList} OperationsScopedList
                         */
                        OperationsScopedList.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.OperationsScopedList)
                                return object;
                            var message = new $root.google.cloud.compute.v1.OperationsScopedList();
                            if (object.operations) {
                                if (!Array.isArray(object.operations))
                                    throw TypeError(".google.cloud.compute.v1.OperationsScopedList.operations: array expected");
                                message.operations = [];
                                for (var i = 0; i < object.operations.length; ++i) {
                                    if (typeof object.operations[i] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.OperationsScopedList.operations: object expected");
                                    message.operations[i] = $root.google.cloud.compute.v1.Operation.fromObject(object.operations[i]);
                                }
                            }
                            if (object.warning != null) {
                                if (typeof object.warning !== "object")
                                    throw TypeError(".google.cloud.compute.v1.OperationsScopedList.warning: object expected");
                                message.warning = $root.google.cloud.compute.v1.Warning.fromObject(object.warning);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an OperationsScopedList message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @static
                         * @param {google.cloud.compute.v1.OperationsScopedList} message OperationsScopedList
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OperationsScopedList.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.operations = [];
                            if (message.operations && message.operations.length) {
                                object.operations = [];
                                for (var j = 0; j < message.operations.length; ++j)
                                    object.operations[j] = $root.google.cloud.compute.v1.Operation.toObject(message.operations[j], options);
                            }
                            if (message.warning != null && message.hasOwnProperty("warning")) {
                                object.warning = $root.google.cloud.compute.v1.Warning.toObject(message.warning, options);
                                if (options.oneofs)
                                    object._warning = "warning";
                            }
                            return object;
                        };

                        /**
                         * Converts this OperationsScopedList to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.OperationsScopedList
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OperationsScopedList.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return OperationsScopedList;
                    })();

                    v1.OperationAggregatedList = (function() {

                        /**
                         * Properties of an OperationAggregatedList.
                         * @memberof google.cloud.compute.v1
                         * @interface IOperationAggregatedList
                         * @property {string|null} [id] OperationAggregatedList id
                         * @property {Object.<string,google.cloud.compute.v1.IOperationsScopedList>|null} [items] OperationAggregatedList items
                         * @property {string|null} [kind] OperationAggregatedList kind
                         * @property {string|null} [nextPageToken] OperationAggregatedList nextPageToken
                         * @property {string|null} [selfLink] OperationAggregatedList selfLink
                         * @property {Array.<string>|null} [unreachables] OperationAggregatedList unreachables
                         * @property {google.cloud.compute.v1.IWarning|null} [warning] OperationAggregatedList warning
                         */

                        /**
                         * Constructs a new OperationAggregatedList.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an OperationAggregatedList.
                         * @implements IOperationAggregatedList
                         * @constructor
                         * @param {google.cloud.compute.v1.IOperationAggregatedList=} [properties] Properties to set
                         */
                        function OperationAggregatedList(properties) {
                            this.items = {};
                            this.unreachables = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * OperationAggregatedList id.
                         * @member {string|null|undefined} id
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.id = null;

                        /**
                         * OperationAggregatedList items.
                         * @member {Object.<string,google.cloud.compute.v1.IOperationsScopedList>} items
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.items = $util.emptyObject;

                        /**
                         * OperationAggregatedList kind.
                         * @member {string|null|undefined} kind
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.kind = null;

                        /**
                         * OperationAggregatedList nextPageToken.
                         * @member {string|null|undefined} nextPageToken
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.nextPageToken = null;

                        /**
                         * OperationAggregatedList selfLink.
                         * @member {string|null|undefined} selfLink
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.selfLink = null;

                        /**
                         * OperationAggregatedList unreachables.
                         * @member {Array.<string>} unreachables
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.unreachables = $util.emptyArray;

                        /**
                         * OperationAggregatedList warning.
                         * @member {google.cloud.compute.v1.IWarning|null|undefined} warning
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        OperationAggregatedList.prototype.warning = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * OperationAggregatedList _id.
                         * @member {"id"|undefined} _id
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        Object.defineProperty(OperationAggregatedList.prototype, "_id", {
                            get: $util.oneOfGetter($oneOfFields = ["id"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationAggregatedList _kind.
                         * @member {"kind"|undefined} _kind
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        Object.defineProperty(OperationAggregatedList.prototype, "_kind", {
                            get: $util.oneOfGetter($oneOfFields = ["kind"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationAggregatedList _nextPageToken.
                         * @member {"nextPageToken"|undefined} _nextPageToken
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        Object.defineProperty(OperationAggregatedList.prototype, "_nextPageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["nextPageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationAggregatedList _selfLink.
                         * @member {"selfLink"|undefined} _selfLink
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        Object.defineProperty(OperationAggregatedList.prototype, "_selfLink", {
                            get: $util.oneOfGetter($oneOfFields = ["selfLink"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationAggregatedList _warning.
                         * @member {"warning"|undefined} _warning
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         */
                        Object.defineProperty(OperationAggregatedList.prototype, "_warning", {
                            get: $util.oneOfGetter($oneOfFields = ["warning"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new OperationAggregatedList instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationAggregatedList=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.OperationAggregatedList} OperationAggregatedList instance
                         */
                        OperationAggregatedList.create = function create(properties) {
                            return new OperationAggregatedList(properties);
                        };

                        /**
                         * Encodes the specified OperationAggregatedList message. Does not implicitly {@link google.cloud.compute.v1.OperationAggregatedList.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationAggregatedList} message OperationAggregatedList message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationAggregatedList.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 3355, wireType 2 =*/26842).string(message.id);
                            if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                                writer.uint32(/* id 3292052, wireType 2 =*/26336418).string(message.kind);
                            if (message.warning != null && Object.hasOwnProperty.call(message, "warning"))
                                $root.google.cloud.compute.v1.Warning.encode(message.warning, writer.uint32(/* id 50704284, wireType 2 =*/405634274).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 79797525, wireType 2 =*/638380202).string(message.nextPageToken);
                            if (message.items != null && Object.hasOwnProperty.call(message, "items"))
                                for (var keys = Object.keys(message.items), i = 0; i < keys.length; ++i) {
                                    writer.uint32(/* id 100526016, wireType 2 =*/804208130).fork().uint32(/* id 1, wireType 2 =*/10).string(keys[i]);
                                    $root.google.cloud.compute.v1.OperationsScopedList.encode(message.items[keys[i]], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim().ldelim();
                                }
                            if (message.unreachables != null && message.unreachables.length)
                                for (var i = 0; i < message.unreachables.length; ++i)
                                    writer.uint32(/* id 243372063, wireType 2 =*/1946976506).string(message.unreachables[i]);
                            if (message.selfLink != null && Object.hasOwnProperty.call(message, "selfLink"))
                                writer.uint32(/* id 456214797, wireType 2 =*/3649718378).string(message.selfLink);
                            return writer;
                        };

                        /**
                         * Encodes the specified OperationAggregatedList message, length delimited. Does not implicitly {@link google.cloud.compute.v1.OperationAggregatedList.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationAggregatedList} message OperationAggregatedList message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationAggregatedList.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an OperationAggregatedList message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.OperationAggregatedList} OperationAggregatedList
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationAggregatedList.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.OperationAggregatedList(), key, value;
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3355:
                                    message.id = reader.string();
                                    break;
                                case 100526016:
                                    if (message.items === $util.emptyObject)
                                        message.items = {};
                                    var end2 = reader.uint32() + reader.pos;
                                    key = "";
                                    value = null;
                                    while (reader.pos < end2) {
                                        var tag2 = reader.uint32();
                                        switch (tag2 >>> 3) {
                                        case 1:
                                            key = reader.string();
                                            break;
                                        case 2:
                                            value = $root.google.cloud.compute.v1.OperationsScopedList.decode(reader, reader.uint32());
                                            break;
                                        default:
                                            reader.skipType(tag2 & 7);
                                            break;
                                        }
                                    }
                                    message.items[key] = value;
                                    break;
                                case 3292052:
                                    message.kind = reader.string();
                                    break;
                                case 79797525:
                                    message.nextPageToken = reader.string();
                                    break;
                                case 456214797:
                                    message.selfLink = reader.string();
                                    break;
                                case 243372063:
                                    if (!(message.unreachables && message.unreachables.length))
                                        message.unreachables = [];
                                    message.unreachables.push(reader.string());
                                    break;
                                case 50704284:
                                    message.warning = $root.google.cloud.compute.v1.Warning.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an OperationAggregatedList message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.OperationAggregatedList} OperationAggregatedList
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationAggregatedList.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an OperationAggregatedList message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OperationAggregatedList.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.id != null && message.hasOwnProperty("id")) {
                                properties._id = 1;
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            }
                            if (message.items != null && message.hasOwnProperty("items")) {
                                if (!$util.isObject(message.items))
                                    return "items: object expected";
                                var key = Object.keys(message.items);
                                for (var i = 0; i < key.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.OperationsScopedList.verify(message.items[key[i]]);
                                    if (error)
                                        return "items." + error;
                                }
                            }
                            if (message.kind != null && message.hasOwnProperty("kind")) {
                                properties._kind = 1;
                                if (!$util.isString(message.kind))
                                    return "kind: string expected";
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken")) {
                                properties._nextPageToken = 1;
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            }
                            if (message.selfLink != null && message.hasOwnProperty("selfLink")) {
                                properties._selfLink = 1;
                                if (!$util.isString(message.selfLink))
                                    return "selfLink: string expected";
                            }
                            if (message.unreachables != null && message.hasOwnProperty("unreachables")) {
                                if (!Array.isArray(message.unreachables))
                                    return "unreachables: array expected";
                                for (var i = 0; i < message.unreachables.length; ++i)
                                    if (!$util.isString(message.unreachables[i]))
                                        return "unreachables: string[] expected";
                            }
                            if (message.warning != null && message.hasOwnProperty("warning")) {
                                properties._warning = 1;
                                {
                                    var error = $root.google.cloud.compute.v1.Warning.verify(message.warning);
                                    if (error)
                                        return "warning." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates an OperationAggregatedList message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.OperationAggregatedList} OperationAggregatedList
                         */
                        OperationAggregatedList.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.OperationAggregatedList)
                                return object;
                            var message = new $root.google.cloud.compute.v1.OperationAggregatedList();
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.items) {
                                if (typeof object.items !== "object")
                                    throw TypeError(".google.cloud.compute.v1.OperationAggregatedList.items: object expected");
                                message.items = {};
                                for (var keys = Object.keys(object.items), i = 0; i < keys.length; ++i) {
                                    if (typeof object.items[keys[i]] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.OperationAggregatedList.items: object expected");
                                    message.items[keys[i]] = $root.google.cloud.compute.v1.OperationsScopedList.fromObject(object.items[keys[i]]);
                                }
                            }
                            if (object.kind != null)
                                message.kind = String(object.kind);
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.selfLink != null)
                                message.selfLink = String(object.selfLink);
                            if (object.unreachables) {
                                if (!Array.isArray(object.unreachables))
                                    throw TypeError(".google.cloud.compute.v1.OperationAggregatedList.unreachables: array expected");
                                message.unreachables = [];
                                for (var i = 0; i < object.unreachables.length; ++i)
                                    message.unreachables[i] = String(object.unreachables[i]);
                            }
                            if (object.warning != null) {
                                if (typeof object.warning !== "object")
                                    throw TypeError(".google.cloud.compute.v1.OperationAggregatedList.warning: object expected");
                                message.warning = $root.google.cloud.compute.v1.Warning.fromObject(object.warning);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an OperationAggregatedList message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @static
                         * @param {google.cloud.compute.v1.OperationAggregatedList} message OperationAggregatedList
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OperationAggregatedList.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.unreachables = [];
                            if (options.objects || options.defaults)
                                object.items = {};
                            if (message.id != null && message.hasOwnProperty("id")) {
                                object.id = message.id;
                                if (options.oneofs)
                                    object._id = "id";
                            }
                            if (message.kind != null && message.hasOwnProperty("kind")) {
                                object.kind = message.kind;
                                if (options.oneofs)
                                    object._kind = "kind";
                            }
                            if (message.warning != null && message.hasOwnProperty("warning")) {
                                object.warning = $root.google.cloud.compute.v1.Warning.toObject(message.warning, options);
                                if (options.oneofs)
                                    object._warning = "warning";
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken")) {
                                object.nextPageToken = message.nextPageToken;
                                if (options.oneofs)
                                    object._nextPageToken = "nextPageToken";
                            }
                            var keys2;
                            if (message.items && (keys2 = Object.keys(message.items)).length) {
                                object.items = {};
                                for (var j = 0; j < keys2.length; ++j)
                                    object.items[keys2[j]] = $root.google.cloud.compute.v1.OperationsScopedList.toObject(message.items[keys2[j]], options);
                            }
                            if (message.unreachables && message.unreachables.length) {
                                object.unreachables = [];
                                for (var j = 0; j < message.unreachables.length; ++j)
                                    object.unreachables[j] = message.unreachables[j];
                            }
                            if (message.selfLink != null && message.hasOwnProperty("selfLink")) {
                                object.selfLink = message.selfLink;
                                if (options.oneofs)
                                    object._selfLink = "selfLink";
                            }
                            return object;
                        };

                        /**
                         * Converts this OperationAggregatedList to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.OperationAggregatedList
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OperationAggregatedList.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return OperationAggregatedList;
                    })();

                    v1.GetRegionOperationRequest = (function() {

                        /**
                         * Properties of a GetRegionOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IGetRegionOperationRequest
                         * @property {string|null} [operation] GetRegionOperationRequest operation
                         * @property {string|null} [project] GetRegionOperationRequest project
                         * @property {string|null} [region] GetRegionOperationRequest region
                         */

                        /**
                         * Constructs a new GetRegionOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a GetRegionOperationRequest.
                         * @implements IGetRegionOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IGetRegionOperationRequest=} [properties] Properties to set
                         */
                        function GetRegionOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetRegionOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @instance
                         */
                        GetRegionOperationRequest.prototype.operation = "";

                        /**
                         * GetRegionOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @instance
                         */
                        GetRegionOperationRequest.prototype.project = "";

                        /**
                         * GetRegionOperationRequest region.
                         * @member {string} region
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @instance
                         */
                        GetRegionOperationRequest.prototype.region = "";

                        /**
                         * Creates a new GetRegionOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetRegionOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.GetRegionOperationRequest} GetRegionOperationRequest instance
                         */
                        GetRegionOperationRequest.create = function create(properties) {
                            return new GetRegionOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified GetRegionOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.GetRegionOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetRegionOperationRequest} message GetRegionOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetRegionOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.region != null && Object.hasOwnProperty.call(message, "region"))
                                writer.uint32(/* id 138946292, wireType 2 =*/1111570338).string(message.region);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetRegionOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.GetRegionOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetRegionOperationRequest} message GetRegionOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetRegionOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetRegionOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.GetRegionOperationRequest} GetRegionOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetRegionOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.GetRegionOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 138946292:
                                    message.region = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetRegionOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.GetRegionOperationRequest} GetRegionOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetRegionOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetRegionOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetRegionOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.region != null && message.hasOwnProperty("region"))
                                if (!$util.isString(message.region))
                                    return "region: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetRegionOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.GetRegionOperationRequest} GetRegionOperationRequest
                         */
                        GetRegionOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.GetRegionOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.GetRegionOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.region != null)
                                message.region = String(object.region);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetRegionOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.GetRegionOperationRequest} message GetRegionOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetRegionOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.operation = "";
                                object.region = "";
                                object.project = "";
                            }
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.region != null && message.hasOwnProperty("region"))
                                object.region = message.region;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this GetRegionOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.GetRegionOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetRegionOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetRegionOperationRequest;
                    })();

                    v1.DeleteRegionOperationRequest = (function() {

                        /**
                         * Properties of a DeleteRegionOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteRegionOperationRequest
                         * @property {string|null} [operation] DeleteRegionOperationRequest operation
                         * @property {string|null} [project] DeleteRegionOperationRequest project
                         * @property {string|null} [region] DeleteRegionOperationRequest region
                         */

                        /**
                         * Constructs a new DeleteRegionOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteRegionOperationRequest.
                         * @implements IDeleteRegionOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationRequest=} [properties] Properties to set
                         */
                        function DeleteRegionOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteRegionOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @instance
                         */
                        DeleteRegionOperationRequest.prototype.operation = "";

                        /**
                         * DeleteRegionOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @instance
                         */
                        DeleteRegionOperationRequest.prototype.project = "";

                        /**
                         * DeleteRegionOperationRequest region.
                         * @member {string} region
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @instance
                         */
                        DeleteRegionOperationRequest.prototype.region = "";

                        /**
                         * Creates a new DeleteRegionOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationRequest} DeleteRegionOperationRequest instance
                         */
                        DeleteRegionOperationRequest.create = function create(properties) {
                            return new DeleteRegionOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified DeleteRegionOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.DeleteRegionOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationRequest} message DeleteRegionOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteRegionOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.region != null && Object.hasOwnProperty.call(message, "region"))
                                writer.uint32(/* id 138946292, wireType 2 =*/1111570338).string(message.region);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteRegionOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteRegionOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationRequest} message DeleteRegionOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteRegionOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteRegionOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationRequest} DeleteRegionOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteRegionOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteRegionOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 138946292:
                                    message.region = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteRegionOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationRequest} DeleteRegionOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteRegionOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteRegionOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteRegionOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.region != null && message.hasOwnProperty("region"))
                                if (!$util.isString(message.region))
                                    return "region: string expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteRegionOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationRequest} DeleteRegionOperationRequest
                         */
                        DeleteRegionOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteRegionOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.DeleteRegionOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.region != null)
                                message.region = String(object.region);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DeleteRegionOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.DeleteRegionOperationRequest} message DeleteRegionOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteRegionOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.operation = "";
                                object.region = "";
                                object.project = "";
                            }
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.region != null && message.hasOwnProperty("region"))
                                object.region = message.region;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this DeleteRegionOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteRegionOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteRegionOperationRequest;
                    })();

                    v1.DeleteRegionOperationResponse = (function() {

                        /**
                         * Properties of a DeleteRegionOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteRegionOperationResponse
                         */

                        /**
                         * Constructs a new DeleteRegionOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteRegionOperationResponse.
                         * @implements IDeleteRegionOperationResponse
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationResponse=} [properties] Properties to set
                         */
                        function DeleteRegionOperationResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DeleteRegionOperationResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationResponse=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationResponse} DeleteRegionOperationResponse instance
                         */
                        DeleteRegionOperationResponse.create = function create(properties) {
                            return new DeleteRegionOperationResponse(properties);
                        };

                        /**
                         * Encodes the specified DeleteRegionOperationResponse message. Does not implicitly {@link google.cloud.compute.v1.DeleteRegionOperationResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationResponse} message DeleteRegionOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteRegionOperationResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteRegionOperationResponse message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteRegionOperationResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationResponse} message DeleteRegionOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteRegionOperationResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteRegionOperationResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationResponse} DeleteRegionOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteRegionOperationResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteRegionOperationResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteRegionOperationResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationResponse} DeleteRegionOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteRegionOperationResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteRegionOperationResponse message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteRegionOperationResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteRegionOperationResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteRegionOperationResponse} DeleteRegionOperationResponse
                         */
                        DeleteRegionOperationResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteRegionOperationResponse)
                                return object;
                            return new $root.google.cloud.compute.v1.DeleteRegionOperationResponse();
                        };

                        /**
                         * Creates a plain object from a DeleteRegionOperationResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.DeleteRegionOperationResponse} message DeleteRegionOperationResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteRegionOperationResponse.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DeleteRegionOperationResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteRegionOperationResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteRegionOperationResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteRegionOperationResponse;
                    })();

                    v1.ListRegionOperationsRequest = (function() {

                        /**
                         * Properties of a ListRegionOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IListRegionOperationsRequest
                         * @property {string|null} [filter] ListRegionOperationsRequest filter
                         * @property {number|null} [maxResults] ListRegionOperationsRequest maxResults
                         * @property {string|null} [orderBy] ListRegionOperationsRequest orderBy
                         * @property {string|null} [pageToken] ListRegionOperationsRequest pageToken
                         * @property {string|null} [project] ListRegionOperationsRequest project
                         * @property {string|null} [region] ListRegionOperationsRequest region
                         * @property {boolean|null} [returnPartialSuccess] ListRegionOperationsRequest returnPartialSuccess
                         */

                        /**
                         * Constructs a new ListRegionOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a ListRegionOperationsRequest.
                         * @implements IListRegionOperationsRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IListRegionOperationsRequest=} [properties] Properties to set
                         */
                        function ListRegionOperationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListRegionOperationsRequest filter.
                         * @member {string|null|undefined} filter
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.filter = null;

                        /**
                         * ListRegionOperationsRequest maxResults.
                         * @member {number|null|undefined} maxResults
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.maxResults = null;

                        /**
                         * ListRegionOperationsRequest orderBy.
                         * @member {string|null|undefined} orderBy
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.orderBy = null;

                        /**
                         * ListRegionOperationsRequest pageToken.
                         * @member {string|null|undefined} pageToken
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.pageToken = null;

                        /**
                         * ListRegionOperationsRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.project = "";

                        /**
                         * ListRegionOperationsRequest region.
                         * @member {string} region
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.region = "";

                        /**
                         * ListRegionOperationsRequest returnPartialSuccess.
                         * @member {boolean|null|undefined} returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        ListRegionOperationsRequest.prototype.returnPartialSuccess = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * ListRegionOperationsRequest _filter.
                         * @member {"filter"|undefined} _filter
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListRegionOperationsRequest.prototype, "_filter", {
                            get: $util.oneOfGetter($oneOfFields = ["filter"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListRegionOperationsRequest _maxResults.
                         * @member {"maxResults"|undefined} _maxResults
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListRegionOperationsRequest.prototype, "_maxResults", {
                            get: $util.oneOfGetter($oneOfFields = ["maxResults"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListRegionOperationsRequest _orderBy.
                         * @member {"orderBy"|undefined} _orderBy
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListRegionOperationsRequest.prototype, "_orderBy", {
                            get: $util.oneOfGetter($oneOfFields = ["orderBy"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListRegionOperationsRequest _pageToken.
                         * @member {"pageToken"|undefined} _pageToken
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListRegionOperationsRequest.prototype, "_pageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["pageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListRegionOperationsRequest _returnPartialSuccess.
                         * @member {"returnPartialSuccess"|undefined} _returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListRegionOperationsRequest.prototype, "_returnPartialSuccess", {
                            get: $util.oneOfGetter($oneOfFields = ["returnPartialSuccess"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new ListRegionOperationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListRegionOperationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.ListRegionOperationsRequest} ListRegionOperationsRequest instance
                         */
                        ListRegionOperationsRequest.create = function create(properties) {
                            return new ListRegionOperationsRequest(properties);
                        };

                        /**
                         * Encodes the specified ListRegionOperationsRequest message. Does not implicitly {@link google.cloud.compute.v1.ListRegionOperationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListRegionOperationsRequest} message ListRegionOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListRegionOperationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 19994697, wireType 2 =*/159957578).string(message.pageToken);
                            if (message.maxResults != null && Object.hasOwnProperty.call(message, "maxResults"))
                                writer.uint32(/* id 54715419, wireType 0 =*/437723352).uint32(message.maxResults);
                            if (message.region != null && Object.hasOwnProperty.call(message, "region"))
                                writer.uint32(/* id 138946292, wireType 2 =*/1111570338).string(message.region);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 160562920, wireType 2 =*/1284503362).string(message.orderBy);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 336120696, wireType 2 =*/2688965570).string(message.filter);
                            if (message.returnPartialSuccess != null && Object.hasOwnProperty.call(message, "returnPartialSuccess"))
                                writer.uint32(/* id 517198390, wireType 0 =*/4137587120).bool(message.returnPartialSuccess);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListRegionOperationsRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.ListRegionOperationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListRegionOperationsRequest} message ListRegionOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListRegionOperationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListRegionOperationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.ListRegionOperationsRequest} ListRegionOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListRegionOperationsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.ListRegionOperationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 336120696:
                                    message.filter = reader.string();
                                    break;
                                case 54715419:
                                    message.maxResults = reader.uint32();
                                    break;
                                case 160562920:
                                    message.orderBy = reader.string();
                                    break;
                                case 19994697:
                                    message.pageToken = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 138946292:
                                    message.region = reader.string();
                                    break;
                                case 517198390:
                                    message.returnPartialSuccess = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListRegionOperationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.ListRegionOperationsRequest} ListRegionOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListRegionOperationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListRegionOperationsRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListRegionOperationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                properties._filter = 1;
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                properties._maxResults = 1;
                                if (!$util.isInteger(message.maxResults))
                                    return "maxResults: integer expected";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                properties._orderBy = 1;
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            }
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                properties._pageToken = 1;
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.region != null && message.hasOwnProperty("region"))
                                if (!$util.isString(message.region))
                                    return "region: string expected";
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                properties._returnPartialSuccess = 1;
                                if (typeof message.returnPartialSuccess !== "boolean")
                                    return "returnPartialSuccess: boolean expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a ListRegionOperationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.ListRegionOperationsRequest} ListRegionOperationsRequest
                         */
                        ListRegionOperationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.ListRegionOperationsRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.ListRegionOperationsRequest();
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.maxResults != null)
                                message.maxResults = object.maxResults >>> 0;
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.region != null)
                                message.region = String(object.region);
                            if (object.returnPartialSuccess != null)
                                message.returnPartialSuccess = Boolean(object.returnPartialSuccess);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListRegionOperationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.ListRegionOperationsRequest} message ListRegionOperationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListRegionOperationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.region = "";
                                object.project = "";
                            }
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                object.pageToken = message.pageToken;
                                if (options.oneofs)
                                    object._pageToken = "pageToken";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                object.maxResults = message.maxResults;
                                if (options.oneofs)
                                    object._maxResults = "maxResults";
                            }
                            if (message.region != null && message.hasOwnProperty("region"))
                                object.region = message.region;
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                object.orderBy = message.orderBy;
                                if (options.oneofs)
                                    object._orderBy = "orderBy";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                object.filter = message.filter;
                                if (options.oneofs)
                                    object._filter = "filter";
                            }
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                object.returnPartialSuccess = message.returnPartialSuccess;
                                if (options.oneofs)
                                    object._returnPartialSuccess = "returnPartialSuccess";
                            }
                            return object;
                        };

                        /**
                         * Converts this ListRegionOperationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.ListRegionOperationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListRegionOperationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListRegionOperationsRequest;
                    })();

                    v1.OperationList = (function() {

                        /**
                         * Properties of an OperationList.
                         * @memberof google.cloud.compute.v1
                         * @interface IOperationList
                         * @property {string|null} [id] OperationList id
                         * @property {Array.<google.cloud.compute.v1.IOperation>|null} [items] OperationList items
                         * @property {string|null} [kind] OperationList kind
                         * @property {string|null} [nextPageToken] OperationList nextPageToken
                         * @property {string|null} [selfLink] OperationList selfLink
                         * @property {google.cloud.compute.v1.IWarning|null} [warning] OperationList warning
                         */

                        /**
                         * Constructs a new OperationList.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an OperationList.
                         * @implements IOperationList
                         * @constructor
                         * @param {google.cloud.compute.v1.IOperationList=} [properties] Properties to set
                         */
                        function OperationList(properties) {
                            this.items = [];
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * OperationList id.
                         * @member {string|null|undefined} id
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        OperationList.prototype.id = null;

                        /**
                         * OperationList items.
                         * @member {Array.<google.cloud.compute.v1.IOperation>} items
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        OperationList.prototype.items = $util.emptyArray;

                        /**
                         * OperationList kind.
                         * @member {string|null|undefined} kind
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        OperationList.prototype.kind = null;

                        /**
                         * OperationList nextPageToken.
                         * @member {string|null|undefined} nextPageToken
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        OperationList.prototype.nextPageToken = null;

                        /**
                         * OperationList selfLink.
                         * @member {string|null|undefined} selfLink
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        OperationList.prototype.selfLink = null;

                        /**
                         * OperationList warning.
                         * @member {google.cloud.compute.v1.IWarning|null|undefined} warning
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        OperationList.prototype.warning = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * OperationList _id.
                         * @member {"id"|undefined} _id
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        Object.defineProperty(OperationList.prototype, "_id", {
                            get: $util.oneOfGetter($oneOfFields = ["id"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationList _kind.
                         * @member {"kind"|undefined} _kind
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        Object.defineProperty(OperationList.prototype, "_kind", {
                            get: $util.oneOfGetter($oneOfFields = ["kind"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationList _nextPageToken.
                         * @member {"nextPageToken"|undefined} _nextPageToken
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        Object.defineProperty(OperationList.prototype, "_nextPageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["nextPageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationList _selfLink.
                         * @member {"selfLink"|undefined} _selfLink
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        Object.defineProperty(OperationList.prototype, "_selfLink", {
                            get: $util.oneOfGetter($oneOfFields = ["selfLink"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * OperationList _warning.
                         * @member {"warning"|undefined} _warning
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         */
                        Object.defineProperty(OperationList.prototype, "_warning", {
                            get: $util.oneOfGetter($oneOfFields = ["warning"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new OperationList instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationList=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.OperationList} OperationList instance
                         */
                        OperationList.create = function create(properties) {
                            return new OperationList(properties);
                        };

                        /**
                         * Encodes the specified OperationList message. Does not implicitly {@link google.cloud.compute.v1.OperationList.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationList} message OperationList message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationList.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.id != null && Object.hasOwnProperty.call(message, "id"))
                                writer.uint32(/* id 3355, wireType 2 =*/26842).string(message.id);
                            if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                                writer.uint32(/* id 3292052, wireType 2 =*/26336418).string(message.kind);
                            if (message.warning != null && Object.hasOwnProperty.call(message, "warning"))
                                $root.google.cloud.compute.v1.Warning.encode(message.warning, writer.uint32(/* id 50704284, wireType 2 =*/405634274).fork()).ldelim();
                            if (message.nextPageToken != null && Object.hasOwnProperty.call(message, "nextPageToken"))
                                writer.uint32(/* id 79797525, wireType 2 =*/638380202).string(message.nextPageToken);
                            if (message.items != null && message.items.length)
                                for (var i = 0; i < message.items.length; ++i)
                                    $root.google.cloud.compute.v1.Operation.encode(message.items[i], writer.uint32(/* id 100526016, wireType 2 =*/804208130).fork()).ldelim();
                            if (message.selfLink != null && Object.hasOwnProperty.call(message, "selfLink"))
                                writer.uint32(/* id 456214797, wireType 2 =*/3649718378).string(message.selfLink);
                            return writer;
                        };

                        /**
                         * Encodes the specified OperationList message, length delimited. Does not implicitly {@link google.cloud.compute.v1.OperationList.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {google.cloud.compute.v1.IOperationList} message OperationList message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        OperationList.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an OperationList message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.OperationList} OperationList
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationList.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.OperationList();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 3355:
                                    message.id = reader.string();
                                    break;
                                case 100526016:
                                    if (!(message.items && message.items.length))
                                        message.items = [];
                                    message.items.push($root.google.cloud.compute.v1.Operation.decode(reader, reader.uint32()));
                                    break;
                                case 3292052:
                                    message.kind = reader.string();
                                    break;
                                case 79797525:
                                    message.nextPageToken = reader.string();
                                    break;
                                case 456214797:
                                    message.selfLink = reader.string();
                                    break;
                                case 50704284:
                                    message.warning = $root.google.cloud.compute.v1.Warning.decode(reader, reader.uint32());
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an OperationList message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.OperationList} OperationList
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        OperationList.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an OperationList message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        OperationList.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.id != null && message.hasOwnProperty("id")) {
                                properties._id = 1;
                                if (!$util.isString(message.id))
                                    return "id: string expected";
                            }
                            if (message.items != null && message.hasOwnProperty("items")) {
                                if (!Array.isArray(message.items))
                                    return "items: array expected";
                                for (var i = 0; i < message.items.length; ++i) {
                                    var error = $root.google.cloud.compute.v1.Operation.verify(message.items[i]);
                                    if (error)
                                        return "items." + error;
                                }
                            }
                            if (message.kind != null && message.hasOwnProperty("kind")) {
                                properties._kind = 1;
                                if (!$util.isString(message.kind))
                                    return "kind: string expected";
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken")) {
                                properties._nextPageToken = 1;
                                if (!$util.isString(message.nextPageToken))
                                    return "nextPageToken: string expected";
                            }
                            if (message.selfLink != null && message.hasOwnProperty("selfLink")) {
                                properties._selfLink = 1;
                                if (!$util.isString(message.selfLink))
                                    return "selfLink: string expected";
                            }
                            if (message.warning != null && message.hasOwnProperty("warning")) {
                                properties._warning = 1;
                                {
                                    var error = $root.google.cloud.compute.v1.Warning.verify(message.warning);
                                    if (error)
                                        return "warning." + error;
                                }
                            }
                            return null;
                        };

                        /**
                         * Creates an OperationList message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.OperationList} OperationList
                         */
                        OperationList.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.OperationList)
                                return object;
                            var message = new $root.google.cloud.compute.v1.OperationList();
                            if (object.id != null)
                                message.id = String(object.id);
                            if (object.items) {
                                if (!Array.isArray(object.items))
                                    throw TypeError(".google.cloud.compute.v1.OperationList.items: array expected");
                                message.items = [];
                                for (var i = 0; i < object.items.length; ++i) {
                                    if (typeof object.items[i] !== "object")
                                        throw TypeError(".google.cloud.compute.v1.OperationList.items: object expected");
                                    message.items[i] = $root.google.cloud.compute.v1.Operation.fromObject(object.items[i]);
                                }
                            }
                            if (object.kind != null)
                                message.kind = String(object.kind);
                            if (object.nextPageToken != null)
                                message.nextPageToken = String(object.nextPageToken);
                            if (object.selfLink != null)
                                message.selfLink = String(object.selfLink);
                            if (object.warning != null) {
                                if (typeof object.warning !== "object")
                                    throw TypeError(".google.cloud.compute.v1.OperationList.warning: object expected");
                                message.warning = $root.google.cloud.compute.v1.Warning.fromObject(object.warning);
                            }
                            return message;
                        };

                        /**
                         * Creates a plain object from an OperationList message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.OperationList
                         * @static
                         * @param {google.cloud.compute.v1.OperationList} message OperationList
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        OperationList.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.arrays || options.defaults)
                                object.items = [];
                            if (message.id != null && message.hasOwnProperty("id")) {
                                object.id = message.id;
                                if (options.oneofs)
                                    object._id = "id";
                            }
                            if (message.kind != null && message.hasOwnProperty("kind")) {
                                object.kind = message.kind;
                                if (options.oneofs)
                                    object._kind = "kind";
                            }
                            if (message.warning != null && message.hasOwnProperty("warning")) {
                                object.warning = $root.google.cloud.compute.v1.Warning.toObject(message.warning, options);
                                if (options.oneofs)
                                    object._warning = "warning";
                            }
                            if (message.nextPageToken != null && message.hasOwnProperty("nextPageToken")) {
                                object.nextPageToken = message.nextPageToken;
                                if (options.oneofs)
                                    object._nextPageToken = "nextPageToken";
                            }
                            if (message.items && message.items.length) {
                                object.items = [];
                                for (var j = 0; j < message.items.length; ++j)
                                    object.items[j] = $root.google.cloud.compute.v1.Operation.toObject(message.items[j], options);
                            }
                            if (message.selfLink != null && message.hasOwnProperty("selfLink")) {
                                object.selfLink = message.selfLink;
                                if (options.oneofs)
                                    object._selfLink = "selfLink";
                            }
                            return object;
                        };

                        /**
                         * Converts this OperationList to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.OperationList
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        OperationList.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return OperationList;
                    })();

                    v1.WaitRegionOperationRequest = (function() {

                        /**
                         * Properties of a WaitRegionOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IWaitRegionOperationRequest
                         * @property {string|null} [operation] WaitRegionOperationRequest operation
                         * @property {string|null} [project] WaitRegionOperationRequest project
                         * @property {string|null} [region] WaitRegionOperationRequest region
                         */

                        /**
                         * Constructs a new WaitRegionOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a WaitRegionOperationRequest.
                         * @implements IWaitRegionOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IWaitRegionOperationRequest=} [properties] Properties to set
                         */
                        function WaitRegionOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * WaitRegionOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @instance
                         */
                        WaitRegionOperationRequest.prototype.operation = "";

                        /**
                         * WaitRegionOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @instance
                         */
                        WaitRegionOperationRequest.prototype.project = "";

                        /**
                         * WaitRegionOperationRequest region.
                         * @member {string} region
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @instance
                         */
                        WaitRegionOperationRequest.prototype.region = "";

                        /**
                         * Creates a new WaitRegionOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitRegionOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.WaitRegionOperationRequest} WaitRegionOperationRequest instance
                         */
                        WaitRegionOperationRequest.create = function create(properties) {
                            return new WaitRegionOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified WaitRegionOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.WaitRegionOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitRegionOperationRequest} message WaitRegionOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WaitRegionOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.region != null && Object.hasOwnProperty.call(message, "region"))
                                writer.uint32(/* id 138946292, wireType 2 =*/1111570338).string(message.region);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified WaitRegionOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.WaitRegionOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitRegionOperationRequest} message WaitRegionOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WaitRegionOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a WaitRegionOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.WaitRegionOperationRequest} WaitRegionOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WaitRegionOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.WaitRegionOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 138946292:
                                    message.region = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a WaitRegionOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.WaitRegionOperationRequest} WaitRegionOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WaitRegionOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a WaitRegionOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        WaitRegionOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.region != null && message.hasOwnProperty("region"))
                                if (!$util.isString(message.region))
                                    return "region: string expected";
                            return null;
                        };

                        /**
                         * Creates a WaitRegionOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.WaitRegionOperationRequest} WaitRegionOperationRequest
                         */
                        WaitRegionOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.WaitRegionOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.WaitRegionOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.region != null)
                                message.region = String(object.region);
                            return message;
                        };

                        /**
                         * Creates a plain object from a WaitRegionOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.WaitRegionOperationRequest} message WaitRegionOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        WaitRegionOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.operation = "";
                                object.region = "";
                                object.project = "";
                            }
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.region != null && message.hasOwnProperty("region"))
                                object.region = message.region;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this WaitRegionOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.WaitRegionOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        WaitRegionOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return WaitRegionOperationRequest;
                    })();

                    v1.DeleteZoneOperationRequest = (function() {

                        /**
                         * Properties of a DeleteZoneOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteZoneOperationRequest
                         * @property {string|null} [operation] DeleteZoneOperationRequest operation
                         * @property {string|null} [project] DeleteZoneOperationRequest project
                         * @property {string|null} [zone] DeleteZoneOperationRequest zone
                         */

                        /**
                         * Constructs a new DeleteZoneOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteZoneOperationRequest.
                         * @implements IDeleteZoneOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationRequest=} [properties] Properties to set
                         */
                        function DeleteZoneOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteZoneOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @instance
                         */
                        DeleteZoneOperationRequest.prototype.operation = "";

                        /**
                         * DeleteZoneOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @instance
                         */
                        DeleteZoneOperationRequest.prototype.project = "";

                        /**
                         * DeleteZoneOperationRequest zone.
                         * @member {string} zone
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @instance
                         */
                        DeleteZoneOperationRequest.prototype.zone = "";

                        /**
                         * Creates a new DeleteZoneOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationRequest} DeleteZoneOperationRequest instance
                         */
                        DeleteZoneOperationRequest.create = function create(properties) {
                            return new DeleteZoneOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified DeleteZoneOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.DeleteZoneOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationRequest} message DeleteZoneOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteZoneOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.zone != null && Object.hasOwnProperty.call(message, "zone"))
                                writer.uint32(/* id 3744684, wireType 2 =*/29957474).string(message.zone);
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteZoneOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteZoneOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationRequest} message DeleteZoneOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteZoneOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteZoneOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationRequest} DeleteZoneOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteZoneOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteZoneOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 3744684:
                                    message.zone = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteZoneOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationRequest} DeleteZoneOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteZoneOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteZoneOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteZoneOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                if (!$util.isString(message.zone))
                                    return "zone: string expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteZoneOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationRequest} DeleteZoneOperationRequest
                         */
                        DeleteZoneOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteZoneOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.DeleteZoneOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.zone != null)
                                message.zone = String(object.zone);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DeleteZoneOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.DeleteZoneOperationRequest} message DeleteZoneOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteZoneOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.zone = "";
                                object.operation = "";
                                object.project = "";
                            }
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                object.zone = message.zone;
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this DeleteZoneOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteZoneOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteZoneOperationRequest;
                    })();

                    v1.DeleteZoneOperationResponse = (function() {

                        /**
                         * Properties of a DeleteZoneOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteZoneOperationResponse
                         */

                        /**
                         * Constructs a new DeleteZoneOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteZoneOperationResponse.
                         * @implements IDeleteZoneOperationResponse
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationResponse=} [properties] Properties to set
                         */
                        function DeleteZoneOperationResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DeleteZoneOperationResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationResponse=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationResponse} DeleteZoneOperationResponse instance
                         */
                        DeleteZoneOperationResponse.create = function create(properties) {
                            return new DeleteZoneOperationResponse(properties);
                        };

                        /**
                         * Encodes the specified DeleteZoneOperationResponse message. Does not implicitly {@link google.cloud.compute.v1.DeleteZoneOperationResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationResponse} message DeleteZoneOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteZoneOperationResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteZoneOperationResponse message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteZoneOperationResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationResponse} message DeleteZoneOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteZoneOperationResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteZoneOperationResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationResponse} DeleteZoneOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteZoneOperationResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteZoneOperationResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteZoneOperationResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationResponse} DeleteZoneOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteZoneOperationResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteZoneOperationResponse message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteZoneOperationResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteZoneOperationResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteZoneOperationResponse} DeleteZoneOperationResponse
                         */
                        DeleteZoneOperationResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteZoneOperationResponse)
                                return object;
                            return new $root.google.cloud.compute.v1.DeleteZoneOperationResponse();
                        };

                        /**
                         * Creates a plain object from a DeleteZoneOperationResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.DeleteZoneOperationResponse} message DeleteZoneOperationResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteZoneOperationResponse.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DeleteZoneOperationResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteZoneOperationResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteZoneOperationResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteZoneOperationResponse;
                    })();

                    v1.GetZoneOperationRequest = (function() {

                        /**
                         * Properties of a GetZoneOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IGetZoneOperationRequest
                         * @property {string|null} [operation] GetZoneOperationRequest operation
                         * @property {string|null} [project] GetZoneOperationRequest project
                         * @property {string|null} [zone] GetZoneOperationRequest zone
                         */

                        /**
                         * Constructs a new GetZoneOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a GetZoneOperationRequest.
                         * @implements IGetZoneOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IGetZoneOperationRequest=} [properties] Properties to set
                         */
                        function GetZoneOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetZoneOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @instance
                         */
                        GetZoneOperationRequest.prototype.operation = "";

                        /**
                         * GetZoneOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @instance
                         */
                        GetZoneOperationRequest.prototype.project = "";

                        /**
                         * GetZoneOperationRequest zone.
                         * @member {string} zone
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @instance
                         */
                        GetZoneOperationRequest.prototype.zone = "";

                        /**
                         * Creates a new GetZoneOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetZoneOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.GetZoneOperationRequest} GetZoneOperationRequest instance
                         */
                        GetZoneOperationRequest.create = function create(properties) {
                            return new GetZoneOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified GetZoneOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.GetZoneOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetZoneOperationRequest} message GetZoneOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetZoneOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.zone != null && Object.hasOwnProperty.call(message, "zone"))
                                writer.uint32(/* id 3744684, wireType 2 =*/29957474).string(message.zone);
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetZoneOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.GetZoneOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetZoneOperationRequest} message GetZoneOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetZoneOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetZoneOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.GetZoneOperationRequest} GetZoneOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetZoneOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.GetZoneOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 3744684:
                                    message.zone = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetZoneOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.GetZoneOperationRequest} GetZoneOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetZoneOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetZoneOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetZoneOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                if (!$util.isString(message.zone))
                                    return "zone: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetZoneOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.GetZoneOperationRequest} GetZoneOperationRequest
                         */
                        GetZoneOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.GetZoneOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.GetZoneOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.zone != null)
                                message.zone = String(object.zone);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetZoneOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.GetZoneOperationRequest} message GetZoneOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetZoneOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.zone = "";
                                object.operation = "";
                                object.project = "";
                            }
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                object.zone = message.zone;
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this GetZoneOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.GetZoneOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetZoneOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetZoneOperationRequest;
                    })();

                    v1.ListZoneOperationsRequest = (function() {

                        /**
                         * Properties of a ListZoneOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IListZoneOperationsRequest
                         * @property {string|null} [filter] ListZoneOperationsRequest filter
                         * @property {number|null} [maxResults] ListZoneOperationsRequest maxResults
                         * @property {string|null} [orderBy] ListZoneOperationsRequest orderBy
                         * @property {string|null} [pageToken] ListZoneOperationsRequest pageToken
                         * @property {string|null} [project] ListZoneOperationsRequest project
                         * @property {boolean|null} [returnPartialSuccess] ListZoneOperationsRequest returnPartialSuccess
                         * @property {string|null} [zone] ListZoneOperationsRequest zone
                         */

                        /**
                         * Constructs a new ListZoneOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a ListZoneOperationsRequest.
                         * @implements IListZoneOperationsRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IListZoneOperationsRequest=} [properties] Properties to set
                         */
                        function ListZoneOperationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListZoneOperationsRequest filter.
                         * @member {string|null|undefined} filter
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.filter = null;

                        /**
                         * ListZoneOperationsRequest maxResults.
                         * @member {number|null|undefined} maxResults
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.maxResults = null;

                        /**
                         * ListZoneOperationsRequest orderBy.
                         * @member {string|null|undefined} orderBy
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.orderBy = null;

                        /**
                         * ListZoneOperationsRequest pageToken.
                         * @member {string|null|undefined} pageToken
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.pageToken = null;

                        /**
                         * ListZoneOperationsRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.project = "";

                        /**
                         * ListZoneOperationsRequest returnPartialSuccess.
                         * @member {boolean|null|undefined} returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.returnPartialSuccess = null;

                        /**
                         * ListZoneOperationsRequest zone.
                         * @member {string} zone
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        ListZoneOperationsRequest.prototype.zone = "";

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * ListZoneOperationsRequest _filter.
                         * @member {"filter"|undefined} _filter
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListZoneOperationsRequest.prototype, "_filter", {
                            get: $util.oneOfGetter($oneOfFields = ["filter"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListZoneOperationsRequest _maxResults.
                         * @member {"maxResults"|undefined} _maxResults
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListZoneOperationsRequest.prototype, "_maxResults", {
                            get: $util.oneOfGetter($oneOfFields = ["maxResults"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListZoneOperationsRequest _orderBy.
                         * @member {"orderBy"|undefined} _orderBy
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListZoneOperationsRequest.prototype, "_orderBy", {
                            get: $util.oneOfGetter($oneOfFields = ["orderBy"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListZoneOperationsRequest _pageToken.
                         * @member {"pageToken"|undefined} _pageToken
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListZoneOperationsRequest.prototype, "_pageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["pageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListZoneOperationsRequest _returnPartialSuccess.
                         * @member {"returnPartialSuccess"|undefined} _returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListZoneOperationsRequest.prototype, "_returnPartialSuccess", {
                            get: $util.oneOfGetter($oneOfFields = ["returnPartialSuccess"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new ListZoneOperationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListZoneOperationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.ListZoneOperationsRequest} ListZoneOperationsRequest instance
                         */
                        ListZoneOperationsRequest.create = function create(properties) {
                            return new ListZoneOperationsRequest(properties);
                        };

                        /**
                         * Encodes the specified ListZoneOperationsRequest message. Does not implicitly {@link google.cloud.compute.v1.ListZoneOperationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListZoneOperationsRequest} message ListZoneOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListZoneOperationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.zone != null && Object.hasOwnProperty.call(message, "zone"))
                                writer.uint32(/* id 3744684, wireType 2 =*/29957474).string(message.zone);
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 19994697, wireType 2 =*/159957578).string(message.pageToken);
                            if (message.maxResults != null && Object.hasOwnProperty.call(message, "maxResults"))
                                writer.uint32(/* id 54715419, wireType 0 =*/437723352).uint32(message.maxResults);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 160562920, wireType 2 =*/1284503362).string(message.orderBy);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 336120696, wireType 2 =*/2688965570).string(message.filter);
                            if (message.returnPartialSuccess != null && Object.hasOwnProperty.call(message, "returnPartialSuccess"))
                                writer.uint32(/* id 517198390, wireType 0 =*/4137587120).bool(message.returnPartialSuccess);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListZoneOperationsRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.ListZoneOperationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListZoneOperationsRequest} message ListZoneOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListZoneOperationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListZoneOperationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.ListZoneOperationsRequest} ListZoneOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListZoneOperationsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.ListZoneOperationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 336120696:
                                    message.filter = reader.string();
                                    break;
                                case 54715419:
                                    message.maxResults = reader.uint32();
                                    break;
                                case 160562920:
                                    message.orderBy = reader.string();
                                    break;
                                case 19994697:
                                    message.pageToken = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 517198390:
                                    message.returnPartialSuccess = reader.bool();
                                    break;
                                case 3744684:
                                    message.zone = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListZoneOperationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.ListZoneOperationsRequest} ListZoneOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListZoneOperationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListZoneOperationsRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListZoneOperationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                properties._filter = 1;
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                properties._maxResults = 1;
                                if (!$util.isInteger(message.maxResults))
                                    return "maxResults: integer expected";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                properties._orderBy = 1;
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            }
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                properties._pageToken = 1;
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                properties._returnPartialSuccess = 1;
                                if (typeof message.returnPartialSuccess !== "boolean")
                                    return "returnPartialSuccess: boolean expected";
                            }
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                if (!$util.isString(message.zone))
                                    return "zone: string expected";
                            return null;
                        };

                        /**
                         * Creates a ListZoneOperationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.ListZoneOperationsRequest} ListZoneOperationsRequest
                         */
                        ListZoneOperationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.ListZoneOperationsRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.ListZoneOperationsRequest();
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.maxResults != null)
                                message.maxResults = object.maxResults >>> 0;
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.returnPartialSuccess != null)
                                message.returnPartialSuccess = Boolean(object.returnPartialSuccess);
                            if (object.zone != null)
                                message.zone = String(object.zone);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListZoneOperationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.ListZoneOperationsRequest} message ListZoneOperationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListZoneOperationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.zone = "";
                                object.project = "";
                            }
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                object.zone = message.zone;
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                object.pageToken = message.pageToken;
                                if (options.oneofs)
                                    object._pageToken = "pageToken";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                object.maxResults = message.maxResults;
                                if (options.oneofs)
                                    object._maxResults = "maxResults";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                object.orderBy = message.orderBy;
                                if (options.oneofs)
                                    object._orderBy = "orderBy";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                object.filter = message.filter;
                                if (options.oneofs)
                                    object._filter = "filter";
                            }
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                object.returnPartialSuccess = message.returnPartialSuccess;
                                if (options.oneofs)
                                    object._returnPartialSuccess = "returnPartialSuccess";
                            }
                            return object;
                        };

                        /**
                         * Converts this ListZoneOperationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.ListZoneOperationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListZoneOperationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListZoneOperationsRequest;
                    })();

                    v1.WaitZoneOperationRequest = (function() {

                        /**
                         * Properties of a WaitZoneOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IWaitZoneOperationRequest
                         * @property {string|null} [operation] WaitZoneOperationRequest operation
                         * @property {string|null} [project] WaitZoneOperationRequest project
                         * @property {string|null} [zone] WaitZoneOperationRequest zone
                         */

                        /**
                         * Constructs a new WaitZoneOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a WaitZoneOperationRequest.
                         * @implements IWaitZoneOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IWaitZoneOperationRequest=} [properties] Properties to set
                         */
                        function WaitZoneOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * WaitZoneOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @instance
                         */
                        WaitZoneOperationRequest.prototype.operation = "";

                        /**
                         * WaitZoneOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @instance
                         */
                        WaitZoneOperationRequest.prototype.project = "";

                        /**
                         * WaitZoneOperationRequest zone.
                         * @member {string} zone
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @instance
                         */
                        WaitZoneOperationRequest.prototype.zone = "";

                        /**
                         * Creates a new WaitZoneOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitZoneOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.WaitZoneOperationRequest} WaitZoneOperationRequest instance
                         */
                        WaitZoneOperationRequest.create = function create(properties) {
                            return new WaitZoneOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified WaitZoneOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.WaitZoneOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitZoneOperationRequest} message WaitZoneOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WaitZoneOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.zone != null && Object.hasOwnProperty.call(message, "zone"))
                                writer.uint32(/* id 3744684, wireType 2 =*/29957474).string(message.zone);
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified WaitZoneOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.WaitZoneOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitZoneOperationRequest} message WaitZoneOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WaitZoneOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a WaitZoneOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.WaitZoneOperationRequest} WaitZoneOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WaitZoneOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.WaitZoneOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 3744684:
                                    message.zone = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a WaitZoneOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.WaitZoneOperationRequest} WaitZoneOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WaitZoneOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a WaitZoneOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        WaitZoneOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                if (!$util.isString(message.zone))
                                    return "zone: string expected";
                            return null;
                        };

                        /**
                         * Creates a WaitZoneOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.WaitZoneOperationRequest} WaitZoneOperationRequest
                         */
                        WaitZoneOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.WaitZoneOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.WaitZoneOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.zone != null)
                                message.zone = String(object.zone);
                            return message;
                        };

                        /**
                         * Creates a plain object from a WaitZoneOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.WaitZoneOperationRequest} message WaitZoneOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        WaitZoneOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.zone = "";
                                object.operation = "";
                                object.project = "";
                            }
                            if (message.zone != null && message.hasOwnProperty("zone"))
                                object.zone = message.zone;
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this WaitZoneOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.WaitZoneOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        WaitZoneOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return WaitZoneOperationRequest;
                    })();

                    v1.AggregatedListGlobalOperationsRequest = (function() {

                        /**
                         * Properties of an AggregatedListGlobalOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IAggregatedListGlobalOperationsRequest
                         * @property {string|null} [filter] AggregatedListGlobalOperationsRequest filter
                         * @property {boolean|null} [includeAllScopes] AggregatedListGlobalOperationsRequest includeAllScopes
                         * @property {number|null} [maxResults] AggregatedListGlobalOperationsRequest maxResults
                         * @property {string|null} [orderBy] AggregatedListGlobalOperationsRequest orderBy
                         * @property {string|null} [pageToken] AggregatedListGlobalOperationsRequest pageToken
                         * @property {string|null} [project] AggregatedListGlobalOperationsRequest project
                         * @property {boolean|null} [returnPartialSuccess] AggregatedListGlobalOperationsRequest returnPartialSuccess
                         */

                        /**
                         * Constructs a new AggregatedListGlobalOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents an AggregatedListGlobalOperationsRequest.
                         * @implements IAggregatedListGlobalOperationsRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IAggregatedListGlobalOperationsRequest=} [properties] Properties to set
                         */
                        function AggregatedListGlobalOperationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * AggregatedListGlobalOperationsRequest filter.
                         * @member {string|null|undefined} filter
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.filter = null;

                        /**
                         * AggregatedListGlobalOperationsRequest includeAllScopes.
                         * @member {boolean|null|undefined} includeAllScopes
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.includeAllScopes = null;

                        /**
                         * AggregatedListGlobalOperationsRequest maxResults.
                         * @member {number|null|undefined} maxResults
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.maxResults = null;

                        /**
                         * AggregatedListGlobalOperationsRequest orderBy.
                         * @member {string|null|undefined} orderBy
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.orderBy = null;

                        /**
                         * AggregatedListGlobalOperationsRequest pageToken.
                         * @member {string|null|undefined} pageToken
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.pageToken = null;

                        /**
                         * AggregatedListGlobalOperationsRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.project = "";

                        /**
                         * AggregatedListGlobalOperationsRequest returnPartialSuccess.
                         * @member {boolean|null|undefined} returnPartialSuccess
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        AggregatedListGlobalOperationsRequest.prototype.returnPartialSuccess = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * AggregatedListGlobalOperationsRequest _filter.
                         * @member {"filter"|undefined} _filter
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(AggregatedListGlobalOperationsRequest.prototype, "_filter", {
                            get: $util.oneOfGetter($oneOfFields = ["filter"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * AggregatedListGlobalOperationsRequest _includeAllScopes.
                         * @member {"includeAllScopes"|undefined} _includeAllScopes
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(AggregatedListGlobalOperationsRequest.prototype, "_includeAllScopes", {
                            get: $util.oneOfGetter($oneOfFields = ["includeAllScopes"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * AggregatedListGlobalOperationsRequest _maxResults.
                         * @member {"maxResults"|undefined} _maxResults
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(AggregatedListGlobalOperationsRequest.prototype, "_maxResults", {
                            get: $util.oneOfGetter($oneOfFields = ["maxResults"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * AggregatedListGlobalOperationsRequest _orderBy.
                         * @member {"orderBy"|undefined} _orderBy
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(AggregatedListGlobalOperationsRequest.prototype, "_orderBy", {
                            get: $util.oneOfGetter($oneOfFields = ["orderBy"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * AggregatedListGlobalOperationsRequest _pageToken.
                         * @member {"pageToken"|undefined} _pageToken
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(AggregatedListGlobalOperationsRequest.prototype, "_pageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["pageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * AggregatedListGlobalOperationsRequest _returnPartialSuccess.
                         * @member {"returnPartialSuccess"|undefined} _returnPartialSuccess
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(AggregatedListGlobalOperationsRequest.prototype, "_returnPartialSuccess", {
                            get: $util.oneOfGetter($oneOfFields = ["returnPartialSuccess"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new AggregatedListGlobalOperationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IAggregatedListGlobalOperationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.AggregatedListGlobalOperationsRequest} AggregatedListGlobalOperationsRequest instance
                         */
                        AggregatedListGlobalOperationsRequest.create = function create(properties) {
                            return new AggregatedListGlobalOperationsRequest(properties);
                        };

                        /**
                         * Encodes the specified AggregatedListGlobalOperationsRequest message. Does not implicitly {@link google.cloud.compute.v1.AggregatedListGlobalOperationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IAggregatedListGlobalOperationsRequest} message AggregatedListGlobalOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AggregatedListGlobalOperationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 19994697, wireType 2 =*/159957578).string(message.pageToken);
                            if (message.maxResults != null && Object.hasOwnProperty.call(message, "maxResults"))
                                writer.uint32(/* id 54715419, wireType 0 =*/437723352).uint32(message.maxResults);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 160562920, wireType 2 =*/1284503362).string(message.orderBy);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 336120696, wireType 2 =*/2688965570).string(message.filter);
                            if (message.includeAllScopes != null && Object.hasOwnProperty.call(message, "includeAllScopes"))
                                writer.uint32(/* id 391327988, wireType 0 =*/3130623904).bool(message.includeAllScopes);
                            if (message.returnPartialSuccess != null && Object.hasOwnProperty.call(message, "returnPartialSuccess"))
                                writer.uint32(/* id 517198390, wireType 0 =*/4137587120).bool(message.returnPartialSuccess);
                            return writer;
                        };

                        /**
                         * Encodes the specified AggregatedListGlobalOperationsRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.AggregatedListGlobalOperationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IAggregatedListGlobalOperationsRequest} message AggregatedListGlobalOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        AggregatedListGlobalOperationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes an AggregatedListGlobalOperationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.AggregatedListGlobalOperationsRequest} AggregatedListGlobalOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AggregatedListGlobalOperationsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.AggregatedListGlobalOperationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 336120696:
                                    message.filter = reader.string();
                                    break;
                                case 391327988:
                                    message.includeAllScopes = reader.bool();
                                    break;
                                case 54715419:
                                    message.maxResults = reader.uint32();
                                    break;
                                case 160562920:
                                    message.orderBy = reader.string();
                                    break;
                                case 19994697:
                                    message.pageToken = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 517198390:
                                    message.returnPartialSuccess = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes an AggregatedListGlobalOperationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.AggregatedListGlobalOperationsRequest} AggregatedListGlobalOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        AggregatedListGlobalOperationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies an AggregatedListGlobalOperationsRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        AggregatedListGlobalOperationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                properties._filter = 1;
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            }
                            if (message.includeAllScopes != null && message.hasOwnProperty("includeAllScopes")) {
                                properties._includeAllScopes = 1;
                                if (typeof message.includeAllScopes !== "boolean")
                                    return "includeAllScopes: boolean expected";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                properties._maxResults = 1;
                                if (!$util.isInteger(message.maxResults))
                                    return "maxResults: integer expected";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                properties._orderBy = 1;
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            }
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                properties._pageToken = 1;
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                properties._returnPartialSuccess = 1;
                                if (typeof message.returnPartialSuccess !== "boolean")
                                    return "returnPartialSuccess: boolean expected";
                            }
                            return null;
                        };

                        /**
                         * Creates an AggregatedListGlobalOperationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.AggregatedListGlobalOperationsRequest} AggregatedListGlobalOperationsRequest
                         */
                        AggregatedListGlobalOperationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.AggregatedListGlobalOperationsRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.AggregatedListGlobalOperationsRequest();
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.includeAllScopes != null)
                                message.includeAllScopes = Boolean(object.includeAllScopes);
                            if (object.maxResults != null)
                                message.maxResults = object.maxResults >>> 0;
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.returnPartialSuccess != null)
                                message.returnPartialSuccess = Boolean(object.returnPartialSuccess);
                            return message;
                        };

                        /**
                         * Creates a plain object from an AggregatedListGlobalOperationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.AggregatedListGlobalOperationsRequest} message AggregatedListGlobalOperationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        AggregatedListGlobalOperationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.project = "";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                object.pageToken = message.pageToken;
                                if (options.oneofs)
                                    object._pageToken = "pageToken";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                object.maxResults = message.maxResults;
                                if (options.oneofs)
                                    object._maxResults = "maxResults";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                object.orderBy = message.orderBy;
                                if (options.oneofs)
                                    object._orderBy = "orderBy";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                object.filter = message.filter;
                                if (options.oneofs)
                                    object._filter = "filter";
                            }
                            if (message.includeAllScopes != null && message.hasOwnProperty("includeAllScopes")) {
                                object.includeAllScopes = message.includeAllScopes;
                                if (options.oneofs)
                                    object._includeAllScopes = "includeAllScopes";
                            }
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                object.returnPartialSuccess = message.returnPartialSuccess;
                                if (options.oneofs)
                                    object._returnPartialSuccess = "returnPartialSuccess";
                            }
                            return object;
                        };

                        /**
                         * Converts this AggregatedListGlobalOperationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.AggregatedListGlobalOperationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        AggregatedListGlobalOperationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return AggregatedListGlobalOperationsRequest;
                    })();

                    v1.DeleteGlobalOperationRequest = (function() {

                        /**
                         * Properties of a DeleteGlobalOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteGlobalOperationRequest
                         * @property {string|null} [operation] DeleteGlobalOperationRequest operation
                         * @property {string|null} [project] DeleteGlobalOperationRequest project
                         */

                        /**
                         * Constructs a new DeleteGlobalOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteGlobalOperationRequest.
                         * @implements IDeleteGlobalOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationRequest=} [properties] Properties to set
                         */
                        function DeleteGlobalOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteGlobalOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @instance
                         */
                        DeleteGlobalOperationRequest.prototype.operation = "";

                        /**
                         * DeleteGlobalOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @instance
                         */
                        DeleteGlobalOperationRequest.prototype.project = "";

                        /**
                         * Creates a new DeleteGlobalOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationRequest} DeleteGlobalOperationRequest instance
                         */
                        DeleteGlobalOperationRequest.create = function create(properties) {
                            return new DeleteGlobalOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified DeleteGlobalOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationRequest} message DeleteGlobalOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteGlobalOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationRequest} message DeleteGlobalOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteGlobalOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationRequest} DeleteGlobalOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteGlobalOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteGlobalOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationRequest} DeleteGlobalOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteGlobalOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteGlobalOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteGlobalOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationRequest} DeleteGlobalOperationRequest
                         */
                        DeleteGlobalOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteGlobalOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.DeleteGlobalOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DeleteGlobalOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.DeleteGlobalOperationRequest} message DeleteGlobalOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteGlobalOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.operation = "";
                                object.project = "";
                            }
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this DeleteGlobalOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteGlobalOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteGlobalOperationRequest;
                    })();

                    v1.DeleteGlobalOperationResponse = (function() {

                        /**
                         * Properties of a DeleteGlobalOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteGlobalOperationResponse
                         */

                        /**
                         * Constructs a new DeleteGlobalOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteGlobalOperationResponse.
                         * @implements IDeleteGlobalOperationResponse
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationResponse=} [properties] Properties to set
                         */
                        function DeleteGlobalOperationResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DeleteGlobalOperationResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationResponse=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationResponse} DeleteGlobalOperationResponse instance
                         */
                        DeleteGlobalOperationResponse.create = function create(properties) {
                            return new DeleteGlobalOperationResponse(properties);
                        };

                        /**
                         * Encodes the specified DeleteGlobalOperationResponse message. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOperationResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationResponse} message DeleteGlobalOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOperationResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteGlobalOperationResponse message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOperationResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationResponse} message DeleteGlobalOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOperationResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteGlobalOperationResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationResponse} DeleteGlobalOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOperationResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteGlobalOperationResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteGlobalOperationResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationResponse} DeleteGlobalOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOperationResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteGlobalOperationResponse message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteGlobalOperationResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteGlobalOperationResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteGlobalOperationResponse} DeleteGlobalOperationResponse
                         */
                        DeleteGlobalOperationResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteGlobalOperationResponse)
                                return object;
                            return new $root.google.cloud.compute.v1.DeleteGlobalOperationResponse();
                        };

                        /**
                         * Creates a plain object from a DeleteGlobalOperationResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.DeleteGlobalOperationResponse} message DeleteGlobalOperationResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteGlobalOperationResponse.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DeleteGlobalOperationResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteGlobalOperationResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteGlobalOperationResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteGlobalOperationResponse;
                    })();

                    v1.GetGlobalOperationRequest = (function() {

                        /**
                         * Properties of a GetGlobalOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IGetGlobalOperationRequest
                         * @property {string|null} [operation] GetGlobalOperationRequest operation
                         * @property {string|null} [project] GetGlobalOperationRequest project
                         */

                        /**
                         * Constructs a new GetGlobalOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a GetGlobalOperationRequest.
                         * @implements IGetGlobalOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IGetGlobalOperationRequest=} [properties] Properties to set
                         */
                        function GetGlobalOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetGlobalOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @instance
                         */
                        GetGlobalOperationRequest.prototype.operation = "";

                        /**
                         * GetGlobalOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @instance
                         */
                        GetGlobalOperationRequest.prototype.project = "";

                        /**
                         * Creates a new GetGlobalOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetGlobalOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.GetGlobalOperationRequest} GetGlobalOperationRequest instance
                         */
                        GetGlobalOperationRequest.create = function create(properties) {
                            return new GetGlobalOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified GetGlobalOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.GetGlobalOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetGlobalOperationRequest} message GetGlobalOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetGlobalOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetGlobalOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.GetGlobalOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetGlobalOperationRequest} message GetGlobalOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetGlobalOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetGlobalOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.GetGlobalOperationRequest} GetGlobalOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetGlobalOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.GetGlobalOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetGlobalOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.GetGlobalOperationRequest} GetGlobalOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetGlobalOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetGlobalOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetGlobalOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            return null;
                        };

                        /**
                         * Creates a GetGlobalOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.GetGlobalOperationRequest} GetGlobalOperationRequest
                         */
                        GetGlobalOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.GetGlobalOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.GetGlobalOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetGlobalOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.GetGlobalOperationRequest} message GetGlobalOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetGlobalOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.operation = "";
                                object.project = "";
                            }
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this GetGlobalOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.GetGlobalOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetGlobalOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetGlobalOperationRequest;
                    })();

                    v1.ListGlobalOperationsRequest = (function() {

                        /**
                         * Properties of a ListGlobalOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IListGlobalOperationsRequest
                         * @property {string|null} [filter] ListGlobalOperationsRequest filter
                         * @property {number|null} [maxResults] ListGlobalOperationsRequest maxResults
                         * @property {string|null} [orderBy] ListGlobalOperationsRequest orderBy
                         * @property {string|null} [pageToken] ListGlobalOperationsRequest pageToken
                         * @property {string|null} [project] ListGlobalOperationsRequest project
                         * @property {boolean|null} [returnPartialSuccess] ListGlobalOperationsRequest returnPartialSuccess
                         */

                        /**
                         * Constructs a new ListGlobalOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a ListGlobalOperationsRequest.
                         * @implements IListGlobalOperationsRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IListGlobalOperationsRequest=} [properties] Properties to set
                         */
                        function ListGlobalOperationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListGlobalOperationsRequest filter.
                         * @member {string|null|undefined} filter
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        ListGlobalOperationsRequest.prototype.filter = null;

                        /**
                         * ListGlobalOperationsRequest maxResults.
                         * @member {number|null|undefined} maxResults
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        ListGlobalOperationsRequest.prototype.maxResults = null;

                        /**
                         * ListGlobalOperationsRequest orderBy.
                         * @member {string|null|undefined} orderBy
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        ListGlobalOperationsRequest.prototype.orderBy = null;

                        /**
                         * ListGlobalOperationsRequest pageToken.
                         * @member {string|null|undefined} pageToken
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        ListGlobalOperationsRequest.prototype.pageToken = null;

                        /**
                         * ListGlobalOperationsRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        ListGlobalOperationsRequest.prototype.project = "";

                        /**
                         * ListGlobalOperationsRequest returnPartialSuccess.
                         * @member {boolean|null|undefined} returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        ListGlobalOperationsRequest.prototype.returnPartialSuccess = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * ListGlobalOperationsRequest _filter.
                         * @member {"filter"|undefined} _filter
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOperationsRequest.prototype, "_filter", {
                            get: $util.oneOfGetter($oneOfFields = ["filter"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOperationsRequest _maxResults.
                         * @member {"maxResults"|undefined} _maxResults
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOperationsRequest.prototype, "_maxResults", {
                            get: $util.oneOfGetter($oneOfFields = ["maxResults"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOperationsRequest _orderBy.
                         * @member {"orderBy"|undefined} _orderBy
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOperationsRequest.prototype, "_orderBy", {
                            get: $util.oneOfGetter($oneOfFields = ["orderBy"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOperationsRequest _pageToken.
                         * @member {"pageToken"|undefined} _pageToken
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOperationsRequest.prototype, "_pageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["pageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOperationsRequest _returnPartialSuccess.
                         * @member {"returnPartialSuccess"|undefined} _returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOperationsRequest.prototype, "_returnPartialSuccess", {
                            get: $util.oneOfGetter($oneOfFields = ["returnPartialSuccess"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new ListGlobalOperationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListGlobalOperationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.ListGlobalOperationsRequest} ListGlobalOperationsRequest instance
                         */
                        ListGlobalOperationsRequest.create = function create(properties) {
                            return new ListGlobalOperationsRequest(properties);
                        };

                        /**
                         * Encodes the specified ListGlobalOperationsRequest message. Does not implicitly {@link google.cloud.compute.v1.ListGlobalOperationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListGlobalOperationsRequest} message ListGlobalOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGlobalOperationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 19994697, wireType 2 =*/159957578).string(message.pageToken);
                            if (message.maxResults != null && Object.hasOwnProperty.call(message, "maxResults"))
                                writer.uint32(/* id 54715419, wireType 0 =*/437723352).uint32(message.maxResults);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 160562920, wireType 2 =*/1284503362).string(message.orderBy);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 336120696, wireType 2 =*/2688965570).string(message.filter);
                            if (message.returnPartialSuccess != null && Object.hasOwnProperty.call(message, "returnPartialSuccess"))
                                writer.uint32(/* id 517198390, wireType 0 =*/4137587120).bool(message.returnPartialSuccess);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListGlobalOperationsRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.ListGlobalOperationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListGlobalOperationsRequest} message ListGlobalOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGlobalOperationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListGlobalOperationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.ListGlobalOperationsRequest} ListGlobalOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGlobalOperationsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.ListGlobalOperationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 336120696:
                                    message.filter = reader.string();
                                    break;
                                case 54715419:
                                    message.maxResults = reader.uint32();
                                    break;
                                case 160562920:
                                    message.orderBy = reader.string();
                                    break;
                                case 19994697:
                                    message.pageToken = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                case 517198390:
                                    message.returnPartialSuccess = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListGlobalOperationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.ListGlobalOperationsRequest} ListGlobalOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGlobalOperationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListGlobalOperationsRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListGlobalOperationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                properties._filter = 1;
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                properties._maxResults = 1;
                                if (!$util.isInteger(message.maxResults))
                                    return "maxResults: integer expected";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                properties._orderBy = 1;
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            }
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                properties._pageToken = 1;
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                properties._returnPartialSuccess = 1;
                                if (typeof message.returnPartialSuccess !== "boolean")
                                    return "returnPartialSuccess: boolean expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a ListGlobalOperationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.ListGlobalOperationsRequest} ListGlobalOperationsRequest
                         */
                        ListGlobalOperationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.ListGlobalOperationsRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.ListGlobalOperationsRequest();
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.maxResults != null)
                                message.maxResults = object.maxResults >>> 0;
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.project != null)
                                message.project = String(object.project);
                            if (object.returnPartialSuccess != null)
                                message.returnPartialSuccess = Boolean(object.returnPartialSuccess);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListGlobalOperationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.ListGlobalOperationsRequest} message ListGlobalOperationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListGlobalOperationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.project = "";
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                object.pageToken = message.pageToken;
                                if (options.oneofs)
                                    object._pageToken = "pageToken";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                object.maxResults = message.maxResults;
                                if (options.oneofs)
                                    object._maxResults = "maxResults";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                object.orderBy = message.orderBy;
                                if (options.oneofs)
                                    object._orderBy = "orderBy";
                            }
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                object.filter = message.filter;
                                if (options.oneofs)
                                    object._filter = "filter";
                            }
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                object.returnPartialSuccess = message.returnPartialSuccess;
                                if (options.oneofs)
                                    object._returnPartialSuccess = "returnPartialSuccess";
                            }
                            return object;
                        };

                        /**
                         * Converts this ListGlobalOperationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.ListGlobalOperationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListGlobalOperationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListGlobalOperationsRequest;
                    })();

                    v1.WaitGlobalOperationRequest = (function() {

                        /**
                         * Properties of a WaitGlobalOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IWaitGlobalOperationRequest
                         * @property {string|null} [operation] WaitGlobalOperationRequest operation
                         * @property {string|null} [project] WaitGlobalOperationRequest project
                         */

                        /**
                         * Constructs a new WaitGlobalOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a WaitGlobalOperationRequest.
                         * @implements IWaitGlobalOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IWaitGlobalOperationRequest=} [properties] Properties to set
                         */
                        function WaitGlobalOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * WaitGlobalOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @instance
                         */
                        WaitGlobalOperationRequest.prototype.operation = "";

                        /**
                         * WaitGlobalOperationRequest project.
                         * @member {string} project
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @instance
                         */
                        WaitGlobalOperationRequest.prototype.project = "";

                        /**
                         * Creates a new WaitGlobalOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitGlobalOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.WaitGlobalOperationRequest} WaitGlobalOperationRequest instance
                         */
                        WaitGlobalOperationRequest.create = function create(properties) {
                            return new WaitGlobalOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified WaitGlobalOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.WaitGlobalOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitGlobalOperationRequest} message WaitGlobalOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WaitGlobalOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.project != null && Object.hasOwnProperty.call(message, "project"))
                                writer.uint32(/* id 227560217, wireType 2 =*/1820481738).string(message.project);
                            return writer;
                        };

                        /**
                         * Encodes the specified WaitGlobalOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.WaitGlobalOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IWaitGlobalOperationRequest} message WaitGlobalOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        WaitGlobalOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a WaitGlobalOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.WaitGlobalOperationRequest} WaitGlobalOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WaitGlobalOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.WaitGlobalOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 227560217:
                                    message.project = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a WaitGlobalOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.WaitGlobalOperationRequest} WaitGlobalOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        WaitGlobalOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a WaitGlobalOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        WaitGlobalOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.project != null && message.hasOwnProperty("project"))
                                if (!$util.isString(message.project))
                                    return "project: string expected";
                            return null;
                        };

                        /**
                         * Creates a WaitGlobalOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.WaitGlobalOperationRequest} WaitGlobalOperationRequest
                         */
                        WaitGlobalOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.WaitGlobalOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.WaitGlobalOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.project != null)
                                message.project = String(object.project);
                            return message;
                        };

                        /**
                         * Creates a plain object from a WaitGlobalOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.WaitGlobalOperationRequest} message WaitGlobalOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        WaitGlobalOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults) {
                                object.operation = "";
                                object.project = "";
                            }
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.project != null && message.hasOwnProperty("project"))
                                object.project = message.project;
                            return object;
                        };

                        /**
                         * Converts this WaitGlobalOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.WaitGlobalOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        WaitGlobalOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return WaitGlobalOperationRequest;
                    })();

                    v1.DeleteGlobalOrganizationOperationRequest = (function() {

                        /**
                         * Properties of a DeleteGlobalOrganizationOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteGlobalOrganizationOperationRequest
                         * @property {string|null} [operation] DeleteGlobalOrganizationOperationRequest operation
                         * @property {string|null} [parentId] DeleteGlobalOrganizationOperationRequest parentId
                         */

                        /**
                         * Constructs a new DeleteGlobalOrganizationOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteGlobalOrganizationOperationRequest.
                         * @implements IDeleteGlobalOrganizationOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationRequest=} [properties] Properties to set
                         */
                        function DeleteGlobalOrganizationOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * DeleteGlobalOrganizationOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @instance
                         */
                        DeleteGlobalOrganizationOperationRequest.prototype.operation = "";

                        /**
                         * DeleteGlobalOrganizationOperationRequest parentId.
                         * @member {string|null|undefined} parentId
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @instance
                         */
                        DeleteGlobalOrganizationOperationRequest.prototype.parentId = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * DeleteGlobalOrganizationOperationRequest _parentId.
                         * @member {"parentId"|undefined} _parentId
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @instance
                         */
                        Object.defineProperty(DeleteGlobalOrganizationOperationRequest.prototype, "_parentId", {
                            get: $util.oneOfGetter($oneOfFields = ["parentId"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new DeleteGlobalOrganizationOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest} DeleteGlobalOrganizationOperationRequest instance
                         */
                        DeleteGlobalOrganizationOperationRequest.create = function create(properties) {
                            return new DeleteGlobalOrganizationOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified DeleteGlobalOrganizationOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationRequest} message DeleteGlobalOrganizationOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOrganizationOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.parentId != null && Object.hasOwnProperty.call(message, "parentId"))
                                writer.uint32(/* id 459714768, wireType 2 =*/3677718146).string(message.parentId);
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteGlobalOrganizationOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationRequest} message DeleteGlobalOrganizationOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOrganizationOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteGlobalOrganizationOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest} DeleteGlobalOrganizationOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOrganizationOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 459714768:
                                    message.parentId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteGlobalOrganizationOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest} DeleteGlobalOrganizationOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOrganizationOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteGlobalOrganizationOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteGlobalOrganizationOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.parentId != null && message.hasOwnProperty("parentId")) {
                                properties._parentId = 1;
                                if (!$util.isString(message.parentId))
                                    return "parentId: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a DeleteGlobalOrganizationOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest} DeleteGlobalOrganizationOperationRequest
                         */
                        DeleteGlobalOrganizationOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.parentId != null)
                                message.parentId = String(object.parentId);
                            return message;
                        };

                        /**
                         * Creates a plain object from a DeleteGlobalOrganizationOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest} message DeleteGlobalOrganizationOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteGlobalOrganizationOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.operation = "";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.parentId != null && message.hasOwnProperty("parentId")) {
                                object.parentId = message.parentId;
                                if (options.oneofs)
                                    object._parentId = "parentId";
                            }
                            return object;
                        };

                        /**
                         * Converts this DeleteGlobalOrganizationOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteGlobalOrganizationOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteGlobalOrganizationOperationRequest;
                    })();

                    v1.DeleteGlobalOrganizationOperationResponse = (function() {

                        /**
                         * Properties of a DeleteGlobalOrganizationOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @interface IDeleteGlobalOrganizationOperationResponse
                         */

                        /**
                         * Constructs a new DeleteGlobalOrganizationOperationResponse.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a DeleteGlobalOrganizationOperationResponse.
                         * @implements IDeleteGlobalOrganizationOperationResponse
                         * @constructor
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationResponse=} [properties] Properties to set
                         */
                        function DeleteGlobalOrganizationOperationResponse(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * Creates a new DeleteGlobalOrganizationOperationResponse instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationResponse=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse} DeleteGlobalOrganizationOperationResponse instance
                         */
                        DeleteGlobalOrganizationOperationResponse.create = function create(properties) {
                            return new DeleteGlobalOrganizationOperationResponse(properties);
                        };

                        /**
                         * Encodes the specified DeleteGlobalOrganizationOperationResponse message. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationResponse} message DeleteGlobalOrganizationOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOrganizationOperationResponse.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            return writer;
                        };

                        /**
                         * Encodes the specified DeleteGlobalOrganizationOperationResponse message, length delimited. Does not implicitly {@link google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationResponse} message DeleteGlobalOrganizationOperationResponse message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        DeleteGlobalOrganizationOperationResponse.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a DeleteGlobalOrganizationOperationResponse message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse} DeleteGlobalOrganizationOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOrganizationOperationResponse.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a DeleteGlobalOrganizationOperationResponse message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse} DeleteGlobalOrganizationOperationResponse
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        DeleteGlobalOrganizationOperationResponse.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a DeleteGlobalOrganizationOperationResponse message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        DeleteGlobalOrganizationOperationResponse.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            return null;
                        };

                        /**
                         * Creates a DeleteGlobalOrganizationOperationResponse message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse} DeleteGlobalOrganizationOperationResponse
                         */
                        DeleteGlobalOrganizationOperationResponse.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse)
                                return object;
                            return new $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse();
                        };

                        /**
                         * Creates a plain object from a DeleteGlobalOrganizationOperationResponse message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @static
                         * @param {google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse} message DeleteGlobalOrganizationOperationResponse
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        DeleteGlobalOrganizationOperationResponse.toObject = function toObject() {
                            return {};
                        };

                        /**
                         * Converts this DeleteGlobalOrganizationOperationResponse to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        DeleteGlobalOrganizationOperationResponse.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return DeleteGlobalOrganizationOperationResponse;
                    })();

                    v1.GetGlobalOrganizationOperationRequest = (function() {

                        /**
                         * Properties of a GetGlobalOrganizationOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IGetGlobalOrganizationOperationRequest
                         * @property {string|null} [operation] GetGlobalOrganizationOperationRequest operation
                         * @property {string|null} [parentId] GetGlobalOrganizationOperationRequest parentId
                         */

                        /**
                         * Constructs a new GetGlobalOrganizationOperationRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a GetGlobalOrganizationOperationRequest.
                         * @implements IGetGlobalOrganizationOperationRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IGetGlobalOrganizationOperationRequest=} [properties] Properties to set
                         */
                        function GetGlobalOrganizationOperationRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * GetGlobalOrganizationOperationRequest operation.
                         * @member {string} operation
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @instance
                         */
                        GetGlobalOrganizationOperationRequest.prototype.operation = "";

                        /**
                         * GetGlobalOrganizationOperationRequest parentId.
                         * @member {string|null|undefined} parentId
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @instance
                         */
                        GetGlobalOrganizationOperationRequest.prototype.parentId = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * GetGlobalOrganizationOperationRequest _parentId.
                         * @member {"parentId"|undefined} _parentId
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @instance
                         */
                        Object.defineProperty(GetGlobalOrganizationOperationRequest.prototype, "_parentId", {
                            get: $util.oneOfGetter($oneOfFields = ["parentId"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new GetGlobalOrganizationOperationRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetGlobalOrganizationOperationRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.GetGlobalOrganizationOperationRequest} GetGlobalOrganizationOperationRequest instance
                         */
                        GetGlobalOrganizationOperationRequest.create = function create(properties) {
                            return new GetGlobalOrganizationOperationRequest(properties);
                        };

                        /**
                         * Encodes the specified GetGlobalOrganizationOperationRequest message. Does not implicitly {@link google.cloud.compute.v1.GetGlobalOrganizationOperationRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetGlobalOrganizationOperationRequest} message GetGlobalOrganizationOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetGlobalOrganizationOperationRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.operation != null && Object.hasOwnProperty.call(message, "operation"))
                                writer.uint32(/* id 52090215, wireType 2 =*/416721722).string(message.operation);
                            if (message.parentId != null && Object.hasOwnProperty.call(message, "parentId"))
                                writer.uint32(/* id 459714768, wireType 2 =*/3677718146).string(message.parentId);
                            return writer;
                        };

                        /**
                         * Encodes the specified GetGlobalOrganizationOperationRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.GetGlobalOrganizationOperationRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.IGetGlobalOrganizationOperationRequest} message GetGlobalOrganizationOperationRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        GetGlobalOrganizationOperationRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a GetGlobalOrganizationOperationRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.GetGlobalOrganizationOperationRequest} GetGlobalOrganizationOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetGlobalOrganizationOperationRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.GetGlobalOrganizationOperationRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 52090215:
                                    message.operation = reader.string();
                                    break;
                                case 459714768:
                                    message.parentId = reader.string();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a GetGlobalOrganizationOperationRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.GetGlobalOrganizationOperationRequest} GetGlobalOrganizationOperationRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        GetGlobalOrganizationOperationRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a GetGlobalOrganizationOperationRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        GetGlobalOrganizationOperationRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                if (!$util.isString(message.operation))
                                    return "operation: string expected";
                            if (message.parentId != null && message.hasOwnProperty("parentId")) {
                                properties._parentId = 1;
                                if (!$util.isString(message.parentId))
                                    return "parentId: string expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a GetGlobalOrganizationOperationRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.GetGlobalOrganizationOperationRequest} GetGlobalOrganizationOperationRequest
                         */
                        GetGlobalOrganizationOperationRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.GetGlobalOrganizationOperationRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.GetGlobalOrganizationOperationRequest();
                            if (object.operation != null)
                                message.operation = String(object.operation);
                            if (object.parentId != null)
                                message.parentId = String(object.parentId);
                            return message;
                        };

                        /**
                         * Creates a plain object from a GetGlobalOrganizationOperationRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @static
                         * @param {google.cloud.compute.v1.GetGlobalOrganizationOperationRequest} message GetGlobalOrganizationOperationRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        GetGlobalOrganizationOperationRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (options.defaults)
                                object.operation = "";
                            if (message.operation != null && message.hasOwnProperty("operation"))
                                object.operation = message.operation;
                            if (message.parentId != null && message.hasOwnProperty("parentId")) {
                                object.parentId = message.parentId;
                                if (options.oneofs)
                                    object._parentId = "parentId";
                            }
                            return object;
                        };

                        /**
                         * Converts this GetGlobalOrganizationOperationRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.GetGlobalOrganizationOperationRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        GetGlobalOrganizationOperationRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return GetGlobalOrganizationOperationRequest;
                    })();

                    v1.ListGlobalOrganizationOperationsRequest = (function() {

                        /**
                         * Properties of a ListGlobalOrganizationOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @interface IListGlobalOrganizationOperationsRequest
                         * @property {string|null} [filter] ListGlobalOrganizationOperationsRequest filter
                         * @property {number|null} [maxResults] ListGlobalOrganizationOperationsRequest maxResults
                         * @property {string|null} [orderBy] ListGlobalOrganizationOperationsRequest orderBy
                         * @property {string|null} [pageToken] ListGlobalOrganizationOperationsRequest pageToken
                         * @property {string|null} [parentId] ListGlobalOrganizationOperationsRequest parentId
                         * @property {boolean|null} [returnPartialSuccess] ListGlobalOrganizationOperationsRequest returnPartialSuccess
                         */

                        /**
                         * Constructs a new ListGlobalOrganizationOperationsRequest.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a ListGlobalOrganizationOperationsRequest.
                         * @implements IListGlobalOrganizationOperationsRequest
                         * @constructor
                         * @param {google.cloud.compute.v1.IListGlobalOrganizationOperationsRequest=} [properties] Properties to set
                         */
                        function ListGlobalOrganizationOperationsRequest(properties) {
                            if (properties)
                                for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                    if (properties[keys[i]] != null)
                                        this[keys[i]] = properties[keys[i]];
                        }

                        /**
                         * ListGlobalOrganizationOperationsRequest filter.
                         * @member {string|null|undefined} filter
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.filter = null;

                        /**
                         * ListGlobalOrganizationOperationsRequest maxResults.
                         * @member {number|null|undefined} maxResults
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.maxResults = null;

                        /**
                         * ListGlobalOrganizationOperationsRequest orderBy.
                         * @member {string|null|undefined} orderBy
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.orderBy = null;

                        /**
                         * ListGlobalOrganizationOperationsRequest pageToken.
                         * @member {string|null|undefined} pageToken
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.pageToken = null;

                        /**
                         * ListGlobalOrganizationOperationsRequest parentId.
                         * @member {string|null|undefined} parentId
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.parentId = null;

                        /**
                         * ListGlobalOrganizationOperationsRequest returnPartialSuccess.
                         * @member {boolean|null|undefined} returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.returnPartialSuccess = null;

                        // OneOf field names bound to virtual getters and setters
                        var $oneOfFields;

                        /**
                         * ListGlobalOrganizationOperationsRequest _filter.
                         * @member {"filter"|undefined} _filter
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOrganizationOperationsRequest.prototype, "_filter", {
                            get: $util.oneOfGetter($oneOfFields = ["filter"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOrganizationOperationsRequest _maxResults.
                         * @member {"maxResults"|undefined} _maxResults
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOrganizationOperationsRequest.prototype, "_maxResults", {
                            get: $util.oneOfGetter($oneOfFields = ["maxResults"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOrganizationOperationsRequest _orderBy.
                         * @member {"orderBy"|undefined} _orderBy
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOrganizationOperationsRequest.prototype, "_orderBy", {
                            get: $util.oneOfGetter($oneOfFields = ["orderBy"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOrganizationOperationsRequest _pageToken.
                         * @member {"pageToken"|undefined} _pageToken
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOrganizationOperationsRequest.prototype, "_pageToken", {
                            get: $util.oneOfGetter($oneOfFields = ["pageToken"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOrganizationOperationsRequest _parentId.
                         * @member {"parentId"|undefined} _parentId
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOrganizationOperationsRequest.prototype, "_parentId", {
                            get: $util.oneOfGetter($oneOfFields = ["parentId"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * ListGlobalOrganizationOperationsRequest _returnPartialSuccess.
                         * @member {"returnPartialSuccess"|undefined} _returnPartialSuccess
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         */
                        Object.defineProperty(ListGlobalOrganizationOperationsRequest.prototype, "_returnPartialSuccess", {
                            get: $util.oneOfGetter($oneOfFields = ["returnPartialSuccess"]),
                            set: $util.oneOfSetter($oneOfFields)
                        });

                        /**
                         * Creates a new ListGlobalOrganizationOperationsRequest instance using the specified properties.
                         * @function create
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListGlobalOrganizationOperationsRequest=} [properties] Properties to set
                         * @returns {google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest} ListGlobalOrganizationOperationsRequest instance
                         */
                        ListGlobalOrganizationOperationsRequest.create = function create(properties) {
                            return new ListGlobalOrganizationOperationsRequest(properties);
                        };

                        /**
                         * Encodes the specified ListGlobalOrganizationOperationsRequest message. Does not implicitly {@link google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest.verify|verify} messages.
                         * @function encode
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListGlobalOrganizationOperationsRequest} message ListGlobalOrganizationOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGlobalOrganizationOperationsRequest.encode = function encode(message, writer) {
                            if (!writer)
                                writer = $Writer.create();
                            if (message.pageToken != null && Object.hasOwnProperty.call(message, "pageToken"))
                                writer.uint32(/* id 19994697, wireType 2 =*/159957578).string(message.pageToken);
                            if (message.maxResults != null && Object.hasOwnProperty.call(message, "maxResults"))
                                writer.uint32(/* id 54715419, wireType 0 =*/437723352).uint32(message.maxResults);
                            if (message.orderBy != null && Object.hasOwnProperty.call(message, "orderBy"))
                                writer.uint32(/* id 160562920, wireType 2 =*/1284503362).string(message.orderBy);
                            if (message.filter != null && Object.hasOwnProperty.call(message, "filter"))
                                writer.uint32(/* id 336120696, wireType 2 =*/2688965570).string(message.filter);
                            if (message.parentId != null && Object.hasOwnProperty.call(message, "parentId"))
                                writer.uint32(/* id 459714768, wireType 2 =*/3677718146).string(message.parentId);
                            if (message.returnPartialSuccess != null && Object.hasOwnProperty.call(message, "returnPartialSuccess"))
                                writer.uint32(/* id 517198390, wireType 0 =*/4137587120).bool(message.returnPartialSuccess);
                            return writer;
                        };

                        /**
                         * Encodes the specified ListGlobalOrganizationOperationsRequest message, length delimited. Does not implicitly {@link google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest.verify|verify} messages.
                         * @function encodeDelimited
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.IListGlobalOrganizationOperationsRequest} message ListGlobalOrganizationOperationsRequest message or plain object to encode
                         * @param {$protobuf.Writer} [writer] Writer to encode to
                         * @returns {$protobuf.Writer} Writer
                         */
                        ListGlobalOrganizationOperationsRequest.encodeDelimited = function encodeDelimited(message, writer) {
                            return this.encode(message, writer).ldelim();
                        };

                        /**
                         * Decodes a ListGlobalOrganizationOperationsRequest message from the specified reader or buffer.
                         * @function decode
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @param {number} [length] Message length if known beforehand
                         * @returns {google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest} ListGlobalOrganizationOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGlobalOrganizationOperationsRequest.decode = function decode(reader, length) {
                            if (!(reader instanceof $Reader))
                                reader = $Reader.create(reader);
                            var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest();
                            while (reader.pos < end) {
                                var tag = reader.uint32();
                                switch (tag >>> 3) {
                                case 336120696:
                                    message.filter = reader.string();
                                    break;
                                case 54715419:
                                    message.maxResults = reader.uint32();
                                    break;
                                case 160562920:
                                    message.orderBy = reader.string();
                                    break;
                                case 19994697:
                                    message.pageToken = reader.string();
                                    break;
                                case 459714768:
                                    message.parentId = reader.string();
                                    break;
                                case 517198390:
                                    message.returnPartialSuccess = reader.bool();
                                    break;
                                default:
                                    reader.skipType(tag & 7);
                                    break;
                                }
                            }
                            return message;
                        };

                        /**
                         * Decodes a ListGlobalOrganizationOperationsRequest message from the specified reader or buffer, length delimited.
                         * @function decodeDelimited
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                         * @returns {google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest} ListGlobalOrganizationOperationsRequest
                         * @throws {Error} If the payload is not a reader or valid buffer
                         * @throws {$protobuf.util.ProtocolError} If required fields are missing
                         */
                        ListGlobalOrganizationOperationsRequest.decodeDelimited = function decodeDelimited(reader) {
                            if (!(reader instanceof $Reader))
                                reader = new $Reader(reader);
                            return this.decode(reader, reader.uint32());
                        };

                        /**
                         * Verifies a ListGlobalOrganizationOperationsRequest message.
                         * @function verify
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {Object.<string,*>} message Plain object to verify
                         * @returns {string|null} `null` if valid, otherwise the reason why it is not
                         */
                        ListGlobalOrganizationOperationsRequest.verify = function verify(message) {
                            if (typeof message !== "object" || message === null)
                                return "object expected";
                            var properties = {};
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                properties._filter = 1;
                                if (!$util.isString(message.filter))
                                    return "filter: string expected";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                properties._maxResults = 1;
                                if (!$util.isInteger(message.maxResults))
                                    return "maxResults: integer expected";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                properties._orderBy = 1;
                                if (!$util.isString(message.orderBy))
                                    return "orderBy: string expected";
                            }
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                properties._pageToken = 1;
                                if (!$util.isString(message.pageToken))
                                    return "pageToken: string expected";
                            }
                            if (message.parentId != null && message.hasOwnProperty("parentId")) {
                                properties._parentId = 1;
                                if (!$util.isString(message.parentId))
                                    return "parentId: string expected";
                            }
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                properties._returnPartialSuccess = 1;
                                if (typeof message.returnPartialSuccess !== "boolean")
                                    return "returnPartialSuccess: boolean expected";
                            }
                            return null;
                        };

                        /**
                         * Creates a ListGlobalOrganizationOperationsRequest message from a plain object. Also converts values to their respective internal types.
                         * @function fromObject
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {Object.<string,*>} object Plain object
                         * @returns {google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest} ListGlobalOrganizationOperationsRequest
                         */
                        ListGlobalOrganizationOperationsRequest.fromObject = function fromObject(object) {
                            if (object instanceof $root.google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest)
                                return object;
                            var message = new $root.google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest();
                            if (object.filter != null)
                                message.filter = String(object.filter);
                            if (object.maxResults != null)
                                message.maxResults = object.maxResults >>> 0;
                            if (object.orderBy != null)
                                message.orderBy = String(object.orderBy);
                            if (object.pageToken != null)
                                message.pageToken = String(object.pageToken);
                            if (object.parentId != null)
                                message.parentId = String(object.parentId);
                            if (object.returnPartialSuccess != null)
                                message.returnPartialSuccess = Boolean(object.returnPartialSuccess);
                            return message;
                        };

                        /**
                         * Creates a plain object from a ListGlobalOrganizationOperationsRequest message. Also converts values to other types if specified.
                         * @function toObject
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @static
                         * @param {google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest} message ListGlobalOrganizationOperationsRequest
                         * @param {$protobuf.IConversionOptions} [options] Conversion options
                         * @returns {Object.<string,*>} Plain object
                         */
                        ListGlobalOrganizationOperationsRequest.toObject = function toObject(message, options) {
                            if (!options)
                                options = {};
                            var object = {};
                            if (message.pageToken != null && message.hasOwnProperty("pageToken")) {
                                object.pageToken = message.pageToken;
                                if (options.oneofs)
                                    object._pageToken = "pageToken";
                            }
                            if (message.maxResults != null && message.hasOwnProperty("maxResults")) {
                                object.maxResults = message.maxResults;
                                if (options.oneofs)
                                    object._maxResults = "maxResults";
                            }
                            if (message.orderBy != null && message.hasOwnProperty("orderBy")) {
                                object.orderBy = message.orderBy;
                                if (options.oneofs)
                                    object._orderBy = "orderBy";
                            }
                            if (message.filter != null && message.hasOwnProperty("filter")) {
                                object.filter = message.filter;
                                if (options.oneofs)
                                    object._filter = "filter";
                            }
                            if (message.parentId != null && message.hasOwnProperty("parentId")) {
                                object.parentId = message.parentId;
                                if (options.oneofs)
                                    object._parentId = "parentId";
                            }
                            if (message.returnPartialSuccess != null && message.hasOwnProperty("returnPartialSuccess")) {
                                object.returnPartialSuccess = message.returnPartialSuccess;
                                if (options.oneofs)
                                    object._returnPartialSuccess = "returnPartialSuccess";
                            }
                            return object;
                        };

                        /**
                         * Converts this ListGlobalOrganizationOperationsRequest to JSON.
                         * @function toJSON
                         * @memberof google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest
                         * @instance
                         * @returns {Object.<string,*>} JSON object
                         */
                        ListGlobalOrganizationOperationsRequest.prototype.toJSON = function toJSON() {
                            return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                        };

                        return ListGlobalOrganizationOperationsRequest;
                    })();

                    v1.RegionOperations = (function() {

                        /**
                         * Constructs a new RegionOperations service.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a RegionOperations
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function RegionOperations(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (RegionOperations.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = RegionOperations;

                        /**
                         * Creates new RegionOperations service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {RegionOperations} RPC service. Useful where requests and/or responses are streamed.
                         */
                        RegionOperations.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.RegionOperations#delete_}.
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @typedef DeleteCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.DeleteRegionOperationResponse} [response] DeleteRegionOperationResponse
                         */

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationRequest} request DeleteRegionOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.RegionOperations.DeleteCallback} callback Node-style callback called with the error, if any, and DeleteRegionOperationResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(RegionOperations.prototype["delete"] = function delete_(request, callback) {
                            return this.rpcCall(delete_, $root.google.cloud.compute.v1.DeleteRegionOperationRequest, $root.google.cloud.compute.v1.DeleteRegionOperationResponse, request, callback);
                        }, "name", { value: "Delete" });

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteRegionOperationRequest} request DeleteRegionOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.DeleteRegionOperationResponse>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.RegionOperations#get}.
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @typedef GetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetRegionOperationRequest} request GetRegionOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.RegionOperations.GetCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(RegionOperations.prototype.get = function get(request, callback) {
                            return this.rpcCall(get, $root.google.cloud.compute.v1.GetRegionOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Get" });

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetRegionOperationRequest} request GetRegionOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.RegionOperations#list}.
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.OperationList} [response] OperationList
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListRegionOperationsRequest} request ListRegionOperationsRequest message or plain object
                         * @param {google.cloud.compute.v1.RegionOperations.ListCallback} callback Node-style callback called with the error, if any, and OperationList
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(RegionOperations.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.google.cloud.compute.v1.ListRegionOperationsRequest, $root.google.cloud.compute.v1.OperationList, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListRegionOperationsRequest} request ListRegionOperationsRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.OperationList>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.RegionOperations#wait}.
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @typedef WaitCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Wait.
                         * @function wait
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IWaitRegionOperationRequest} request WaitRegionOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.RegionOperations.WaitCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(RegionOperations.prototype.wait = function wait(request, callback) {
                            return this.rpcCall(wait, $root.google.cloud.compute.v1.WaitRegionOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Wait" });

                        /**
                         * Calls Wait.
                         * @function wait
                         * @memberof google.cloud.compute.v1.RegionOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IWaitRegionOperationRequest} request WaitRegionOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        return RegionOperations;
                    })();

                    v1.ZoneOperations = (function() {

                        /**
                         * Constructs a new ZoneOperations service.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a ZoneOperations
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function ZoneOperations(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (ZoneOperations.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = ZoneOperations;

                        /**
                         * Creates new ZoneOperations service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {ZoneOperations} RPC service. Useful where requests and/or responses are streamed.
                         */
                        ZoneOperations.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.ZoneOperations#delete_}.
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @typedef DeleteCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.DeleteZoneOperationResponse} [response] DeleteZoneOperationResponse
                         */

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationRequest} request DeleteZoneOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.ZoneOperations.DeleteCallback} callback Node-style callback called with the error, if any, and DeleteZoneOperationResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ZoneOperations.prototype["delete"] = function delete_(request, callback) {
                            return this.rpcCall(delete_, $root.google.cloud.compute.v1.DeleteZoneOperationRequest, $root.google.cloud.compute.v1.DeleteZoneOperationResponse, request, callback);
                        }, "name", { value: "Delete" });

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteZoneOperationRequest} request DeleteZoneOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.DeleteZoneOperationResponse>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.ZoneOperations#get}.
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @typedef GetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetZoneOperationRequest} request GetZoneOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.ZoneOperations.GetCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ZoneOperations.prototype.get = function get(request, callback) {
                            return this.rpcCall(get, $root.google.cloud.compute.v1.GetZoneOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Get" });

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetZoneOperationRequest} request GetZoneOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.ZoneOperations#list}.
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.OperationList} [response] OperationList
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListZoneOperationsRequest} request ListZoneOperationsRequest message or plain object
                         * @param {google.cloud.compute.v1.ZoneOperations.ListCallback} callback Node-style callback called with the error, if any, and OperationList
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ZoneOperations.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.google.cloud.compute.v1.ListZoneOperationsRequest, $root.google.cloud.compute.v1.OperationList, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListZoneOperationsRequest} request ListZoneOperationsRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.OperationList>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.ZoneOperations#wait}.
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @typedef WaitCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Wait.
                         * @function wait
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IWaitZoneOperationRequest} request WaitZoneOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.ZoneOperations.WaitCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(ZoneOperations.prototype.wait = function wait(request, callback) {
                            return this.rpcCall(wait, $root.google.cloud.compute.v1.WaitZoneOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Wait" });

                        /**
                         * Calls Wait.
                         * @function wait
                         * @memberof google.cloud.compute.v1.ZoneOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IWaitZoneOperationRequest} request WaitZoneOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        return ZoneOperations;
                    })();

                    v1.GlobalOperations = (function() {

                        /**
                         * Constructs a new GlobalOperations service.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a GlobalOperations
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function GlobalOperations(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (GlobalOperations.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = GlobalOperations;

                        /**
                         * Creates new GlobalOperations service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {GlobalOperations} RPC service. Useful where requests and/or responses are streamed.
                         */
                        GlobalOperations.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOperations#aggregatedList}.
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @typedef AggregatedListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.OperationAggregatedList} [response] OperationAggregatedList
                         */

                        /**
                         * Calls AggregatedList.
                         * @function aggregatedList
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IAggregatedListGlobalOperationsRequest} request AggregatedListGlobalOperationsRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOperations.AggregatedListCallback} callback Node-style callback called with the error, if any, and OperationAggregatedList
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOperations.prototype.aggregatedList = function aggregatedList(request, callback) {
                            return this.rpcCall(aggregatedList, $root.google.cloud.compute.v1.AggregatedListGlobalOperationsRequest, $root.google.cloud.compute.v1.OperationAggregatedList, request, callback);
                        }, "name", { value: "AggregatedList" });

                        /**
                         * Calls AggregatedList.
                         * @function aggregatedList
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IAggregatedListGlobalOperationsRequest} request AggregatedListGlobalOperationsRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.OperationAggregatedList>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOperations#delete_}.
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @typedef DeleteCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.DeleteGlobalOperationResponse} [response] DeleteGlobalOperationResponse
                         */

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationRequest} request DeleteGlobalOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOperations.DeleteCallback} callback Node-style callback called with the error, if any, and DeleteGlobalOperationResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOperations.prototype["delete"] = function delete_(request, callback) {
                            return this.rpcCall(delete_, $root.google.cloud.compute.v1.DeleteGlobalOperationRequest, $root.google.cloud.compute.v1.DeleteGlobalOperationResponse, request, callback);
                        }, "name", { value: "Delete" });

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteGlobalOperationRequest} request DeleteGlobalOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.DeleteGlobalOperationResponse>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOperations#get}.
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @typedef GetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetGlobalOperationRequest} request GetGlobalOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOperations.GetCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOperations.prototype.get = function get(request, callback) {
                            return this.rpcCall(get, $root.google.cloud.compute.v1.GetGlobalOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Get" });

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetGlobalOperationRequest} request GetGlobalOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOperations#list}.
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.OperationList} [response] OperationList
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListGlobalOperationsRequest} request ListGlobalOperationsRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOperations.ListCallback} callback Node-style callback called with the error, if any, and OperationList
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOperations.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.google.cloud.compute.v1.ListGlobalOperationsRequest, $root.google.cloud.compute.v1.OperationList, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListGlobalOperationsRequest} request ListGlobalOperationsRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.OperationList>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOperations#wait}.
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @typedef WaitCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Wait.
                         * @function wait
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IWaitGlobalOperationRequest} request WaitGlobalOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOperations.WaitCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOperations.prototype.wait = function wait(request, callback) {
                            return this.rpcCall(wait, $root.google.cloud.compute.v1.WaitGlobalOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Wait" });

                        /**
                         * Calls Wait.
                         * @function wait
                         * @memberof google.cloud.compute.v1.GlobalOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IWaitGlobalOperationRequest} request WaitGlobalOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        return GlobalOperations;
                    })();

                    v1.GlobalOrganizationOperations = (function() {

                        /**
                         * Constructs a new GlobalOrganizationOperations service.
                         * @memberof google.cloud.compute.v1
                         * @classdesc Represents a GlobalOrganizationOperations
                         * @extends $protobuf.rpc.Service
                         * @constructor
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         */
                        function GlobalOrganizationOperations(rpcImpl, requestDelimited, responseDelimited) {
                            $protobuf.rpc.Service.call(this, rpcImpl, requestDelimited, responseDelimited);
                        }

                        (GlobalOrganizationOperations.prototype = Object.create($protobuf.rpc.Service.prototype)).constructor = GlobalOrganizationOperations;

                        /**
                         * Creates new GlobalOrganizationOperations service using the specified rpc implementation.
                         * @function create
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @static
                         * @param {$protobuf.RPCImpl} rpcImpl RPC implementation
                         * @param {boolean} [requestDelimited=false] Whether requests are length-delimited
                         * @param {boolean} [responseDelimited=false] Whether responses are length-delimited
                         * @returns {GlobalOrganizationOperations} RPC service. Useful where requests and/or responses are streamed.
                         */
                        GlobalOrganizationOperations.create = function create(rpcImpl, requestDelimited, responseDelimited) {
                            return new this(rpcImpl, requestDelimited, responseDelimited);
                        };

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOrganizationOperations#delete_}.
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @typedef DeleteCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse} [response] DeleteGlobalOrganizationOperationResponse
                         */

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationRequest} request DeleteGlobalOrganizationOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOrganizationOperations.DeleteCallback} callback Node-style callback called with the error, if any, and DeleteGlobalOrganizationOperationResponse
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOrganizationOperations.prototype["delete"] = function delete_(request, callback) {
                            return this.rpcCall(delete_, $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationRequest, $root.google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse, request, callback);
                        }, "name", { value: "Delete" });

                        /**
                         * Calls Delete.
                         * @function delete
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IDeleteGlobalOrganizationOperationRequest} request DeleteGlobalOrganizationOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.DeleteGlobalOrganizationOperationResponse>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOrganizationOperations#get}.
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @typedef GetCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.Operation} [response] Operation
                         */

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetGlobalOrganizationOperationRequest} request GetGlobalOrganizationOperationRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOrganizationOperations.GetCallback} callback Node-style callback called with the error, if any, and Operation
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOrganizationOperations.prototype.get = function get(request, callback) {
                            return this.rpcCall(get, $root.google.cloud.compute.v1.GetGlobalOrganizationOperationRequest, $root.google.cloud.compute.v1.Operation, request, callback);
                        }, "name", { value: "Get" });

                        /**
                         * Calls Get.
                         * @function get
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IGetGlobalOrganizationOperationRequest} request GetGlobalOrganizationOperationRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.Operation>} Promise
                         * @variation 2
                         */

                        /**
                         * Callback as used by {@link google.cloud.compute.v1.GlobalOrganizationOperations#list}.
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @typedef ListCallback
                         * @type {function}
                         * @param {Error|null} error Error, if any
                         * @param {google.cloud.compute.v1.OperationList} [response] OperationList
                         */

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListGlobalOrganizationOperationsRequest} request ListGlobalOrganizationOperationsRequest message or plain object
                         * @param {google.cloud.compute.v1.GlobalOrganizationOperations.ListCallback} callback Node-style callback called with the error, if any, and OperationList
                         * @returns {undefined}
                         * @variation 1
                         */
                        Object.defineProperty(GlobalOrganizationOperations.prototype.list = function list(request, callback) {
                            return this.rpcCall(list, $root.google.cloud.compute.v1.ListGlobalOrganizationOperationsRequest, $root.google.cloud.compute.v1.OperationList, request, callback);
                        }, "name", { value: "List" });

                        /**
                         * Calls List.
                         * @function list
                         * @memberof google.cloud.compute.v1.GlobalOrganizationOperations
                         * @instance
                         * @param {google.cloud.compute.v1.IListGlobalOrganizationOperationsRequest} request ListGlobalOrganizationOperationsRequest message or plain object
                         * @returns {Promise<google.cloud.compute.v1.OperationList>} Promise
                         * @variation 2
                         */

                        return GlobalOrganizationOperations;
                    })();

                    return v1;
                })();

                return compute;
            })();

            return cloud;
        })();

        google.api = (function() {

            /**
             * Namespace api.
             * @memberof google
             * @namespace
             */
            var api = {};

            api.Http = (function() {

                /**
                 * Properties of a Http.
                 * @memberof google.api
                 * @interface IHttp
                 * @property {Array.<google.api.IHttpRule>|null} [rules] Http rules
                 * @property {boolean|null} [fullyDecodeReservedExpansion] Http fullyDecodeReservedExpansion
                 */

                /**
                 * Constructs a new Http.
                 * @memberof google.api
                 * @classdesc Represents a Http.
                 * @implements IHttp
                 * @constructor
                 * @param {google.api.IHttp=} [properties] Properties to set
                 */
                function Http(properties) {
                    this.rules = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * Http rules.
                 * @member {Array.<google.api.IHttpRule>} rules
                 * @memberof google.api.Http
                 * @instance
                 */
                Http.prototype.rules = $util.emptyArray;

                /**
                 * Http fullyDecodeReservedExpansion.
                 * @member {boolean} fullyDecodeReservedExpansion
                 * @memberof google.api.Http
                 * @instance
                 */
                Http.prototype.fullyDecodeReservedExpansion = false;

                /**
                 * Creates a new Http instance using the specified properties.
                 * @function create
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp=} [properties] Properties to set
                 * @returns {google.api.Http} Http instance
                 */
                Http.create = function create(properties) {
                    return new Http(properties);
                };

                /**
                 * Encodes the specified Http message. Does not implicitly {@link google.api.Http.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp} message Http message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Http.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.rules != null && message.rules.length)
                        for (var i = 0; i < message.rules.length; ++i)
                            $root.google.api.HttpRule.encode(message.rules[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    if (message.fullyDecodeReservedExpansion != null && Object.hasOwnProperty.call(message, "fullyDecodeReservedExpansion"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.fullyDecodeReservedExpansion);
                    return writer;
                };

                /**
                 * Encodes the specified Http message, length delimited. Does not implicitly {@link google.api.Http.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.IHttp} message Http message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                Http.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a Http message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.Http
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.Http} Http
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Http.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.Http();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.rules && message.rules.length))
                                message.rules = [];
                            message.rules.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
                            break;
                        case 2:
                            message.fullyDecodeReservedExpansion = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a Http message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.Http
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.Http} Http
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                Http.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a Http message.
                 * @function verify
                 * @memberof google.api.Http
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                Http.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.rules != null && message.hasOwnProperty("rules")) {
                        if (!Array.isArray(message.rules))
                            return "rules: array expected";
                        for (var i = 0; i < message.rules.length; ++i) {
                            var error = $root.google.api.HttpRule.verify(message.rules[i]);
                            if (error)
                                return "rules." + error;
                        }
                    }
                    if (message.fullyDecodeReservedExpansion != null && message.hasOwnProperty("fullyDecodeReservedExpansion"))
                        if (typeof message.fullyDecodeReservedExpansion !== "boolean")
                            return "fullyDecodeReservedExpansion: boolean expected";
                    return null;
                };

                /**
                 * Creates a Http message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.Http
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.Http} Http
                 */
                Http.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.Http)
                        return object;
                    var message = new $root.google.api.Http();
                    if (object.rules) {
                        if (!Array.isArray(object.rules))
                            throw TypeError(".google.api.Http.rules: array expected");
                        message.rules = [];
                        for (var i = 0; i < object.rules.length; ++i) {
                            if (typeof object.rules[i] !== "object")
                                throw TypeError(".google.api.Http.rules: object expected");
                            message.rules[i] = $root.google.api.HttpRule.fromObject(object.rules[i]);
                        }
                    }
                    if (object.fullyDecodeReservedExpansion != null)
                        message.fullyDecodeReservedExpansion = Boolean(object.fullyDecodeReservedExpansion);
                    return message;
                };

                /**
                 * Creates a plain object from a Http message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.Http
                 * @static
                 * @param {google.api.Http} message Http
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                Http.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.rules = [];
                    if (options.defaults)
                        object.fullyDecodeReservedExpansion = false;
                    if (message.rules && message.rules.length) {
                        object.rules = [];
                        for (var j = 0; j < message.rules.length; ++j)
                            object.rules[j] = $root.google.api.HttpRule.toObject(message.rules[j], options);
                    }
                    if (message.fullyDecodeReservedExpansion != null && message.hasOwnProperty("fullyDecodeReservedExpansion"))
                        object.fullyDecodeReservedExpansion = message.fullyDecodeReservedExpansion;
                    return object;
                };

                /**
                 * Converts this Http to JSON.
                 * @function toJSON
                 * @memberof google.api.Http
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                Http.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return Http;
            })();

            api.HttpRule = (function() {

                /**
                 * Properties of a HttpRule.
                 * @memberof google.api
                 * @interface IHttpRule
                 * @property {string|null} [selector] HttpRule selector
                 * @property {string|null} [get] HttpRule get
                 * @property {string|null} [put] HttpRule put
                 * @property {string|null} [post] HttpRule post
                 * @property {string|null} ["delete"] HttpRule delete
                 * @property {string|null} [patch] HttpRule patch
                 * @property {google.api.ICustomHttpPattern|null} [custom] HttpRule custom
                 * @property {string|null} [body] HttpRule body
                 * @property {string|null} [responseBody] HttpRule responseBody
                 * @property {Array.<google.api.IHttpRule>|null} [additionalBindings] HttpRule additionalBindings
                 */

                /**
                 * Constructs a new HttpRule.
                 * @memberof google.api
                 * @classdesc Represents a HttpRule.
                 * @implements IHttpRule
                 * @constructor
                 * @param {google.api.IHttpRule=} [properties] Properties to set
                 */
                function HttpRule(properties) {
                    this.additionalBindings = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * HttpRule selector.
                 * @member {string} selector
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.selector = "";

                /**
                 * HttpRule get.
                 * @member {string|null|undefined} get
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.get = null;

                /**
                 * HttpRule put.
                 * @member {string|null|undefined} put
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.put = null;

                /**
                 * HttpRule post.
                 * @member {string|null|undefined} post
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.post = null;

                /**
                 * HttpRule delete.
                 * @member {string|null|undefined} delete
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype["delete"] = null;

                /**
                 * HttpRule patch.
                 * @member {string|null|undefined} patch
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.patch = null;

                /**
                 * HttpRule custom.
                 * @member {google.api.ICustomHttpPattern|null|undefined} custom
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.custom = null;

                /**
                 * HttpRule body.
                 * @member {string} body
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.body = "";

                /**
                 * HttpRule responseBody.
                 * @member {string} responseBody
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.responseBody = "";

                /**
                 * HttpRule additionalBindings.
                 * @member {Array.<google.api.IHttpRule>} additionalBindings
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                HttpRule.prototype.additionalBindings = $util.emptyArray;

                // OneOf field names bound to virtual getters and setters
                var $oneOfFields;

                /**
                 * HttpRule pattern.
                 * @member {"get"|"put"|"post"|"delete"|"patch"|"custom"|undefined} pattern
                 * @memberof google.api.HttpRule
                 * @instance
                 */
                Object.defineProperty(HttpRule.prototype, "pattern", {
                    get: $util.oneOfGetter($oneOfFields = ["get", "put", "post", "delete", "patch", "custom"]),
                    set: $util.oneOfSetter($oneOfFields)
                });

                /**
                 * Creates a new HttpRule instance using the specified properties.
                 * @function create
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule=} [properties] Properties to set
                 * @returns {google.api.HttpRule} HttpRule instance
                 */
                HttpRule.create = function create(properties) {
                    return new HttpRule(properties);
                };

                /**
                 * Encodes the specified HttpRule message. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                HttpRule.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.selector != null && Object.hasOwnProperty.call(message, "selector"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.selector);
                    if (message.get != null && Object.hasOwnProperty.call(message, "get"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.get);
                    if (message.put != null && Object.hasOwnProperty.call(message, "put"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.put);
                    if (message.post != null && Object.hasOwnProperty.call(message, "post"))
                        writer.uint32(/* id 4, wireType 2 =*/34).string(message.post);
                    if (message["delete"] != null && Object.hasOwnProperty.call(message, "delete"))
                        writer.uint32(/* id 5, wireType 2 =*/42).string(message["delete"]);
                    if (message.patch != null && Object.hasOwnProperty.call(message, "patch"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.patch);
                    if (message.body != null && Object.hasOwnProperty.call(message, "body"))
                        writer.uint32(/* id 7, wireType 2 =*/58).string(message.body);
                    if (message.custom != null && Object.hasOwnProperty.call(message, "custom"))
                        $root.google.api.CustomHttpPattern.encode(message.custom, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.additionalBindings != null && message.additionalBindings.length)
                        for (var i = 0; i < message.additionalBindings.length; ++i)
                            $root.google.api.HttpRule.encode(message.additionalBindings[i], writer.uint32(/* id 11, wireType 2 =*/90).fork()).ldelim();
                    if (message.responseBody != null && Object.hasOwnProperty.call(message, "responseBody"))
                        writer.uint32(/* id 12, wireType 2 =*/98).string(message.responseBody);
                    return writer;
                };

                /**
                 * Encodes the specified HttpRule message, length delimited. Does not implicitly {@link google.api.HttpRule.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.IHttpRule} message HttpRule message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                HttpRule.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a HttpRule message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.HttpRule} HttpRule
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                HttpRule.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.HttpRule();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.selector = reader.string();
                            break;
                        case 2:
                            message.get = reader.string();
                            break;
                        case 3:
                            message.put = reader.string();
                            break;
                        case 4:
                            message.post = reader.string();
                            break;
                        case 5:
                            message["delete"] = reader.string();
                            break;
                        case 6:
                            message.patch = reader.string();
                            break;
                        case 8:
                            message.custom = $root.google.api.CustomHttpPattern.decode(reader, reader.uint32());
                            break;
                        case 7:
                            message.body = reader.string();
                            break;
                        case 12:
                            message.responseBody = reader.string();
                            break;
                        case 11:
                            if (!(message.additionalBindings && message.additionalBindings.length))
                                message.additionalBindings = [];
                            message.additionalBindings.push($root.google.api.HttpRule.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a HttpRule message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.HttpRule} HttpRule
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                HttpRule.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a HttpRule message.
                 * @function verify
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                HttpRule.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    var properties = {};
                    if (message.selector != null && message.hasOwnProperty("selector"))
                        if (!$util.isString(message.selector))
                            return "selector: string expected";
                    if (message.get != null && message.hasOwnProperty("get")) {
                        properties.pattern = 1;
                        if (!$util.isString(message.get))
                            return "get: string expected";
                    }
                    if (message.put != null && message.hasOwnProperty("put")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.put))
                            return "put: string expected";
                    }
                    if (message.post != null && message.hasOwnProperty("post")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.post))
                            return "post: string expected";
                    }
                    if (message["delete"] != null && message.hasOwnProperty("delete")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message["delete"]))
                            return "delete: string expected";
                    }
                    if (message.patch != null && message.hasOwnProperty("patch")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        if (!$util.isString(message.patch))
                            return "patch: string expected";
                    }
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        if (properties.pattern === 1)
                            return "pattern: multiple values";
                        properties.pattern = 1;
                        {
                            var error = $root.google.api.CustomHttpPattern.verify(message.custom);
                            if (error)
                                return "custom." + error;
                        }
                    }
                    if (message.body != null && message.hasOwnProperty("body"))
                        if (!$util.isString(message.body))
                            return "body: string expected";
                    if (message.responseBody != null && message.hasOwnProperty("responseBody"))
                        if (!$util.isString(message.responseBody))
                            return "responseBody: string expected";
                    if (message.additionalBindings != null && message.hasOwnProperty("additionalBindings")) {
                        if (!Array.isArray(message.additionalBindings))
                            return "additionalBindings: array expected";
                        for (var i = 0; i < message.additionalBindings.length; ++i) {
                            var error = $root.google.api.HttpRule.verify(message.additionalBindings[i]);
                            if (error)
                                return "additionalBindings." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a HttpRule message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.HttpRule} HttpRule
                 */
                HttpRule.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.HttpRule)
                        return object;
                    var message = new $root.google.api.HttpRule();
                    if (object.selector != null)
                        message.selector = String(object.selector);
                    if (object.get != null)
                        message.get = String(object.get);
                    if (object.put != null)
                        message.put = String(object.put);
                    if (object.post != null)
                        message.post = String(object.post);
                    if (object["delete"] != null)
                        message["delete"] = String(object["delete"]);
                    if (object.patch != null)
                        message.patch = String(object.patch);
                    if (object.custom != null) {
                        if (typeof object.custom !== "object")
                            throw TypeError(".google.api.HttpRule.custom: object expected");
                        message.custom = $root.google.api.CustomHttpPattern.fromObject(object.custom);
                    }
                    if (object.body != null)
                        message.body = String(object.body);
                    if (object.responseBody != null)
                        message.responseBody = String(object.responseBody);
                    if (object.additionalBindings) {
                        if (!Array.isArray(object.additionalBindings))
                            throw TypeError(".google.api.HttpRule.additionalBindings: array expected");
                        message.additionalBindings = [];
                        for (var i = 0; i < object.additionalBindings.length; ++i) {
                            if (typeof object.additionalBindings[i] !== "object")
                                throw TypeError(".google.api.HttpRule.additionalBindings: object expected");
                            message.additionalBindings[i] = $root.google.api.HttpRule.fromObject(object.additionalBindings[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a HttpRule message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.HttpRule
                 * @static
                 * @param {google.api.HttpRule} message HttpRule
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                HttpRule.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.additionalBindings = [];
                    if (options.defaults) {
                        object.selector = "";
                        object.body = "";
                        object.responseBody = "";
                    }
                    if (message.selector != null && message.hasOwnProperty("selector"))
                        object.selector = message.selector;
                    if (message.get != null && message.hasOwnProperty("get")) {
                        object.get = message.get;
                        if (options.oneofs)
                            object.pattern = "get";
                    }
                    if (message.put != null && message.hasOwnProperty("put")) {
                        object.put = message.put;
                        if (options.oneofs)
                            object.pattern = "put";
                    }
                    if (message.post != null && message.hasOwnProperty("post")) {
                        object.post = message.post;
                        if (options.oneofs)
                            object.pattern = "post";
                    }
                    if (message["delete"] != null && message.hasOwnProperty("delete")) {
                        object["delete"] = message["delete"];
                        if (options.oneofs)
                            object.pattern = "delete";
                    }
                    if (message.patch != null && message.hasOwnProperty("patch")) {
                        object.patch = message.patch;
                        if (options.oneofs)
                            object.pattern = "patch";
                    }
                    if (message.body != null && message.hasOwnProperty("body"))
                        object.body = message.body;
                    if (message.custom != null && message.hasOwnProperty("custom")) {
                        object.custom = $root.google.api.CustomHttpPattern.toObject(message.custom, options);
                        if (options.oneofs)
                            object.pattern = "custom";
                    }
                    if (message.additionalBindings && message.additionalBindings.length) {
                        object.additionalBindings = [];
                        for (var j = 0; j < message.additionalBindings.length; ++j)
                            object.additionalBindings[j] = $root.google.api.HttpRule.toObject(message.additionalBindings[j], options);
                    }
                    if (message.responseBody != null && message.hasOwnProperty("responseBody"))
                        object.responseBody = message.responseBody;
                    return object;
                };

                /**
                 * Converts this HttpRule to JSON.
                 * @function toJSON
                 * @memberof google.api.HttpRule
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                HttpRule.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return HttpRule;
            })();

            api.CustomHttpPattern = (function() {

                /**
                 * Properties of a CustomHttpPattern.
                 * @memberof google.api
                 * @interface ICustomHttpPattern
                 * @property {string|null} [kind] CustomHttpPattern kind
                 * @property {string|null} [path] CustomHttpPattern path
                 */

                /**
                 * Constructs a new CustomHttpPattern.
                 * @memberof google.api
                 * @classdesc Represents a CustomHttpPattern.
                 * @implements ICustomHttpPattern
                 * @constructor
                 * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
                 */
                function CustomHttpPattern(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * CustomHttpPattern kind.
                 * @member {string} kind
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 */
                CustomHttpPattern.prototype.kind = "";

                /**
                 * CustomHttpPattern path.
                 * @member {string} path
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 */
                CustomHttpPattern.prototype.path = "";

                /**
                 * Creates a new CustomHttpPattern instance using the specified properties.
                 * @function create
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern=} [properties] Properties to set
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern instance
                 */
                CustomHttpPattern.create = function create(properties) {
                    return new CustomHttpPattern(properties);
                };

                /**
                 * Encodes the specified CustomHttpPattern message. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
                 * @function encode
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CustomHttpPattern.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.kind != null && Object.hasOwnProperty.call(message, "kind"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.kind);
                    if (message.path != null && Object.hasOwnProperty.call(message, "path"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.path);
                    return writer;
                };

                /**
                 * Encodes the specified CustomHttpPattern message, length delimited. Does not implicitly {@link google.api.CustomHttpPattern.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.ICustomHttpPattern} message CustomHttpPattern message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                CustomHttpPattern.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a CustomHttpPattern message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CustomHttpPattern.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.api.CustomHttpPattern();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.kind = reader.string();
                            break;
                        case 2:
                            message.path = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a CustomHttpPattern message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                CustomHttpPattern.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a CustomHttpPattern message.
                 * @function verify
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                CustomHttpPattern.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        if (!$util.isString(message.kind))
                            return "kind: string expected";
                    if (message.path != null && message.hasOwnProperty("path"))
                        if (!$util.isString(message.path))
                            return "path: string expected";
                    return null;
                };

                /**
                 * Creates a CustomHttpPattern message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.api.CustomHttpPattern} CustomHttpPattern
                 */
                CustomHttpPattern.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.api.CustomHttpPattern)
                        return object;
                    var message = new $root.google.api.CustomHttpPattern();
                    if (object.kind != null)
                        message.kind = String(object.kind);
                    if (object.path != null)
                        message.path = String(object.path);
                    return message;
                };

                /**
                 * Creates a plain object from a CustomHttpPattern message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.api.CustomHttpPattern
                 * @static
                 * @param {google.api.CustomHttpPattern} message CustomHttpPattern
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                CustomHttpPattern.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.kind = "";
                        object.path = "";
                    }
                    if (message.kind != null && message.hasOwnProperty("kind"))
                        object.kind = message.kind;
                    if (message.path != null && message.hasOwnProperty("path"))
                        object.path = message.path;
                    return object;
                };

                /**
                 * Converts this CustomHttpPattern to JSON.
                 * @function toJSON
                 * @memberof google.api.CustomHttpPattern
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                CustomHttpPattern.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return CustomHttpPattern;
            })();

            return api;
        })();

        google.protobuf = (function() {

            /**
             * Namespace protobuf.
             * @memberof google
             * @namespace
             */
            var protobuf = {};

            protobuf.FileDescriptorSet = (function() {

                /**
                 * Properties of a FileDescriptorSet.
                 * @memberof google.protobuf
                 * @interface IFileDescriptorSet
                 * @property {Array.<google.protobuf.IFileDescriptorProto>|null} [file] FileDescriptorSet file
                 */

                /**
                 * Constructs a new FileDescriptorSet.
                 * @memberof google.protobuf
                 * @classdesc Represents a FileDescriptorSet.
                 * @implements IFileDescriptorSet
                 * @constructor
                 * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
                 */
                function FileDescriptorSet(properties) {
                    this.file = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * FileDescriptorSet file.
                 * @member {Array.<google.protobuf.IFileDescriptorProto>} file
                 * @memberof google.protobuf.FileDescriptorSet
                 * @instance
                 */
                FileDescriptorSet.prototype.file = $util.emptyArray;

                /**
                 * Creates a new FileDescriptorSet instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.IFileDescriptorSet=} [properties] Properties to set
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet instance
                 */
                FileDescriptorSet.create = function create(properties) {
                    return new FileDescriptorSet(properties);
                };

                /**
                 * Encodes the specified FileDescriptorSet message. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorSet.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.file != null && message.file.length)
                        for (var i = 0; i < message.file.length; ++i)
                            $root.google.protobuf.FileDescriptorProto.encode(message.file[i], writer.uint32(/* id 1, wireType 2 =*/10).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified FileDescriptorSet message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorSet.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.IFileDescriptorSet} message FileDescriptorSet message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorSet.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a FileDescriptorSet message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorSet.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorSet();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            if (!(message.file && message.file.length))
                                message.file = [];
                            message.file.push($root.google.protobuf.FileDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a FileDescriptorSet message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorSet.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a FileDescriptorSet message.
                 * @function verify
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FileDescriptorSet.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.file != null && message.hasOwnProperty("file")) {
                        if (!Array.isArray(message.file))
                            return "file: array expected";
                        for (var i = 0; i < message.file.length; ++i) {
                            var error = $root.google.protobuf.FileDescriptorProto.verify(message.file[i]);
                            if (error)
                                return "file." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a FileDescriptorSet message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FileDescriptorSet} FileDescriptorSet
                 */
                FileDescriptorSet.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FileDescriptorSet)
                        return object;
                    var message = new $root.google.protobuf.FileDescriptorSet();
                    if (object.file) {
                        if (!Array.isArray(object.file))
                            throw TypeError(".google.protobuf.FileDescriptorSet.file: array expected");
                        message.file = [];
                        for (var i = 0; i < object.file.length; ++i) {
                            if (typeof object.file[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorSet.file: object expected");
                            message.file[i] = $root.google.protobuf.FileDescriptorProto.fromObject(object.file[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a FileDescriptorSet message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FileDescriptorSet
                 * @static
                 * @param {google.protobuf.FileDescriptorSet} message FileDescriptorSet
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FileDescriptorSet.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.file = [];
                    if (message.file && message.file.length) {
                        object.file = [];
                        for (var j = 0; j < message.file.length; ++j)
                            object.file[j] = $root.google.protobuf.FileDescriptorProto.toObject(message.file[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this FileDescriptorSet to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FileDescriptorSet
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FileDescriptorSet.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return FileDescriptorSet;
            })();

            protobuf.FileDescriptorProto = (function() {

                /**
                 * Properties of a FileDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IFileDescriptorProto
                 * @property {string|null} [name] FileDescriptorProto name
                 * @property {string|null} ["package"] FileDescriptorProto package
                 * @property {Array.<string>|null} [dependency] FileDescriptorProto dependency
                 * @property {Array.<number>|null} [publicDependency] FileDescriptorProto publicDependency
                 * @property {Array.<number>|null} [weakDependency] FileDescriptorProto weakDependency
                 * @property {Array.<google.protobuf.IDescriptorProto>|null} [messageType] FileDescriptorProto messageType
                 * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] FileDescriptorProto enumType
                 * @property {Array.<google.protobuf.IServiceDescriptorProto>|null} [service] FileDescriptorProto service
                 * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] FileDescriptorProto extension
                 * @property {google.protobuf.IFileOptions|null} [options] FileDescriptorProto options
                 * @property {google.protobuf.ISourceCodeInfo|null} [sourceCodeInfo] FileDescriptorProto sourceCodeInfo
                 * @property {string|null} [syntax] FileDescriptorProto syntax
                 */

                /**
                 * Constructs a new FileDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a FileDescriptorProto.
                 * @implements IFileDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
                 */
                function FileDescriptorProto(properties) {
                    this.dependency = [];
                    this.publicDependency = [];
                    this.weakDependency = [];
                    this.messageType = [];
                    this.enumType = [];
                    this.service = [];
                    this.extension = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * FileDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.name = "";

                /**
                 * FileDescriptorProto package.
                 * @member {string} package
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype["package"] = "";

                /**
                 * FileDescriptorProto dependency.
                 * @member {Array.<string>} dependency
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.dependency = $util.emptyArray;

                /**
                 * FileDescriptorProto publicDependency.
                 * @member {Array.<number>} publicDependency
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.publicDependency = $util.emptyArray;

                /**
                 * FileDescriptorProto weakDependency.
                 * @member {Array.<number>} weakDependency
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.weakDependency = $util.emptyArray;

                /**
                 * FileDescriptorProto messageType.
                 * @member {Array.<google.protobuf.IDescriptorProto>} messageType
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.messageType = $util.emptyArray;

                /**
                 * FileDescriptorProto enumType.
                 * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.enumType = $util.emptyArray;

                /**
                 * FileDescriptorProto service.
                 * @member {Array.<google.protobuf.IServiceDescriptorProto>} service
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.service = $util.emptyArray;

                /**
                 * FileDescriptorProto extension.
                 * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.extension = $util.emptyArray;

                /**
                 * FileDescriptorProto options.
                 * @member {google.protobuf.IFileOptions|null|undefined} options
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.options = null;

                /**
                 * FileDescriptorProto sourceCodeInfo.
                 * @member {google.protobuf.ISourceCodeInfo|null|undefined} sourceCodeInfo
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.sourceCodeInfo = null;

                /**
                 * FileDescriptorProto syntax.
                 * @member {string} syntax
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 */
                FileDescriptorProto.prototype.syntax = "";

                /**
                 * Creates a new FileDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.IFileDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto instance
                 */
                FileDescriptorProto.create = function create(properties) {
                    return new FileDescriptorProto(properties);
                };

                /**
                 * Encodes the specified FileDescriptorProto message. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message["package"] != null && Object.hasOwnProperty.call(message, "package"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message["package"]);
                    if (message.dependency != null && message.dependency.length)
                        for (var i = 0; i < message.dependency.length; ++i)
                            writer.uint32(/* id 3, wireType 2 =*/26).string(message.dependency[i]);
                    if (message.messageType != null && message.messageType.length)
                        for (var i = 0; i < message.messageType.length; ++i)
                            $root.google.protobuf.DescriptorProto.encode(message.messageType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.enumType != null && message.enumType.length)
                        for (var i = 0; i < message.enumType.length; ++i)
                            $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.service != null && message.service.length)
                        for (var i = 0; i < message.service.length; ++i)
                            $root.google.protobuf.ServiceDescriptorProto.encode(message.service[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.extension != null && message.extension.length)
                        for (var i = 0; i < message.extension.length; ++i)
                            $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.FileOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.sourceCodeInfo != null && Object.hasOwnProperty.call(message, "sourceCodeInfo"))
                        $root.google.protobuf.SourceCodeInfo.encode(message.sourceCodeInfo, writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.publicDependency != null && message.publicDependency.length)
                        for (var i = 0; i < message.publicDependency.length; ++i)
                            writer.uint32(/* id 10, wireType 0 =*/80).int32(message.publicDependency[i]);
                    if (message.weakDependency != null && message.weakDependency.length)
                        for (var i = 0; i < message.weakDependency.length; ++i)
                            writer.uint32(/* id 11, wireType 0 =*/88).int32(message.weakDependency[i]);
                    if (message.syntax != null && Object.hasOwnProperty.call(message, "syntax"))
                        writer.uint32(/* id 12, wireType 2 =*/98).string(message.syntax);
                    return writer;
                };

                /**
                 * Encodes the specified FileDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FileDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.IFileDescriptorProto} message FileDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a FileDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message["package"] = reader.string();
                            break;
                        case 3:
                            if (!(message.dependency && message.dependency.length))
                                message.dependency = [];
                            message.dependency.push(reader.string());
                            break;
                        case 10:
                            if (!(message.publicDependency && message.publicDependency.length))
                                message.publicDependency = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.publicDependency.push(reader.int32());
                            } else
                                message.publicDependency.push(reader.int32());
                            break;
                        case 11:
                            if (!(message.weakDependency && message.weakDependency.length))
                                message.weakDependency = [];
                            if ((tag & 7) === 2) {
                                var end2 = reader.uint32() + reader.pos;
                                while (reader.pos < end2)
                                    message.weakDependency.push(reader.int32());
                            } else
                                message.weakDependency.push(reader.int32());
                            break;
                        case 4:
                            if (!(message.messageType && message.messageType.length))
                                message.messageType = [];
                            message.messageType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.enumType && message.enumType.length))
                                message.enumType = [];
                            message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            if (!(message.service && message.service.length))
                                message.service = [];
                            message.service.push($root.google.protobuf.ServiceDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 7:
                            if (!(message.extension && message.extension.length))
                                message.extension = [];
                            message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 8:
                            message.options = $root.google.protobuf.FileOptions.decode(reader, reader.uint32());
                            break;
                        case 9:
                            message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.decode(reader, reader.uint32());
                            break;
                        case 12:
                            message.syntax = reader.string();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a FileDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a FileDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FileDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message["package"] != null && message.hasOwnProperty("package"))
                        if (!$util.isString(message["package"]))
                            return "package: string expected";
                    if (message.dependency != null && message.hasOwnProperty("dependency")) {
                        if (!Array.isArray(message.dependency))
                            return "dependency: array expected";
                        for (var i = 0; i < message.dependency.length; ++i)
                            if (!$util.isString(message.dependency[i]))
                                return "dependency: string[] expected";
                    }
                    if (message.publicDependency != null && message.hasOwnProperty("publicDependency")) {
                        if (!Array.isArray(message.publicDependency))
                            return "publicDependency: array expected";
                        for (var i = 0; i < message.publicDependency.length; ++i)
                            if (!$util.isInteger(message.publicDependency[i]))
                                return "publicDependency: integer[] expected";
                    }
                    if (message.weakDependency != null && message.hasOwnProperty("weakDependency")) {
                        if (!Array.isArray(message.weakDependency))
                            return "weakDependency: array expected";
                        for (var i = 0; i < message.weakDependency.length; ++i)
                            if (!$util.isInteger(message.weakDependency[i]))
                                return "weakDependency: integer[] expected";
                    }
                    if (message.messageType != null && message.hasOwnProperty("messageType")) {
                        if (!Array.isArray(message.messageType))
                            return "messageType: array expected";
                        for (var i = 0; i < message.messageType.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.verify(message.messageType[i]);
                            if (error)
                                return "messageType." + error;
                        }
                    }
                    if (message.enumType != null && message.hasOwnProperty("enumType")) {
                        if (!Array.isArray(message.enumType))
                            return "enumType: array expected";
                        for (var i = 0; i < message.enumType.length; ++i) {
                            var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
                            if (error)
                                return "enumType." + error;
                        }
                    }
                    if (message.service != null && message.hasOwnProperty("service")) {
                        if (!Array.isArray(message.service))
                            return "service: array expected";
                        for (var i = 0; i < message.service.length; ++i) {
                            var error = $root.google.protobuf.ServiceDescriptorProto.verify(message.service[i]);
                            if (error)
                                return "service." + error;
                        }
                    }
                    if (message.extension != null && message.hasOwnProperty("extension")) {
                        if (!Array.isArray(message.extension))
                            return "extension: array expected";
                        for (var i = 0; i < message.extension.length; ++i) {
                            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
                            if (error)
                                return "extension." + error;
                        }
                    }
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.FileOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo")) {
                        var error = $root.google.protobuf.SourceCodeInfo.verify(message.sourceCodeInfo);
                        if (error)
                            return "sourceCodeInfo." + error;
                    }
                    if (message.syntax != null && message.hasOwnProperty("syntax"))
                        if (!$util.isString(message.syntax))
                            return "syntax: string expected";
                    return null;
                };

                /**
                 * Creates a FileDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FileDescriptorProto} FileDescriptorProto
                 */
                FileDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FileDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.FileDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object["package"] != null)
                        message["package"] = String(object["package"]);
                    if (object.dependency) {
                        if (!Array.isArray(object.dependency))
                            throw TypeError(".google.protobuf.FileDescriptorProto.dependency: array expected");
                        message.dependency = [];
                        for (var i = 0; i < object.dependency.length; ++i)
                            message.dependency[i] = String(object.dependency[i]);
                    }
                    if (object.publicDependency) {
                        if (!Array.isArray(object.publicDependency))
                            throw TypeError(".google.protobuf.FileDescriptorProto.publicDependency: array expected");
                        message.publicDependency = [];
                        for (var i = 0; i < object.publicDependency.length; ++i)
                            message.publicDependency[i] = object.publicDependency[i] | 0;
                    }
                    if (object.weakDependency) {
                        if (!Array.isArray(object.weakDependency))
                            throw TypeError(".google.protobuf.FileDescriptorProto.weakDependency: array expected");
                        message.weakDependency = [];
                        for (var i = 0; i < object.weakDependency.length; ++i)
                            message.weakDependency[i] = object.weakDependency[i] | 0;
                    }
                    if (object.messageType) {
                        if (!Array.isArray(object.messageType))
                            throw TypeError(".google.protobuf.FileDescriptorProto.messageType: array expected");
                        message.messageType = [];
                        for (var i = 0; i < object.messageType.length; ++i) {
                            if (typeof object.messageType[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.messageType: object expected");
                            message.messageType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.messageType[i]);
                        }
                    }
                    if (object.enumType) {
                        if (!Array.isArray(object.enumType))
                            throw TypeError(".google.protobuf.FileDescriptorProto.enumType: array expected");
                        message.enumType = [];
                        for (var i = 0; i < object.enumType.length; ++i) {
                            if (typeof object.enumType[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.enumType: object expected");
                            message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
                        }
                    }
                    if (object.service) {
                        if (!Array.isArray(object.service))
                            throw TypeError(".google.protobuf.FileDescriptorProto.service: array expected");
                        message.service = [];
                        for (var i = 0; i < object.service.length; ++i) {
                            if (typeof object.service[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.service: object expected");
                            message.service[i] = $root.google.protobuf.ServiceDescriptorProto.fromObject(object.service[i]);
                        }
                    }
                    if (object.extension) {
                        if (!Array.isArray(object.extension))
                            throw TypeError(".google.protobuf.FileDescriptorProto.extension: array expected");
                        message.extension = [];
                        for (var i = 0; i < object.extension.length; ++i) {
                            if (typeof object.extension[i] !== "object")
                                throw TypeError(".google.protobuf.FileDescriptorProto.extension: object expected");
                            message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
                        }
                    }
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.FileOptions.fromObject(object.options);
                    }
                    if (object.sourceCodeInfo != null) {
                        if (typeof object.sourceCodeInfo !== "object")
                            throw TypeError(".google.protobuf.FileDescriptorProto.sourceCodeInfo: object expected");
                        message.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.fromObject(object.sourceCodeInfo);
                    }
                    if (object.syntax != null)
                        message.syntax = String(object.syntax);
                    return message;
                };

                /**
                 * Creates a plain object from a FileDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FileDescriptorProto
                 * @static
                 * @param {google.protobuf.FileDescriptorProto} message FileDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FileDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.dependency = [];
                        object.messageType = [];
                        object.enumType = [];
                        object.service = [];
                        object.extension = [];
                        object.publicDependency = [];
                        object.weakDependency = [];
                    }
                    if (options.defaults) {
                        object.name = "";
                        object["package"] = "";
                        object.options = null;
                        object.sourceCodeInfo = null;
                        object.syntax = "";
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message["package"] != null && message.hasOwnProperty("package"))
                        object["package"] = message["package"];
                    if (message.dependency && message.dependency.length) {
                        object.dependency = [];
                        for (var j = 0; j < message.dependency.length; ++j)
                            object.dependency[j] = message.dependency[j];
                    }
                    if (message.messageType && message.messageType.length) {
                        object.messageType = [];
                        for (var j = 0; j < message.messageType.length; ++j)
                            object.messageType[j] = $root.google.protobuf.DescriptorProto.toObject(message.messageType[j], options);
                    }
                    if (message.enumType && message.enumType.length) {
                        object.enumType = [];
                        for (var j = 0; j < message.enumType.length; ++j)
                            object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
                    }
                    if (message.service && message.service.length) {
                        object.service = [];
                        for (var j = 0; j < message.service.length; ++j)
                            object.service[j] = $root.google.protobuf.ServiceDescriptorProto.toObject(message.service[j], options);
                    }
                    if (message.extension && message.extension.length) {
                        object.extension = [];
                        for (var j = 0; j < message.extension.length; ++j)
                            object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
                    }
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.FileOptions.toObject(message.options, options);
                    if (message.sourceCodeInfo != null && message.hasOwnProperty("sourceCodeInfo"))
                        object.sourceCodeInfo = $root.google.protobuf.SourceCodeInfo.toObject(message.sourceCodeInfo, options);
                    if (message.publicDependency && message.publicDependency.length) {
                        object.publicDependency = [];
                        for (var j = 0; j < message.publicDependency.length; ++j)
                            object.publicDependency[j] = message.publicDependency[j];
                    }
                    if (message.weakDependency && message.weakDependency.length) {
                        object.weakDependency = [];
                        for (var j = 0; j < message.weakDependency.length; ++j)
                            object.weakDependency[j] = message.weakDependency[j];
                    }
                    if (message.syntax != null && message.hasOwnProperty("syntax"))
                        object.syntax = message.syntax;
                    return object;
                };

                /**
                 * Converts this FileDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FileDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FileDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return FileDescriptorProto;
            })();

            protobuf.DescriptorProto = (function() {

                /**
                 * Properties of a DescriptorProto.
                 * @memberof google.protobuf
                 * @interface IDescriptorProto
                 * @property {string|null} [name] DescriptorProto name
                 * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [field] DescriptorProto field
                 * @property {Array.<google.protobuf.IFieldDescriptorProto>|null} [extension] DescriptorProto extension
                 * @property {Array.<google.protobuf.IDescriptorProto>|null} [nestedType] DescriptorProto nestedType
                 * @property {Array.<google.protobuf.IEnumDescriptorProto>|null} [enumType] DescriptorProto enumType
                 * @property {Array.<google.protobuf.DescriptorProto.IExtensionRange>|null} [extensionRange] DescriptorProto extensionRange
                 * @property {Array.<google.protobuf.IOneofDescriptorProto>|null} [oneofDecl] DescriptorProto oneofDecl
                 * @property {google.protobuf.IMessageOptions|null} [options] DescriptorProto options
                 * @property {Array.<google.protobuf.DescriptorProto.IReservedRange>|null} [reservedRange] DescriptorProto reservedRange
                 * @property {Array.<string>|null} [reservedName] DescriptorProto reservedName
                 */

                /**
                 * Constructs a new DescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a DescriptorProto.
                 * @implements IDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
                 */
                function DescriptorProto(properties) {
                    this.field = [];
                    this.extension = [];
                    this.nestedType = [];
                    this.enumType = [];
                    this.extensionRange = [];
                    this.oneofDecl = [];
                    this.reservedRange = [];
                    this.reservedName = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * DescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.name = "";

                /**
                 * DescriptorProto field.
                 * @member {Array.<google.protobuf.IFieldDescriptorProto>} field
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.field = $util.emptyArray;

                /**
                 * DescriptorProto extension.
                 * @member {Array.<google.protobuf.IFieldDescriptorProto>} extension
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.extension = $util.emptyArray;

                /**
                 * DescriptorProto nestedType.
                 * @member {Array.<google.protobuf.IDescriptorProto>} nestedType
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.nestedType = $util.emptyArray;

                /**
                 * DescriptorProto enumType.
                 * @member {Array.<google.protobuf.IEnumDescriptorProto>} enumType
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.enumType = $util.emptyArray;

                /**
                 * DescriptorProto extensionRange.
                 * @member {Array.<google.protobuf.DescriptorProto.IExtensionRange>} extensionRange
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.extensionRange = $util.emptyArray;

                /**
                 * DescriptorProto oneofDecl.
                 * @member {Array.<google.protobuf.IOneofDescriptorProto>} oneofDecl
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.oneofDecl = $util.emptyArray;

                /**
                 * DescriptorProto options.
                 * @member {google.protobuf.IMessageOptions|null|undefined} options
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.options = null;

                /**
                 * DescriptorProto reservedRange.
                 * @member {Array.<google.protobuf.DescriptorProto.IReservedRange>} reservedRange
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.reservedRange = $util.emptyArray;

                /**
                 * DescriptorProto reservedName.
                 * @member {Array.<string>} reservedName
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 */
                DescriptorProto.prototype.reservedName = $util.emptyArray;

                /**
                 * Creates a new DescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.IDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto instance
                 */
                DescriptorProto.create = function create(properties) {
                    return new DescriptorProto(properties);
                };

                /**
                 * Encodes the specified DescriptorProto message. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                DescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.field != null && message.field.length)
                        for (var i = 0; i < message.field.length; ++i)
                            $root.google.protobuf.FieldDescriptorProto.encode(message.field[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.nestedType != null && message.nestedType.length)
                        for (var i = 0; i < message.nestedType.length; ++i)
                            $root.google.protobuf.DescriptorProto.encode(message.nestedType[i], writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.enumType != null && message.enumType.length)
                        for (var i = 0; i < message.enumType.length; ++i)
                            $root.google.protobuf.EnumDescriptorProto.encode(message.enumType[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.extensionRange != null && message.extensionRange.length)
                        for (var i = 0; i < message.extensionRange.length; ++i)
                            $root.google.protobuf.DescriptorProto.ExtensionRange.encode(message.extensionRange[i], writer.uint32(/* id 5, wireType 2 =*/42).fork()).ldelim();
                    if (message.extension != null && message.extension.length)
                        for (var i = 0; i < message.extension.length; ++i)
                            $root.google.protobuf.FieldDescriptorProto.encode(message.extension[i], writer.uint32(/* id 6, wireType 2 =*/50).fork()).ldelim();
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.MessageOptions.encode(message.options, writer.uint32(/* id 7, wireType 2 =*/58).fork()).ldelim();
                    if (message.oneofDecl != null && message.oneofDecl.length)
                        for (var i = 0; i < message.oneofDecl.length; ++i)
                            $root.google.protobuf.OneofDescriptorProto.encode(message.oneofDecl[i], writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.reservedRange != null && message.reservedRange.length)
                        for (var i = 0; i < message.reservedRange.length; ++i)
                            $root.google.protobuf.DescriptorProto.ReservedRange.encode(message.reservedRange[i], writer.uint32(/* id 9, wireType 2 =*/74).fork()).ldelim();
                    if (message.reservedName != null && message.reservedName.length)
                        for (var i = 0; i < message.reservedName.length; ++i)
                            writer.uint32(/* id 10, wireType 2 =*/82).string(message.reservedName[i]);
                    return writer;
                };

                /**
                 * Encodes the specified DescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.IDescriptorProto} message DescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                DescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a DescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                DescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            if (!(message.field && message.field.length))
                                message.field = [];
                            message.field.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 6:
                            if (!(message.extension && message.extension.length))
                                message.extension = [];
                            message.extension.push($root.google.protobuf.FieldDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            if (!(message.nestedType && message.nestedType.length))
                                message.nestedType = [];
                            message.nestedType.push($root.google.protobuf.DescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 4:
                            if (!(message.enumType && message.enumType.length))
                                message.enumType = [];
                            message.enumType.push($root.google.protobuf.EnumDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.extensionRange && message.extensionRange.length))
                                message.extensionRange = [];
                            message.extensionRange.push($root.google.protobuf.DescriptorProto.ExtensionRange.decode(reader, reader.uint32()));
                            break;
                        case 8:
                            if (!(message.oneofDecl && message.oneofDecl.length))
                                message.oneofDecl = [];
                            message.oneofDecl.push($root.google.protobuf.OneofDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 7:
                            message.options = $root.google.protobuf.MessageOptions.decode(reader, reader.uint32());
                            break;
                        case 9:
                            if (!(message.reservedRange && message.reservedRange.length))
                                message.reservedRange = [];
                            message.reservedRange.push($root.google.protobuf.DescriptorProto.ReservedRange.decode(reader, reader.uint32()));
                            break;
                        case 10:
                            if (!(message.reservedName && message.reservedName.length))
                                message.reservedName = [];
                            message.reservedName.push(reader.string());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a DescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                DescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a DescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                DescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.field != null && message.hasOwnProperty("field")) {
                        if (!Array.isArray(message.field))
                            return "field: array expected";
                        for (var i = 0; i < message.field.length; ++i) {
                            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.field[i]);
                            if (error)
                                return "field." + error;
                        }
                    }
                    if (message.extension != null && message.hasOwnProperty("extension")) {
                        if (!Array.isArray(message.extension))
                            return "extension: array expected";
                        for (var i = 0; i < message.extension.length; ++i) {
                            var error = $root.google.protobuf.FieldDescriptorProto.verify(message.extension[i]);
                            if (error)
                                return "extension." + error;
                        }
                    }
                    if (message.nestedType != null && message.hasOwnProperty("nestedType")) {
                        if (!Array.isArray(message.nestedType))
                            return "nestedType: array expected";
                        for (var i = 0; i < message.nestedType.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.verify(message.nestedType[i]);
                            if (error)
                                return "nestedType." + error;
                        }
                    }
                    if (message.enumType != null && message.hasOwnProperty("enumType")) {
                        if (!Array.isArray(message.enumType))
                            return "enumType: array expected";
                        for (var i = 0; i < message.enumType.length; ++i) {
                            var error = $root.google.protobuf.EnumDescriptorProto.verify(message.enumType[i]);
                            if (error)
                                return "enumType." + error;
                        }
                    }
                    if (message.extensionRange != null && message.hasOwnProperty("extensionRange")) {
                        if (!Array.isArray(message.extensionRange))
                            return "extensionRange: array expected";
                        for (var i = 0; i < message.extensionRange.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.ExtensionRange.verify(message.extensionRange[i]);
                            if (error)
                                return "extensionRange." + error;
                        }
                    }
                    if (message.oneofDecl != null && message.hasOwnProperty("oneofDecl")) {
                        if (!Array.isArray(message.oneofDecl))
                            return "oneofDecl: array expected";
                        for (var i = 0; i < message.oneofDecl.length; ++i) {
                            var error = $root.google.protobuf.OneofDescriptorProto.verify(message.oneofDecl[i]);
                            if (error)
                                return "oneofDecl." + error;
                        }
                    }
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.MessageOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.reservedRange != null && message.hasOwnProperty("reservedRange")) {
                        if (!Array.isArray(message.reservedRange))
                            return "reservedRange: array expected";
                        for (var i = 0; i < message.reservedRange.length; ++i) {
                            var error = $root.google.protobuf.DescriptorProto.ReservedRange.verify(message.reservedRange[i]);
                            if (error)
                                return "reservedRange." + error;
                        }
                    }
                    if (message.reservedName != null && message.hasOwnProperty("reservedName")) {
                        if (!Array.isArray(message.reservedName))
                            return "reservedName: array expected";
                        for (var i = 0; i < message.reservedName.length; ++i)
                            if (!$util.isString(message.reservedName[i]))
                                return "reservedName: string[] expected";
                    }
                    return null;
                };

                /**
                 * Creates a DescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.DescriptorProto} DescriptorProto
                 */
                DescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.DescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.DescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.field) {
                        if (!Array.isArray(object.field))
                            throw TypeError(".google.protobuf.DescriptorProto.field: array expected");
                        message.field = [];
                        for (var i = 0; i < object.field.length; ++i) {
                            if (typeof object.field[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.field: object expected");
                            message.field[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.field[i]);
                        }
                    }
                    if (object.extension) {
                        if (!Array.isArray(object.extension))
                            throw TypeError(".google.protobuf.DescriptorProto.extension: array expected");
                        message.extension = [];
                        for (var i = 0; i < object.extension.length; ++i) {
                            if (typeof object.extension[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.extension: object expected");
                            message.extension[i] = $root.google.protobuf.FieldDescriptorProto.fromObject(object.extension[i]);
                        }
                    }
                    if (object.nestedType) {
                        if (!Array.isArray(object.nestedType))
                            throw TypeError(".google.protobuf.DescriptorProto.nestedType: array expected");
                        message.nestedType = [];
                        for (var i = 0; i < object.nestedType.length; ++i) {
                            if (typeof object.nestedType[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.nestedType: object expected");
                            message.nestedType[i] = $root.google.protobuf.DescriptorProto.fromObject(object.nestedType[i]);
                        }
                    }
                    if (object.enumType) {
                        if (!Array.isArray(object.enumType))
                            throw TypeError(".google.protobuf.DescriptorProto.enumType: array expected");
                        message.enumType = [];
                        for (var i = 0; i < object.enumType.length; ++i) {
                            if (typeof object.enumType[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.enumType: object expected");
                            message.enumType[i] = $root.google.protobuf.EnumDescriptorProto.fromObject(object.enumType[i]);
                        }
                    }
                    if (object.extensionRange) {
                        if (!Array.isArray(object.extensionRange))
                            throw TypeError(".google.protobuf.DescriptorProto.extensionRange: array expected");
                        message.extensionRange = [];
                        for (var i = 0; i < object.extensionRange.length; ++i) {
                            if (typeof object.extensionRange[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.extensionRange: object expected");
                            message.extensionRange[i] = $root.google.protobuf.DescriptorProto.ExtensionRange.fromObject(object.extensionRange[i]);
                        }
                    }
                    if (object.oneofDecl) {
                        if (!Array.isArray(object.oneofDecl))
                            throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: array expected");
                        message.oneofDecl = [];
                        for (var i = 0; i < object.oneofDecl.length; ++i) {
                            if (typeof object.oneofDecl[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.oneofDecl: object expected");
                            message.oneofDecl[i] = $root.google.protobuf.OneofDescriptorProto.fromObject(object.oneofDecl[i]);
                        }
                    }
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.DescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.MessageOptions.fromObject(object.options);
                    }
                    if (object.reservedRange) {
                        if (!Array.isArray(object.reservedRange))
                            throw TypeError(".google.protobuf.DescriptorProto.reservedRange: array expected");
                        message.reservedRange = [];
                        for (var i = 0; i < object.reservedRange.length; ++i) {
                            if (typeof object.reservedRange[i] !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.reservedRange: object expected");
                            message.reservedRange[i] = $root.google.protobuf.DescriptorProto.ReservedRange.fromObject(object.reservedRange[i]);
                        }
                    }
                    if (object.reservedName) {
                        if (!Array.isArray(object.reservedName))
                            throw TypeError(".google.protobuf.DescriptorProto.reservedName: array expected");
                        message.reservedName = [];
                        for (var i = 0; i < object.reservedName.length; ++i)
                            message.reservedName[i] = String(object.reservedName[i]);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a DescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.DescriptorProto
                 * @static
                 * @param {google.protobuf.DescriptorProto} message DescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                DescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.field = [];
                        object.nestedType = [];
                        object.enumType = [];
                        object.extensionRange = [];
                        object.extension = [];
                        object.oneofDecl = [];
                        object.reservedRange = [];
                        object.reservedName = [];
                    }
                    if (options.defaults) {
                        object.name = "";
                        object.options = null;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.field && message.field.length) {
                        object.field = [];
                        for (var j = 0; j < message.field.length; ++j)
                            object.field[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.field[j], options);
                    }
                    if (message.nestedType && message.nestedType.length) {
                        object.nestedType = [];
                        for (var j = 0; j < message.nestedType.length; ++j)
                            object.nestedType[j] = $root.google.protobuf.DescriptorProto.toObject(message.nestedType[j], options);
                    }
                    if (message.enumType && message.enumType.length) {
                        object.enumType = [];
                        for (var j = 0; j < message.enumType.length; ++j)
                            object.enumType[j] = $root.google.protobuf.EnumDescriptorProto.toObject(message.enumType[j], options);
                    }
                    if (message.extensionRange && message.extensionRange.length) {
                        object.extensionRange = [];
                        for (var j = 0; j < message.extensionRange.length; ++j)
                            object.extensionRange[j] = $root.google.protobuf.DescriptorProto.ExtensionRange.toObject(message.extensionRange[j], options);
                    }
                    if (message.extension && message.extension.length) {
                        object.extension = [];
                        for (var j = 0; j < message.extension.length; ++j)
                            object.extension[j] = $root.google.protobuf.FieldDescriptorProto.toObject(message.extension[j], options);
                    }
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.MessageOptions.toObject(message.options, options);
                    if (message.oneofDecl && message.oneofDecl.length) {
                        object.oneofDecl = [];
                        for (var j = 0; j < message.oneofDecl.length; ++j)
                            object.oneofDecl[j] = $root.google.protobuf.OneofDescriptorProto.toObject(message.oneofDecl[j], options);
                    }
                    if (message.reservedRange && message.reservedRange.length) {
                        object.reservedRange = [];
                        for (var j = 0; j < message.reservedRange.length; ++j)
                            object.reservedRange[j] = $root.google.protobuf.DescriptorProto.ReservedRange.toObject(message.reservedRange[j], options);
                    }
                    if (message.reservedName && message.reservedName.length) {
                        object.reservedName = [];
                        for (var j = 0; j < message.reservedName.length; ++j)
                            object.reservedName[j] = message.reservedName[j];
                    }
                    return object;
                };

                /**
                 * Converts this DescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.DescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                DescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                DescriptorProto.ExtensionRange = (function() {

                    /**
                     * Properties of an ExtensionRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @interface IExtensionRange
                     * @property {number|null} [start] ExtensionRange start
                     * @property {number|null} [end] ExtensionRange end
                     * @property {google.protobuf.IExtensionRangeOptions|null} [options] ExtensionRange options
                     */

                    /**
                     * Constructs a new ExtensionRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @classdesc Represents an ExtensionRange.
                     * @implements IExtensionRange
                     * @constructor
                     * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
                     */
                    function ExtensionRange(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * ExtensionRange start.
                     * @member {number} start
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     */
                    ExtensionRange.prototype.start = 0;

                    /**
                     * ExtensionRange end.
                     * @member {number} end
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     */
                    ExtensionRange.prototype.end = 0;

                    /**
                     * ExtensionRange options.
                     * @member {google.protobuf.IExtensionRangeOptions|null|undefined} options
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     */
                    ExtensionRange.prototype.options = null;

                    /**
                     * Creates a new ExtensionRange instance using the specified properties.
                     * @function create
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IExtensionRange=} [properties] Properties to set
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange instance
                     */
                    ExtensionRange.create = function create(properties) {
                        return new ExtensionRange(properties);
                    };

                    /**
                     * Encodes the specified ExtensionRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                     * @function encode
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExtensionRange.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                        if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                        if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                            $root.google.protobuf.ExtensionRangeOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                        return writer;
                    };

                    /**
                     * Encodes the specified ExtensionRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ExtensionRange.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IExtensionRange} message ExtensionRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ExtensionRange.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes an ExtensionRange message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExtensionRange.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.start = reader.int32();
                                break;
                            case 2:
                                message.end = reader.int32();
                                break;
                            case 3:
                                message.options = $root.google.protobuf.ExtensionRangeOptions.decode(reader, reader.uint32());
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes an ExtensionRange message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ExtensionRange.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies an ExtensionRange message.
                     * @function verify
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ExtensionRange.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.start != null && message.hasOwnProperty("start"))
                            if (!$util.isInteger(message.start))
                                return "start: integer expected";
                        if (message.end != null && message.hasOwnProperty("end"))
                            if (!$util.isInteger(message.end))
                                return "end: integer expected";
                        if (message.options != null && message.hasOwnProperty("options")) {
                            var error = $root.google.protobuf.ExtensionRangeOptions.verify(message.options);
                            if (error)
                                return "options." + error;
                        }
                        return null;
                    };

                    /**
                     * Creates an ExtensionRange message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.protobuf.DescriptorProto.ExtensionRange} ExtensionRange
                     */
                    ExtensionRange.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.protobuf.DescriptorProto.ExtensionRange)
                            return object;
                        var message = new $root.google.protobuf.DescriptorProto.ExtensionRange();
                        if (object.start != null)
                            message.start = object.start | 0;
                        if (object.end != null)
                            message.end = object.end | 0;
                        if (object.options != null) {
                            if (typeof object.options !== "object")
                                throw TypeError(".google.protobuf.DescriptorProto.ExtensionRange.options: object expected");
                            message.options = $root.google.protobuf.ExtensionRangeOptions.fromObject(object.options);
                        }
                        return message;
                    };

                    /**
                     * Creates a plain object from an ExtensionRange message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.ExtensionRange} message ExtensionRange
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ExtensionRange.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.start = 0;
                            object.end = 0;
                            object.options = null;
                        }
                        if (message.start != null && message.hasOwnProperty("start"))
                            object.start = message.start;
                        if (message.end != null && message.hasOwnProperty("end"))
                            object.end = message.end;
                        if (message.options != null && message.hasOwnProperty("options"))
                            object.options = $root.google.protobuf.ExtensionRangeOptions.toObject(message.options, options);
                        return object;
                    };

                    /**
                     * Converts this ExtensionRange to JSON.
                     * @function toJSON
                     * @memberof google.protobuf.DescriptorProto.ExtensionRange
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ExtensionRange.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return ExtensionRange;
                })();

                DescriptorProto.ReservedRange = (function() {

                    /**
                     * Properties of a ReservedRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @interface IReservedRange
                     * @property {number|null} [start] ReservedRange start
                     * @property {number|null} [end] ReservedRange end
                     */

                    /**
                     * Constructs a new ReservedRange.
                     * @memberof google.protobuf.DescriptorProto
                     * @classdesc Represents a ReservedRange.
                     * @implements IReservedRange
                     * @constructor
                     * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
                     */
                    function ReservedRange(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * ReservedRange start.
                     * @member {number} start
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @instance
                     */
                    ReservedRange.prototype.start = 0;

                    /**
                     * ReservedRange end.
                     * @member {number} end
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @instance
                     */
                    ReservedRange.prototype.end = 0;

                    /**
                     * Creates a new ReservedRange instance using the specified properties.
                     * @function create
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IReservedRange=} [properties] Properties to set
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange instance
                     */
                    ReservedRange.create = function create(properties) {
                        return new ReservedRange(properties);
                    };

                    /**
                     * Encodes the specified ReservedRange message. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                     * @function encode
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReservedRange.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                        if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                        return writer;
                    };

                    /**
                     * Encodes the specified ReservedRange message, length delimited. Does not implicitly {@link google.protobuf.DescriptorProto.ReservedRange.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.IReservedRange} message ReservedRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    ReservedRange.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes a ReservedRange message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReservedRange.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.DescriptorProto.ReservedRange();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.start = reader.int32();
                                break;
                            case 2:
                                message.end = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes a ReservedRange message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    ReservedRange.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies a ReservedRange message.
                     * @function verify
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    ReservedRange.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.start != null && message.hasOwnProperty("start"))
                            if (!$util.isInteger(message.start))
                                return "start: integer expected";
                        if (message.end != null && message.hasOwnProperty("end"))
                            if (!$util.isInteger(message.end))
                                return "end: integer expected";
                        return null;
                    };

                    /**
                     * Creates a ReservedRange message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.protobuf.DescriptorProto.ReservedRange} ReservedRange
                     */
                    ReservedRange.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.protobuf.DescriptorProto.ReservedRange)
                            return object;
                        var message = new $root.google.protobuf.DescriptorProto.ReservedRange();
                        if (object.start != null)
                            message.start = object.start | 0;
                        if (object.end != null)
                            message.end = object.end | 0;
                        return message;
                    };

                    /**
                     * Creates a plain object from a ReservedRange message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @static
                     * @param {google.protobuf.DescriptorProto.ReservedRange} message ReservedRange
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    ReservedRange.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.start = 0;
                            object.end = 0;
                        }
                        if (message.start != null && message.hasOwnProperty("start"))
                            object.start = message.start;
                        if (message.end != null && message.hasOwnProperty("end"))
                            object.end = message.end;
                        return object;
                    };

                    /**
                     * Converts this ReservedRange to JSON.
                     * @function toJSON
                     * @memberof google.protobuf.DescriptorProto.ReservedRange
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    ReservedRange.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return ReservedRange;
                })();

                return DescriptorProto;
            })();

            protobuf.ExtensionRangeOptions = (function() {

                /**
                 * Properties of an ExtensionRangeOptions.
                 * @memberof google.protobuf
                 * @interface IExtensionRangeOptions
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] ExtensionRangeOptions uninterpretedOption
                 */

                /**
                 * Constructs a new ExtensionRangeOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents an ExtensionRangeOptions.
                 * @implements IExtensionRangeOptions
                 * @constructor
                 * @param {google.protobuf.IExtensionRangeOptions=} [properties] Properties to set
                 */
                function ExtensionRangeOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * ExtensionRangeOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @instance
                 */
                ExtensionRangeOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new ExtensionRangeOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.IExtensionRangeOptions=} [properties] Properties to set
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions instance
                 */
                ExtensionRangeOptions.create = function create(properties) {
                    return new ExtensionRangeOptions(properties);
                };

                /**
                 * Encodes the specified ExtensionRangeOptions message. Does not implicitly {@link google.protobuf.ExtensionRangeOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.IExtensionRangeOptions} message ExtensionRangeOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtensionRangeOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified ExtensionRangeOptions message, length delimited. Does not implicitly {@link google.protobuf.ExtensionRangeOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.IExtensionRangeOptions} message ExtensionRangeOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ExtensionRangeOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an ExtensionRangeOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtensionRangeOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ExtensionRangeOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an ExtensionRangeOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ExtensionRangeOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an ExtensionRangeOptions message.
                 * @function verify
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ExtensionRangeOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates an ExtensionRangeOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.ExtensionRangeOptions} ExtensionRangeOptions
                 */
                ExtensionRangeOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.ExtensionRangeOptions)
                        return object;
                    var message = new $root.google.protobuf.ExtensionRangeOptions();
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.ExtensionRangeOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.ExtensionRangeOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an ExtensionRangeOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @static
                 * @param {google.protobuf.ExtensionRangeOptions} message ExtensionRangeOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                ExtensionRangeOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this ExtensionRangeOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.ExtensionRangeOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                ExtensionRangeOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return ExtensionRangeOptions;
            })();

            protobuf.FieldDescriptorProto = (function() {

                /**
                 * Properties of a FieldDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IFieldDescriptorProto
                 * @property {string|null} [name] FieldDescriptorProto name
                 * @property {number|null} [number] FieldDescriptorProto number
                 * @property {google.protobuf.FieldDescriptorProto.Label|null} [label] FieldDescriptorProto label
                 * @property {google.protobuf.FieldDescriptorProto.Type|null} [type] FieldDescriptorProto type
                 * @property {string|null} [typeName] FieldDescriptorProto typeName
                 * @property {string|null} [extendee] FieldDescriptorProto extendee
                 * @property {string|null} [defaultValue] FieldDescriptorProto defaultValue
                 * @property {number|null} [oneofIndex] FieldDescriptorProto oneofIndex
                 * @property {string|null} [jsonName] FieldDescriptorProto jsonName
                 * @property {google.protobuf.IFieldOptions|null} [options] FieldDescriptorProto options
                 * @property {boolean|null} [proto3Optional] FieldDescriptorProto proto3Optional
                 */

                /**
                 * Constructs a new FieldDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a FieldDescriptorProto.
                 * @implements IFieldDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IFieldDescriptorProto=} [properties] Properties to set
                 */
                function FieldDescriptorProto(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * FieldDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.name = "";

                /**
                 * FieldDescriptorProto number.
                 * @member {number} number
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.number = 0;

                /**
                 * FieldDescriptorProto label.
                 * @member {google.protobuf.FieldDescriptorProto.Label} label
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.label = 1;

                /**
                 * FieldDescriptorProto type.
                 * @member {google.protobuf.FieldDescriptorProto.Type} type
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.type = 1;

                /**
                 * FieldDescriptorProto typeName.
                 * @member {string} typeName
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.typeName = "";

                /**
                 * FieldDescriptorProto extendee.
                 * @member {string} extendee
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.extendee = "";

                /**
                 * FieldDescriptorProto defaultValue.
                 * @member {string} defaultValue
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.defaultValue = "";

                /**
                 * FieldDescriptorProto oneofIndex.
                 * @member {number} oneofIndex
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.oneofIndex = 0;

                /**
                 * FieldDescriptorProto jsonName.
                 * @member {string} jsonName
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.jsonName = "";

                /**
                 * FieldDescriptorProto options.
                 * @member {google.protobuf.IFieldOptions|null|undefined} options
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.options = null;

                /**
                 * FieldDescriptorProto proto3Optional.
                 * @member {boolean} proto3Optional
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 */
                FieldDescriptorProto.prototype.proto3Optional = false;

                /**
                 * Creates a new FieldDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {google.protobuf.IFieldDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto instance
                 */
                FieldDescriptorProto.create = function create(properties) {
                    return new FieldDescriptorProto(properties);
                };

                /**
                 * Encodes the specified FieldDescriptorProto message. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {google.protobuf.IFieldDescriptorProto} message FieldDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FieldDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.extendee != null && Object.hasOwnProperty.call(message, "extendee"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.extendee);
                    if (message.number != null && Object.hasOwnProperty.call(message, "number"))
                        writer.uint32(/* id 3, wireType 0 =*/24).int32(message.number);
                    if (message.label != null && Object.hasOwnProperty.call(message, "label"))
                        writer.uint32(/* id 4, wireType 0 =*/32).int32(message.label);
                    if (message.type != null && Object.hasOwnProperty.call(message, "type"))
                        writer.uint32(/* id 5, wireType 0 =*/40).int32(message.type);
                    if (message.typeName != null && Object.hasOwnProperty.call(message, "typeName"))
                        writer.uint32(/* id 6, wireType 2 =*/50).string(message.typeName);
                    if (message.defaultValue != null && Object.hasOwnProperty.call(message, "defaultValue"))
                        writer.uint32(/* id 7, wireType 2 =*/58).string(message.defaultValue);
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.FieldOptions.encode(message.options, writer.uint32(/* id 8, wireType 2 =*/66).fork()).ldelim();
                    if (message.oneofIndex != null && Object.hasOwnProperty.call(message, "oneofIndex"))
                        writer.uint32(/* id 9, wireType 0 =*/72).int32(message.oneofIndex);
                    if (message.jsonName != null && Object.hasOwnProperty.call(message, "jsonName"))
                        writer.uint32(/* id 10, wireType 2 =*/82).string(message.jsonName);
                    if (message.proto3Optional != null && Object.hasOwnProperty.call(message, "proto3Optional"))
                        writer.uint32(/* id 17, wireType 0 =*/136).bool(message.proto3Optional);
                    return writer;
                };

                /**
                 * Encodes the specified FieldDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.FieldDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {google.protobuf.IFieldDescriptorProto} message FieldDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FieldDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a FieldDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FieldDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FieldDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 3:
                            message.number = reader.int32();
                            break;
                        case 4:
                            message.label = reader.int32();
                            break;
                        case 5:
                            message.type = reader.int32();
                            break;
                        case 6:
                            message.typeName = reader.string();
                            break;
                        case 2:
                            message.extendee = reader.string();
                            break;
                        case 7:
                            message.defaultValue = reader.string();
                            break;
                        case 9:
                            message.oneofIndex = reader.int32();
                            break;
                        case 10:
                            message.jsonName = reader.string();
                            break;
                        case 8:
                            message.options = $root.google.protobuf.FieldOptions.decode(reader, reader.uint32());
                            break;
                        case 17:
                            message.proto3Optional = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a FieldDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FieldDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a FieldDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FieldDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.number != null && message.hasOwnProperty("number"))
                        if (!$util.isInteger(message.number))
                            return "number: integer expected";
                    if (message.label != null && message.hasOwnProperty("label"))
                        switch (message.label) {
                        default:
                            return "label: enum value expected";
                        case 1:
                        case 2:
                        case 3:
                            break;
                        }
                    if (message.type != null && message.hasOwnProperty("type"))
                        switch (message.type) {
                        default:
                            return "type: enum value expected";
                        case 1:
                        case 2:
                        case 3:
                        case 4:
                        case 5:
                        case 6:
                        case 7:
                        case 8:
                        case 9:
                        case 10:
                        case 11:
                        case 12:
                        case 13:
                        case 14:
                        case 15:
                        case 16:
                        case 17:
                        case 18:
                            break;
                        }
                    if (message.typeName != null && message.hasOwnProperty("typeName"))
                        if (!$util.isString(message.typeName))
                            return "typeName: string expected";
                    if (message.extendee != null && message.hasOwnProperty("extendee"))
                        if (!$util.isString(message.extendee))
                            return "extendee: string expected";
                    if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
                        if (!$util.isString(message.defaultValue))
                            return "defaultValue: string expected";
                    if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
                        if (!$util.isInteger(message.oneofIndex))
                            return "oneofIndex: integer expected";
                    if (message.jsonName != null && message.hasOwnProperty("jsonName"))
                        if (!$util.isString(message.jsonName))
                            return "jsonName: string expected";
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.FieldOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.proto3Optional != null && message.hasOwnProperty("proto3Optional"))
                        if (typeof message.proto3Optional !== "boolean")
                            return "proto3Optional: boolean expected";
                    return null;
                };

                /**
                 * Creates a FieldDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FieldDescriptorProto} FieldDescriptorProto
                 */
                FieldDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FieldDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.FieldDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.number != null)
                        message.number = object.number | 0;
                    switch (object.label) {
                    case "LABEL_OPTIONAL":
                    case 1:
                        message.label = 1;
                        break;
                    case "LABEL_REQUIRED":
                    case 2:
                        message.label = 2;
                        break;
                    case "LABEL_REPEATED":
                    case 3:
                        message.label = 3;
                        break;
                    }
                    switch (object.type) {
                    case "TYPE_DOUBLE":
                    case 1:
                        message.type = 1;
                        break;
                    case "TYPE_FLOAT":
                    case 2:
                        message.type = 2;
                        break;
                    case "TYPE_INT64":
                    case 3:
                        message.type = 3;
                        break;
                    case "TYPE_UINT64":
                    case 4:
                        message.type = 4;
                        break;
                    case "TYPE_INT32":
                    case 5:
                        message.type = 5;
                        break;
                    case "TYPE_FIXED64":
                    case 6:
                        message.type = 6;
                        break;
                    case "TYPE_FIXED32":
                    case 7:
                        message.type = 7;
                        break;
                    case "TYPE_BOOL":
                    case 8:
                        message.type = 8;
                        break;
                    case "TYPE_STRING":
                    case 9:
                        message.type = 9;
                        break;
                    case "TYPE_GROUP":
                    case 10:
                        message.type = 10;
                        break;
                    case "TYPE_MESSAGE":
                    case 11:
                        message.type = 11;
                        break;
                    case "TYPE_BYTES":
                    case 12:
                        message.type = 12;
                        break;
                    case "TYPE_UINT32":
                    case 13:
                        message.type = 13;
                        break;
                    case "TYPE_ENUM":
                    case 14:
                        message.type = 14;
                        break;
                    case "TYPE_SFIXED32":
                    case 15:
                        message.type = 15;
                        break;
                    case "TYPE_SFIXED64":
                    case 16:
                        message.type = 16;
                        break;
                    case "TYPE_SINT32":
                    case 17:
                        message.type = 17;
                        break;
                    case "TYPE_SINT64":
                    case 18:
                        message.type = 18;
                        break;
                    }
                    if (object.typeName != null)
                        message.typeName = String(object.typeName);
                    if (object.extendee != null)
                        message.extendee = String(object.extendee);
                    if (object.defaultValue != null)
                        message.defaultValue = String(object.defaultValue);
                    if (object.oneofIndex != null)
                        message.oneofIndex = object.oneofIndex | 0;
                    if (object.jsonName != null)
                        message.jsonName = String(object.jsonName);
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.FieldDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.FieldOptions.fromObject(object.options);
                    }
                    if (object.proto3Optional != null)
                        message.proto3Optional = Boolean(object.proto3Optional);
                    return message;
                };

                /**
                 * Creates a plain object from a FieldDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @static
                 * @param {google.protobuf.FieldDescriptorProto} message FieldDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FieldDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.name = "";
                        object.extendee = "";
                        object.number = 0;
                        object.label = options.enums === String ? "LABEL_OPTIONAL" : 1;
                        object.type = options.enums === String ? "TYPE_DOUBLE" : 1;
                        object.typeName = "";
                        object.defaultValue = "";
                        object.options = null;
                        object.oneofIndex = 0;
                        object.jsonName = "";
                        object.proto3Optional = false;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.extendee != null && message.hasOwnProperty("extendee"))
                        object.extendee = message.extendee;
                    if (message.number != null && message.hasOwnProperty("number"))
                        object.number = message.number;
                    if (message.label != null && message.hasOwnProperty("label"))
                        object.label = options.enums === String ? $root.google.protobuf.FieldDescriptorProto.Label[message.label] : message.label;
                    if (message.type != null && message.hasOwnProperty("type"))
                        object.type = options.enums === String ? $root.google.protobuf.FieldDescriptorProto.Type[message.type] : message.type;
                    if (message.typeName != null && message.hasOwnProperty("typeName"))
                        object.typeName = message.typeName;
                    if (message.defaultValue != null && message.hasOwnProperty("defaultValue"))
                        object.defaultValue = message.defaultValue;
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.FieldOptions.toObject(message.options, options);
                    if (message.oneofIndex != null && message.hasOwnProperty("oneofIndex"))
                        object.oneofIndex = message.oneofIndex;
                    if (message.jsonName != null && message.hasOwnProperty("jsonName"))
                        object.jsonName = message.jsonName;
                    if (message.proto3Optional != null && message.hasOwnProperty("proto3Optional"))
                        object.proto3Optional = message.proto3Optional;
                    return object;
                };

                /**
                 * Converts this FieldDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FieldDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FieldDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * Type enum.
                 * @name google.protobuf.FieldDescriptorProto.Type
                 * @enum {number}
                 * @property {number} TYPE_DOUBLE=1 TYPE_DOUBLE value
                 * @property {number} TYPE_FLOAT=2 TYPE_FLOAT value
                 * @property {number} TYPE_INT64=3 TYPE_INT64 value
                 * @property {number} TYPE_UINT64=4 TYPE_UINT64 value
                 * @property {number} TYPE_INT32=5 TYPE_INT32 value
                 * @property {number} TYPE_FIXED64=6 TYPE_FIXED64 value
                 * @property {number} TYPE_FIXED32=7 TYPE_FIXED32 value
                 * @property {number} TYPE_BOOL=8 TYPE_BOOL value
                 * @property {number} TYPE_STRING=9 TYPE_STRING value
                 * @property {number} TYPE_GROUP=10 TYPE_GROUP value
                 * @property {number} TYPE_MESSAGE=11 TYPE_MESSAGE value
                 * @property {number} TYPE_BYTES=12 TYPE_BYTES value
                 * @property {number} TYPE_UINT32=13 TYPE_UINT32 value
                 * @property {number} TYPE_ENUM=14 TYPE_ENUM value
                 * @property {number} TYPE_SFIXED32=15 TYPE_SFIXED32 value
                 * @property {number} TYPE_SFIXED64=16 TYPE_SFIXED64 value
                 * @property {number} TYPE_SINT32=17 TYPE_SINT32 value
                 * @property {number} TYPE_SINT64=18 TYPE_SINT64 value
                 */
                FieldDescriptorProto.Type = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[1] = "TYPE_DOUBLE"] = 1;
                    values[valuesById[2] = "TYPE_FLOAT"] = 2;
                    values[valuesById[3] = "TYPE_INT64"] = 3;
                    values[valuesById[4] = "TYPE_UINT64"] = 4;
                    values[valuesById[5] = "TYPE_INT32"] = 5;
                    values[valuesById[6] = "TYPE_FIXED64"] = 6;
                    values[valuesById[7] = "TYPE_FIXED32"] = 7;
                    values[valuesById[8] = "TYPE_BOOL"] = 8;
                    values[valuesById[9] = "TYPE_STRING"] = 9;
                    values[valuesById[10] = "TYPE_GROUP"] = 10;
                    values[valuesById[11] = "TYPE_MESSAGE"] = 11;
                    values[valuesById[12] = "TYPE_BYTES"] = 12;
                    values[valuesById[13] = "TYPE_UINT32"] = 13;
                    values[valuesById[14] = "TYPE_ENUM"] = 14;
                    values[valuesById[15] = "TYPE_SFIXED32"] = 15;
                    values[valuesById[16] = "TYPE_SFIXED64"] = 16;
                    values[valuesById[17] = "TYPE_SINT32"] = 17;
                    values[valuesById[18] = "TYPE_SINT64"] = 18;
                    return values;
                })();

                /**
                 * Label enum.
                 * @name google.protobuf.FieldDescriptorProto.Label
                 * @enum {number}
                 * @property {number} LABEL_OPTIONAL=1 LABEL_OPTIONAL value
                 * @property {number} LABEL_REQUIRED=2 LABEL_REQUIRED value
                 * @property {number} LABEL_REPEATED=3 LABEL_REPEATED value
                 */
                FieldDescriptorProto.Label = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[1] = "LABEL_OPTIONAL"] = 1;
                    values[valuesById[2] = "LABEL_REQUIRED"] = 2;
                    values[valuesById[3] = "LABEL_REPEATED"] = 3;
                    return values;
                })();

                return FieldDescriptorProto;
            })();

            protobuf.OneofDescriptorProto = (function() {

                /**
                 * Properties of an OneofDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IOneofDescriptorProto
                 * @property {string|null} [name] OneofDescriptorProto name
                 * @property {google.protobuf.IOneofOptions|null} [options] OneofDescriptorProto options
                 */

                /**
                 * Constructs a new OneofDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents an OneofDescriptorProto.
                 * @implements IOneofDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IOneofDescriptorProto=} [properties] Properties to set
                 */
                function OneofDescriptorProto(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * OneofDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @instance
                 */
                OneofDescriptorProto.prototype.name = "";

                /**
                 * OneofDescriptorProto options.
                 * @member {google.protobuf.IOneofOptions|null|undefined} options
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @instance
                 */
                OneofDescriptorProto.prototype.options = null;

                /**
                 * Creates a new OneofDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {google.protobuf.IOneofDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto instance
                 */
                OneofDescriptorProto.create = function create(properties) {
                    return new OneofDescriptorProto(properties);
                };

                /**
                 * Encodes the specified OneofDescriptorProto message. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {google.protobuf.IOneofDescriptorProto} message OneofDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OneofDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.OneofOptions.encode(message.options, writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified OneofDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.OneofDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {google.protobuf.IOneofDescriptorProto} message OneofDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OneofDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an OneofDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OneofDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.OneofDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message.options = $root.google.protobuf.OneofOptions.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an OneofDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OneofDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an OneofDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                OneofDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.OneofOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    return null;
                };

                /**
                 * Creates an OneofDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.OneofDescriptorProto} OneofDescriptorProto
                 */
                OneofDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.OneofDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.OneofDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.OneofDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.OneofOptions.fromObject(object.options);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an OneofDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @static
                 * @param {google.protobuf.OneofDescriptorProto} message OneofDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                OneofDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.name = "";
                        object.options = null;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.OneofOptions.toObject(message.options, options);
                    return object;
                };

                /**
                 * Converts this OneofDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.OneofDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                OneofDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return OneofDescriptorProto;
            })();

            protobuf.EnumDescriptorProto = (function() {

                /**
                 * Properties of an EnumDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IEnumDescriptorProto
                 * @property {string|null} [name] EnumDescriptorProto name
                 * @property {Array.<google.protobuf.IEnumValueDescriptorProto>|null} [value] EnumDescriptorProto value
                 * @property {google.protobuf.IEnumOptions|null} [options] EnumDescriptorProto options
                 * @property {Array.<google.protobuf.EnumDescriptorProto.IEnumReservedRange>|null} [reservedRange] EnumDescriptorProto reservedRange
                 * @property {Array.<string>|null} [reservedName] EnumDescriptorProto reservedName
                 */

                /**
                 * Constructs a new EnumDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents an EnumDescriptorProto.
                 * @implements IEnumDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IEnumDescriptorProto=} [properties] Properties to set
                 */
                function EnumDescriptorProto(properties) {
                    this.value = [];
                    this.reservedRange = [];
                    this.reservedName = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * EnumDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @instance
                 */
                EnumDescriptorProto.prototype.name = "";

                /**
                 * EnumDescriptorProto value.
                 * @member {Array.<google.protobuf.IEnumValueDescriptorProto>} value
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @instance
                 */
                EnumDescriptorProto.prototype.value = $util.emptyArray;

                /**
                 * EnumDescriptorProto options.
                 * @member {google.protobuf.IEnumOptions|null|undefined} options
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @instance
                 */
                EnumDescriptorProto.prototype.options = null;

                /**
                 * EnumDescriptorProto reservedRange.
                 * @member {Array.<google.protobuf.EnumDescriptorProto.IEnumReservedRange>} reservedRange
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @instance
                 */
                EnumDescriptorProto.prototype.reservedRange = $util.emptyArray;

                /**
                 * EnumDescriptorProto reservedName.
                 * @member {Array.<string>} reservedName
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @instance
                 */
                EnumDescriptorProto.prototype.reservedName = $util.emptyArray;

                /**
                 * Creates a new EnumDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {google.protobuf.IEnumDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto instance
                 */
                EnumDescriptorProto.create = function create(properties) {
                    return new EnumDescriptorProto(properties);
                };

                /**
                 * Encodes the specified EnumDescriptorProto message. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {google.protobuf.IEnumDescriptorProto} message EnumDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.value != null && message.value.length)
                        for (var i = 0; i < message.value.length; ++i)
                            $root.google.protobuf.EnumValueDescriptorProto.encode(message.value[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.EnumOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    if (message.reservedRange != null && message.reservedRange.length)
                        for (var i = 0; i < message.reservedRange.length; ++i)
                            $root.google.protobuf.EnumDescriptorProto.EnumReservedRange.encode(message.reservedRange[i], writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.reservedName != null && message.reservedName.length)
                        for (var i = 0; i < message.reservedName.length; ++i)
                            writer.uint32(/* id 5, wireType 2 =*/42).string(message.reservedName[i]);
                    return writer;
                };

                /**
                 * Encodes the specified EnumDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {google.protobuf.IEnumDescriptorProto} message EnumDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an EnumDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            if (!(message.value && message.value.length))
                                message.value = [];
                            message.value.push($root.google.protobuf.EnumValueDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            message.options = $root.google.protobuf.EnumOptions.decode(reader, reader.uint32());
                            break;
                        case 4:
                            if (!(message.reservedRange && message.reservedRange.length))
                                message.reservedRange = [];
                            message.reservedRange.push($root.google.protobuf.EnumDescriptorProto.EnumReservedRange.decode(reader, reader.uint32()));
                            break;
                        case 5:
                            if (!(message.reservedName && message.reservedName.length))
                                message.reservedName = [];
                            message.reservedName.push(reader.string());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an EnumDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an EnumDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                EnumDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.value != null && message.hasOwnProperty("value")) {
                        if (!Array.isArray(message.value))
                            return "value: array expected";
                        for (var i = 0; i < message.value.length; ++i) {
                            var error = $root.google.protobuf.EnumValueDescriptorProto.verify(message.value[i]);
                            if (error)
                                return "value." + error;
                        }
                    }
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.EnumOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.reservedRange != null && message.hasOwnProperty("reservedRange")) {
                        if (!Array.isArray(message.reservedRange))
                            return "reservedRange: array expected";
                        for (var i = 0; i < message.reservedRange.length; ++i) {
                            var error = $root.google.protobuf.EnumDescriptorProto.EnumReservedRange.verify(message.reservedRange[i]);
                            if (error)
                                return "reservedRange." + error;
                        }
                    }
                    if (message.reservedName != null && message.hasOwnProperty("reservedName")) {
                        if (!Array.isArray(message.reservedName))
                            return "reservedName: array expected";
                        for (var i = 0; i < message.reservedName.length; ++i)
                            if (!$util.isString(message.reservedName[i]))
                                return "reservedName: string[] expected";
                    }
                    return null;
                };

                /**
                 * Creates an EnumDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.EnumDescriptorProto} EnumDescriptorProto
                 */
                EnumDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.EnumDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.EnumDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.value) {
                        if (!Array.isArray(object.value))
                            throw TypeError(".google.protobuf.EnumDescriptorProto.value: array expected");
                        message.value = [];
                        for (var i = 0; i < object.value.length; ++i) {
                            if (typeof object.value[i] !== "object")
                                throw TypeError(".google.protobuf.EnumDescriptorProto.value: object expected");
                            message.value[i] = $root.google.protobuf.EnumValueDescriptorProto.fromObject(object.value[i]);
                        }
                    }
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.EnumDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.EnumOptions.fromObject(object.options);
                    }
                    if (object.reservedRange) {
                        if (!Array.isArray(object.reservedRange))
                            throw TypeError(".google.protobuf.EnumDescriptorProto.reservedRange: array expected");
                        message.reservedRange = [];
                        for (var i = 0; i < object.reservedRange.length; ++i) {
                            if (typeof object.reservedRange[i] !== "object")
                                throw TypeError(".google.protobuf.EnumDescriptorProto.reservedRange: object expected");
                            message.reservedRange[i] = $root.google.protobuf.EnumDescriptorProto.EnumReservedRange.fromObject(object.reservedRange[i]);
                        }
                    }
                    if (object.reservedName) {
                        if (!Array.isArray(object.reservedName))
                            throw TypeError(".google.protobuf.EnumDescriptorProto.reservedName: array expected");
                        message.reservedName = [];
                        for (var i = 0; i < object.reservedName.length; ++i)
                            message.reservedName[i] = String(object.reservedName[i]);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an EnumDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @static
                 * @param {google.protobuf.EnumDescriptorProto} message EnumDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                EnumDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults) {
                        object.value = [];
                        object.reservedRange = [];
                        object.reservedName = [];
                    }
                    if (options.defaults) {
                        object.name = "";
                        object.options = null;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.value && message.value.length) {
                        object.value = [];
                        for (var j = 0; j < message.value.length; ++j)
                            object.value[j] = $root.google.protobuf.EnumValueDescriptorProto.toObject(message.value[j], options);
                    }
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.EnumOptions.toObject(message.options, options);
                    if (message.reservedRange && message.reservedRange.length) {
                        object.reservedRange = [];
                        for (var j = 0; j < message.reservedRange.length; ++j)
                            object.reservedRange[j] = $root.google.protobuf.EnumDescriptorProto.EnumReservedRange.toObject(message.reservedRange[j], options);
                    }
                    if (message.reservedName && message.reservedName.length) {
                        object.reservedName = [];
                        for (var j = 0; j < message.reservedName.length; ++j)
                            object.reservedName[j] = message.reservedName[j];
                    }
                    return object;
                };

                /**
                 * Converts this EnumDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.EnumDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                EnumDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                EnumDescriptorProto.EnumReservedRange = (function() {

                    /**
                     * Properties of an EnumReservedRange.
                     * @memberof google.protobuf.EnumDescriptorProto
                     * @interface IEnumReservedRange
                     * @property {number|null} [start] EnumReservedRange start
                     * @property {number|null} [end] EnumReservedRange end
                     */

                    /**
                     * Constructs a new EnumReservedRange.
                     * @memberof google.protobuf.EnumDescriptorProto
                     * @classdesc Represents an EnumReservedRange.
                     * @implements IEnumReservedRange
                     * @constructor
                     * @param {google.protobuf.EnumDescriptorProto.IEnumReservedRange=} [properties] Properties to set
                     */
                    function EnumReservedRange(properties) {
                        if (properties)
                            for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                                if (properties[keys[i]] != null)
                                    this[keys[i]] = properties[keys[i]];
                    }

                    /**
                     * EnumReservedRange start.
                     * @member {number} start
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @instance
                     */
                    EnumReservedRange.prototype.start = 0;

                    /**
                     * EnumReservedRange end.
                     * @member {number} end
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @instance
                     */
                    EnumReservedRange.prototype.end = 0;

                    /**
                     * Creates a new EnumReservedRange instance using the specified properties.
                     * @function create
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {google.protobuf.EnumDescriptorProto.IEnumReservedRange=} [properties] Properties to set
                     * @returns {google.protobuf.EnumDescriptorProto.EnumReservedRange} EnumReservedRange instance
                     */
                    EnumReservedRange.create = function create(properties) {
                        return new EnumReservedRange(properties);
                    };

                    /**
                     * Encodes the specified EnumReservedRange message. Does not implicitly {@link google.protobuf.EnumDescriptorProto.EnumReservedRange.verify|verify} messages.
                     * @function encode
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {google.protobuf.EnumDescriptorProto.IEnumReservedRange} message EnumReservedRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    EnumReservedRange.encode = function encode(message, writer) {
                        if (!writer)
                            writer = $Writer.create();
                        if (message.start != null && Object.hasOwnProperty.call(message, "start"))
                            writer.uint32(/* id 1, wireType 0 =*/8).int32(message.start);
                        if (message.end != null && Object.hasOwnProperty.call(message, "end"))
                            writer.uint32(/* id 2, wireType 0 =*/16).int32(message.end);
                        return writer;
                    };

                    /**
                     * Encodes the specified EnumReservedRange message, length delimited. Does not implicitly {@link google.protobuf.EnumDescriptorProto.EnumReservedRange.verify|verify} messages.
                     * @function encodeDelimited
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {google.protobuf.EnumDescriptorProto.IEnumReservedRange} message EnumReservedRange message or plain object to encode
                     * @param {$protobuf.Writer} [writer] Writer to encode to
                     * @returns {$protobuf.Writer} Writer
                     */
                    EnumReservedRange.encodeDelimited = function encodeDelimited(message, writer) {
                        return this.encode(message, writer).ldelim();
                    };

                    /**
                     * Decodes an EnumReservedRange message from the specified reader or buffer.
                     * @function decode
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @param {number} [length] Message length if known beforehand
                     * @returns {google.protobuf.EnumDescriptorProto.EnumReservedRange} EnumReservedRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    EnumReservedRange.decode = function decode(reader, length) {
                        if (!(reader instanceof $Reader))
                            reader = $Reader.create(reader);
                        var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumDescriptorProto.EnumReservedRange();
                        while (reader.pos < end) {
                            var tag = reader.uint32();
                            switch (tag >>> 3) {
                            case 1:
                                message.start = reader.int32();
                                break;
                            case 2:
                                message.end = reader.int32();
                                break;
                            default:
                                reader.skipType(tag & 7);
                                break;
                            }
                        }
                        return message;
                    };

                    /**
                     * Decodes an EnumReservedRange message from the specified reader or buffer, length delimited.
                     * @function decodeDelimited
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                     * @returns {google.protobuf.EnumDescriptorProto.EnumReservedRange} EnumReservedRange
                     * @throws {Error} If the payload is not a reader or valid buffer
                     * @throws {$protobuf.util.ProtocolError} If required fields are missing
                     */
                    EnumReservedRange.decodeDelimited = function decodeDelimited(reader) {
                        if (!(reader instanceof $Reader))
                            reader = new $Reader(reader);
                        return this.decode(reader, reader.uint32());
                    };

                    /**
                     * Verifies an EnumReservedRange message.
                     * @function verify
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {Object.<string,*>} message Plain object to verify
                     * @returns {string|null} `null` if valid, otherwise the reason why it is not
                     */
                    EnumReservedRange.verify = function verify(message) {
                        if (typeof message !== "object" || message === null)
                            return "object expected";
                        if (message.start != null && message.hasOwnProperty("start"))
                            if (!$util.isInteger(message.start))
                                return "start: integer expected";
                        if (message.end != null && message.hasOwnProperty("end"))
                            if (!$util.isInteger(message.end))
                                return "end: integer expected";
                        return null;
                    };

                    /**
                     * Creates an EnumReservedRange message from a plain object. Also converts values to their respective internal types.
                     * @function fromObject
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {Object.<string,*>} object Plain object
                     * @returns {google.protobuf.EnumDescriptorProto.EnumReservedRange} EnumReservedRange
                     */
                    EnumReservedRange.fromObject = function fromObject(object) {
                        if (object instanceof $root.google.protobuf.EnumDescriptorProto.EnumReservedRange)
                            return object;
                        var message = new $root.google.protobuf.EnumDescriptorProto.EnumReservedRange();
                        if (object.start != null)
                            message.start = object.start | 0;
                        if (object.end != null)
                            message.end = object.end | 0;
                        return message;
                    };

                    /**
                     * Creates a plain object from an EnumReservedRange message. Also converts values to other types if specified.
                     * @function toObject
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @static
                     * @param {google.protobuf.EnumDescriptorProto.EnumReservedRange} message EnumReservedRange
                     * @param {$protobuf.IConversionOptions} [options] Conversion options
                     * @returns {Object.<string,*>} Plain object
                     */
                    EnumReservedRange.toObject = function toObject(message, options) {
                        if (!options)
                            options = {};
                        var object = {};
                        if (options.defaults) {
                            object.start = 0;
                            object.end = 0;
                        }
                        if (message.start != null && message.hasOwnProperty("start"))
                            object.start = message.start;
                        if (message.end != null && message.hasOwnProperty("end"))
                            object.end = message.end;
                        return object;
                    };

                    /**
                     * Converts this EnumReservedRange to JSON.
                     * @function toJSON
                     * @memberof google.protobuf.EnumDescriptorProto.EnumReservedRange
                     * @instance
                     * @returns {Object.<string,*>} JSON object
                     */
                    EnumReservedRange.prototype.toJSON = function toJSON() {
                        return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                    };

                    return EnumReservedRange;
                })();

                return EnumDescriptorProto;
            })();

            protobuf.EnumValueDescriptorProto = (function() {

                /**
                 * Properties of an EnumValueDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IEnumValueDescriptorProto
                 * @property {string|null} [name] EnumValueDescriptorProto name
                 * @property {number|null} [number] EnumValueDescriptorProto number
                 * @property {google.protobuf.IEnumValueOptions|null} [options] EnumValueDescriptorProto options
                 */

                /**
                 * Constructs a new EnumValueDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents an EnumValueDescriptorProto.
                 * @implements IEnumValueDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IEnumValueDescriptorProto=} [properties] Properties to set
                 */
                function EnumValueDescriptorProto(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * EnumValueDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @instance
                 */
                EnumValueDescriptorProto.prototype.name = "";

                /**
                 * EnumValueDescriptorProto number.
                 * @member {number} number
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @instance
                 */
                EnumValueDescriptorProto.prototype.number = 0;

                /**
                 * EnumValueDescriptorProto options.
                 * @member {google.protobuf.IEnumValueOptions|null|undefined} options
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @instance
                 */
                EnumValueDescriptorProto.prototype.options = null;

                /**
                 * Creates a new EnumValueDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {google.protobuf.IEnumValueDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto instance
                 */
                EnumValueDescriptorProto.create = function create(properties) {
                    return new EnumValueDescriptorProto(properties);
                };

                /**
                 * Encodes the specified EnumValueDescriptorProto message. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {google.protobuf.IEnumValueDescriptorProto} message EnumValueDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumValueDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.number != null && Object.hasOwnProperty.call(message, "number"))
                        writer.uint32(/* id 2, wireType 0 =*/16).int32(message.number);
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.EnumValueOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified EnumValueDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.EnumValueDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {google.protobuf.IEnumValueDescriptorProto} message EnumValueDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumValueDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an EnumValueDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumValueDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumValueDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message.number = reader.int32();
                            break;
                        case 3:
                            message.options = $root.google.protobuf.EnumValueOptions.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an EnumValueDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumValueDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an EnumValueDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                EnumValueDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.number != null && message.hasOwnProperty("number"))
                        if (!$util.isInteger(message.number))
                            return "number: integer expected";
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.EnumValueOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    return null;
                };

                /**
                 * Creates an EnumValueDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.EnumValueDescriptorProto} EnumValueDescriptorProto
                 */
                EnumValueDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.EnumValueDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.EnumValueDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.number != null)
                        message.number = object.number | 0;
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.EnumValueDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.EnumValueOptions.fromObject(object.options);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an EnumValueDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @static
                 * @param {google.protobuf.EnumValueDescriptorProto} message EnumValueDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                EnumValueDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.name = "";
                        object.number = 0;
                        object.options = null;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.number != null && message.hasOwnProperty("number"))
                        object.number = message.number;
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.EnumValueOptions.toObject(message.options, options);
                    return object;
                };

                /**
                 * Converts this EnumValueDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.EnumValueDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                EnumValueDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return EnumValueDescriptorProto;
            })();

            protobuf.ServiceDescriptorProto = (function() {

                /**
                 * Properties of a ServiceDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IServiceDescriptorProto
                 * @property {string|null} [name] ServiceDescriptorProto name
                 * @property {Array.<google.protobuf.IMethodDescriptorProto>|null} [method] ServiceDescriptorProto method
                 * @property {google.protobuf.IServiceOptions|null} [options] ServiceDescriptorProto options
                 */

                /**
                 * Constructs a new ServiceDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a ServiceDescriptorProto.
                 * @implements IServiceDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IServiceDescriptorProto=} [properties] Properties to set
                 */
                function ServiceDescriptorProto(properties) {
                    this.method = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * ServiceDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @instance
                 */
                ServiceDescriptorProto.prototype.name = "";

                /**
                 * ServiceDescriptorProto method.
                 * @member {Array.<google.protobuf.IMethodDescriptorProto>} method
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @instance
                 */
                ServiceDescriptorProto.prototype.method = $util.emptyArray;

                /**
                 * ServiceDescriptorProto options.
                 * @member {google.protobuf.IServiceOptions|null|undefined} options
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @instance
                 */
                ServiceDescriptorProto.prototype.options = null;

                /**
                 * Creates a new ServiceDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {google.protobuf.IServiceDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto instance
                 */
                ServiceDescriptorProto.create = function create(properties) {
                    return new ServiceDescriptorProto(properties);
                };

                /**
                 * Encodes the specified ServiceDescriptorProto message. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {google.protobuf.IServiceDescriptorProto} message ServiceDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ServiceDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.method != null && message.method.length)
                        for (var i = 0; i < message.method.length; ++i)
                            $root.google.protobuf.MethodDescriptorProto.encode(message.method[i], writer.uint32(/* id 2, wireType 2 =*/18).fork()).ldelim();
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.ServiceOptions.encode(message.options, writer.uint32(/* id 3, wireType 2 =*/26).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified ServiceDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.ServiceDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {google.protobuf.IServiceDescriptorProto} message ServiceDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ServiceDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a ServiceDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ServiceDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ServiceDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            if (!(message.method && message.method.length))
                                message.method = [];
                            message.method.push($root.google.protobuf.MethodDescriptorProto.decode(reader, reader.uint32()));
                            break;
                        case 3:
                            message.options = $root.google.protobuf.ServiceOptions.decode(reader, reader.uint32());
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a ServiceDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ServiceDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a ServiceDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ServiceDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.method != null && message.hasOwnProperty("method")) {
                        if (!Array.isArray(message.method))
                            return "method: array expected";
                        for (var i = 0; i < message.method.length; ++i) {
                            var error = $root.google.protobuf.MethodDescriptorProto.verify(message.method[i]);
                            if (error)
                                return "method." + error;
                        }
                    }
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.ServiceOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    return null;
                };

                /**
                 * Creates a ServiceDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.ServiceDescriptorProto} ServiceDescriptorProto
                 */
                ServiceDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.ServiceDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.ServiceDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.method) {
                        if (!Array.isArray(object.method))
                            throw TypeError(".google.protobuf.ServiceDescriptorProto.method: array expected");
                        message.method = [];
                        for (var i = 0; i < object.method.length; ++i) {
                            if (typeof object.method[i] !== "object")
                                throw TypeError(".google.protobuf.ServiceDescriptorProto.method: object expected");
                            message.method[i] = $root.google.protobuf.MethodDescriptorProto.fromObject(object.method[i]);
                        }
                    }
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.ServiceDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.ServiceOptions.fromObject(object.options);
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a ServiceDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @static
                 * @param {google.protobuf.ServiceDescriptorProto} message ServiceDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                ServiceDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.method = [];
                    if (options.defaults) {
                        object.name = "";
                        object.options = null;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.method && message.method.length) {
                        object.method = [];
                        for (var j = 0; j < message.method.length; ++j)
                            object.method[j] = $root.google.protobuf.MethodDescriptorProto.toObject(message.method[j], options);
                    }
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.ServiceOptions.toObject(message.options, options);
                    return object;
                };

                /**
                 * Converts this ServiceDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.ServiceDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                ServiceDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return ServiceDescriptorProto;
            })();

            protobuf.MethodDescriptorProto = (function() {

                /**
                 * Properties of a MethodDescriptorProto.
                 * @memberof google.protobuf
                 * @interface IMethodDescriptorProto
                 * @property {string|null} [name] MethodDescriptorProto name
                 * @property {string|null} [inputType] MethodDescriptorProto inputType
                 * @property {string|null} [outputType] MethodDescriptorProto outputType
                 * @property {google.protobuf.IMethodOptions|null} [options] MethodDescriptorProto options
                 * @property {boolean|null} [clientStreaming] MethodDescriptorProto clientStreaming
                 * @property {boolean|null} [serverStreaming] MethodDescriptorProto serverStreaming
                 */

                /**
                 * Constructs a new MethodDescriptorProto.
                 * @memberof google.protobuf
                 * @classdesc Represents a MethodDescriptorProto.
                 * @implements IMethodDescriptorProto
                 * @constructor
                 * @param {google.protobuf.IMethodDescriptorProto=} [properties] Properties to set
                 */
                function MethodDescriptorProto(properties) {
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * MethodDescriptorProto name.
                 * @member {string} name
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 */
                MethodDescriptorProto.prototype.name = "";

                /**
                 * MethodDescriptorProto inputType.
                 * @member {string} inputType
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 */
                MethodDescriptorProto.prototype.inputType = "";

                /**
                 * MethodDescriptorProto outputType.
                 * @member {string} outputType
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 */
                MethodDescriptorProto.prototype.outputType = "";

                /**
                 * MethodDescriptorProto options.
                 * @member {google.protobuf.IMethodOptions|null|undefined} options
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 */
                MethodDescriptorProto.prototype.options = null;

                /**
                 * MethodDescriptorProto clientStreaming.
                 * @member {boolean} clientStreaming
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 */
                MethodDescriptorProto.prototype.clientStreaming = false;

                /**
                 * MethodDescriptorProto serverStreaming.
                 * @member {boolean} serverStreaming
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 */
                MethodDescriptorProto.prototype.serverStreaming = false;

                /**
                 * Creates a new MethodDescriptorProto instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {google.protobuf.IMethodDescriptorProto=} [properties] Properties to set
                 * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto instance
                 */
                MethodDescriptorProto.create = function create(properties) {
                    return new MethodDescriptorProto(properties);
                };

                /**
                 * Encodes the specified MethodDescriptorProto message. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {google.protobuf.IMethodDescriptorProto} message MethodDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                MethodDescriptorProto.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.name != null && Object.hasOwnProperty.call(message, "name"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.name);
                    if (message.inputType != null && Object.hasOwnProperty.call(message, "inputType"))
                        writer.uint32(/* id 2, wireType 2 =*/18).string(message.inputType);
                    if (message.outputType != null && Object.hasOwnProperty.call(message, "outputType"))
                        writer.uint32(/* id 3, wireType 2 =*/26).string(message.outputType);
                    if (message.options != null && Object.hasOwnProperty.call(message, "options"))
                        $root.google.protobuf.MethodOptions.encode(message.options, writer.uint32(/* id 4, wireType 2 =*/34).fork()).ldelim();
                    if (message.clientStreaming != null && Object.hasOwnProperty.call(message, "clientStreaming"))
                        writer.uint32(/* id 5, wireType 0 =*/40).bool(message.clientStreaming);
                    if (message.serverStreaming != null && Object.hasOwnProperty.call(message, "serverStreaming"))
                        writer.uint32(/* id 6, wireType 0 =*/48).bool(message.serverStreaming);
                    return writer;
                };

                /**
                 * Encodes the specified MethodDescriptorProto message, length delimited. Does not implicitly {@link google.protobuf.MethodDescriptorProto.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {google.protobuf.IMethodDescriptorProto} message MethodDescriptorProto message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                MethodDescriptorProto.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a MethodDescriptorProto message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                MethodDescriptorProto.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MethodDescriptorProto();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.name = reader.string();
                            break;
                        case 2:
                            message.inputType = reader.string();
                            break;
                        case 3:
                            message.outputType = reader.string();
                            break;
                        case 4:
                            message.options = $root.google.protobuf.MethodOptions.decode(reader, reader.uint32());
                            break;
                        case 5:
                            message.clientStreaming = reader.bool();
                            break;
                        case 6:
                            message.serverStreaming = reader.bool();
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a MethodDescriptorProto message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                MethodDescriptorProto.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a MethodDescriptorProto message.
                 * @function verify
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                MethodDescriptorProto.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.name != null && message.hasOwnProperty("name"))
                        if (!$util.isString(message.name))
                            return "name: string expected";
                    if (message.inputType != null && message.hasOwnProperty("inputType"))
                        if (!$util.isString(message.inputType))
                            return "inputType: string expected";
                    if (message.outputType != null && message.hasOwnProperty("outputType"))
                        if (!$util.isString(message.outputType))
                            return "outputType: string expected";
                    if (message.options != null && message.hasOwnProperty("options")) {
                        var error = $root.google.protobuf.MethodOptions.verify(message.options);
                        if (error)
                            return "options." + error;
                    }
                    if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
                        if (typeof message.clientStreaming !== "boolean")
                            return "clientStreaming: boolean expected";
                    if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
                        if (typeof message.serverStreaming !== "boolean")
                            return "serverStreaming: boolean expected";
                    return null;
                };

                /**
                 * Creates a MethodDescriptorProto message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.MethodDescriptorProto} MethodDescriptorProto
                 */
                MethodDescriptorProto.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.MethodDescriptorProto)
                        return object;
                    var message = new $root.google.protobuf.MethodDescriptorProto();
                    if (object.name != null)
                        message.name = String(object.name);
                    if (object.inputType != null)
                        message.inputType = String(object.inputType);
                    if (object.outputType != null)
                        message.outputType = String(object.outputType);
                    if (object.options != null) {
                        if (typeof object.options !== "object")
                            throw TypeError(".google.protobuf.MethodDescriptorProto.options: object expected");
                        message.options = $root.google.protobuf.MethodOptions.fromObject(object.options);
                    }
                    if (object.clientStreaming != null)
                        message.clientStreaming = Boolean(object.clientStreaming);
                    if (object.serverStreaming != null)
                        message.serverStreaming = Boolean(object.serverStreaming);
                    return message;
                };

                /**
                 * Creates a plain object from a MethodDescriptorProto message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @static
                 * @param {google.protobuf.MethodDescriptorProto} message MethodDescriptorProto
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                MethodDescriptorProto.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.defaults) {
                        object.name = "";
                        object.inputType = "";
                        object.outputType = "";
                        object.options = null;
                        object.clientStreaming = false;
                        object.serverStreaming = false;
                    }
                    if (message.name != null && message.hasOwnProperty("name"))
                        object.name = message.name;
                    if (message.inputType != null && message.hasOwnProperty("inputType"))
                        object.inputType = message.inputType;
                    if (message.outputType != null && message.hasOwnProperty("outputType"))
                        object.outputType = message.outputType;
                    if (message.options != null && message.hasOwnProperty("options"))
                        object.options = $root.google.protobuf.MethodOptions.toObject(message.options, options);
                    if (message.clientStreaming != null && message.hasOwnProperty("clientStreaming"))
                        object.clientStreaming = message.clientStreaming;
                    if (message.serverStreaming != null && message.hasOwnProperty("serverStreaming"))
                        object.serverStreaming = message.serverStreaming;
                    return object;
                };

                /**
                 * Converts this MethodDescriptorProto to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.MethodDescriptorProto
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                MethodDescriptorProto.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return MethodDescriptorProto;
            })();

            protobuf.FileOptions = (function() {

                /**
                 * Properties of a FileOptions.
                 * @memberof google.protobuf
                 * @interface IFileOptions
                 * @property {string|null} [javaPackage] FileOptions javaPackage
                 * @property {string|null} [javaOuterClassname] FileOptions javaOuterClassname
                 * @property {boolean|null} [javaMultipleFiles] FileOptions javaMultipleFiles
                 * @property {boolean|null} [javaGenerateEqualsAndHash] FileOptions javaGenerateEqualsAndHash
                 * @property {boolean|null} [javaStringCheckUtf8] FileOptions javaStringCheckUtf8
                 * @property {google.protobuf.FileOptions.OptimizeMode|null} [optimizeFor] FileOptions optimizeFor
                 * @property {string|null} [goPackage] FileOptions goPackage
                 * @property {boolean|null} [ccGenericServices] FileOptions ccGenericServices
                 * @property {boolean|null} [javaGenericServices] FileOptions javaGenericServices
                 * @property {boolean|null} [pyGenericServices] FileOptions pyGenericServices
                 * @property {boolean|null} [phpGenericServices] FileOptions phpGenericServices
                 * @property {boolean|null} [deprecated] FileOptions deprecated
                 * @property {boolean|null} [ccEnableArenas] FileOptions ccEnableArenas
                 * @property {string|null} [objcClassPrefix] FileOptions objcClassPrefix
                 * @property {string|null} [csharpNamespace] FileOptions csharpNamespace
                 * @property {string|null} [swiftPrefix] FileOptions swiftPrefix
                 * @property {string|null} [phpClassPrefix] FileOptions phpClassPrefix
                 * @property {string|null} [phpNamespace] FileOptions phpNamespace
                 * @property {string|null} [phpMetadataNamespace] FileOptions phpMetadataNamespace
                 * @property {string|null} [rubyPackage] FileOptions rubyPackage
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] FileOptions uninterpretedOption
                 */

                /**
                 * Constructs a new FileOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents a FileOptions.
                 * @implements IFileOptions
                 * @constructor
                 * @param {google.protobuf.IFileOptions=} [properties] Properties to set
                 */
                function FileOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * FileOptions javaPackage.
                 * @member {string} javaPackage
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.javaPackage = "";

                /**
                 * FileOptions javaOuterClassname.
                 * @member {string} javaOuterClassname
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.javaOuterClassname = "";

                /**
                 * FileOptions javaMultipleFiles.
                 * @member {boolean} javaMultipleFiles
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.javaMultipleFiles = false;

                /**
                 * FileOptions javaGenerateEqualsAndHash.
                 * @member {boolean} javaGenerateEqualsAndHash
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.javaGenerateEqualsAndHash = false;

                /**
                 * FileOptions javaStringCheckUtf8.
                 * @member {boolean} javaStringCheckUtf8
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.javaStringCheckUtf8 = false;

                /**
                 * FileOptions optimizeFor.
                 * @member {google.protobuf.FileOptions.OptimizeMode} optimizeFor
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.optimizeFor = 1;

                /**
                 * FileOptions goPackage.
                 * @member {string} goPackage
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.goPackage = "";

                /**
                 * FileOptions ccGenericServices.
                 * @member {boolean} ccGenericServices
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.ccGenericServices = false;

                /**
                 * FileOptions javaGenericServices.
                 * @member {boolean} javaGenericServices
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.javaGenericServices = false;

                /**
                 * FileOptions pyGenericServices.
                 * @member {boolean} pyGenericServices
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.pyGenericServices = false;

                /**
                 * FileOptions phpGenericServices.
                 * @member {boolean} phpGenericServices
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.phpGenericServices = false;

                /**
                 * FileOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.deprecated = false;

                /**
                 * FileOptions ccEnableArenas.
                 * @member {boolean} ccEnableArenas
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.ccEnableArenas = true;

                /**
                 * FileOptions objcClassPrefix.
                 * @member {string} objcClassPrefix
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.objcClassPrefix = "";

                /**
                 * FileOptions csharpNamespace.
                 * @member {string} csharpNamespace
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.csharpNamespace = "";

                /**
                 * FileOptions swiftPrefix.
                 * @member {string} swiftPrefix
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.swiftPrefix = "";

                /**
                 * FileOptions phpClassPrefix.
                 * @member {string} phpClassPrefix
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.phpClassPrefix = "";

                /**
                 * FileOptions phpNamespace.
                 * @member {string} phpNamespace
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.phpNamespace = "";

                /**
                 * FileOptions phpMetadataNamespace.
                 * @member {string} phpMetadataNamespace
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.phpMetadataNamespace = "";

                /**
                 * FileOptions rubyPackage.
                 * @member {string} rubyPackage
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.rubyPackage = "";

                /**
                 * FileOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 */
                FileOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new FileOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {google.protobuf.IFileOptions=} [properties] Properties to set
                 * @returns {google.protobuf.FileOptions} FileOptions instance
                 */
                FileOptions.create = function create(properties) {
                    return new FileOptions(properties);
                };

                /**
                 * Encodes the specified FileOptions message. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {google.protobuf.IFileOptions} message FileOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.javaPackage != null && Object.hasOwnProperty.call(message, "javaPackage"))
                        writer.uint32(/* id 1, wireType 2 =*/10).string(message.javaPackage);
                    if (message.javaOuterClassname != null && Object.hasOwnProperty.call(message, "javaOuterClassname"))
                        writer.uint32(/* id 8, wireType 2 =*/66).string(message.javaOuterClassname);
                    if (message.optimizeFor != null && Object.hasOwnProperty.call(message, "optimizeFor"))
                        writer.uint32(/* id 9, wireType 0 =*/72).int32(message.optimizeFor);
                    if (message.javaMultipleFiles != null && Object.hasOwnProperty.call(message, "javaMultipleFiles"))
                        writer.uint32(/* id 10, wireType 0 =*/80).bool(message.javaMultipleFiles);
                    if (message.goPackage != null && Object.hasOwnProperty.call(message, "goPackage"))
                        writer.uint32(/* id 11, wireType 2 =*/90).string(message.goPackage);
                    if (message.ccGenericServices != null && Object.hasOwnProperty.call(message, "ccGenericServices"))
                        writer.uint32(/* id 16, wireType 0 =*/128).bool(message.ccGenericServices);
                    if (message.javaGenericServices != null && Object.hasOwnProperty.call(message, "javaGenericServices"))
                        writer.uint32(/* id 17, wireType 0 =*/136).bool(message.javaGenericServices);
                    if (message.pyGenericServices != null && Object.hasOwnProperty.call(message, "pyGenericServices"))
                        writer.uint32(/* id 18, wireType 0 =*/144).bool(message.pyGenericServices);
                    if (message.javaGenerateEqualsAndHash != null && Object.hasOwnProperty.call(message, "javaGenerateEqualsAndHash"))
                        writer.uint32(/* id 20, wireType 0 =*/160).bool(message.javaGenerateEqualsAndHash);
                    if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                        writer.uint32(/* id 23, wireType 0 =*/184).bool(message.deprecated);
                    if (message.javaStringCheckUtf8 != null && Object.hasOwnProperty.call(message, "javaStringCheckUtf8"))
                        writer.uint32(/* id 27, wireType 0 =*/216).bool(message.javaStringCheckUtf8);
                    if (message.ccEnableArenas != null && Object.hasOwnProperty.call(message, "ccEnableArenas"))
                        writer.uint32(/* id 31, wireType 0 =*/248).bool(message.ccEnableArenas);
                    if (message.objcClassPrefix != null && Object.hasOwnProperty.call(message, "objcClassPrefix"))
                        writer.uint32(/* id 36, wireType 2 =*/290).string(message.objcClassPrefix);
                    if (message.csharpNamespace != null && Object.hasOwnProperty.call(message, "csharpNamespace"))
                        writer.uint32(/* id 37, wireType 2 =*/298).string(message.csharpNamespace);
                    if (message.swiftPrefix != null && Object.hasOwnProperty.call(message, "swiftPrefix"))
                        writer.uint32(/* id 39, wireType 2 =*/314).string(message.swiftPrefix);
                    if (message.phpClassPrefix != null && Object.hasOwnProperty.call(message, "phpClassPrefix"))
                        writer.uint32(/* id 40, wireType 2 =*/322).string(message.phpClassPrefix);
                    if (message.phpNamespace != null && Object.hasOwnProperty.call(message, "phpNamespace"))
                        writer.uint32(/* id 41, wireType 2 =*/330).string(message.phpNamespace);
                    if (message.phpGenericServices != null && Object.hasOwnProperty.call(message, "phpGenericServices"))
                        writer.uint32(/* id 42, wireType 0 =*/336).bool(message.phpGenericServices);
                    if (message.phpMetadataNamespace != null && Object.hasOwnProperty.call(message, "phpMetadataNamespace"))
                        writer.uint32(/* id 44, wireType 2 =*/354).string(message.phpMetadataNamespace);
                    if (message.rubyPackage != null && Object.hasOwnProperty.call(message, "rubyPackage"))
                        writer.uint32(/* id 45, wireType 2 =*/362).string(message.rubyPackage);
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified FileOptions message, length delimited. Does not implicitly {@link google.protobuf.FileOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {google.protobuf.IFileOptions} message FileOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FileOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a FileOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FileOptions} FileOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FileOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.javaPackage = reader.string();
                            break;
                        case 8:
                            message.javaOuterClassname = reader.string();
                            break;
                        case 10:
                            message.javaMultipleFiles = reader.bool();
                            break;
                        case 20:
                            message.javaGenerateEqualsAndHash = reader.bool();
                            break;
                        case 27:
                            message.javaStringCheckUtf8 = reader.bool();
                            break;
                        case 9:
                            message.optimizeFor = reader.int32();
                            break;
                        case 11:
                            message.goPackage = reader.string();
                            break;
                        case 16:
                            message.ccGenericServices = reader.bool();
                            break;
                        case 17:
                            message.javaGenericServices = reader.bool();
                            break;
                        case 18:
                            message.pyGenericServices = reader.bool();
                            break;
                        case 42:
                            message.phpGenericServices = reader.bool();
                            break;
                        case 23:
                            message.deprecated = reader.bool();
                            break;
                        case 31:
                            message.ccEnableArenas = reader.bool();
                            break;
                        case 36:
                            message.objcClassPrefix = reader.string();
                            break;
                        case 37:
                            message.csharpNamespace = reader.string();
                            break;
                        case 39:
                            message.swiftPrefix = reader.string();
                            break;
                        case 40:
                            message.phpClassPrefix = reader.string();
                            break;
                        case 41:
                            message.phpNamespace = reader.string();
                            break;
                        case 44:
                            message.phpMetadataNamespace = reader.string();
                            break;
                        case 45:
                            message.rubyPackage = reader.string();
                            break;
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a FileOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FileOptions} FileOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FileOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a FileOptions message.
                 * @function verify
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FileOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
                        if (!$util.isString(message.javaPackage))
                            return "javaPackage: string expected";
                    if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
                        if (!$util.isString(message.javaOuterClassname))
                            return "javaOuterClassname: string expected";
                    if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
                        if (typeof message.javaMultipleFiles !== "boolean")
                            return "javaMultipleFiles: boolean expected";
                    if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
                        if (typeof message.javaGenerateEqualsAndHash !== "boolean")
                            return "javaGenerateEqualsAndHash: boolean expected";
                    if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
                        if (typeof message.javaStringCheckUtf8 !== "boolean")
                            return "javaStringCheckUtf8: boolean expected";
                    if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
                        switch (message.optimizeFor) {
                        default:
                            return "optimizeFor: enum value expected";
                        case 1:
                        case 2:
                        case 3:
                            break;
                        }
                    if (message.goPackage != null && message.hasOwnProperty("goPackage"))
                        if (!$util.isString(message.goPackage))
                            return "goPackage: string expected";
                    if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
                        if (typeof message.ccGenericServices !== "boolean")
                            return "ccGenericServices: boolean expected";
                    if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
                        if (typeof message.javaGenericServices !== "boolean")
                            return "javaGenericServices: boolean expected";
                    if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
                        if (typeof message.pyGenericServices !== "boolean")
                            return "pyGenericServices: boolean expected";
                    if (message.phpGenericServices != null && message.hasOwnProperty("phpGenericServices"))
                        if (typeof message.phpGenericServices !== "boolean")
                            return "phpGenericServices: boolean expected";
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        if (typeof message.deprecated !== "boolean")
                            return "deprecated: boolean expected";
                    if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
                        if (typeof message.ccEnableArenas !== "boolean")
                            return "ccEnableArenas: boolean expected";
                    if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
                        if (!$util.isString(message.objcClassPrefix))
                            return "objcClassPrefix: string expected";
                    if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
                        if (!$util.isString(message.csharpNamespace))
                            return "csharpNamespace: string expected";
                    if (message.swiftPrefix != null && message.hasOwnProperty("swiftPrefix"))
                        if (!$util.isString(message.swiftPrefix))
                            return "swiftPrefix: string expected";
                    if (message.phpClassPrefix != null && message.hasOwnProperty("phpClassPrefix"))
                        if (!$util.isString(message.phpClassPrefix))
                            return "phpClassPrefix: string expected";
                    if (message.phpNamespace != null && message.hasOwnProperty("phpNamespace"))
                        if (!$util.isString(message.phpNamespace))
                            return "phpNamespace: string expected";
                    if (message.phpMetadataNamespace != null && message.hasOwnProperty("phpMetadataNamespace"))
                        if (!$util.isString(message.phpMetadataNamespace))
                            return "phpMetadataNamespace: string expected";
                    if (message.rubyPackage != null && message.hasOwnProperty("rubyPackage"))
                        if (!$util.isString(message.rubyPackage))
                            return "rubyPackage: string expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a FileOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FileOptions} FileOptions
                 */
                FileOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FileOptions)
                        return object;
                    var message = new $root.google.protobuf.FileOptions();
                    if (object.javaPackage != null)
                        message.javaPackage = String(object.javaPackage);
                    if (object.javaOuterClassname != null)
                        message.javaOuterClassname = String(object.javaOuterClassname);
                    if (object.javaMultipleFiles != null)
                        message.javaMultipleFiles = Boolean(object.javaMultipleFiles);
                    if (object.javaGenerateEqualsAndHash != null)
                        message.javaGenerateEqualsAndHash = Boolean(object.javaGenerateEqualsAndHash);
                    if (object.javaStringCheckUtf8 != null)
                        message.javaStringCheckUtf8 = Boolean(object.javaStringCheckUtf8);
                    switch (object.optimizeFor) {
                    case "SPEED":
                    case 1:
                        message.optimizeFor = 1;
                        break;
                    case "CODE_SIZE":
                    case 2:
                        message.optimizeFor = 2;
                        break;
                    case "LITE_RUNTIME":
                    case 3:
                        message.optimizeFor = 3;
                        break;
                    }
                    if (object.goPackage != null)
                        message.goPackage = String(object.goPackage);
                    if (object.ccGenericServices != null)
                        message.ccGenericServices = Boolean(object.ccGenericServices);
                    if (object.javaGenericServices != null)
                        message.javaGenericServices = Boolean(object.javaGenericServices);
                    if (object.pyGenericServices != null)
                        message.pyGenericServices = Boolean(object.pyGenericServices);
                    if (object.phpGenericServices != null)
                        message.phpGenericServices = Boolean(object.phpGenericServices);
                    if (object.deprecated != null)
                        message.deprecated = Boolean(object.deprecated);
                    if (object.ccEnableArenas != null)
                        message.ccEnableArenas = Boolean(object.ccEnableArenas);
                    if (object.objcClassPrefix != null)
                        message.objcClassPrefix = String(object.objcClassPrefix);
                    if (object.csharpNamespace != null)
                        message.csharpNamespace = String(object.csharpNamespace);
                    if (object.swiftPrefix != null)
                        message.swiftPrefix = String(object.swiftPrefix);
                    if (object.phpClassPrefix != null)
                        message.phpClassPrefix = String(object.phpClassPrefix);
                    if (object.phpNamespace != null)
                        message.phpNamespace = String(object.phpNamespace);
                    if (object.phpMetadataNamespace != null)
                        message.phpMetadataNamespace = String(object.phpMetadataNamespace);
                    if (object.rubyPackage != null)
                        message.rubyPackage = String(object.rubyPackage);
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.FileOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.FileOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a FileOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FileOptions
                 * @static
                 * @param {google.protobuf.FileOptions} message FileOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FileOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (options.defaults) {
                        object.javaPackage = "";
                        object.javaOuterClassname = "";
                        object.optimizeFor = options.enums === String ? "SPEED" : 1;
                        object.javaMultipleFiles = false;
                        object.goPackage = "";
                        object.ccGenericServices = false;
                        object.javaGenericServices = false;
                        object.pyGenericServices = false;
                        object.javaGenerateEqualsAndHash = false;
                        object.deprecated = false;
                        object.javaStringCheckUtf8 = false;
                        object.ccEnableArenas = true;
                        object.objcClassPrefix = "";
                        object.csharpNamespace = "";
                        object.swiftPrefix = "";
                        object.phpClassPrefix = "";
                        object.phpNamespace = "";
                        object.phpGenericServices = false;
                        object.phpMetadataNamespace = "";
                        object.rubyPackage = "";
                    }
                    if (message.javaPackage != null && message.hasOwnProperty("javaPackage"))
                        object.javaPackage = message.javaPackage;
                    if (message.javaOuterClassname != null && message.hasOwnProperty("javaOuterClassname"))
                        object.javaOuterClassname = message.javaOuterClassname;
                    if (message.optimizeFor != null && message.hasOwnProperty("optimizeFor"))
                        object.optimizeFor = options.enums === String ? $root.google.protobuf.FileOptions.OptimizeMode[message.optimizeFor] : message.optimizeFor;
                    if (message.javaMultipleFiles != null && message.hasOwnProperty("javaMultipleFiles"))
                        object.javaMultipleFiles = message.javaMultipleFiles;
                    if (message.goPackage != null && message.hasOwnProperty("goPackage"))
                        object.goPackage = message.goPackage;
                    if (message.ccGenericServices != null && message.hasOwnProperty("ccGenericServices"))
                        object.ccGenericServices = message.ccGenericServices;
                    if (message.javaGenericServices != null && message.hasOwnProperty("javaGenericServices"))
                        object.javaGenericServices = message.javaGenericServices;
                    if (message.pyGenericServices != null && message.hasOwnProperty("pyGenericServices"))
                        object.pyGenericServices = message.pyGenericServices;
                    if (message.javaGenerateEqualsAndHash != null && message.hasOwnProperty("javaGenerateEqualsAndHash"))
                        object.javaGenerateEqualsAndHash = message.javaGenerateEqualsAndHash;
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        object.deprecated = message.deprecated;
                    if (message.javaStringCheckUtf8 != null && message.hasOwnProperty("javaStringCheckUtf8"))
                        object.javaStringCheckUtf8 = message.javaStringCheckUtf8;
                    if (message.ccEnableArenas != null && message.hasOwnProperty("ccEnableArenas"))
                        object.ccEnableArenas = message.ccEnableArenas;
                    if (message.objcClassPrefix != null && message.hasOwnProperty("objcClassPrefix"))
                        object.objcClassPrefix = message.objcClassPrefix;
                    if (message.csharpNamespace != null && message.hasOwnProperty("csharpNamespace"))
                        object.csharpNamespace = message.csharpNamespace;
                    if (message.swiftPrefix != null && message.hasOwnProperty("swiftPrefix"))
                        object.swiftPrefix = message.swiftPrefix;
                    if (message.phpClassPrefix != null && message.hasOwnProperty("phpClassPrefix"))
                        object.phpClassPrefix = message.phpClassPrefix;
                    if (message.phpNamespace != null && message.hasOwnProperty("phpNamespace"))
                        object.phpNamespace = message.phpNamespace;
                    if (message.phpGenericServices != null && message.hasOwnProperty("phpGenericServices"))
                        object.phpGenericServices = message.phpGenericServices;
                    if (message.phpMetadataNamespace != null && message.hasOwnProperty("phpMetadataNamespace"))
                        object.phpMetadataNamespace = message.phpMetadataNamespace;
                    if (message.rubyPackage != null && message.hasOwnProperty("rubyPackage"))
                        object.rubyPackage = message.rubyPackage;
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this FileOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FileOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FileOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * OptimizeMode enum.
                 * @name google.protobuf.FileOptions.OptimizeMode
                 * @enum {number}
                 * @property {number} SPEED=1 SPEED value
                 * @property {number} CODE_SIZE=2 CODE_SIZE value
                 * @property {number} LITE_RUNTIME=3 LITE_RUNTIME value
                 */
                FileOptions.OptimizeMode = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[1] = "SPEED"] = 1;
                    values[valuesById[2] = "CODE_SIZE"] = 2;
                    values[valuesById[3] = "LITE_RUNTIME"] = 3;
                    return values;
                })();

                return FileOptions;
            })();

            protobuf.MessageOptions = (function() {

                /**
                 * Properties of a MessageOptions.
                 * @memberof google.protobuf
                 * @interface IMessageOptions
                 * @property {boolean|null} [messageSetWireFormat] MessageOptions messageSetWireFormat
                 * @property {boolean|null} [noStandardDescriptorAccessor] MessageOptions noStandardDescriptorAccessor
                 * @property {boolean|null} [deprecated] MessageOptions deprecated
                 * @property {boolean|null} [mapEntry] MessageOptions mapEntry
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] MessageOptions uninterpretedOption
                 */

                /**
                 * Constructs a new MessageOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents a MessageOptions.
                 * @implements IMessageOptions
                 * @constructor
                 * @param {google.protobuf.IMessageOptions=} [properties] Properties to set
                 */
                function MessageOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * MessageOptions messageSetWireFormat.
                 * @member {boolean} messageSetWireFormat
                 * @memberof google.protobuf.MessageOptions
                 * @instance
                 */
                MessageOptions.prototype.messageSetWireFormat = false;

                /**
                 * MessageOptions noStandardDescriptorAccessor.
                 * @member {boolean} noStandardDescriptorAccessor
                 * @memberof google.protobuf.MessageOptions
                 * @instance
                 */
                MessageOptions.prototype.noStandardDescriptorAccessor = false;

                /**
                 * MessageOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.MessageOptions
                 * @instance
                 */
                MessageOptions.prototype.deprecated = false;

                /**
                 * MessageOptions mapEntry.
                 * @member {boolean} mapEntry
                 * @memberof google.protobuf.MessageOptions
                 * @instance
                 */
                MessageOptions.prototype.mapEntry = false;

                /**
                 * MessageOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.MessageOptions
                 * @instance
                 */
                MessageOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new MessageOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {google.protobuf.IMessageOptions=} [properties] Properties to set
                 * @returns {google.protobuf.MessageOptions} MessageOptions instance
                 */
                MessageOptions.create = function create(properties) {
                    return new MessageOptions(properties);
                };

                /**
                 * Encodes the specified MessageOptions message. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {google.protobuf.IMessageOptions} message MessageOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                MessageOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.messageSetWireFormat != null && Object.hasOwnProperty.call(message, "messageSetWireFormat"))
                        writer.uint32(/* id 1, wireType 0 =*/8).bool(message.messageSetWireFormat);
                    if (message.noStandardDescriptorAccessor != null && Object.hasOwnProperty.call(message, "noStandardDescriptorAccessor"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.noStandardDescriptorAccessor);
                    if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                        writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
                    if (message.mapEntry != null && Object.hasOwnProperty.call(message, "mapEntry"))
                        writer.uint32(/* id 7, wireType 0 =*/56).bool(message.mapEntry);
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified MessageOptions message, length delimited. Does not implicitly {@link google.protobuf.MessageOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {google.protobuf.IMessageOptions} message MessageOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                MessageOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a MessageOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.MessageOptions} MessageOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                MessageOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.MessageOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.messageSetWireFormat = reader.bool();
                            break;
                        case 2:
                            message.noStandardDescriptorAccessor = reader.bool();
                            break;
                        case 3:
                            message.deprecated = reader.bool();
                            break;
                        case 7:
                            message.mapEntry = reader.bool();
                            break;
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a MessageOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.MessageOptions} MessageOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                MessageOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a MessageOptions message.
                 * @function verify
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                MessageOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
                        if (typeof message.messageSetWireFormat !== "boolean")
                            return "messageSetWireFormat: boolean expected";
                    if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
                        if (typeof message.noStandardDescriptorAccessor !== "boolean")
                            return "noStandardDescriptorAccessor: boolean expected";
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        if (typeof message.deprecated !== "boolean")
                            return "deprecated: boolean expected";
                    if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
                        if (typeof message.mapEntry !== "boolean")
                            return "mapEntry: boolean expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a MessageOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.MessageOptions} MessageOptions
                 */
                MessageOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.MessageOptions)
                        return object;
                    var message = new $root.google.protobuf.MessageOptions();
                    if (object.messageSetWireFormat != null)
                        message.messageSetWireFormat = Boolean(object.messageSetWireFormat);
                    if (object.noStandardDescriptorAccessor != null)
                        message.noStandardDescriptorAccessor = Boolean(object.noStandardDescriptorAccessor);
                    if (object.deprecated != null)
                        message.deprecated = Boolean(object.deprecated);
                    if (object.mapEntry != null)
                        message.mapEntry = Boolean(object.mapEntry);
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.MessageOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.MessageOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a MessageOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.MessageOptions
                 * @static
                 * @param {google.protobuf.MessageOptions} message MessageOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                MessageOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (options.defaults) {
                        object.messageSetWireFormat = false;
                        object.noStandardDescriptorAccessor = false;
                        object.deprecated = false;
                        object.mapEntry = false;
                    }
                    if (message.messageSetWireFormat != null && message.hasOwnProperty("messageSetWireFormat"))
                        object.messageSetWireFormat = message.messageSetWireFormat;
                    if (message.noStandardDescriptorAccessor != null && message.hasOwnProperty("noStandardDescriptorAccessor"))
                        object.noStandardDescriptorAccessor = message.noStandardDescriptorAccessor;
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        object.deprecated = message.deprecated;
                    if (message.mapEntry != null && message.hasOwnProperty("mapEntry"))
                        object.mapEntry = message.mapEntry;
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this MessageOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.MessageOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                MessageOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return MessageOptions;
            })();

            protobuf.FieldOptions = (function() {

                /**
                 * Properties of a FieldOptions.
                 * @memberof google.protobuf
                 * @interface IFieldOptions
                 * @property {google.protobuf.FieldOptions.CType|null} [ctype] FieldOptions ctype
                 * @property {boolean|null} [packed] FieldOptions packed
                 * @property {google.protobuf.FieldOptions.JSType|null} [jstype] FieldOptions jstype
                 * @property {boolean|null} [lazy] FieldOptions lazy
                 * @property {boolean|null} [deprecated] FieldOptions deprecated
                 * @property {boolean|null} [weak] FieldOptions weak
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] FieldOptions uninterpretedOption
                 */

                /**
                 * Constructs a new FieldOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents a FieldOptions.
                 * @implements IFieldOptions
                 * @constructor
                 * @param {google.protobuf.IFieldOptions=} [properties] Properties to set
                 */
                function FieldOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * FieldOptions ctype.
                 * @member {google.protobuf.FieldOptions.CType} ctype
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.ctype = 0;

                /**
                 * FieldOptions packed.
                 * @member {boolean} packed
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.packed = false;

                /**
                 * FieldOptions jstype.
                 * @member {google.protobuf.FieldOptions.JSType} jstype
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.jstype = 0;

                /**
                 * FieldOptions lazy.
                 * @member {boolean} lazy
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.lazy = false;

                /**
                 * FieldOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.deprecated = false;

                /**
                 * FieldOptions weak.
                 * @member {boolean} weak
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.weak = false;

                /**
                 * FieldOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 */
                FieldOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new FieldOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {google.protobuf.IFieldOptions=} [properties] Properties to set
                 * @returns {google.protobuf.FieldOptions} FieldOptions instance
                 */
                FieldOptions.create = function create(properties) {
                    return new FieldOptions(properties);
                };

                /**
                 * Encodes the specified FieldOptions message. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {google.protobuf.IFieldOptions} message FieldOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FieldOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.ctype != null && Object.hasOwnProperty.call(message, "ctype"))
                        writer.uint32(/* id 1, wireType 0 =*/8).int32(message.ctype);
                    if (message.packed != null && Object.hasOwnProperty.call(message, "packed"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.packed);
                    if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                        writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
                    if (message.lazy != null && Object.hasOwnProperty.call(message, "lazy"))
                        writer.uint32(/* id 5, wireType 0 =*/40).bool(message.lazy);
                    if (message.jstype != null && Object.hasOwnProperty.call(message, "jstype"))
                        writer.uint32(/* id 6, wireType 0 =*/48).int32(message.jstype);
                    if (message.weak != null && Object.hasOwnProperty.call(message, "weak"))
                        writer.uint32(/* id 10, wireType 0 =*/80).bool(message.weak);
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified FieldOptions message, length delimited. Does not implicitly {@link google.protobuf.FieldOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {google.protobuf.IFieldOptions} message FieldOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                FieldOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a FieldOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.FieldOptions} FieldOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FieldOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.FieldOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.ctype = reader.int32();
                            break;
                        case 2:
                            message.packed = reader.bool();
                            break;
                        case 6:
                            message.jstype = reader.int32();
                            break;
                        case 5:
                            message.lazy = reader.bool();
                            break;
                        case 3:
                            message.deprecated = reader.bool();
                            break;
                        case 10:
                            message.weak = reader.bool();
                            break;
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a FieldOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.FieldOptions} FieldOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                FieldOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a FieldOptions message.
                 * @function verify
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                FieldOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.ctype != null && message.hasOwnProperty("ctype"))
                        switch (message.ctype) {
                        default:
                            return "ctype: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.packed != null && message.hasOwnProperty("packed"))
                        if (typeof message.packed !== "boolean")
                            return "packed: boolean expected";
                    if (message.jstype != null && message.hasOwnProperty("jstype"))
                        switch (message.jstype) {
                        default:
                            return "jstype: enum value expected";
                        case 0:
                        case 1:
                        case 2:
                            break;
                        }
                    if (message.lazy != null && message.hasOwnProperty("lazy"))
                        if (typeof message.lazy !== "boolean")
                            return "lazy: boolean expected";
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        if (typeof message.deprecated !== "boolean")
                            return "deprecated: boolean expected";
                    if (message.weak != null && message.hasOwnProperty("weak"))
                        if (typeof message.weak !== "boolean")
                            return "weak: boolean expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a FieldOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.FieldOptions} FieldOptions
                 */
                FieldOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.FieldOptions)
                        return object;
                    var message = new $root.google.protobuf.FieldOptions();
                    switch (object.ctype) {
                    case "STRING":
                    case 0:
                        message.ctype = 0;
                        break;
                    case "CORD":
                    case 1:
                        message.ctype = 1;
                        break;
                    case "STRING_PIECE":
                    case 2:
                        message.ctype = 2;
                        break;
                    }
                    if (object.packed != null)
                        message.packed = Boolean(object.packed);
                    switch (object.jstype) {
                    case "JS_NORMAL":
                    case 0:
                        message.jstype = 0;
                        break;
                    case "JS_STRING":
                    case 1:
                        message.jstype = 1;
                        break;
                    case "JS_NUMBER":
                    case 2:
                        message.jstype = 2;
                        break;
                    }
                    if (object.lazy != null)
                        message.lazy = Boolean(object.lazy);
                    if (object.deprecated != null)
                        message.deprecated = Boolean(object.deprecated);
                    if (object.weak != null)
                        message.weak = Boolean(object.weak);
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.FieldOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.FieldOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a FieldOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.FieldOptions
                 * @static
                 * @param {google.protobuf.FieldOptions} message FieldOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                FieldOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (options.defaults) {
                        object.ctype = options.enums === String ? "STRING" : 0;
                        object.packed = false;
                        object.deprecated = false;
                        object.lazy = false;
                        object.jstype = options.enums === String ? "JS_NORMAL" : 0;
                        object.weak = false;
                    }
                    if (message.ctype != null && message.hasOwnProperty("ctype"))
                        object.ctype = options.enums === String ? $root.google.protobuf.FieldOptions.CType[message.ctype] : message.ctype;
                    if (message.packed != null && message.hasOwnProperty("packed"))
                        object.packed = message.packed;
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        object.deprecated = message.deprecated;
                    if (message.lazy != null && message.hasOwnProperty("lazy"))
                        object.lazy = message.lazy;
                    if (message.jstype != null && message.hasOwnProperty("jstype"))
                        object.jstype = options.enums === String ? $root.google.protobuf.FieldOptions.JSType[message.jstype] : message.jstype;
                    if (message.weak != null && message.hasOwnProperty("weak"))
                        object.weak = message.weak;
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this FieldOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.FieldOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                FieldOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                /**
                 * CType enum.
                 * @name google.protobuf.FieldOptions.CType
                 * @enum {number}
                 * @property {number} STRING=0 STRING value
                 * @property {number} CORD=1 CORD value
                 * @property {number} STRING_PIECE=2 STRING_PIECE value
                 */
                FieldOptions.CType = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "STRING"] = 0;
                    values[valuesById[1] = "CORD"] = 1;
                    values[valuesById[2] = "STRING_PIECE"] = 2;
                    return values;
                })();

                /**
                 * JSType enum.
                 * @name google.protobuf.FieldOptions.JSType
                 * @enum {number}
                 * @property {number} JS_NORMAL=0 JS_NORMAL value
                 * @property {number} JS_STRING=1 JS_STRING value
                 * @property {number} JS_NUMBER=2 JS_NUMBER value
                 */
                FieldOptions.JSType = (function() {
                    var valuesById = {}, values = Object.create(valuesById);
                    values[valuesById[0] = "JS_NORMAL"] = 0;
                    values[valuesById[1] = "JS_STRING"] = 1;
                    values[valuesById[2] = "JS_NUMBER"] = 2;
                    return values;
                })();

                return FieldOptions;
            })();

            protobuf.OneofOptions = (function() {

                /**
                 * Properties of an OneofOptions.
                 * @memberof google.protobuf
                 * @interface IOneofOptions
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] OneofOptions uninterpretedOption
                 */

                /**
                 * Constructs a new OneofOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents an OneofOptions.
                 * @implements IOneofOptions
                 * @constructor
                 * @param {google.protobuf.IOneofOptions=} [properties] Properties to set
                 */
                function OneofOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * OneofOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.OneofOptions
                 * @instance
                 */
                OneofOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new OneofOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {google.protobuf.IOneofOptions=} [properties] Properties to set
                 * @returns {google.protobuf.OneofOptions} OneofOptions instance
                 */
                OneofOptions.create = function create(properties) {
                    return new OneofOptions(properties);
                };

                /**
                 * Encodes the specified OneofOptions message. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {google.protobuf.IOneofOptions} message OneofOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OneofOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified OneofOptions message, length delimited. Does not implicitly {@link google.protobuf.OneofOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {google.protobuf.IOneofOptions} message OneofOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                OneofOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an OneofOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.OneofOptions} OneofOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OneofOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.OneofOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an OneofOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.OneofOptions} OneofOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                OneofOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an OneofOptions message.
                 * @function verify
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                OneofOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates an OneofOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.OneofOptions} OneofOptions
                 */
                OneofOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.OneofOptions)
                        return object;
                    var message = new $root.google.protobuf.OneofOptions();
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.OneofOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.OneofOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an OneofOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.OneofOptions
                 * @static
                 * @param {google.protobuf.OneofOptions} message OneofOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                OneofOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this OneofOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.OneofOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                OneofOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return OneofOptions;
            })();

            protobuf.EnumOptions = (function() {

                /**
                 * Properties of an EnumOptions.
                 * @memberof google.protobuf
                 * @interface IEnumOptions
                 * @property {boolean|null} [allowAlias] EnumOptions allowAlias
                 * @property {boolean|null} [deprecated] EnumOptions deprecated
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] EnumOptions uninterpretedOption
                 */

                /**
                 * Constructs a new EnumOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents an EnumOptions.
                 * @implements IEnumOptions
                 * @constructor
                 * @param {google.protobuf.IEnumOptions=} [properties] Properties to set
                 */
                function EnumOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * EnumOptions allowAlias.
                 * @member {boolean} allowAlias
                 * @memberof google.protobuf.EnumOptions
                 * @instance
                 */
                EnumOptions.prototype.allowAlias = false;

                /**
                 * EnumOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.EnumOptions
                 * @instance
                 */
                EnumOptions.prototype.deprecated = false;

                /**
                 * EnumOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.EnumOptions
                 * @instance
                 */
                EnumOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new EnumOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {google.protobuf.IEnumOptions=} [properties] Properties to set
                 * @returns {google.protobuf.EnumOptions} EnumOptions instance
                 */
                EnumOptions.create = function create(properties) {
                    return new EnumOptions(properties);
                };

                /**
                 * Encodes the specified EnumOptions message. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {google.protobuf.IEnumOptions} message EnumOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.allowAlias != null && Object.hasOwnProperty.call(message, "allowAlias"))
                        writer.uint32(/* id 2, wireType 0 =*/16).bool(message.allowAlias);
                    if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                        writer.uint32(/* id 3, wireType 0 =*/24).bool(message.deprecated);
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified EnumOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {google.protobuf.IEnumOptions} message EnumOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an EnumOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.EnumOptions} EnumOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 2:
                            message.allowAlias = reader.bool();
                            break;
                        case 3:
                            message.deprecated = reader.bool();
                            break;
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an EnumOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.EnumOptions} EnumOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an EnumOptions message.
                 * @function verify
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                EnumOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
                        if (typeof message.allowAlias !== "boolean")
                            return "allowAlias: boolean expected";
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        if (typeof message.deprecated !== "boolean")
                            return "deprecated: boolean expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates an EnumOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.EnumOptions} EnumOptions
                 */
                EnumOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.EnumOptions)
                        return object;
                    var message = new $root.google.protobuf.EnumOptions();
                    if (object.allowAlias != null)
                        message.allowAlias = Boolean(object.allowAlias);
                    if (object.deprecated != null)
                        message.deprecated = Boolean(object.deprecated);
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.EnumOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.EnumOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an EnumOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.EnumOptions
                 * @static
                 * @param {google.protobuf.EnumOptions} message EnumOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                EnumOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (options.defaults) {
                        object.allowAlias = false;
                        object.deprecated = false;
                    }
                    if (message.allowAlias != null && message.hasOwnProperty("allowAlias"))
                        object.allowAlias = message.allowAlias;
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        object.deprecated = message.deprecated;
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this EnumOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.EnumOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                EnumOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return EnumOptions;
            })();

            protobuf.EnumValueOptions = (function() {

                /**
                 * Properties of an EnumValueOptions.
                 * @memberof google.protobuf
                 * @interface IEnumValueOptions
                 * @property {boolean|null} [deprecated] EnumValueOptions deprecated
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] EnumValueOptions uninterpretedOption
                 */

                /**
                 * Constructs a new EnumValueOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents an EnumValueOptions.
                 * @implements IEnumValueOptions
                 * @constructor
                 * @param {google.protobuf.IEnumValueOptions=} [properties] Properties to set
                 */
                function EnumValueOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * EnumValueOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.EnumValueOptions
                 * @instance
                 */
                EnumValueOptions.prototype.deprecated = false;

                /**
                 * EnumValueOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.EnumValueOptions
                 * @instance
                 */
                EnumValueOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new EnumValueOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {google.protobuf.IEnumValueOptions=} [properties] Properties to set
                 * @returns {google.protobuf.EnumValueOptions} EnumValueOptions instance
                 */
                EnumValueOptions.create = function create(properties) {
                    return new EnumValueOptions(properties);
                };

                /**
                 * Encodes the specified EnumValueOptions message. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {google.protobuf.IEnumValueOptions} message EnumValueOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumValueOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                        writer.uint32(/* id 1, wireType 0 =*/8).bool(message.deprecated);
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified EnumValueOptions message, length delimited. Does not implicitly {@link google.protobuf.EnumValueOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {google.protobuf.IEnumValueOptions} message EnumValueOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                EnumValueOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes an EnumValueOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumValueOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.EnumValueOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 1:
                            message.deprecated = reader.bool();
                            break;
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes an EnumValueOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                EnumValueOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies an EnumValueOptions message.
                 * @function verify
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                EnumValueOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        if (typeof message.deprecated !== "boolean")
                            return "deprecated: boolean expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates an EnumValueOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.EnumValueOptions} EnumValueOptions
                 */
                EnumValueOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.EnumValueOptions)
                        return object;
                    var message = new $root.google.protobuf.EnumValueOptions();
                    if (object.deprecated != null)
                        message.deprecated = Boolean(object.deprecated);
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.EnumValueOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.EnumValueOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from an EnumValueOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.EnumValueOptions
                 * @static
                 * @param {google.protobuf.EnumValueOptions} message EnumValueOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                EnumValueOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (options.defaults)
                        object.deprecated = false;
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        object.deprecated = message.deprecated;
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this EnumValueOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.EnumValueOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                EnumValueOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return EnumValueOptions;
            })();

            protobuf.ServiceOptions = (function() {

                /**
                 * Properties of a ServiceOptions.
                 * @memberof google.protobuf
                 * @interface IServiceOptions
                 * @property {boolean|null} [deprecated] ServiceOptions deprecated
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] ServiceOptions uninterpretedOption
                 */

                /**
                 * Constructs a new ServiceOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents a ServiceOptions.
                 * @implements IServiceOptions
                 * @constructor
                 * @param {google.protobuf.IServiceOptions=} [properties] Properties to set
                 */
                function ServiceOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * ServiceOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.ServiceOptions
                 * @instance
                 */
                ServiceOptions.prototype.deprecated = false;

                /**
                 * ServiceOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.ServiceOptions
                 * @instance
                 */
                ServiceOptions.prototype.uninterpretedOption = $util.emptyArray;

                /**
                 * Creates a new ServiceOptions instance using the specified properties.
                 * @function create
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {google.protobuf.IServiceOptions=} [properties] Properties to set
                 * @returns {google.protobuf.ServiceOptions} ServiceOptions instance
                 */
                ServiceOptions.create = function create(properties) {
                    return new ServiceOptions(properties);
                };

                /**
                 * Encodes the specified ServiceOptions message. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
                 * @function encode
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {google.protobuf.IServiceOptions} message ServiceOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ServiceOptions.encode = function encode(message, writer) {
                    if (!writer)
                        writer = $Writer.create();
                    if (message.deprecated != null && Object.hasOwnProperty.call(message, "deprecated"))
                        writer.uint32(/* id 33, wireType 0 =*/264).bool(message.deprecated);
                    if (message.uninterpretedOption != null && message.uninterpretedOption.length)
                        for (var i = 0; i < message.uninterpretedOption.length; ++i)
                            $root.google.protobuf.UninterpretedOption.encode(message.uninterpretedOption[i], writer.uint32(/* id 999, wireType 2 =*/7994).fork()).ldelim();
                    return writer;
                };

                /**
                 * Encodes the specified ServiceOptions message, length delimited. Does not implicitly {@link google.protobuf.ServiceOptions.verify|verify} messages.
                 * @function encodeDelimited
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {google.protobuf.IServiceOptions} message ServiceOptions message or plain object to encode
                 * @param {$protobuf.Writer} [writer] Writer to encode to
                 * @returns {$protobuf.Writer} Writer
                 */
                ServiceOptions.encodeDelimited = function encodeDelimited(message, writer) {
                    return this.encode(message, writer).ldelim();
                };

                /**
                 * Decodes a ServiceOptions message from the specified reader or buffer.
                 * @function decode
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @param {number} [length] Message length if known beforehand
                 * @returns {google.protobuf.ServiceOptions} ServiceOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ServiceOptions.decode = function decode(reader, length) {
                    if (!(reader instanceof $Reader))
                        reader = $Reader.create(reader);
                    var end = length === undefined ? reader.len : reader.pos + length, message = new $root.google.protobuf.ServiceOptions();
                    while (reader.pos < end) {
                        var tag = reader.uint32();
                        switch (tag >>> 3) {
                        case 33:
                            message.deprecated = reader.bool();
                            break;
                        case 999:
                            if (!(message.uninterpretedOption && message.uninterpretedOption.length))
                                message.uninterpretedOption = [];
                            message.uninterpretedOption.push($root.google.protobuf.UninterpretedOption.decode(reader, reader.uint32()));
                            break;
                        default:
                            reader.skipType(tag & 7);
                            break;
                        }
                    }
                    return message;
                };

                /**
                 * Decodes a ServiceOptions message from the specified reader or buffer, length delimited.
                 * @function decodeDelimited
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {$protobuf.Reader|Uint8Array} reader Reader or buffer to decode from
                 * @returns {google.protobuf.ServiceOptions} ServiceOptions
                 * @throws {Error} If the payload is not a reader or valid buffer
                 * @throws {$protobuf.util.ProtocolError} If required fields are missing
                 */
                ServiceOptions.decodeDelimited = function decodeDelimited(reader) {
                    if (!(reader instanceof $Reader))
                        reader = new $Reader(reader);
                    return this.decode(reader, reader.uint32());
                };

                /**
                 * Verifies a ServiceOptions message.
                 * @function verify
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {Object.<string,*>} message Plain object to verify
                 * @returns {string|null} `null` if valid, otherwise the reason why it is not
                 */
                ServiceOptions.verify = function verify(message) {
                    if (typeof message !== "object" || message === null)
                        return "object expected";
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        if (typeof message.deprecated !== "boolean")
                            return "deprecated: boolean expected";
                    if (message.uninterpretedOption != null && message.hasOwnProperty("uninterpretedOption")) {
                        if (!Array.isArray(message.uninterpretedOption))
                            return "uninterpretedOption: array expected";
                        for (var i = 0; i < message.uninterpretedOption.length; ++i) {
                            var error = $root.google.protobuf.UninterpretedOption.verify(message.uninterpretedOption[i]);
                            if (error)
                                return "uninterpretedOption." + error;
                        }
                    }
                    return null;
                };

                /**
                 * Creates a ServiceOptions message from a plain object. Also converts values to their respective internal types.
                 * @function fromObject
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {Object.<string,*>} object Plain object
                 * @returns {google.protobuf.ServiceOptions} ServiceOptions
                 */
                ServiceOptions.fromObject = function fromObject(object) {
                    if (object instanceof $root.google.protobuf.ServiceOptions)
                        return object;
                    var message = new $root.google.protobuf.ServiceOptions();
                    if (object.deprecated != null)
                        message.deprecated = Boolean(object.deprecated);
                    if (object.uninterpretedOption) {
                        if (!Array.isArray(object.uninterpretedOption))
                            throw TypeError(".google.protobuf.ServiceOptions.uninterpretedOption: array expected");
                        message.uninterpretedOption = [];
                        for (var i = 0; i < object.uninterpretedOption.length; ++i) {
                            if (typeof object.uninterpretedOption[i] !== "object")
                                throw TypeError(".google.protobuf.ServiceOptions.uninterpretedOption: object expected");
                            message.uninterpretedOption[i] = $root.google.protobuf.UninterpretedOption.fromObject(object.uninterpretedOption[i]);
                        }
                    }
                    return message;
                };

                /**
                 * Creates a plain object from a ServiceOptions message. Also converts values to other types if specified.
                 * @function toObject
                 * @memberof google.protobuf.ServiceOptions
                 * @static
                 * @param {google.protobuf.ServiceOptions} message ServiceOptions
                 * @param {$protobuf.IConversionOptions} [options] Conversion options
                 * @returns {Object.<string,*>} Plain object
                 */
                ServiceOptions.toObject = function toObject(message, options) {
                    if (!options)
                        options = {};
                    var object = {};
                    if (options.arrays || options.defaults)
                        object.uninterpretedOption = [];
                    if (options.defaults)
                        object.deprecated = false;
                    if (message.deprecated != null && message.hasOwnProperty("deprecated"))
                        object.deprecated = message.deprecated;
                    if (message.uninterpretedOption && message.uninterpretedOption.length) {
                        object.uninterpretedOption = [];
                        for (var j = 0; j < message.uninterpretedOption.length; ++j)
                            object.uninterpretedOption[j] = $root.google.protobuf.UninterpretedOption.toObject(message.uninterpretedOption[j], options);
                    }
                    return object;
                };

                /**
                 * Converts this ServiceOptions to JSON.
                 * @function toJSON
                 * @memberof google.protobuf.ServiceOptions
                 * @instance
                 * @returns {Object.<string,*>} JSON object
                 */
                ServiceOptions.prototype.toJSON = function toJSON() {
                    return this.constructor.toObject(this, $protobuf.util.toJSONOptions);
                };

                return ServiceOptions;
            })();

            protobuf.MethodOptions = (function() {

                /**
                 * Properties of a MethodOptions.
                 * @memberof google.protobuf
                 * @interface IMethodOptions
                 * @property {boolean|null} [deprecated] MethodOptions deprecated
                 * @property {google.protobuf.MethodOptions.IdempotencyLevel|null} [idempotencyLevel] MethodOptions idempotencyLevel
                 * @property {Array.<google.protobuf.IUninterpretedOption>|null} [uninterpretedOption] MethodOptions uninterpretedOption
                 * @property {google.api.IHttpRule|null} [".google.api.http"] MethodOptions .google.api.http
                 */

                /**
                 * Constructs a new MethodOptions.
                 * @memberof google.protobuf
                 * @classdesc Represents a MethodOptions.
                 * @implements IMethodOptions
                 * @constructor
                 * @param {google.protobuf.IMethodOptions=} [properties] Properties to set
                 */
                function MethodOptions(properties) {
                    this.uninterpretedOption = [];
                    if (properties)
                        for (var keys = Object.keys(properties), i = 0; i < keys.length; ++i)
                            if (properties[keys[i]] != null)
                                this[keys[i]] = properties[keys[i]];
                }

                /**
                 * MethodOptions deprecated.
                 * @member {boolean} deprecated
                 * @memberof google.protobuf.MethodOptions
                 * @instance
                 */
                MethodOptions.prototype.deprecated = false;

                /**
                 * MethodOptions idempotencyLevel.
                 * @member {google.protobuf.MethodOptions.IdempotencyLevel} idempotencyLevel
                 * @memberof google.protobuf.MethodOptions
                 * @instance
                 */
                MethodOptions.prototype.idempotencyLevel = 0;

                /**
                 * MethodOptions uninterpretedOption.
                 * @member {Array.<google.protobuf.IUninterpretedOption>} uninterpretedOption
                 * @memberof google.protobuf.MethodOptions
                 * @instance
                 */
                MethodOptions.prototy