/**
 * TimeoutOverrideWrapper.ts
 * @author  Nev Wylie (newylie)
 * @copyright Microsoft 2022
 * Simple internal timeout wrapper
 */

export type TimeoutSetFunc<T = any> = (callback: (...args: any[]) => void, ms: number, ...args: any[]) => T;
export type TimeoutClearFunc<T = any> = (timeoutId?: T) => void;

export interface ITimeoutOverrideWrapper<T = any> {
    set: TimeoutSetFunc<T>;
    clear: TimeoutClearFunc<T>;
}

export function defaultSetTimeout<T = any>(callback: (...args: any[]) => void, ms: number, ...args: any[]): T {
    return setTimeout(callback, ms, args) as any;
}

export function defaultClearTimeout<T = any>(timeoutId?: T): void {
    clearTimeout(timeoutId as any);
}

export function createTimeoutWrapper<T = any>(argSetTimeout?: TimeoutSetFunc<T>, argClearTimeout?: TimeoutClearFunc<T>) {
    return {
        set: argSetTimeout || defaultSetTimeout,
        clear: argClearTimeout || defaultClearTimeout
    } 
}