/// <reference types="node" />
import * as gax from 'google-gax';
import { Callback, CallOptions, Descriptors, ClientOptions, LROperation, PaginationCallback } from 'google-gax';
import { Transform } from 'stream';
import * as protos from '../../protos/protos';
/**
 *  Service for configuring sinks used to route log entries.
 * @class
 * @memberof v2
 */
export declare class ConfigServiceV2Client {
    private _terminated;
    private _opts;
    private _providedCustomServicePath;
    private _gaxModule;
    private _gaxGrpc;
    private _protos;
    private _defaults;
    auth: gax.GoogleAuth;
    descriptors: Descriptors;
    warn: (code: string, message: string, warnType?: string) => void;
    innerApiCalls: {
        [name: string]: Function;
    };
    pathTemplates: {
        [name: string]: gax.PathTemplate;
    };
    operationsClient: gax.OperationsClient;
    configServiceV2Stub?: Promise<{
        [name: string]: Function;
    }>;
    /**
     * Construct an instance of ConfigServiceV2Client.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP fallback mode.
     *     In fallback mode, a special browser-compatible transport implementation is used
     *     instead of gRPC transport. In browser context (if the `window` object is defined)
     *     the fallback mode is enabled automatically; set `options.fallback` to `false`
     *     if you need to override this behavior.
     */
    constructor(opts?: ClientOptions);
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize(): Promise<{
        [name: string]: Function;
    }>;
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath(): string;
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint(): string;
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port(): number;
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes(): string[];
    getProjectId(): Promise<string>;
    getProjectId(callback: Callback<string, undefined, undefined>): void;
    /**
     * Gets a log bucket.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the bucket:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogBucket]{@link google.logging.v2.LogBucket}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.get_bucket.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_GetBucket_async
     */
    getBucket(request?: protos.google.logging.v2.IGetBucketRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogBucket, protos.google.logging.v2.IGetBucketRequest | undefined, {} | undefined]>;
    getBucket(request: protos.google.logging.v2.IGetBucketRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogBucket, protos.google.logging.v2.IGetBucketRequest | null | undefined, {} | null | undefined>): void;
    getBucket(request: protos.google.logging.v2.IGetBucketRequest, callback: Callback<protos.google.logging.v2.ILogBucket, protos.google.logging.v2.IGetBucketRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Creates a log bucket that can be used to store log entries. After a bucket
     * has been created, the bucket's location cannot be changed.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource in which to create the log bucket:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global"`
     * @param {string} request.bucketId
     *   Required. A client-assigned identifier such as `"my-bucket"`. Identifiers are limited
     *   to 100 characters and can include only letters, digits, underscores,
     *   hyphens, and periods.
     * @param {google.logging.v2.LogBucket} request.bucket
     *   Required. The new bucket. The region specified in the new bucket must be compliant
     *   with any Location Restriction Org Policy. The name field in the bucket is
     *   ignored.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogBucket]{@link google.logging.v2.LogBucket}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.create_bucket.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_CreateBucket_async
     */
    createBucket(request?: protos.google.logging.v2.ICreateBucketRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogBucket, protos.google.logging.v2.ICreateBucketRequest | undefined, {} | undefined]>;
    createBucket(request: protos.google.logging.v2.ICreateBucketRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogBucket, protos.google.logging.v2.ICreateBucketRequest | null | undefined, {} | null | undefined>): void;
    createBucket(request: protos.google.logging.v2.ICreateBucketRequest, callback: Callback<protos.google.logging.v2.ILogBucket, protos.google.logging.v2.ICreateBucketRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Updates a log bucket. This method replaces the following fields in the
     * existing bucket with values from the new bucket: `retention_period`
     *
     * If the retention period is decreased and the bucket is locked,
     * `FAILED_PRECONDITION` will be returned.
     *
     * If the bucket has a `lifecycle_state` of `DELETE_REQUESTED`, then
     * `FAILED_PRECONDITION` will be returned.
     *
     * After a bucket has been created, the bucket's location cannot be changed.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The full resource name of the bucket to update.
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param {google.logging.v2.LogBucket} request.bucket
     *   Required. The updated bucket.
     * @param {google.protobuf.FieldMask} request.updateMask
     *   Required. Field mask that specifies the fields in `bucket` that need an update. A
     *   bucket field will be overwritten if, and only if, it is in the update mask.
     *   `name` and output only fields cannot be updated.
     *
     *   For a detailed `FieldMask` definition, see:
     *   https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
     *
     *   For example: `updateMask=retention_days`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogBucket]{@link google.logging.v2.LogBucket}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.update_bucket.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UpdateBucket_async
     */
    updateBucket(request?: protos.google.logging.v2.IUpdateBucketRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogBucket, protos.google.logging.v2.IUpdateBucketRequest | undefined, {} | undefined]>;
    updateBucket(request: protos.google.logging.v2.IUpdateBucketRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogBucket, protos.google.logging.v2.IUpdateBucketRequest | null | undefined, {} | null | undefined>): void;
    updateBucket(request: protos.google.logging.v2.IUpdateBucketRequest, callback: Callback<protos.google.logging.v2.ILogBucket, protos.google.logging.v2.IUpdateBucketRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Deletes a log bucket.
     *
     * Changes the bucket's `lifecycle_state` to the `DELETE_REQUESTED` state.
     * After 7 days, the bucket will be purged and all log entries in the bucket
     * will be permanently deleted.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The full resource name of the bucket to delete.
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.delete_bucket.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_DeleteBucket_async
     */
    deleteBucket(request?: protos.google.logging.v2.IDeleteBucketRequest, options?: CallOptions): Promise<[protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteBucketRequest | undefined, {} | undefined]>;
    deleteBucket(request: protos.google.logging.v2.IDeleteBucketRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteBucketRequest | null | undefined, {} | null | undefined>): void;
    deleteBucket(request: protos.google.logging.v2.IDeleteBucketRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteBucketRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Undeletes a log bucket. A bucket that has been deleted can be undeleted
     * within the grace period of 7 days.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The full resource name of the bucket to undelete.
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.undelete_bucket.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UndeleteBucket_async
     */
    undeleteBucket(request?: protos.google.logging.v2.IUndeleteBucketRequest, options?: CallOptions): Promise<[protos.google.protobuf.IEmpty, protos.google.logging.v2.IUndeleteBucketRequest | undefined, {} | undefined]>;
    undeleteBucket(request: protos.google.logging.v2.IUndeleteBucketRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IUndeleteBucketRequest | null | undefined, {} | null | undefined>): void;
    undeleteBucket(request: protos.google.logging.v2.IUndeleteBucketRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IUndeleteBucketRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Gets a view on a log bucket..
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the policy:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogView]{@link google.logging.v2.LogView}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.get_view.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_GetView_async
     */
    getView(request?: protos.google.logging.v2.IGetViewRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogView, protos.google.logging.v2.IGetViewRequest | undefined, {} | undefined]>;
    getView(request: protos.google.logging.v2.IGetViewRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogView, protos.google.logging.v2.IGetViewRequest | null | undefined, {} | null | undefined>): void;
    getView(request: protos.google.logging.v2.IGetViewRequest, callback: Callback<protos.google.logging.v2.ILogView, protos.google.logging.v2.IGetViewRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Creates a view over log entries in a log bucket. A bucket may contain a
     * maximum of 30 views.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The bucket in which to create the view
     *
     *       `"projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"`
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket"`
     * @param {string} request.viewId
     *   Required. The id to use for this view.
     * @param {google.logging.v2.LogView} request.view
     *   Required. The new view.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogView]{@link google.logging.v2.LogView}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.create_view.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_CreateView_async
     */
    createView(request?: protos.google.logging.v2.ICreateViewRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogView, protos.google.logging.v2.ICreateViewRequest | undefined, {} | undefined]>;
    createView(request: protos.google.logging.v2.ICreateViewRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogView, protos.google.logging.v2.ICreateViewRequest | null | undefined, {} | null | undefined>): void;
    createView(request: protos.google.logging.v2.ICreateViewRequest, callback: Callback<protos.google.logging.v2.ILogView, protos.google.logging.v2.ICreateViewRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Updates a view on a log bucket. This method replaces the following fields
     * in the existing view with values from the new view: `filter`.
     * If an `UNAVAILABLE` error is returned, this indicates that system is not in
     * a state where it can update the view. If this occurs, please try again in a
     * few minutes.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The full resource name of the view to update
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
     * @param {google.logging.v2.LogView} request.view
     *   Required. The updated view.
     * @param {google.protobuf.FieldMask} [request.updateMask]
     *   Optional. Field mask that specifies the fields in `view` that need
     *   an update. A field will be overwritten if, and only if, it is
     *   in the update mask. `name` and output only fields cannot be updated.
     *
     *   For a detailed `FieldMask` definition, see
     *   https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
     *
     *   For example: `updateMask=filter`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogView]{@link google.logging.v2.LogView}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.update_view.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UpdateView_async
     */
    updateView(request?: protos.google.logging.v2.IUpdateViewRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogView, protos.google.logging.v2.IUpdateViewRequest | undefined, {} | undefined]>;
    updateView(request: protos.google.logging.v2.IUpdateViewRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogView, protos.google.logging.v2.IUpdateViewRequest | null | undefined, {} | null | undefined>): void;
    updateView(request: protos.google.logging.v2.IUpdateViewRequest, callback: Callback<protos.google.logging.v2.ILogView, protos.google.logging.v2.IUpdateViewRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Deletes a view on a log bucket.
     * If an `UNAVAILABLE` error is returned, this indicates that system is not in
     * a state where it can delete the view. If this occurs, please try again in a
     * few minutes.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The full resource name of the view to delete:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]/views/[VIEW_ID]"
     *
     *   For example:
     *
     *      `"projects/my-project/locations/global/buckets/my-bucket/views/my-view"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.delete_view.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_DeleteView_async
     */
    deleteView(request?: protos.google.logging.v2.IDeleteViewRequest, options?: CallOptions): Promise<[protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteViewRequest | undefined, {} | undefined]>;
    deleteView(request: protos.google.logging.v2.IDeleteViewRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteViewRequest | null | undefined, {} | null | undefined>): void;
    deleteView(request: protos.google.logging.v2.IDeleteViewRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteViewRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Gets a sink.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.sinkName
     *   Required. The resource name of the sink:
     *
     *       "projects/[PROJECT_ID]/sinks/[SINK_ID]"
     *       "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
     *       "folders/[FOLDER_ID]/sinks/[SINK_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/sinks/my-sink"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogSink]{@link google.logging.v2.LogSink}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.get_sink.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_GetSink_async
     */
    getSink(request?: protos.google.logging.v2.IGetSinkRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogSink, protos.google.logging.v2.IGetSinkRequest | undefined, {} | undefined]>;
    getSink(request: protos.google.logging.v2.IGetSinkRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogSink, protos.google.logging.v2.IGetSinkRequest | null | undefined, {} | null | undefined>): void;
    getSink(request: protos.google.logging.v2.IGetSinkRequest, callback: Callback<protos.google.logging.v2.ILogSink, protos.google.logging.v2.IGetSinkRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Creates a sink that exports specified log entries to a destination. The
     * export of newly-ingested log entries begins immediately, unless the sink's
     * `writer_identity` is not permitted to write to the destination. A sink can
     * export log entries only from the resource owning the sink.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource in which to create the sink:
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     *
     *   For examples:
     *
     *     `"projects/my-project"`
     *     `"organizations/123456789"`
     * @param {google.logging.v2.LogSink} request.sink
     *   Required. The new sink, whose `name` parameter is a sink identifier that
     *   is not already in use.
     * @param {boolean} [request.uniqueWriterIdentity]
     *   Optional. Determines the kind of IAM identity returned as `writer_identity`
     *   in the new sink. If this value is omitted or set to false, and if the
     *   sink's parent is a project, then the value returned as `writer_identity` is
     *   the same group or service account used by Cloud Logging before the addition
     *   of writer identities to this API. The sink's destination must be in the
     *   same project as the sink itself.
     *
     *   If this field is set to true, or if the sink is owned by a non-project
     *   resource such as an organization, then the value of `writer_identity` will
     *   be a unique service account used only for exports from the new sink. For
     *   more information, see `writer_identity` in {@link google.logging.v2.LogSink|LogSink}.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogSink]{@link google.logging.v2.LogSink}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.create_sink.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_CreateSink_async
     */
    createSink(request?: protos.google.logging.v2.ICreateSinkRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogSink, protos.google.logging.v2.ICreateSinkRequest | undefined, {} | undefined]>;
    createSink(request: protos.google.logging.v2.ICreateSinkRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogSink, protos.google.logging.v2.ICreateSinkRequest | null | undefined, {} | null | undefined>): void;
    createSink(request: protos.google.logging.v2.ICreateSinkRequest, callback: Callback<protos.google.logging.v2.ILogSink, protos.google.logging.v2.ICreateSinkRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Updates a sink. This method replaces the following fields in the existing
     * sink with values from the new sink: `destination`, and `filter`.
     *
     * The updated sink might also have a new `writer_identity`; see the
     * `unique_writer_identity` field.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.sinkName
     *   Required. The full resource name of the sink to update, including the parent
     *   resource and the sink identifier:
     *
     *       "projects/[PROJECT_ID]/sinks/[SINK_ID]"
     *       "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
     *       "folders/[FOLDER_ID]/sinks/[SINK_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/sinks/my-sink"`
     * @param {google.logging.v2.LogSink} request.sink
     *   Required. The updated sink, whose name is the same identifier that appears as part
     *   of `sink_name`.
     * @param {boolean} [request.uniqueWriterIdentity]
     *   Optional. See {@link google.logging.v2.ConfigServiceV2.CreateSink|sinks.create}
     *   for a description of this field. When updating a sink, the effect of this
     *   field on the value of `writer_identity` in the updated sink depends on both
     *   the old and new values of this field:
     *
     *   +   If the old and new values of this field are both false or both true,
     *       then there is no change to the sink's `writer_identity`.
     *   +   If the old value is false and the new value is true, then
     *       `writer_identity` is changed to a unique service account.
     *   +   It is an error if the old value is true and the new value is
     *       set to false or defaulted to false.
     * @param {google.protobuf.FieldMask} [request.updateMask]
     *   Optional. Field mask that specifies the fields in `sink` that need
     *   an update. A sink field will be overwritten if, and only if, it is
     *   in the update mask. `name` and output only fields cannot be updated.
     *
     *   An empty `updateMask` is temporarily treated as using the following mask
     *   for backwards compatibility purposes:
     *
     *     `destination,filter,includeChildren`
     *
     *   At some point in the future, behavior will be removed and specifying an
     *   empty `updateMask` will be an error.
     *
     *   For a detailed `FieldMask` definition, see
     *   https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#google.protobuf.FieldMask
     *
     *   For example: `updateMask=filter`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogSink]{@link google.logging.v2.LogSink}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.update_sink.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UpdateSink_async
     */
    updateSink(request?: protos.google.logging.v2.IUpdateSinkRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogSink, protos.google.logging.v2.IUpdateSinkRequest | undefined, {} | undefined]>;
    updateSink(request: protos.google.logging.v2.IUpdateSinkRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogSink, protos.google.logging.v2.IUpdateSinkRequest | null | undefined, {} | null | undefined>): void;
    updateSink(request: protos.google.logging.v2.IUpdateSinkRequest, callback: Callback<protos.google.logging.v2.ILogSink, protos.google.logging.v2.IUpdateSinkRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Deletes a sink. If the sink has a unique `writer_identity`, then that
     * service account is also deleted.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.sinkName
     *   Required. The full resource name of the sink to delete, including the parent
     *   resource and the sink identifier:
     *
     *       "projects/[PROJECT_ID]/sinks/[SINK_ID]"
     *       "organizations/[ORGANIZATION_ID]/sinks/[SINK_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/sinks/[SINK_ID]"
     *       "folders/[FOLDER_ID]/sinks/[SINK_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/sinks/my-sink"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.delete_sink.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_DeleteSink_async
     */
    deleteSink(request?: protos.google.logging.v2.IDeleteSinkRequest, options?: CallOptions): Promise<[protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteSinkRequest | undefined, {} | undefined]>;
    deleteSink(request: protos.google.logging.v2.IDeleteSinkRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteSinkRequest | null | undefined, {} | null | undefined>): void;
    deleteSink(request: protos.google.logging.v2.IDeleteSinkRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteSinkRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Gets the description of an exclusion in the _Default sink.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of an existing exclusion:
     *
     *       "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
     *       "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
     *       "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/exclusions/my-exclusion"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogExclusion]{@link google.logging.v2.LogExclusion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.get_exclusion.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_GetExclusion_async
     */
    getExclusion(request?: protos.google.logging.v2.IGetExclusionRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.IGetExclusionRequest | undefined, {} | undefined]>;
    getExclusion(request: protos.google.logging.v2.IGetExclusionRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.IGetExclusionRequest | null | undefined, {} | null | undefined>): void;
    getExclusion(request: protos.google.logging.v2.IGetExclusionRequest, callback: Callback<protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.IGetExclusionRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Creates a new exclusion in the _Default sink in a specified parent
     * resource. Only log entries belonging to that resource can be excluded. You
     * can have up to 10 exclusions in a resource.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource in which to create the exclusion:
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     *
     *   For examples:
     *
     *     `"projects/my-logging-project"`
     *     `"organizations/123456789"`
     * @param {google.logging.v2.LogExclusion} request.exclusion
     *   Required. The new exclusion, whose `name` parameter is an exclusion name
     *   that is not already used in the parent resource.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogExclusion]{@link google.logging.v2.LogExclusion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.create_exclusion.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_CreateExclusion_async
     */
    createExclusion(request?: protos.google.logging.v2.ICreateExclusionRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.ICreateExclusionRequest | undefined, {} | undefined]>;
    createExclusion(request: protos.google.logging.v2.ICreateExclusionRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.ICreateExclusionRequest | null | undefined, {} | null | undefined>): void;
    createExclusion(request: protos.google.logging.v2.ICreateExclusionRequest, callback: Callback<protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.ICreateExclusionRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Changes one or more properties of an existing exclusion in the _Default
     * sink.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of the exclusion to update:
     *
     *       "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
     *       "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
     *       "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/exclusions/my-exclusion"`
     * @param {google.logging.v2.LogExclusion} request.exclusion
     *   Required. New values for the existing exclusion. Only the fields specified in
     *   `update_mask` are relevant.
     * @param {google.protobuf.FieldMask} request.updateMask
     *   Required. A non-empty list of fields to change in the existing exclusion. New values
     *   for the fields are taken from the corresponding fields in the
     *   {@link google.logging.v2.LogExclusion|LogExclusion} included in this request. Fields not mentioned in
     *   `update_mask` are not changed and are ignored in the request.
     *
     *   For example, to change the filter and description of an exclusion,
     *   specify an `update_mask` of `"filter,description"`.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogExclusion]{@link google.logging.v2.LogExclusion}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.update_exclusion.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UpdateExclusion_async
     */
    updateExclusion(request?: protos.google.logging.v2.IUpdateExclusionRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.IUpdateExclusionRequest | undefined, {} | undefined]>;
    updateExclusion(request: protos.google.logging.v2.IUpdateExclusionRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.IUpdateExclusionRequest | null | undefined, {} | null | undefined>): void;
    updateExclusion(request: protos.google.logging.v2.IUpdateExclusionRequest, callback: Callback<protos.google.logging.v2.ILogExclusion, protos.google.logging.v2.IUpdateExclusionRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Deletes an exclusion in the _Default sink.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name of an existing exclusion to delete:
     *
     *       "projects/[PROJECT_ID]/exclusions/[EXCLUSION_ID]"
     *       "organizations/[ORGANIZATION_ID]/exclusions/[EXCLUSION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/exclusions/[EXCLUSION_ID]"
     *       "folders/[FOLDER_ID]/exclusions/[EXCLUSION_ID]"
     *
     *   For example:
     *
     *     `"projects/my-project/exclusions/my-exclusion"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.delete_exclusion.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_DeleteExclusion_async
     */
    deleteExclusion(request?: protos.google.logging.v2.IDeleteExclusionRequest, options?: CallOptions): Promise<[protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteExclusionRequest | undefined, {} | undefined]>;
    deleteExclusion(request: protos.google.logging.v2.IDeleteExclusionRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteExclusionRequest | null | undefined, {} | null | undefined>): void;
    deleteExclusion(request: protos.google.logging.v2.IDeleteExclusionRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteExclusionRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Gets the Logging CMEK settings for the given resource.
     *
     * Note: CMEK for the Log Router can be configured for Google Cloud projects,
     * folders, organizations and billing accounts. Once configured for an
     * organization, it applies to all projects and folders in the Google Cloud
     * organization.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource for which to retrieve CMEK settings.
     *
     *       "projects/[PROJECT_ID]/cmekSettings"
     *       "organizations/[ORGANIZATION_ID]/cmekSettings"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
     *       "folders/[FOLDER_ID]/cmekSettings"
     *
     *   For example:
     *
     *     `"organizations/12345/cmekSettings"`
     *
     *   Note: CMEK for the Log Router can be configured for Google Cloud projects,
     *   folders, organizations and billing accounts. Once configured for an
     *   organization, it applies to all projects and folders in the Google Cloud
     *   organization.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [CmekSettings]{@link google.logging.v2.CmekSettings}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.get_cmek_settings.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_GetCmekSettings_async
     */
    getCmekSettings(request?: protos.google.logging.v2.IGetCmekSettingsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ICmekSettings, protos.google.logging.v2.IGetCmekSettingsRequest | undefined, {} | undefined]>;
    getCmekSettings(request: protos.google.logging.v2.IGetCmekSettingsRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ICmekSettings, protos.google.logging.v2.IGetCmekSettingsRequest | null | undefined, {} | null | undefined>): void;
    getCmekSettings(request: protos.google.logging.v2.IGetCmekSettingsRequest, callback: Callback<protos.google.logging.v2.ICmekSettings, protos.google.logging.v2.IGetCmekSettingsRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Updates the Log Router CMEK settings for the given resource.
     *
     * Note: CMEK for the Log Router can currently only be configured for Google
     * Cloud organizations. Once configured, it applies to all projects and
     * folders in the Google Cloud organization.
     *
     * {@link google.logging.v2.ConfigServiceV2.UpdateCmekSettings|UpdateCmekSettings}
     * will fail if 1) `kms_key_name` is invalid, or 2) the associated service
     * account does not have the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
     * 3) access to the key is disabled.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name for the CMEK settings to update.
     *
     *       "projects/[PROJECT_ID]/cmekSettings"
     *       "organizations/[ORGANIZATION_ID]/cmekSettings"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/cmekSettings"
     *       "folders/[FOLDER_ID]/cmekSettings"
     *
     *   For example:
     *
     *     `"organizations/12345/cmekSettings"`
     *
     *   Note: CMEK for the Log Router can currently only be configured for Google
     *   Cloud organizations. Once configured, it applies to all projects and
     *   folders in the Google Cloud organization.
     * @param {google.logging.v2.CmekSettings} request.cmekSettings
     *   Required. The CMEK settings to update.
     *
     *   See [Enabling CMEK for Log
     *   Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     *   for more information.
     * @param {google.protobuf.FieldMask} [request.updateMask]
     *   Optional. Field mask identifying which fields from `cmek_settings` should
     *   be updated. A field will be overwritten if and only if it is in the update
     *   mask. Output only fields cannot be updated.
     *
     *   See {@link google.protobuf.FieldMask|FieldMask} for more information.
     *
     *   For example: `"updateMask=kmsKeyName"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [CmekSettings]{@link google.logging.v2.CmekSettings}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.update_cmek_settings.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UpdateCmekSettings_async
     */
    updateCmekSettings(request?: protos.google.logging.v2.IUpdateCmekSettingsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ICmekSettings, protos.google.logging.v2.IUpdateCmekSettingsRequest | undefined, {} | undefined]>;
    updateCmekSettings(request: protos.google.logging.v2.IUpdateCmekSettingsRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ICmekSettings, protos.google.logging.v2.IUpdateCmekSettingsRequest | null | undefined, {} | null | undefined>): void;
    updateCmekSettings(request: protos.google.logging.v2.IUpdateCmekSettingsRequest, callback: Callback<protos.google.logging.v2.ICmekSettings, protos.google.logging.v2.IUpdateCmekSettingsRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Gets the Log Router settings for the given resource.
     *
     * Note: Settings for the Log Router can be get for Google Cloud projects,
     * folders, organizations and billing accounts. Currently it can only be
     * configured for organizations. Once configured for an organization, it
     * applies to all projects and folders in the Google Cloud organization.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource for which to retrieve settings.
     *
     *       "projects/[PROJECT_ID]/settings"
     *       "organizations/[ORGANIZATION_ID]/settings"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/settings"
     *       "folders/[FOLDER_ID]/settings"
     *
     *   For example:
     *
     *     `"organizations/12345/settings"`
     *
     *   Note: Settings for the Log Router can be get for Google Cloud projects,
     *   folders, organizations and billing accounts. Currently it can only be
     *   configured for organizations. Once configured for an organization, it
     *   applies to all projects and folders in the Google Cloud organization.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Settings]{@link google.logging.v2.Settings}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.get_settings.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_GetSettings_async
     */
    getSettings(request?: protos.google.logging.v2.IGetSettingsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ISettings, protos.google.logging.v2.IGetSettingsRequest | undefined, {} | undefined]>;
    getSettings(request: protos.google.logging.v2.IGetSettingsRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ISettings, protos.google.logging.v2.IGetSettingsRequest | null | undefined, {} | null | undefined>): void;
    getSettings(request: protos.google.logging.v2.IGetSettingsRequest, callback: Callback<protos.google.logging.v2.ISettings, protos.google.logging.v2.IGetSettingsRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Updates the Log Router settings for the given resource.
     *
     * Note: Settings for the Log Router can currently only be configured for
     * Google Cloud organizations. Once configured, it applies to all projects and
     * folders in the Google Cloud organization.
     *
     * {@link google.logging.v2.ConfigServiceV2.UpdateSettings|UpdateSettings}
     * will fail if 1) `kms_key_name` is invalid, or 2) the associated service
     * account does not have the required
     * `roles/cloudkms.cryptoKeyEncrypterDecrypter` role assigned for the key, or
     * 3) access to the key is disabled. 4) `location_id` is not supported by
     * Logging. 5) `location_id` violate OrgPolicy.
     *
     * See [Enabling CMEK for Log
     * Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     * for more information.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. The resource name for the settings to update.
     *
     *       "organizations/[ORGANIZATION_ID]/settings"
     *
     *   For example:
     *
     *     `"organizations/12345/settings"`
     *
     *   Note: Settings for the Log Router can currently only be configured for
     *   Google Cloud organizations. Once configured, it applies to all projects and
     *   folders in the Google Cloud organization.
     * @param {google.logging.v2.Settings} request.settings
     *   Required. The settings to update.
     *
     *   See [Enabling CMEK for Log
     *   Router](https://cloud.google.com/logging/docs/routing/managed-encryption)
     *   for more information.
     * @param {google.protobuf.FieldMask} [request.updateMask]
     *   Optional. Field mask identifying which fields from `settings` should
     *   be updated. A field will be overwritten if and only if it is in the update
     *   mask. Output only fields cannot be updated.
     *
     *   See {@link google.protobuf.FieldMask|FieldMask} for more information.
     *
     *   For example: `"updateMask=kmsKeyName"`
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Settings]{@link google.logging.v2.Settings}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.update_settings.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_UpdateSettings_async
     */
    updateSettings(request?: protos.google.logging.v2.IUpdateSettingsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ISettings, protos.google.logging.v2.IUpdateSettingsRequest | undefined, {} | undefined]>;
    updateSettings(request: protos.google.logging.v2.IUpdateSettingsRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ISettings, protos.google.logging.v2.IUpdateSettingsRequest | null | undefined, {} | null | undefined>): void;
    updateSettings(request: protos.google.logging.v2.IUpdateSettingsRequest, callback: Callback<protos.google.logging.v2.ISettings, protos.google.logging.v2.IUpdateSettingsRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Copies a set of log entries from a log bucket to a Cloud Storage bucket.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.name
     *   Required. Log bucket from which to copy log entries.
     *
     *   For example:
     *
     *     `"projects/my-project/locations/global/buckets/my-source-bucket"`
     * @param {string} [request.filter]
     *   Optional. A filter specifying which log entries to copy. The filter must be no more
     *   than 20k characters. An empty filter matches all log entries.
     * @param {string} request.destination
     *   Required. Destination to which to copy log entries.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing
     *   a long running operation. Its `promise()` method returns a promise
     *   you can `await` for.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.copy_log_entries.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_CopyLogEntries_async
     */
    copyLogEntries(request?: protos.google.logging.v2.ICopyLogEntriesRequest, options?: CallOptions): Promise<[LROperation<protos.google.logging.v2.ICopyLogEntriesResponse, protos.google.logging.v2.ICopyLogEntriesMetadata>, protos.google.longrunning.IOperation | undefined, {} | undefined]>;
    copyLogEntries(request: protos.google.logging.v2.ICopyLogEntriesRequest, options: CallOptions, callback: Callback<LROperation<protos.google.logging.v2.ICopyLogEntriesResponse, protos.google.logging.v2.ICopyLogEntriesMetadata>, protos.google.longrunning.IOperation | null | undefined, {} | null | undefined>): void;
    copyLogEntries(request: protos.google.logging.v2.ICopyLogEntriesRequest, callback: Callback<LROperation<protos.google.logging.v2.ICopyLogEntriesResponse, protos.google.logging.v2.ICopyLogEntriesMetadata>, protos.google.longrunning.IOperation | null | undefined, {} | null | undefined>): void;
    /**
     * Check the status of the long running operation returned by `copyLogEntries()`.
     * @param {String} name
     *   The operation name that will be passed.
     * @returns {Promise} - The promise which resolves to an object.
     *   The decoded operation object has result and metadata field to get information from.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#long-running-operations)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.copy_log_entries.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_CopyLogEntries_async
     */
    checkCopyLogEntriesProgress(name: string): Promise<LROperation<protos.google.logging.v2.CopyLogEntriesResponse, protos.google.logging.v2.CopyLogEntriesMetadata>>;
    /**
     * Lists log buckets.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose buckets are to be listed:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
     *
     *   Note: The locations portion of the resource must be specified, but
     *   supplying the character `-` in place of [LOCATION_ID] will return all
     *   buckets.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the preceding call
     *   to this method. `pageToken` must be the value of `nextPageToken` from the
     *   previous response. The values of other method parameters should be
     *   identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request. Non-positive
     *   values are ignored. The presence of `nextPageToken` in the response
     *   indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [LogBucket]{@link google.logging.v2.LogBucket}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listBucketsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listBuckets(request?: protos.google.logging.v2.IListBucketsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogBucket[], protos.google.logging.v2.IListBucketsRequest | null, protos.google.logging.v2.IListBucketsResponse]>;
    listBuckets(request: protos.google.logging.v2.IListBucketsRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListBucketsRequest, protos.google.logging.v2.IListBucketsResponse | null | undefined, protos.google.logging.v2.ILogBucket>): void;
    listBuckets(request: protos.google.logging.v2.IListBucketsRequest, callback: PaginationCallback<protos.google.logging.v2.IListBucketsRequest, protos.google.logging.v2.IListBucketsResponse | null | undefined, protos.google.logging.v2.ILogBucket>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose buckets are to be listed:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
     *
     *   Note: The locations portion of the resource must be specified, but
     *   supplying the character `-` in place of [LOCATION_ID] will return all
     *   buckets.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the preceding call
     *   to this method. `pageToken` must be the value of `nextPageToken` from the
     *   previous response. The values of other method parameters should be
     *   identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request. Non-positive
     *   values are ignored. The presence of `nextPageToken` in the response
     *   indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [LogBucket]{@link google.logging.v2.LogBucket} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listBucketsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listBucketsStream(request?: protos.google.logging.v2.IListBucketsRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listBuckets`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose buckets are to be listed:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]"
     *       "organizations/[ORGANIZATION_ID]/locations/[LOCATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]/locations/[LOCATION_ID]"
     *       "folders/[FOLDER_ID]/locations/[LOCATION_ID]"
     *
     *   Note: The locations portion of the resource must be specified, but
     *   supplying the character `-` in place of [LOCATION_ID] will return all
     *   buckets.
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the preceding call
     *   to this method. `pageToken` must be the value of `nextPageToken` from the
     *   previous response. The values of other method parameters should be
     *   identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request. Non-positive
     *   values are ignored. The presence of `nextPageToken` in the response
     *   indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [LogBucket]{@link google.logging.v2.LogBucket}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.list_buckets.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_ListBuckets_async
     */
    listBucketsAsync(request?: protos.google.logging.v2.IListBucketsRequest, options?: CallOptions): AsyncIterable<protos.google.logging.v2.ILogBucket>;
    /**
     * Lists views on a log bucket.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The bucket whose views are to be listed:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the preceding call
     *   to this method. `pageToken` must be the value of `nextPageToken` from the
     *   previous response. The values of other method parameters should be
     *   identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [LogView]{@link google.logging.v2.LogView}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listViewsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listViews(request?: protos.google.logging.v2.IListViewsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogView[], protos.google.logging.v2.IListViewsRequest | null, protos.google.logging.v2.IListViewsResponse]>;
    listViews(request: protos.google.logging.v2.IListViewsRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListViewsRequest, protos.google.logging.v2.IListViewsResponse | null | undefined, protos.google.logging.v2.ILogView>): void;
    listViews(request: protos.google.logging.v2.IListViewsRequest, callback: PaginationCallback<protos.google.logging.v2.IListViewsRequest, protos.google.logging.v2.IListViewsResponse | null | undefined, protos.google.logging.v2.ILogView>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The bucket whose views are to be listed:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the preceding call
     *   to this method. `pageToken` must be the value of `nextPageToken` from the
     *   previous response. The values of other method parameters should be
     *   identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [LogView]{@link google.logging.v2.LogView} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listViewsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listViewsStream(request?: protos.google.logging.v2.IListViewsRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listViews`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The bucket whose views are to be listed:
     *
     *       "projects/[PROJECT_ID]/locations/[LOCATION_ID]/buckets/[BUCKET_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the preceding call
     *   to this method. `pageToken` must be the value of `nextPageToken` from the
     *   previous response. The values of other method parameters should be
     *   identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [LogView]{@link google.logging.v2.LogView}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.list_views.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_ListViews_async
     */
    listViewsAsync(request?: protos.google.logging.v2.IListViewsRequest, options?: CallOptions): AsyncIterable<protos.google.logging.v2.ILogView>;
    /**
     * Lists sinks.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose sinks are to be listed:
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [LogSink]{@link google.logging.v2.LogSink}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listSinksAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listSinks(request?: protos.google.logging.v2.IListSinksRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogSink[], protos.google.logging.v2.IListSinksRequest | null, protos.google.logging.v2.IListSinksResponse]>;
    listSinks(request: protos.google.logging.v2.IListSinksRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListSinksRequest, protos.google.logging.v2.IListSinksResponse | null | undefined, protos.google.logging.v2.ILogSink>): void;
    listSinks(request: protos.google.logging.v2.IListSinksRequest, callback: PaginationCallback<protos.google.logging.v2.IListSinksRequest, protos.google.logging.v2.IListSinksResponse | null | undefined, protos.google.logging.v2.ILogSink>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose sinks are to be listed:
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [LogSink]{@link google.logging.v2.LogSink} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listSinksAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listSinksStream(request?: protos.google.logging.v2.IListSinksRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listSinks`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose sinks are to be listed:
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [LogSink]{@link google.logging.v2.LogSink}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.list_sinks.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_ListSinks_async
     */
    listSinksAsync(request?: protos.google.logging.v2.IListSinksRequest, options?: CallOptions): AsyncIterable<protos.google.logging.v2.ILogSink>;
    /**
     * Lists all the exclusions on the _Default sink in a parent resource.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose exclusions are to be listed.
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [LogExclusion]{@link google.logging.v2.LogExclusion}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listExclusionsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listExclusions(request?: protos.google.logging.v2.IListExclusionsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogExclusion[], protos.google.logging.v2.IListExclusionsRequest | null, protos.google.logging.v2.IListExclusionsResponse]>;
    listExclusions(request: protos.google.logging.v2.IListExclusionsRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListExclusionsRequest, protos.google.logging.v2.IListExclusionsResponse | null | undefined, protos.google.logging.v2.ILogExclusion>): void;
    listExclusions(request: protos.google.logging.v2.IListExclusionsRequest, callback: PaginationCallback<protos.google.logging.v2.IListExclusionsRequest, protos.google.logging.v2.IListExclusionsResponse | null | undefined, protos.google.logging.v2.ILogExclusion>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose exclusions are to be listed.
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [LogExclusion]{@link google.logging.v2.LogExclusion} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listExclusionsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listExclusionsStream(request?: protos.google.logging.v2.IListExclusionsRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listExclusions`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The parent resource whose exclusions are to be listed.
     *
     *       "projects/[PROJECT_ID]"
     *       "organizations/[ORGANIZATION_ID]"
     *       "billingAccounts/[BILLING_ACCOUNT_ID]"
     *       "folders/[FOLDER_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [LogExclusion]{@link google.logging.v2.LogExclusion}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/config_service_v2.list_exclusions.js</caption>
     * region_tag:logging_v2_generated_ConfigServiceV2_ListExclusions_async
     */
    listExclusionsAsync(request?: protos.google.logging.v2.IListExclusionsRequest, options?: CallOptions): AsyncIterable<protos.google.logging.v2.ILogExclusion>;
    /**
     * Return a fully-qualified billingAccountCmekSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountCmekSettingsPath(billingAccount: string): string;
    /**
     * Parse the billing_account from BillingAccountCmekSettings resource.
     *
     * @param {string} billingAccountCmekSettingsName
     *   A fully-qualified path representing billing_account_cmekSettings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountCmekSettingsName(billingAccountCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified billingAccountExclusion resource name string.
     *
     * @param {string} billing_account
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    billingAccountExclusionPath(billingAccount: string, exclusion: string): string;
    /**
     * Parse the billing_account from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountExclusionName(billingAccountExclusionName: string): string | number;
    /**
     * Parse the exclusion from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromBillingAccountExclusionName(billingAccountExclusionName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucket resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketPath(billingAccount: string, location: string, bucket: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucketView resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketViewPath(billingAccount: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the view from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLog resource name string.
     *
     * @param {string} billing_account
     * @param {string} log
     * @returns {string} Resource name string.
     */
    billingAccountLogPath(billingAccount: string, log: string): string;
    /**
     * Parse the billing_account from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLogName(billingAccountLogName: string): string | number;
    /**
     * Parse the log from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromBillingAccountLogName(billingAccountLogName: string): string | number;
    /**
     * Return a fully-qualified billingAccountSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountSettingsPath(billingAccount: string): string;
    /**
     * Parse the billing_account from BillingAccountSettings resource.
     *
     * @param {string} billingAccountSettingsName
     *   A fully-qualified path representing billing_account_settings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSettingsName(billingAccountSettingsName: string): string | number;
    /**
     * Return a fully-qualified billingAccountSink resource name string.
     *
     * @param {string} billing_account
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    billingAccountSinkPath(billingAccount: string, sink: string): string;
    /**
     * Parse the billing_account from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSinkName(billingAccountSinkName: string): string | number;
    /**
     * Parse the sink from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromBillingAccountSinkName(billingAccountSinkName: string): string | number;
    /**
     * Return a fully-qualified folderCmekSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderCmekSettingsPath(folder: string): string;
    /**
     * Parse the folder from FolderCmekSettings resource.
     *
     * @param {string} folderCmekSettingsName
     *   A fully-qualified path representing folder_cmekSettings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderCmekSettingsName(folderCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified folderExclusion resource name string.
     *
     * @param {string} folder
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    folderExclusionPath(folder: string, exclusion: string): string;
    /**
     * Parse the folder from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderExclusionName(folderExclusionName: string): string | number;
    /**
     * Parse the exclusion from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromFolderExclusionName(folderExclusionName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucket resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    folderLocationBucketPath(folder: string, location: string, bucket: string): string;
    /**
     * Parse the folder from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Parse the location from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucketView resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    folderLocationBucketViewPath(folder: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the folder from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the location from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the view from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified folderLog resource name string.
     *
     * @param {string} folder
     * @param {string} log
     * @returns {string} Resource name string.
     */
    folderLogPath(folder: string, log: string): string;
    /**
     * Parse the folder from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLogName(folderLogName: string): string | number;
    /**
     * Parse the log from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromFolderLogName(folderLogName: string): string | number;
    /**
     * Return a fully-qualified folderSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderSettingsPath(folder: string): string;
    /**
     * Parse the folder from FolderSettings resource.
     *
     * @param {string} folderSettingsName
     *   A fully-qualified path representing folder_settings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSettingsName(folderSettingsName: string): string | number;
    /**
     * Return a fully-qualified folderSink resource name string.
     *
     * @param {string} folder
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    folderSinkPath(folder: string, sink: string): string;
    /**
     * Parse the folder from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSinkName(folderSinkName: string): string | number;
    /**
     * Parse the sink from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromFolderSinkName(folderSinkName: string): string | number;
    /**
     * Return a fully-qualified location resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @returns {string} Resource name string.
     */
    locationPath(project: string, location: string): string;
    /**
     * Parse the project from Location resource.
     *
     * @param {string} locationName
     *   A fully-qualified path representing Location resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromLocationName(locationName: string): string | number;
    /**
     * Parse the location from Location resource.
     *
     * @param {string} locationName
     *   A fully-qualified path representing Location resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromLocationName(locationName: string): string | number;
    /**
     * Return a fully-qualified logMetric resource name string.
     *
     * @param {string} project
     * @param {string} metric
     * @returns {string} Resource name string.
     */
    logMetricPath(project: string, metric: string): string;
    /**
     * Parse the project from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromLogMetricName(logMetricName: string): string | number;
    /**
     * Parse the metric from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the metric.
     */
    matchMetricFromLogMetricName(logMetricName: string): string | number;
    /**
     * Return a fully-qualified organizationCmekSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationCmekSettingsPath(organization: string): string;
    /**
     * Parse the organization from OrganizationCmekSettings resource.
     *
     * @param {string} organizationCmekSettingsName
     *   A fully-qualified path representing organization_cmekSettings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationCmekSettingsName(organizationCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified organizationExclusion resource name string.
     *
     * @param {string} organization
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    organizationExclusionPath(organization: string, exclusion: string): string;
    /**
     * Parse the organization from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationExclusionName(organizationExclusionName: string): string | number;
    /**
     * Parse the exclusion from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromOrganizationExclusionName(organizationExclusionName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucket resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    organizationLocationBucketPath(organization: string, location: string, bucket: string): string;
    /**
     * Parse the organization from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucketView resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    organizationLocationBucketViewPath(organization: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the organization from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the view from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified organizationLog resource name string.
     *
     * @param {string} organization
     * @param {string} log
     * @returns {string} Resource name string.
     */
    organizationLogPath(organization: string, log: string): string;
    /**
     * Parse the organization from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLogName(organizationLogName: string): string | number;
    /**
     * Parse the log from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromOrganizationLogName(organizationLogName: string): string | number;
    /**
     * Return a fully-qualified organizationSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationSettingsPath(organization: string): string;
    /**
     * Parse the organization from OrganizationSettings resource.
     *
     * @param {string} organizationSettingsName
     *   A fully-qualified path representing organization_settings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSettingsName(organizationSettingsName: string): string | number;
    /**
     * Return a fully-qualified organizationSink resource name string.
     *
     * @param {string} organization
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    organizationSinkPath(organization: string, sink: string): string;
    /**
     * Parse the organization from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSinkName(organizationSinkName: string): string | number;
    /**
     * Parse the sink from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromOrganizationSinkName(organizationSinkName: string): string | number;
    /**
     * Return a fully-qualified project resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectPath(project: string): string;
    /**
     * Parse the project from Project resource.
     *
     * @param {string} projectName
     *   A fully-qualified path representing Project resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectName(projectName: string): string | number;
    /**
     * Return a fully-qualified projectCmekSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectCmekSettingsPath(project: string): string;
    /**
     * Parse the project from ProjectCmekSettings resource.
     *
     * @param {string} projectCmekSettingsName
     *   A fully-qualified path representing project_cmekSettings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectCmekSettingsName(projectCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified projectExclusion resource name string.
     *
     * @param {string} project
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    projectExclusionPath(project: string, exclusion: string): string;
    /**
     * Parse the project from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectExclusionName(projectExclusionName: string): string | number;
    /**
     * Parse the exclusion from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromProjectExclusionName(projectExclusionName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucket resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    projectLocationBucketPath(project: string, location: string, bucket: string): string;
    /**
     * Parse the project from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucketView resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    projectLocationBucketViewPath(project: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the project from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the view from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified projectLog resource name string.
     *
     * @param {string} project
     * @param {string} log
     * @returns {string} Resource name string.
     */
    projectLogPath(project: string, log: string): string;
    /**
     * Parse the project from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLogName(projectLogName: string): string | number;
    /**
     * Parse the log from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromProjectLogName(projectLogName: string): string | number;
    /**
     * Return a fully-qualified projectSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectSettingsPath(project: string): string;
    /**
     * Parse the project from ProjectSettings resource.
     *
     * @param {string} projectSettingsName
     *   A fully-qualified path representing project_settings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSettingsName(projectSettingsName: string): string | number;
    /**
     * Return a fully-qualified projectSink resource name string.
     *
     * @param {string} project
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    projectSinkPath(project: string, sink: string): string;
    /**
     * Parse the project from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSinkName(projectSinkName: string): string | number;
    /**
     * Parse the sink from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromProjectSinkName(projectSinkName: string): string | number;
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close(): Promise<void>;
}
