import requests


def get_docker_hub_tags(repository, username=None, token=None):
    # 注意：这里的URL是虚构的，用于示例。你需要替换为Docker Hub API的实际URL。
    # 如果API需要认证，你可能需要将用户名和令牌作为请求的一部分发送。
    api_url = f"https://registry-1.docker.io/v2/{username or ''}{repository}/tags/list"
    headers = {
        'Authorization': f'Bearer {token}' if token else '',
        'Accept': 'application/vnd.docker.distribution.manifest.v2+json'
    }

    try:
        response = requests.get(api_url, headers=headers)
        response.raise_for_status()  # 如果响应状态码不是200，则抛出HTTPError异常

        # 解析响应体，这里假设返回的是JSON格式，并包含tags列表
        tags = response.json().get('tags', [])
        return tags
    except requests.RequestException as e:
        print(f"Error fetching tags: {e}")
        return []

    # 替换以下变量为你的Docker Hub用户名（如果有）、仓库名和（可选的）API令牌


username = "your_username"  # 如果仓库是私有的或需要认证，则提供
repository = "library/ubuntu"  # 例如，使用官方Ubuntu镜像
token = "your_docker_hub_token"  # 如果API需要认证，则提供

tags = get_docker_hub_tags(repository, username, token)
print("Tags:", tags)