/*!
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
/// <reference types="node" />
import * as http from 'http';
export declare type RawHttpRequest = http.IncomingMessage & CloudLoggingHttpRequest;
export interface CloudLoggingHttpRequest {
    requestMethod?: string;
    requestUrl?: string;
    requestSize?: number;
    status?: number;
    responseSize?: number;
    userAgent?: string;
    remoteIp?: string;
    serverIp?: string;
    referer?: string;
    latency?: {
        seconds: number;
        nanos: number;
    };
    cacheLookup?: boolean;
    cacheHit?: boolean;
    cacheValidatedWithOriginServer?: boolean;
    cacheFillBytes?: number;
    protocol?: string;
}
/**
 * Abstraction of http.IncomingMessage used by middleware implementation.
 */
export interface ServerRequest extends http.IncomingMessage {
    originalUrl: string;
}
/**
 * makeHttpRequestData turns raw incoming HTTPRequests into structured
 * HTTPRequest objects interpreted by Cloud Logging.
 *
 * @param req
 * @param res
 * @param latencyMilliseconds
 */
export declare function makeHttpRequestData(req: ServerRequest | http.IncomingMessage, res?: http.ServerResponse, latencyMilliseconds?: number): CloudLoggingHttpRequest;
/**
 * isRawHttpRequest detects whether a request object extends the
 * http.IncomingMessage class. It should return true on HTTP compliant requests
 * and all requests created by an http.Server.
 *
 * @param req
 */
export declare function isRawHttpRequest(req?: any): req is RawHttpRequest;
