import { IDiagnosticLogger } from "../JavaScriptSDK.Interfaces/IDiagnosticLogger";
import { ICookieMgr } from "../JavaScriptSDK.Interfaces/ICookieMgr";
import { IConfiguration } from "../JavaScriptSDK.Interfaces/IConfiguration";
import { IAppInsightsCore } from "../JavaScriptSDK.Interfaces/IAppInsightsCore";
/**
 * @ignore
 * DO NOT USE or export from the module, this is exposed as public to support backward compatibility of previous static utility methods only.
 * If you want to manager cookies either use the ICookieMgr available from the core instance via getCookieMgr() or create
 * your own instance of the CookieMgr and use that.
 * Using this directly for enabling / disabling cookie handling will not only affect your usage but EVERY user of cookies.
 * Example, if you are using a shared component that is also using Application Insights you will affect their cookie handling.
 * @param logger - The DiagnosticLogger to use for reporting errors.
 */
export declare function _gblCookieMgr(config?: IConfiguration, logger?: IDiagnosticLogger): ICookieMgr;
/**
 * Helper to return the ICookieMgr from the core (if not null/undefined) or a default implementation
 * associated with the configuration or a legacy default.
 * @param core
 * @param config
 * @returns
 */
export declare function safeGetCookieMgr(core: IAppInsightsCore, config?: IConfiguration): ICookieMgr;
export declare function createCookieMgr(rootConfig?: IConfiguration, logger?: IDiagnosticLogger): ICookieMgr;
export declare function areCookiesSupported(logger?: IDiagnosticLogger): any;
export declare function uaDisallowsSameSiteNone(userAgent: string): boolean;
