#!/bin/bash

# 设置要检查的目录和Git仓库的URL
TARGET_DIR="gpu-base-image-test"
GIT_REPO='http://developer.hpccube.com/codes/chenpangpang/gpu-base-image-test.git'

echo "--------------------------拉取代码--------------------------"
# 检查目录是否存在
if [ ! -d "$TARGET_DIR" ]; then
    echo "目录 '$TARGET_DIR' 不存在，正在从Git拉取代码..."
    # 尝试从Git拉取代码
    git clone $GIT_REPO
    # 检查是否成功拉取
    if [ $? -eq 0 ]; then
        echo "代码拉取成功，目录已创建。"
    else
        echo "拉取代码失败，请检查Git仓库URL或网络连接。"
        exit 1
    fi
else
    echo "目录 $TARGET_DIR 已存在，无需拉取。"
fi

echo "--------------------------验证镜像--------------------------"
docker run --rm --platform=linux/amd64 --gpus all -v ./$TARGET_DIR:/workspace --workdir /workspace/gpt2 $1 python infer.py