/// <reference types="node" />
import * as gax from 'google-gax';
import { Callback, CallOptions, Descriptors, ClientOptions, PaginationCallback } from 'google-gax';
import { Transform } from 'stream';
import * as protos from '../../protos/protos';
/**
 *  Service for configuring logs-based metrics.
 * @class
 * @memberof v2
 */
export declare class MetricsServiceV2Client {
    private _terminated;
    private _opts;
    private _providedCustomServicePath;
    private _gaxModule;
    private _gaxGrpc;
    private _protos;
    private _defaults;
    auth: gax.GoogleAuth;
    descriptors: Descriptors;
    warn: (code: string, message: string, warnType?: string) => void;
    innerApiCalls: {
        [name: string]: Function;
    };
    pathTemplates: {
        [name: string]: gax.PathTemplate;
    };
    metricsServiceV2Stub?: Promise<{
        [name: string]: Function;
    }>;
    /**
     * Construct an instance of MetricsServiceV2Client.
     *
     * @param {object} [options] - The configuration object.
     * The options accepted by the constructor are described in detail
     * in [this document](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#creating-the-client-instance).
     * The common options are:
     * @param {object} [options.credentials] - Credentials object.
     * @param {string} [options.credentials.client_email]
     * @param {string} [options.credentials.private_key]
     * @param {string} [options.email] - Account email address. Required when
     *     using a .pem or .p12 keyFilename.
     * @param {string} [options.keyFilename] - Full path to the a .json, .pem, or
     *     .p12 key downloaded from the Google Developers Console. If you provide
     *     a path to a JSON file, the projectId option below is not necessary.
     *     NOTE: .pem and .p12 require you to specify options.email as well.
     * @param {number} [options.port] - The port on which to connect to
     *     the remote host.
     * @param {string} [options.projectId] - The project ID from the Google
     *     Developer's Console, e.g. 'grape-spaceship-123'. We will also check
     *     the environment variable GCLOUD_PROJECT for your project ID. If your
     *     app is running in an environment which supports
     *     {@link https://developers.google.com/identity/protocols/application-default-credentials Application Default Credentials},
     *     your project ID will be detected automatically.
     * @param {string} [options.apiEndpoint] - The domain name of the
     *     API remote host.
     * @param {gax.ClientConfig} [options.clientConfig] - Client configuration override.
     *     Follows the structure of {@link gapicConfig}.
     * @param {boolean} [options.fallback] - Use HTTP fallback mode.
     *     In fallback mode, a special browser-compatible transport implementation is used
     *     instead of gRPC transport. In browser context (if the `window` object is defined)
     *     the fallback mode is enabled automatically; set `options.fallback` to `false`
     *     if you need to override this behavior.
     */
    constructor(opts?: ClientOptions);
    /**
     * Initialize the client.
     * Performs asynchronous operations (such as authentication) and prepares the client.
     * This function will be called automatically when any class method is called for the
     * first time, but if you need to initialize it before calling an actual method,
     * feel free to call initialize() directly.
     *
     * You can await on this method if you want to make sure the client is initialized.
     *
     * @returns {Promise} A promise that resolves to an authenticated service stub.
     */
    initialize(): Promise<{
        [name: string]: Function;
    }>;
    /**
     * The DNS address for this API service.
     * @returns {string} The DNS address for this service.
     */
    static get servicePath(): string;
    /**
     * The DNS address for this API service - same as servicePath(),
     * exists for compatibility reasons.
     * @returns {string} The DNS address for this service.
     */
    static get apiEndpoint(): string;
    /**
     * The port for this API service.
     * @returns {number} The default port for this service.
     */
    static get port(): number;
    /**
     * The scopes needed to make gRPC calls for every method defined
     * in this service.
     * @returns {string[]} List of default scopes.
     */
    static get scopes(): string[];
    getProjectId(): Promise<string>;
    getProjectId(callback: Callback<string, undefined, undefined>): void;
    /**
     * Gets a logs-based metric.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.metricName
     *   Required. The resource name of the desired metric:
     *
     *       "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogMetric]{@link google.logging.v2.LogMetric}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/metrics_service_v2.get_log_metric.js</caption>
     * region_tag:logging_v2_generated_MetricsServiceV2_GetLogMetric_async
     */
    getLogMetric(request?: protos.google.logging.v2.IGetLogMetricRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogMetric, protos.google.logging.v2.IGetLogMetricRequest | undefined, {} | undefined]>;
    getLogMetric(request: protos.google.logging.v2.IGetLogMetricRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogMetric, protos.google.logging.v2.IGetLogMetricRequest | null | undefined, {} | null | undefined>): void;
    getLogMetric(request: protos.google.logging.v2.IGetLogMetricRequest, callback: Callback<protos.google.logging.v2.ILogMetric, protos.google.logging.v2.IGetLogMetricRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Creates a logs-based metric.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The resource name of the project in which to create the metric:
     *
     *       "projects/[PROJECT_ID]"
     *
     *   The new metric must be provided in the request.
     * @param {google.logging.v2.LogMetric} request.metric
     *   Required. The new logs-based metric, which must not have an identifier that
     *   already exists.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogMetric]{@link google.logging.v2.LogMetric}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/metrics_service_v2.create_log_metric.js</caption>
     * region_tag:logging_v2_generated_MetricsServiceV2_CreateLogMetric_async
     */
    createLogMetric(request?: protos.google.logging.v2.ICreateLogMetricRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogMetric, protos.google.logging.v2.ICreateLogMetricRequest | undefined, {} | undefined]>;
    createLogMetric(request: protos.google.logging.v2.ICreateLogMetricRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogMetric, protos.google.logging.v2.ICreateLogMetricRequest | null | undefined, {} | null | undefined>): void;
    createLogMetric(request: protos.google.logging.v2.ICreateLogMetricRequest, callback: Callback<protos.google.logging.v2.ILogMetric, protos.google.logging.v2.ICreateLogMetricRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Creates or updates a logs-based metric.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.metricName
     *   Required. The resource name of the metric to update:
     *
     *       "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
     *
     *   The updated metric must be provided in the request and it's
     *   `name` field must be the same as `[METRIC_ID]` If the metric
     *   does not exist in `[PROJECT_ID]`, then a new metric is created.
     * @param {google.logging.v2.LogMetric} request.metric
     *   Required. The updated metric.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [LogMetric]{@link google.logging.v2.LogMetric}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/metrics_service_v2.update_log_metric.js</caption>
     * region_tag:logging_v2_generated_MetricsServiceV2_UpdateLogMetric_async
     */
    updateLogMetric(request?: protos.google.logging.v2.IUpdateLogMetricRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogMetric, protos.google.logging.v2.IUpdateLogMetricRequest | undefined, {} | undefined]>;
    updateLogMetric(request: protos.google.logging.v2.IUpdateLogMetricRequest, options: CallOptions, callback: Callback<protos.google.logging.v2.ILogMetric, protos.google.logging.v2.IUpdateLogMetricRequest | null | undefined, {} | null | undefined>): void;
    updateLogMetric(request: protos.google.logging.v2.IUpdateLogMetricRequest, callback: Callback<protos.google.logging.v2.ILogMetric, protos.google.logging.v2.IUpdateLogMetricRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Deletes a logs-based metric.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.metricName
     *   Required. The resource name of the metric to delete:
     *
     *       "projects/[PROJECT_ID]/metrics/[METRIC_ID]"
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is an object representing [Empty]{@link google.protobuf.Empty}.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#regular-methods)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/metrics_service_v2.delete_log_metric.js</caption>
     * region_tag:logging_v2_generated_MetricsServiceV2_DeleteLogMetric_async
     */
    deleteLogMetric(request?: protos.google.logging.v2.IDeleteLogMetricRequest, options?: CallOptions): Promise<[protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteLogMetricRequest | undefined, {} | undefined]>;
    deleteLogMetric(request: protos.google.logging.v2.IDeleteLogMetricRequest, options: CallOptions, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteLogMetricRequest | null | undefined, {} | null | undefined>): void;
    deleteLogMetric(request: protos.google.logging.v2.IDeleteLogMetricRequest, callback: Callback<protos.google.protobuf.IEmpty, protos.google.logging.v2.IDeleteLogMetricRequest | null | undefined, {} | null | undefined>): void;
    /**
     * Lists logs-based metrics.
     *
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The name of the project containing the metrics:
     *
     *       "projects/[PROJECT_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Promise} - The promise which resolves to an array.
     *   The first element of the array is Array of [LogMetric]{@link google.logging.v2.LogMetric}.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed and will merge results from all the pages into this array.
     *   Note that it can affect your quota.
     *   We recommend using `listLogMetricsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listLogMetrics(request?: protos.google.logging.v2.IListLogMetricsRequest, options?: CallOptions): Promise<[protos.google.logging.v2.ILogMetric[], protos.google.logging.v2.IListLogMetricsRequest | null, protos.google.logging.v2.IListLogMetricsResponse]>;
    listLogMetrics(request: protos.google.logging.v2.IListLogMetricsRequest, options: CallOptions, callback: PaginationCallback<protos.google.logging.v2.IListLogMetricsRequest, protos.google.logging.v2.IListLogMetricsResponse | null | undefined, protos.google.logging.v2.ILogMetric>): void;
    listLogMetrics(request: protos.google.logging.v2.IListLogMetricsRequest, callback: PaginationCallback<protos.google.logging.v2.IListLogMetricsRequest, protos.google.logging.v2.IListLogMetricsResponse | null | undefined, protos.google.logging.v2.ILogMetric>): void;
    /**
     * Equivalent to `method.name.toCamelCase()`, but returns a NodeJS Stream object.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The name of the project containing the metrics:
     *
     *       "projects/[PROJECT_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Stream}
     *   An object stream which emits an object representing [LogMetric]{@link google.logging.v2.LogMetric} on 'data' event.
     *   The client library will perform auto-pagination by default: it will call the API as many
     *   times as needed. Note that it can affect your quota.
     *   We recommend using `listLogMetricsAsync()`
     *   method described below for async iteration which you can stop as needed.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     */
    listLogMetricsStream(request?: protos.google.logging.v2.IListLogMetricsRequest, options?: CallOptions): Transform;
    /**
     * Equivalent to `listLogMetrics`, but returns an iterable object.
     *
     * `for`-`await`-`of` syntax is used with the iterable to get response elements on-demand.
     * @param {Object} request
     *   The request object that will be sent.
     * @param {string} request.parent
     *   Required. The name of the project containing the metrics:
     *
     *       "projects/[PROJECT_ID]"
     * @param {string} [request.pageToken]
     *   Optional. If present, then retrieve the next batch of results from the
     *   preceding call to this method. `pageToken` must be the value of
     *   `nextPageToken` from the previous response. The values of other method
     *   parameters should be identical to those in the previous call.
     * @param {number} [request.pageSize]
     *   Optional. The maximum number of results to return from this request.
     *   Non-positive values are ignored. The presence of `nextPageToken` in the
     *   response indicates that more results might be available.
     * @param {object} [options]
     *   Call options. See {@link https://googleapis.dev/nodejs/google-gax/latest/interfaces/CallOptions.html|CallOptions} for more details.
     * @returns {Object}
     *   An iterable Object that allows [async iteration](https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Iteration_protocols).
     *   When you iterate the returned iterable, each element will be an object representing
     *   [LogMetric]{@link google.logging.v2.LogMetric}. The API will be called under the hood as needed, once per the page,
     *   so you can stop the iteration when you don't need more results.
     *   Please see the
     *   [documentation](https://github.com/googleapis/gax-nodejs/blob/master/client-libraries.md#auto-pagination)
     *   for more details and examples.
     * @example <caption>include:samples/generated/v2/metrics_service_v2.list_log_metrics.js</caption>
     * region_tag:logging_v2_generated_MetricsServiceV2_ListLogMetrics_async
     */
    listLogMetricsAsync(request?: protos.google.logging.v2.IListLogMetricsRequest, options?: CallOptions): AsyncIterable<protos.google.logging.v2.ILogMetric>;
    /**
     * Return a fully-qualified billingAccountCmekSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountCmekSettingsPath(billingAccount: string): string;
    /**
     * Parse the billing_account from BillingAccountCmekSettings resource.
     *
     * @param {string} billingAccountCmekSettingsName
     *   A fully-qualified path representing billing_account_cmekSettings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountCmekSettingsName(billingAccountCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified billingAccountExclusion resource name string.
     *
     * @param {string} billing_account
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    billingAccountExclusionPath(billingAccount: string, exclusion: string): string;
    /**
     * Parse the billing_account from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountExclusionName(billingAccountExclusionName: string): string | number;
    /**
     * Parse the exclusion from BillingAccountExclusion resource.
     *
     * @param {string} billingAccountExclusionName
     *   A fully-qualified path representing billing_account_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromBillingAccountExclusionName(billingAccountExclusionName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucket resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketPath(billingAccount: string, location: string, bucket: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucket resource.
     *
     * @param {string} billingAccountLocationBucketName
     *   A fully-qualified path representing billing_account_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketName(billingAccountLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLocationBucketView resource name string.
     *
     * @param {string} billing_account
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    billingAccountLocationBucketViewPath(billingAccount: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the billing_account from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the location from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Parse the view from BillingAccountLocationBucketView resource.
     *
     * @param {string} billingAccountLocationBucketViewName
     *   A fully-qualified path representing billing_account_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromBillingAccountLocationBucketViewName(billingAccountLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified billingAccountLog resource name string.
     *
     * @param {string} billing_account
     * @param {string} log
     * @returns {string} Resource name string.
     */
    billingAccountLogPath(billingAccount: string, log: string): string;
    /**
     * Parse the billing_account from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountLogName(billingAccountLogName: string): string | number;
    /**
     * Parse the log from BillingAccountLog resource.
     *
     * @param {string} billingAccountLogName
     *   A fully-qualified path representing billing_account_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromBillingAccountLogName(billingAccountLogName: string): string | number;
    /**
     * Return a fully-qualified billingAccountSettings resource name string.
     *
     * @param {string} billing_account
     * @returns {string} Resource name string.
     */
    billingAccountSettingsPath(billingAccount: string): string;
    /**
     * Parse the billing_account from BillingAccountSettings resource.
     *
     * @param {string} billingAccountSettingsName
     *   A fully-qualified path representing billing_account_settings resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSettingsName(billingAccountSettingsName: string): string | number;
    /**
     * Return a fully-qualified billingAccountSink resource name string.
     *
     * @param {string} billing_account
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    billingAccountSinkPath(billingAccount: string, sink: string): string;
    /**
     * Parse the billing_account from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the billing_account.
     */
    matchBillingAccountFromBillingAccountSinkName(billingAccountSinkName: string): string | number;
    /**
     * Parse the sink from BillingAccountSink resource.
     *
     * @param {string} billingAccountSinkName
     *   A fully-qualified path representing billing_account_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromBillingAccountSinkName(billingAccountSinkName: string): string | number;
    /**
     * Return a fully-qualified folderCmekSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderCmekSettingsPath(folder: string): string;
    /**
     * Parse the folder from FolderCmekSettings resource.
     *
     * @param {string} folderCmekSettingsName
     *   A fully-qualified path representing folder_cmekSettings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderCmekSettingsName(folderCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified folderExclusion resource name string.
     *
     * @param {string} folder
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    folderExclusionPath(folder: string, exclusion: string): string;
    /**
     * Parse the folder from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderExclusionName(folderExclusionName: string): string | number;
    /**
     * Parse the exclusion from FolderExclusion resource.
     *
     * @param {string} folderExclusionName
     *   A fully-qualified path representing folder_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromFolderExclusionName(folderExclusionName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucket resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    folderLocationBucketPath(folder: string, location: string, bucket: string): string;
    /**
     * Parse the folder from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Parse the location from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucket resource.
     *
     * @param {string} folderLocationBucketName
     *   A fully-qualified path representing folder_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketName(folderLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified folderLocationBucketView resource name string.
     *
     * @param {string} folder
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    folderLocationBucketViewPath(folder: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the folder from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the location from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Parse the view from FolderLocationBucketView resource.
     *
     * @param {string} folderLocationBucketViewName
     *   A fully-qualified path representing folder_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromFolderLocationBucketViewName(folderLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified folderLog resource name string.
     *
     * @param {string} folder
     * @param {string} log
     * @returns {string} Resource name string.
     */
    folderLogPath(folder: string, log: string): string;
    /**
     * Parse the folder from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderLogName(folderLogName: string): string | number;
    /**
     * Parse the log from FolderLog resource.
     *
     * @param {string} folderLogName
     *   A fully-qualified path representing folder_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromFolderLogName(folderLogName: string): string | number;
    /**
     * Return a fully-qualified folderSettings resource name string.
     *
     * @param {string} folder
     * @returns {string} Resource name string.
     */
    folderSettingsPath(folder: string): string;
    /**
     * Parse the folder from FolderSettings resource.
     *
     * @param {string} folderSettingsName
     *   A fully-qualified path representing folder_settings resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSettingsName(folderSettingsName: string): string | number;
    /**
     * Return a fully-qualified folderSink resource name string.
     *
     * @param {string} folder
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    folderSinkPath(folder: string, sink: string): string;
    /**
     * Parse the folder from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the folder.
     */
    matchFolderFromFolderSinkName(folderSinkName: string): string | number;
    /**
     * Parse the sink from FolderSink resource.
     *
     * @param {string} folderSinkName
     *   A fully-qualified path representing folder_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromFolderSinkName(folderSinkName: string): string | number;
    /**
     * Return a fully-qualified logMetric resource name string.
     *
     * @param {string} project
     * @param {string} metric
     * @returns {string} Resource name string.
     */
    logMetricPath(project: string, metric: string): string;
    /**
     * Parse the project from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromLogMetricName(logMetricName: string): string | number;
    /**
     * Parse the metric from LogMetric resource.
     *
     * @param {string} logMetricName
     *   A fully-qualified path representing LogMetric resource.
     * @returns {string} A string representing the metric.
     */
    matchMetricFromLogMetricName(logMetricName: string): string | number;
    /**
     * Return a fully-qualified organizationCmekSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationCmekSettingsPath(organization: string): string;
    /**
     * Parse the organization from OrganizationCmekSettings resource.
     *
     * @param {string} organizationCmekSettingsName
     *   A fully-qualified path representing organization_cmekSettings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationCmekSettingsName(organizationCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified organizationExclusion resource name string.
     *
     * @param {string} organization
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    organizationExclusionPath(organization: string, exclusion: string): string;
    /**
     * Parse the organization from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationExclusionName(organizationExclusionName: string): string | number;
    /**
     * Parse the exclusion from OrganizationExclusion resource.
     *
     * @param {string} organizationExclusionName
     *   A fully-qualified path representing organization_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromOrganizationExclusionName(organizationExclusionName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucket resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    organizationLocationBucketPath(organization: string, location: string, bucket: string): string;
    /**
     * Parse the organization from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucket resource.
     *
     * @param {string} organizationLocationBucketName
     *   A fully-qualified path representing organization_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketName(organizationLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified organizationLocationBucketView resource name string.
     *
     * @param {string} organization
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    organizationLocationBucketViewPath(organization: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the organization from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the location from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Parse the view from OrganizationLocationBucketView resource.
     *
     * @param {string} organizationLocationBucketViewName
     *   A fully-qualified path representing organization_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromOrganizationLocationBucketViewName(organizationLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified organizationLog resource name string.
     *
     * @param {string} organization
     * @param {string} log
     * @returns {string} Resource name string.
     */
    organizationLogPath(organization: string, log: string): string;
    /**
     * Parse the organization from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationLogName(organizationLogName: string): string | number;
    /**
     * Parse the log from OrganizationLog resource.
     *
     * @param {string} organizationLogName
     *   A fully-qualified path representing organization_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromOrganizationLogName(organizationLogName: string): string | number;
    /**
     * Return a fully-qualified organizationSettings resource name string.
     *
     * @param {string} organization
     * @returns {string} Resource name string.
     */
    organizationSettingsPath(organization: string): string;
    /**
     * Parse the organization from OrganizationSettings resource.
     *
     * @param {string} organizationSettingsName
     *   A fully-qualified path representing organization_settings resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSettingsName(organizationSettingsName: string): string | number;
    /**
     * Return a fully-qualified organizationSink resource name string.
     *
     * @param {string} organization
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    organizationSinkPath(organization: string, sink: string): string;
    /**
     * Parse the organization from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the organization.
     */
    matchOrganizationFromOrganizationSinkName(organizationSinkName: string): string | number;
    /**
     * Parse the sink from OrganizationSink resource.
     *
     * @param {string} organizationSinkName
     *   A fully-qualified path representing organization_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromOrganizationSinkName(organizationSinkName: string): string | number;
    /**
     * Return a fully-qualified project resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectPath(project: string): string;
    /**
     * Parse the project from Project resource.
     *
     * @param {string} projectName
     *   A fully-qualified path representing Project resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectName(projectName: string): string | number;
    /**
     * Return a fully-qualified projectCmekSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectCmekSettingsPath(project: string): string;
    /**
     * Parse the project from ProjectCmekSettings resource.
     *
     * @param {string} projectCmekSettingsName
     *   A fully-qualified path representing project_cmekSettings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectCmekSettingsName(projectCmekSettingsName: string): string | number;
    /**
     * Return a fully-qualified projectExclusion resource name string.
     *
     * @param {string} project
     * @param {string} exclusion
     * @returns {string} Resource name string.
     */
    projectExclusionPath(project: string, exclusion: string): string;
    /**
     * Parse the project from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectExclusionName(projectExclusionName: string): string | number;
    /**
     * Parse the exclusion from ProjectExclusion resource.
     *
     * @param {string} projectExclusionName
     *   A fully-qualified path representing project_exclusion resource.
     * @returns {string} A string representing the exclusion.
     */
    matchExclusionFromProjectExclusionName(projectExclusionName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucket resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @returns {string} Resource name string.
     */
    projectLocationBucketPath(project: string, location: string, bucket: string): string;
    /**
     * Parse the project from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucket resource.
     *
     * @param {string} projectLocationBucketName
     *   A fully-qualified path representing project_location_bucket resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketName(projectLocationBucketName: string): string | number;
    /**
     * Return a fully-qualified projectLocationBucketView resource name string.
     *
     * @param {string} project
     * @param {string} location
     * @param {string} bucket
     * @param {string} view
     * @returns {string} Resource name string.
     */
    projectLocationBucketViewPath(project: string, location: string, bucket: string, view: string): string;
    /**
     * Parse the project from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the location from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the location.
     */
    matchLocationFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the bucket from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the bucket.
     */
    matchBucketFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Parse the view from ProjectLocationBucketView resource.
     *
     * @param {string} projectLocationBucketViewName
     *   A fully-qualified path representing project_location_bucket_view resource.
     * @returns {string} A string representing the view.
     */
    matchViewFromProjectLocationBucketViewName(projectLocationBucketViewName: string): string | number;
    /**
     * Return a fully-qualified projectLog resource name string.
     *
     * @param {string} project
     * @param {string} log
     * @returns {string} Resource name string.
     */
    projectLogPath(project: string, log: string): string;
    /**
     * Parse the project from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectLogName(projectLogName: string): string | number;
    /**
     * Parse the log from ProjectLog resource.
     *
     * @param {string} projectLogName
     *   A fully-qualified path representing project_log resource.
     * @returns {string} A string representing the log.
     */
    matchLogFromProjectLogName(projectLogName: string): string | number;
    /**
     * Return a fully-qualified projectSettings resource name string.
     *
     * @param {string} project
     * @returns {string} Resource name string.
     */
    projectSettingsPath(project: string): string;
    /**
     * Parse the project from ProjectSettings resource.
     *
     * @param {string} projectSettingsName
     *   A fully-qualified path representing project_settings resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSettingsName(projectSettingsName: string): string | number;
    /**
     * Return a fully-qualified projectSink resource name string.
     *
     * @param {string} project
     * @param {string} sink
     * @returns {string} Resource name string.
     */
    projectSinkPath(project: string, sink: string): string;
    /**
     * Parse the project from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the project.
     */
    matchProjectFromProjectSinkName(projectSinkName: string): string | number;
    /**
     * Parse the sink from ProjectSink resource.
     *
     * @param {string} projectSinkName
     *   A fully-qualified path representing project_sink resource.
     * @returns {string} A string representing the sink.
     */
    matchSinkFromProjectSinkName(projectSinkName: string): string | number;
    /**
     * Terminate the gRPC channel and close the client.
     *
     * The client will no longer be usable and all future behavior is undefined.
     * @returns {Promise} A promise that resolves when the client is closed.
     */
    close(): Promise<void>;
}
