import { IEventProperty } from "./DataModels";
import { GuidStyle, FieldValueSanitizerType, EventLatency } from "./Enums";
import { ITelemetryItem, objForEachKey, isNumber, isReactNative, isString, isBoolean, isObject, perfNow, addEventHandler, uaDisallowsSameSiteNone, objDefineAccessors, toISOString, strTrim, isFunction, objKeys, arrReduce, arrMap, arrIndexOf, arrForEach, areCookiesSupported, ICookieMgr, ICoreUtils, strEndsWith, useXDomainRequest, isBeaconsSupported, addPageUnloadEventListener } from "@microsoft/applicationinsights-core-js";
export declare const Version = "3.2.3";
export declare const FullVersionString: string;
/**
 * Checks if document object is available
 */
export declare var isDocumentObjectAvailable: boolean;
/**
 * Checks if window object is available
 */
export declare var isWindowObjectAvailable: boolean;
/**
 * Checks if value is assigned to the given param.
 * @param value - The token from which the tenant id is to be extracted.
 * @returns True/false denoting if value is assigned to the param.
 */
export declare function isValueAssigned(value: any): boolean;
/**
 * Gets the tenant id from the tenant token.
 * @param apiKey - The token from which the tenant id is to be extracted.
 * @returns The tenant id.
 */
export declare function getTenantId(apiKey: string | undefined): string;
/**
 * Checks if Uint8Array are available in the current environment. Safari and Firefox along with
 * ReactNative are known to not support Uint8Array properly.
 * @returns True if available, false otherwise.
 */
export declare function isUint8ArrayAvailable(): boolean;
/**
 * Checks if the value is a valid EventLatency.
 * @param value - The value that needs to be checked.
 * @returns True if the value is in AWTEventLatency, false otherwise.
 */
export declare function isLatency(value: EventLatency | undefined): boolean;
/**
 * Sanitizes the Property. It checks the that the property name and value are valid. It also
 * checks/populates the correct type and pii of the property value.
 * @param name - property name                          - The property name.
 * @param property - The property value or an IEventProperty containing value,
 * type ,pii and customer content.
 * @returns IEventProperty containing valid name, value, pii and type or null if invalid.
 */
export declare function sanitizeProperty(name: string, property: string | number | boolean | string[] | number[] | boolean[] | object | IEventProperty, stringifyObjects?: boolean): IEventProperty | null;
export declare function getCommonSchemaMetaData(value: string | boolean | number | string[] | number[] | boolean[] | undefined, kind: number | undefined, type?: number | undefined): number;
/**
 * @deprecated - Use the core.getCookieMgr().disable()
 * Force the SDK not to store and read any data from cookies.
 * Overriding the applicationinsights-core version for tree-shaking
 */
export declare function disableCookies(): void;
/**
 * @deprecated - Use the oneDs.getCookieMgr().set()
 * Sets the value of a cookie.
 * @param name - Cookie name.
 * @param value - Cookie value.
 * @param days - Expiration days.
 */
export declare function setCookie(name: string, value: string, days: number): void;
/**
 * @deprecated - Use the oneDs.getCookieMgr().del()
 * Deletes a cookie, by setting its expiration to -1.
 * @param name - Cookie name to delete.
 */
export declare function deleteCookie(name: string): void;
/**
 * @deprecated - Use the oneDs.getCookieMgr().get()
 * Gets the cookie value for the specified cookie.
 * if value is k1=v1&k2==v2 then will return 'v1' for key 'k1'
 * @param cookieName - Cookie name.
 */
export declare function getCookie(name: string): string;
/**
 * Helper to get and decode the cookie value using decodeURIComponent, this is for historical
 * backward compatibility where the document.cookie value was decoded before parsing.
 * @param cookieMgr - The cookie manager to use
 * @param name - The name of the cookie to get
 * @param decode - A flag to indicate whether the cookie value should be decoded
 * @returns The decoded cookie value (if available) otherwise an empty string.
 */
export declare function getCookieValue(cookieMgr: ICookieMgr, name: string, decode?: boolean): string;
/**
 * Create a new guid.
 * @param style - The style of guid to generated, defaults to Digits
 * Digits (Default) : 32 digits separated by hyphens: 00000000-0000-0000-0000-000000000000
 * Braces - 32 digits separated by hyphens, enclosed in braces: {00000000-0000-0000-0000-000000000000}
 * Parentheses - 32 digits separated by hyphens, enclosed in parentheses: (00000000-0000-0000-0000-000000000000)
 * Numeric - 32 digits: 00000000000000000000000000000000
 * @returns The formatted guid.
 */
export declare function createGuid(style?: GuidStyle): string;
/**
 * Pass in the objects to merge as arguments.
 * @param obj1 - object to merge.  Set this argument to 'true' for a deep extend.
 * @param obj2 - object to merge.
 * @param obj3 - object to merge.
 * @param obj4 - object to merge.
 * @param obj5 - object to merge.
 * @returns The extended object.
 */
export declare function extend(obj?: any, obj2?: any, obj3?: any, obj4?: any, obj5?: any): any;
export declare let getTime: typeof perfNow;
export declare function isValueKind(value: number | undefined): boolean;
export declare function isArrayValid(value: any[]): boolean;
export declare function setProcessTelemetryTimings(event: ITelemetryItem, identifier: string): void;
/**
 * Returns a bitwise value for the FieldValueSanitizerType enum representing the decoded type of the passed value
 * @param value The value to determine the type
 */
export declare function getFieldValueType(value: any): FieldValueSanitizerType;
export declare const Utils: {
    Version: string;
    FullVersionString: string;
    strUndefined: string;
    strObject: string;
    Undefined: string;
    arrForEach: typeof arrForEach;
    arrIndexOf: typeof arrIndexOf;
    arrMap: typeof arrMap;
    arrReduce: typeof arrReduce;
    objKeys: typeof objKeys;
    toISOString: typeof toISOString;
    isReactNative: typeof isReactNative;
    isString: typeof isString;
    isNumber: typeof isNumber;
    isBoolean: typeof isBoolean;
    isFunction: typeof isFunction;
    isArray: <T = any>(obj: any) => obj is T[];
    isObject: typeof isObject;
    strTrim: typeof strTrim;
    isDocumentObjectAvailable: boolean;
    isWindowObjectAvailable: boolean;
    isValueAssigned: typeof isValueAssigned;
    getTenantId: typeof getTenantId;
    isBeaconsSupported: typeof isBeaconsSupported;
    isUint8ArrayAvailable: typeof isUint8ArrayAvailable;
    isLatency: typeof isLatency;
    sanitizeProperty: typeof sanitizeProperty;
    getISOString: typeof toISOString;
    useXDomainRequest: typeof useXDomainRequest;
    getCommonSchemaMetaData: typeof getCommonSchemaMetaData;
    cookieAvailable: typeof areCookiesSupported;
    disallowsSameSiteNone: typeof uaDisallowsSameSiteNone;
    setCookie: typeof setCookie;
    deleteCookie: typeof deleteCookie;
    getCookie: typeof getCookie;
    createGuid: typeof createGuid;
    extend: typeof extend;
    getTime: typeof perfNow;
    isValueKind: typeof isValueKind;
    isArrayValid: typeof isArrayValid;
    objDefineAccessors: typeof objDefineAccessors;
    addPageUnloadEventListener: typeof addPageUnloadEventListener;
    setProcessTelemetryTimings: typeof setProcessTelemetryTimings;
    addEventHandler: typeof addEventHandler;
    getFieldValueType: typeof getFieldValueType;
    strEndsWith: typeof strEndsWith;
    objForEachKey: typeof objForEachKey;
};
/**
 * Provides a collection of utility functions, included for backward compatibility with previous releases.
 * @deprecated Marking this instance as deprecated in favor of direct usage of the helper functions
 * as direct usage provides better tree-shaking and minification by avoiding the inclusion of the unused items
 * in your resulting code.
 * Overriding the applicationinsights-core version for tree-shaking
 */
export declare const CoreUtils: ICoreUtils;
/**
 * Helper to identify whether we are running in a chromium based browser environment
 */
export declare function isChromium(): boolean;
/**
 * Create and open an XMLHttpRequest object
 * @param method - The request method
 * @param urlString - The url
 * @param withCredentials - Option flag indicating that credentials should be sent
 * @param disabled - Optional flag indicating that the XHR object should be marked as disabled and not tracked (default is false)
 * @param isSync - Optional flag indicating if the instance should be a synchronous request (defaults to false)
 * @param timeout - Optional value identifying the timeout value that should be assigned to the XHR request
 * @returns A new opened XHR request
 */
export declare function openXhr(method: string, urlString: string, withCredentials?: boolean, disabled?: boolean, isSync?: boolean, timeout?: number): XMLHttpRequest;
