import { IInstrumentHooksCallbacks, IInstrumentHook } from "../JavaScriptSDK.Interfaces/IInstrumentHooks";
/**
 * Intercept the named prototype functions for the target class / object
 * @param target - The target object
 * @param funcName - The function name
 * @param callbacks - The callbacks to configure and call whenever the function is called
 */
export declare function InstrumentProto(target: any, funcName: string, callbacks: IInstrumentHooksCallbacks): IInstrumentHook;
/**
 * Intercept the named prototype functions for the target class / object
 * @param target - The target object
 * @param funcNames - The function names to intercept and call
 * @param callbacks - The callbacks to configure and call whenever the function is called
 */
export declare function InstrumentProtos(target: any, funcNames: string[], callbacks: IInstrumentHooksCallbacks): IInstrumentHook[];
/**
 * Intercept the named prototype functions for the target class / object
 * @param target - The target object
 * @param funcName - The function name
 * @param callbacks - The callbacks to configure and call whenever the function is called
 * @param checkPrototype - If the function doesn't exist on the target should it attempt to hook the prototype function
 */
export declare function InstrumentFunc(target: any, funcName: string, callbacks: IInstrumentHooksCallbacks, checkPrototype?: boolean): IInstrumentHook;
/**
 * Intercept the named functions for the target class / object
 * @param target - The target object
 * @param funcNames - The function names to intercept and call
 * @param callbacks - The callbacks to configure and call whenever the function is called
 * @param checkPrototype - If the function doesn't exist on the target should it attempt to hook the prototype function
 */
export declare function InstrumentFuncs(target: any, funcNames: string[], callbacks: IInstrumentHooksCallbacks, checkPrototype?: boolean): IInstrumentHook[];
/**
 * Add an instrumentation hook to the provided named "event" for the target class / object, this doesn't check whether the
 * named "event" is in fact a function and just assigns the instrumentation hook to the target[evtName]
 * @param target - The target object
 * @param evtName - The name of the event
 * @param callbacks - The callbacks to configure and call whenever the function is called
 * @param checkPrototype - If the function doesn't exist on the target should it attempt to hook the prototype function
 */
export declare function InstrumentEvent(target: any, evtName: string, callbacks: IInstrumentHooksCallbacks, checkPrototype?: boolean): IInstrumentHook;
