/**
 * TimeoutOverrideWrapper.ts
 * @author  Nev Wylie (newylie)
 * @copyright Microsoft 2022
 * Simple internal timeout wrapper
 */
export declare type TimeoutSetFunc<T = any> = (callback: (...args: any[]) => void, ms: number, ...args: any[]) => T;
export declare type TimeoutClearFunc<T = any> = (timeoutId?: T) => void;
export interface ITimeoutOverrideWrapper<T = any> {
    set: TimeoutSetFunc<T>;
    clear: TimeoutClearFunc<T>;
}
export declare function defaultSetTimeout<T = any>(callback: (...args: any[]) => void, ms: number, ...args: any[]): T;
export declare function defaultClearTimeout<T = any>(timeoutId?: T): void;
export declare function createTimeoutWrapper<T = any>(argSetTimeout?: TimeoutSetFunc<T>, argClearTimeout?: TimeoutClearFunc<T>): {
    set: TimeoutSetFunc<T>;
    clear: TimeoutClearFunc<T>;
};
