import { getFieldValueType } from "./Utils";
import { IEventProperty, IValueSanitizer, FieldValueSanitizerTypes, IFieldValueSanitizerProvider } from "./DataModels";
export declare class ValueSanitizer implements IValueSanitizer {
    static getFieldType: typeof getFieldValueType;
    /**
     * Add a value sanitizer as a fallback sanitizer if this sanitizer can't handle the path/name.
     */
    addSanitizer: (sanitizer: IValueSanitizer) => void;
    /**
     * Adds a field sanitizer to the evaluation list
     */
    addFieldSanitizer: (fieldSanitizer: IFieldValueSanitizerProvider) => void;
    /**
     * Does this field value sanitizer handle this path / field combination
     * @param path - The field path
     * @param name - The name of the field
     */
    handleField: (path: string, name: string) => boolean;
    /**
     * Sanitizes the value. It checks the that the property name and value are valid. It also
     * checks/populates the correct type and pii of the property value.
     * @param path - The root path of the property
     * @param name - The property name.
     * @param value - The property value or an IEventProperty containing value, type ,pii and customer content.
     * @param stringifyObjects - If supplied tells the sanitizer that it should JSON stringify() objects
     * @returns IEventProperty containing valid name, value, pii and type or null if invalid.
     */
    value: (path: string, name: string, value: FieldValueSanitizerTypes, stringifyObjects?: boolean) => IEventProperty | null;
    /**
     * Sanitizes the Property. It checks the that the property name and value are valid. It also
     * checks/populates the correct type and pii of the property value.
     * @param path - The root path of the property
     * @param name - The property name.
     * @param property - The property value or an IEventProperty containing value, type ,pii and customer content.
     * @param stringifyObjects - If supplied tells the sanitizer that it should JSON stringify() objects
     * @returns IEventProperty containing valid name, value, pii and type or null if invalid.
     */
    property: (path: string, name: string, property: IEventProperty, stringifyObjects?: boolean) => IEventProperty | null;
    constructor(fieldSanitizerProvider?: IFieldValueSanitizerProvider);
}
