/*
 * Application Insights JavaScript SDK - Core, 2.8.4
 * Copyright (c) Microsoft and contributors. All rights reserved.
 */


import { createEnumStyle } from "../JavaScriptSDK.Enums/EnumHelperFuncs";
export var LoggingSeverity = createEnumStyle({
    CRITICAL: 1 /* eLoggingSeverity.CRITICAL */,
    WARNING: 2 /* eLoggingSeverity.WARNING */
});
/**
 * Internal message ID. Please create a new one for every conceptually different message. Please keep alphabetically ordered
 */
export var _InternalMessageId = createEnumStyle({
    // Non user actionable
    BrowserDoesNotSupportLocalStorage: 0 /* _eInternalMessageId.BrowserDoesNotSupportLocalStorage */,
    BrowserCannotReadLocalStorage: 1 /* _eInternalMessageId.BrowserCannotReadLocalStorage */,
    BrowserCannotReadSessionStorage: 2 /* _eInternalMessageId.BrowserCannotReadSessionStorage */,
    BrowserCannotWriteLocalStorage: 3 /* _eInternalMessageId.BrowserCannotWriteLocalStorage */,
    BrowserCannotWriteSessionStorage: 4 /* _eInternalMessageId.BrowserCannotWriteSessionStorage */,
    BrowserFailedRemovalFromLocalStorage: 5 /* _eInternalMessageId.BrowserFailedRemovalFromLocalStorage */,
    BrowserFailedRemovalFromSessionStorage: 6 /* _eInternalMessageId.BrowserFailedRemovalFromSessionStorage */,
    CannotSendEmptyTelemetry: 7 /* _eInternalMessageId.CannotSendEmptyTelemetry */,
    ClientPerformanceMathError: 8 /* _eInternalMessageId.ClientPerformanceMathError */,
    ErrorParsingAISessionCookie: 9 /* _eInternalMessageId.ErrorParsingAISessionCookie */,
    ErrorPVCalc: 10 /* _eInternalMessageId.ErrorPVCalc */,
    ExceptionWhileLoggingError: 11 /* _eInternalMessageId.ExceptionWhileLoggingError */,
    FailedAddingTelemetryToBuffer: 12 /* _eInternalMessageId.FailedAddingTelemetryToBuffer */,
    FailedMonitorAjaxAbort: 13 /* _eInternalMessageId.FailedMonitorAjaxAbort */,
    FailedMonitorAjaxDur: 14 /* _eInternalMessageId.FailedMonitorAjaxDur */,
    FailedMonitorAjaxOpen: 15 /* _eInternalMessageId.FailedMonitorAjaxOpen */,
    FailedMonitorAjaxRSC: 16 /* _eInternalMessageId.FailedMonitorAjaxRSC */,
    FailedMonitorAjaxSend: 17 /* _eInternalMessageId.FailedMonitorAjaxSend */,
    FailedMonitorAjaxGetCorrelationHeader: 18 /* _eInternalMessageId.FailedMonitorAjaxGetCorrelationHeader */,
    FailedToAddHandlerForOnBeforeUnload: 19 /* _eInternalMessageId.FailedToAddHandlerForOnBeforeUnload */,
    FailedToSendQueuedTelemetry: 20 /* _eInternalMessageId.FailedToSendQueuedTelemetry */,
    FailedToReportDataLoss: 21 /* _eInternalMessageId.FailedToReportDataLoss */,
    FlushFailed: 22 /* _eInternalMessageId.FlushFailed */,
    MessageLimitPerPVExceeded: 23 /* _eInternalMessageId.MessageLimitPerPVExceeded */,
    MissingRequiredFieldSpecification: 24 /* _eInternalMessageId.MissingRequiredFieldSpecification */,
    NavigationTimingNotSupported: 25 /* _eInternalMessageId.NavigationTimingNotSupported */,
    OnError: 26 /* _eInternalMessageId.OnError */,
    SessionRenewalDateIsZero: 27 /* _eInternalMessageId.SessionRenewalDateIsZero */,
    SenderNotInitialized: 28 /* _eInternalMessageId.SenderNotInitialized */,
    StartTrackEventFailed: 29 /* _eInternalMessageId.StartTrackEventFailed */,
    StopTrackEventFailed: 30 /* _eInternalMessageId.StopTrackEventFailed */,
    StartTrackFailed: 31 /* _eInternalMessageId.StartTrackFailed */,
    StopTrackFailed: 32 /* _eInternalMessageId.StopTrackFailed */,
    TelemetrySampledAndNotSent: 33 /* _eInternalMessageId.TelemetrySampledAndNotSent */,
    TrackEventFailed: 34 /* _eInternalMessageId.TrackEventFailed */,
    TrackExceptionFailed: 35 /* _eInternalMessageId.TrackExceptionFailed */,
    TrackMetricFailed: 36 /* _eInternalMessageId.TrackMetricFailed */,
    TrackPVFailed: 37 /* _eInternalMessageId.TrackPVFailed */,
    TrackPVFailedCalc: 38 /* _eInternalMessageId.TrackPVFailedCalc */,
    TrackTraceFailed: 39 /* _eInternalMessageId.TrackTraceFailed */,
    TransmissionFailed: 40 /* _eInternalMessageId.TransmissionFailed */,
    FailedToSetStorageBuffer: 41 /* _eInternalMessageId.FailedToSetStorageBuffer */,
    FailedToRestoreStorageBuffer: 42 /* _eInternalMessageId.FailedToRestoreStorageBuffer */,
    InvalidBackendResponse: 43 /* _eInternalMessageId.InvalidBackendResponse */,
    FailedToFixDepricatedValues: 44 /* _eInternalMessageId.FailedToFixDepricatedValues */,
    InvalidDurationValue: 45 /* _eInternalMessageId.InvalidDurationValue */,
    TelemetryEnvelopeInvalid: 46 /* _eInternalMessageId.TelemetryEnvelopeInvalid */,
    CreateEnvelopeError: 47 /* _eInternalMessageId.CreateEnvelopeError */,
    // User actionable
    CannotSerializeObject: 48 /* _eInternalMessageId.CannotSerializeObject */,
    CannotSerializeObjectNonSerializable: 49 /* _eInternalMessageId.CannotSerializeObjectNonSerializable */,
    CircularReferenceDetected: 50 /* _eInternalMessageId.CircularReferenceDetected */,
    ClearAuthContextFailed: 51 /* _eInternalMessageId.ClearAuthContextFailed */,
    ExceptionTruncated: 52 /* _eInternalMessageId.ExceptionTruncated */,
    IllegalCharsInName: 53 /* _eInternalMessageId.IllegalCharsInName */,
    ItemNotInArray: 54 /* _eInternalMessageId.ItemNotInArray */,
    MaxAjaxPerPVExceeded: 55 /* _eInternalMessageId.MaxAjaxPerPVExceeded */,
    MessageTruncated: 56 /* _eInternalMessageId.MessageTruncated */,
    NameTooLong: 57 /* _eInternalMessageId.NameTooLong */,
    SampleRateOutOfRange: 58 /* _eInternalMessageId.SampleRateOutOfRange */,
    SetAuthContextFailed: 59 /* _eInternalMessageId.SetAuthContextFailed */,
    SetAuthContextFailedAccountName: 60 /* _eInternalMessageId.SetAuthContextFailedAccountName */,
    StringValueTooLong: 61 /* _eInternalMessageId.StringValueTooLong */,
    StartCalledMoreThanOnce: 62 /* _eInternalMessageId.StartCalledMoreThanOnce */,
    StopCalledWithoutStart: 63 /* _eInternalMessageId.StopCalledWithoutStart */,
    TelemetryInitializerFailed: 64 /* _eInternalMessageId.TelemetryInitializerFailed */,
    TrackArgumentsNotSpecified: 65 /* _eInternalMessageId.TrackArgumentsNotSpecified */,
    UrlTooLong: 66 /* _eInternalMessageId.UrlTooLong */,
    SessionStorageBufferFull: 67 /* _eInternalMessageId.SessionStorageBufferFull */,
    CannotAccessCookie: 68 /* _eInternalMessageId.CannotAccessCookie */,
    IdTooLong: 69 /* _eInternalMessageId.IdTooLong */,
    InvalidEvent: 70 /* _eInternalMessageId.InvalidEvent */,
    FailedMonitorAjaxSetRequestHeader: 71 /* _eInternalMessageId.FailedMonitorAjaxSetRequestHeader */,
    SendBrowserInfoOnUserInit: 72 /* _eInternalMessageId.SendBrowserInfoOnUserInit */,
    PluginException: 73 /* _eInternalMessageId.PluginException */,
    NotificationException: 74 /* _eInternalMessageId.NotificationException */,
    SnippetScriptLoadFailure: 99 /* _eInternalMessageId.SnippetScriptLoadFailure */,
    InvalidInstrumentationKey: 100 /* _eInternalMessageId.InvalidInstrumentationKey */,
    CannotParseAiBlobValue: 101 /* _eInternalMessageId.CannotParseAiBlobValue */,
    InvalidContentBlob: 102 /* _eInternalMessageId.InvalidContentBlob */,
    TrackPageActionEventFailed: 103 /* _eInternalMessageId.TrackPageActionEventFailed */,
    FailedAddingCustomDefinedRequestContext: 104 /* _eInternalMessageId.FailedAddingCustomDefinedRequestContext */,
    InMemoryStorageBufferFull: 105 /* _eInternalMessageId.InMemoryStorageBufferFull */,
    InstrumentationKeyDeprecation: 106 /* _eInternalMessageId.InstrumentationKeyDeprecation */
});
//# sourceMappingURL=LoggingEnums.js.map