import { IProcessTelemetryContext } from "../JavaScriptSDK.Interfaces/IProcessTelemetryContext";
import { ITelemetryInitializerContainer, ITelemetryInitializerHandler, TelemetryInitializerFunction } from "../JavaScriptSDK.Interfaces/ITelemetryInitializers";
import { ITelemetryItem } from "../JavaScriptSDK.Interfaces/ITelemetryItem";
import { BaseTelemetryPlugin } from "./BaseTelemetryPlugin";
export declare class TelemetryInitializerPlugin extends BaseTelemetryPlugin implements ITelemetryInitializerContainer {
    identifier: string;
    priority: number;
    constructor();
    /**
     * Add a telemetry processor to decorate or drop telemetry events.
     * @param telemetryInitializer - The Telemetry Initializer function
     * @returns - A ITelemetryInitializerHandler to enable the initializer to be removed
     */
    addTelemetryInitializer(telemetryInitializer: TelemetryInitializerFunction): ITelemetryInitializerHandler;
    processTelemetry(env: ITelemetryItem, itemCtx?: IProcessTelemetryContext): void;
}
