# <div align="center"><strong>sglang</strong></div>

## 简介

sglang 是一个用于大语言模型（LLM）与多模态视觉语言模型（VLM）的高效推理与服务框架。通过前后端协同设计，提供更高吞吐与更可控的调用体验。

## 安装

> 组件支持组合安装；下表给出一个经过验证的环境组合示例，可按需替换为你本机/集群的镜像与版本。

| Python版本 | DTK版本        | 基础镜像（示例）                                                                                                          | 推荐安装方式       |
| ---------- | -------------- | ------------------------------------------------------------------------------------------------------------------------- | ------------------ |
| 3.10       | 25.04.1 及以上 | `image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250812-beta` | 使用镜像 + 源码安装 |

### 1、使用镜像环境准备

#### 拉取并启动 Docker

```bash
# 拉取镜像
docker pull image.sourcefind.cn:5000/dcu/admin/base/vllm:0.9.2-ubuntu22.04-dtk25.04.1-rc5-rocblas101839-0811-das1.6-py3.10-20250812-beta

# 启动容器（将 <Image ID> 替换为上面拉取镜像的 ID；路径按需修改）
docker run -it --name sglang-dev \
  --shm-size=1024G \
  -v /opt/hyhal:/opt/hyhal:ro \
  --device=/dev/kfd \
  --device=/dev/dri/ \
  --cap-add=SYS_PTRACE \
  <Image ID> /bin/bash
```

> 注意：
> 1) `-v /opt/hyhal:/opt/hyhal` 不能少；
> 2) 若 `pip install` 较慢，可添加镜像源：`-i https://pypi.tuna.tsinghua.edu.cn/simple/`。

### 2、源码准备

```bash
# 克隆代码仓库（容器内执行）
git clone https://developer.sourcefind.cn/codes/OpenDAS/sglang
cd sglang
```

### 3、编译与安装

#### 3.1 编译 `sgl-kernel`

```bash
cd sgl-kernel
python setup_hip.py install
```

#### 3.2 安装 sglang Python 依赖

```bash
cd ..
pip install -e "python[all_hip]"
```

## 注意事项

- **挂载依赖**：确保在 `docker run` 时挂载 `/opt/hyhal:/opt/hyhal`，否则运行期可能缺少必需依赖。
- **加速下载**：国内网络环境建议为 `pip` 添加清华源：`-i https://pypi.tuna.tsinghua.edu.cn/simple/`。
- **设备访问**：容器需添加 `--device=/dev/kfd --device=/dev/dri/` 以启用 DCU/ROCm 设备访问。

## Known Issue

- 无

## 参考资料

- 仓库地址：`https://developer.sourcefind.cn/codes/OpenDAS/sglang`
- [README_ORIGIN](https://developer.sourcefind.cn/codes/OpenDAS/sglang/-/blob/v0.5.2rc1/README_ORIGIN.md)
