# Resnet50_onnxruntime

## 论文
`Deep Residual Learning for Image Recognition`

- https://arxiv.org/abs/1512.03385

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

![ResNet50模型结构](./resource/1.png)

## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![算法原理](./resource/2.png)

## 环境配置
### Docker
拉取镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/custom:opencv49_ffmpeg4.2.1_ubuntu20.04-dtk24.04.2
```

## 数据集
无

## 推理
### C++推理
该cpp项目支持多batch，下面介绍cpp项目编译流程
#### 构建工程
```
cd resnet50_ort
mkdir build && cd build 
cmake ../
make
```
#### 执行程序
```
export ORT_ROCM_MULTITHRAED_ENABLE=1
cd build 
./resnet
```

## result
输出结果为每个图像得分前五的类别标签
![算法原理](./resource/3.jpg)


## 应用场景
### 算法类别
`图像分类`

### 热点应用行业
`制造,政府,医疗,科研`

## 源码仓库及问题反馈
https://developer.sourcefind.cn/codes/change/resnet50_ort

## 参考资料
https://github.com/onnx/models/tree/main/vision/classification/resnet
