# Resnet50_migraphx

## 论文
`Deep Residual Learning for Image Recognition`

- https://arxiv.org/abs/1512.03385

## 模型结构
ResNet50模型包含了49个卷积层、一个全连接层。

![ResNet50模型结构](./resource/1.png)

## 算法原理
ResNet50使用了多个具有残差连接的残差块来解决梯度消失或梯度爆炸问题，并使得网络可以向更深层发展。

![算法原理](./resource/2.png)

## 环境配置
### Docker
拉取镜像：
```
docker pull image.sourcefind.cn:5000/dcu/admin/base/migraphx:4.5.0-py3.10-dtk24.04.3-ubuntu20.04

# 安装opencv（编译源码方式）
git clone --branch 4.9.0 --depth=1 https://github.com/opencv/opencv.git

sudo apt-get install build-essential libgtk2.0-dev libjpeg8-dev  libjasper-dev libtiff5-dev libpng12-dev libatlas-base-dev gfortran libavcodec-dev libavformat-dev libswscale-dev libv4l-dev  python-numpy libtbb2 libtbb-dev libdc1394-22-dev
cd opencv

mkdir build&& cd build

cmake -D CMAKE_BUILD_TYPE=Release -D CMAKE_INSTALL_PREFIX=/usr/local/ -D FFMPEG=ON -D OPENCV_GENERATE_PKGCONFIG=YES -D WITH_1394=OFF -D OPENCV_ENABLE_NONFREE=ON -D BUILD_opencv_videoio=ON -D BUILD_opencv_highgui=ON ..

make -j8 # 几个线程编

# 安装
make install
```

## 数据集
无

## 推理
### C++推理
该cpp项目支持多batch，下面介绍cpp项目编译流程
#### 构建工程
```
cd resnet50_migraphx
mkdir build && cd build 
cmake ../
make
```
#### 执行程序
```
cd build 
./main
```

## result
输出结果为每个图像得分前五的类别标签
![算法原理](./resource/3.jpg)


## 应用场景
### 算法类别
`图像分类`

### 热点应用行业
`制造,政府,医疗,科研`

## 源码仓库及问题反馈
- https://developer.sourcefind.cn/codes/change/resnet50_migraphx

## 参考资料
- https://developer.sourcefind.cn/codes/modelzoo/resnet50_migraphx
- https://developer.sourcefind.cn/codes/change/resnet50_ort

