"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from typing import List
# noinspection PyUnresolvedReferences
from ...basic.exception import check, SeekTODOException
# noinspection PyUnresolvedReferences
from ...basic.register import *
# noinspection PyUnresolvedReferences
from ...basic.instr import Block, Waitcnt


def __check_alignment(operand_value: Gpr, operand_size: int):
    if operand_value.rtype.is_special():
        pass
    elif operand_value.rtype.is_vgpr():
        check(operand_value.align.is_aligned(1), operand_value)
    elif operand_value.rtype.is_sgpr():
        alignment = 1
        if operand_size == 2:
            alignment = 2
        assert operand_size != 3
        if operand_size >= 4:
            alignment = 4
        check(operand_value.align.is_aligned(alignment), operand_value)
    else:
        assert operand_value.rtype.is_agpr()
        raise SeekTODOException("AGpr")

def __check_size(operand_value: Gpr, operand_size: int, /, allow_off: bool):
    # If this operand is allowed to be `off`, and it's indeed `off`, don't check operand_size
    if allow_off and operand_value.base_gpr is off:
        return

    if operand_size == 0:
        raise SeekException(f"Expects `off` here, but got {operand_value}")

    if operand_value.base_gpr in {scc, vccz, execz}:
        # These Gprs are 1-bit, they will be extended to desired size
        pass
    else:
        check(operand_value.count == operand_size,
              f'Expects {operand_size} Gprs here, but got {operand_value}')

def __check_abs_neg_sext(operand_value: Gpr, allow_abs: bool, allow_neg: bool, allow_sext: bool):
    if not allow_abs:
        check(not operand_value.is_abs, f"abs() is not allowed here, but got {operand_value}")
    if not allow_neg:
        check(not operand_value.is_neg, f"neg() is not allowed here, but got {operand_value}")
    if not allow_sext:
        check(not operand_value.is_sext, f"sext() is not allowed here, but got {operand_value}")


# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vaddr(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vaddr¶

    An offset from the start of GDS/LDS memory.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Instruction input.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Instruction input.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata0(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata0¶

    Instruction input.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata1¶

    Instruction input.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata0_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata0¶

    Instruction input.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata1_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata1¶

    Instruction input.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output.

    Size: 4 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output.

    Size: 3 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 3
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Instruction input.

    Size: 4 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Instruction input.

    Size: 3 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 3
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_tgt(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # tgt¶

    An export target:

    Syntax         | Description
    > ---          |---
    > pos{0..3}    | Copy vertex position 0..3.
    > param{0..31} | Copy vertex parameter 0..31.
    > mrt{0..7}    | Copy pixel color to the MRTs 0..7.
    > mrtz         | Copy pixel depth (Z) data.
    > null         | Copy nothing.
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vsrc(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vsrc¶

    Data to copy to export buffers. This is an optional operand. Must be specified as off if not used.

    compr modifier indicates use of compressed (16-bit) data. This limits number of source operands from 4 to 2:

      * src0 and src1 must specify the first register (or off).
      * src2 and src3 must specify the second register (or off).

    An example:

        exp mrtz v3, v3, off, off compr

    Size: 1 dword.

    Operands: v, off
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=True)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is off: return  # off
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Data returned by a 32-bit atomic flat instruction.

    This is an optional operand. It must be used if and only if glc is specified.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vaddr_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vaddr¶

    A 64-bit flat address.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Data returned by a 64-bit atomic flat instruction.

    This is an optional operand. It must be used if and only if glc is specified.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vaddr_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vaddr¶

    A 64-bit flat global address or a 32-bit offset depending on addressing mode:

      * Address = vaddr + offset13s. vaddr is a 64-bit address. This mode is indicated by saddr set to off.
      * Address = saddr + vaddr + offset13s. vaddr is a 32-bit offset. This mode is used when saddr is not off.

    Size: 1 or 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if operands['saddr'] == off:
            operand_size = 2
        if operands['saddr'] != off:
            operand_size = 1
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_saddr(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # saddr¶

    An optional 64-bit flat global address. Must be specified as off if not used.

    See vaddr for description of available addressing modes.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, off
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=True)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is off: return  # off
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vaddr_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vaddr¶

    An optional 32-bit flat scratch offset. Must be specified as off if not used.

    Either this operand or saddr must be set to off.

    Size: 1 dword.

    Operands: v, off
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=True)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is off: return  # off
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_saddr_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # saddr¶

    An optional 32-bit flat scratch offset. Must be specified as off if not used.

    Either this operand or vaddr must be set to off.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, off
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=True)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is off: return  # off
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: depends on dmask and tfe:

      * dmask may specify 1 data element for 32-bit-per-pixel surfaces or 2 data elements for 64-bit-per-pixel surfaces. Each data element occupies 1 dword.

      * tfe adds 1 dword if specified.

    Note: the surface data format is indicated in the image resource constant but not in the instruction.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vaddr_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vaddr¶

    Image address which includes from one to four dimensional coordinates and other data used to locate a position in the image.

    Size: 1, 2, 3, 4, 8 or 16 dwords. Actual size depends on opcode, specific image being handled and a16.

    > Note 1. Image format and dimensions are encoded in the image resource constant but not in the instruction.
    >
    > Note 2. Actually image address size may vary from 1 to 13 dwords, but assembler currently supports a limited range of register sequences.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_srsrc(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # srsrc¶

    Image resource constant which defines the location of the image buffer in memory, its dimensions, tiling, and data format.

    Size: 8 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 8
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: depends on dmask and tfe:

      * dmask may specify 2 data elements for 32-bit-per-pixel surfaces or 4 data elements for 64-bit-per-pixel surfaces. Each data element occupies 1 dword.

      * tfe adds 1 dword if specified.

    Note: the surface data format is indicated in the image resource constant but not in the instruction.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_6(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Image data to load by an image_gather4 instruction.

    Size: 4 data elements by default. Each data element occupies either 32 bits or 16 bits depending on d16.

    d16 and tfe affect operand size as follows:

      * d16 specifies that data elements in registers are packed; each value occupies 16 bits.
      * tfe adds one dword if specified.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssamp(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssamp¶

    Sampler constant used to specify filtering options applied to the image data after it is read.

    Size: 4 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_7(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Image data to load by an image instruction.

    Size: depends on dmask and tfe:

      * dmask may specify from 1 to 4 data elements. Each data element occupies 1 dword.
      * tfe adds 1 dword if specified.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_8(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Image data to load by an image instruction.

    Size: depends on dmask, tfe and d16:

      * dmask may specify from 1 to 4 data elements. Each data element occupies either 32 bits or 16 bits depending on d16.
      * d16 specifies that data elements in registers are packed; each value occupies 16 bits.
      * tfe adds 1 dword if specified.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_6(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Image data to store by an image_store instruction.

    Size: depends on dmask and d16:

      * dmask may specify from 1 to 4 data elements. Each data element occupies either 32 bits or 16 bits depending on d16.
      * d16 specifies that data in registers are packed; each value occupies 16 bits.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_7(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Image data to store by an image_store instruction.

    Size: depends on dmask which may specify from 1 to 4 data elements. Each data element occupies 1 dword.

    Operands: v
    """
    raise NotImplementedError('Unsupported for now')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_9(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output: data read from a memory buffer.

    Size: 1 dword by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 1
        if modifiers['tfe']:
            operand_size = 2
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vaddr_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vaddr¶

    This is an optional operand which may specify offset and/or index.

    Size: 0, 1 or 2 dwords. Size is controlled by modifiers offen and idxen:

      * If only idxen is specified, this operand supplies an index. Size is 1 dword.
      * If only offen is specified, this operand supplies an offset. Size is 1 dword.
      * If both modifiers are specified, index is in the first register and offset is in the second. Size is 2 dwords.
      * If none of these modifiers are specified, this operand must be set to off.

    Operands: v, off
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if modifiers['idxen'] and modifiers['offen']:
            operand_size = 2
        if modifiers['idxen'] and not modifiers['offen']:
            operand_size = 1
        if not modifiers['idxen'] and modifiers['offen']:
            operand_size = 1
        if not modifiers['idxen'] and not modifiers['offen']:
            operand_size = 0
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=True)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is off: return  # off
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_srsrc_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # srsrc¶

    Buffer resource constant which defines the address and characteristics of the buffer in memory.

    Size: 4 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_soffset(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # soffset¶

    An unsigned byte offset.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_10(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output: data read from a memory buffer.

    Size: 2 dwords by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 2
        if modifiers['tfe']:
            operand_size = 3
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_11(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output: data read from a memory buffer.

    Size: 3 dwords by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 3
        if modifiers['tfe']:
            operand_size = 4
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_12(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output: data read from a memory buffer.

    Size: 4 dwords by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 4
        if modifiers['tfe']:
            operand_size = 5
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_8(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: 1 dword by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 1
        if modifiers['tfe']:
            operand_size = 2
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_9(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: 2 dwords by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 2
        if modifiers['tfe']:
            operand_size = 3
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdata_10(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: 4 dwords by default. tfe adds 1 dword if specified.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 4
        if modifiers['tfe']:
            operand_size = 5
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vdst_13(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output: data read from a memory buffer.

    If lds is specified, this operand is ignored by H/W and data are stored directly into LDS.

    Size: 1 dword by default. tfe adds 1 dword if specified.

    > Note that tfe and lds cannot be used together.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = None
        if not modifiers['tfe']:
            operand_size = 1
        if modifiers['tfe']:
            operand_size = 2
        assert operand_size is not None
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_probe(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # probe¶

    A bit mask which indicates request permissions.

    This operand must be specified as an integer_number or an absolute_expression. The value is truncated to 7 bits, but only 3 low bits are significant.

    Bit Number | Description
    > ---      |---
    > 0        | Request read permission.
    > 1        | Request write permission.
    > 2        | Request execute permission.
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sbase(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sbase¶

    A 64-bit base address for scalar memory operations.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_soffset_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # soffset¶

    An offset added to the base address to get memory address.

      * If offset is specified as a register, it supplies an unsigned byte offset.
      * If offset is specified as a 21-bit immediate, it supplies a signed byte offset.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, simm21
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, int) and (-0x100000 <= operand_value < 0x100000): return  # simm21
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sbase_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sbase¶

    A 128-bit buffer resource constant for scalar memory operations which provides a base address, a size and a stride.

    Size: 4 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_soffset_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # soffset¶

    An unsigned 20-bit offset added to the base address to get memory address.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, uimm20
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, int) and (0 <= operand_value < 0x100000): return  # uimm20
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdata(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdata_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdata_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdata¶

    Input data for an atomic instruction.

    Optionally may serve as an output data:

      * If glc is specified, gets the memory value before the operation.

    Size: 4 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 16 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 16
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 4 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 8 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 8
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdata_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdata¶

    Instruction input.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdata_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdata¶

    Instruction input.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdata_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdata¶

    Instruction input.

    Size: 4 dwords.

    Operands: s, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sbase_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sbase¶

    This operand is ignored by H/W and flat_scratch is supplied instead.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, constant, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, exec, vccz, execz, scc, constant, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_6(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, exec
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, exec, vccz, execz, scc, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_imask(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # imask¶

    This operand is a mask which controls indexing mode for operands of subsequent instructions. Bits 0, 1 and 2 control indexing of src0, src1 and src2, while bit 3 controls indexing of dst. Value 1 enables indexing and value 0 disables it.

    Bit   | Meaning
    > --- |---
    > 0   | Enables or disables src0 indexing.
    > 1   | Enables or disables src1 indexing.
    > 2   | Enables or disables src2 indexing.
    > 3   | Enables or disables dst indexing.

    This operand may be specified as one of the following:

      * An integer_number or an absolute_expression. The value must be in the range 0..15.

      * A gpr_idx value described below.

    Gpr_idx Value Syntax                                                                                                                  | Description
    > ---                                                                                                                                 |---
    > gpr_idx(<operands>)                                                                                                                 |
    >
    > Enable indexing for specified operands and disable it for the rest. Operands is a comma-separated list of values which may include:
    >
    >     * “SRC0” - enable src0 indexing.
    >     * “SRC1” - enable src1 indexing.
    >     * “SRC2” - enable src2 indexing.
    >     * “DST” - enable dst indexing.
    >
    > Each of these values may be specified only once.
    >
    > Operands list may be empty; this syntax disables indexing for all operands.
    >

    Examples:

        s_set_gpr_idx_mode 0
        s_set_gpr_idx_mode gpr_idx()                        // the same as above

        s_set_gpr_idx_mode 15
        s_set_gpr_idx_mode gpr_idx(DST,SRC0,SRC1,SRC2)      // the same as above
        s_set_gpr_idx_mode gpr_idx(SRC0,SRC1,SRC2,DST)      // the same as above

        s_set_gpr_idx_mode gpr_idx(DST,SRC1)
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_imm16(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # imm16¶

    An integer_number or an absolute_expression. The value must be in the range -32768..65535.
    """
    check(isinstance(operand_value, int), operand_value)
    check(-32768 <= operand_value <= 65535, operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_label(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # label¶

    A branch target which is a 16-bit signed integer treated as a PC-relative dword offset.

    This operand may be specified as one of the following:

      * An integer_number or an absolute_expression. The value must be in the range -32768..65535.
      * A symbol (for example, a label) representing a relocatable address in the same compilation unit where it is referred from. The value is handled as a 16-bit PC-relative dword offset to be resolved by a linker.

    Examples:

        offset = 30
        label_1:
        label_2 = . + 4

        s_branch 32
        s_branch offset + 2
        s_branch label_1
        s_branch label_2
        s_branch label_3
        s_branch label_4

        label_3 = label_2 + 4
        label_4:
    """
    if isinstance(operand_value, str):
        check(operand_value)
        return
    check(isinstance(operand_value, Block), operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 2 dwords.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, exec
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_6(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_imm16_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # imm16¶

    An integer_number or an absolute_expression. The value must be in the range 0..65535.
    """
    check(isinstance(operand_value, int), operand_value)
    check(0 <= operand_value <= 65535, operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_hwreg(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # hwreg¶

    Bits of a hardware register being accessed.

    The bits of this operand have the following meaning:

    Bits    | Description       | Value Range
    > ---   |---                |---
    > 5:0   | Register id.      | 0..63
    > 10:6  | First bit offset. | 0..31
    > 15:11 | Size in bits.     | 1..32

    This operand may be specified as one of the following:

      * An integer_number or an absolute_expression. The value must be in the range 0..0xFFFF.

      * An hwreg value described below.

    Hwreg Value Syntax                 | Description
    > ---                              |---
    > hwreg({0..63})                   | All bits of a register indicated by its id.
    > hwreg(<name>)                    | All bits of a register indicated by its name.
    > hwreg({0..63}, {0..31}, {1..32}) | Register bits indicated by register id, first bit offset and size.
    > hwreg(<name>, {0..31}, {1..32})  | Register bits indicated by register name, first bit offset and size.

    Numeric values may be specified as positive integer numbers or absolute expressions.

    Defined register names include:

    Name                  | Description
    > ---                 |---
    > HW_REG_MODE         | Shader writeable mode bits.
    > HW_REG_STATUS       | Shader read-only status.
    > HW_REG_TRAPSTS      | Trap status.
    > HW_REG_HW_ID        | Id of wave, simd, compute unit, etc.
    > HW_REG_GPR_ALLOC    | Per-wave SGPR and VGPR allocation.
    > HW_REG_LDS_ALLOC    | Per-wave LDS allocation.
    > HW_REG_IB_STS       | Counters of outstanding instructions.
    > HW_REG_SH_MEM_BASES | Memory aperture.

    Examples:

        reg = 1
        offset = 2
        size = 4
        hwreg_enc = reg | (offset << 6) | ((size - 1) << 11)

        s_getreg_b32 s2, 0x1881
        s_getreg_b32 s2, hwreg_enc                     // the same as above
        s_getreg_b32 s2, hwreg(1, 2, 4)                // the same as above
        s_getreg_b32 s2, hwreg(reg, offset, size)      // the same as above

        s_getreg_b32 s2, hwreg(15)
        s_getreg_b32 s2, hwreg(51, 1, 31)
        s_getreg_b32 s2, hwreg(HW_REG_LDS_ALLOC, 0, 1)
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_simm32(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # simm32¶

    An integer_number or an absolute_expression. The value is truncated to 32 bits.
    """
    check(isinstance(operand_value, int), operand_value)
    check(-2147483648 <= operand_value <= 4294967295, operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_imm16_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # imm16¶

    A 16-bit integer_number or an absolute_expression. The value must be in the range -32768..65535.
    """
    check(isinstance(operand_value, int), operand_value)
    check(-32768 <= operand_value <= 65535, operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_msg(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # msg¶

    A 16-bit message code. The bits of this operand have the following meaning:

    Bits    | Description         | Value Range
    > ---   |---                  |---
    > 3:0   | Message type.       | 0..15
    > 6:4   | Optional operation. | 0..7
    > 7:7   | Unused.             | -
    > 9:8   | Optional stream.    | 0..3
    > 15:10 | Unused.             | -

    This operand may be specified as one of the following:

      * An integer_number or an absolute_expression. The value must be in the range 0..0xFFFF.

      * A sendmsg value described below.

    Sendmsg Value Syntax            | Description
    > ---                           |---
    > sendmsg(<type>)               | A message identified by its type.
    > sendmsg(<type>,<op>)          | A message identified by its type and operation.
    > sendmsg(<type>,<op>,<stream>) | A message identified by its type and operation with a stream id.

    Type may be specified using message name or message id.

    Op may be specified using operation name or operation id.

    Stream id is an integer in the range 0..3.

    Numeric values may be specified as positive integer numbers or absolute expressions.

    Each message type supports specific operations:

    Message name             | Message Id | Supported Operations        | Operation Id | Stream Id
    > ---                    |---         |---                          |---           |---
    > MSG_INTERRUPT          | 1          | -                           | -            | -
    > MSG_GS                 | 2          | GS_OP_CUT                   | 1            | Optional
    >                        |            | GS_OP_EMIT                  | 2            | Optional
    >                        |            | GS_OP_EMIT_CUT              | 3            | Optional
    > MSG_GS_DONE            | 3          | GS_OP_NOP                   | 0            | -
    >                        |            | GS_OP_CUT                   | 1            | Optional
    >                        |            | GS_OP_EMIT                  | 2            | Optional
    >                        |            | GS_OP_EMIT_CUT              | 3            | Optional
    > MSG_SAVEWAVE           | 4          | -                           | -            | -
    > MSG_STALL_WAVE_GEN     | 5          | -                           | -            | -
    > MSG_HALT_WAVES         | 6          | -                           | -            | -
    > MSG_ORDERED_PS_DONE    | 7          | -                           | -            | -
    > MSG_EARLY_PRIM_DEALLOC | 8          | -                           | -            | -
    > MSG_GS_ALLOC_REQ       | 9          | -                           | -            | -
    > MSG_GET_DOORBELL       | 10         | -                           | -            | -
    > MSG_SYSMSG             | 15         | SYSMSG_OP_ECC_ERR_INTERRUPT | 1            | -
    >                        |            | SYSMSG_OP_REG_RD            | 2            | -
    >                        |            | SYSMSG_OP_HOST_TRAP_ACK     | 3            | -
    >                        |            | SYSMSG_OP_TTRACE_PC         | 4            | -

    Sendmsg arguments are validated depending on how type value is specified:

      * If message type is specified by name, arguments values must satisfy limitations detailed in the table above.
      * If message type is specified as a number, each argument must not exceed corresponding value range (see the first table).

    Examples:

        // numeric message code
        msg = 0x10
        s_sendmsg 0x12
        s_sendmsg msg + 2

        // sendmsg with strict arguments validation
        s_sendmsg sendmsg(MSG_INTERRUPT)
        s_sendmsg sendmsg(MSG_GS, GS_OP_EMIT)
        s_sendmsg sendmsg(MSG_GS, 2)
        s_sendmsg sendmsg(MSG_GS_DONE, GS_OP_EMIT_CUT, 1)
        s_sendmsg sendmsg(MSG_SYSMSG, SYSMSG_OP_TTRACE_PC)
        s_sendmsg sendmsg(MSG_GET_DOORBELL)

        // sendmsg with validation of value range only
        msg = 2
        op = 3
        stream = 1
        s_sendmsg sendmsg(msg, op, stream)
        s_sendmsg sendmsg(2, GS_OP_CUT)
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_waitcnt(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # waitcnt¶

    Counts of outstanding instructions to wait for.

    The bits of this operand have the following meaning:

    High Bits | Low Bits | Description                                     | Value Range
    > ---     |---       |---                                              |---
    > 15:14   | 3:0      | VM_CNT: vector memory operations count.         | 0..63
    > -       | 6:4      | EXP_CNT: export count.                          | 0..7
    > -       | 11:8     | LGKM_CNT: LDS, GDS, Constant and Message count. | 0..15

    This operand may be specified as one of the following:

      * An integer_number or an absolute_expression. The value must be in the range 0..0xFFFF.

      * A combination of vmcnt, expcnt, lgkmcnt and other values described below.

    Syntax             | Description
    > ---              |---
    > vmcnt(<N>)       | A VM_CNT value. N must not exceed the largest VM_CNT value.
    > expcnt(<N>)      | An EXP_CNT value. N must not exceed the largest EXP_CNT value.
    > lgkmcnt(<N>)     | An LGKM_CNT value. N must not exceed the largest LGKM_CNT value.
    > vmcnt_sat(<N>)   | A VM_CNT value computed as min(N, the largest VM_CNT value).
    > expcnt_sat(<N>)  | An EXP_CNT value computed as min(N, the largest EXP_CNT value).
    > lgkmcnt_sat(<N>) | An LGKM_CNT value computed as min(N, the largest LGKM_CNT value).

    These values may be specified in any order. Spaces, ampersands and commas may be used as optional separators.

    N is either an integer number or an absolute expression.

    Examples:

        vm_cnt = 1
        exp_cnt = 2
        lgkm_cnt = 3
        cnt = vm_cnt | (exp_cnt << 4) | (lgkm_cnt << 8)

        s_waitcnt cnt
        s_waitcnt 1 | (2 << 4) | (3 << 8)                          // the same as above
        s_waitcnt vmcnt(1) expcnt(2) lgkmcnt(3)                    // the same as above
        s_waitcnt vmcnt(vm_cnt) expcnt(exp_cnt) lgkmcnt(lgkm_cnt)  // the same as above

        s_waitcnt vmcnt(1)
        s_waitcnt expcnt(2) lgkmcnt(3)
        s_waitcnt vmcnt(1), expcnt(2), lgkmcnt(3)
        s_waitcnt vmcnt(1) & lgkmcnt_sat(100) & expcnt(2)
    """
    if isinstance(operand_value, int):
        check(0 <= operand_value <= 65535, operand_value)  # totally 16 bits
        return
    check(isinstance(operand_value, Waitcnt), operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_param(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # param¶

    Interpolation parameter to read:

    Syntax | Description
    > ---  |---
    > p0   | Parameter P0.
    > p10  | Parameter P10.
    > p20  | Parameter P20.
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_attr(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # attr¶

    Interpolation attribute and channel:

    Syntax          | Description
    > ---           |---
    > attr{0..32}.x | Attribute 0..32 with x channel.
    > attr{0..32}.y | Attribute 0..32 with y channel.
    > attr{0..32}.z | Attribute 0..32 with z channel.
    > attr{0..32}.w | Attribute 0..32 with w channel.

    Examples:

        v_interp_p1_f32 v1, v0, attr0.x
        v_interp_p1_f32 v1, v0, attr32.w
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vsrc_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vsrc¶

    Instruction input.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, constant, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 2 dwords.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, exec, vccz, execz, scc, constant, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, iconst, ival, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    if isinstance(operand_value, str) and operand_value in ('shared_base', 'shared_limit', 'private_base', 'private_limit', 'pops_exiting_wave_id'): return  # ival
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, iconst, ival
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    if isinstance(operand_value, str) and operand_value in ('shared_base', 'shared_limit', 'private_base', 'private_limit', 'pops_exiting_wave_id'): return  # ival
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_sdst_7(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # sdst¶

    Instruction output.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, ttmp
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_5(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, lds_direct
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vcc(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vcc¶

    Vector condition code.

    Size: 2 dwords.

    Operands: vcc
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_6(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, iconst, ival, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    if isinstance(operand_value, str) and operand_value in ('shared_base', 'shared_limit', 'private_base', 'private_limit', 'pops_exiting_wave_id'): return  # ival
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_7(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, constant, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_8(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_simm32_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # simm32¶

    A floating-point_number, an integer_number, or an absolute_expression. The value is converted to f16 as described here.
    """
    check(isinstance(operand_value, int) or isinstance(operand_value, float), operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_simm32_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # simm32¶

    A floating-point_number, an integer_number, or an absolute_expression. The value is converted to f32 as described here.
    """
    check(isinstance(operand_value, int) or isinstance(operand_value, float), operand_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_9(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 2 dwords.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, exec, vccz, execz, scc, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_src_10(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, iconst, ival
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    if isinstance(operand_value, str) and operand_value in ('shared_base', 'shared_limit', 'private_base', 'private_limit', 'pops_exiting_wave_id'): return  # ival
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vsrc_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vsrc¶

    Instruction input.

    Size: 4 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 4
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_7(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, iconst
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_ssrc_8(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # ssrc¶

    Instruction input.

    Size: 1 dword.

    Operands: s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx9_vsrc_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vsrc¶

    Instruction input.

    Size: 2 dwords.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 2
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_vdst(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vdst¶

    Instruction output.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_src(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, constant, literal
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    if isinstance(operand_value, int) and (-0x80000000 <= operand_value < 0xffffffff+1): return  # literal
    if isinstance(operand_value, float): return  # literal
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_vsrc(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # vsrc¶

    Instruction input.

    Size: 1 dword.

    Operands: v
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_src_1(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_src_2(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, constant
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # constant
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_src_3(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, lds_direct, iconst, ival
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is lds_direct: return  # lds_direct
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    if isinstance(operand_value, str) and operand_value in ('shared_base', 'shared_limit', 'private_base', 'private_limit', 'pops_exiting_wave_id'): return  # ival
    raise SeekException(f'Invalid operand: {operand_value}')

# noinspection DuplicatedCode,PyUnusedLocal
def validate_operand_synid_gfx906_src_4(category, instr_name, operands, modifiers, operand_text, operand_value, /, allow_abs: bool = False, allow_neg: bool = False, allow_sext: bool = False):
    """
    # src¶

    Instruction input.

    Size: 1 dword.

    Operands: v, s, flat_scratch, xnack_mask, vcc, ttmp, m0, exec, vccz, execz, scc, iconst, ival
    """
    if isinstance(operand_value, Gpr):
        # Check operand size
        operand_size = 1
        __check_size(operand_value, operand_size, allow_off=False)

        # Check operand alignment
        __check_alignment(operand_value, operand_size)

        # Check operand abs(), neg(), sext()
        __check_abs_neg_sext(operand_value, allow_abs, allow_neg, allow_sext)

    # Check operands Gpr rtype
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_vgpr(): return  # v
    if isinstance(operand_value, Gpr) and operand_value.rtype.is_sgpr(): return  # s
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is flat_scratch: return  # flat_scratch
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is xnack_mask: return  # xnack_mask
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vcc: return  # vcc
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is m0: return  # m0
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is exec: return  # exec
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is vccz: return  # vccz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is execz: return  # execz
    if isinstance(operand_value, Gpr) and operand_value.base_gpr is scc: return  # scc
    if isinstance(operand_value, int) and (-16 <= operand_value <= 64): return  # iconst
    if isinstance(operand_value, str) and operand_value in ('shared_base', 'shared_limit', 'private_base', 'private_limit', 'pops_exiting_wave_id'): return  # ival
    raise SeekException(f'Invalid operand: {operand_value}')

