"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from typing import Optional, Hashable, Dict, Set
# noinspection PyUnresolvedReferences
from .autogen_validate_operands import *
# noinspection PyUnresolvedReferences
from .autogen_validate_modifiers import *
# noinspection PyUnresolvedReferences
from ...basic.instr import InstrCall, MemToken, SrcLoc


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_add(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_add
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_add', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_add', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_add', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_add', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_add', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_add', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_add', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_add', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_add', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_add', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_add', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_and(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_and
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_and', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_and', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_and', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_and', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_and', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_and', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_and', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_and', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_and', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_and', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_and', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_cmpswap(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_cmpswap
    Operands:
        src0: vdata/*synid-gfx9-vdata-5*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_5('mimg', 'image_atomic_cmpswap', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_cmpswap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_cmpswap', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_cmpswap', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_cmpswap', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_cmpswap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_cmpswap', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_cmpswap', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_cmpswap', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_cmpswap', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_cmpswap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_dec(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_dec
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_dec', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_dec', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_dec', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_dec', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_dec', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_dec', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_dec', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_dec', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_dec', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_dec', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_dec', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_inc(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_inc
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_inc', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_inc', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_inc', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_inc', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_inc', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_inc', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_inc', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_inc', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_inc', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_inc', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_inc', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_or(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_or
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_or', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_or', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_or', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_or', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_or', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_or', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_or', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_or', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_or', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_or', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_or', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_smax(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_smax
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_smax', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_smax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_smax', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_smax', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_smax', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_smax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_smax', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_smax', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_smax', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_smax', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_smax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_smin(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_smin
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_smin', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_smin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_smin', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_smin', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_smin', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_smin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_smin', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_smin', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_smin', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_smin', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_smin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_sub(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_sub
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_sub', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_sub', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_sub', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_sub', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_sub', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_sub', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_sub', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_sub', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_sub', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_sub', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_sub', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_swap(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_swap
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_swap', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_swap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_swap', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_swap', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_swap', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_swap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_swap', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_swap', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_swap', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_swap', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_swap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_umax(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_umax
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_umax', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_umax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_umax', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_umax', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_umax', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_umax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_umax', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_umax', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_umax', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_umax', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_umax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_umin(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_umin
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_umin', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_umin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_umin', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_umin', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_umin', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_umin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_umin', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_umin', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_umin', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_umin', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_umin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_atomic_xor(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_atomic_xor
    Operands:
        src0: vdata/*synid-gfx9-vdata-4*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_4('mimg', 'image_atomic_xor', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_atomic_xor', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_atomic_xor', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_atomic_xor', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_atomic_xor', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_atomic_xor', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_atomic_xor', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_atomic_xor', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_atomic_xor', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_atomic_xor', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_atomic_xor', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_b(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_b
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_b', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_b', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_b', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_b', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_b', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_b', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_b', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_b', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_b', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_b', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_b', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_b', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_b', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_b_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_b_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_b_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_b_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_b_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_b_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_b_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_b_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_b_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_b_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_b_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_b_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_b_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_b_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_b_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_b_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_b_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_b_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_b_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_b_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_b_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_b_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_b_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_b_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_b_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_b_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_b_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_b_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_b_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_b_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_b_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_b_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_b_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_b_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_b(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_b
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_b', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_b', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_b', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_b', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_b', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_b', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_b', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_b', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_b', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_b', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_b', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_b', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_b', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_b_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_b_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_b_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_b_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_b_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_b_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_b_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_b_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_b_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_b_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_b_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_b_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_b_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_b_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_b_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_b_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_b_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_b_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_b_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_b_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_b_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_b_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_l(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_l
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_l', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_l', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_l', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_l', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_l', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_l', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_l', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_l', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_l', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_l', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_l', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_l', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_l', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_l_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_l_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_l_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_l_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_l_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_l_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_l_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_l_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_l_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_l_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_l_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_l_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_l_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_l_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_l_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_lz(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_lz
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_lz', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_lz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_lz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_lz', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_lz', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_lz', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_lz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_lz', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_lz', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_lz', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_lz', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_lz', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_lz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_lz_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_lz_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_lz_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_lz_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_c_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_c_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_c_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_c_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_c_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_c_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_c_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_c_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_c_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_c_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_c_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_c_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_c_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_c_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_c_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_l(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_l
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_l', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_l', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_l', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_l', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_l', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_l', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_l', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_l', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_l', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_l', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_l', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_l', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_l', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_l_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_l_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_l_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_l_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_l_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_l_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_l_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_l_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_l_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_l_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_l_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_l_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_l_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_l_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_l_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_lz(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_lz
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_lz', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_lz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_lz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_lz', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_lz', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_lz', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_lz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_lz', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_lz', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_lz', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_lz', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_lz', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_lz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_lz_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_lz_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_lz_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_lz_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_lz_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_lz_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_lz_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_lz_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_lz_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_lz_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_lz_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_lz_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_lz_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_lz_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_lz_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_gather4_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_gather4_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-6*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_6('mimg', 'image_gather4_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_gather4_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_gather4_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_gather4_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_gather4_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_gather4_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_gather4_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_gather4_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_gather4_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_gather4_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_gather4_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_gather4_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_gather4_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_get_lod(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_get_lod
    Operands:
        dst: vdst/*synid-gfx9-vdst-7*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdst_7('mimg', 'image_get_lod', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_get_lod', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_get_lod', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_get_lod', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_get_lod', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_get_lod', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_get_lod', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_get_lod', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_get_lod', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_get_lod', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_get_lod', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_get_lod', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_get_lod', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_get_resinfo(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_get_resinfo
    Operands:
        dst: vdst/*synid-gfx9-vdst-7*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdst_7('mimg', 'image_get_resinfo', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_get_resinfo', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_get_resinfo', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_get_resinfo', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_get_resinfo', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_get_resinfo', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_get_resinfo', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_get_resinfo', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_get_resinfo', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_get_resinfo', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_get_resinfo', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_get_resinfo', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_load(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_load
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_load', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_load', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_load', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_load', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_load', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_load', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_load', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_load', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_load', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_load', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_load', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_load', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_load', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_load_mip(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_load_mip
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_load_mip', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_load_mip', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_load_mip', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_load_mip', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_load_mip', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_load_mip', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_load_mip', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_load_mip', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_load_mip', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_load_mip', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_load_mip', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_load_mip', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_load_mip', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_load_mip_pck(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_load_mip_pck
    Operands:
        dst: vdst/*synid-gfx9-vdst-7*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdst_7('mimg', 'image_load_mip_pck', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_load_mip_pck', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_load_mip_pck', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_load_mip_pck', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_load_mip_pck', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_load_mip_pck', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_load_mip_pck', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_load_mip_pck', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_load_mip_pck', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_load_mip_pck', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_load_mip_pck', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_load_mip_pck', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_load_mip_pck_sgn(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_load_mip_pck_sgn
    Operands:
        dst: vdst/*synid-gfx9-vdst-7*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdst_7('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_load_mip_pck_sgn', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_load_mip_pck_sgn', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_load_pck(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_load_pck
    Operands:
        dst: vdst/*synid-gfx9-vdst-7*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdst_7('mimg', 'image_load_pck', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_load_pck', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_load_pck', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_load_pck', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_load_pck', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_load_pck', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_load_pck', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_load_pck', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_load_pck', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_load_pck', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_load_pck', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_load_pck', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_load_pck_sgn(vdst, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_load_pck_sgn
    Operands:
        dst: vdst/*synid-gfx9-vdst-7*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdst_7('mimg', 'image_load_pck_sgn', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_load_pck_sgn', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_load_pck_sgn', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_load_pck_sgn', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_load_pck_sgn', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_load_pck_sgn', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_load_pck_sgn', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_load_pck_sgn', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_load_pck_sgn', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_load_pck_sgn', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_load_pck_sgn', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_load_pck_sgn', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_b(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_b
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_b', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_b', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_b', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_b', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_b', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_b', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_b', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_b', operands, modifiers, 'slc', slc)
    validate_modifier_synid_tfe('mimg', 'image_sample_b', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_b', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_b', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_b', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_b', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_b_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_b_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_b_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_b_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_b_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_b_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_b_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_b_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_b_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_b_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_b_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_b_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_b_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_b_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_b_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_b_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_b_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_b_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_b_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_b_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_b_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_b_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_b_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_b_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_b_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_b_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_b_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_b_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_b_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_b_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_b_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_b_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_b_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_b_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_b_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_b_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_b_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_b_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_b_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_b_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_b_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_b_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_tfe('mimg', 'image_sample_b_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_b_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_b_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_b_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_b_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_b(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_b
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_b', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_b', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_b', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_b', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_b', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_b', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_b', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_b', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_b', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_b', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_b', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_b', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_b', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_b', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_b_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_b_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_b_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_b_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_b_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_b_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_b_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_b_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_b_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_b_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_b_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_b_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_b_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_b_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_b_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_b_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_b_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_b_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_b_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_b_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_b_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_b_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_b_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_b_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_b_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_b_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_b_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_b_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_b_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_b_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_b_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_b_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_b_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_b_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_b_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_b_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_cd(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_cd
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_cd', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_cd', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_cd', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_cd', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_cd', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_cd', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_cd', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_cd', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_cd', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_cd', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_cd', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_cd', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_cd', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_cd', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_cd_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_cd_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_cd_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_cd_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_cd_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_cd_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_cd_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_cd_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_cd_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_cd_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_cd_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_cd_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_cd_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_cd_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_cd_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_cd_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_cd_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_cd_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_cd_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_cd_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_cd_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_cd_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_cd_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_d(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_d
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_d', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_d', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_d', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_d', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_d', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_d', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_d', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_d', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_d', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_d', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_d', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_d', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_d', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_d', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_d_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_d_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_d_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_d_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_d_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_d_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_d_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_d_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_d_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_d_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_d_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_d_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_d_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_d_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_d_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_d_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_d_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_d_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_d_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_d_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_d_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_d_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_d_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_d_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_d_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_d_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_d_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_d_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_d_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_d_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_d_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_d_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_d_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_d_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_d_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_d_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_l(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_l
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_l', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_l', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_l', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_l', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_l', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_l', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_l', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_l', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_l', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_l', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_l', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_l', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_l', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_l', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_l_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_l_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_l_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_l_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_l_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_l_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_l_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_l_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_l_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_l_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_l_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_l_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_l_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_l_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_l_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_l_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_lz(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_lz
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_lz', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_lz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_lz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_lz', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_lz', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_lz', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_lz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_lz', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_lz', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_lz', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_lz', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_lz', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_lz', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_lz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_lz_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_lz_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_lz_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_lz_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_lz_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_lz_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_lz_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_lz_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_lz_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_lz_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_lz_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_lz_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_lz_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_lz_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_lz_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_lz_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_c_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_c_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_c_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_c_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_c_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_c_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_c_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_c_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_c_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_c_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_c_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_c_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_c_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_c_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_c_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_c_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_cd(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_cd
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_cd', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_cd', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_cd', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_cd', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_cd', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_cd', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_cd', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_cd', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_cd', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_cd', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_cd', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_cd', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_cd', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_cd', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_cd_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_cd_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_cd_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_cd_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_cd_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_cd_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_cd_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_cd_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_cd_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_cd_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_cd_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_cd_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_cd_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_cd_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_cd_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_cd_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_cd_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_cd_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_cd_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_cd_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_cd_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_cd_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_cd_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_cd_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_cd_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_cd_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_cd_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_cd_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_cd_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_cd_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_cd_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_cd_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_cd_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_cd_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_cd_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_cd_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_d(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_d
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_d', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_d', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_d', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_d', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_d', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_d', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_d', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_d', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_d', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_d', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_d', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_d', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_d', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_d', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_d_cl(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_d_cl
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_d_cl', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_d_cl', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_d_cl', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_d_cl', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_d_cl', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_d_cl', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_d_cl', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_d_cl', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_d_cl', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_d_cl', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_d_cl', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_d_cl', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_d_cl', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_d_cl', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_d_cl_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_d_cl_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_d_cl_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_d_cl_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_d_cl_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_d_cl_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_d_cl_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_d_cl_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_d_cl_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_d_cl_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_d_cl_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_d_cl_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_d_cl_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_d_cl_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_d_cl_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_d_cl_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_d_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_d_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_d_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_d_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_d_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_d_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_d_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_d_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_d_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_d_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_d_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_d_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_d_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_d_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_d_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_d_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_l(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_l
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_l', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_l', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_l', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_l', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_l', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_l', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_l', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_l', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_l', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_l', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_l', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_l', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_l', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_l', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_l_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_l_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_l_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_l_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_l_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_l_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_l_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_l_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_l_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_l_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_l_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_l_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_l_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_l_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_l_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_l_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_lz(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_lz
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_lz', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_lz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_lz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_lz', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_lz', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_lz', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_lz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_lz', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_lz', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_lz', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_lz', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_lz', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_lz', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_lz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_lz_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_lz_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_lz_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_lz_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_lz_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_lz_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_lz_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_lz_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_lz_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_lz_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_lz_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_lz_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_lz_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_lz_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_lz_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_lz_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_sample_o(vdst, vaddr, srsrc, ssamp, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, tfe=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_sample_o
    Operands:
        dst: vdst/*synid-gfx9-vdst-8*/
        src0: vaddr/*synid-gfx9-vaddr-4*/
        src1: srsrc/*synid-gfx9-srsrc*/
        src2: ssamp/*synid-gfx9-ssamp*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        tfe/*synid-tfe*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'ssamp': ssamp}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'tfe': tfe, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdst_8('mimg', 'image_sample_o', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_sample_o', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_sample_o', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_ssamp('mimg', 'image_sample_o', operands, modifiers, 'ssamp', ssamp)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_sample_o', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_sample_o', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_sample_o', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_sample_o', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_sample_o', operands, modifiers, 'a16', a16)
    validate_modifier_synid_tfe('mimg', 'image_sample_o', operands, modifiers, 'tfe', tfe)
    validate_modifier_synid_lwe('mimg', 'image_sample_o', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_sample_o', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_sample_o', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_sample_o', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, ssamp, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_store(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_store
    Operands:
        src0: vdata/*synid-gfx9-vdata-6*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdata_6('mimg', 'image_store', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_store', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_store', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_store', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_store', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_store', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_store', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_store', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_store', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_store', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_store', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_store', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_store_mip(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, d16=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_store_mip
    Operands:
        src0: vdata/*synid-gfx9-vdata-6*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
        d16/*synid-d16*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da, 'd16': d16}

    # Operands validation
    validate_operand_synid_gfx9_vdata_6('mimg', 'image_store_mip', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_store_mip', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_store_mip', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_store_mip', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_store_mip', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_store_mip', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_store_mip', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_store_mip', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_store_mip', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_store_mip', operands, modifiers, 'da', da)
    validate_modifier_synid_d16('mimg', 'image_store_mip', operands, modifiers, 'd16', d16)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_store_mip', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_store_mip_pck(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_store_mip_pck
    Operands:
        src0: vdata/*synid-gfx9-vdata-7*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_7('mimg', 'image_store_mip_pck', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_store_mip_pck', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_store_mip_pck', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_store_mip_pck', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_store_mip_pck', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_store_mip_pck', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_store_mip_pck', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_store_mip_pck', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_store_mip_pck', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_store_mip_pck', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_store_mip_pck', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def image_store_pck(vdata, vaddr, srsrc, /, dmask=None, unorm=None, glc=None, slc=None, a16=None, lwe=None, da=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: image_store_pck
    Operands:
        src0: vdata/*synid-gfx9-vdata-7*/
        src1: vaddr/*synid-gfx9-vaddr-4*/
        src2: srsrc/*synid-gfx9-srsrc*/
    Modifiers:
        dmask/*synid-dmask*/
        unorm/*synid-unorm*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        a16/*synid-a16*/
        lwe/*synid-lwe*/
        da/*synid-da*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc}
    modifiers = {'dmask': dmask, 'unorm': unorm, 'glc': glc, 'slc': slc, 'a16': a16, 'lwe': lwe, 'da': da}

    # Operands validation
    validate_operand_synid_gfx9_vdata_7('mimg', 'image_store_pck', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_4('mimg', 'image_store_pck', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc('mimg', 'image_store_pck', operands, modifiers, 'srsrc', srsrc)

    # Modifiers validation
    validate_modifier_synid_dmask('mimg', 'image_store_pck', operands, modifiers, 'dmask', dmask)
    validate_modifier_synid_unorm('mimg', 'image_store_pck', operands, modifiers, 'unorm', unorm)
    validate_modifier_synid_glc('mimg', 'image_store_pck', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mimg', 'image_store_pck', operands, modifiers, 'slc', slc)
    validate_modifier_synid_a16('mimg', 'image_store_pck', operands, modifiers, 'a16', a16)
    validate_modifier_synid_lwe('mimg', 'image_store_pck', operands, modifiers, 'lwe', lwe)
    validate_modifier_synid_da('mimg', 'image_store_pck', operands, modifiers, 'da', da)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mimg', 'image_store_pck', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


