import unittest
from typing import Any
from seek.basic.exception import SeekException
from seek.basic.utility import get_caller_assignments


class TestUtility(unittest.TestCase):
    def test_get_caller_assignments(self):
        x1 = get_caller_assignments(stack=0)
        self.assertEqual(x1, "x1")

        x2, = get_caller_assignments(stack=0)
        self.assertEqual(x2, "x2")  # `x2` is not a list any more

        x3, x4 = get_caller_assignments(stack=0)
        self.assertTupleEqual((x3, x4), ("x3", "x4"))

        x5, (x6, [x7, (x8, x9), _]) = get_caller_assignments(stack=0)
        self.assertTupleEqual((x5, x6, x7, x8, x9, _), ("x5", "x6", "x7", "x8", "x9", "_"))

        x10: Any = get_caller_assignments(stack=0)
        self.assertEqual(x10, "x10")

        # This is not an assignment and should return None
        self.assertIsNone(get_caller_assignments(stack=0))

        # The stack is invalid, so it should raise SeekException
        # Note that we didn't actually parse the source code here (as the stack depth is invalid),
        # so multi-line source code is OK
        self.assertRaisesRegex(SeekException,
                               r"Can't get frame at stack depth 1000000 from bottom",
                               lambda: get_caller_assignments(stack=1000000))


if __name__ == "__main__":
    unittest.main()
