"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from typing import Optional, Hashable, Dict, Set
# noinspection PyUnresolvedReferences
from .autogen_validate_operands import *
# noinspection PyUnresolvedReferences
from .autogen_validate_modifiers import *
# noinspection PyUnresolvedReferences
from ...basic.instr import InstrCall, MemToken, SrcLoc


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_add(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_add
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_add', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_add', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_add', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_add', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_add', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_add', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_add', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_add_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_add_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_add_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_add_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_add_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_add_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_add_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_add_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_add_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_and(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_and
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_and', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_and', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_and', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_and', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_and', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_and', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_and', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_and_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_and_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_and_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_and_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_and_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_and_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_and_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_and_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_and_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_cmpswap(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_cmpswap
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:b32x2/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_cmpswap', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_cmpswap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_cmpswap', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_cmpswap', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_cmpswap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_cmpswap', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_cmpswap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_cmpswap_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_cmpswap_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-2*/:b64x2/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_2('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_cmpswap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_dec(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_dec
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_dec', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_dec', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_dec', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_dec', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_dec', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_dec', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_dec', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_dec_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_dec_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_dec_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_dec_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_dec_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_dec_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_dec_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_dec_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_dec_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_inc(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_inc
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_inc', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_inc', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_inc', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_inc', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_inc', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_inc', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_inc', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_inc_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_inc_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_inc_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_inc_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_inc_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_inc_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_inc_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_inc_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_inc_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_or(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_or
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_or', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_or', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_or', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_or', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_or', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_or', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_or', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_or_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_or_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_or_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_or_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_or_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_or_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_or_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_or_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_or_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_smax(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_smax
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:i32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/:i32/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_smax', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_smax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_smax', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_smax', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_smax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_smax', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_smax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_smax_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_smax_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:i64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:i64/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_smax_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_smax_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_smax_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_smax_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_smax_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_smax_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_smax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_smin(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_smin
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:i32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/:i32/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_smin', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_smin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_smin', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_smin', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_smin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_smin', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_smin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_smin_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_smin_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:i64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:i64/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_smin_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_smin_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_smin_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_smin_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_smin_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_smin_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_smin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_sub(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_sub
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_sub', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_sub', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_sub', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_sub', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_sub', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_sub', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_sub', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_sub_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_sub_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_sub_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_sub_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_sub_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_sub_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_sub_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_sub_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_sub_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_swap(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_swap
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_swap', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_swap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_swap', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_swap', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_swap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_swap', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_swap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_swap_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_swap_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_swap_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_swap_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_swap_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_swap_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_swap_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_swap_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_swap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_umax(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_umax
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_umax', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_umax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_umax', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_umax', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_umax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_umax', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_umax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_umax_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_umax_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_umax_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_umax_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_umax_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_umax_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_umax_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_umax_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_umax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_umin(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_umin
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_umin', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_umin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_umin', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_umin', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_umin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_umin', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_umin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_umin_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_umin_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_umin_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_umin_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_umin_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_umin_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_umin_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_umin_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_umin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_xor(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_xor
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'flat_atomic_xor', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_xor', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_atomic_xor', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_xor', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_xor', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_xor', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_xor', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_atomic_xor_x2(vdst, vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_atomic_xor_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'flat_atomic_xor_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_atomic_xor_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_atomic_xor_x2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_atomic_xor_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_atomic_xor_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_atomic_xor_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_atomic_xor_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_dword(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_dword
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_dword', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_dword', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_dwordx2(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_dwordx2
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('flat', 'flat_load_dwordx2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_dwordx2', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_dwordx3(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_dwordx3
    Operands:
        dst: vdst/*synid-gfx9-vdst-3*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_3('flat', 'flat_load_dwordx3', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_dwordx3', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_dwordx4(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_dwordx4
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('flat', 'flat_load_dwordx4', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_dwordx4', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_sbyte(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_sbyte
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_sbyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_sbyte', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_sbyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_sbyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_sbyte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_sbyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_sbyte_d16(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_sbyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_sbyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_sbyte_d16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_sbyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_sbyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_sbyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_sbyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_sbyte_d16_hi(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_sbyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_sbyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_sbyte_d16_hi', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_sbyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_sbyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_sbyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_sbyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_short_d16(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_short_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_short_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_short_d16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_short_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_short_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_short_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_short_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_short_d16_hi(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_short_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_short_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_short_d16_hi', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_sshort(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_sshort
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_sshort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_sshort', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_sshort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_sshort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_sshort', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_sshort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_ubyte(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_ubyte
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_ubyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_ubyte', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_ubyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_ubyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_ubyte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_ubyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_ubyte_d16(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_ubyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_ubyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_ubyte_d16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_ubyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_ubyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_ubyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_ubyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_ubyte_d16_hi(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_ubyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_ubyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_ubyte_d16_hi', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_ubyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_ubyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_ubyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_ubyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_load_ushort(vdst, vaddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_load_ushort
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'flat_load_ushort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_load_ushort', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_load_ushort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_load_ushort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_load_ushort', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_load_ushort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_byte(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_byte
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_byte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_store_byte', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_byte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_byte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_byte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_byte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_byte_d16_hi(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_byte_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_byte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_store_byte_d16_hi', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_byte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_byte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_byte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_byte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_dword(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_dword
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_store_dword', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_dwordx2(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_dwordx2
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'flat_store_dwordx2', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_dwordx3(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_dwordx3
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-3*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_3('flat', 'flat_store_dwordx3', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_dwordx4(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_dwordx4
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata-2*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_2('flat', 'flat_store_dwordx4', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_short(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_short
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_short', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_store_short', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_short', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_short', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_short', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_short', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def flat_store_short_d16_hi(vaddr, vdata, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: flat_store_short_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-1*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-flat-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_1('flat', 'flat_store_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'flat_store_short_d16_hi', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_flat_offset12('flat', 'flat_store_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'flat_store_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'flat_store_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'flat_store_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_add(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_add
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_add', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_add', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_add', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_add', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_add', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_add', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_add', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_add', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_add_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_add_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_add_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_add_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_add_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_add_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_add_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_add_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_add_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_add_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_and(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_and
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_and', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_and', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_and', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_and', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_and', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_and', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_and', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_and', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_and_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_and_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_and_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_and_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_and_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_and_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_and_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_and_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_and_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_and_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_cmpswap(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_cmpswap
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:b32x2/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_cmpswap', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_cmpswap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_cmpswap', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_cmpswap', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_cmpswap', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_cmpswap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_cmpswap', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_cmpswap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_cmpswap_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_cmpswap_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-2*/:b64x2/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_2('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_cmpswap_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_cmpswap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_dec(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_dec
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_dec', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_dec', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_dec', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_dec', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_dec', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_dec', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_dec', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_dec', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_dec_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_dec_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_dec_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_dec_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_dec_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_dec_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_dec_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_dec_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_dec_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_dec_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_inc(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_inc
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_inc', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_inc', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_inc', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_inc', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_inc', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_inc', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_inc', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_inc', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_inc_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_inc_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_inc_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_inc_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_inc_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_inc_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_inc_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_inc_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_inc_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_inc_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_or(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_or
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_or', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_or', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_or', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_or', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_or', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_or', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_or', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_or', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_or_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_or_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_or_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_or_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_or_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_or_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_or_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_or_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_or_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_or_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_smax(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_smax
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:i32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/:i32/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_smax', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_smax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_smax', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_smax', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_smax', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_smax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_smax', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_smax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_smax_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_smax_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:i64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:i64/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_smax_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_smax_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_smax_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_smax_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_smax_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_smax_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_smax_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_smax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_smin(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_smin
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:i32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/:i32/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_smin', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_smin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_smin', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_smin', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_smin', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_smin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_smin', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_smin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_smin_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_smin_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:i64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:i64/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_smin_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_smin_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_smin_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_smin_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_smin_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_smin_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_smin_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_smin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_sub(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_sub
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_sub', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_sub', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_sub', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_sub', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_sub', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_sub', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_sub', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_sub', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_sub_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_sub_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_sub_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_sub_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_sub_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_sub_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_sub_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_sub_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_sub_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_sub_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_swap(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_swap
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_swap', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_swap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_swap', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_swap', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_swap', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_swap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_swap', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_swap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_swap_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_swap_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_swap_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_swap_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_swap_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_swap_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_swap_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_swap_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_swap_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_swap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_umax(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_umax
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_umax', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_umax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_umax', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_umax', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_umax', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_umax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_umax', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_umax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_umax_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_umax_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_umax_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_umax_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_umax_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_umax_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_umax_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_umax_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_umax_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_umax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_umin(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_umin
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/:u32/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/:u32/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_umin', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_umin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_umin', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_umin', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_umin', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_umin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_umin', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_umin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_umin_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_umin_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/:u64/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/:u64/*synid-gfx9-type-deviation*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_umin_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_umin_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_umin_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_umin_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_umin_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_umin_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_umin_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_umin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_xor(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_xor
    Operands:
        dst: vdst/*synid-gfx9-vdst-4*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_4('flat', 'global_atomic_xor', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_xor', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_atomic_xor', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_xor', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_xor', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_xor', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_xor', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_xor', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_atomic_xor_x2(vdst, vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_atomic_xor_x2
    Operands:
        dst: vdst/*synid-gfx9-vdst-5*/:opt/*synid-gfx9-opt*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_5('flat', 'global_atomic_xor_x2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_atomic_xor_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_atomic_xor_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_atomic_xor_x2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_atomic_xor_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_atomic_xor_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_atomic_xor_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdst)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_atomic_xor_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)
    if glc:
        call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_dword(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_dword
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_dword', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_dword', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_dwordx2(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_dwordx2
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('flat', 'global_load_dwordx2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_dwordx2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_dwordx3(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_dwordx3
    Operands:
        dst: vdst/*synid-gfx9-vdst-3*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_3('flat', 'global_load_dwordx3', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_dwordx3', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_dwordx4(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_dwordx4
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('flat', 'global_load_dwordx4', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_dwordx4', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_sbyte(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_sbyte
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_sbyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_sbyte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_sbyte', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_sbyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_sbyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_sbyte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_sbyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_sbyte_d16(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_sbyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_sbyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_sbyte_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_sbyte_d16', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_sbyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_sbyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_sbyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_sbyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_sbyte_d16_hi(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_sbyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_sbyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_sbyte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_sbyte_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_sbyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_sbyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_sbyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_sbyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_short_d16(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_short_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_short_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_short_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_short_d16', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_short_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_short_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_short_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_short_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_short_d16_hi(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_short_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_short_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_short_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_sshort(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_sshort
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_sshort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_sshort', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_sshort', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_sshort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_sshort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_sshort', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_sshort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_ubyte(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_ubyte
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_ubyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_ubyte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_ubyte', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_ubyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_ubyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_ubyte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_ubyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_ubyte_d16(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_ubyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_ubyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_ubyte_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_ubyte_d16', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_ubyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_ubyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_ubyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_ubyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_ubyte_d16_hi(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_ubyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_ubyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_ubyte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_ubyte_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_ubyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_ubyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_ubyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_ubyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_load_ushort(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_load_ushort
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'global_load_ushort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_load_ushort', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr('flat', 'global_load_ushort', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_load_ushort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_load_ushort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_load_ushort', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_load_ushort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_byte(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_byte
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_byte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_store_byte', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_byte', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_byte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_byte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_byte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_byte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_byte_d16_hi(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_byte_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_byte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_store_byte_d16_hi', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_byte_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_byte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_byte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_byte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_byte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_dword(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_dword
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_store_dword', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_dword', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_dwordx2(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_dwordx2
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'global_store_dwordx2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_dwordx2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_dwordx3(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_dwordx3
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-3*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_3('flat', 'global_store_dwordx3', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_dwordx3', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_dwordx4(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_dwordx4
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata-2*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_2('flat', 'global_store_dwordx4', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_dwordx4', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_short(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_short
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_short', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_store_short', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_short', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_short', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_short', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_short', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_short', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def global_store_short_d16_hi(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: global_store_short_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-2*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_2('flat', 'global_store_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'global_store_short_d16_hi', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr('flat', 'global_store_short_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'global_store_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'global_store_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'global_store_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'global_store_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_dword(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_dword
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_dword', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_dword', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_dwordx2(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_dwordx2
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('flat', 'scratch_load_dwordx2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_dwordx2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_dwordx3(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_dwordx3
    Operands:
        dst: vdst/*synid-gfx9-vdst-3*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_3('flat', 'scratch_load_dwordx3', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_dwordx3', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_dwordx4(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_dwordx4
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('flat', 'scratch_load_dwordx4', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_dwordx4', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_sbyte(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_sbyte
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_sbyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_sbyte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_sbyte', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_sbyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_sbyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_sbyte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_sbyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_sbyte_d16(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_sbyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_sbyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_sbyte_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_sbyte_d16', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_sbyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_sbyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_sbyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_sbyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_sbyte_d16_hi(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_sbyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_sbyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_short_d16(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_short_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_short_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_short_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_short_d16', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_short_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_short_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_short_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_short_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_short_d16_hi(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_short_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_short_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_short_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_sshort(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_sshort
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_sshort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_sshort', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_sshort', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_sshort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_sshort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_sshort', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_sshort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_ubyte(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_ubyte
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_ubyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_ubyte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_ubyte', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_ubyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_ubyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_ubyte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_ubyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_ubyte_d16(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_ubyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_ubyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_ubyte_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_ubyte_d16', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_ubyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_ubyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_ubyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_ubyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_ubyte_d16_hi(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_ubyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_ubyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_load_ushort(vdst, vaddr, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_load_ushort
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst('flat', 'scratch_load_ushort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_load_ushort', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_load_ushort', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_load_ushort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_load_ushort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_load_ushort', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_load_ushort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_byte(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_byte
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_byte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'scratch_store_byte', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_byte', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_byte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_byte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_byte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_byte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_byte_d16_hi(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_byte_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_byte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'scratch_store_byte_d16_hi', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_byte_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_byte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_byte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_byte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_byte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_dword(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_dword
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'scratch_store_dword', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_dword', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_dwordx2(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_dwordx2
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata-1*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('flat', 'scratch_store_dwordx2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_dwordx2', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_dwordx3(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_dwordx3
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata-3*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_3('flat', 'scratch_store_dwordx3', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_dwordx3', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_dwordx4(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_dwordx4
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata-2*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_2('flat', 'scratch_store_dwordx4', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_dwordx4', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_short(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_short
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_short', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'scratch_store_short', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_short', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_short', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_short', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_short', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_short', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def scratch_store_short_d16_hi(vaddr, vdata, saddr, /, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: scratch_store_short_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr-3*/
        src1: vdata/*synid-gfx9-vdata*/
        src2: saddr/*synid-gfx9-saddr-1*/
    Modifiers:
        offset/*synid-flat-offset13s*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata, 'saddr': saddr}
    modifiers = {'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vaddr_3('flat', 'scratch_store_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('flat', 'scratch_store_short_d16_hi', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_saddr_1('flat', 'scratch_store_short_d16_hi', operands, modifiers, 'saddr', saddr)

    # Modifiers validation
    validate_modifier_synid_flat_offset13s('flat', 'scratch_store_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('flat', 'scratch_store_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('flat', 'scratch_store_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('flat', 'scratch_store_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, flat_scratch, saddr, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


