"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from typing import Optional, Hashable, Dict, Set
# noinspection PyUnresolvedReferences
from .autogen_validate_operands import *
# noinspection PyUnresolvedReferences
from .autogen_validate_modifiers import *
# noinspection PyUnresolvedReferences
from ...basic.instr import InstrCall, MemToken, SrcLoc


# noinspection DuplicatedCode,PyDictCreation
def ds_add_f32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_add_f32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_rtn_f32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_rtn_f32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_add_rtn_f32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_rtn_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_add_rtn_f32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_rtn_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_rtn_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_rtn_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_add_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_add_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_add_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_add_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_src2_f32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_src2_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_src2_f32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_src2_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_src2_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_src2_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_add_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_add_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_add_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_add_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_add_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_add_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_add_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_add_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_and_b32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_and_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_and_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_and_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_and_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_and_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_and_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_and_b64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_and_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_and_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_and_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_and_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_and_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_and_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_and_rtn_b32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_and_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_and_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_and_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_and_rtn_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_and_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_and_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_and_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_and_rtn_b64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_and_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_and_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_and_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_and_rtn_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_and_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_and_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_and_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_and_src2_b32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_and_src2_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_and_src2_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_and_src2_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_and_src2_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_and_src2_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_and_src2_b64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_and_src2_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_and_src2_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_and_src2_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_and_src2_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_and_src2_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_append(vdst, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_append
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_append', operands, modifiers, 'vdst', vdst)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_append', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_append', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_append', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_bpermute_b32(vdst, vaddr, vdata, /, offset=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_bpermute_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_bpermute_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_bpermute_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_bpermute_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_bpermute_b32', operands, modifiers, 'offset', offset)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_lds': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_bpermute_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_b32(vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_cmpst_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_cmpst_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_b64(vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_cmpst_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_cmpst_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_f32(vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_cmpst_f32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_cmpst_f32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_f64(vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_f64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_f64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_cmpst_f64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_cmpst_f64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_rtn_b32(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_cmpst_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_cmpst_rtn_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_cmpst_rtn_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_rtn_b64(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_cmpst_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_cmpst_rtn_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_cmpst_rtn_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_rtn_f32(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_rtn_f32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_cmpst_rtn_f32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_rtn_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_cmpst_rtn_f32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_cmpst_rtn_f32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_rtn_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_rtn_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_rtn_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_cmpst_rtn_f64(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_cmpst_rtn_f64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_cmpst_rtn_f64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_cmpst_rtn_f64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_cmpst_rtn_f64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_cmpst_rtn_f64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_cmpst_rtn_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_cmpst_rtn_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_cmpst_rtn_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_condxchg32_rtn_b64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_condxchg32_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_condxchg32_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_condxchg32_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_condxchg32_rtn_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_condxchg32_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_condxchg32_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_condxchg32_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_consume(vdst, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_consume
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_consume', operands, modifiers, 'vdst', vdst)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_consume', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_consume', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_consume', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_dec_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_dec_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_dec_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_dec_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_dec_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_dec_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_dec_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_dec_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_dec_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_dec_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_dec_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_dec_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_dec_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_dec_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_dec_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_dec_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_dec_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_dec_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_dec_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_dec_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_dec_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_dec_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_dec_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_dec_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_dec_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_dec_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_dec_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_dec_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_dec_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_dec_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_dec_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_dec_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_dec_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_dec_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_dec_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_dec_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_dec_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_dec_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_dec_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_dec_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_dec_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_dec_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_gws_barrier(vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_gws_barrier
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdata('ds', 'ds_gws_barrier', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_gws_barrier', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_gws_barrier', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_gws_barrier', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_gws_init(vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_gws_init
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdata('ds', 'ds_gws_init', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_gws_init', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_gws_init', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_gws_init', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_gws_sema_br(vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_gws_sema_br
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdata('ds', 'ds_gws_sema_br', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_gws_sema_br', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_gws_sema_br', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_gws_sema_br', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_gws_sema_p(*, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_gws_sema_p
    Operands: -
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {'offset': offset, 'gds': gds}

    # No operands to validate

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_gws_sema_p', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_gws_sema_p', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_gws_sema_p', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_gws_sema_release_all(*, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_gws_sema_release_all
    Operands: -
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {'offset': offset, 'gds': gds}

    # No operands to validate

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_gws_sema_release_all', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_gws_sema_release_all', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_gws_sema_release_all', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_gws_sema_v(*, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_gws_sema_v
    Operands: -
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {'offset': offset, 'gds': gds}

    # No operands to validate

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_gws_sema_v', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_gws_sema_v', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_gws_sema_v', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_inc_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_inc_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_inc_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_inc_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_inc_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_inc_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_inc_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_inc_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_inc_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_inc_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_inc_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_inc_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_inc_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_inc_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_inc_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_inc_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_inc_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_inc_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_inc_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_inc_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_inc_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_inc_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_inc_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_inc_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_inc_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_inc_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_inc_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_inc_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_inc_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_inc_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_inc_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_inc_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_inc_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_inc_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_inc_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_inc_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_inc_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_inc_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_inc_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_inc_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_inc_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_inc_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_f32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_max_f32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_f64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_f64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_f64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_max_f64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_i32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_i32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_i32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_max_i32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_i32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_i32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_i32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_i64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_i64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_i64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_max_i64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_i64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_i64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_i64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_rtn_f32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_rtn_f32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_max_rtn_f32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_rtn_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_max_rtn_f32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_rtn_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_rtn_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_rtn_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_rtn_f64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_rtn_f64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_max_rtn_f64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_rtn_f64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_max_rtn_f64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_rtn_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_rtn_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_rtn_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_rtn_i32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_rtn_i32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_max_rtn_i32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_rtn_i32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_max_rtn_i32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_rtn_i32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_rtn_i32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_rtn_i32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_rtn_i64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_rtn_i64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_max_rtn_i64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_rtn_i64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_max_rtn_i64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_rtn_i64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_rtn_i64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_rtn_i64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_max_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_max_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_max_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_max_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_src2_f32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_src2_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_src2_f32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_src2_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_src2_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_src2_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_src2_f64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_src2_f64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_src2_f64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_src2_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_src2_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_src2_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_src2_i32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_src2_i32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_src2_i32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_src2_i32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_src2_i32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_src2_i32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_src2_i64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_src2_i64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_src2_i64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_src2_i64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_src2_i64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_src2_i64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_max_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_max_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_max_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_max_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_max_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_max_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_max_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_max_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_f32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_min_f32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_f64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_f64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_f64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_min_f64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_i32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_i32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_i32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_min_i32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_i32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_i32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_i32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_i64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_i64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_i64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_min_i64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_i64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_i64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_i64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_rtn_f32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_rtn_f32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_min_rtn_f32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_rtn_f32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_min_rtn_f32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_rtn_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_rtn_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_rtn_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_rtn_f64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_rtn_f64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_min_rtn_f64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_rtn_f64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_min_rtn_f64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_rtn_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_rtn_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_rtn_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_rtn_i32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_rtn_i32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_min_rtn_i32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_rtn_i32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_min_rtn_i32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_rtn_i32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_rtn_i32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_rtn_i32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_rtn_i64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_rtn_i64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_min_rtn_i64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_rtn_i64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_min_rtn_i64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_rtn_i64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_rtn_i64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_rtn_i64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_min_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_min_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_min_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_min_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_src2_f32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_src2_f32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_src2_f32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_src2_f32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_src2_f32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_src2_f32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_src2_f64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_src2_f64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_src2_f64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_src2_f64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_src2_f64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_src2_f64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_src2_i32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_src2_i32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_src2_i32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_src2_i32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_src2_i32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_src2_i32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_src2_i64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_src2_i64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_src2_i64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_src2_i64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_src2_i64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_src2_i64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_min_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_min_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_min_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_min_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_min_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_min_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_min_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_min_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_mskor_b32(vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_mskor_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_mskor_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_mskor_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_mskor_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_mskor_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_mskor_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_mskor_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_mskor_b64(vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_mskor_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_mskor_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_mskor_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_mskor_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_mskor_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_mskor_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_mskor_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_mskor_rtn_b32(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_mskor_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_mskor_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_mskor_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_mskor_rtn_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_mskor_rtn_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_mskor_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_mskor_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_mskor_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_mskor_rtn_b64(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_mskor_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_mskor_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_mskor_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_mskor_rtn_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_mskor_rtn_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_mskor_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_mskor_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_mskor_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_nop(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_nop
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_lds': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_nop', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_or_b32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_or_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_or_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_or_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_or_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_or_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_or_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_or_b64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_or_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_or_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_or_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_or_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_or_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_or_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_or_rtn_b32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_or_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_or_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_or_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_or_rtn_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_or_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_or_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_or_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_or_rtn_b64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_or_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_or_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_or_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_or_rtn_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_or_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_or_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_or_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_or_src2_b32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_or_src2_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_or_src2_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_or_src2_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_or_src2_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_or_src2_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_or_src2_b64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_or_src2_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_or_src2_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_or_src2_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_or_src2_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_or_src2_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_ordered_count(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_ordered_count
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_ordered_count', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_ordered_count', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_ordered_count', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_ordered_count', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_ordered_count', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_permute_b32(vdst, vaddr, vdata, /, offset=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_permute_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_permute_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_permute_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_permute_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_permute_b32', operands, modifiers, 'offset', offset)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_lds': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_permute_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read2_b32(vdst, vaddr, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read2_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/:b32x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_read2_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read2_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_read2_b32', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_read2_b32', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_read2_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read2_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read2_b64(vdst, vaddr, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read2_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/:b64x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('ds', 'ds_read2_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read2_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_read2_b64', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_read2_b64', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_read2_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read2_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read2st64_b32(vdst, vaddr, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read2st64_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/:b32x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_read2st64_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read2st64_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_read2st64_b32', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_read2st64_b32', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_read2st64_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read2st64_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read2st64_b64(vdst, vaddr, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read2st64_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/:b64x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('ds', 'ds_read2st64_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read2st64_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_read2st64_b64', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_read2st64_b64', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_read2st64_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read2st64_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_addtid_b32(vdst, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_addtid_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_addtid_b32', operands, modifiers, 'vdst', vdst)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_addtid_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_addtid_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_addtid_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_b128(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_b128
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('ds', 'ds_read_b128', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_b128', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_b128', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_b128', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_b128', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_b32(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_b64(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_read_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_b96(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_b96
    Operands:
        dst: vdst/*synid-gfx9-vdst-3*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_3('ds', 'ds_read_b96', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_b96', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_b96', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_b96', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_b96', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_i16(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_i16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_i16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_i16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_i16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_i16', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_i16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_i8(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_i8
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_i8', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_i8', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_i8', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_i8', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_i8', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_i8_d16(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_i8_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_i8_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_i8_d16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_i8_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_i8_d16', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_i8_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_i8_d16_hi(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_i8_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_i8_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_i8_d16_hi', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_i8_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_i8_d16_hi', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_i8_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_u16(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_u16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_u16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_u16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_u16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_u16', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_u16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_u16_d16(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_u16_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_u16_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_u16_d16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_u16_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_u16_d16', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_u16_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_u16_d16_hi(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_u16_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_u16_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_u16_d16_hi', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_u16_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_u16_d16_hi', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_u16_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_u8(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_u8
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_u8', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_u8', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_u8', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_u8', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_u8', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_u8_d16(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_u8_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_u8_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_u8_d16', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_u8_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_u8_d16', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_u8_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_read_u8_d16_hi(vdst, vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_read_u8_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_read_u8_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_read_u8_d16_hi', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_read_u8_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_read_u8_d16_hi', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_read_u8_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_rsub_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_rsub_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_rsub_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_rsub_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_rsub_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_rsub_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_rsub_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_rsub_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_rsub_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_rsub_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_rsub_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_rsub_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_rsub_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_rsub_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_rsub_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_rsub_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_rsub_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_rsub_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_rsub_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_rsub_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_rsub_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_rsub_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_rsub_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_rsub_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_rsub_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_rsub_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_rsub_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_rsub_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_rsub_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_rsub_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_rsub_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_rsub_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_rsub_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_rsub_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_rsub_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_rsub_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_rsub_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_rsub_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_rsub_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_rsub_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_rsub_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_rsub_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_sub_rtn_u32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_sub_rtn_u32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_sub_rtn_u32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_sub_rtn_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_sub_rtn_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_sub_rtn_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_sub_rtn_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_sub_rtn_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_sub_rtn_u64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_sub_rtn_u64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_sub_rtn_u64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_sub_rtn_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_sub_rtn_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_sub_rtn_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_sub_rtn_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_sub_rtn_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_sub_src2_u32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_sub_src2_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_sub_src2_u32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_sub_src2_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_sub_src2_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_sub_src2_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_sub_src2_u64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_sub_src2_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_sub_src2_u64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_sub_src2_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_sub_src2_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_sub_src2_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_sub_u32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_sub_u32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_sub_u32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_sub_u32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_sub_u32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_sub_u32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_sub_u32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_sub_u64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_sub_u64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_sub_u64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_sub_u64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_sub_u64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_sub_u64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_sub_u64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_swizzle_b32(vdst, vaddr, /, pattern=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_swizzle_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        pattern/*synid-sw-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr}
    modifiers = {'pattern': pattern, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_swizzle_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_swizzle_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_sw_offset16('ds', 'ds_swizzle_b32', operands, modifiers, 'pattern', pattern)
    validate_modifier_synid_gds('ds', 'ds_swizzle_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_swizzle_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrap_rtn_b32(vdst, vaddr, vdata0, vdata1, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrap_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_wrap_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrap_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_wrap_rtn_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_wrap_rtn_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_wrap_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_wrap_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrap_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write2_b32(vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write2_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write2_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_write2_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_write2_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_write2_b32', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_write2_b32', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_write2_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write2_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write2_b64(vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write2_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write2_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_write2_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_write2_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_write2_b64', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_write2_b64', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_write2_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write2_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write2st64_b32(vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write2st64_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write2st64_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_write2st64_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_write2st64_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_write2st64_b32', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_write2st64_b32', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_write2st64_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write2st64_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write2st64_b64(vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write2st64_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write2st64_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_write2st64_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_write2st64_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_write2st64_b64', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_write2st64_b64', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_write2st64_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write2st64_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_addtid_b32(vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_addtid_b32
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdata('ds', 'ds_write_addtid_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_addtid_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_addtid_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_addtid_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b128(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b128
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-2*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b128', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_2('ds', 'ds_write_b128', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b128', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b128', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b128', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b16(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b16
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_write_b16', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b16', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b16_d16_hi(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b16_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b16_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_write_b16_d16_hi', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b16_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b16_d16_hi', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b16_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_write_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_write_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b8(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b8
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b8', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_write_b8', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b8', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b8', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b8', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b8_d16_hi(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b8_d16_hi
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b8_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_write_b8_d16_hi', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b8_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b8_d16_hi', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b8_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_b96(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_b96
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-3*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_b96', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_3('ds', 'ds_write_b96', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_b96', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_b96', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_b96', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_src2_b32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_src2_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_src2_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_src2_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_src2_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_src2_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_write_src2_b64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_write_src2_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_write_src2_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_write_src2_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_write_src2_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_write_src2_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrxchg2_rtn_b32(vdst, vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrxchg2_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/:b32x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrxchg2_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrxchg2_rtn_b64(vdst, vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrxchg2_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/:b64x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrxchg2_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrxchg2st64_rtn_b32(vdst, vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrxchg2st64_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/:b32x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0*/
        src2: vdata1/*synid-gfx9-vdata1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrxchg2st64_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrxchg2st64_rtn_b64(vdst, vaddr, vdata0, vdata1, /, offset0=None, offset1=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrxchg2st64_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-2*/:b64x2/*synid-gfx9-type-deviation*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata0/*synid-gfx9-vdata0-1*/
        src2: vdata1/*synid-gfx9-vdata1-1*/
    Modifiers:
        offset0/*synid-ds-offset80*/
        offset1/*synid-ds-offset81*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata0': vdata0, 'vdata1': vdata1}
    modifiers = {'offset0': offset0, 'offset1': offset1, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_2('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata0_1('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'vdata0', vdata0)
    validate_operand_synid_gfx9_vdata1_1('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'vdata1', vdata1)

    # Modifiers validation
    validate_modifier_synid_ds_offset80('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'offset0', offset0)
    validate_modifier_synid_ds_offset81('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'offset1', offset1)
    validate_modifier_synid_gds('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata0, vdata1}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrxchg2st64_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata0, vdata1)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrxchg_rtn_b32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrxchg_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_wrxchg_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrxchg_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_wrxchg_rtn_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_wrxchg_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_wrxchg_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrxchg_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_wrxchg_rtn_b64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_wrxchg_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_wrxchg_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_wrxchg_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_wrxchg_rtn_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_wrxchg_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_wrxchg_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_wrxchg_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_xor_b32(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_xor_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_xor_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_xor_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_xor_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_xor_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_xor_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_xor_b64(vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_xor_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_xor_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_xor_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_xor_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_xor_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_xor_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_xor_rtn_b32(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_xor_rtn_b32
    Operands:
        dst: vdst/*synid-gfx9-vdst*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst('ds', 'ds_xor_rtn_b32', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_xor_rtn_b32', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata('ds', 'ds_xor_rtn_b32', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_xor_rtn_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_xor_rtn_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_xor_rtn_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_xor_rtn_b64(vdst, vaddr, vdata, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_xor_rtn_b64
    Operands:
        dst: vdst/*synid-gfx9-vdst-1*/
        src0: vaddr/*synid-gfx9-vaddr*/
        src1: vdata/*synid-gfx9-vdata-1*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'vdata': vdata}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_1('ds', 'ds_xor_rtn_b64', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr('ds', 'ds_xor_rtn_b64', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_vdata_1('ds', 'ds_xor_rtn_b64', operands, modifiers, 'vdata', vdata)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_xor_rtn_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_xor_rtn_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_xor_rtn_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr, vdata)
    call.add_gpr_defs(vdst)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_xor_src2_b32(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_xor_src2_b32
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_xor_src2_b32', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_xor_src2_b32', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_xor_src2_b32', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_xor_src2_b32', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def ds_xor_src2_b64(vaddr, /, offset=None, gds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: ds_xor_src2_b64
    Operands:
        src0: vaddr/*synid-gfx9-vaddr*/
    Modifiers:
        offset/*synid-ds-offset16*/
        gds/*synid-gds*/
    """
    # Prepare for a new instruction call
    operands = {'vaddr': vaddr}
    modifiers = {'offset': offset, 'gds': gds}

    # Operands validation
    validate_operand_synid_gfx9_vaddr('ds', 'ds_xor_src2_b64', operands, modifiers, 'vaddr', vaddr)

    # Modifiers validation
    validate_modifier_synid_ds_offset16('ds', 'ds_xor_src2_b64', operands, modifiers, 'offset', offset)
    validate_modifier_synid_gds('ds', 'ds_xor_src2_b64', operands, modifiers, 'gds', gds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {}  # type: Dict[str, int]
    if not gds:
        inc_waitcnt['inc_lds'] = 1
    if gds:
        inc_waitcnt['inc_gds'] = 1
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('ds', 'ds_xor_src2_b64', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, vaddr)
    if gds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


