"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from ...basic.exception import check, SeekTODOException

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_ds_offset16(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offset¶

    Specifies a 16-bit offset, in bytes. The default value is 0.

    Used with DS instructions that expect a single address.

    Syntax               | Description
    > ---                |---
    > offset:{0..0xFFFF} | Specifies an unsigned 16-bit offset as a positive integer number or an absolute expression.

    Examples:

        offset:65535
        offset:0xffff
        offset:-x-y
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 65535, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_gds(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### gds¶

    Specifies whether to use GDS or LDS memory (LDS is the default).

    Syntax | Description
    > ---  |---
    > gds  | Use GDS memory.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_ds_offset80(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offset0¶

    Specifies first 8-bit offset, in bytes. The default value is 0.

    Used with DS instructions that expect two addresses.

    Syntax              | Description
    > ---               |---
    > offset0:{0..0xFF} | Specifies an unsigned 8-bit offset as a positive integer number or an absolute expression.

    Examples:

        offset0:0xff
        offset0:2-x
        offset0:-x-y
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 255, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_ds_offset81(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offset1¶

    Specifies second 8-bit offset, in bytes. The default value is 0.

    Used with DS instructions that expect two addresses.

    Syntax              | Description
    > ---               |---
    > offset1:{0..0xFF} | Specifies an unsigned 8-bit offset as a positive integer number or an absolute expression.

    Examples:

        offset1:0xff
        offset1:2-x
        offset1:-x-y
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 255, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_sw_offset16(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### swizzle pattern¶

    This is a special modifier which may be used with ds_swizzle_b32 instruction only. It specifies a swizzle pattern in numeric or symbolic form. The default value is 0.

    See AMD documentation for more information.

    Syntax                                                                                     | Description
    > ---                                                                                      |---
    > offset:{0..0xFFFF}                                                                       | Specifies a 16-bit swizzle pattern.
    > offset:swizzle(QUAD_PERM,{0..3},{0..3},{0..3},{0..3})                                    |
    >
    > Specifies a quad permute mode pattern
    >
    > Each number is a lane id.
    >
    > offset:swizzle(BITMASK_PERM, “<mask>”)                                                   |
    >
    > Specifies a bitmask permute mode pattern.
    >
    > The pattern converts a 5-bit lane id to another lane id with which the lane interacts.
    >
    > mask is a 5 character sequence which specifies how to transform the bits of the lane id.
    >
    > The following characters are allowed:
    >
    >   * “0” - set bit to 0.
    >   * “1” - set bit to 1.
    >   * “p” - preserve bit.
    >   * “i” - inverse bit.
    >

    > offset:swizzle(BROADCAST,{2..32},{0..N})                                                 |
    >
    > Specifies a broadcast mode.
    >
    > Broadcasts the value of any particular lane to all lanes in its group.
    >
    > The first numeric parameter is a group size and must be equal to 2, 4, 8, 16 or 32.
    >
    > The second numeric parameter is an index of the lane being broadcasted.
    >
    > The index must not exceed group size.
    >
    > offset:swizzle(SWAP,{1..16})                                                             |
    >
    > Specifies a swap mode.
    >
    > Swaps the neighboring groups of 1, 2, 4, 8 or 16 lanes.
    >
    > offset:swizzle(REVERSE,{2..32})                                                          |
    >
    > Specifies a reverse mode.
    >
    > Reverses the lanes for groups of 2, 4, 8, 16 or 32 lanes.
    >

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        offset:255
        offset:0xffff
        offset:swizzle(QUAD_PERM, 0, 1, 2, 3)
        offset:swizzle(BITMASK_PERM, "01pi0")
        offset:swizzle(BROADCAST, 2, 0)
        offset:swizzle(SWAP, 8)
        offset:swizzle(REVERSE, 30 + 2)
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_done(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### done¶

    Specifies if this is the last export from the shader to the target. By default, exp instruction does not finish an export sequence.

    Syntax | Description
    > ---  |---
    > done | Indicates the last export operation.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_compr(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### compr¶

    Indicates if the data are compressed (data are not compressed by default).

    Syntax  | Description
    > ---   |---
    > compr | Data are compressed.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_vm(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### vm¶

    Specifies valid mask flag state (off by default).

    Syntax | Description
    > ---  |---
    > vm   | Set valid mask flag.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_flat_offset12(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offset12¶

    Specifies an immediate unsigned 12-bit offset, in bytes. The default value is 0.

    Cannot be used with global/scratch opcodes. GFX9 only.

    Syntax             | Description
    > ---              |---
    > offset:{0..4095} | Specifies a 12-bit unsigned offset as a positive integer number or an absolute expression.

    Examples:

        offset:4095
        offset:x-0xff
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 4095, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_glc(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### glc¶

    This modifier has different meaning for loads, stores, and atomic operations. The default value is off (0).

    See AMD documentation for details.

    Syntax | Description
    > ---  |---
    > glc  | Set glc bit to 1.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_slc(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### slc¶

    Specifies cache policy. The default value is off (0).

    See AMD documentation for details.

    Syntax | Description
    > ---  |---
    > slc  | Set slc bit to 1.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_flat_offset13s(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offset13s¶

    Specifies an immediate signed 13-bit offset, in bytes. The default value is 0.

    Can be used with global/scratch opcodes only. GFX9 only.

    Syntax                 | Description
    > ---                  |---
    > offset:{-4096..4095} | Specifies a 13-bit signed offset as an integer number or an absolute expression.

    Examples:

        offset:-4000
        offset:0x10
        offset:-x
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(-4096 <= modifier_value <= 4095, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_dmask(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### dmask¶

    Specifies which channels (image components) are used by the operation. By default, no channels are used.

    Syntax                                                                                                  | Description
    > ---                                                                                                   |---
    > dmask:{0..15}                                                                                         |
    >
    > Specifies image channels as a positive integer number or an absolute expression.
    >
    > Each bit corresponds to one of 4 image components (RGBA).
    >
    > If the specified bit value is 0, the component is not used, value 1 means that the component is used.
    >

    This modifier has some limitations depending on instruction kind:

    Instruction Kind                                | Valid dmask Values
    > ---                                           |---
    > 32-bit atomic cmpswap                         | 0x3
    > 32-bit atomic instructions except for cmpswap | 0x1
    > 64-bit atomic cmpswap                         | 0xF
    > 64-bit atomic instructions except for cmpswap | 0x3
    > gather4                                       | 0x1, 0x2, 0x4, 0x8
    > Other instructions                            | any value

    Examples:

        dmask:0xf
        dmask:0b1111
        dmask:x|y|z
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 15, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_unorm(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### unorm¶

    Specifies whether the address is normalized or not (the address is normalized by default).

    Syntax  | Description
    > ---   |---
    > unorm | Force the address to be unnormalized.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_a16(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### a16¶

    Specifies size of image address components: 16 or 32 bits (32 bits by default). GFX9 and GFX10 only.

    Syntax | Description
    > ---  |---
    > a16  | Enables 16-bits image address components.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_lwe(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### lwe¶

    Specifies LOD warning status (LOD warning is disabled by default).

    Syntax | Description
    > ---  |---
    > lwe  | Enables LOD warning.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_da(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### da¶

    Specifies if an array index must be sent to TA. By default, array index is not sent.

    Syntax | Description
    > ---  |---
    > da   | Send an array-index to TA.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_d16(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### d16¶

    Specifies data size: 16 or 32 bits (32 bits by default). Not supported by GFX7.

    Syntax                                                                                            | Description
    > ---                                                                                             |---
    > d16                                                                                             |
    >
    > Enables 16-bits data mode.
    >
    > On loads, convert data in memory to 16-bit format before storing it in VGPRs.
    >
    > For stores, convert 16-bit data in VGPRs to 32 bits before going to memory.
    >
    > Note that GFX8.0 does not support data packing. Each 16-bit data element occupies 1 VGPR.
    >
    > GFX8.1, GFX9 and GFX10 support data packing. Each pair of 16-bit data elements occupies 1 VGPR.
    >
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_tfe(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### tfe¶

    Controls access to partially resident textures. The default value is off (0).

    See AMD documentation for details.

    Syntax | Description
    > ---  |---
    > tfe  | Set tfe bit to 1.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_fmt(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### fmt¶

    Specifies data and numeric formats used by the operation. The default numeric format is BUF_NUM_FORMAT_UNORM. The default data format is BUF_DATA_FORMAT_8.

    Syntax                                     | Description
    > ---                                      |---
    > format:{0..127}                          | Use format specified as either an integer number or an absolute expression.
    > format:[<data format>]                   | Use the specified data format and default numeric format.
    > format:[<numeric format>]                | Use the specified numeric format and default data format.
    > format:[<data format>, <numeric format>] | Use the specified data and numeric formats.
    > format:[<numeric format>, <data format>] | Use the specified data and numeric formats.

    Supported data formats are defined in the following table:

    Syntax                        | Note
    > ---                         |---
    > BUF_DATA_FORMAT_INVALID     |
    > BUF_DATA_FORMAT_8           | Default value.
    > BUF_DATA_FORMAT_16          |
    > BUF_DATA_FORMAT_8_8         |
    > BUF_DATA_FORMAT_32          |
    > BUF_DATA_FORMAT_16_16       |
    > BUF_DATA_FORMAT_10_11_11    |
    > BUF_DATA_FORMAT_11_11_10    |
    > BUF_DATA_FORMAT_10_10_10_2  |
    > BUF_DATA_FORMAT_2_10_10_10  |
    > BUF_DATA_FORMAT_8_8_8_8     |
    > BUF_DATA_FORMAT_32_32       |
    > BUF_DATA_FORMAT_16_16_16_16 |
    > BUF_DATA_FORMAT_32_32_32    |
    > BUF_DATA_FORMAT_32_32_32_32 |
    > BUF_DATA_FORMAT_RESERVED_15 |

    Supported numeric formats are defined below:

    Syntax                      | Note
    > ---                       |---
    > BUF_NUM_FORMAT_UNORM      | Default value.
    > BUF_NUM_FORMAT_SNORM      |
    > BUF_NUM_FORMAT_USCALED    |
    > BUF_NUM_FORMAT_SSCALED    |
    > BUF_NUM_FORMAT_UINT       |
    > BUF_NUM_FORMAT_SINT       |
    > BUF_NUM_FORMAT_SNORM_OGL  | GFX7 only.
    > BUF_NUM_FORMAT_RESERVED_6 | GFX8 and GFX9 only.
    > BUF_NUM_FORMAT_FLOAT      |

    Examples:

        format:0
        format:127
        format:[BUF_DATA_FORMAT_16]
        format:[BUF_DATA_FORMAT_16,BUF_NUM_FORMAT_SSCALED]
        format:[BUF_NUM_FORMAT_FLOAT]
    """
    raise SeekTODOException()

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_idxen(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### idxen¶

    Specifies whether address components include an index. By default, no components are used.

    Can be used together with offen.

    Cannot be used with addr64.

    Syntax  | Description
    > ---   |---
    > idxen | Address components include an index.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_offen(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offen¶

    Specifies whether address components include an offset. By default, no components are used.

    Can be used together with idxen.

    Cannot be used with addr64.

    Syntax  | Description
    > ---   |---
    > offen | Address components include an offset.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_buf_offset12(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### offset12¶

    Specifies an immediate unsigned 12-bit offset, in bytes. The default value is 0.

    Syntax              | Description
    > ---               |---
    > offset:{0..0xFFF} | Specifies a 12-bit unsigned offset as a positive integer number or an absolute expression.

    Examples:

        offset:x+y
        offset:0x10
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 4095, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_lds(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### lds¶

    Specifies where to store the result: VGPRs or LDS (VGPRs by default).

    Syntax | Description
    > ---  |---
    > lds  | Store result in LDS.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_dpp_ctrl(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### dpp_ctrl¶

    Specifies how data are shared between threads. This is a mandatory modifier. There is no default value.

    GFX8 and GFX9 only. Use dpp16_ctrl for GFX10.

    Note: the lanes of a wavefront are organized in four rows and four banks.

    Syntax                                    | Description
    > ---                                     |---
    > quad_perm:[{0..3},{0..3},{0..3},{0..3}] | Full permute of 4 threads.
    > row_mirror                              | Mirror threads within row.
    > row_half_mirror                         | Mirror threads within 1/2 row (8 threads).
    > row_bcast:15                            | Broadcast 15th thread of each row to next row.
    > row_bcast:31                            | Broadcast thread 31 to rows 2 and 3.
    > wave_shl:1                              | Wavefront left shift by 1 thread.
    > wave_rol:1                              | Wavefront left rotate by 1 thread.
    > wave_shr:1                              | Wavefront right shift by 1 thread.
    > wave_ror:1                              | Wavefront right rotate by 1 thread.
    > row_shl:{1..15}                         | Row shift left by 1-15 threads.
    > row_shr:{1..15}                         | Row shift right by 1-15 threads.
    > row_ror:{1..15}                         | Row rotate right by 1-15 threads.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        quad_perm:[0, 1, 2, 3]
        row_shl:3
    """
    check(modifier_value is not None, modifier_value)
    check(modifier_value in {'quad_perm:[0,0,0,0]', 'quad_perm:[0,0,0,1]', 'quad_perm:[0,0,0,2]', 'quad_perm:[0,0,0,3]', 'quad_perm:[0,0,1,0]', 'quad_perm:[0,0,1,1]', 'quad_perm:[0,0,1,2]', 'quad_perm:[0,0,1,3]', 'quad_perm:[0,0,2,0]', 'quad_perm:[0,0,2,1]', 'quad_perm:[0,0,2,2]', 'quad_perm:[0,0,2,3]', 'quad_perm:[0,0,3,0]', 'quad_perm:[0,0,3,1]', 'quad_perm:[0,0,3,2]', 'quad_perm:[0,0,3,3]', 'quad_perm:[0,1,0,0]', 'quad_perm:[0,1,0,1]', 'quad_perm:[0,1,0,2]', 'quad_perm:[0,1,0,3]', 'quad_perm:[0,1,1,0]', 'quad_perm:[0,1,1,1]', 'quad_perm:[0,1,1,2]', 'quad_perm:[0,1,1,3]', 'quad_perm:[0,1,2,0]', 'quad_perm:[0,1,2,1]', 'quad_perm:[0,1,2,2]', 'quad_perm:[0,1,2,3]', 'quad_perm:[0,1,3,0]', 'quad_perm:[0,1,3,1]', 'quad_perm:[0,1,3,2]', 'quad_perm:[0,1,3,3]', 'quad_perm:[0,2,0,0]', 'quad_perm:[0,2,0,1]', 'quad_perm:[0,2,0,2]', 'quad_perm:[0,2,0,3]', 'quad_perm:[0,2,1,0]', 'quad_perm:[0,2,1,1]', 'quad_perm:[0,2,1,2]', 'quad_perm:[0,2,1,3]', 'quad_perm:[0,2,2,0]', 'quad_perm:[0,2,2,1]', 'quad_perm:[0,2,2,2]', 'quad_perm:[0,2,2,3]', 'quad_perm:[0,2,3,0]', 'quad_perm:[0,2,3,1]', 'quad_perm:[0,2,3,2]', 'quad_perm:[0,2,3,3]', 'quad_perm:[0,3,0,0]', 'quad_perm:[0,3,0,1]', 'quad_perm:[0,3,0,2]', 'quad_perm:[0,3,0,3]', 'quad_perm:[0,3,1,0]', 'quad_perm:[0,3,1,1]', 'quad_perm:[0,3,1,2]', 'quad_perm:[0,3,1,3]', 'quad_perm:[0,3,2,0]', 'quad_perm:[0,3,2,1]', 'quad_perm:[0,3,2,2]', 'quad_perm:[0,3,2,3]', 'quad_perm:[0,3,3,0]', 'quad_perm:[0,3,3,1]', 'quad_perm:[0,3,3,2]', 'quad_perm:[0,3,3,3]', 'quad_perm:[1,0,0,0]', 'quad_perm:[1,0,0,1]', 'quad_perm:[1,0,0,2]', 'quad_perm:[1,0,0,3]', 'quad_perm:[1,0,1,0]', 'quad_perm:[1,0,1,1]', 'quad_perm:[1,0,1,2]', 'quad_perm:[1,0,1,3]', 'quad_perm:[1,0,2,0]', 'quad_perm:[1,0,2,1]', 'quad_perm:[1,0,2,2]', 'quad_perm:[1,0,2,3]', 'quad_perm:[1,0,3,0]', 'quad_perm:[1,0,3,1]', 'quad_perm:[1,0,3,2]', 'quad_perm:[1,0,3,3]', 'quad_perm:[1,1,0,0]', 'quad_perm:[1,1,0,1]', 'quad_perm:[1,1,0,2]', 'quad_perm:[1,1,0,3]', 'quad_perm:[1,1,1,0]', 'quad_perm:[1,1,1,1]', 'quad_perm:[1,1,1,2]', 'quad_perm:[1,1,1,3]', 'quad_perm:[1,1,2,0]', 'quad_perm:[1,1,2,1]', 'quad_perm:[1,1,2,2]', 'quad_perm:[1,1,2,3]', 'quad_perm:[1,1,3,0]', 'quad_perm:[1,1,3,1]', 'quad_perm:[1,1,3,2]', 'quad_perm:[1,1,3,3]', 'quad_perm:[1,2,0,0]', 'quad_perm:[1,2,0,1]', 'quad_perm:[1,2,0,2]', 'quad_perm:[1,2,0,3]', 'quad_perm:[1,2,1,0]', 'quad_perm:[1,2,1,1]', 'quad_perm:[1,2,1,2]', 'quad_perm:[1,2,1,3]', 'quad_perm:[1,2,2,0]', 'quad_perm:[1,2,2,1]', 'quad_perm:[1,2,2,2]', 'quad_perm:[1,2,2,3]', 'quad_perm:[1,2,3,0]', 'quad_perm:[1,2,3,1]', 'quad_perm:[1,2,3,2]', 'quad_perm:[1,2,3,3]', 'quad_perm:[1,3,0,0]', 'quad_perm:[1,3,0,1]', 'quad_perm:[1,3,0,2]', 'quad_perm:[1,3,0,3]', 'quad_perm:[1,3,1,0]', 'quad_perm:[1,3,1,1]', 'quad_perm:[1,3,1,2]', 'quad_perm:[1,3,1,3]', 'quad_perm:[1,3,2,0]', 'quad_perm:[1,3,2,1]', 'quad_perm:[1,3,2,2]', 'quad_perm:[1,3,2,3]', 'quad_perm:[1,3,3,0]', 'quad_perm:[1,3,3,1]', 'quad_perm:[1,3,3,2]', 'quad_perm:[1,3,3,3]', 'quad_perm:[2,0,0,0]', 'quad_perm:[2,0,0,1]', 'quad_perm:[2,0,0,2]', 'quad_perm:[2,0,0,3]', 'quad_perm:[2,0,1,0]', 'quad_perm:[2,0,1,1]', 'quad_perm:[2,0,1,2]', 'quad_perm:[2,0,1,3]', 'quad_perm:[2,0,2,0]', 'quad_perm:[2,0,2,1]', 'quad_perm:[2,0,2,2]', 'quad_perm:[2,0,2,3]', 'quad_perm:[2,0,3,0]', 'quad_perm:[2,0,3,1]', 'quad_perm:[2,0,3,2]', 'quad_perm:[2,0,3,3]', 'quad_perm:[2,1,0,0]', 'quad_perm:[2,1,0,1]', 'quad_perm:[2,1,0,2]', 'quad_perm:[2,1,0,3]', 'quad_perm:[2,1,1,0]', 'quad_perm:[2,1,1,1]', 'quad_perm:[2,1,1,2]', 'quad_perm:[2,1,1,3]', 'quad_perm:[2,1,2,0]', 'quad_perm:[2,1,2,1]', 'quad_perm:[2,1,2,2]', 'quad_perm:[2,1,2,3]', 'quad_perm:[2,1,3,0]', 'quad_perm:[2,1,3,1]', 'quad_perm:[2,1,3,2]', 'quad_perm:[2,1,3,3]', 'quad_perm:[2,2,0,0]', 'quad_perm:[2,2,0,1]', 'quad_perm:[2,2,0,2]', 'quad_perm:[2,2,0,3]', 'quad_perm:[2,2,1,0]', 'quad_perm:[2,2,1,1]', 'quad_perm:[2,2,1,2]', 'quad_perm:[2,2,1,3]', 'quad_perm:[2,2,2,0]', 'quad_perm:[2,2,2,1]', 'quad_perm:[2,2,2,2]', 'quad_perm:[2,2,2,3]', 'quad_perm:[2,2,3,0]', 'quad_perm:[2,2,3,1]', 'quad_perm:[2,2,3,2]', 'quad_perm:[2,2,3,3]', 'quad_perm:[2,3,0,0]', 'quad_perm:[2,3,0,1]', 'quad_perm:[2,3,0,2]', 'quad_perm:[2,3,0,3]', 'quad_perm:[2,3,1,0]', 'quad_perm:[2,3,1,1]', 'quad_perm:[2,3,1,2]', 'quad_perm:[2,3,1,3]', 'quad_perm:[2,3,2,0]', 'quad_perm:[2,3,2,1]', 'quad_perm:[2,3,2,2]', 'quad_perm:[2,3,2,3]', 'quad_perm:[2,3,3,0]', 'quad_perm:[2,3,3,1]', 'quad_perm:[2,3,3,2]', 'quad_perm:[2,3,3,3]', 'quad_perm:[3,0,0,0]', 'quad_perm:[3,0,0,1]', 'quad_perm:[3,0,0,2]', 'quad_perm:[3,0,0,3]', 'quad_perm:[3,0,1,0]', 'quad_perm:[3,0,1,1]', 'quad_perm:[3,0,1,2]', 'quad_perm:[3,0,1,3]', 'quad_perm:[3,0,2,0]', 'quad_perm:[3,0,2,1]', 'quad_perm:[3,0,2,2]', 'quad_perm:[3,0,2,3]', 'quad_perm:[3,0,3,0]', 'quad_perm:[3,0,3,1]', 'quad_perm:[3,0,3,2]', 'quad_perm:[3,0,3,3]', 'quad_perm:[3,1,0,0]', 'quad_perm:[3,1,0,1]', 'quad_perm:[3,1,0,2]', 'quad_perm:[3,1,0,3]', 'quad_perm:[3,1,1,0]', 'quad_perm:[3,1,1,1]', 'quad_perm:[3,1,1,2]', 'quad_perm:[3,1,1,3]', 'quad_perm:[3,1,2,0]', 'quad_perm:[3,1,2,1]', 'quad_perm:[3,1,2,2]', 'quad_perm:[3,1,2,3]', 'quad_perm:[3,1,3,0]', 'quad_perm:[3,1,3,1]', 'quad_perm:[3,1,3,2]', 'quad_perm:[3,1,3,3]', 'quad_perm:[3,2,0,0]', 'quad_perm:[3,2,0,1]', 'quad_perm:[3,2,0,2]', 'quad_perm:[3,2,0,3]', 'quad_perm:[3,2,1,0]', 'quad_perm:[3,2,1,1]', 'quad_perm:[3,2,1,2]', 'quad_perm:[3,2,1,3]', 'quad_perm:[3,2,2,0]', 'quad_perm:[3,2,2,1]', 'quad_perm:[3,2,2,2]', 'quad_perm:[3,2,2,3]', 'quad_perm:[3,2,3,0]', 'quad_perm:[3,2,3,1]', 'quad_perm:[3,2,3,2]', 'quad_perm:[3,2,3,3]', 'quad_perm:[3,3,0,0]', 'quad_perm:[3,3,0,1]', 'quad_perm:[3,3,0,2]', 'quad_perm:[3,3,0,3]', 'quad_perm:[3,3,1,0]', 'quad_perm:[3,3,1,1]', 'quad_perm:[3,3,1,2]', 'quad_perm:[3,3,1,3]', 'quad_perm:[3,3,2,0]', 'quad_perm:[3,3,2,1]', 'quad_perm:[3,3,2,2]', 'quad_perm:[3,3,2,3]', 'quad_perm:[3,3,3,0]', 'quad_perm:[3,3,3,1]', 'quad_perm:[3,3,3,2]', 'quad_perm:[3,3,3,3]', 'row_mirror', 'row_half_mirror', 'row_bcast:15', 'row_bcast:31', 'wave_shl:1', 'wave_rol:1', 'wave_shr:1', 'wave_ror:1', 'row_shl:1', 'row_shr:1', 'row_ror:1', 'row_shl:2', 'row_shr:2', 'row_ror:2', 'row_shl:3', 'row_shr:3', 'row_ror:3', 'row_shl:4', 'row_shr:4', 'row_ror:4', 'row_shl:5', 'row_shr:5', 'row_ror:5', 'row_shl:6', 'row_shr:6', 'row_ror:6', 'row_shl:7', 'row_shr:7', 'row_ror:7', 'row_shl:8', 'row_shr:8', 'row_ror:8', 'row_shl:9', 'row_shr:9', 'row_ror:9', 'row_shl:10', 'row_shr:10', 'row_ror:10', 'row_shl:11', 'row_shr:11', 'row_ror:11', 'row_shl:12', 'row_shr:12', 'row_ror:12', 'row_shl:13', 'row_shr:13', 'row_ror:13', 'row_shl:14', 'row_shr:14', 'row_ror:14', 'row_shl:15', 'row_shr:15', 'row_ror:15'}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_row_mask(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### row_mask¶

    Controls which rows are enabled for data sharing. By default, all rows are enabled.

    Note: the lanes of a wavefront are organized in four rows and four banks. (There are only two rows in wave32 mode.)

    Syntax                                                                         | Description
    > ---                                                                          |---
    > row_mask:{0..15}                                                             |
    >
    > Specifies a row mask as a positive integer number or an absolute expression.
    >
    > Each of 4 bits in the mask controls one row (0 - disabled, 1 - enabled).
    >
    > In wave32 mode the values should be limited to 0..7.
    >

    Examples:

        row_mask:0xf
        row_mask:0b1010
        row_mask:x|y
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 15, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_bank_mask(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### bank_mask¶

    Controls which banks are enabled for data sharing. By default, all banks are enabled.

    Note: the lanes of a wavefront are organized in four rows and four banks. (There are only two rows in wave32 mode.)

    Syntax                                                                          | Description
    > ---                                                                           |---
    > bank_mask:{0..15}                                                             |
    >
    > Specifies a bank mask as a positive integer number or an absolute expression.
    >
    > Each of 4 bits in the mask controls one bank (0 - disabled, 1 - enabled).
    >

    Examples:

        bank_mask:0x3
        bank_mask:0b0011
        bank_mask:x&y
    """
    if modifier_value is None:
        return
    check(isinstance(modifier_value, int), modifier_value)
    check(0 <= modifier_value <= 15, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_bound_ctrl(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### bound_ctrl¶

    Controls data sharing when accessing an invalid lane. By default, data sharing with invalid lanes is disabled.

    Syntax                                                  | Description
    > ---                                                   |---
    > bound_ctrl:1                                          |
    >
    > Enables data sharing with invalid lanes.
    >
    > Accessing data from an invalid lane will return zero.
    >
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_dst_sel(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### dst_sel¶

    Selects which bits in the destination are affected. By default, all bits are affected.

    Syntax           | Description
    > ---            |---
    > dst_sel:DWORD  | Use bits 31:0.
    > dst_sel:BYTE_0 | Use bits 7:0.
    > dst_sel:BYTE_1 | Use bits 15:8.
    > dst_sel:BYTE_2 | Use bits 23:16.
    > dst_sel:BYTE_3 | Use bits 31:24.
    > dst_sel:WORD_0 | Use bits 15:0.
    > dst_sel:WORD_1 | Use bits 31:16.
    """
    if modifier_value is None:
        return
    check(modifier_value in {'DWORD', 'BYTE_0', 'BYTE_1', 'BYTE_2', 'BYTE_3', 'WORD_0', 'WORD_1'}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_dst_unused(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### dst_unused¶

    Controls what to do with the bits in the destination which are not selected by dst_sel. By default, unused bits are preserved.

    Syntax                       | Description
    > ---                        |---
    > dst_unused:UNUSED_PAD      | Pad with zeros.
    > dst_unused:UNUSED_SEXT     | Sign-extend upper bits, zero lower bits.
    > dst_unused:UNUSED_PRESERVE | Preserve bits.
    """
    if modifier_value is None:
        return
    check(modifier_value in {'UNUSED_PAD', 'UNUSED_SEXT', 'UNUSED_PRESERVE'}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_src0_sel(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### src0_sel¶

    Controls which bits in the src0 are used. By default, all bits are used.

    Syntax            | Description
    > ---             |---
    > src0_sel:DWORD  | Use bits 31:0.
    > src0_sel:BYTE_0 | Use bits 7:0.
    > src0_sel:BYTE_1 | Use bits 15:8.
    > src0_sel:BYTE_2 | Use bits 23:16.
    > src0_sel:BYTE_3 | Use bits 31:24.
    > src0_sel:WORD_0 | Use bits 15:0.
    > src0_sel:WORD_1 | Use bits 31:16.
    """
    if modifier_value is None:
        return
    check(modifier_value in {'DWORD', 'BYTE_0', 'BYTE_1', 'BYTE_2', 'BYTE_3', 'WORD_0', 'WORD_1'}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_clamp(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### clamp¶

    Clamp meaning depends on instruction.

    For v_cmp instructions, clamp modifier indicates that the compare signals if a floating point exception occurs. By default, signaling is disabled. Not supported by GFX7.

    For integer operations, clamp modifier indicates that the result must be clamped to the largest and smallest representable value. By default, there is no clamping. Integer clamping is not supported by GFX7.

    For floating point operations, clamp modifier indicates that the result must be clamped to the range [0.0, 1.0]. By default, there is no clamping.

    Note: clamp modifier is applied after output modifiers (if any).

    Syntax  | Description
    > ---   |---
    > clamp | Enables clamping (or signaling).
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_omod(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### omod¶

    Specifies if an output modifier must be applied to the result. By default, no output modifiers are applied.

    Note: output modifiers are applied before clamping (if any).

    Output modifiers are valid for f32 and f64 floating point results only. They must not be used with f16.

    Note: v_cvt_f16_f32 is an exception. This instruction produces f16 result but accepts output modifiers.

    Syntax  | Description
    > ---   |---
    > mul:2 | Multiply the result by 2.
    > mul:4 | Multiply the result by 4.
    > div:2 | Multiply the result by 0.5.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        mul:2
        mul:x      // x must be equal to 2 or 4
    """
    if modifier_value is None:
        return
    check(modifier_value in {'mul:2', 'mul:4', 'div:2'}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_src1_sel(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### src1_sel¶

    Controls which bits in the src1 are used. By default, all bits are used.

    Syntax            | Description
    > ---             |---
    > src1_sel:DWORD  | Use bits 31:0.
    > src1_sel:BYTE_0 | Use bits 7:0.
    > src1_sel:BYTE_1 | Use bits 15:8.
    > src1_sel:BYTE_2 | Use bits 23:16.
    > src1_sel:BYTE_3 | Use bits 31:24.
    > src1_sel:WORD_0 | Use bits 15:0.
    > src1_sel:WORD_1 | Use bits 31:16.
    """
    if modifier_value is None:
        return
    check(modifier_value in {'DWORD', 'BYTE_0', 'BYTE_1', 'BYTE_2', 'BYTE_3', 'WORD_0', 'WORD_1'}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_vop3_op_sel(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### op_sel¶

    Selects the low [15:0] or high [31:16] operand bits for source and destination operands. By default, low bits are used for all operands.

    The number of values specified with the op_sel modifier must match the number of instruction operands (both source and destination). First value controls src0, second value controls src1 and so on, except that the last value controls destination. The value 0 selects the low bits, while 1 selects the high bits.

    Note: op_sel modifier affects 16-bit operands only. For 32-bit operands the value specified by op_sel must be 0.

    GFX9 and GFX10 only.

    Syntax                                 | Description
    > ---                                  |---
    > op_sel:[{0..1},{0..1}]               | Select operand bits for instructions with 1 source operand.
    > op_sel:[{0..1},{0..1},{0..1}]        | Select operand bits for instructions with 2 source operands.
    > op_sel:[{0..1},{0..1},{0..1},{0..1}] | Select operand bits for instructions with 3 source operands.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        op_sel:[0,0]
        op_sel:[0,1]
    """
    if modifier_value is not None:
        num_src_and_dst_operands = len(operands)  # counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_and_dst_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_high(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### high¶

    Specifies which half of the LDS word to use. Low half of LDS word is used by default. GFX9 and GFX10 only.

    Syntax | Description
    > ---  |---
    > high | Use high half of LDS word.
    """
    if modifier_value is not None:
        check(modifier_value in {True, False}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_op_sel(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### op_sel¶

    Selects the low [15:0] or high [31:16] operand bits as input to the operation which results in the lower-half of the destination. By default, low bits are used for all operands.

    The number of values specified by the op_sel modifier must match the number of source operands. First value controls src0, second value controls src1 and so on.

    The value 0 selects the low bits, while 1 selects the high bits.

    Syntax                          | Description
    > ---                           |---
    > op_sel:[{0..1}]               | Select operand bits for instructions with 1 source operand.
    > op_sel:[{0..1},{0..1}]        | Select operand bits for instructions with 2 source operands.
    > op_sel:[{0..1},{0..1},{0..1}] | Select operand bits for instructions with 3 source operands.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        op_sel:[0,0]
        op_sel:[0,1,0]
    """
    if modifier_value is not None:
        num_src_operands = len(operands) - 1  # not counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_op_sel_hi(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### op_sel_hi¶

    Selects the low [15:0] or high [31:16] operand bits as input to the operation which results in the upper-half of the destination. By default, high bits are used for all operands.

    The number of values specified by the op_sel_hi modifier must match the number of source operands. First value controls src0, second value controls src1 and so on.

    The value 0 selects the low bits, while 1 selects the high bits.

    Syntax                             | Description
    > ---                              |---
    > op_sel_hi:[{0..1}]               | Select operand bits for instructions with 1 source operand.
    > op_sel_hi:[{0..1},{0..1}]        | Select operand bits for instructions with 2 source operands.
    > op_sel_hi:[{0..1},{0..1},{0..1}] | Select operand bits for instructions with 3 source operands.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        op_sel_hi:[0,0]
        op_sel_hi:[0,0,1]
    """
    if modifier_value is not None:
        num_src_operands = len(operands) - 1  # not counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_neg_lo(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### neg_lo¶

    Specifies whether to change sign of operand values selected by op_sel. These values are then used as input to the operation which results in the upper-half of the destination.

    The number of values specified by this modifier must match the number of source operands. First value controls src0, second value controls src1 and so on.

    The value 0 indicates that the corresponding operand value is used unmodified, the value 1 indicates that negative value of the operand must be used.

    By default, operand values are used unmodified.

    This modifier is valid for floating point operands only.

    Syntax                          | Description
    > ---                           |---
    > neg_lo:[{0..1}]               | Select affected operands for instructions with 1 source operand.
    > neg_lo:[{0..1},{0..1}]        | Select affected operands for instructions with 2 source operands.
    > neg_lo:[{0..1},{0..1},{0..1}] | Select affected operands for instructions with 3 source operands.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        neg_lo:[0]
        neg_lo:[0,1]
    """
    if modifier_value is not None:
        num_src_operands = len(operands) - 1  # not counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_neg_hi(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### neg_hi¶

    Specifies whether to change sign of operand values selected by op_sel_hi. These values are then used as input to the operation which results in the upper-half of the destination.

    The number of values specified by this modifier must match the number of source operands. First value controls src0, second value controls src1 and so on.

    The value 0 indicates that the corresponding operand value is used unmodified, the value 1 indicates that negative value of the operand must be used.

    By default, operand values are used unmodified.

    This modifier is valid for floating point operands only.

    Syntax                          | Description
    > ---                           |---
    > neg_hi:[{0..1}]               | Select affected operands for instructions with 1 source operand.
    > neg_hi:[{0..1},{0..1}]        | Select affected operands for instructions with 2 source operands.
    > neg_hi:[{0..1},{0..1},{0..1}] | Select affected operands for instructions with 3 source operands.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        neg_hi:[1,0]
        neg_hi:[0,1,1]
    """
    if modifier_value is not None:
        num_src_operands = len(operands) - 1  # not counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_mad_mix_op_sel(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### m_op_sel¶

    This operand has meaning only for 16-bit source operands as indicated by m_op_sel_hi. It specifies to select either the low [15:0] or high [31:16] operand bits as input to the operation.

    The number of values specified by the op_sel modifier must match the number of source operands. First value controls src0, second value controls src1 and so on.

    The value 0 indicates the low bits, the value 1 indicates the high 16 bits.

    By default, low bits are used for all operands.

    Syntax                          | Description
    > ---                           |---
    > op_sel:[{0..1},{0..1},{0..1}] | Select location of each 16-bit source operand.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        op_sel:[0,1]
    """
    if modifier_value is not None:
        num_src_operands = len(operands) - 1  # not counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

# noinspection DuplicatedCode,PyUnusedLocal
def validate_modifier_synid_mad_mix_op_sel_hi(category, instr_name, operands, modifiers, modifier_text, modifier_value):
    """
    #### m_op_sel_hi¶

    Selects the size of source operands: either 32 bits or 16 bits. By default, 32 bits are used for all source operands.

    The number of values specified by the op_sel_hi modifier must match the number of source operands. First value controls src0, second value controls src1 and so on.

    The value 0 indicates 32 bits, the value 1 indicates 16 bits.

    The location of 16 bits in the operand may be specified by m_op_sel.

    Syntax                             | Description
    > ---                              |---
    > op_sel_hi:[{0..1},{0..1},{0..1}] | Select size of each source operand.

    Note: numeric values may be specified as either integer numbers or absolute expressions.

    Examples:

        op_sel_hi:[1,1,1]
    """
    if modifier_value is not None:
        num_src_operands = len(operands) - 1  # not counting `vdst`
        check(isinstance(modifier_value, list), modifier_value)
        check(len(modifier_value) == num_src_operands, modifier_value)
        for x in modifier_value:
            check(x in {0, 1}, modifier_value)

