"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from typing import Optional, Hashable, Dict, Set
# noinspection PyUnresolvedReferences
from .autogen_validate_operands import *
# noinspection PyUnresolvedReferences
from .autogen_validate_modifiers import *
# noinspection PyUnresolvedReferences
from ...basic.instr import InstrCall, MemToken, SrcLoc


# noinspection DuplicatedCode,PyDictCreation
def s_atc_probe(probe, sbase, soffset, /, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atc_probe
    Operands:
        src0: probe/*synid-gfx9-probe*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {'probe': probe, 'sbase': sbase, 'soffset': soffset}
    modifiers = {}

    # Operands validation
    validate_operand_synid_gfx9_probe('smem', 's_atc_probe', operands, modifiers, 'probe', probe)
    validate_operand_synid_gfx9_sbase('smem', 's_atc_probe', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atc_probe', operands, modifiers, 'soffset', soffset)

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    mem_token = None  # this instruction does not access memory

    # Generate the instruction call
    call = InstrCall('smem', 's_atc_probe', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(probe, sbase, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atc_probe_buffer(probe, sbase, soffset, /, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atc_probe_buffer
    Operands:
        src0: probe/*synid-gfx9-probe*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {'probe': probe, 'sbase': sbase, 'soffset': soffset}
    modifiers = {}

    # Operands validation
    validate_operand_synid_gfx9_probe('smem', 's_atc_probe_buffer', operands, modifiers, 'probe', probe)
    validate_operand_synid_gfx9_sbase_1('smem', 's_atc_probe_buffer', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_atc_probe_buffer', operands, modifiers, 'soffset', soffset)

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    mem_token = None  # this instruction does not access memory

    # Generate the instruction call
    call = InstrCall('smem', 's_atc_probe_buffer', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(probe, sbase, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_add(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_add
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_add', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_add', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_add', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_add', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_add', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_add_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_add_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_add_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_add_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_add_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_add_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_add_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_and(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_and
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_and', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_and', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_and', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_and', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_and', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_and_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_and_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_and_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_and_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_and_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_and_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_and_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_cmpswap(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_cmpswap
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:b32x2/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_cmpswap', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_cmpswap', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_cmpswap', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_cmpswap', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_cmpswap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_cmpswap_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_cmpswap_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-2*/:dst/*synid-gfx9-dst*/:b64x2/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_2('smem', 's_atomic_cmpswap_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_cmpswap_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_cmpswap_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_cmpswap_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_cmpswap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_dec(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_dec
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_dec', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_dec', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_dec', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_dec', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_dec', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_dec_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_dec_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_dec_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_dec_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_dec_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_dec_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_dec_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_inc(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_inc
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_inc', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_inc', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_inc', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_inc', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_inc', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_inc_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_inc_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_inc_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_inc_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_inc_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_inc_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_inc_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_or(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_or
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_or', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_or', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_or', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_or', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_or', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_or_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_or_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_or_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_or_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_or_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_or_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_or_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_smax(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_smax
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:i32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_smax', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_smax', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_smax', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_smax', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_smax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_smax_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_smax_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:i64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_smax_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_smax_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_smax_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_smax_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_smax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_smin(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_smin
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:i32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_smin', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_smin', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_smin', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_smin', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_smin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_smin_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_smin_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:i64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_smin_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_smin_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_smin_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_smin_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_smin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_sub(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_sub
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_sub', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_sub', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_sub', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_sub', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_sub', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_sub_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_sub_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_sub_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_sub_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_sub_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_sub_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_sub_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_swap(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_swap
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_swap', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_swap', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_swap', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_swap', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_swap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_swap_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_swap_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_swap_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_swap_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_swap_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_swap_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_swap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_umax(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_umax
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_umax', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_umax', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_umax', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_umax', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_umax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_umax_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_umax_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_umax_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_umax_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_umax_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_umax_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_umax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_umin(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_umin
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_umin', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_umin', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_umin', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_umin', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_umin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_umin_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_umin_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_umin_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_umin_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_umin_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_umin_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_umin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_xor(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_xor
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_atomic_xor', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_xor', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_xor', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_xor', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_xor', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_atomic_xor_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_atomic_xor_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_atomic_xor_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_atomic_xor_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_atomic_xor_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_atomic_xor_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_atomic_xor_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_add(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_add
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_add', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_add', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_add', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_add', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_add', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_add_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_add_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_add_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_add_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_add_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_add_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_add_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_and(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_and
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_and', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_and', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_and', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_and', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_and', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_and_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_and_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_and_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_and_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_and_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_and_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_and_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_cmpswap(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_cmpswap
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:b32x2/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_cmpswap', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_cmpswap', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_cmpswap', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_cmpswap', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_cmpswap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_cmpswap_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_cmpswap_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-2*/:dst/*synid-gfx9-dst*/:b64x2/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_2('smem', 's_buffer_atomic_cmpswap_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_cmpswap_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_cmpswap_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_cmpswap_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_cmpswap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_dec(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_dec
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_dec', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_dec', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_dec', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_dec', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_dec', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_dec_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_dec_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_dec_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_dec_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_dec_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_dec_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_dec_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_inc(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_inc
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_inc', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_inc', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_inc', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_inc', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_inc', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_inc_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_inc_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_inc_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_inc_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_inc_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_inc_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_inc_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_or(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_or
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_or', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_or', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_or', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_or', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_or', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_or_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_or_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_or_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_or_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_or_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_or_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_or_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_smax(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_smax
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:i32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_smax', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_smax', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_smax', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_smax', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_smax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_smax_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_smax_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:i64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_smax_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_smax_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_smax_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_smax_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_smax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_smin(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_smin
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:i32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_smin', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_smin', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_smin', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_smin', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_smin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_smin_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_smin_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:i64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_smin_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_smin_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_smin_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_smin_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_smin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_sub(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_sub
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_sub', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_sub', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_sub', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_sub', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_sub', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_sub_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_sub_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_sub_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_sub_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_sub_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_sub_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_sub_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_swap(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_swap
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_swap', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_swap', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_swap', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_swap', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_swap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_swap_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_swap_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_swap_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_swap_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_swap_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_swap_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_swap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_umax(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_umax
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_umax', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_umax', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_umax', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_umax', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_umax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_umax_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_umax_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_umax_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_umax_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_umax_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_umax_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_umax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_umin(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_umin
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_umin', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_umin', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_umin', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_umin', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_umin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_umin_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_umin_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_umin_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_umin_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_umin_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_umin_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_umin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_xor(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_xor
    Operands:
        src0: sdata/*synid-gfx9-sdata*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata('smem', 's_buffer_atomic_xor', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_xor', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_xor', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_xor', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_xor', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_atomic_xor_x2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_atomic_xor_x2
    Operands:
        src0: sdata/*synid-gfx9-sdata-1*/:dst/*synid-gfx9-dst*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_1('smem', 's_buffer_atomic_xor_x2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_atomic_xor_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_atomic_xor_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_atomic_xor_x2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(sdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_atomic_xor_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)
    if glc:
        call.add_gpr_holds(sdata)
        call.add_gpr_defs(sdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_load_dword(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_load_dword
    Operands:
        dst: sdst/*synid-gfx9-sdst*/
        src0: sbase/*synid-gfx9-sbase-1*/
        src1: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst('smem', 's_buffer_load_dword', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_load_dword', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_load_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_load_dword', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_load_dwordx16(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_load_dwordx16
    Operands:
        dst: sdst/*synid-gfx9-sdst-1*/
        src0: sbase/*synid-gfx9-sbase-1*/
        src1: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_1('smem', 's_buffer_load_dwordx16', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_load_dwordx16', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_load_dwordx16', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_load_dwordx16', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_load_dwordx16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_load_dwordx2(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_load_dwordx2
    Operands:
        dst: sdst/*synid-gfx9-sdst-2*/
        src0: sbase/*synid-gfx9-sbase-1*/
        src1: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_2('smem', 's_buffer_load_dwordx2', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_load_dwordx2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_load_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_load_dwordx2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_load_dwordx4(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_load_dwordx4
    Operands:
        dst: sdst/*synid-gfx9-sdst-3*/
        src0: sbase/*synid-gfx9-sbase-1*/
        src1: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_3('smem', 's_buffer_load_dwordx4', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_load_dwordx4', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_load_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_load_dwordx4', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_load_dwordx8(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_load_dwordx8
    Operands:
        dst: sdst/*synid-gfx9-sdst-4*/
        src0: sbase/*synid-gfx9-sbase-1*/
        src1: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_4('smem', 's_buffer_load_dwordx8', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_load_dwordx8', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_load_dwordx8', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_load_dwordx8', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_load_dwordx8', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_store_dword(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_store_dword
    Operands:
        src0: sdata/*synid-gfx9-sdata-3*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_3('smem', 's_buffer_store_dword', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_store_dword', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_store_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_store_dword', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_store_dwordx2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_store_dwordx2
    Operands:
        src0: sdata/*synid-gfx9-sdata-4*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_4('smem', 's_buffer_store_dwordx2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_store_dwordx2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_store_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_store_dwordx2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_buffer_store_dwordx4(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_buffer_store_dwordx4
    Operands:
        src0: sdata/*synid-gfx9-sdata-5*/
        src1: sbase/*synid-gfx9-sbase-1*/
        src2: soffset/*synid-gfx9-soffset-2*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_5('smem', 's_buffer_store_dwordx4', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_1('smem', 's_buffer_store_dwordx4', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_2('smem', 's_buffer_store_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_buffer_store_dwordx4', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_buffer_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_dcache_discard(sbase, soffset, /, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_dcache_discard
    Operands:
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {'sbase': sbase, 'soffset': soffset}
    modifiers = {}

    # Operands validation
    validate_operand_synid_gfx9_sbase('smem', 's_dcache_discard', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_dcache_discard', operands, modifiers, 'soffset', soffset)

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_dcache_discard', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_dcache_discard_x2(sbase, soffset, /, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_dcache_discard_x2
    Operands:
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {'sbase': sbase, 'soffset': soffset}
    modifiers = {}

    # Operands validation
    validate_operand_synid_gfx9_sbase('smem', 's_dcache_discard_x2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_dcache_discard_x2', operands, modifiers, 'soffset', soffset)

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_dcache_discard_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_dcache_inv(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_dcache_inv
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_dcache_inv', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_dcache_inv_vol(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_dcache_inv_vol
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_dcache_inv_vol', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_dcache_wb(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_dcache_wb
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_dcache_wb', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_dcache_wb_vol(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_dcache_wb_vol
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_dcache_wb_vol', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_load_dword(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_load_dword
    Operands:
        dst: sdst/*synid-gfx9-sdst*/
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst('smem', 's_load_dword', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase('smem', 's_load_dword', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_load_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_load_dword', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_load_dwordx16(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_load_dwordx16
    Operands:
        dst: sdst/*synid-gfx9-sdst-1*/
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_1('smem', 's_load_dwordx16', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase('smem', 's_load_dwordx16', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_load_dwordx16', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_load_dwordx16', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_load_dwordx16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_load_dwordx2(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_load_dwordx2
    Operands:
        dst: sdst/*synid-gfx9-sdst-2*/
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_2('smem', 's_load_dwordx2', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase('smem', 's_load_dwordx2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_load_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_load_dwordx2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_load_dwordx4(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_load_dwordx4
    Operands:
        dst: sdst/*synid-gfx9-sdst-3*/
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_3('smem', 's_load_dwordx4', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase('smem', 's_load_dwordx4', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_load_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_load_dwordx4', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_load_dwordx8(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_load_dwordx8
    Operands:
        dst: sdst/*synid-gfx9-sdst-4*/
        src0: sbase/*synid-gfx9-sbase*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_4('smem', 's_load_dwordx8', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase('smem', 's_load_dwordx8', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_load_dwordx8', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_load_dwordx8', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_load_dwordx8', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_memrealtime(sdst, /, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_memrealtime
    Operands:
        dst: sdst/*synid-gfx9-sdst-2*/:b64/*synid-gfx9-type-deviation*/
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst}
    modifiers = {}

    # Operands validation
    validate_operand_synid_gfx9_sdst_2('smem', 's_memrealtime', operands, modifiers, 'sdst', sdst)

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_memrealtime', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_memtime(sdst, /, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_memtime
    Operands:
        dst: sdst/*synid-gfx9-sdst-2*/:b64/*synid-gfx9-type-deviation*/
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst}
    modifiers = {}

    # Operands validation
    validate_operand_synid_gfx9_sdst_2('smem', 's_memtime', operands, modifiers, 'sdst', sdst)

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_memtime', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_scratch_load_dword(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_scratch_load_dword
    Operands:
        dst: sdst/*synid-gfx9-sdst*/
        src0: sbase/*synid-gfx9-sbase-2*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst('smem', 's_scratch_load_dword', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_2('smem', 's_scratch_load_dword', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_scratch_load_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_scratch_load_dword', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_scratch_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(flat_scratch, sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_scratch_load_dwordx2(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_scratch_load_dwordx2
    Operands:
        dst: sdst/*synid-gfx9-sdst-2*/
        src0: sbase/*synid-gfx9-sbase-2*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_2('smem', 's_scratch_load_dwordx2', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_2('smem', 's_scratch_load_dwordx2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_scratch_load_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_scratch_load_dwordx2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_scratch_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(flat_scratch, sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_scratch_load_dwordx4(sdst, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_scratch_load_dwordx4
    Operands:
        dst: sdst/*synid-gfx9-sdst-3*/
        src0: sbase/*synid-gfx9-sbase-2*/
        src1: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdst': sdst, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdst_3('smem', 's_scratch_load_dwordx4', operands, modifiers, 'sdst', sdst)
    validate_operand_synid_gfx9_sbase_2('smem', 's_scratch_load_dwordx4', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_scratch_load_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_scratch_load_dwordx4', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {sdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_scratch_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(flat_scratch, sbase, soffset)
    call.add_gpr_defs(sdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_scratch_store_dword(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_scratch_store_dword
    Operands:
        src0: sdata/*synid-gfx9-sdata-3*/
        src1: sbase/*synid-gfx9-sbase-2*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_3('smem', 's_scratch_store_dword', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_2('smem', 's_scratch_store_dword', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_scratch_store_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_scratch_store_dword', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_scratch_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(flat_scratch, sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_scratch_store_dwordx2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_scratch_store_dwordx2
    Operands:
        src0: sdata/*synid-gfx9-sdata-4*/
        src1: sbase/*synid-gfx9-sbase-2*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_4('smem', 's_scratch_store_dwordx2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_2('smem', 's_scratch_store_dwordx2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_scratch_store_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_scratch_store_dwordx2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_scratch_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(flat_scratch, sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_scratch_store_dwordx4(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_scratch_store_dwordx4
    Operands:
        src0: sdata/*synid-gfx9-sdata-5*/
        src1: sbase/*synid-gfx9-sbase-2*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_5('smem', 's_scratch_store_dwordx4', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase_2('smem', 's_scratch_store_dwordx4', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_scratch_store_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_scratch_store_dwordx4', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_scratch_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(flat_scratch, sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_store_dword(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_store_dword
    Operands:
        src0: sdata/*synid-gfx9-sdata-3*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_3('smem', 's_store_dword', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_store_dword', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_store_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_store_dword', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_store_dwordx2(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_store_dwordx2
    Operands:
        src0: sdata/*synid-gfx9-sdata-4*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_4('smem', 's_store_dwordx2', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_store_dwordx2', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_store_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_store_dwordx2', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def s_store_dwordx4(sdata, sbase, soffset, /, glc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: s_store_dwordx4
    Operands:
        src0: sdata/*synid-gfx9-sdata-5*/
        src1: sbase/*synid-gfx9-sbase*/
        src2: soffset/*synid-gfx9-soffset-1*/
    Modifiers:
        glc/*synid-glc*/
    """
    # Prepare for a new instruction call
    operands = {'sdata': sdata, 'sbase': sbase, 'soffset': soffset}
    modifiers = {'glc': glc}

    # Operands validation
    validate_operand_synid_gfx9_sdata_5('smem', 's_store_dwordx4', operands, modifiers, 'sdata', sdata)
    validate_operand_synid_gfx9_sbase('smem', 's_store_dwordx4', operands, modifiers, 'sbase', sbase)
    validate_operand_synid_gfx9_soffset_1('smem', 's_store_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_glc('smem', 's_store_dwordx4', operands, modifiers, 'glc', glc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_scalar': 2}  # type: Dict[str, int]
    store_mem_from_gprs = {sdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('smem', 's_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(sbase, sdata, soffset)

    # Add instruction call to current block
    call.add_to_current_block()


