"""
THIS FILE IS AUTO GENERATED.
ANY MODIFICATION WILL BE LOST AFTER REGENERATION.
"""

# flake8: noqa

# noinspection PyUnresolvedReferences
from typing import Optional, Hashable, Dict, Set
# noinspection PyUnresolvedReferences
from .autogen_validate_operands import *
# noinspection PyUnresolvedReferences
from .autogen_validate_modifiers import *
# noinspection PyUnresolvedReferences
from ...basic.instr import InstrCall, MemToken, SrcLoc


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_add(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_add
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_add', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_add', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_add', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_add', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_add', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_add', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_add', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_add', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_add', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_add', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_add_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_add_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_add_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_add_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_and(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_and
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_and', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_and', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_and', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_and', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_and', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_and', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_and', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_and', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_and', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_and', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_and_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_and_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_and_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_and_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_cmpswap(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_cmpswap
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:b32x2/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_cmpswap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_cmpswap_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_cmpswap_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-10*/:dst/*synid-gfx9-dst*/:b64x2/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_10('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_cmpswap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_dec(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_dec
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_dec', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_dec', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_dec', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_dec', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_dec', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_dec', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_dec', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_dec', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_dec', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_dec', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_dec_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_dec_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_dec_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_inc(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_inc
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_inc', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_inc', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_inc', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_inc', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_inc', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_inc', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_inc', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_inc', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_inc', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_inc', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_inc_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_inc_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_inc_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_or(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_or
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_or', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_or', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_or', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_or', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_or', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_or', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_or', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_or', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_or', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_or', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_or_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_or_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_or_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_or_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_smax(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_smax
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/:i32/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_smax', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_smax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_smax', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_smax', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_smax', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_smax', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_smax', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_smax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_smax', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_smax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_smax_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_smax_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:i64/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_smax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_smin(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_smin
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/:i32/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_smin', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_smin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_smin', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_smin', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_smin', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_smin', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_smin', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_smin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_smin', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_smin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_smin_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_smin_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:i64/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_smin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_sub(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_sub
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_sub', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_sub', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_sub', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_sub', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_sub', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_sub', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_sub', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_sub', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_sub', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_sub', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_sub_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_sub_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_sub_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_swap(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_swap
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_swap', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_swap', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_swap', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_swap', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_swap', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_swap', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_swap', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_swap', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_swap', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_swap', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_swap_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_swap_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_swap_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_umax(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_umax
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_umax', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_umax', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_umax', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_umax', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_umax', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_umax', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_umax', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_umax', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_umax', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_umax', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_umax_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_umax_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_umax_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_umin(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_umin
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/:u32/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_umin', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_umin', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_umin', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_umin', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_umin', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_umin', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_umin', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_umin', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_umin', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_umin', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_umin_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_umin_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/:u64/*synid-gfx9-type-deviation*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_umin_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_xor(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_xor
    Operands:
        src0: vdata/*synid-gfx9-vdata-8*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_8('mubuf', 'buffer_atomic_xor', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_xor', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_xor', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_xor', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_xor', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_xor', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_xor', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_xor', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_xor', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_xor', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_atomic_xor_x2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_atomic_xor_x2
    Operands:
        src0: vdata/*synid-gfx9-vdata-9*/:dst/*synid-gfx9-dst*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_9('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    if glc:
        load_mem_to_gprs.add(vdata)
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_atomic_xor_x2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)
    if glc:
        call.add_gpr_holds(vdata)
        call.add_gpr_defs(vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_dword(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_dword
    Operands:
        dst: vdst/*synid-gfx9-vdst-13*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_13('mubuf', 'buffer_load_dword', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_dword', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_dword', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_dword', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_dword', operands, modifiers, 'slc', slc)
    validate_modifier_synid_lds('mubuf', 'buffer_load_dword', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_dwordx2(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_dwordx2
    Operands:
        dst: vdst/*synid-gfx9-vdst-10*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_10('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_dwordx3(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_dwordx3
    Operands:
        dst: vdst/*synid-gfx9-vdst-11*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_11('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_dwordx4(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_dwordx4
    Operands:
        dst: vdst/*synid-gfx9-vdst-12*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_12('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_d16_hi_x(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_d16_hi_x
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_d16_hi_x', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_d16_x(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_d16_x
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_d16_x', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_d16_x', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_d16_xy(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_d16_xy
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_d16_xy', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_d16_xyz(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_d16_xyz
    Operands:
        dst: vdst/*synid-gfx9-vdst-10*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_10('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_d16_xyz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_d16_xyzw(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_d16_xyzw
    Operands:
        dst: vdst/*synid-gfx9-vdst-10*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_10('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_d16_xyzw', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_x(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_x
    Operands:
        dst: vdst/*synid-gfx9-vdst-13*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_13('mubuf', 'buffer_load_format_x', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_x', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_x', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_x', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_x', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_x', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_x', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_x', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_x', operands, modifiers, 'slc', slc)
    validate_modifier_synid_lds('mubuf', 'buffer_load_format_x', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_x', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_xy(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_xy
    Operands:
        dst: vdst/*synid-gfx9-vdst-10*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_10('mubuf', 'buffer_load_format_xy', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_xy', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_xy', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_xy', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_xy', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_xy', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_xy', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_xy', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_xy', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_xy', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_xyz(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_xyz
    Operands:
        dst: vdst/*synid-gfx9-vdst-11*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_11('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_xyz', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_xyz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_format_xyzw(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_format_xyzw
    Operands:
        dst: vdst/*synid-gfx9-vdst-12*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_12('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_format_xyzw', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_format_xyzw', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_sbyte(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_sbyte
    Operands:
        dst: vdst/*synid-gfx9-vdst-13*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_13('mubuf', 'buffer_load_sbyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_sbyte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_sbyte', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_sbyte', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_sbyte', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_sbyte', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_sbyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_sbyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_sbyte', operands, modifiers, 'slc', slc)
    validate_modifier_synid_lds('mubuf', 'buffer_load_sbyte', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_sbyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_sbyte_d16(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_sbyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_sbyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_sbyte_d16_hi(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_sbyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_sbyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_short_d16(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_short_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_short_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_short_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_short_d16', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_short_d16', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_short_d16', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_short_d16', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_short_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_short_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_short_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_short_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_short_d16_hi(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_short_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_sshort(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_sshort
    Operands:
        dst: vdst/*synid-gfx9-vdst-13*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_13('mubuf', 'buffer_load_sshort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_sshort', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_sshort', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_sshort', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_sshort', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_sshort', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_sshort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_sshort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_sshort', operands, modifiers, 'slc', slc)
    validate_modifier_synid_lds('mubuf', 'buffer_load_sshort', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_sshort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_ubyte(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_ubyte
    Operands:
        dst: vdst/*synid-gfx9-vdst-13*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_13('mubuf', 'buffer_load_ubyte', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_ubyte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_ubyte', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_ubyte', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_ubyte', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_ubyte', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_ubyte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_ubyte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_ubyte', operands, modifiers, 'slc', slc)
    validate_modifier_synid_lds('mubuf', 'buffer_load_ubyte', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_ubyte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_ubyte_d16(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_ubyte_d16
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_ubyte_d16', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_ubyte_d16_hi(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_ubyte_d16_hi
    Operands:
        dst: vdst/*synid-gfx9-vdst-9*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdst_9('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_ubyte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_load_ushort(vdst, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_load_ushort
    Operands:
        dst: vdst/*synid-gfx9-vdst-13*/
        src0: vaddr/*synid-gfx9-vaddr-5*/
        src1: srsrc/*synid-gfx9-srsrc-1*/
        src2: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'vdst': vdst, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_vdst_13('mubuf', 'buffer_load_ushort', operands, modifiers, 'vdst', vdst)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_load_ushort', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_load_ushort', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_load_ushort', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_load_ushort', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_load_ushort', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_load_ushort', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_load_ushort', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_load_ushort', operands, modifiers, 'slc', slc)
    validate_modifier_synid_lds('mubuf', 'buffer_load_ushort', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = {vdst}  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_load_ushort', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr)
    call.add_gpr_defs(vdst)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_byte(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_byte
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_byte', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_byte', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_byte', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_byte', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_byte', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_byte', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_byte', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_byte', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_byte', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_byte', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_byte_d16_hi(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_byte_d16_hi
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_byte_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_dword(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_dword
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_dword', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_dword', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_dword', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_dword', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_dword', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_dword', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_dword', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_dwordx2(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_dwordx2
    Operands:
        src0: vdata/*synid-gfx9-vdata-1*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_1('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_dwordx2', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_dwordx2', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_dwordx3(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_dwordx3
    Operands:
        src0: vdata/*synid-gfx9-vdata-3*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_3('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_dwordx3', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_dwordx3', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_dwordx4(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_dwordx4
    Operands:
        src0: vdata/*synid-gfx9-vdata-2*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_2('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_dwordx4', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_dwordx4', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_d16_hi_x(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_d16_hi_x
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_d16_hi_x', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_d16_x(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_d16_x
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_d16_x', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_d16_x', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_d16_xy(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_d16_xy
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_d16_xy', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_d16_xyz(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_d16_xyz
    Operands:
        src0: vdata/*synid-gfx9-vdata-1*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_1('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_d16_xyz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_d16_xyzw(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_d16_xyzw
    Operands:
        src0: vdata/*synid-gfx9-vdata-1*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_1('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_d16_xyzw', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_x(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_x
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_format_x', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_x', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_x', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_x', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_x', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_x', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_x', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_x', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_x', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_x', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_xy(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_xy
    Operands:
        src0: vdata/*synid-gfx9-vdata-1*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_1('mubuf', 'buffer_store_format_xy', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_xy', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_xy', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_xy', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_xy', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_xy', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_xy', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_xy', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_xy', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_xy', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_xyz(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_xyz
    Operands:
        src0: vdata/*synid-gfx9-vdata-3*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_3('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_xyz', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_xyz', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_format_xyzw(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_format_xyzw
    Operands:
        src0: vdata/*synid-gfx9-vdata-2*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata_2('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_format_xyzw', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_format_xyzw', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_lds_dword(srsrc, soffset, /, offset=None, lds=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_lds_dword
    Operands:
        src0: srsrc/*synid-gfx9-srsrc-1*/
        src1: soffset/*synid-gfx9-soffset*/
    Modifiers:
        offset/*synid-buf-offset12*/
        lds/*synid-lds*/
    """
    # Prepare for a new instruction call
    operands = {'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'offset': offset, 'lds': lds}

    # Operands validation
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_lds_dword', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_lds_dword', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_lds_dword', operands, modifiers, 'offset', offset)
    validate_modifier_synid_lds('mubuf', 'buffer_store_lds_dword', operands, modifiers, 'lds', lds)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_lds_dword', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc)
    if lds:
        call.add_gpr_uses(m0)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_short(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_short
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_short', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_short', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_short', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_short', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_short', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_short', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_short', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_short', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_short', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_short', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_store_short_d16_hi(vdata, vaddr, srsrc, soffset, /, idxen=None, offen=None, offset=None, glc=None, slc=None, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_store_short_d16_hi
    Operands:
        src0: vdata/*synid-gfx9-vdata*/
        src1: vaddr/*synid-gfx9-vaddr-5*/
        src2: srsrc/*synid-gfx9-srsrc-1*/
        src3: soffset/*synid-gfx9-soffset*/
    Modifiers:
        idxen/*synid-idxen*/
        offen/*synid-offen*/
        offset/*synid-buf-offset12*/
        glc/*synid-glc*/
        slc/*synid-slc*/
    """
    # Prepare for a new instruction call
    operands = {'vdata': vdata, 'vaddr': vaddr, 'srsrc': srsrc, 'soffset': soffset}
    modifiers = {'idxen': idxen, 'offen': offen, 'offset': offset, 'glc': glc, 'slc': slc}

    # Operands validation
    validate_operand_synid_gfx9_vdata('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'vdata', vdata)
    validate_operand_synid_gfx9_vaddr_5('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'vaddr', vaddr)
    validate_operand_synid_gfx9_srsrc_1('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'srsrc', srsrc)
    validate_operand_synid_gfx9_soffset('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'soffset', soffset)

    # Modifiers validation
    validate_modifier_synid_idxen('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'idxen', idxen)
    validate_modifier_synid_offen('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'offen', offen)
    validate_modifier_synid_buf_offset12('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'offset', offset)
    validate_modifier_synid_glc('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'glc', glc)
    validate_modifier_synid_slc('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, 'slc', slc)

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = {vdata}  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_store_short_d16_hi', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec, soffset, srsrc, vaddr, vdata)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_wbinvl1(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_wbinvl1
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_wbinvl1', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)

    # Add instruction call to current block
    call.add_to_current_block()


# noinspection DuplicatedCode,PyDictCreation
def buffer_wbinvl1_vol(*, mem_token_object: Optional[Hashable] = None, comment: str = None, srcloc: Optional[SrcLoc] = None):
    """
    Instruction: buffer_wbinvl1_vol
    Operands: -
    Modifiers: -
    """
    # Prepare for a new instruction call
    operands = {}
    modifiers = {}

    # No operands to validate

    # No modifiers to validate

    # Generate the source location
    if srcloc is None:
        srcloc = SrcLoc.get_caller_srcloc()

    # Generate memory token
    inc_waitcnt = {'inc_vector': 1}  # type: Dict[str, int]
    store_mem_from_gprs = set()  # type: Set[Gpr]
    load_mem_to_gprs = set()  # type: Set[Gpr]
    mem_token = MemToken(mem_token_object, store_mem_from_gprs, load_mem_to_gprs, srcloc, **inc_waitcnt)  # mem_token_object might be None

    # Generate the instruction call
    call = InstrCall('mubuf', 'buffer_wbinvl1_vol', operands, modifiers, mem_token, comment, srcloc)

    # Do we use/hold/define any Gpr
    call.add_gpr_uses(exec)

    # Add instruction call to current block
    call.add_to_current_block()


