# YOLOv5_L

## 项目简介

YOLOv5 是一种目标检测算法，采用单阶段（one-stage）的方法，基于轻量级的卷积神经网络结构，通过引入不同尺度的特征融合和特征金字塔结构来实现高效准确的目标检测。

---

## 环境部署

### 1. 拉取镜像

```bash
docker pull image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.10
```

### 2. 创建容器

```bash
docker run -it \
--network=host \
--hostname=localhost \
--name=yolov5 \
-v /opt/hyhal:/opt/hyhal:ro \
-v $PWD:/workspace \
--ipc=host \
--device=/dev/kfd \
--device=/dev/mkfd \
--device=/dev/dri \
--shm-size=512G \
--privileged \
--group-add video \
--cap-add=SYS_PTRACE \
-u root \
--security-opt seccomp=unconfined \
image.sourcefind.cn:5000/dcu/admin/base/pytorch:2.4.1-ubuntu22.04-dtk25.04.1-py3.10 \
/bin/bash
```

---

## 测试步骤

### 1. 拉取代码

```bash
git clone http://developer.sourcefind.cn/codes/bw-bestperf/yolov5_l.git
cd yolov5_l
```

### 2. 安装依赖

```bash
pip install -r requirements.txt -i https://mirrors.tuna.tsinghua.edu.cn/pypi/web/simple
cp Arial.ttf /root/.config/Ultralytics/Arial.ttf
```

### 3. 下载模型

下载所需模型：

```bash
wget https://github.com/ultralytics/yolov5/releases/download/v7.0/yolov5l.pt
```

### 4. 下载数据集

数据集地址：https://www.modelscope.cn/datasets/PAI/COCO2017/

数据集目录结构如下：
```bash
coco2017
├── images 
│   ├── train2017
│   ├── val2017
│   ├── test2017
├── labels
│   ├── train2017
│   ├── val2017
├── annotations
│   ├── instances_val2017.json
├── test-dev2017.txt
├── train2017.txt
├── val2017.txt
├── ...

```

修改测试配置中的数据集路径

```bash
vim data/coco.yaml # 修改 path: /path/coco2017/
```

---

## 测试代码示例（单卡测试）

单卡训练

```bash
HIP_VISIBLE_DEVICES=0 python train.py --data data/coco.yaml --epochs 5 --weights yolov5l.pt --batch-size 64 --img 640
```

---

## 配置选项说明

| 参数                 | 说明                           | 默认值 / 示例                             |
| -------------------- | ------------------------------ | ---------------------------------------- |
| `--data`            | 指定数据集的配置文件           | `data/coco.yaml`                            |
| `--epochs`           | 训练轮次                       | `5`                                       |
| `--weights`   | 指定加载的预训练权重                   | `yolov5l.pt`          |
| `--batch-size`   | 每一个batch送入训练的图像数量                 | `64`                                  |
| `--img`    | 输入图像的分辨率                 | `640`                                  |

---

## 贡献指南

欢迎对 YOLOv5_L 项目进行贡献！请遵循以下步骤：

1. Fork 本仓库，并新建分支进行功能开发或问题修复。
2. 提交规范的 commit 信息，描述清晰。
3. 提交 Pull Request，简述修改内容及目的。
4. 遵守项目代码规范和测试标准。
5. 参与代码评审，积极沟通改进方案。

---

## 许可证

本项目遵循 MIT 许可证，详见 [LICENSE](./LICENSE) 文件。

---

感谢您的关注与支持！如有问题，欢迎提交 Issue 或联系维护团队。
