#!/bin/bash
# Wan2.1 I2V 480P INT8-VLLM - 8 GPUs with Ulysses + CFG Parallelism
export PLATFORM=hygon_dcu
# export PYTHONPATH=/data/sensetime/fhw/LightX2V:/opt/venv/lib/python3.10/site-packages/:$PYTHONPATH

# Set paths
lightx2v_path=/workspace/LightX2V
model_path=/panhb/workspace/isv/shangtang/models/

# Set HIP devices for 8 GPUs
export HIP_VISIBLE_DEVICES=0,1,2,3,4,5,6,7

# Set environment variables
source ${lightx2v_path}/scripts/base/base.sh

# Use torchrun for distributed inference
# python -X faulthandler -m torch.distributed.run --nproc_per_node=8 -m lightx2v.infer \
torchrun --nproc_per_node=8 -m lightx2v.infer \
--model_cls wan2.1 \
--task i2v \
--model_path $model_path \
--config_json ${lightx2v_path}/configs/dcu/quant/vllm/wan_i2v_480p_int8_vllm_8gpu.json \
--prompt "Summer beach vacation style, a white cat wearing sunglasses sits on a surfboard. The fluffy-furred feline gazes directly at the camera with a relaxed expression. Blurred beach scenery forms the background featuring crystal-clear waters, distant green hills, and a blue sky dotted with white clouds. The cat assumes a naturally relaxed posture, as if savoring the sea breeze and warm sunlight. A close-up shot highlights the feline's intricate details and the refreshing atmosphere of the seaside." \
--negative_prompt "镜头晃动，色调艳丽，过曝，静态，细节模糊不清，字幕，风格，作品，画作，画面，静止，整体发灰，最差质量，低质量，JPEG压缩残留，丑陋的，残缺的，多余的手指，画得不好的手部，画得
不好的脸部，畸形的，毁容的，形态畸形的肢体，手指融合，静止不动的画面，杂乱的背景，三条腿，背景人很多，倒着走" \
--image_path ${lightx2v_path}/assets/inputs/imgs/img_0.jpg \
--save_result_path ${lightx2v_path}/save_results/phb/output_lightx2v_wan_i2v_480p_int8_8gpu_test_0129.mp4

